import 'dart:io';

import 'package:connectivity_plus/connectivity_plus.dart';
import 'package:dotted_line/dotted_line.dart';
import 'package:flutter/material.dart';
import 'package:flutter_svg/svg.dart';
import 'package:generp/Notifiers/GeneratorDetailsProvider.dart';
import 'package:generp/screens/genTracker/ComplaintHistory.dart';
import 'package:provider/provider.dart';
import 'package:url_launcher/url_launcher.dart';

import '../../Notifiers/HomeScreenNotifier.dart';
import '../../Utils/app_colors.dart';
import '../../Utils/commonServices.dart';
import '../../Utils/commonWidgets.dart';
import 'ScanEnterGeneratorIDScreen.dart';

class Generatordetails extends StatefulWidget {
  final activityName;
  final genLocation;
  final generatorId;

  const Generatordetails({
    super.key,
    this.activityName,
    this.genLocation,
    required this.generatorId,
  });

  @override
  State<Generatordetails> createState() => _GeneratordetailsState();
}

class _GeneratordetailsState extends State<Generatordetails> {
  Map _source = {ConnectivityResult.mobile: true};
  final MyConnectivity _connectivity = MyConnectivity.instance;

  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    _connectivity.initialise();
    _connectivity.myStream.listen((source) {
      setState(() => _source = source);
    });
    WidgetsBinding.instance.addPostFrameCallback((_) {
      var details = Provider.of<Generatordetailsprovider>(
        context,
        listen: false,
      );
      var homeProvider = Provider.of<HomescreenNotifier>(
        context,
        listen: false,
      );
      if (widget.activityName == "NearByGenerators") {
        details.LoadTechniciangeneratorDetailsApifunction(
          homeProvider,
          context,
          "",
          widget.generatorId,
        );
      }
      // else {
      //   details.LoadgeneratorDetailsApifunction(
      //     homeProvider,
      //     context,
      //     "",
      //     widget.generatorId,
      //     "3"
      //   );
      // }
    });
  }

  @override
  void dispose() {
    // TODO: implement dispose
    super.dispose();
    _connectivity.disposeStream();
  }

  @override
  Widget build(BuildContext context) {
    switch (_source.keys.toList()[0]) {
      case ConnectivityResult.mobile:
        connection = 'Online';
        break;
      case ConnectivityResult.wifi:
        connection = 'Online';
        break;
      case ConnectivityResult.none:
      default:
        connection = 'Offline';
    }
    return (connection == "Online")
        ? Platform.isAndroid
            ? WillPopScope(
              onWillPop: () async {
                Provider.of<Generatordetailsprovider>(
                  context,
                  listen: false,
                ).resetForm();
                return onBackPressed(context);
              },
              child: SafeArea(
                top: false,
                bottom: true,
                child: _scaffold(context),
              ),
            )
            : _scaffold(context)
        : NoNetwork(context);
  }

  Widget _scaffold(BuildContext context) {
    switch (_source.keys.toList()[0]) {
      case ConnectivityResult.mobile:
        connection = 'Online';
        break;
      case ConnectivityResult.wifi:
        connection = 'Online';
        break;
      case ConnectivityResult.none:
      default:
        connection = 'Offline';
    }
    return Consumer2<Generatordetailsprovider, HomescreenNotifier>(
      builder: (context, provider, Homeprovider, child) {
        print("cojomdspofjfm: ${provider.complaintsList.length}");
        var sendwidget = SizedBox(width: 0);
        return WillPopScope(
          onWillPop: () async {
            return onBackPressed(context);
          },
          child: SafeArea(
            top: false,
            bottom: Platform.isIOS ? false : true,
            child: Scaffold(
              resizeToAvoidBottomInset: true,
              appBar: appbar2New(
                context,
                "Generator Details",
                provider.resetForm,
                sendwidget,
                0xFFFFFFFF,
              ),
              backgroundColor: AppColors.scaffold_bg_color,
              body: Container(
                child: SingleChildScrollView(
                  child: Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      Card(
                        margin: EdgeInsets.symmetric(
                          horizontal: 0,
                          vertical: 2,
                        ),
                        shape: RoundedRectangleBorder(
                          borderRadius: BorderRadius.only(
                            bottomLeft: Radius.circular(30),
                            bottomRight: Radius.circular(30),
                          ),
                        ),
                        elevation: 2,
                        child: Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: [
                            Container(
                              padding: EdgeInsets.symmetric(
                                horizontal: 15,
                                vertical: 5,
                              ),

                              child: Column(
                                children: [
                                  Container(
                                    padding: EdgeInsets.symmetric(
                                      vertical: 3,
                                      horizontal: 0,
                                    ),
                                    child: Row(
                                      children: [
                                        SvgPicture.asset(
                                          "assets/svg/crm/lead_details_ic.svg",
                                        ),
                                        SizedBox(width: 10),

                                        Expanded(
                                          child: Column(
                                            crossAxisAlignment:
                                                CrossAxisAlignment.start,
                                            children: [
                                              Text(
                                                "${provider.aname}",
                                                maxLines: 2,
                                                overflow: TextOverflow.ellipsis,
                                                style: TextStyle(
                                                  fontFamily: "JakartaMedium",
                                                  fontSize: 14,
                                                ),
                                              ),
                                              Text(
                                                "${provider.cname}",
                                                maxLines: 2,
                                                overflow: TextOverflow.ellipsis,
                                                style: TextStyle(
                                                  fontSize: 14,
                                                  color: Color(0xFF818181),
                                                ),
                                              ),
                                            ],
                                          ),
                                        ),
                                      ],
                                    ),
                                  ),
                                ],
                              ),
                            ),

                            Visibility(
                              visible: provider.showMoreDetails ? true : false,
                              child: Container(
                                padding: EdgeInsets.symmetric(
                                  vertical: 10,
                                  horizontal: 10,
                                ),
                                margin: EdgeInsets.symmetric(
                                  vertical: 0,
                                  horizontal: 10,
                                ),
                                decoration: BoxDecoration(
                                  color: AppColors.white,
                                  borderRadius: BorderRadius.circular(16),
                                ),
                                child: Column(
                                  children: [
                                    Container(
                                      padding: EdgeInsets.symmetric(
                                        vertical: 4,
                                      ),
                                      child: Row(
                                        children: [
                                          Expanded(
                                            flex: 3,
                                            child: Text(
                                              "Customer Details",
                                              style: TextStyle(
                                                fontSize: 14,
                                                fontFamily: "JakartaSemiBold",
                                              ),
                                            ),
                                          ),
                                          Expanded(
                                            flex: 6,
                                            child: DottedLine(
                                              dashGapLength: 4,
                                              dashGapColor: Colors.white,
                                              dashColor: AppColors.grey_semi,
                                              dashLength: 2,
                                              lineThickness: 0.5,
                                            ),
                                          ),
                                        ],
                                      ),
                                    ),

                                    Column(
                                      crossAxisAlignment:
                                          CrossAxisAlignment.start,
                                      children: List.generate(4, (j) {
                                        final textheads = [
                                          "Mobile Number",
                                          "Contact Person Number",
                                          "Mail ID",
                                          "Location",
                                        ];
                                        final textSubheads = [
                                          provider.mob1 ?? "-",
                                          provider.mob2 ?? "-",
                                          provider.mail ?? "-",
                                          "View",
                                        ];
                                        return Container(
                                          padding: EdgeInsets.symmetric(
                                            vertical: 6,
                                            horizontal: 0,
                                          ),
                                          child: Row(
                                            children: [
                                              Expanded(
                                                flex: 1,
                                                child: SizedBox(
                                                  child: Text(
                                                    textheads[j].toString(),
                                                    maxLines: 2,
                                                    overflow:
                                                        TextOverflow.ellipsis,
                                                    style: TextStyle(
                                                      fontFamily:
                                                          "JakartaRegular",
                                                      fontSize: 14,
                                                    ),
                                                  ),
                                                ),
                                              ),
                                              SizedBox(width: 5),
                                              if (textSubheads[j] ==
                                                  "View") ...[
                                                Expanded(
                                                  flex: 2,
                                                  child: Container(
                                                    padding: EdgeInsets.only(
                                                      right: 10.0,
                                                    ),
                                                    child: InkWell(
                                                      onTap: () async {
                                                        if (widget
                                                                .genLocation !=
                                                            null) {
                                                          provider.genLocationLatLngs =
                                                              widget.genLocation
                                                                  ?.split(",")
                                                                  .toString();
                                                        } else {
                                                          provider.genLocationLatLngs =
                                                              provider
                                                                  .genLocation
                                                                  ?.split(",")
                                                                  .toString();
                                                        }

                                                        var uri = Uri.parse(
                                                          "google.navigation:q=${provider.genLocationLatLngs![0]},${provider.genLocationLatLngs![1]}&mode=d",
                                                        );
                                                        if (Platform.isIOS) {
                                                          uri = Uri.parse(
                                                            "maps://?q=${provider.genLocationLatLngs![0]},${provider.genLocationLatLngs![1]}&z=10&daddr=${provider.genLocationLatLngs![0]},${provider.genLocationLatLngs![1]}&dirflg=d",
                                                          );
                                                        }
                                                        if (await canLaunch(
                                                          uri.toString(),
                                                        )) {
                                                          await launch(
                                                            uri.toString(),
                                                          );
                                                        } else {
                                                          throw 'Could not launch ${uri.toString()}';
                                                        }
                                                      },
                                                      child: Text(
                                                        textSubheads[j],
                                                        maxLines: 2,
                                                        textAlign:
                                                            TextAlign.right,
                                                        overflow:
                                                            TextOverflow
                                                                .ellipsis,
                                                        style: TextStyle(
                                                          fontSize: 14,
                                                          color:
                                                              AppColors
                                                                  .app_blue,
                                                          decoration:
                                                              TextDecoration
                                                                  .underline,
                                                          decorationColor:
                                                              AppColors
                                                                  .app_blue,
                                                        ),
                                                      ),
                                                    ),
                                                  ),
                                                ),
                                              ] else ...[
                                                Expanded(
                                                  flex: 2,
                                                  child: InkResponse(
                                                    onTap:
                                                        textheads[j] !=
                                                                "Mobile Number"
                                                            ? null
                                                            : () async {
                                                              final Uri
                                                              phoneUri = Uri(
                                                                scheme: 'tel',
                                                                path:
                                                                    provider.mob1 ==
                                                                            ""
                                                                        ? provider
                                                                            .mob2
                                                                        : provider
                                                                            .mob1,
                                                              );

                                                              if (await canLaunchUrl(
                                                                phoneUri,
                                                              )) {
                                                                await launchUrl(
                                                                  phoneUri,
                                                                );
                                                              } else {
                                                                throw 'Could not launch $phoneUri';
                                                              }
                                                            },
                                                    child: SizedBox(
                                                      child: Text(
                                                        textSubheads[j] == ""
                                                            ? "-"
                                                            : textSubheads[j],
                                                        maxLines: 2,
                                                        overflow:
                                                            TextOverflow
                                                                .ellipsis,
                                                        textAlign:
                                                            TextAlign.right,
                                                        style: TextStyle(
                                                          fontSize: 14,
                                                          fontFamily:
                                                              "JakartaRegular",
                                                          color:
                                                              textheads[j] ==
                                                                      "Mobile Number"
                                                                  ? AppColors
                                                                      .app_blue
                                                                  : Color(
                                                                    0xFF818181,
                                                                  ),
                                                          decorationColor:
                                                              textheads[j] ==
                                                                      "Mobile Number"
                                                                  ? AppColors
                                                                      .app_blue
                                                                  : null,
                                                          decoration:
                                                              textheads[j] ==
                                                                      "Mobile Number"
                                                                  ? TextDecoration
                                                                      .underline
                                                                  : null,
                                                        ),
                                                      ),
                                                    ),
                                                  ),
                                                ),
                                              ],
                                            ],
                                          ),
                                        );
                                      }),
                                    ),

                                    Container(
                                      padding: EdgeInsets.symmetric(
                                        vertical: 4,
                                      ),
                                      child: Row(
                                        children: [
                                          Expanded(
                                            flex: 3,
                                            child: Text(
                                              "Generator Details",
                                              style: TextStyle(
                                                fontSize: 14,
                                                fontFamily: "JakartaSemiBold",
                                              ),
                                            ),
                                          ),
                                          Expanded(
                                            flex: 6,
                                            child: DottedLine(
                                              dashGapLength: 4,
                                              dashGapColor: Colors.white,
                                              dashColor: AppColors.grey_semi,
                                              dashLength: 2,
                                              lineThickness: 0.5,
                                            ),
                                          ),
                                        ],
                                      ),
                                    ),
                                    Column(
                                      crossAxisAlignment:
                                          CrossAxisAlignment.start,
                                      children: List.generate(6, (j) {
                                        final textheads = [
                                          "Product Name",
                                          "Gen Hash ID",
                                          "Engine Number",
                                          "Engine Model",
                                          "Address",
                                          "Date Of Supply",
                                        ];
                                        final textSubheads = [
                                          "${provider.spname}",
                                          "${provider.genHashID}",
                                          "${provider.engineNo}",
                                          "${provider.emodel}",
                                          "${provider.address}",
                                          "${provider.dateOfEngineSale}",
                                        ];
                                        return Container(
                                          padding: EdgeInsets.symmetric(
                                            vertical: 6,
                                            horizontal: 0,
                                          ),
                                          child: Row(
                                            crossAxisAlignment:
                                                CrossAxisAlignment.start,
                                            children: [
                                              Expanded(
                                                flex: 1,
                                                child: Text(
                                                  textheads[j].toString(),
                                                  style: TextStyle(
                                                    fontSize: 14,
                                                    fontFamily:
                                                        "JakartaRegular",
                                                  ),
                                                ),
                                              ),
                                              SizedBox(width: 5),
                                              Expanded(
                                                flex: 2,
                                                child: SizedBox(
                                                  child: Text(
                                                    textSubheads[j] == ""
                                                        ? "-"
                                                        : textSubheads[j],
                                                    maxLines: 2,
                                                    textAlign: TextAlign.right,
                                                    overflow:
                                                        TextOverflow.ellipsis,
                                                    style: TextStyle(
                                                      fontSize: 14,
                                                      color:
                                                          AppColors.grey_semi,
                                                      fontFamily:
                                                          "JakartaRegular",
                                                    ),
                                                  ),
                                                ),
                                              ),
                                            ],
                                          ),
                                        );
                                      }),
                                    ),
                                  ],
                                ),
                              ),
                            ),
                            InkResponse(
                              onTap: () async {
                                provider.showMoreDetails =
                                    !provider.showMoreDetails;
                              },
                              child: Container(
                                padding: EdgeInsets.symmetric(vertical: 5),
                                child: Row(
                                  crossAxisAlignment: CrossAxisAlignment.center,
                                  mainAxisAlignment: MainAxisAlignment.center,
                                  children: [
                                    Text(
                                      provider.showMoreDetails
                                          ? "Hide Details"
                                          : "View Details",
                                      style: TextStyle(
                                        fontFamily: "JakartaMedium",
                                        fontSize: 14,
                                        color: AppColors.app_blue,
                                      ),
                                    ),
                                    Transform.flip(
                                      flipY:
                                          provider.showMoreDetails
                                              ? true
                                              : false,
                                      child: SvgPicture.asset(
                                        "assets/svg/arrow_dropdown.svg",
                                        height: 25,
                                        width: 20,
                                        color: AppColors.app_blue,
                                      ),
                                    ),
                                  ],
                                ),
                              ),
                            ),
                          ],
                        ),
                      ),

                      if (provider.contactsList.isNotEmpty) ...[
                        Container(
                          padding: EdgeInsets.symmetric(
                            horizontal: 10,
                            vertical: 5,
                          ),
                          child: Text(
                            "Customer Contact Details",
                            style: TextStyle(
                              color: Color(0xFF818181),
                              fontFamily: "JakartaMedium",
                            ),
                          ),
                        ),
                        ListView.builder(
                          shrinkWrap: true,
                          physics: NeverScrollableScrollPhysics(),
                          itemCount: provider.contactsList.length,
                          itemBuilder: (context, l) {
                            return Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: [
                                Container(
                                  margin: EdgeInsets.symmetric(
                                    horizontal: 10,
                                    vertical: 5,
                                  ),
                                  decoration: BoxDecoration(
                                    color: Colors.white,
                                    borderRadius: BorderRadius.circular(16),
                                  ),
                                  child: Container(
                                    decoration: BoxDecoration(
                                      color: Colors.white,
                                      borderRadius: BorderRadius.circular(14),
                                    ),
                                    padding: EdgeInsets.symmetric(
                                      horizontal: 10,
                                      vertical: 10,
                                    ),
                                    margin: EdgeInsets.symmetric(vertical: 5),

                                    child: Row(
                                      mainAxisAlignment:
                                          MainAxisAlignment.start,
                                      crossAxisAlignment:
                                          CrossAxisAlignment.start,
                                      children: [
                                        Expanded(
                                          flex: 1,
                                          child: SvgPicture.asset(
                                            "assets/svg/crm/contact_details_ic.svg",
                                          ),
                                        ),
                                        SizedBox(width: 10),
                                        Expanded(
                                          flex: 6,
                                          child: SizedBox(
                                            child: Column(
                                              // mainAxisAlignment: MainAxisAlignment.start,
                                              crossAxisAlignment:
                                                  CrossAxisAlignment.start,
                                              mainAxisAlignment:
                                                  MainAxisAlignment.start,
                                              children: [
                                                Row(
                                                  children: [
                                                    Expanded(
                                                      flex: 4,
                                                      child: Text(
                                                        provider
                                                                    .contactsList[l]
                                                                    .name ==
                                                                ""
                                                            ? "-"
                                                            : provider
                                                                    .contactsList[l]
                                                                    .name ??
                                                                "-",
                                                        style: TextStyle(
                                                          fontFamily:
                                                              "JakartaMedium",
                                                          fontSize: 14,
                                                          color:
                                                              AppColors
                                                                  .semi_black,
                                                        ),
                                                      ),
                                                    ),
                                                    Expanded(
                                                      flex: 2,
                                                      child: InkResponse(
                                                        onTap:
                                                            provider
                                                                        .contactsList[l]
                                                                        .mob2 ==
                                                                    ""
                                                                ? null
                                                                : () {
                                                                  launch(
                                                                    'tel://${provider.contactsList[l].mob2}',
                                                                  );
                                                                },
                                                        child: Text(
                                                          textAlign:
                                                              TextAlign.right,
                                                          provider
                                                                      .contactsList[l]
                                                                      .mob2 ==
                                                                  ""
                                                              ? "-"
                                                              : provider
                                                                      .contactsList[l]
                                                                      .mob2 ??
                                                                  "-",
                                                          style: TextStyle(
                                                            height: 1,
                                                            decorationColor:
                                                                AppColors
                                                                    .grey_thick,
                                                            decoration:
                                                                TextDecoration
                                                                    .underline,
                                                            decorationStyle:
                                                                TextDecorationStyle
                                                                    .dotted,
                                                            fontFamily:
                                                                "JakartaMedium",
                                                            fontSize: 14,
                                                            color:
                                                                AppColors
                                                                    .semi_black,
                                                          ),
                                                        ),
                                                      ),
                                                    ),
                                                  ],
                                                ),
                                                Text(
                                                  provider
                                                          .contactsList[l]
                                                          .mail ??
                                                      "-",
                                                  style: TextStyle(
                                                    fontFamily: "JakartaMedium",
                                                    fontSize: 14,
                                                    color: AppColors.grey_semi,
                                                  ),
                                                ),
                                              ],
                                            ),
                                          ),
                                        ),
                                      ],
                                    ),
                                  ),
                                ),
                              ],
                            );
                          },
                        ),
                      ],

                      if (provider.scheduleList.isNotEmpty) ...[
                        Container(
                          padding: EdgeInsets.symmetric(
                            horizontal: 10,
                            vertical: 5,
                          ),
                          child: Text(
                            "Schedule Details",
                            style: TextStyle(
                              color: Color(0xFF818181),
                              fontFamily: "JakartaMedium",
                            ),
                          ),
                        ),
                        SizedBox(
                          width: double.infinity,
                          height: 300,
                          child: ListView.builder(
                            physics: AlwaysScrollableScrollPhysics(),
                            shrinkWrap: true,
                            scrollDirection: Axis.horizontal,
                            padding: EdgeInsets.symmetric(
                              vertical: 10,
                              horizontal: 10,
                            ),
                            itemCount: provider.scheduleList.length,
                            itemBuilder: (context, lp) {
                              return Container(
                                height: 300,
                                width: MediaQuery.of(context).size.width * 0.92,
                                decoration: BoxDecoration(
                                  color: Colors.white,
                                  borderRadius: BorderRadius.circular(14),
                                ),
                                padding: EdgeInsets.symmetric(
                                  horizontal: 10,
                                  vertical: 10,
                                ),
                                margin: EdgeInsets.symmetric(horizontal: 5),

                                child: Column(
                                  children: [
                                    Row(
                                      mainAxisAlignment:
                                          MainAxisAlignment.start,
                                      crossAxisAlignment:
                                          CrossAxisAlignment.start,
                                      children: [
                                        Expanded(
                                          flex: 1,
                                          child: SvgPicture.asset(
                                            "assets/svg/crm/followup_details_ic.svg",
                                          ),
                                        ),
                                        SizedBox(width: 10),
                                        Expanded(
                                          flex: 6,
                                          child: SizedBox(
                                            child: Column(
                                              // mainAxisAlignment: MainAxisAlignment.start,
                                              crossAxisAlignment:
                                                  CrossAxisAlignment.start,
                                              mainAxisAlignment:
                                                  MainAxisAlignment.start,
                                              children: [
                                                Row(
                                                  children: [
                                                    Expanded(
                                                      flex: 4,
                                                      child: Column(
                                                        crossAxisAlignment:
                                                            CrossAxisAlignment
                                                                .start,
                                                        children: [
                                                          Text(
                                                            provider
                                                                    .scheduleList[lp]
                                                                    .complaintCategory ??
                                                                "-",
                                                            style: TextStyle(
                                                              fontFamily:
                                                                  "JakartaMedium",
                                                              fontSize: 14,
                                                              color:
                                                                  AppColors
                                                                      .semi_black,
                                                            ),
                                                          ),
                                                          Text(
                                                            provider
                                                                    .scheduleList[lp]
                                                                    .dueDate ??
                                                                "-",
                                                            style: TextStyle(
                                                              fontFamily:
                                                                  "JakartaMedium",
                                                              fontSize: 14,
                                                              color:
                                                                  AppColors
                                                                      .grey_semi,
                                                            ),
                                                          ),
                                                        ],
                                                      ),
                                                    ),
                                                    Expanded(
                                                      flex: 3,
                                                      child: Container(
                                                        decoration: BoxDecoration(
                                                          borderRadius:
                                                              BorderRadius.circular(
                                                                8,
                                                              ),
                                                          color: Color(
                                                            0xFFF3FFD5,
                                                          ),
                                                        ),
                                                        padding:
                                                            EdgeInsets.symmetric(
                                                              horizontal: 5,
                                                              vertical: 10,
                                                            ),
                                                        child: Text(
                                                          provider
                                                                  .scheduleList[lp]
                                                                  .status ??
                                                              "-",
                                                          textAlign:
                                                              TextAlign.center,
                                                          style: TextStyle(
                                                            fontFamily:
                                                                "JakartaMedium",
                                                            fontSize: 14,
                                                            color: Color(
                                                              0xFF586000,
                                                            ),
                                                          ),
                                                        ),
                                                      ),
                                                    ),
                                                  ],
                                                ),
                                              ],
                                            ),
                                          ),
                                        ),
                                      ],
                                    ),
                                    Container(
                                      padding: EdgeInsets.symmetric(
                                        vertical: 7.5,
                                      ),
                                      child: Row(
                                        children: [
                                          Expanded(
                                            flex: 4,
                                            child: Text(
                                              "Complaint Details",
                                              style: TextStyle(
                                                fontSize: 14,
                                                fontFamily: "JakartaSemiBold",
                                              ),
                                            ),
                                          ),
                                          Expanded(
                                            flex: 6,
                                            child: DottedLine(
                                              dashGapLength: 4,
                                              dashGapColor: Colors.white,
                                              dashColor: AppColors.grey_semi,
                                              dashLength: 2,
                                              lineThickness: 0.5,
                                            ),
                                          ),
                                        ],
                                      ),
                                    ),
                                    ...List.generate(3, (j) {
                                      final heads = [
                                        "Complaint Type",
                                        "Complaint ID",
                                        "Service Schedule ID",
                                      ];
                                      final subHeads = [
                                        provider
                                                .scheduleList[lp]
                                                .complaintType ??
                                            "-",
                                        provider.scheduleList[lp].complaintId ??
                                            "-",
                                        provider
                                                .scheduleList[lp]
                                                .serviceScheduleId ??
                                            "-",
                                      ];
                                      return Container(
                                        padding: EdgeInsets.symmetric(
                                          vertical: 3,
                                        ),
                                        child: Row(
                                          crossAxisAlignment:
                                              CrossAxisAlignment.start,
                                          children: [
                                            Expanded(
                                              child: Text(
                                                textAlign: TextAlign.left,
                                                heads[j],
                                                style: TextStyle(
                                                  fontFamily: "JakartaRegular",
                                                  fontSize: 14,
                                                  color: AppColors.semi_black,
                                                ),
                                              ),
                                            ),
                                            Expanded(
                                              child: Text(
                                                textAlign: TextAlign.right,
                                                maxLines: 1,
                                                overflow: TextOverflow.ellipsis,
                                                subHeads[j] == ""
                                                    ? "-"
                                                    : subHeads[j],
                                                style: TextStyle(
                                                  fontSize: 14,
                                                  color: AppColors.grey_semi,
                                                ),
                                              ),
                                            ),
                                          ],
                                        ),
                                      );
                                    }),
                                    Container(
                                      padding: EdgeInsets.symmetric(
                                        vertical: 7,
                                      ),
                                      child: Row(
                                        children: [
                                          Expanded(
                                            flex: 3,
                                            child: Text(
                                              "Remarks",
                                              style: TextStyle(
                                                fontSize: 14,
                                                fontFamily: "JakartaSemiBold",
                                              ),
                                            ),
                                          ),
                                          Expanded(
                                            flex: 7,
                                            child: DottedLine(
                                              dashGapLength: 4,
                                              dashGapColor: Colors.white,
                                              dashColor: AppColors.grey_semi,
                                              dashLength: 2,
                                              lineThickness: 0.5,
                                            ),
                                          ),
                                        ],
                                      ),
                                    ),
                                    ...List.generate(2, (j) {
                                      final heads = [
                                        "Complaint Description",
                                        "Feedback Status",
                                      ];
                                      final subHeads = [
                                        provider
                                                .scheduleList[lp]
                                                .complaintDescription ??
                                            "-",
                                        provider
                                                .scheduleList[lp]
                                                .feedbackStatus ??
                                            "-",
                                      ];
                                      return Container(
                                        padding: EdgeInsets.symmetric(
                                          vertical: 3,
                                        ),
                                        child: Row(
                                          crossAxisAlignment:
                                              CrossAxisAlignment.start,
                                          children: [
                                            Expanded(
                                              child: Text(
                                                textAlign: TextAlign.left,
                                                heads[j],
                                                style: TextStyle(
                                                  fontFamily: "JakartaRegular",
                                                  fontSize: 14,
                                                  color: AppColors.semi_black,
                                                ),
                                              ),
                                            ),
                                            Expanded(
                                              child: Text(
                                                textAlign: TextAlign.right,
                                                subHeads[j] == ""
                                                    ? "-"
                                                    : subHeads[j],

                                                style: TextStyle(
                                                  fontSize: 14,
                                                  color: AppColors.grey_semi,
                                                ),
                                              ),
                                            ),
                                          ],
                                        ),
                                      );
                                    }),
                                  ],
                                ),
                              );
                            },
                          ),
                        ),
                      ],

                      if (provider.complaintsList.isNotEmpty) ...[
                        Container(
                          padding: EdgeInsets.symmetric(
                            horizontal: 10,
                            vertical: 5,
                          ),
                          child: Text(
                            "Complaint History",
                            style: TextStyle(
                              color: Color(0xFF818181),
                              fontFamily: "JakartaMedium",
                            ),
                          ),
                        ),
                        SizedBox(
                          width: double.infinity,
                          height: 220,
                          child: ListView.builder(
                            physics: AlwaysScrollableScrollPhysics(),
                            shrinkWrap: true,
                            scrollDirection: Axis.horizontal,
                            padding: EdgeInsets.symmetric(
                              vertical: 10,
                              horizontal: 10,
                            ),
                            itemCount: provider.complaintsList.length,
                            itemBuilder: (context, lp) {
                              return Container(
                                height: 220,
                                width: MediaQuery.of(context).size.width * 0.92,
                                decoration: BoxDecoration(
                                  color: Colors.white,
                                  borderRadius: BorderRadius.circular(14),
                                ),
                                padding: EdgeInsets.symmetric(
                                  horizontal: 10,
                                  vertical: 10,
                                ),
                                margin: EdgeInsets.symmetric(horizontal: 5),

                                child: Column(
                                  children: [
                                    Row(
                                      mainAxisAlignment:
                                          MainAxisAlignment.start,
                                      crossAxisAlignment:
                                          CrossAxisAlignment.start,
                                      children: [
                                        Expanded(
                                          flex: 1,
                                          child: SvgPicture.asset(
                                            "assets/svg/crm/quotation_details_ic.svg",
                                          ),
                                        ),
                                        SizedBox(width: 10),
                                        Expanded(
                                          flex: 6,
                                          child: SizedBox(
                                            child: Column(
                                              // mainAxisAlignment: MainAxisAlignment.start,
                                              crossAxisAlignment:
                                                  CrossAxisAlignment.start,
                                              mainAxisAlignment:
                                                  MainAxisAlignment.start,
                                              children: [
                                                Row(
                                                  children: [
                                                    Expanded(
                                                      flex: 4,
                                                      child: Column(
                                                        crossAxisAlignment:
                                                            CrossAxisAlignment
                                                                .start,
                                                        children: [
                                                          Text(
                                                            provider
                                                                    .complaintsList[lp]
                                                                    .technicianName ??
                                                                "-",
                                                            style: TextStyle(
                                                              fontFamily:
                                                                  "JakartaMedium",
                                                              fontSize: 14,
                                                              color:
                                                                  AppColors
                                                                      .semi_black,
                                                            ),
                                                          ),
                                                          Text(
                                                            provider
                                                                    .complaintsList[lp]
                                                                    .complaintTypeName ??
                                                                "-",
                                                            style: TextStyle(
                                                              fontFamily:
                                                                  "JakartaMedium",
                                                              fontSize: 14,
                                                              color:
                                                                  AppColors
                                                                      .grey_semi,
                                                            ),
                                                          ),
                                                        ],
                                                      ),
                                                    ),
                                                    Expanded(
                                                      flex: 3,
                                                      child: Container(
                                                        decoration: BoxDecoration(
                                                          borderRadius:
                                                              BorderRadius.circular(
                                                                8,
                                                              ),
                                                          color: Color(
                                                            0xFFF3FFD5,
                                                          ),
                                                        ),
                                                        padding:
                                                            EdgeInsets.symmetric(
                                                              horizontal: 5,
                                                              vertical: 10,
                                                            ),
                                                        child: Text(
                                                          provider
                                                                  .complaintsList[lp]
                                                                  .openStatus ??
                                                              "-",
                                                          textAlign:
                                                              TextAlign.center,
                                                          style: TextStyle(
                                                            fontFamily:
                                                                "JakartaMedium",
                                                            fontSize: 14,
                                                            color: Color(
                                                              0xFF586000,
                                                            ),
                                                          ),
                                                        ),
                                                      ),
                                                    ),
                                                  ],
                                                ),
                                              ],
                                            ),
                                          ),
                                        ),
                                      ],
                                    ),
                                    Container(
                                      padding: EdgeInsets.symmetric(
                                        vertical: 7.5,
                                      ),
                                      child: Row(
                                        children: [
                                          Expanded(
                                            flex: 4,
                                            child: Text(
                                              "Complaint Details",
                                              style: TextStyle(
                                                fontSize: 14,
                                                fontFamily: "JakartaSemiBold",
                                              ),
                                            ),
                                          ),
                                          Expanded(
                                            flex: 6,
                                            child: DottedLine(
                                              dashGapLength: 4,
                                              dashGapColor: Colors.white,
                                              dashColor: AppColors.grey_semi,
                                              dashLength: 2,
                                              lineThickness: 0.5,
                                            ),
                                          ),
                                        ],
                                      ),
                                    ),
                                    ...List.generate(3, (j) {
                                      final heads = [
                                        "Complaint Category",
                                        "Created By",
                                        "Registered Date",
                                      ];
                                      final subHeads = [
                                        provider
                                                .complaintsList[lp]
                                                .complaintCategoryName ??
                                            "-",
                                        provider.complaintsList[lp].createdBy ??
                                            "-",
                                        provider
                                                .complaintsList[lp]
                                                .createdDate ??
                                            "-",
                                      ];
                                      return Container(
                                        padding: EdgeInsets.symmetric(
                                          vertical: 3,
                                        ),
                                        child: Row(
                                          crossAxisAlignment:
                                              CrossAxisAlignment.start,
                                          children: [
                                            Expanded(
                                              child: Text(
                                                textAlign: TextAlign.left,
                                                heads[j],
                                                style: TextStyle(
                                                  fontFamily: "JakartaRegular",
                                                  fontSize: 14,
                                                  color: AppColors.semi_black,
                                                ),
                                              ),
                                            ),
                                            Expanded(
                                              child: Text(
                                                textAlign: TextAlign.right,
                                                maxLines: 1,
                                                overflow: TextOverflow.ellipsis,
                                                subHeads[j] == ""
                                                    ? "-"
                                                    : subHeads[j],
                                                style: TextStyle(
                                                  fontSize: 14,
                                                  color: AppColors.grey_semi,
                                                ),
                                              ),
                                            ),
                                          ],
                                        ),
                                      );
                                    }),
                                  ],
                                ),
                              );
                            },
                          ),
                        ),
                      ],

                      InkWell(
                        onTap: () {
                          Navigator.push(
                            context,
                            MaterialPageRoute(
                              builder:
                                  (context) => TagLocationScreen(
                                    genHashID: provider.genHashID,
                                  ),
                            ),
                          );
                        },
                        child: Container(
                          height: 45,
                          decoration: BoxDecoration(
                            color: Colors.white,
                            borderRadius: BorderRadius.circular(14),
                          ),
                          // width: Med1iaQuery.of(context).size.width,
                          margin: EdgeInsets.symmetric(
                            horizontal: 10,
                            vertical: 5,
                          ),
                          padding: EdgeInsets.symmetric(
                            horizontal: 10,
                            vertical: 10,
                          ),
                          // decoration: BoxDecoration(
                          //   color: AppColors.app_blue,
                          //   borderRadius: BorderRadius.circular(15.0),
                          // ),
                          child: Row(
                            mainAxisAlignment: MainAxisAlignment.start,
                            children: [
                              Container(
                                height: 40,
                                width: 40,
                                decoration: BoxDecoration(
                                  shape: BoxShape.circle,
                                  color: Color(0xFFE6F6FF),
                                ),
                                child: SvgPicture.asset(
                                  "assets/svg/gent_tag_loc.svg",
                                  width: 20,
                                ),
                              ),
                              SizedBox(width: 10),
                              Expanded(
                                flex: 4,
                                child: Text(
                                  "Tag Location",
                                  style: TextStyle(
                                    fontFamily: "JakartaMedium",
                                    fontSize: 14,
                                    color: AppColors.semi_black,
                                  ),
                                ),
                              ),
                              SizedBox(width: 10),
                            ],
                          ),
                        ),
                      ),
                      InkWell(
                        onTap: () {
                          provider.TagGeneratorCheckAPIFunction(
                            Homeprovider,
                            context,
                            provider.genHashID,
                          );
                        },
                        child: Container(
                          height: 45,
                          decoration: BoxDecoration(
                            color: Colors.white,
                            borderRadius: BorderRadius.circular(14),
                          ),
                          // width: Med1iaQuery.of(context).size.width,
                          margin: EdgeInsets.symmetric(
                            horizontal: 10,
                            vertical: 5,
                          ),
                          padding: EdgeInsets.symmetric(
                            horizontal: 10,
                            vertical: 10,
                          ),
                          // decoration: BoxDecoration(
                          //   color: AppColors.app_blue,
                          //   borderRadius: BorderRadius.circular(15.0),
                          // ),
                          child: Row(
                            mainAxisAlignment: MainAxisAlignment.start,
                            children: [
                              Container(
                                height: 40,
                                width: 40,
                                decoration: BoxDecoration(
                                  shape: BoxShape.circle,
                                  color: Color(0xFFE6F6FF),
                                ),
                                child: SvgPicture.asset(
                                  "assets/svg/gent_tag_den.svg",
                                  width: 20,
                                ),
                              ),
                              SizedBox(width: 10),
                              Expanded(
                                flex: 4,
                                child: Text(
                                  "Tag Generator",
                                  style: TextStyle(
                                    fontFamily: "JakartaMedium",
                                    fontSize: 14,
                                    color: AppColors.semi_black,
                                  ),
                                ),
                              ),
                              SizedBox(width: 10),
                            ],
                          ),
                        ),
                      ),
                      InkWell(
                        onTap: () {
                          provider.LoadgeneratorDetailsApifunction(
                            Homeprovider,
                            context,
                            "Register Complaint",
                            provider.genHashID,
                            "2",
                          );
                          // Navigator.push(
                          //   context,
                          //   MaterialPageRoute(
                          //     builder:
                          //         (context) => Scanentergeneratoridscreen(
                          //           from: "Register Complaint",
                          //         ),
                          //   ),
                          // );
                        },
                        child: Container(
                          height: 45,
                          decoration: BoxDecoration(
                            color: Colors.white,
                            borderRadius: BorderRadius.circular(14),
                          ),
                          // width: Med1iaQuery.of(context).size.width,
                          margin: EdgeInsets.symmetric(
                            horizontal: 10,
                            vertical: 5,
                          ),
                          padding: EdgeInsets.symmetric(
                            horizontal: 10,
                            vertical: 10,
                          ),
                          // decoration: BoxDecoration(
                          //   color: AppColors.app_blue,
                          //   borderRadius: BorderRadius.circular(15.0),
                          // ),
                          child: Row(
                            children: [
                              Container(
                                height: 40,
                                width: 40,
                                decoration: BoxDecoration(
                                  shape: BoxShape.circle,
                                  color: Color(0xFFE6F6FF),
                                ),
                                child: SvgPicture.asset(
                                  "assets/svg/gent_reg_comp.svg",
                                  width: 20,
                                ),
                              ),
                              SizedBox(width: 10),
                              Expanded(
                                flex: 4,
                                child: Text(
                                  "Register Complaint",
                                  style: TextStyle(
                                    fontFamily: "JakartaMedium",
                                    fontSize: 14,
                                    color: AppColors.semi_black,
                                  ),
                                ),
                              ),

                              SizedBox(width: 10),
                            ],
                          ),
                        ),
                      ),
                      SizedBox(height: 75),
                    ],
                  ),
                ),
              ),
              // floatingActionButton: Align(
              //   alignment: Alignment.bottomCenter,
              //   child: InkWell(
              //     onTap: () {
              //       Navigator.push(
              //         context,
              //         MaterialPageRoute(
              //           builder:
              //               (context) =>
              //                   Complainthistory(genHashID: provider.genHashID),
              //         ),
              //       );
              //     },
              //     child: Container(
              //       alignment: Alignment.bottomCenter,
              //       height: 45,
              //       width: MediaQuery.of(context).size.width,
              //       margin: EdgeInsets.symmetric(horizontal: 10),
              //       decoration: BoxDecoration(
              //         color: AppColors.app_blue,
              //         borderRadius: BorderRadius.circular(15.0),
              //       ),
              //       child: Center(
              //         child: Text(
              //           "Complaint History",
              //           textAlign: TextAlign.center,
              //           style: TextStyle(
              //             fontFamily: "JakartaMedium",
              //             fontSize: 15,
              //             color: Colors.white,
              //           ),
              //         ),
              //       ),
              //     ),
              //   ),
              // ),
              // floatingActionButtonLocation:
              //     FloatingActionButtonLocation.centerFloat,
            ),
          ),
        );
      },
    );
  }

  Widget _scaffold1(BuildContext context) {
    switch (_source.keys.toList()[0]) {
      case ConnectivityResult.mobile:
        connection = 'Online';
        break;
      case ConnectivityResult.wifi:
        connection = 'Online';
        break;
      case ConnectivityResult.none:
      default:
        connection = 'Offline';
    }
    return Consumer2<Generatordetailsprovider, HomescreenNotifier>(
      builder: (context, provider, Homeprovider, child) {
        var sendwidget = SizedBox(width: 0);
        return WillPopScope(
          onWillPop: () => onBackPressed(context),
          child: SafeArea(
            top: false,
            bottom: Platform.isIOS ? false : true,
            child: Scaffold(
              resizeToAvoidBottomInset: true,
              appBar: appbar2(
                context,
                "Generator Details",
                provider.resetForm,
                sendwidget,
              ),
              backgroundColor: AppColors.scaffold_bg_color,
              body: Container(
                child: SingleChildScrollView(
                  child: Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      Container(
                        padding: EdgeInsets.symmetric(
                          horizontal: 10,
                          vertical: 5,
                        ),
                        child: Text(
                          "Customer Details",
                          style: TextStyle(
                            color: Color(0xFF818181),
                            fontFamily: "JakartaMedium",
                          ),
                        ),
                      ),
                      Container(
                        margin: EdgeInsets.symmetric(
                          horizontal: 10,
                          vertical: 5,
                        ),
                        padding: EdgeInsets.symmetric(
                          horizontal: 15,
                          vertical: 10,
                        ),
                        decoration: BoxDecoration(
                          color: Colors.white,
                          borderRadius: BorderRadius.circular(20),
                        ),
                        child: Column(
                          children: [
                            Container(
                              padding: EdgeInsets.symmetric(
                                vertical: 3,
                                horizontal: 0,
                              ),
                              child: Row(
                                children: [
                                  SvgPicture.asset(
                                    "assets/svg/se_block_head.svg",
                                  ),
                                  SizedBox(width: 10),

                                  Expanded(
                                    child: Column(
                                      crossAxisAlignment:
                                          CrossAxisAlignment.start,
                                      children: [
                                        Text(
                                          "${provider.aname}",
                                          maxLines: 2,
                                          overflow: TextOverflow.ellipsis,
                                          style: TextStyle(
                                            fontFamily: "JakartaMedium",
                                            fontSize: 14,
                                          ),
                                        ),
                                        Text(
                                          "${provider.cname}",
                                          maxLines: 2,
                                          overflow: TextOverflow.ellipsis,
                                          style: TextStyle(
                                            fontSize: 14,
                                            color: Color(0xFF818181),
                                          ),
                                        ),
                                      ],
                                    ),
                                  ),
                                ],
                              ),
                            ),
                            Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: List.generate(4, (j) {
                                final textheads = [
                                  "Mobile Number",
                                  "Contact Person Number",
                                  "Mail ID",
                                  "Location",
                                ];
                                final textSubheads = [
                                  provider.mob1 ?? "-",
                                  provider.mob2 ?? "-",
                                  provider.mail ?? "-",
                                  "View",
                                ];
                                return Container(
                                  padding: EdgeInsets.symmetric(
                                    vertical: 6,
                                    horizontal: 0,
                                  ),
                                  child: Row(
                                    children: [
                                      Expanded(
                                        flex: 1,
                                        child: SizedBox(
                                          child: Text(
                                            textheads[j].toString(),
                                            maxLines: 2,
                                            overflow: TextOverflow.ellipsis,
                                            style: TextStyle(
                                              fontFamily: "JakartaMedium",
                                              fontSize: 14,
                                            ),
                                          ),
                                        ),
                                      ),
                                      SizedBox(width: 5),
                                      if (textSubheads[j] == "View") ...[
                                        Expanded(
                                          flex: 2,
                                          child: Container(
                                            padding: EdgeInsets.only(
                                              right: 10.0,
                                            ),
                                            child: InkWell(
                                              onTap: () async {
                                                if (widget.genLocation !=
                                                    null) {
                                                  provider.genLocationLatLngs =
                                                      widget.genLocation
                                                          ?.split(",")
                                                          .toString();
                                                } else {
                                                  provider.genLocationLatLngs =
                                                      provider.genLocation
                                                          ?.split(",")
                                                          .toString();
                                                }

                                                var uri = Uri.parse(
                                                  "google.navigation:q=${provider.genLocationLatLngs![0]},${provider.genLocationLatLngs![1]}&mode=d",
                                                );
                                                if (Platform.isIOS) {
                                                  uri = Uri.parse(
                                                    "maps://?q=${provider.genLocationLatLngs![0]},${provider.genLocationLatLngs![1]}&z=10&daddr=${provider.genLocationLatLngs![0]},${provider.genLocationLatLngs![1]}&dirflg=d",
                                                  );
                                                }
                                                if (await canLaunch(
                                                  uri.toString(),
                                                )) {
                                                  await launch(uri.toString());
                                                } else {
                                                  throw 'Could not launch ${uri.toString()}';
                                                }
                                              },
                                              child: Text(
                                                textSubheads[j],
                                                maxLines: 2,
                                                overflow: TextOverflow.ellipsis,
                                                style: TextStyle(
                                                  fontSize: 14,
                                                  color: AppColors.app_blue,
                                                  decoration:
                                                      TextDecoration.underline,
                                                  decorationColor:
                                                      AppColors.app_blue,
                                                ),
                                              ),
                                            ),
                                          ),
                                        ),
                                      ] else ...[
                                        Expanded(
                                          flex: 2,
                                          child: InkResponse(
                                            onTap:
                                                textheads[j] != "Mobile Number"
                                                    ? null
                                                    : () async {
                                                      final Uri phoneUri = Uri(
                                                        scheme: 'tel',
                                                        path:
                                                            provider.mob1 == ""
                                                                ? provider.mob2
                                                                : provider.mob1,
                                                      );

                                                      if (await canLaunchUrl(
                                                        phoneUri,
                                                      )) {
                                                        await launchUrl(
                                                          phoneUri,
                                                        );
                                                      } else {
                                                        throw 'Could not launch $phoneUri';
                                                      }
                                                    },
                                            child: SizedBox(
                                              child: Text(
                                                textSubheads[j] == ""
                                                    ? "-"
                                                    : textSubheads[j],
                                                maxLines: 2,
                                                overflow: TextOverflow.ellipsis,
                                                style: TextStyle(
                                                  fontSize: 14,
                                                  color:
                                                      textheads[j] ==
                                                              "Mobile Number"
                                                          ? AppColors.app_blue
                                                          : Color(0xFF818181),
                                                  decorationColor:
                                                      textheads[j] ==
                                                              "Mobile Number"
                                                          ? AppColors.app_blue
                                                          : null,
                                                  decoration:
                                                      textheads[j] ==
                                                              "Mobile Number"
                                                          ? TextDecoration
                                                              .underline
                                                          : null,
                                                ),
                                              ),
                                            ),
                                          ),
                                        ),
                                      ],
                                    ],
                                  ),
                                );
                              }),
                            ),
                          ],
                        ),
                      ),

                      Container(
                        padding: EdgeInsets.symmetric(
                          horizontal: 10,
                          vertical: 5,
                        ),
                        child: Text(
                          "Generator Details",
                          style: TextStyle(
                            color: Color(0xFF818181),
                            fontFamily: "JakartaMedium",
                          ),
                        ),
                      ),
                      Container(
                        margin: EdgeInsets.symmetric(
                          horizontal: 10,
                          vertical: 5,
                        ),
                        padding: EdgeInsets.symmetric(
                          horizontal: 15,
                          vertical: 10,
                        ),
                        decoration: BoxDecoration(
                          color: Colors.white,
                          borderRadius: BorderRadius.circular(20),
                        ),
                        child: Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: List.generate(6, (j) {
                            final textheads = [
                              "Product Name",
                              "Gen Hash ID",
                              "Engine Number",
                              "Engine Model",
                              "Address",
                              "Date Of Supply",
                            ];
                            final textSubheads = [
                              "${provider.spname}",
                              "${provider.genHashID}",
                              "${provider.engineNo}",
                              "${provider.emodel}",
                              "${provider.address}",
                              "${provider.dateOfEngineSale}",
                            ];
                            return Container(
                              padding: EdgeInsets.symmetric(
                                vertical: 6,
                                horizontal: 0,
                              ),
                              child: Row(
                                crossAxisAlignment: CrossAxisAlignment.start,
                                children: [
                                  Expanded(
                                    flex: 1,
                                    child: Text(
                                      textheads[j].toString(),
                                      style: TextStyle(
                                        fontSize: 14,
                                        fontFamily: "JakartaMedium",
                                      ),
                                    ),
                                  ),
                                  SizedBox(width: 5),
                                  Expanded(
                                    flex: 2,
                                    child: SizedBox(
                                      child: Text(
                                        textSubheads[j] == ""
                                            ? "-"
                                            : textSubheads[j],
                                        maxLines: 2,
                                        overflow: TextOverflow.ellipsis,
                                        style: TextStyle(
                                          fontSize: 14,
                                          color: Color(0xFF818181),
                                        ),
                                      ),
                                    ),
                                  ),
                                ],
                              ),
                            );
                          }),
                        ),
                      ),

                      if (provider.contactsList.isNotEmpty) ...[
                        Container(
                          padding: EdgeInsets.symmetric(
                            horizontal: 10,
                            vertical: 5,
                          ),
                          child: Text(
                            "Customer Contact Details",
                            style: TextStyle(
                              color: Color(0xFF818181),
                              fontFamily: "JakartaMedium",
                            ),
                          ),
                        ),
                        ListView.builder(
                          shrinkWrap: true,
                          physics: NeverScrollableScrollPhysics(),
                          itemCount: provider.contactsList.length,
                          itemBuilder: (context, l) {
                            return Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: [
                                Container(
                                  margin: EdgeInsets.symmetric(
                                    horizontal: 10,
                                    vertical: 5,
                                  ),
                                  decoration: BoxDecoration(
                                    color: Colors.white,
                                    borderRadius: BorderRadius.circular(16),
                                  ),
                                  child: Column(
                                    children: [
                                      ...List.generate(4, (jndex) {
                                        final headings = [
                                          "Alternate Mobile Number",
                                          "Designation",
                                          "Contact Type",
                                          "Mail ID",
                                        ];

                                        final values = [
                                          provider.contactsList[l].mob2,
                                          provider.contactsList[l].designation,
                                          provider.contactsList[l].type,
                                          provider.contactsList[l].mail,
                                        ];
                                        return Container(
                                          padding: EdgeInsets.symmetric(
                                            horizontal: 15,
                                            vertical: 6,
                                          ),
                                          child: Row(
                                            crossAxisAlignment:
                                                CrossAxisAlignment.start,
                                            children: [
                                              Expanded(
                                                child: SizedBox(
                                                  child: Text(
                                                    headings[jndex],
                                                    style: TextStyle(
                                                      fontSize: 14,
                                                    ),
                                                  ),
                                                ),
                                              ),
                                              Expanded(
                                                child: SizedBox(
                                                  child: Text(
                                                    values[jndex] == ""
                                                        ? "-"
                                                        : "${values[jndex]}",
                                                    style: TextStyle(
                                                      fontSize: 14,
                                                      color: Color(0xFF818181),
                                                    ),
                                                  ),
                                                ),
                                              ),
                                            ],
                                          ),
                                        );
                                      }),
                                    ],
                                  ),
                                ),
                              ],
                            );
                          },
                        ),
                      ],

                      if (provider.scheduleList.isNotEmpty) ...[
                        Container(
                          padding: EdgeInsets.symmetric(
                            horizontal: 10,
                            vertical: 5,
                          ),
                          child: Text(
                            "Schedule Details",
                            style: TextStyle(
                              color: Color(0xFF818181),
                              fontFamily: "JakartaMedium",
                            ),
                          ),
                        ),
                        ListView.builder(
                          shrinkWrap: true,
                          physics: NeverScrollableScrollPhysics(),
                          itemCount:
                              provider.showMoreScheduleList
                                  ? provider.scheduleList.length
                                  : 1,
                          itemBuilder: (context, l) {
                            final headings1 = [
                              "Employee Name",
                              "Schedule Manager Name",
                              "Due Date",
                            ];
                            final values1 = [
                              provider.scheduleList[l].name,
                              provider.scheduleList[l].scheduleManagerName,
                              provider.scheduleList[l].dueDate,
                            ];

                            final headings2 = [
                              "Complaint Type",
                              "Complaint Category",
                              "Service Schedule ID",
                              "Complaint Description",

                              "Complaint ID",

                              "Status",
                              "Feedback Status",
                            ];
                            final values2 = [
                              provider.scheduleList[l].complaintType,
                              provider.scheduleList[l].complaintCategory,
                              provider.scheduleList[l].serviceScheduleId,
                              provider.scheduleList[l].complaintDescription,

                              provider.scheduleList[l].complaintId,

                              provider.scheduleList[l].feedbackStatus,
                              provider.scheduleList[l].status,
                              provider.scheduleList[l].feedbackStatus,
                            ];
                            var headings = [...headings1];
                            var values = [...values1];

                            if (provider.showMoreScheduleDetails) {
                              headings = [...headings1, ...headings2];
                              values = [...values1, ...values2];
                            }
                            return Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: [
                                Container(
                                  margin: EdgeInsets.symmetric(
                                    horizontal: 10,
                                    vertical: 5,
                                  ),
                                  decoration: BoxDecoration(
                                    color: Colors.white,
                                    borderRadius: BorderRadius.circular(16),
                                  ),
                                  child: Column(
                                    children: [
                                      ...List.generate(headings.length, (
                                        jndex,
                                      ) {
                                        return Container(
                                          padding: EdgeInsets.symmetric(
                                            horizontal: 15,
                                            vertical: 6,
                                          ),
                                          child: Row(
                                            crossAxisAlignment:
                                                CrossAxisAlignment.start,
                                            children: [
                                              Expanded(
                                                child: SizedBox(
                                                  child: Text(
                                                    headings[jndex],
                                                    style: TextStyle(
                                                      fontSize: 14,
                                                    ),
                                                  ),
                                                ),
                                              ),
                                              Expanded(
                                                child: SizedBox(
                                                  child: Text(
                                                    values[jndex] == ""
                                                        ? "-"
                                                        : "${values[jndex]}",
                                                    style: TextStyle(
                                                      fontSize: 14,
                                                      color: Color(0xFF818181),
                                                    ),
                                                  ),
                                                ),
                                              ),
                                            ],
                                          ),
                                        );
                                      }),
                                      InkResponse(
                                        onTap: () async {
                                          provider.showMoreScheduleDetails =
                                              !provider.showMoreScheduleDetails;
                                        },
                                        child: Container(
                                          padding: EdgeInsets.symmetric(
                                            vertical: 5,
                                          ),
                                          child: Row(
                                            crossAxisAlignment:
                                                CrossAxisAlignment.center,
                                            mainAxisAlignment:
                                                MainAxisAlignment.center,
                                            children: [
                                              Text(
                                                provider.showMoreScheduleDetails
                                                    ? "- Show Less"
                                                    : "+ More Details",
                                                style: TextStyle(
                                                  fontFamily: "JakartaMedium",
                                                  fontSize: 14,
                                                  color: AppColors.app_blue,
                                                ),
                                              ),
                                            ],
                                          ),
                                        ),
                                      ),
                                    ],
                                  ),
                                ),
                              ],
                            );
                          },
                        ),
                        if (provider.scheduleList.length > 1) ...[
                          InkResponse(
                            onTap: () async {
                              provider.showMoreScheduleList =
                                  !provider.showMoreScheduleList;
                            },
                            child: Container(
                              padding: EdgeInsets.symmetric(vertical: 5),
                              child: Row(
                                crossAxisAlignment: CrossAxisAlignment.center,
                                mainAxisAlignment: MainAxisAlignment.center,
                                children: [
                                  Text(
                                    provider.showMoreScheduleList
                                        ? " Show Less"
                                        : " Show More",
                                    style: TextStyle(
                                      fontFamily: "JakartaMedium",
                                      fontSize: 14,
                                      color: AppColors.app_blue,
                                    ),
                                  ),
                                  Transform.rotate(
                                    angle:
                                        provider.showMoreScheduleList
                                            ? 180 * 3.14159 / 180
                                            : 0 * 3.14159 / 180,
                                    child: SvgPicture.asset(
                                      "assets/svg/arrow_dropdown.svg",
                                      color: AppColors.app_blue,
                                      width: 25,
                                    ),
                                  ),
                                ],
                              ),
                            ),
                          ),
                        ],
                      ],
                      InkWell(
                        onTap: () {
                          Navigator.push(
                            context,
                            MaterialPageRoute(
                              builder:
                                  (context) => TagLocationScreen(
                                    genHashID: provider.genHashID,
                                  ),
                            ),
                          );
                        },
                        child: Container(
                          height: 45,
                          decoration: BoxDecoration(
                            color: Colors.white,
                            borderRadius: BorderRadius.circular(14),
                          ),
                          // width: Med1iaQuery.of(context).size.width,
                          margin: EdgeInsets.symmetric(
                            horizontal: 10,
                            vertical: 5,
                          ),
                          padding: EdgeInsets.symmetric(
                            horizontal: 10,
                            vertical: 10,
                          ),
                          // decoration: BoxDecoration(
                          //   color: AppColors.app_blue,
                          //   borderRadius: BorderRadius.circular(15.0),
                          // ),
                          child: Row(
                            mainAxisAlignment: MainAxisAlignment.start,
                            children: [
                              SvgPicture.asset(
                                "assets/svg/gent_tag_loc.svg",
                                width: 20,
                              ),
                              SizedBox(width: 10),
                              Expanded(
                                flex: 4,
                                child: Text(
                                  "Tag Location",
                                  style: TextStyle(
                                    fontFamily: "JakartaMedium",
                                    fontSize: 15,
                                    decoration: TextDecoration.underline,
                                    decorationColor: AppColors.app_blue,
                                    color: AppColors.app_blue,
                                  ),
                                ),
                              ),
                              SizedBox(width: 10),
                              SvgPicture.asset(
                                "assets/svg/arrow_right_new.svg",
                              ),
                            ],
                          ),
                        ),
                      ),
                      InkWell(
                        onTap: () {
                          provider.TagGeneratorCheckAPIFunction(
                            Homeprovider,
                            context,
                            provider.genHashID,
                          );
                        },
                        child: Container(
                          height: 45,
                          decoration: BoxDecoration(
                            color: Colors.white,
                            borderRadius: BorderRadius.circular(14),
                          ),
                          // width: Med1iaQuery.of(context).size.width,
                          margin: EdgeInsets.symmetric(
                            horizontal: 10,
                            vertical: 5,
                          ),
                          padding: EdgeInsets.symmetric(
                            horizontal: 10,
                            vertical: 10,
                          ),
                          // decoration: BoxDecoration(
                          //   color: AppColors.app_blue,
                          //   borderRadius: BorderRadius.circular(15.0),
                          // ),
                          child: Row(
                            mainAxisAlignment: MainAxisAlignment.start,
                            children: [
                              SvgPicture.asset(
                                "assets/svg/gent_tag_loc.svg",
                                width: 20,
                              ),
                              SizedBox(width: 10),
                              Expanded(
                                flex: 4,
                                child: Text(
                                  "Tag Generator",
                                  style: TextStyle(
                                    fontFamily: "JakartaMedium",
                                    fontSize: 15,
                                    decoration: TextDecoration.underline,
                                    decorationColor: AppColors.app_blue,
                                    color: AppColors.app_blue,
                                  ),
                                ),
                              ),
                              SizedBox(width: 10),
                              SvgPicture.asset(
                                "assets/svg/arrow_right_new.svg",
                              ),
                            ],
                          ),
                        ),
                      ),
                      InkWell(
                        onTap: () {
                          provider.LoadgeneratorDetailsApifunction(
                            Homeprovider,
                            context,
                            "Register Complaint",
                            provider.genHashID,
                            "2",
                          );
                          // Navigator.push(
                          //   context,
                          //   MaterialPageRoute(
                          //     builder:
                          //         (context) => Scanentergeneratoridscreen(
                          //           from: "Register Complaint",
                          //         ),
                          //   ),
                          // );
                        },
                        child: Container(
                          height: 45,
                          decoration: BoxDecoration(
                            color: Colors.white,
                            borderRadius: BorderRadius.circular(14),
                          ),
                          // width: Med1iaQuery.of(context).size.width,
                          margin: EdgeInsets.symmetric(
                            horizontal: 10,
                            vertical: 5,
                          ),
                          padding: EdgeInsets.symmetric(
                            horizontal: 10,
                            vertical: 10,
                          ),
                          // decoration: BoxDecoration(
                          //   color: AppColors.app_blue,
                          //   borderRadius: BorderRadius.circular(15.0),
                          // ),
                          child: Row(
                            children: [
                              SvgPicture.asset(
                                "assets/svg/gent_reg_comp.svg",
                                width: 20,
                              ),
                              SizedBox(width: 10),
                              Expanded(
                                flex: 4,
                                child: Text(
                                  "Register Complaint",
                                  style: TextStyle(
                                    fontFamily: "JakartaMedium",
                                    fontSize: 15,
                                    decoration: TextDecoration.underline,
                                    decorationColor: AppColors.app_blue,
                                    color: AppColors.app_blue,
                                  ),
                                ),
                              ),

                              SizedBox(width: 10),
                              SvgPicture.asset(
                                "assets/svg/arrow_right_new.svg",
                              ),
                            ],
                          ),
                        ),
                      ),
                      SizedBox(height: 75),
                    ],
                  ),
                ),
              ),
              floatingActionButton: Align(
                alignment: Alignment.bottomCenter,
                child: InkWell(
                  onTap: () {
                    Navigator.push(
                      context,
                      MaterialPageRoute(
                        builder:
                            (context) =>
                                Complainthistory(genHashID: provider.genHashID),
                      ),
                    );
                  },
                  child: Container(
                    alignment: Alignment.bottomCenter,
                    height: 45,
                    width: MediaQuery.of(context).size.width,
                    margin: EdgeInsets.symmetric(horizontal: 10),
                    decoration: BoxDecoration(
                      color: AppColors.app_blue,
                      borderRadius: BorderRadius.circular(15.0),
                    ),
                    child: Center(
                      child: Text(
                        "Complaint History",
                        textAlign: TextAlign.center,
                        style: TextStyle(
                          fontFamily: "JakartaMedium",
                          fontSize: 15,
                          color: Colors.white,
                        ),
                      ),
                    ),
                  ),
                ),
              ),
              floatingActionButtonLocation:
                  FloatingActionButtonLocation.centerFloat,
            ),
          ),
        );
      },
    );
  }
}

class TagLocationScreen extends StatefulWidget {
  final genHashID;

  const TagLocationScreen({super.key, required this.genHashID});

  @override
  State<TagLocationScreen> createState() => _TagLocationScreenState();
}

class _TagLocationScreenState extends State<TagLocationScreen> {
  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    WidgetsBinding.instance.addPostFrameCallback((_) {
      final provider = Provider.of<Generatordetailsprovider>(
        context,
        listen: false,
      );
      provider.showMoreDetails = false;
    });
  }

  @override
  Widget build(BuildContext context) {
    return Consumer2<Generatordetailsprovider, HomescreenNotifier>(
      builder: (context, provider, Homeprovider, child) {
        var sendwidget = SizedBox(width: 0);
        return WillPopScope(
          onWillPop: () => onBackPressed(context),
          child: Scaffold(
            resizeToAvoidBottomInset: true,
            appBar: appbar2(
              context,
              "Tag Location",
              provider.resetForm,
              sendwidget,
            ),
            backgroundColor: AppColors.white,
            body: SafeArea(
              child: Padding(
                padding: EdgeInsets.symmetric(horizontal: 10, vertical: 10),
                child: Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    textControllerReadonlyWidget(
                      context,
                      TextEditingController(text: widget.genHashID),
                      "Gen ID",
                      (p0) {},
                    ),
                    SizedBox(height: 10),
                    InkResponse(
                      onTap: () {
                        _showAttachmentSheet(context);
                      },
                      child: Container(
                        margin: EdgeInsets.symmetric(vertical: 10),
                        height: 45,
                        width: MediaQuery.of(context).size.width,
                        decoration: BoxDecoration(
                          color: Color(0xFFE6F6FF),
                          borderRadius: BorderRadius.circular(12),
                          border: Border.all(
                            color: AppColors.app_blue,
                            width: 0.5,
                          ),
                        ),
                        child: Center(
                          child: Text(
                            "Add Proof",
                            style: TextStyle(color: AppColors.app_blue),
                          ),
                        ),
                      ),
                    ),
                    if (provider.imagePicked == 1 &&
                        provider.imagePath != null) ...[
                      Padding(
                        padding: const EdgeInsets.symmetric(vertical: 4.0),
                        child: Row(
                          mainAxisAlignment: MainAxisAlignment.spaceBetween,
                          children: [
                            Expanded(
                              flex: 4,
                              child: Text(
                                "${provider.imagePath}",
                                overflow: TextOverflow.visible,
                                style: TextStyle(
                                  color: AppColors.semi_black,
                                  fontSize: 11,
                                  fontWeight: FontWeight.w600,
                                ),
                              ),
                            ),
                            SizedBox(width: 10),
                            Expanded(
                              flex: 1,
                              child: InkResponse(
                                onTap: () {
                                  provider.imagePicked = 0;
                                  provider.imagePath = null;
                                  provider.imageFilePath = null;
                                },
                                child: SvgPicture.asset(
                                  "assets/svg/ic_close.svg",
                                  width: 15,
                                  height: 15,
                                ),
                              ),
                            ),
                          ],
                        ),
                      ),
                    ],
                    errorWidget(context, provider.imageError),
                  ],
                ),
              ),
            ),
            bottomNavigationBar: InkWell(
              onTap: () {
                provider.TagLocationAPIFunction(
                  Homeprovider,
                  context,
                  provider.genHashID,
                );
              },
              child: Container(
                alignment: Alignment.bottomCenter,
                height: 45,
                width: MediaQuery.of(context).size.width,
                margin: EdgeInsets.symmetric(horizontal: 10, vertical: 10),
                decoration: BoxDecoration(
                  color: AppColors.app_blue,
                  borderRadius: BorderRadius.circular(15.0),
                ),
                child: Center(
                  child: Text(
                    "Tag Location",
                    textAlign: TextAlign.center,
                    style: TextStyle(
                      fontFamily: "JakartaMedium",
                      fontSize: 15,
                      color: Colors.white,
                    ),
                  ),
                ),
              ),
            ),
          ),
        );
      },
    );
  }

  Future<void> _showAttachmentSheet(BuildContext context) {
    return showModalBottomSheet(
      useSafeArea: true,
      isDismissible: true,
      isScrollControlled: true,
      showDragHandle: true,
      backgroundColor: Colors.white,
      enableDrag: true,
      context: context,
      builder: (context) {
        return StatefulBuilder(
          builder: (context, setState) {
            return SafeArea(
              child: Consumer<Generatordetailsprovider>(
                builder: (context, provider, child) {
                  return Padding(
                    padding: EdgeInsets.only(
                      bottom:
                          MediaQuery.of(
                            context,
                          ).viewInsets.bottom, // This handles keyboard
                    ),
                    child: Container(
                      margin: EdgeInsets.only(
                        bottom: 15,
                        left: 15,
                        right: 15,
                        top: 10,
                      ),

                      child: SingleChildScrollView(
                        child: Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          mainAxisSize: MainAxisSize.min,
                          children: [
                            Align(
                              alignment: Alignment.center,
                              child: Text(
                                "Select Source",
                                style: TextStyle(
                                  color: AppColors.app_blue,
                                  fontSize: 16,
                                ),
                              ),
                            ),
                            SizedBox(height: 15),

                            InkWell(
                              onTap: () {
                                Navigator.of(context).pop(false);
                                provider.imgFromCamera();
                              },
                              child: SizedBox(
                                height: 35,
                                child: Text("Capture photo from camera"),
                              ),
                            ),
                          ],
                        ),
                      ),
                    ),
                  );
                },
              ),
            );
          },
        );
      },
    );
  }
}
