import 'dart:io';

import 'package:connectivity_plus/connectivity_plus.dart';
import 'package:dotted_line/dotted_line.dart';
import 'package:dropdown_button2/dropdown_button2.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:flutter_svg/svg.dart';
import 'package:generp/Utils/dropdownTheme.dart';
import 'package:generp/screens/notifierExports.dart';
import 'package:generp/Utils/app_colors.dart';
import 'package:generp/Utils/commonWidgets.dart';
import 'package:generp/screens/commom/accountsListDetails.dart';
import 'package:intl/intl.dart';
import 'package:provider/provider.dart';

import '../../Utils/commonServices.dart';
import 'FileViewer.dart';

class Paymentrequestionlistdetails extends StatefulWidget {
  final paymentRequestId;
  final pageName;
  final mode;

  const Paymentrequestionlistdetails({
    super.key,
    required this.mode,
    required this.paymentRequestId,
    required this.pageName,
  });

  @override
  State<Paymentrequestionlistdetails> createState() =>
      _PaymentrequestionlistdetailsState();
}

class _PaymentrequestionlistdetailsState
    extends State<Paymentrequestionlistdetails> {
  Map _source = {ConnectivityResult.mobile: true};
  final MyConnectivity _connectivity = MyConnectivity.instance;

  List<FocusNode> focusNodes = List.generate(10, (index) => FocusNode());
  Dropdowntheme ddtheme = Dropdowntheme();
  TextEditingController approvedAmount = TextEditingController();
  TextEditingController remarks = TextEditingController();

  TextEditingController paymentReferenceNumber = TextEditingController();

  FocusNode requestNode = FocusNode();
  FocusNode approveNode = FocusNode();
  FocusNode remarkNode = FocusNode();
  FocusNode proposedPaymentAmountNode = FocusNode();
  FocusNode paymentReferenceNumberNode = FocusNode();
  FocusNode accountNameNode = FocusNode();
  FocusNode branchNode = FocusNode();
  FocusNode requestingPurposeNode = FocusNode();
  FocusNode descriptionNode = FocusNode();
  FocusNode amountNode = FocusNode();
  FocusNode paymentModeNode = FocusNode();
  FocusNode bankUpiIDNode = FocusNode();
  bool isLevel1Finalized = false;

  bool isLevel2Finalized = false;

  // Final decision on whether to show buttons
  bool shouldShowButtons = false;
  final numberFormat = NumberFormat.decimalPattern();

  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    _connectivity.initialise();
    _connectivity.myStream.listen((source) {
      setState(() => _source = source);
    });
    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
      var provider = Provider.of<Requesitionlidtdetailsprovider>(
        context,
        listen: false,
      );
      provider.showMoreDetails = false;
      provider.checkDropDownReset();
      print(widget.paymentRequestId);
      provider.paymentRequesitionDetails(context, widget.paymentRequestId);
    });
  }

  @override
  void dispose() {
    // TODO: implement dispose
    focusNodes.map((e) => e.dispose());
    _connectivity.disposeStream();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    switch (_source.keys.toList()[0]) {
      case ConnectivityResult.mobile:
        connection = 'Online';
        break;
      case ConnectivityResult.wifi:
        connection = 'Online';
        break;
      case ConnectivityResult.none:
      default:
        connection = 'Offline';
    }
    return (connection == "Online")
        ? Platform.isAndroid
            ? WillPopScope(
              onWillPop: () => onBackPressed(context),
              child: SafeArea(
                top: false,
                bottom: true,
                child: _scaffold1(context),
              ),
            )
            : _scaffold1(context)
        : NoNetwork(context);
  }

  Color getDecorationColor(value) {
    var color = AppColors.approved_bg_color;
    switch (value) {
      case 'Requested':
        return AppColors.requested_bg_color;
      case 'Level 1 Approved':
        return AppColors.approved_bg_color;
      case 'Level 1 Rejected':
        return AppColors.rejected_bg_color;
      case 'Level 2 Approved':
        return AppColors.approved_bg_color;
      case 'Level 2 Rejected':
        return AppColors.rejected_bg_color;
      case 'Processed':
        return AppColors.processed_bg_color;
      case 'Payment Rejected':
        return AppColors.rejected_bg_color;
    }
    return color;
  }

  Color getTextColor(value) {
    var color = AppColors.approved_text_color;
    switch (value) {
      case 'Requested':
        return AppColors.requested_text_color;
      case 'Level 1 Approved':
        return AppColors.approved_text_color;
      case 'Level 1 Rejected':
        return AppColors.rejected_text_color;
      case 'Level 2 Approved':
        return AppColors.approved_text_color;
      case 'Level 2 Rejected':
        return AppColors.rejected_text_color;
      case 'Processed':
        return AppColors.processed_text_color;
      case 'Payment Rejected':
        return AppColors.rejected_text_color;
    }
    return color;
  }

  getText(value) {
    switch (value) {
      case 'Requested':
        return "Requested";
      case 'Level 1 Approved':
        return "L1 Approved";
      case 'Level 1 Rejected':
        return "L1 Rejected";
      case 'Level 2 Approved':
        return "L2 Approved";
      case 'Level 2 Rejected':
        return "L2 Rejected";
      case 'Processed':
        return "Processed";
      case 'Payment Rejected':
        return "Payment Rejected";
      default:
        return "Requested";
    }
  }

  Widget _scaffold(BuildContext context) {
    return Consumer<Requesitionlidtdetailsprovider>(
      builder: (context, provider, child) {
        var reqDet = provider.requestsDetails;
        isLevel1Finalized = [
          "Level 1 Approved",
          "Level 1 Rejected",
          "Level 1 approved",
          "Level 1 rejected",
        ].contains(reqDet.status);

        isLevel2Finalized = [
          "Level 2 Approved",
          "Level 2 Rejected",
          "Level 2 approved",
          "Level 2 rejected",
        ].contains(reqDet.status);
        if (widget.mode == "apr_lvl1") {
          shouldShowButtons = !isLevel1Finalized;
        } else if (widget.mode == "apr_lvl2") {
          shouldShowButtons =
              !isLevel2Finalized &&
              [
                "Requested",
                "Level 1 Approved",
                "Level 1 approved",
              ].contains(reqDet.status);
        } else if (widget.mode == "process") {
          shouldShowButtons = [
            "Level 2 Approved",
            "Level 2 approved",
          ].contains(reqDet.status);
        } else if (widget.mode == "self_apr_lvl2") {
          shouldShowButtons = ["Requested"].contains(reqDet.status);
        }
        return Scaffold(
          resizeToAvoidBottomInset: true,
          appBar: appbar2(
            context,
            widget.pageName,
            provider.resetAll,
            SizedBox(width: 0),
          ),
          backgroundColor: AppColors.scaffold_bg_color,
          body: Container(
            child: SingleChildScrollView(
              child: Container(
                decoration: BoxDecoration(
                  color: Colors.white,
                  borderRadius: BorderRadius.circular(16),
                ),
                margin: EdgeInsets.symmetric(vertical: 10, horizontal: 10),
                padding: EdgeInsets.symmetric(vertical: 10, horizontal: 10),
                child: Column(
                  children: [
                    Row(
                      children: [
                        Expanded(
                          flex: 1,
                          child: Container(
                            height: 50,
                            width: 35,
                            padding: EdgeInsets.all(8.0),
                            decoration: BoxDecoration(
                              color: Color(0xFFFFF3CE),
                              borderRadius: BorderRadius.circular(8),
                            ),
                            child: SvgPicture.asset("assets/svg/fin_ic.svg"),
                          ),
                        ),
                        SizedBox(width: 10),
                        Expanded(
                          flex: 4,
                          child: SizedBox(
                            child: Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: [
                                Text(
                                  reqDet.accountName == ""
                                      ? "-"
                                      : reqDet.accountName ?? "-",
                                  style: TextStyle(
                                    fontFamily: "JakartaMedium",
                                    fontSize: 14,
                                    color: AppColors.semi_black,
                                  ),
                                ),
                                Text(
                                  reqDet.amount == ""
                                      ? "-"
                                      : "₹${reqDet.amount}",
                                  style: TextStyle(
                                    fontFamily: "JakartaMedium",
                                    fontSize: 14,
                                    color: AppColors.app_blue,
                                  ),
                                ),
                              ],
                            ),
                          ),
                        ),
                        Expanded(
                          flex: 2,
                          child: Container(
                            padding: EdgeInsets.symmetric(
                              horizontal: 5,
                              vertical: 10,
                            ),
                            decoration: BoxDecoration(
                              borderRadius: BorderRadius.circular(8),
                              color: Color(0xFFE3FFE0),
                            ),
                            child: Center(
                              child: Text(
                                reqDet.status ?? "-",
                                textAlign: TextAlign.center,
                                style: TextStyle(
                                  fontFamily: "JakartaMedium",
                                  fontSize: 14,
                                  color: Color(0xFF0D9C00),
                                ),
                              ),
                            ),
                          ),
                        ),
                      ],
                    ),
                    Divider(thickness: 0.5, color: Color(0xFFD7D7D7)),
                    ...List.generate(provider.subHeadings.length, (j) {
                      if (provider.Headings[j] == "Attachment" &&
                          reqDet.attachmentViewFileName == "") {
                        return SizedBox.shrink();
                      }
                      return Container(
                        padding: EdgeInsets.symmetric(vertical: 7),
                        child: Row(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: [
                            Expanded(
                              child: Text(
                                provider.Headings[j],
                                style: TextStyle(
                                  fontFamily: "JakartaMedium",
                                  fontSize: 14,
                                  color: AppColors.semi_black,
                                ),
                              ),
                            ),
                            Expanded(
                              child: InkResponse(
                                onTap: () {
                                  if (provider.Headings[j] == "Attachment") {
                                    HapticFeedback.selectionClick();
                                    Navigator.push(
                                      context,
                                      MaterialPageRoute(
                                        builder:
                                            (context) => Fileviewer(
                                              fileName:
                                                  reqDet
                                                      .attachmentViewFileName ??
                                                  "",
                                              fileUrl:
                                                  reqDet
                                                      .attachmentDirFilePath ??
                                                  "",
                                              downloadEnable: true,
                                            ),
                                      ),
                                    );
                                  } else if (provider.Headings[j] ==
                                      "Requested Account") {
                                    HapticFeedback.selectionClick();
                                    Navigator.push(
                                      context,
                                      MaterialPageRoute(
                                        builder:
                                            (context) => Accountslistdetails(
                                              accountID:
                                                  provider
                                                      .requestsDetails
                                                      .accountId,
                                            ),
                                      ),
                                    );
                                  }
                                },
                                child: Text(
                                  ["Attachment"].contains(provider.Headings[j])
                                      ? "View"
                                      : provider.subHeadings[j] == ""
                                      ? "-"
                                      : provider.subHeadings[j],
                                  style: TextStyle(
                                    fontSize: 14,
                                    color:
                                        [
                                              "Attachment",
                                              "Requested Account",
                                            ].contains(provider.Headings[j])
                                            ? AppColors.app_blue
                                            : Color(0xFF818181),
                                    decoration:
                                        [
                                              "Attachment",
                                              "Requested Account",
                                            ].contains(provider.Headings[j])
                                            ? TextDecoration.underline
                                            : TextDecoration.none,
                                    decorationColor:
                                        [
                                              "Attachment",
                                              "Requested Account",
                                            ].contains(provider.Headings[j])
                                            ? AppColors.app_blue
                                            : AppColors.white,
                                  ),
                                ),
                              ),
                            ),
                          ],
                        ),
                      );
                    }),
                    SizedBox(height: 80),
                  ],
                ),
              ),
            ),
          ),
          bottomNavigationBar:
              (["admin", "self"].contains(widget.mode) || !shouldShowButtons)
                  ? Container(height: 0)
                  : Container(
                    margin: EdgeInsets.symmetric(horizontal: 10, vertical: 10),
                    alignment: Alignment.bottomCenter,
                    height: 60,
                    child: Container(
                      margin: EdgeInsets.only(bottom: 10),
                      alignment: Alignment.center,
                      height: 45,
                      child: Row(
                        mainAxisAlignment: MainAxisAlignment.center,
                        children: [
                          Expanded(
                            child: InkResponse(
                              onTap: () {
                                HapticFeedback.selectionClick();
                                print(provider.requestsDetails.id);
                                _showLevelRejectionSheet(
                                  context,
                                  provider.requestsDetails.id,
                                );
                              },
                              child: Container(
                                decoration: BoxDecoration(
                                  borderRadius: BorderRadius.circular(8),
                                  color: Color(0xFFFFEFEF),
                                  border: Border.all(
                                    color: Color(0xFFED3424),
                                    width: 0.5,
                                  ),
                                ),
                                child: Center(
                                  child: Text(
                                    "Reject",
                                    style: TextStyle(color: Color(0xFFED3424)),
                                  ),
                                ),
                              ),
                            ),
                          ),
                          SizedBox(width: 10),
                          if ([
                            "apr_lvl1",
                            "apr_lvl2",
                            "self_apr_lvl2",
                          ].contains(widget.mode)) ...[
                            Expanded(
                              child: InkResponse(
                                onTap: () {
                                  HapticFeedback.selectionClick();
                                  provider
                                      .approveRejectPaymentRequestAPIFunction(
                                        context,
                                        provider.requestsDetails.id,
                                      );
                                  _showLevelApprovalSheet(
                                    context,
                                    provider.requestsDetails.id,
                                  );
                                },
                                child: Container(
                                  decoration: BoxDecoration(
                                    borderRadius: BorderRadius.circular(8),
                                    color: Color(0xFFE7FFE5),
                                    border: Border.all(
                                      color: Color(0xFF0D9C00),
                                      width: 0.5,
                                    ),
                                  ),
                                  child: Center(
                                    child: Text(
                                      "Approve",
                                      style: TextStyle(
                                        color: Color(0xFF0D9C00),
                                      ),
                                    ),
                                  ),
                                ),
                              ),
                            ),
                          ] else if (widget.mode == "process") ...[
                            Expanded(
                              child: InkResponse(
                                onTap: () {
                                  HapticFeedback.selectionClick();
                                  provider
                                      .approveRejectPaymentRequestAPIFunction(
                                        context,
                                        provider.requestsDetails.id,
                                      );
                                  provider.preValues();
                                  _showAddPaymentSheet(
                                    context,
                                    provider.requestsDetails.id,
                                  );
                                },
                                child: Container(
                                  decoration: BoxDecoration(
                                    borderRadius: BorderRadius.circular(8),
                                    color: Color(0xFFE7FFE5),
                                    border: Border.all(
                                      color: Color(0xFF0D9C00),
                                      width: 0.5,
                                    ),
                                  ),
                                  child: Center(
                                    child: Text(
                                      "Add Payment",
                                      style: TextStyle(
                                        color: Color(0xFF0D9C00),
                                      ),
                                    ),
                                  ),
                                ),
                              ),
                            ),
                          ],
                        ],
                      ),
                    ),
                  ),
          floatingActionButtonLocation:
              FloatingActionButtonLocation.centerFloat,
          // bottomNavigationBar:
          //     (["admin", "self"].contains(widget.mode))
          //         ? Container(height: 0)
          //         : ([
          //           "Level 1 Approved",
          //           "Level 1 Rejected",
          //           "Level 1 approved",
          //           "Level 1 rejected",
          //           "Level 2 Approved",
          //           "Level 2 Rejected",
          //           "Level 2 approved",
          //           "Level 2 rejected",
          //         ]).contains(req_det.status)
          //         ? SizedBox(height: 0)
          //         : Container(
          //           margin: EdgeInsets.symmetric(horizontal: 10),
          //           alignment: Alignment.bottomCenter,
          //           height: 60,
          //           child: Container(
          //             margin: EdgeInsets.only(bottom: 10),
          //             alignment: Alignment.center,
          //             height: 45,
          //             child: Row(
          //               mainAxisAlignment: MainAxisAlignment.center,
          //               children: [
          //                 Expanded(
          //                   child: InkResponse(
          //                     onTap: () {
          //                       _showLevelRejectionSheet(context);
          //                     },
          //                     child: Container(
          //                       decoration: BoxDecoration(
          //                         borderRadius: BorderRadius.circular(8),
          //                         color: Color(0xFFFFEFEF),
          //                         border: Border.all(
          //                           color: Color(0xFFED3424),
          //                           width: 0.5,
          //                         ),
          //                       ),
          //                       child: Center(
          //                         child: Text(
          //                           "Reject",
          //                           style: TextStyle(
          //                             color: Color(0xFFED3424),
          //                           ),
          //                         ),
          //                       ),
          //                     ),
          //                   ),
          //                 ),
          //                 SizedBox(width: 10),
          //                 if ([
          //                   "apr_lvl1",
          //                   "apr_lvl2",
          //                 ].contains(widget.mode)) ...[
          //                   Expanded(
          //                     child: InkResponse(
          //                       onTap: () {
          //                         provider
          //                             .approveRejectPaymentRequestAPIFunction(
          //                               context,
          //                               provider.requestsDetails.id,
          //                             );
          //                         _showLevelApprovalSheet(context);
          //                       },
          //                       child: Container(
          //                         decoration: BoxDecoration(
          //                           borderRadius: BorderRadius.circular(8),
          //                           color: Color(0xFFE7FFE5),
          //                           border: Border.all(
          //                             color: Color(0xFF0D9C00),
          //                             width: 0.5,
          //                           ),
          //                         ),
          //                         child: Center(
          //                           child: Text(
          //                             "Approve",
          //                             style: TextStyle(
          //                               color: Color(0xFF0D9C00),
          //                             ),
          //                           ),
          //                         ),
          //                       ),
          //                     ),
          //                   ),
          //                 ] else if (widget.mode == "process") ...[
          //                   Expanded(
          //                     child: InkResponse(
          //                       onTap: () {
          //                         provider
          //                             .approveRejectPaymentRequestAPIFunction(
          //                               context,
          //                               provider.requestsDetails.id,
          //                             );
          //                         _showAddPaymentSheet(context);
          //                       },
          //                       child: Container(
          //                         decoration: BoxDecoration(
          //                           borderRadius: BorderRadius.circular(8),
          //                           color: Color(0xFFE7FFE5),
          //                           border: Border.all(
          //                             color: Color(0xFF0D9C00),
          //                             width: 0.5,
          //                           ),
          //                         ),
          //                         child: Center(
          //                           child: Text(
          //                             "Add Payment",
          //                             style: TextStyle(
          //                               color: Color(0xFF0D9C00),
          //                             ),
          //                           ),
          //                         ),
          //                       ),
          //                     ),
          //                   ),
          //                 ],
          //               ],
          //             ),
          //           ),
          //         ),
        );
      },
    );
  }

  Widget _scaffold1(BuildContext context) {
    return Consumer<Requesitionlidtdetailsprovider>(
      builder: (context, provider, child) {
        var reqDet = provider.requestsDetails;
        var payDet = provider.paymentsDetails;
        isLevel1Finalized = [
          "Level 1 Approved",
          "Level 1 Rejected",
          "Level 1 approved",
          "Level 1 rejected",
        ].contains(reqDet.status);

        isLevel2Finalized = [
          "Level 2 Approved",
          "Level 2 Rejected",
          "Level 2 approved",
          "Level 2 rejected",
        ].contains(reqDet.status);
        if (widget.mode == "apr_lvl1") {
          shouldShowButtons = !isLevel1Finalized;
        } else if (widget.mode == "apr_lvl2") {
          shouldShowButtons =
              !isLevel2Finalized &&
              [
                "Requested",
                "Level 1 Approved",
                "Level 1 approved",
              ].contains(reqDet.status);
        } else if (widget.mode == "process") {
          shouldShowButtons = [
            "Level 2 Approved",
            "Level 2 approved",
          ].contains(reqDet.status);
        } else if (widget.mode == "self_apr_lvl2") {
          shouldShowButtons = ["Requested"].contains(reqDet.status);
        }

        final headings2 = [
          "Proposed Payment Account",
          "Requesting Purpose",
          "Requested Amount",
          "Approved Amount",
          "Requested Date",
        ];
        final subHeadings2 = [
          reqDet.proposedAccount ?? "-",
          reqDet.requestingPurpose ?? "-",
          reqDet.requestedAmount ?? "-",
          reqDet.amount ?? "-",
          reqDet.date ?? "-",
        ];

        final headings3 = [
          "Account Name",
          "Payment Account",
          "Payment Mode",
          "Employee",
          "Amount",
          "Payment Date",
          "Attachment",
        ];
        final subHeadings3 = [
          payDet.accountName ?? "-",
          payDet.paymentAccountName ?? "-",
          payDet.mode ?? "-",
          payDet.paymentEmployeeName ?? "-",
          reqDet.amount ?? "-",
          reqDet.date ?? "-",
          "View",
        ];
        final headings4 = [
          "Bank Name",
          "Account Holder Name",
          "Account Number",
          "Branch",
          "IFSC",
          "UPI ID",
        ];
        final subHeadings4 = [
          payDet.bankName ?? "-",
          payDet.bankAccountHolderName ?? "-",
          payDet.bankAccountNumber ?? "-",
          payDet.bankBranchName ?? "-",
          payDet.bankIfscCode ?? "-",
          payDet.bankUpiId ?? "-",
        ];
        final headings5 = [
          "Level 1 Approved By",
          "Level 1 Remarks",
          "Level 2 Approved By",
          "Level 2 Remarks",
        ];
        final subHeadings5 = [
          reqDet.level1Employee ?? "-",
          reqDet.level1ApprovalRemarks ?? "-",
          reqDet.level2Employee ?? "-",
          reqDet.level2ApprovalRemarks ?? "-",
        ];
        final headings6 = ["Note", "Created Employee"];
        final subHeadings6 = [
          reqDet.description ?? "-",
          reqDet.createdEmployee ?? "-",
        ];

        final sections = [
          {
            "title": "Account Details",
            "headings": headings2,
            "subHeadings": subHeadings2,
          },
          if (provider.showMoreDetails) ...[
            {
              "title": "Request Details",
              "headings": headings3,
              "subHeadings": subHeadings3,
            },
            {
              "title": "Bank Details",
              "headings": headings4,
              "subHeadings": subHeadings4,
            },
            {
              "title": "Approval Details",
              "headings": headings5,
              "subHeadings": subHeadings5,
            },
            {
              "title": "Other Details",
              "headings": headings6,
              "subHeadings": subHeadings6,
            },
          ],
        ];

        return Scaffold(
          resizeToAvoidBottomInset: true,
          appBar: appbar2New(
            context,
            widget.pageName,
            provider.resetAll,
            SizedBox(width: 0),
            0xFFFFFFFF,
          ),
          backgroundColor: AppColors.scaffold_bg_color,
          body: SingleChildScrollView(
            child: Card(
              shape: RoundedRectangleBorder(
                borderRadius: BorderRadius.only(
                  bottomLeft: Radius.circular(30),
                  bottomRight: Radius.circular(30),
                ),
              ),
              elevation: 2,
              child: Container(
                decoration: BoxDecoration(
                  color: Colors.white,
                  borderRadius: BorderRadius.only(
                    bottomLeft: Radius.circular(30),
                    bottomRight: Radius.circular(30),
                  ),
                ),
                // margin: EdgeInsets.symmetric(vertical: 10, horizontal: 10),
                padding: EdgeInsets.symmetric(vertical: 10, horizontal: 10),
                child: Column(
                  children: [
                    Row(
                      children: [
                        Expanded(
                          flex: 1,
                          child: Container(
                            height: 45,
                            width: 45,
                            padding: EdgeInsets.all(7.5),
                            decoration: BoxDecoration(
                              color: Color(0xFFE6F6FF),
                              shape: BoxShape.circle,
                              // borderRadius: BorderRadius.circular(8),
                            ),
                            child: SvgPicture.asset("assets/svg/fin_ic.svg"),
                          ),
                        ),
                        SizedBox(width: 10),
                        Expanded(
                          flex: 4,
                          child: SizedBox(
                            child: Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: [
                                InkResponse(
                                  onTap: () {
                                    Navigator.push(
                                      context,
                                      MaterialPageRoute(
                                        builder:
                                            (context) => Accountslistdetails(
                                              accountID:
                                                  provider
                                                      .requestsDetails
                                                      .accountId,
                                            ),
                                      ),
                                    );
                                  },
                                  child: Padding(
                                    padding: const EdgeInsets.only(
                                      top: 8.0,
                                      bottom: 4,
                                    ),
                                    child: Text(
                                      reqDet.accountName == ""
                                          ? "-"
                                          : reqDet.accountName ?? "-",
                                      style: TextStyle(
                                        decoration: TextDecoration.underline,
                                        decorationStyle:
                                            TextDecorationStyle.dotted,
                                        decorationColor: AppColors.grey_thick,
                                        height: 1.2,
                                        fontFamily: "JakartaRegular",
                                        fontSize: 14,
                                        color: AppColors.semi_black,
                                      ),
                                    ),
                                  ),
                                ),
                                Text(
                                  reqDet.amount == ""
                                      ? "-"
                                      : "₹${reqDet.amount}",
                                  style: TextStyle(
                                    fontFamily: "JakartaRegular",
                                    fontSize: 14,
                                    color: AppColors.app_blue,
                                  ),
                                ),
                              ],
                            ),
                          ),
                        ),
                        Expanded(
                          flex: 2,
                          child: Container(
                            padding: EdgeInsets.symmetric(
                              horizontal: 5,
                              vertical: 10,
                            ),
                            decoration: BoxDecoration(
                              borderRadius: BorderRadius.circular(8),
                              color: getDecorationColor(reqDet.status ?? "-"),
                            ),
                            child: Center(
                              child: Text(
                                getText(reqDet.status ?? "-"),
                                textAlign: TextAlign.center,
                                style: TextStyle(
                                  fontFamily: "JakartaMedium",
                                  fontSize: 13,
                                  color: getTextColor(reqDet.status),
                                ),
                              ),
                            ),
                          ),
                        ),
                      ],
                    ),
                    SizedBox(height: 10),
                    Column(
                      children: List.generate(sections.length, (sectionIndex) {
                        final section = sections[sectionIndex];
                        final title = section["title"] as String;
                        final headings = section["headings"] as List<String>;
                        final subHeadings =
                            section["subHeadings"] as List<String>;

                        return Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: [
                            Container(
                              padding: EdgeInsets.symmetric(vertical: 4),
                              child: Row(
                                children: [
                                  Expanded(
                                    flex: 3,
                                    child: Text(
                                      title,
                                      style: TextStyle(
                                        fontSize: 14,
                                        fontFamily: "JakartaSemiBold",
                                      ),
                                    ),
                                  ),
                                  Expanded(
                                    flex: 6,
                                    child: DottedLine(
                                      dashGapLength: 4,
                                      dashGapColor: Colors.white,
                                      dashColor: AppColors.grey_semi,
                                      dashLength: 2,
                                      lineThickness: 0.5,
                                    ),
                                  ),
                                ],
                              ),
                            ),

                            Column(
                              children: List.generate(headings.length, (j) {
                                if (provider.Headings[j] == "Attachment" &&
                                    reqDet.attachmentViewFileName == "") {
                                  return SizedBox.shrink();
                                }
                                return Container(
                                  padding: EdgeInsets.symmetric(vertical: 7),
                                  child: Row(
                                    crossAxisAlignment:
                                        CrossAxisAlignment.start,
                                    children: [
                                      Expanded(
                                        child: Text(
                                          headings[j],
                                          style: TextStyle(
                                            fontFamily: "JakartaRegular",
                                            fontSize: 14,
                                            color: AppColors.semi_black,
                                          ),
                                        ),
                                      ),
                                      Expanded(
                                        child: InkResponse(
                                          onTap:
                                              subHeadings[j] == "View"
                                                  ? () {
                                                    Navigator.push(
                                                      context,
                                                      MaterialPageRoute(
                                                        builder:
                                                            (
                                                              context,
                                                            ) => Fileviewer(
                                                              fileName:
                                                                  reqDet
                                                                      .attachmentViewFileName ??
                                                                  "",
                                                              fileUrl:
                                                                  reqDet
                                                                      .attachmentDirFilePath ??
                                                                  "",
                                                              downloadEnable: true,
                                                            ),
                                                      ),
                                                    );
                                                  }
                                                  : null,
                                          child: Text(
                                            subHeadings[j].isEmpty
                                                ? "-"
                                                : subHeadings[j],
                                            style: TextStyle(
                                              fontSize: 14,
                                              decoration:
                                                  subHeadings[j] == "View"
                                                      ? TextDecoration.underline
                                                      : TextDecoration.none,
                                              decorationColor:
                                                  AppColors.app_blue,
                                              color:
                                                  subHeadings[j] == "View"
                                                      ? AppColors.app_blue
                                                      : Color(0xFF818181),
                                            ),
                                          ),
                                        ),
                                      ),
                                    ],
                                  ),
                                );
                              }),
                            ),
                          ],
                        );
                      }),
                    ),

                    InkResponse(
                      onTap: () async {
                        provider.showMoreDetails = !provider.showMoreDetails;
                      },
                      child: Container(
                        padding: EdgeInsets.symmetric(vertical: 5),
                        child: Row(
                          crossAxisAlignment: CrossAxisAlignment.center,
                          mainAxisAlignment: MainAxisAlignment.center,
                          children: [
                            Text(
                              provider.showMoreDetails
                                  ? "Hide Details"
                                  : "View Details",
                              style: TextStyle(
                                fontFamily: "JakartaMedium",
                                fontSize: 14,
                                color: AppColors.app_blue,
                              ),
                            ),
                            Transform.flip(
                              flipY: provider.showMoreDetails ? true : false,
                              child: SvgPicture.asset(
                                "assets/svg/arrow_dropdown.svg",
                                height: 25,
                                width: 20,
                                color: AppColors.app_blue,
                              ),
                            ),
                          ],
                        ),
                      ),
                    ),
                    SizedBox(height: 25),
                  ],
                ),
              ),
            ),
          ),
          bottomNavigationBar:
              (["admin", "self"].contains(widget.mode) || !shouldShowButtons)
                  ? SizedBox.shrink()
                  : Container(
                    decoration: BoxDecoration(color: Colors.white),
                    padding: EdgeInsets.symmetric(horizontal: 10, vertical: 10),
                    alignment: Alignment.bottomCenter,
                    height: 78,
                    child: Container(
                      margin: EdgeInsets.only(bottom: 10),
                      alignment: Alignment.center,
                      height: 42,
                      child: Row(
                        mainAxisAlignment: MainAxisAlignment.center,
                        children: [
                          Expanded(
                            child: InkResponse(
                              onTap: () {
                                print(provider.requestsDetails.id);
                                _showLevelRejectionSheet(
                                  context,
                                  provider.requestsDetails.id,
                                );
                              },
                              child: Container(
                                alignment: Alignment.center,
                                // decoration: BoxDecoration(
                                //   borderRadius: BorderRadius.circular(8),
                                //   color: Color(0xFFFFEFEF),
                                //   border: Border.all(
                                //     color: Color(0xFFED3424),
                                //     width: 0.5,
                                //   ),
                                // ),
                                child: Row(
                                  mainAxisAlignment: MainAxisAlignment.center,
                                  children: [
                                    SvgPicture.asset(
                                      "assets/svg/finance/level_reject_ic.svg",
                                    ),
                                    SizedBox(width: 5),
                                    Center(
                                      child: Text(
                                        "Reject",
                                        style: TextStyle(
                                          color: AppColors.semi_black,
                                          fontSize: 12,
                                        ),
                                      ),
                                    ),
                                  ],
                                ),
                              ),
                            ),
                          ),
                          SizedBox(width: 4),

                          if ([
                            "apr_lvl1",
                            "apr_lvl2",
                            "self_apr_lvl2",
                          ].contains(widget.mode)) ...[
                            SvgPicture.asset(
                              "assets/svg/crm/vertical_line_ic.svg",
                            ),
                            SizedBox(width: 4),
                            Expanded(
                              child: InkResponse(
                                onTap: () {
                                  provider
                                      .approveRejectPaymentRequestAPIFunction(
                                        context,
                                        provider.requestsDetails.id,
                                      );
                                  _showLevelApprovalSheet(
                                    context,
                                    provider.requestsDetails.id,
                                  );
                                },
                                child: Container(
                                  alignment: Alignment.center,
                                  // decoration: BoxDecoration(
                                  //   borderRadius: BorderRadius.circular(8),
                                  //   color: Color(0xFFE7FFE5),
                                  //   border: Border.all(
                                  //     color: Color(0xFF0D9C00),
                                  //     width: 0.5,
                                  //   ),
                                  // ),
                                  child: Row(
                                    mainAxisAlignment: MainAxisAlignment.center,
                                    children: [
                                      SvgPicture.asset(
                                        "assets/svg/finance/level_approve_ic.svg",
                                      ),
                                      SizedBox(width: 5),
                                      Center(
                                        child: Text(
                                          "Approve",
                                          style: TextStyle(
                                            color: AppColors.semi_black,
                                            fontSize: 12,
                                          ),
                                        ),
                                      ),
                                    ],
                                  ),
                                ),
                              ),
                            ),
                            SizedBox(width: 4),
                          ] else if (widget.mode == "process") ...[
                            SvgPicture.asset(
                              "assets/svg/crm/vertical_line_ic.svg",
                            ),
                            SizedBox(width: 5),
                            Expanded(
                              child: InkResponse(
                                onTap: () {
                                  provider
                                      .approveRejectPaymentRequestAPIFunction(
                                        context,
                                        provider.requestsDetails.id,
                                      );
                                  provider.preValues();
                                  _showAddPaymentSheet(
                                    context,
                                    provider.requestsDetails.id,
                                  );
                                },
                                child: Container(
                                  alignment: Alignment.center,
                                  // decoration: BoxDecoration(
                                  //   borderRadius: BorderRadius.circular(8),
                                  //   color: Color(0xFFE7FFE5),
                                  //   border: Border.all(
                                  //     color: Color(0xFF0D9C00),
                                  //     width: 0.5,
                                  //   ),
                                  // ),
                                  child: Row(
                                    mainAxisAlignment: MainAxisAlignment.center,
                                    children: [
                                      SvgPicture.asset(
                                        "assets/svg/finance/level_add_payment_ic.svg",
                                      ),
                                      SizedBox(width: 2),
                                      Center(
                                        child: Text(
                                          "Add Payment",
                                          style: TextStyle(
                                            color: AppColors.semi_black,
                                            fontSize: 12,
                                          ),
                                        ),
                                      ),
                                    ],
                                  ),
                                ),
                              ),
                            ),
                            SizedBox(width: 6),
                            SvgPicture.asset(
                              "assets/svg/crm/vertical_line_ic.svg",
                            ),
                            SizedBox(width: 6),
                            Expanded(
                              child: InkResponse(
                                onTap: () {
                                  // provider
                                  //     .approveRejectPaymentRequestAPIFunction(
                                  //   context,
                                  //   provider.requestsDetails.id,
                                  // );
                                  provider.editPrevalues();
                                  _showEditPaymentSheet(
                                    context,
                                    provider.requestsDetails.id,
                                  );
                                },
                                child: Container(
                                  alignment: Alignment.center,

                                  child: Row(
                                    mainAxisAlignment: MainAxisAlignment.center,
                                    children: [
                                      SvgPicture.asset(
                                        "assets/svg/crm/lead_details_edit_ic.svg",
                                      ),
                                      SizedBox(width: 5),
                                      Center(
                                        child: Text(
                                          "Edit Amount",
                                          style: TextStyle(
                                            color: AppColors.semi_black,
                                            fontSize: 12,
                                          ),
                                        ),
                                      ),
                                    ],
                                  ),
                                ),
                              ),
                            ),
                          ],
                        ],
                      ),
                    ),
                  ),
          floatingActionButtonLocation:
              FloatingActionButtonLocation.centerFloat,
        );
      },
    );
  }

  Future<void> _showLevelApprovalSheet(BuildContext context, paymentID) {
    return showModalBottomSheet(
      useSafeArea: true,
      isDismissible: true,
      isScrollControlled: true,
      showDragHandle: true,
      backgroundColor: Colors.white,
      enableDrag: true,
      context: context,
      builder: (context) {
        return StatefulBuilder(
          builder: (context, setState) {
            return SafeArea(
              child: Consumer<Requesitionlidtdetailsprovider>(
                builder: (context, provider, child) {
                  return Container(
                    margin: EdgeInsets.only(
                      bottom: 15,
                      left: 15,
                      right: 15,
                      top: 10,
                    ),
                    padding: EdgeInsets.only(
                      bottom: MediaQuery.of(context).viewInsets.bottom,
                    ),
                    child: SingleChildScrollView(
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        mainAxisSize: MainAxisSize.min,
                        children: [
                          if (widget.mode == "apr_lvl1") ...[
                            Align(
                              alignment: Alignment.topLeft,
                              child: Text(
                                "Level 1 Approval",
                                style: TextStyle(
                                  color: AppColors.app_blue,
                                  fontSize: 16,
                                ),
                              ),
                            ),
                          ] else if (widget.mode == "apr_lvl2") ...[
                            Align(
                              alignment: Alignment.topLeft,
                              child: Text(
                                "Level 2 Approval",
                                style: TextStyle(
                                  color: AppColors.app_blue,
                                  fontSize: 16,
                                ),
                              ),
                            ),
                          ],

                          textControllerReadonlyWidget(
                            context,
                            provider.requestedAmount,
                            "Enter Requested Amount",
                                (p0) {},
                          ),
                          textControllerWidget(
                            context,
                            provider.approvedAmount,
                            "Approved Amount",
                            "Enter Approved Amount",
                                (p0) {
                              provider.onChangeApprov(p0);
                            },
                            TextInputType.numberWithOptions(),
                            false,
                            null,
                            focusNodes[0],
                            focusNodes[1],
                            TextInputAction.next,
                          ),
                          errorWidget(context, provider.ApprovedAmountError),
                          textControllerWidget(
                            context,
                            remarks,
                            "Remarks",
                            "Enter Remarks",
                                (p0) {
                              provider.remarksError = null;
                              provider.notifyListeners();
                            },
                            TextInputType.text,
                            false,
                            null,
                            focusNodes[1],
                            null,
                            TextInputAction.done,
                          ),
                          errorWidget(context, provider.remarksError),
                          TextWidget(context, "Proposed Payment Account"),
                          DropdownButtonHideUnderline(
                            child: Row(
                              children: [
                                Expanded(
                                  child: DropdownButton2<PaymentAccounts>(
                                    isExpanded: true,
                                    hint: Text(
                                      'Select Payment Account',
                                      style: TextStyle(fontSize: 14),
                                      overflow: TextOverflow.ellipsis,
                                    ),
                                    items: provider.paymentsAccounts
                                        .map(
                                          (paymenents) => DropdownMenuItem<
                                          PaymentAccounts>(
                                        value: paymenents,
                                        child: Text(
                                          paymenents.name ?? '',
                                          style: const TextStyle(
                                            fontSize: 14,
                                          ),
                                          overflow: TextOverflow.ellipsis,
                                        ),
                                      ),
                                    )
                                        .toList(),
                                    value: provider.paymentsAccounts.contains(
                                      provider.selectedPaymentAccounts,
                                    )
                                        ? provider.selectedPaymentAccounts
                                        : null,
                                    onChanged: provider.isLoading
                                        ? null // Disable dropdown when loading
                                        : (PaymentAccounts? value) {
                                      if (value != null) {
                                        if (provider.paymentsAccounts.isNotEmpty) {
                                          provider.selectedPaymentAccounts = value;
                                          print(
                                            "Selected Complaint Type: ${value.name}, ID: ${value.id}",
                                          );
                                          provider.selectedID = value.id!;
                                          provider.selectedValue = value.name!;
                                          print(
                                            "hfjkshfg" + provider.selectedID.toString(),
                                          );
                                        }
                                      }
                                    },
                                    dropdownSearchData: DropdownSearchData(
                                      searchInnerWidgetHeight: 50,
                                      searchController: provider.paymentAccountSearchController,
                                      searchInnerWidget: Padding(
                                        padding: const EdgeInsets.all(8),
                                        child: TextFormField(
                                          controller: provider.paymentAccountSearchController,
                                          decoration: InputDecoration(
                                            isDense: true,
                                            contentPadding: const EdgeInsets.symmetric(
                                              horizontal: 10,
                                              vertical: 8,
                                            ),
                                            hintText: 'Search account...',
                                            border: OutlineInputBorder(
                                              borderRadius: BorderRadius.circular(8),
                                            ),
                                          ),
                                        ),
                                      ),
                                      searchMatchFn: (item, searchValue) {
                                        return item.value?.name
                                            ?.toLowerCase()
                                            .contains(
                                          searchValue.toLowerCase(),
                                        ) ??
                                            false;
                                      },
                                    ),
                                    onMenuStateChange: (isOpen) {
                                      if (!isOpen) {
                                        provider.paymentAccountSearchController.clear();
                                      }
                                    },
                                    buttonStyleData: ddtheme.buttonStyleData,
                                    iconStyleData: ddtheme.iconStyleData,
                                    menuItemStyleData: ddtheme.menuItemStyleData,
                                    dropdownStyleData: ddtheme.dropdownStyleData,
                                  ),
                                ),
                              ],
                            ),
                          ),
                          errorWidget(
                            context,
                            provider.selectpaymentAccountError,
                          ),
                          const SizedBox(height: 10),
                          InkWell(
                            onTap: () {
                              if (provider.isLoading) {
                                print("⏸️ Button is loading - ignoring tap");
                                return;
                              }

                              print("🖱️ === SUBMIT BUTTON TAPPED ===");
                              print("📋 Mode: ${widget.mode}");
                              print("📋 Payment ID: $paymentID");
                              print("📋 Approved Amount: ${provider.approvedAmount.text}");
                              print("📋 Remarks: ${remarks.text}");
                              print("📋 Selected Account ID: ${provider.selectedID}");

                              HapticFeedback.selectionClick();

                              // Close keyboard
                              FocusScope.of(context).unfocus();

                              provider.paymentrequisitionApproveSubmitAPIFunction(
                                context,
                                widget.mode,
                                paymentID,
                                provider.approvedAmount.text,
                                remarks.text,
                                provider.selectedID,
                              );
                            },
                            child: Container(
                              alignment: Alignment.center,
                              height: 45,
                              margin: EdgeInsets.only(
                                left: 5.0,
                                right: 5.0,
                                top: 5.0,
                                bottom: 5.0,
                              ),
                              decoration: BoxDecoration(
                                color: provider.isLoading ? Colors.grey : AppColors.app_blue,
                                borderRadius: BorderRadius.circular(14.0),
                              ),
                              child: Center(
                                child: provider.isLoading
                                    ? Row(
                                  mainAxisAlignment: MainAxisAlignment.center,
                                  children: [
                                    SizedBox(
                                      height: 20,
                                      width: 20,
                                      child: CircularProgressIndicator(
                                        strokeWidth: 2,
                                        valueColor: AlwaysStoppedAnimation<Color>(Colors.white),
                                      ),
                                    ),
                                    SizedBox(width: 10),
                                    Text(
                                      "Processing...",
                                      textAlign: TextAlign.center,
                                      style: TextStyle(
                                        color: Colors.white,
                                        fontSize: 16,
                                      ),
                                    ),
                                  ],
                                )
                                    : Text(
                                  "Submit",
                                  textAlign: TextAlign.center,
                                  style: TextStyle(
                                    color: Colors.white,
                                    fontSize: 16,
                                    fontWeight: FontWeight.bold,
                                  ),
                                ),
                              ),
                            ),
                          ),
                        ],
                      ),
                    ),
                  );
                },
              ),
            );
          },
        );
      },
    );
  }

  Future<void> _showLevelRejectionSheet(BuildContext context, paymentID) {
    return showModalBottomSheet(
      useSafeArea: true,
      isDismissible: true,
      isScrollControlled: true,
      showDragHandle: true,
      backgroundColor: Colors.white,
      enableDrag: true,
      context: context,
      builder: (context) {
        // Remove StatefulBuilder and use only Provider
        return SafeArea(
          child: Consumer<Requesitionlidtdetailsprovider>(
            builder: (context, provider, child) {
              return Container(
                margin: EdgeInsets.only(
                  bottom: 15,
                  left: 15,
                  right: 15,
                  top: 10,
                ),
                padding: EdgeInsets.only(
                  bottom: MediaQuery.of(context).viewInsets.bottom,
                ),
                child: SingleChildScrollView(
                  child: Column(
                    mainAxisSize: MainAxisSize.min,
                    children: [
                      if (widget.mode == "apr_lvl1") ...[
                        Align(
                          alignment: Alignment.topLeft,
                          child: Text(
                            "Level 1 Rejection",
                            style: TextStyle(
                              color: AppColors.app_blue,
                              fontSize: 16,
                            ),
                          ),
                        ),
                      ] else if (widget.mode == "apr_lvl2") ...[
                        Align(
                          alignment: Alignment.topLeft,
                          child: Text(
                            "Level 2 Rejection",
                            style: TextStyle(
                              color: AppColors.app_blue,
                              fontSize: 16,
                            ),
                          ),
                        ),
                      ],

                      textControllerReadonlyWidget(
                        context,
                        provider.requestedAmount,
                        "Requested Amount",
                            (p0) {},
                      ),

                      textControllerWidget(
                        context,
                        remarks,
                        "Remarks",
                        "Enter Remarks",
                            (p0) {
                          provider.remarksError = null;
                          provider.notifyListeners();
                        },
                        TextInputType.text,
                        false,
                        null,
                        focusNodes[2],
                        null,
                        TextInputAction.done,
                      ),
                      errorWidget(context, provider.remarksError),
                      const SizedBox(height: 10),
                      InkWell(
                        onTap: () {
                          if (provider.isLoading) {
                            print("⏸️ Reject button is loading - ignoring tap");
                            return;
                          }

                          print("🖱️ === REJECT BUTTON TAPPED ===");
                          print("📋 Mode: ${widget.mode}");
                          print("📋 Payment ID: $paymentID");
                          print("📋 Remarks: ${remarks.text}");

                          HapticFeedback.selectionClick();

                          // Close keyboard
                          FocusScope.of(context).unfocus();

                          provider.paymentrequisitionRejectSubmitAPIFunction(
                            context,
                            widget.mode,
                            paymentID,
                            remarks.text,
                          );
                          remarks.clear();
                        },
                        child: Container(
                          alignment: Alignment.center,
                          height: 45,
                          margin: EdgeInsets.only(
                            left: 5.0,
                            right: 5.0,
                            top: 5.0,
                            bottom: 5.0,
                          ),
                          decoration: BoxDecoration(
                            color: provider.isLoading ? Colors.grey : AppColors.app_blue,
                            borderRadius: BorderRadius.circular(14.0),
                          ),
                          child: Center(
                            child: provider.isLoading
                                ? Row(
                              mainAxisAlignment: MainAxisAlignment.center,
                              children: [
                                SizedBox(
                                  height: 20,
                                  width: 20,
                                  child: CircularProgressIndicator(
                                    strokeWidth: 2,
                                    valueColor: AlwaysStoppedAnimation<Color>(Colors.white),
                                  ),
                                ),
                                SizedBox(width: 10),
                                Text(
                                  "Processing...",
                                  textAlign: TextAlign.center,
                                  style: TextStyle(
                                    color: Colors.white,
                                    fontSize: 16,
                                  ),
                                ),
                              ],
                            )
                                : Text(
                              "Submit",
                              textAlign: TextAlign.center,
                              style: TextStyle(
                                color: Colors.white,
                                fontSize: 16,
                                fontWeight: FontWeight.bold,
                              ),
                            ),
                          ),
                        ),
                      ),
                    ],
                  ),
                ),
              );
            },
          ),
        );
      },
    );
  }

  // Future<void> _showAddPaymentSheet1(BuildContext context, paymentID) {
  //   return showModalBottomSheet(
  //     useSafeArea: true,
  //     isDismissible: true,
  //     isScrollControlled: true,
  //     showDragHandle: true,
  //     backgroundColor: Colors.white,
  //     enableDrag: true,
  //     context: context,
  //     builder: (context) {
  //       return StatefulBuilder(
  //         builder: (context, setState) {
  //           return SafeArea(
  //             child: Consumer<Requesitionlidtdetailsprovider>(
  //               builder: (context, provider, child) {
  //                 return Scaffold(
  //                   body: Container(
  //                     margin: EdgeInsets.only(
  //                       bottom: 15,
  //                       left: 15,
  //                       right: 15,
  //                       top: 10,
  //                     ),
  //                     padding: EdgeInsets.only(
  //                       bottom: MediaQuery.of(context).viewInsets.bottom,
  //                     ),
  //
  //                     child: Column(
  //                       children: [
  //                         Row(
  //                           children: [
  //                             Expanded(
  //                               child: SizedBox(
  //                                 child: Column(
  //                                   crossAxisAlignment:
  //                                       CrossAxisAlignment.start,
  //                                   mainAxisSize: MainAxisSize.min,
  //                                   children: [
  //                                     Align(
  //                                       alignment: Alignment.topLeft,
  //                                       child: Text(
  //                                         "Add Approval",
  //                                         style: TextStyle(
  //                                           color: AppColors.app_blue,
  //                                           fontSize: 16,
  //                                         ),
  //                                       ),
  //                                     ),
  //
  //                                     textControllerReadonlyWidget(
  //                                       context,
  //                                       provider.proposedPaymentAccount,
  //                                       "Enter Proposed Payment Account",
  //                                       (p0) {},
  //                                     ),
  //
  //                                     TextWidget(context, "Payment Account"),
  //                                     DropdownButtonHideUnderline(
  //                                       child: Row(
  //                                         children: [
  //                                           Expanded(
  //                                             child: DropdownButton2<
  //                                               PaymentAccounts
  //                                             >(
  //                                               isExpanded: true,
  //                                               hint: Text(
  //                                                 'Select Account',
  //                                                 style: TextStyle(
  //                                                   fontSize: 14,
  //                                                 ),
  //                                                 overflow:
  //                                                     TextOverflow.ellipsis,
  //                                               ),
  //                                               items:
  //                                                   provider.paymentsAccounts
  //                                                       .map(
  //                                                         (
  //                                                           paymenents,
  //                                                         ) => DropdownMenuItem<
  //                                                           PaymentAccounts
  //                                                         >(
  //                                                           value: paymenents,
  //                                                           child: Text(
  //                                                             paymenents.name ??
  //                                                                 '',
  //                                                             style:
  //                                                                 const TextStyle(
  //                                                                   fontSize:
  //                                                                       14,
  //                                                                 ),
  //                                                             overflow:
  //                                                                 TextOverflow
  //                                                                     .ellipsis,
  //                                                           ),
  //                                                         ),
  //                                                       )
  //                                                       .toList(),
  //                                               value:
  //                                                   provider
  //                                                       .selectedPaymentAccounts,
  //                                               onChanged: (
  //                                                 PaymentAccounts? value,
  //                                               ) {
  //                                                 if (value != null) {
  //                                                   if (provider
  //                                                       .paymentsAccounts
  //                                                       .isNotEmpty) {
  //                                                     provider.selectedPaymentAccounts =
  //                                                         value;
  //                                                     print(
  //                                                       "Selected Complaint Type: ${value.name}, ID: ${value.id}",
  //                                                     );
  //                                                     provider.selectedID =
  //                                                         value.id!;
  //                                                     provider.selectedValue =
  //                                                         value.name!;
  //                                                     print(
  //                                                       "hfjkshfg" +
  //                                                           provider.selectedID
  //                                                               .toString(),
  //                                                     );
  //                                                   }
  //                                                 }
  //                                               },
  //                                               dropdownSearchData: DropdownSearchData(
  //                                                 searchInnerWidgetHeight: 50,
  //                                                 searchController:
  //                                                     provider
  //                                                         .paymentAccountSearchController,
  //                                                 searchInnerWidget: Padding(
  //                                                   padding:
  //                                                       const EdgeInsets.all(8),
  //                                                   child: TextFormField(
  //                                                     controller:
  //                                                         provider
  //                                                             .paymentAccountSearchController,
  //                                                     decoration: InputDecoration(
  //                                                       isDense: true,
  //                                                       contentPadding:
  //                                                           const EdgeInsets.symmetric(
  //                                                             horizontal: 10,
  //                                                             vertical: 8,
  //                                                           ),
  //                                                       hintText:
  //                                                           'Search account...',
  //                                                       border: OutlineInputBorder(
  //                                                         borderRadius:
  //                                                             BorderRadius.circular(
  //                                                               8,
  //                                                             ),
  //                                                       ),
  //                                                     ),
  //                                                   ),
  //                                                 ),
  //                                                 searchMatchFn: (
  //                                                   item,
  //                                                   searchValue,
  //                                                 ) {
  //                                                   return item.value?.name
  //                                                           ?.toLowerCase()
  //                                                           .contains(
  //                                                             searchValue
  //                                                                 .toLowerCase(),
  //                                                           ) ??
  //                                                       false;
  //                                                 },
  //
  //                                                 // Optional: clear search text when dropdown closes
  //                                               ),
  //                                               onMenuStateChange: (isOpen) {
  //                                                 if (!isOpen) {
  //                                                   provider
  //                                                       .paymentAccountSearchController
  //                                                       .clear();
  //                                                 }
  //                                               },
  //                                               buttonStyleData:
  //                                                   ddtheme.buttonStyleData,
  //                                               iconStyleData:
  //                                                   ddtheme.iconStyleData,
  //                                               menuItemStyleData:
  //                                                   ddtheme.menuItemStyleData,
  //                                               dropdownStyleData:
  //                                                   ddtheme.dropdownStyleData,
  //                                             ),
  //                                           ),
  //                                         ],
  //                                       ),
  //                                     ),
  //
  //                                     textControllerReadonlyWidget(
  //                                       context,
  //                                       provider.approvedAmountReadonly,
  //                                       "Approved Amount",
  //                                       (p0) {},
  //                                     ),
  //
  //                                     textControllerWidget(
  //                                       context,
  //                                       provider.approvedAmount,
  //                                       "Payment Amount",
  //                                       "Enter Payment Amount",
  //                                       (p0) {
  //                                         if (numberFormat.parse(
  //                                               provider
  //                                                   .approvedAmountReadonly
  //                                                   .text,
  //                                             ) <
  //                                             numberFormat.parse(
  //                                               provider.approvedAmount.text,
  //                                             )) {
  //                                           provider.proposedAmountError =
  //                                               "Amount Should not be greater than Approved amount";
  //                                         } else {
  //                                           provider.proposedAmountError = "";
  //                                         }
  //                                       },
  //                                       TextInputType.numberWithOptions(),
  //                                       false,
  //                                       null,
  //                                     ),
  //
  //                                     errorWidget(
  //                                       context,
  //                                       provider.proposedAmountError,
  //                                     ),
  //
  //                                     textControllerWidget(
  //                                       context,
  //                                       paymentReferenceNumber,
  //                                       "Payment Reference Number",
  //                                       "Enter Payment Reference Number",
  //                                       (p0) {},
  //                                       TextInputType.text,
  //                                       false,
  //                                       null,
  //                                       focusNodes[3],
  //                                       focusNodes[4],
  //                                       TextInputAction.next,
  //                                     ),
  //
  //                                     textControllerWidget(
  //                                       context,
  //                                       remarks,
  //                                       "Remarks",
  //                                       "Enter Remarks",
  //                                       (p0) {},
  //                                       TextInputType.text,
  //                                       false,
  //                                       null,
  //                                       focusNodes[4],
  //                                       null,
  //                                       TextInputAction.done,
  //                                     ),
  //
  //                                     InkResponse(
  //                                       onTap: () {
  //                                         _showAttachmentSheet(context);
  //                                       },
  //                                       child: Container(
  //                                         margin: EdgeInsets.symmetric(
  //                                           vertical: 10,
  //                                         ),
  //                                         height: 45,
  //                                         width:
  //                                             MediaQuery.of(context).size.width,
  //                                         decoration: BoxDecoration(
  //                                           color: Color(0xFFE6F6FF),
  //                                           borderRadius: BorderRadius.circular(
  //                                             12,
  //                                           ),
  //                                           border: Border.all(
  //                                             color: AppColors.app_blue,
  //                                             width: 0.5,
  //                                           ),
  //                                         ),
  //                                         child: Center(
  //                                           child: Text(
  //                                             "Add Attachment",
  //                                             style: TextStyle(
  //                                               fontFamily: "JakartaMedium",
  //                                               color: AppColors.app_blue,
  //                                             ),
  //                                           ),
  //                                         ),
  //                                       ),
  //                                     ),
  //                                     if (provider.imagePicked == 1 &&
  //                                         provider.imagePath != null) ...[
  //                                       Padding(
  //                                         padding: const EdgeInsets.symmetric(
  //                                           vertical: 4.0,
  //                                         ),
  //                                         child: Row(
  //                                           mainAxisAlignment:
  //                                               MainAxisAlignment.spaceBetween,
  //                                           children: [
  //                                             Text(
  //                                               "${provider.imagePath}",
  //                                               style: TextStyle(
  //                                                 color: AppColors.semi_black,
  //                                                 fontSize: 11,
  //                                                 fontWeight: FontWeight.w600,
  //                                               ),
  //                                             ),
  //                                             InkResponse(
  //                                               onTap: () {
  //                                                 provider.imagePicked = 0;
  //                                                 provider.imagePath = null;
  //                                                 provider.imageFilePath = null;
  //                                               },
  //                                               child: SvgPicture.asset(
  //                                                 "assets/svg/ic_close.svg",
  //                                                 width: 15,
  //                                                 height: 15,
  //                                               ),
  //                                             ),
  //                                           ],
  //                                         ),
  //                                       ),
  //                                     ],
  //                                     textControllerReadonlyWidget(
  //                                       context,
  //                                       provider.accountName,
  //                                       "Enter Account Name",
  //                                       (p0) {},
  //                                     ),
  //                                     textControllerReadonlyWidget(
  //                                       context,
  //                                       provider.branch,
  //                                       "Enter Branch Name",
  //                                       (p0) {},
  //                                     ),
  //                                     textControllerReadonlyWidget(
  //                                       context,
  //                                       provider.requestingPurpose,
  //                                       "Enter Requesting Purpose",
  //                                       (p0) {},
  //                                     ),
  //
  //                                     textControllerReadonlyWidget(
  //                                       context,
  //                                       provider.description,
  //                                       "Enter Description",
  //                                       (p0) {},
  //                                     ),
  //
  //                                     textControllerReadonlyWidget(
  //                                       context,
  //                                       provider.amount,
  //                                       "Enter Amount",
  //                                       (p0) {},
  //                                     ),
  //                                     textControllerReadonlyWidget(
  //                                       context,
  //                                       provider.paymentMode,
  //                                       "Enter Payment Mode",
  //                                       (p0) {},
  //                                     ),
  //                                     textControllerReadonlyWidget(
  //                                       context,
  //                                       provider.bankHolderName,
  //                                       "Bank Account Holder Name",
  //                                       (p0) {},
  //                                     ),
  //                                     textControllerReadonlyWidget(
  //                                       context,
  //                                       provider.bankAccountNumber,
  //                                       "Bank Account Number",
  //                                       (p0) {},
  //                                     ),
  //                                     textControllerReadonlyWidget(
  //                                       context,
  //                                       provider.bankName,
  //                                       "Bank Name",
  //                                       (p0) {},
  //                                     ),
  //                                     textControllerReadonlyWidget(
  //                                       context,
  //                                       provider.bankBranchName,
  //                                       "Bank Branch Name",
  //                                       (p0) {},
  //                                     ),
  //
  //                                     textControllerReadonlyWidget(
  //                                       context,
  //                                       provider.bankIfscCode,
  //                                       "Bank IFSC Code",
  //                                       (p0) {},
  //                                     ),
  //                                     textControllerReadonlyWidget(
  //                                       context,
  //                                       provider.bankUpiID,
  //                                       "Bank UPI ID",
  //                                       (p0) {},
  //                                     ),
  //                                   ],
  //                                 ),
  //                               ),
  //                             ),
  //                           ],
  //                         ),
  //                       ],
  //                     ),
  //                   ),
  //                   bottomNavigationBar: Align(
  //                     alignment: Alignment.bottomCenter,
  //                     child: InkWell(
  //                       onTap: () {
  //                         provider.paymentrequisitionProcessSubmitAPIFunction(
  //                           context,
  //                           widget.mode,
  //                           paymentReferenceNumber.text,
  //                           provider.approvedAmount.text,
  //                           paymentID,
  //                           provider.selectedID,
  //                           remarks.text,
  //                           provider.imagePath,
  //                         );
  //                       },
  //                       child: Container(
  //                         alignment: Alignment.bottomCenter,
  //                         height: 45,
  //                         margin: EdgeInsets.only(
  //                           left: 5.0,
  //                           right: 5.0,
  //                           top: 5.0,
  //                           bottom: 5.0,
  //                         ),
  //                         decoration: BoxDecoration(
  //                           color: AppColors.app_blue, //1487C9
  //                           borderRadius: BorderRadius.circular(14.0),
  //                         ),
  //                         child: Center(
  //                           child: Text(
  //                             "Submit",
  //
  //                             ///add payment
  //                             textAlign: TextAlign.center,
  //                             style: TextStyle(color: Colors.white),
  //                           ),
  //                         ),
  //                       ),
  //                     ),
  //                   ),
  //                 );
  //               },
  //             ),
  //           );
  //         },
  //       );
  //     },
  //   );
  // }

  Future<void> _showAddPaymentSheet(BuildContext context, paymentID) {
    return showModalBottomSheet(
      useSafeArea: true,
      isDismissible: true,
      isScrollControlled: true,
      showDragHandle: true,
      backgroundColor: Colors.white,
      enableDrag: true,
      context: context,
      builder: (context) {
        return StatefulBuilder(
          builder: (context, setState) {
            return SafeArea(
              child: Consumer<Requesitionlidtdetailsprovider>(
                builder: (context, provider, child) {
                  // Fallback UI if provider data is not ready
                  return Padding(
                    padding: EdgeInsets.only(
                      bottom: MediaQuery.of(context).viewInsets.bottom,
                    ),
                    child: Container(
                      // Constrain the height to avoid overflow
                      constraints: BoxConstraints(
                        maxHeight: MediaQuery.of(context).size.height * 0.8,
                      ),
                      margin: EdgeInsets.only(
                        bottom: 15,
                        left: 15,
                        right: 15,
                        top: 10,
                      ),
                      child: Column(
                        children: [
                          // Scrollable content
                          Expanded(
                            child: SingleChildScrollView(
                              child: Padding(
                                padding: EdgeInsets.only(
                                  bottom:
                                      MediaQuery.of(context).viewInsets.bottom,
                                ),
                                child: Column(
                                  mainAxisSize: MainAxisSize.min,
                                  children: [
                                    Row(
                                      children: [
                                        Expanded(
                                          child: Column(
                                            crossAxisAlignment:
                                                CrossAxisAlignment.start,
                                            mainAxisSize: MainAxisSize.min,
                                            children: [
                                              Align(
                                                alignment: Alignment.topLeft,
                                                child: Text(
                                                  "Add Approval",
                                                  style: TextStyle(
                                                    color: AppColors.app_blue,
                                                    fontSize: 16,
                                                  ),
                                                ),
                                              ),
                                              textControllerReadonlyWidget(
                                                context,
                                                provider.proposedPaymentAccount,
                                                "Enter Proposed Payment Account",
                                                (p0) {},
                                              ),
                                              TextWidget(
                                                context,
                                                "Payment Account",
                                              ),
                                              DropdownButtonHideUnderline(
                                                child: Row(
                                                  children: [
                                                    Expanded(
                                                      child: DropdownButton2<
                                                        PaymentAccounts
                                                      >(
                                                        isExpanded: true,
                                                        hint: Text(
                                                          'Select Account',
                                                          style: TextStyle(
                                                            fontSize: 14,
                                                          ),
                                                          overflow:
                                                              TextOverflow
                                                                  .ellipsis,
                                                        ),
                                                        items:
                                                            provider
                                                                .paymentsAccounts
                                                                .map(
                                                                  (
                                                                    paymenents,
                                                                  ) => DropdownMenuItem<
                                                                    PaymentAccounts
                                                                  >(
                                                                    value:
                                                                        paymenents,
                                                                    child: Text(
                                                                      paymenents
                                                                              .name ??
                                                                          '',
                                                                      style: TextStyle(
                                                                        fontSize:
                                                                            14,
                                                                      ),
                                                                      overflow:
                                                                          TextOverflow
                                                                              .ellipsis,
                                                                    ),
                                                                  ),
                                                                )
                                                                .toList(),
                                                        value:
                                                            provider
                                                                .selectedPaymentAccounts,
                                                        onChanged: (
                                                          PaymentAccounts?
                                                          value,
                                                        ) {
                                                          if (value != null &&
                                                              provider
                                                                  .paymentsAccounts
                                                                  .isNotEmpty) {
                                                            setState(() {
                                                              provider.selectedPaymentAccounts =
                                                                  value;
                                                              provider.selectedID =
                                                                  value.id!;
                                                              provider.selectedValue =
                                                                  value.name!;
                                                              print(
                                                                "Selected Account: ${value.name}, ID: ${value.id}",
                                                              );
                                                            });
                                                          }
                                                        },
                                                        dropdownSearchData: DropdownSearchData(
                                                          searchInnerWidgetHeight:
                                                              50,
                                                          searchController:
                                                              provider
                                                                  .paymentAccountSearchController,
                                                          searchInnerWidget: Padding(
                                                            padding:
                                                                const EdgeInsets.all(
                                                                  8,
                                                                ),
                                                            child: TextFormField(
                                                              controller:
                                                                  provider
                                                                      .paymentAccountSearchController,
                                                              decoration: InputDecoration(
                                                                isDense: true,
                                                                contentPadding:
                                                                    EdgeInsets.symmetric(
                                                                      horizontal:
                                                                          10,
                                                                      vertical:
                                                                          8,
                                                                    ),
                                                                hintText:
                                                                    'Search account...',
                                                                border: OutlineInputBorder(
                                                                  borderRadius:
                                                                      BorderRadius.circular(
                                                                        8,
                                                                      ),
                                                                ),
                                                              ),
                                                            ),
                                                          ),
                                                          searchMatchFn: (
                                                            item,
                                                            searchValue,
                                                          ) {
                                                            return item
                                                                    .value
                                                                    ?.name
                                                                    ?.toLowerCase()
                                                                    .contains(
                                                                      searchValue
                                                                          .toLowerCase(),
                                                                    ) ??
                                                                false;
                                                          },
                                                        ),
                                                        onMenuStateChange: (
                                                          isOpen,
                                                        ) {
                                                          if (!isOpen) {
                                                            provider
                                                                .paymentAccountSearchController
                                                                .clear();
                                                          }
                                                        },
                                                        buttonStyleData:
                                                            ddtheme
                                                                .buttonStyleData,
                                                        iconStyleData:
                                                            ddtheme
                                                                .iconStyleData,
                                                        menuItemStyleData:
                                                            ddtheme
                                                                .menuItemStyleData,
                                                        dropdownStyleData:
                                                            ddtheme
                                                                .dropdownStyleData,
                                                      ),
                                                    ),
                                                  ],
                                                ),
                                              ),
                                              textControllerReadonlyWidget(
                                                context,
                                                provider.approvedAmountReadonly,
                                                "Approved Amount",
                                                (p0) {},
                                              ),
                                              textControllerWidget(
                                                context,
                                                provider.approvedAmount,
                                                "Payment Amount",
                                                "Enter Payment Amount",
                                                (p0) {
                                                  if (numberFormat.parse(
                                                        provider
                                                            .approvedAmountReadonly
                                                            .text,
                                                      ) <
                                                      numberFormat.parse(
                                                        provider
                                                            .approvedAmount
                                                            .text,
                                                      )) {
                                                    provider.proposedAmountError =
                                                        "Amount should not be greater than Approved amount";
                                                  } else {
                                                    provider.proposedAmountError =
                                                        "";
                                                  }
                                                },
                                                TextInputType.numberWithOptions(),
                                                false,
                                                null,
                                              ),
                                              errorWidget(
                                                context,
                                                provider.proposedAmountError,
                                              ),
                                              textControllerWidget(
                                                context,
                                                paymentReferenceNumber,
                                                "Enter Payment Reference Number",
                                                "Payment Reference Number",
                                                (p0) {},
                                                TextInputType.text,
                                                false,
                                                null,
                                                focusNodes[3],
                                                focusNodes[4],
                                                TextInputAction.next,
                                              ),
                                              textControllerWidget(
                                                context,
                                                remarks,
                                                "Remarks",
                                                "Enter Remarks",
                                                (p0) {},
                                                TextInputType.text,
                                                false,
                                                null,
                                                focusNodes[4],
                                                null,
                                                TextInputAction.done,
                                              ),
                                              InkResponse(
                                                onTap: () {
                                                  _showAttachmentSheet(context);
                                                },
                                                child: Container(
                                                  margin: EdgeInsets.symmetric(
                                                    vertical: 10,
                                                  ),
                                                  height: 45,
                                                  width:
                                                      MediaQuery.of(
                                                        context,
                                                      ).size.width,
                                                  decoration: BoxDecoration(
                                                    color: Color(0xFFE6F6FF),
                                                    borderRadius:
                                                        BorderRadius.circular(
                                                          12,
                                                        ),
                                                    border: Border.all(
                                                      color: AppColors.app_blue,
                                                      width: 0.5,
                                                    ),
                                                  ),
                                                  child: Center(
                                                    child: Text(
                                                      "Add Attachment",
                                                      style: TextStyle(
                                                        fontFamily:
                                                            "JakartaMedium",
                                                        color:
                                                            AppColors.app_blue,
                                                      ),
                                                    ),
                                                  ),
                                                ),
                                              ),
                                              if (provider.imagePicked == 1 &&
                                                  provider.imagePath !=
                                                      null) ...[
                                                Padding(
                                                  padding:
                                                      const EdgeInsets.symmetric(
                                                        vertical: 4.0,
                                                      ),
                                                  child: Row(
                                                    mainAxisAlignment:
                                                        MainAxisAlignment
                                                            .spaceBetween,
                                                    children: [
                                                      Text(
                                                        "${provider.imagePath}",
                                                        style: TextStyle(
                                                          color:
                                                              AppColors
                                                                  .semi_black,
                                                          fontSize: 11,
                                                          fontWeight:
                                                              FontWeight.w600,
                                                        ),
                                                      ),
                                                      InkResponse(
                                                        onTap: () {
                                                          setState(() {
                                                            provider
                                                                .imagePicked = 0;
                                                            provider.imagePath =
                                                                null;
                                                            provider.imageFilePath =
                                                                null;
                                                          });
                                                        },
                                                        child: SvgPicture.asset(
                                                          "assets/svg/ic_close.svg",
                                                          width: 15,
                                                          height: 15,
                                                        ),
                                                      ),
                                                    ],
                                                  ),
                                                ),
                                              ],
                                              textControllerReadonlyWidget(
                                                context,
                                                provider.accountName,
                                                "Enter Account Name",
                                                (p0) {},
                                              ),
                                              textControllerReadonlyWidget(
                                                context,
                                                provider.branch,
                                                "Enter Branch Name",
                                                (p0) {},
                                              ),
                                              textControllerReadonlyWidget(
                                                context,
                                                provider.requestingPurpose,
                                                "Enter Requesting Purpose",
                                                (p0) {},
                                              ),
                                              textControllerReadonlyWidget(
                                                context,
                                                provider.description,
                                                "Enter Description",
                                                (p0) {},
                                              ),
                                              textControllerReadonlyWidget(
                                                context,
                                                provider.amount,
                                                "Enter Amount",
                                                (p0) {},
                                              ),
                                              textControllerReadonlyWidget(
                                                context,
                                                provider.paymentMode,
                                                "Enter Payment Mode",
                                                (p0) {},
                                              ),
                                              textControllerReadonlyWidget(
                                                context,
                                                provider.bankHolderName,
                                                "Bank Account Holder Name",
                                                (p0) {},
                                              ),
                                              textControllerReadonlyWidget(
                                                context,
                                                provider.bankAccountNumber,
                                                "Bank Account Number",
                                                (p0) {},
                                              ),
                                              textControllerReadonlyWidget(
                                                context,
                                                provider.bankName,
                                                "Bank Name",
                                                (p0) {},
                                              ),
                                              textControllerReadonlyWidget(
                                                context,
                                                provider.bankBranchName,
                                                "Bank Branch Name",
                                                (p0) {},
                                              ),
                                              textControllerReadonlyWidget(
                                                context,
                                                provider.bankIfscCode,
                                                "Bank IFSC Code",
                                                (p0) {},
                                              ),
                                              textControllerReadonlyWidget(
                                                context,
                                                provider.bankUpiID,
                                                "Bank UPI ID",
                                                (p0) {},
                                              ),
                                            ],
                                          ),
                                        ),
                                      ],
                                    ),
                                  ],
                                ),
                              ),
                            ),
                          ),
                          // Sticky Submit Button
                          Padding(
                            padding: EdgeInsets.only(
                              left: 5.0,
                              right: 5.0,
                              top: 5.0,
                              bottom: 5.0,
                            ),
                            child: InkWell(
                              onTap: () {
                                provider
                                    .paymentrequisitionProcessSubmitAPIFunction(
                                      context,
                                      widget.mode,
                                      paymentReferenceNumber.text,
                                      provider.approvedAmount.text,
                                      paymentID,
                                      provider.selectedID,
                                      remarks.text,
                                      provider.imagePath,
                                    );
                              },
                              child: Container(
                                height: 45,
                                decoration: BoxDecoration(
                                  color: AppColors.app_blue,
                                  borderRadius: BorderRadius.circular(14.0),
                                ),
                                child: Center(
                                  child: Text(
                                    "Submit",
                                    textAlign: TextAlign.center,
                                    style: TextStyle(color: Colors.white),
                                  ),
                                ),
                              ),
                            ),
                          ),
                        ],
                      ),
                    ),
                  );
                },
              ),
            );
          },
        );
      },
    );
  }

  Future<void> _showEditPaymentSheet(BuildContext context, paymentID) {
    return showModalBottomSheet(
      useSafeArea: true,
      isDismissible: true,
      isScrollControlled: true,
      showDragHandle: true,
      backgroundColor: Colors.white,
      enableDrag: true,
      context: context,
      builder: (context) {
        return StatefulBuilder(
          builder: (context, setState) {
            return SafeArea(
              child: Consumer<Requesitionlidtdetailsprovider>(
                builder: (context, provider, child) {
                  return Padding(
                    padding: EdgeInsets.only(
                      bottom: MediaQuery.of(context).viewInsets.bottom,
                    ),
                    child: Container(
                      constraints: BoxConstraints(
                        maxHeight: MediaQuery.of(context).size.height * 0.3,
                      ),
                      margin: EdgeInsets.only(
                        bottom: 15,
                        left: 15,
                        right: 15,
                        top: 10,
                      ),
                      child: Column(
                        children: [
                          Align(
                            alignment: Alignment.topLeft,
                            child: Text(
                              "Edit Processed Amount",
                              style: TextStyle(
                                color: AppColors.app_blue,
                                fontSize: 16,
                              ),
                            ),
                          ),
                          textControllerReadonlyWidget(
                            context,
                            provider.editPaymentRequestedAmountController,
                            "Requested Amount",
                            (p0) {},
                          ),
                          textControllerWidget(
                            context,
                            provider
                                .editPaymentRequestedEditableAmountController,
                            "Approved Amount",
                            "Enter Approved Amount",
                            (p0) {
                              provider.onChangeEditableAmount(p0, context);
                            },
                            TextInputType.numberWithOptions(),
                            false,
                            null,
                          ),
                          errorWidget(context, provider.editableAmountError),

                          Padding(
                            padding: EdgeInsets.only(
                              left: 5.0,
                              right: 5.0,
                              top: 5.0,
                              bottom: 5.0,
                            ),
                            child: InkWell(
                              onTap:
                                  provider.editPaymentProcessLoading
                                      ? null
                                      : () {
                                        provider.editPaymentProcessLoading =
                                            true;

                                        provider.editProcessedPaymentAmountAPIFunction(
                                          context,
                                          paymentID,
                                          provider
                                              .editPaymentRequestedEditableAmountController
                                              .text,
                                        );
                                      },
                              child: Container(
                                height: 45,
                                decoration: BoxDecoration(
                                  color: AppColors.app_blue,
                                  borderRadius: BorderRadius.circular(14.0),
                                ),
                                child: Center(
                                  child:
                                      provider.editPaymentProcessLoading
                                          ? CircularProgressIndicator.adaptive(
                                            valueColor: AlwaysStoppedAnimation(
                                              AppColors.white,
                                            ),
                                          )
                                          : Text(
                                            "Submit",
                                            textAlign: TextAlign.center,
                                            style: TextStyle(
                                              color: Colors.white,
                                            ),
                                          ),
                                ),
                              ),
                            ),
                          ),
                        ],
                      ),
                    ),
                  );
                },
              ),
            );
          },
        );
      },
    );
  }

  Future<void> _showAttachmentSheet(BuildContext context) {
    return showModalBottomSheet(
      useSafeArea: true,
      isDismissible: true,
      isScrollControlled: true,
      showDragHandle: true,
      backgroundColor: Colors.white,
      enableDrag: true,
      context: context,
      builder: (context) {
        return StatefulBuilder(
          builder: (context, setState) {
            return SafeArea(
              child: Consumer<Requesitionlidtdetailsprovider>(
                builder: (context, provider, child) {
                  return Padding(
                    padding: EdgeInsets.only(
                      bottom:
                          MediaQuery.of(
                            context,
                          ).viewInsets.bottom, // This handles keyboard
                    ),
                    child: Container(
                      margin: EdgeInsets.only(
                        bottom: 15,
                        left: 15,
                        right: 15,
                        top: 10,
                      ),

                      child: SingleChildScrollView(
                        child: Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          mainAxisSize: MainAxisSize.min,
                          children: [
                            Align(
                              alignment: Alignment.center,
                              child: Text(
                                "Select Source",
                                style: TextStyle(
                                  color: AppColors.app_blue,
                                  fontSize: 16,
                                ),
                              ),
                            ),
                            SizedBox(height: 15),
                            InkWell(
                              onTap: () {
                                Navigator.of(context).pop(false);
                                provider.imgFromGallery(context);
                              },
                              child: SizedBox(
                                height: 35,
                                child: Text("Select photo from gallery"),
                              ),
                            ),
                            SizedBox(height: 10),
                            InkWell(
                              onTap: () {
                                Navigator.of(context).pop(false);
                                provider.imgFromCamera(context);
                              },
                              child: SizedBox(
                                height: 35,
                                child: Text("Capture photo from camera"),
                              ),
                            ),
                          ],
                        ),
                      ),
                    ),
                  );
                },
              ),
            );
          },
        );
      },
    );
  }
}

///
///
/// List.generate(titles.length, (h){
// return  Column(
// children: [
// Container(
// padding: EdgeInsets.symmetric(
// vertical: 4,
// ),
// child: Row(
// children: [
// Expanded(
// flex: 3,
// child: Text(
// titles[h],
// style: TextStyle(
// fontSize: 14,
// fontFamily: "JakartaSemiBold",
// ),
// ),
// ),
// Expanded(
// flex: 6,
// child: DottedLine(
// dashGapLength: 4,
// dashGapColor: Colors.white,
// dashColor: AppColors.grey_semi,
// dashLength: 2,
// lineThickness: 0.5,
// ),
// ),
// ],
// ),
// ),
// ...List.generate(headings.length, (j) {
// return Container(
// padding: EdgeInsets.symmetric(
// vertical: 7,
// ),
// child: Column(
// children: [
//
// Row(
// crossAxisAlignment:
// CrossAxisAlignment.start,
// children: [
// Expanded(
// child: Text(
// headings[j],
// style: TextStyle(
// fontFamily: "JakartaRegular",
// fontSize: 14,
// color: AppColors.semi_black,
// ),
// ),
// ),
// Expanded(
// child: Text(
// subHeadings[j] == ""
// ? "-"
//     : subHeadings[j],
// style: TextStyle(
// fontSize: 14,
// color: Color(0xFF818181),
// ),
// ),
// ),
// ],
// ),
// ],
// ),
// );
// }),
// ],
// );
// }),
///
