// addcommonpayment.dart
import 'dart:io';

import 'package:connectivity_plus/connectivity_plus.dart';
import 'package:dropdown_button2/dropdown_button2.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:flutter_svg/svg.dart';
import 'package:generp/Notifiers/commonProvider/accountsListProvider.dart';
import 'package:generp/Notifiers/HomeScreenNotifier.dart';
import 'package:generp/Utils/ShakeWidget.dart';
import 'package:generp/Utils/app_colors.dart';
import 'package:generp/Utils/commonServices.dart';
import 'package:generp/Utils/commonWidgets.dart';
import 'package:generp/Utils/dropdownTheme.dart';
import 'package:provider/provider.dart';
import 'package:generp/Models/commonModels/DistrictsResponse.dart';
import 'package:generp/Models/commonModels/SubLocationsResponse.dart';

import '../../Models/commonModels/commonAddAccountsViewResponse.dart';

class Addcommonpayment extends StatefulWidget {
  final from;
  const Addcommonpayment({super.key, required this.from});

  @override
  State<Addcommonpayment> createState() => _AddcommonpaymentState();
}

class _AddcommonpaymentState extends State<Addcommonpayment> {
  Dropdowntheme ddtheme = Dropdowntheme();
  int _currentStep = 0;
  final _formKey = GlobalKey<FormState>();
  List<FocusNode> focusNodes = List.generate(20, (index) => FocusNode());
  Map _source = {ConnectivityResult.mobile: true};
  final MyConnectivity _connectivity = MyConnectivity.instance;

  @override
  void initState() {
    super.initState();
    _connectivity.initialise();
    _connectivity.myStream.listen((source) {
      setState(() => _source = source);
    });
    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
      var prov = Provider.of<Accountslistprovider>(context, listen: false);
      prov.addCommonAccountViewAPI(context);
    });
  }

  @override
  void dispose() {
    // correctly dispose focus nodes
    for (final fn in focusNodes) {
      try {
        fn.dispose();
      } catch (_) {}
    }
    _connectivity.disposeStream();
    super.dispose();
  }

  Future<bool> onBackPressed(BuildContext context) async {
    if (_currentStep > 0) {
      setState(() => _currentStep -= 1);
      return false;
    } else {
      return true;
    }
  }

  bool _isIfscValidFormat(String ifsc) {
    // Basic IFSC pattern: 4 letters, 0, 6 alphanumeric
    final reg = RegExp(r'^[A-Za-z]{4}0[A-Za-z0-9]{6}$');
    return reg.hasMatch(ifsc.trim());
  }

  Future<void> _validateGstIfNeeded(
      Accountslistprovider provider) async {
    final gst = provider.gstNumberController.text.trim();
    if (gst.isEmpty) {
      // nothing to validate
      return;
    }

    // get emp/session
    final homeProv =
    Provider.of<HomescreenNotifier>(context, listen: false);

    // set a small loading indicator on provider or local if needed
    provider.isLoading = true;
    provider.gstNumberError = null;
    provider.notifyListeners();

    try {
      await provider.validateGstNumber(homeProv.empId, homeProv.session, gst);

      // After validateGstNumber completes, provider.gstResponse should be set
      if (provider.gstResponse != null && provider.gstResponse!.error == "0") {
        // autofill address in step 2
        final fetchedAddress = provider.gstResponse!.address ?? "";
        if (fetchedAddress.isNotEmpty) {
          provider.addressController.text = fetchedAddress;
        }

        // compare company name
        final gstName = (provider.gstResponse!.legalNameOfBusiness ?? "")
            .trim()
            .toLowerCase();
        final companyName = provider.nameController.text.trim().toLowerCase();
        if (gstName.isNotEmpty &&
            companyName.isNotEmpty &&
            gstName != companyName) {
          provider.nameError =
          "Company name doesn't match GST legal name (${provider.gstResponse!.legalNameOfBusiness}). Please correct.";
        } else {
          provider.nameError = null;
        }

        provider.gstNumberError = null;
      } else {
        // API returned error or invalid gst
        provider.gstNumberError =
            provider.gstResponse?.message ?? "Invalid GST number";
      }
    } catch (e) {
      provider.gstNumberError = "Failed to validate GST: $e";
    } finally {
      provider.isLoading = false;
      provider.notifyListeners();
    }
  }

  Future<void> _validateBankIfNeeded(
      Accountslistprovider provider) async {
    final acc = provider.bankAcNumberController.text.trim();
    final ifsc = provider.bankIfscCotroller.text.trim();

    // Only validate if both fields have values
    if (acc.isEmpty || ifsc.isEmpty) {
      return;
    }

    // IFSC basic format check first
    if (!_isIfscValidFormat(ifsc)) {
      provider.bankIFSCError = "Invalid IFSC format";
      provider.notifyListeners();
      return;
    } else {
      provider.bankIFSCError = null;
    }

    final homeProv =
    Provider.of<HomescreenNotifier>(context, listen: false);

    provider.isLoading = true;
    provider.notifyListeners();

    try {
      await provider.validateBankDetails(homeProv.empId, homeProv.session,
          acc); // provider uses bankIfscCotroller.text internally

      if (provider.bankResponse != null && provider.bankResponse!.error == "0") {
        // autofill fields
        final br = provider.bankResponse!;
        if (br.bankName != null && br.bankName!.isNotEmpty) {
          provider.bankNameController.text = br.bankName!;
        }
        if (br.branch != null && br.branch!.isNotEmpty) {
          provider.branchNameController.text = br.branch!;
        }
        if (br.nameAtBank != null && br.nameAtBank!.isNotEmpty) {
          provider.bankHolderNameController.text = br.nameAtBank!;
        }
        provider.bankAcNumberError = null;
        provider.bankIFSCError = null;
      } else {
        // show error
        provider.bankAcNumberError =
            provider.bankResponse?.message ?? "Invalid account / IFSC";
      }
    } catch (e) {
      provider.bankAcNumberError = "Failed to validate bank details: $e";
    } finally {
      provider.isLoading = false;
      provider.notifyListeners();
    }
  }

  /// Determine first step which has an error (0..3). If none returns null.
  int? _firstErrorStep(Accountslistprovider provider) {
    // Step 0: Account Details
    if ((provider.accountError?.isNotEmpty ?? false) ||
        (provider.nameError?.isNotEmpty ?? false) ||
        (provider.mobileError?.isNotEmpty ?? false) ||
        (provider.contactPersonError?.isNotEmpty ?? false)) {
      return 0;
    }

    // Step 1: Address details (optional step but if errors exist, redirect)
    if ((provider.stateError?.isNotEmpty ?? false) ||
        (provider.districtError?.isNotEmpty ?? false) ||
        (provider.localityError?.isNotEmpty ?? false) ||
        (provider.addressError?.isNotEmpty ?? false)) {
      return 1;
    }

    // Step 2: Bank / GST related validation errors
    if ((provider.gstNumberError?.isNotEmpty ?? false) ||
        (provider.bankAcNumberError?.isNotEmpty ?? false) ||
        (provider.bankIFSCError?.isNotEmpty ?? false) ||
        (provider.banknameError?.isNotEmpty ?? false) ||
        (provider.bankBranchError?.isNotEmpty ?? false) ||
        (provider.bankHolderNameError?.isNotEmpty ?? false) ||
        (provider.upiError?.isNotEmpty ?? false)) {
      return 2;
    }

    // Step 3: Contact Details
    if ((provider.desigantionError?.isNotEmpty ?? false) ||
        (provider.altMobError?.isNotEmpty ?? false) ||
        (provider.teleError?.isNotEmpty ?? false) ||
        (provider.mailError?.isNotEmpty ?? false)) {
      return 3;
    }

    return null;
  }

  @override
  Widget build(BuildContext context) {
    switch (_source.keys.toList()[0]) {
      case ConnectivityResult.mobile:
        connection = 'Online';
        break;
      case ConnectivityResult.wifi:
        connection = 'Online';
        break;
      case ConnectivityResult.none:
      default:
        connection = 'Offline';
    }

    return (connection == "Online")
        ? Platform.isAndroid
        ? WillPopScope(
      onWillPop: () => onBackPressed(context),
      child: SafeArea(top: false, bottom: true, child: _scaffold(context)),
    )
        : _scaffold(context)
        : NoNetwork(context);
  }

  Widget _scaffold(BuildContext context) {
    return Consumer<Accountslistprovider>(
      builder: (context, provider, child) {
        return Scaffold(
          resizeToAvoidBottomInset: true,
          appBar: appbar2New(
            context,
            "Add Account",
            provider.resetValues,
            SizedBox.shrink(),
            0xFFFFFFFF,
          ),
          backgroundColor: AppColors.scaffold_bg_color,
          body: Form(
            key: _formKey,
            child: Stepper(
              margin: EdgeInsets.symmetric(horizontal: 0, vertical: 0),
              type: StepperType.horizontal,
              currentStep: _currentStep,
              onStepContinue: () async {
                // custom continue logic:
                if (_currentStep == 0) {
                  // validate step1 via provider
                  if (provider.validateStep1()) {
                    setState(() => _currentStep = 1);
                  } else {
                    // show error (provider sets errors and notifies)
                    provider.notifyListeners();
                    // stay on step 0
                    setState(() => _currentStep = 0);
                  }
                } else if (_currentStep == 1) {
                  // Step 2 is optional; allow moving to next without forcing validation
                  // But if the user has entered fields and they are invalid, validate
                  if (provider.stateSearchController.text.trim().isNotEmpty ||
                      provider.districtSearchController.text.trim().isNotEmpty ||
                      provider.addressController.text.trim().isNotEmpty) {
                    if (provider.validateStep2()) {
                      setState(() => _currentStep = 2);
                    } else {
                      provider.notifyListeners();
                    }
                  } else {
                    // nothing filled, just move forward
                    setState(() => _currentStep = 2);
                  }
                } else if (_currentStep == 2) {
                  // Step 3 (bank) is optional; validate only if fields present
                  if (provider.gstNumberController.text.trim().isNotEmpty) {
                    // ensure gst validated
                    await _validateGstIfNeeded(provider);
                  }
                  if (provider.bankAcNumberController.text.trim().isNotEmpty ||
                      provider.bankIfscCotroller.text.trim().isNotEmpty) {
                    await _validateBankIfNeeded(provider);
                  }

                  // if any bank/gst errors exist, stay; else move forward
                  final bankErrors = (provider.gstNumberError != null &&
                      provider.gstNumberError!.isNotEmpty) ||
                      (provider.bankAcNumberError != null &&
                          provider.bankAcNumberError!.isNotEmpty) ||
                      (provider.bankIFSCError != null &&
                          provider.bankIFSCError!.isNotEmpty);

                  if (bankErrors) {
                    provider.notifyListeners();
                    setState(() => _currentStep = 2);
                  } else {
                    setState(() => _currentStep = 3);
                  }
                } else if (_currentStep == 3) {
                  // last step: same as pressing Submit in controls below
                }
              },
              onStepCancel: () {
                if (_currentStep > 0) {
                  setState(() => _currentStep -= 1);
                }
              },
              onStepTapped: (value) async {
                // allow tapping to review steps; prevent jumping forward past required failed steps
                if (value == 0) {
                  setState(() => _currentStep = 0);
                } else if (value == 1) {
                  // user wants to jump to step 1 - ensure step 0 valid
                  if (provider.validateStep1()) {
                    setState(() => _currentStep = 1);
                  } else {
                    provider.notifyListeners();
                    setState(() => _currentStep = 0);
                  }
                } else if (value == 2) {
                  // allow jump if step0 valid; step1 optional
                  if (provider.validateStep1()) {
                    setState(() => _currentStep = 2);
                  } else {
                    provider.notifyListeners();
                    setState(() => _currentStep = 0);
                  }
                } else if (value == 3) {
                  // final - require step0 valid
                  if (!provider.validateStep1()) {
                    provider.notifyListeners();
                    setState(() => _currentStep = 0);
                    return;
                  }
                  // optional steps validated when moving forward by controls
                  setState(() => _currentStep = 3);
                }
              },
              connectorColor: WidgetStatePropertyAll(AppColors.app_blue),
              stepIconBuilder: (stepIndex, stepState) {
                return CircleAvatar(
                  radius: 12,
                  backgroundColor: stepIndex <= _currentStep ? AppColors.app_blue : Colors.grey[300],
                );
              },
              steps: [
                // Step 0 (Step 1 in your labels)
                Step(
                  label: Text("Step 1", style: TextStyle(fontSize: 12)),
                  title: const Text(''),
                  isActive: _currentStep >= 0,
                  content: Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      Container(
                        margin: EdgeInsets.only(bottom: 5),
                        child: Text(
                          "Account Details",
                          style: TextStyle(
                            color: AppColors.app_blue,
                            fontSize: 16,
                            fontFamily: "JakartaMedium",
                          ),
                        ),
                      ),
                      Container(
                        padding: EdgeInsets.symmetric(horizontal: 10, vertical: 10),
                        decoration: BoxDecoration(color: Colors.white, borderRadius: BorderRadius.circular(16)),
                        child: Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: [
                            SizedBox(height: 10),
                            Text("Account"),
                            DropdownButtonHideUnderline(
                              child: Row(
                                children: [
                                  Expanded(
                                    child: DropdownButton2<String>(
                                      isExpanded: true,
                                      hint: const Row(
                                        children: [
                                          Expanded(
                                            child: Text(
                                              'Select Account',
                                              style: TextStyle(fontSize: 14),
                                              overflow: TextOverflow.ellipsis,
                                            ),
                                          ),
                                        ],
                                      ),
                                      items: provider.accountTypes.map((act) => DropdownMenuItem<String>(
                                        value: act,
                                        child: Text(act, style: const TextStyle(fontSize: 14), overflow: TextOverflow.ellipsis),
                                      )).toList(),
                                      value: provider.accountTypes.contains(provider.selectedAccountType) ? provider.selectedAccountType : null,
                                      onChanged: (value) {
                                        if (value != null) {
                                          provider.selectedAccountType = value;
                                        }
                                      },
                                      buttonStyleData: ddtheme.buttonStyleData,
                                      iconStyleData: ddtheme.iconStyleData,
                                      menuItemStyleData: ddtheme.menuItemStyleData,
                                      dropdownStyleData: ddtheme.dropdownStyleData,
                                    ),
                                  ),
                                ],
                              ),
                            ),
                            errorWidget(context, provider.accountError),
                            textControllerWidget(
                              context,
                              provider.nameController,
                              "Company Name",
                              "Enter Company Name",
                                  (p0) {
                                provider.updateName(p0);
                                provider.checkInputsAPI(context, "name", provider.nameController.text);
                              },
                              TextInputType.text,
                              false,
                              null,
                              focusNodes[0],
                              focusNodes[1],
                              TextInputAction.next,
                              null,
                              // validator for form-level as well
                              // we won't add Form validator since provider handles it
                            ),
                            errorWidget(context, provider.nameError),
                            textControllerWidget(
                              context,
                              provider.mobileController,
                              "Mobile Number",
                              "Enter Mobile",
                                  (p0) {
                                provider.updateMobile(p0);
                                provider.checkInputsAPI(context, "mob1", provider.mobileController.text);
                              },
                              TextInputType.phone,
                              false,
                              FilteringTextInputFormatter.digitsOnly,
                              focusNodes[1],
                              focusNodes[2],
                              TextInputAction.next,
                              10,
                            ),
                            errorWidget(context, provider.mobileError),
                            textControllerWidget(
                              context,
                              provider.contactPersonController,
                              "Contact Person Name",
                              "Enter Contact Person Name",
                              provider.updateContactPerson,
                              TextInputType.text,
                              false,
                              null,
                              focusNodes[12],
                              focusNodes[13],
                              TextInputAction.next,
                            ),
                            errorWidget(context, provider.contactPersonError),
                          ],
                        ),
                      ),
                    ],
                  ),
                ),

                // Step 1 (Address / optional)
                Step(
                  label: Text("Step 2", style: TextStyle(fontSize: 12)),
                  title: const Text(''),
                  isActive: _currentStep >= 1,
                  content: Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      Container(
                        margin: EdgeInsets.only(bottom: 10),
                        child: Text(
                          "Address Details",
                          style: TextStyle(color: AppColors.app_blue, fontSize: 16, fontFamily: "JakartaMedium"),
                        ),
                      ),
                      Container(
                        padding: EdgeInsets.symmetric(horizontal: 10, vertical: 10),
                        decoration: BoxDecoration(color: Colors.white, borderRadius: BorderRadius.circular(16)),
                        child: Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: [
                            Text("State"),
                            DropdownButtonHideUnderline(
                              child: Row(
                                children: [
                                  Expanded(
                                    child: DropdownButton2<States>(
                                      focusNode: focusNodes[2],
                                      autofocus: focusNodes[2].hasFocus ? true : false,
                                      isExpanded: true,
                                      hint: Text('Select State', style: TextStyle(fontSize: 14)),
                                      items: provider.states.map((states) => DropdownMenuItem<States>(
                                        value: states,
                                        child: Text(states.name ?? '', style: const TextStyle(fontSize: 14), overflow: TextOverflow.ellipsis),
                                      )).toList(),
                                      value: provider.states.contains(provider.selectedState) ? provider.selectedState : null,
                                      onChanged: (States? value) {
                                        if (value != null) {
                                          provider.selectedState = value;
                                          provider.selectedStateID = value.id!;
                                          if (provider.selectedDistricts != null) {
                                            provider.districts.clear();
                                            provider.selectedDistrictId = null;
                                            provider.selectedDistrictValue = null;
                                          }
                                          provider.getDistrictAPI(context, provider.selectedStateID);
                                        }
                                      },
                                      dropdownSearchData: DropdownSearchData(
                                        searchInnerWidgetHeight: 50,
                                        searchController: provider.stateSearchController,
                                        searchInnerWidget: Padding(
                                          padding: const EdgeInsets.all(8),
                                          child: TextFormField(
                                            controller: provider.stateSearchController,
                                            decoration: InputDecoration(isDense: true, contentPadding: const EdgeInsets.symmetric(horizontal: 10, vertical: 8), hintText: 'Search States...', border: OutlineInputBorder(borderRadius: BorderRadius.circular(8))),
                                          ),
                                        ),
                                        searchMatchFn: (item, searchValue) {
                                          return item.value?.name?.toLowerCase().contains(searchValue.toLowerCase()) ?? false;
                                        },
                                      ),
                                      onMenuStateChange: (isOpen) {
                                        if (!isOpen) provider.stateSearchController.clear();
                                      },
                                      buttonStyleData: ddtheme.buttonStyleData,
                                      iconStyleData: ddtheme.iconStyleData,
                                      menuItemStyleData: ddtheme.menuItemStyleData,
                                      dropdownStyleData: ddtheme.dropdownStyleData,
                                    ),
                                  ),
                                ],
                              ),
                            ),
                            errorWidget(context, provider.stateError),
                            Text("District"),
                            DropdownButtonHideUnderline(
                              child: Row(
                                children: [
                                  Expanded(
                                    child: DropdownButton2<Districts>(
                                      focusNode: focusNodes[3],
                                      isExpanded: true,
                                      hint: Text('Select District', style: TextStyle(fontSize: 14)),
                                      items: provider.districts.map((dist) => DropdownMenuItem<Districts>(
                                        value: dist,
                                        child: Text(dist.district ?? '', style: const TextStyle(fontSize: 14), overflow: TextOverflow.ellipsis),
                                      )).toList(),
                                      value: provider.districts.contains(provider.selectedDistricts) ? provider.selectedDistricts : null,
                                      onChanged: (Districts? value) {
                                        if (value != null) {
                                          provider.selectedDistricts = value;
                                          provider.selectedDistrictId = value.id!;
                                          provider.selectedDistrictValue = value.district!;
                                          if (provider.selectedSubLocations != null) {
                                            provider.selectedSubLocID = null;
                                            provider.selectedSubLocValue = null;
                                          }
                                          provider.getSubLocationAPI(context, provider.selectedDistrictId);
                                        }
                                      },
                                      dropdownSearchData: DropdownSearchData(
                                        searchInnerWidgetHeight: 50,
                                        searchController: provider.districtSearchController,
                                        searchInnerWidget: Padding(
                                          padding: const EdgeInsets.all(8),
                                          child: TextFormField(
                                            controller: provider.districtSearchController,
                                            decoration: InputDecoration(isDense: true, contentPadding: const EdgeInsets.symmetric(horizontal: 10, vertical: 8), hintText: 'Search Districts...', border: OutlineInputBorder(borderRadius: BorderRadius.circular(8))),
                                          ),
                                        ),
                                        searchMatchFn: (item, searchValue) {
                                          return item.value?.district?.toLowerCase().contains(searchValue.toLowerCase()) ?? false;
                                        },
                                      ),
                                      onMenuStateChange: (isOpen) {
                                        if (!isOpen) provider.districtSearchController.clear();
                                      },
                                      buttonStyleData: ddtheme.buttonStyleData,
                                      iconStyleData: ddtheme.iconStyleData,
                                      menuItemStyleData: ddtheme.menuItemStyleData,
                                      dropdownStyleData: ddtheme.dropdownStyleData,
                                    ),
                                  ),
                                ],
                              ),
                            ),
                            errorWidget(context, provider.districtError),
                            Text("Sub Locality"),
                            DropdownButtonHideUnderline(
                              child: Row(
                                children: [
                                  Expanded(
                                    child: DropdownButton2<SubLocations>(
                                      focusNode: focusNodes[4],
                                      isExpanded: true,
                                      hint: Text('Select Sub Locality', style: TextStyle(fontSize: 14)),
                                      items: provider.subLocations.map((subloc) => DropdownMenuItem<SubLocations>(
                                        value: subloc,
                                        child: Text(subloc.subLocality ?? '', style: const TextStyle(fontSize: 14), overflow: TextOverflow.ellipsis),
                                      )).toList(),
                                      value: provider.subLocations.contains(provider.selectedSubLocations) ? provider.selectedSubLocations : null,
                                      onChanged: (SubLocations? value) {
                                        if (value != null) {
                                          provider.selectedSubLocations = value;
                                          provider.selectedSubLocID = value.id!;
                                          provider.selectedSubLocValue = value.subLocality!;
                                        }
                                      },
                                      dropdownSearchData: DropdownSearchData(
                                        searchInnerWidgetHeight: 50,
                                        searchController: provider.subLocSearchController,
                                        searchInnerWidget: Padding(
                                          padding: const EdgeInsets.all(8),
                                          child: TextFormField(
                                            controller: provider.subLocSearchController,
                                            decoration: InputDecoration(isDense: true, contentPadding: const EdgeInsets.symmetric(horizontal: 10, vertical: 8), hintText: 'Search Sub Locality...', border: OutlineInputBorder(borderRadius: BorderRadius.circular(8))),
                                          ),
                                        ),
                                        searchMatchFn: (item, searchValue) {
                                          return item.value?.subLocality?.toLowerCase().contains(searchValue.toLowerCase()) ?? false;
                                        },
                                      ),
                                      onMenuStateChange: (isOpen) {
                                        if (!isOpen) provider.subLocSearchController.clear();
                                      },
                                      buttonStyleData: ddtheme.buttonStyleData,
                                      iconStyleData: ddtheme.iconStyleData,
                                      menuItemStyleData: ddtheme.menuItemStyleData,
                                      dropdownStyleData: ddtheme.dropdownStyleData,
                                    ),
                                  ),
                                ],
                              ),
                            ),
                            errorWidget(context, provider.localityError),
                            textControllerWidget(
                              context,
                              provider.addressController,
                              "Address",
                              "Enter Address",
                              provider.updateAddress,
                              TextInputType.text,
                              false,
                              null,
                              focusNodes[5],
                              null,
                              TextInputAction.done,
                            ),
                            errorWidget(context, provider.addressError),
                          ],
                        ),
                      ),
                    ],
                  ),
                ),

                // Step 2 (Bank & GST)
                Step(
                  label: Text("Step 3", style: TextStyle(fontSize: 12)),
                  title: const Text(''),
                  isActive: _currentStep >= 2,
                  content: Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      Container(
                        margin: EdgeInsets.only(bottom: 10),
                        child: Text("Bank Details", style: TextStyle(color: AppColors.app_blue, fontSize: 16, fontFamily: "JakartaMedium")),
                      ),
                      Container(
                        padding: EdgeInsets.symmetric(horizontal: 10, vertical: 10),
                        decoration: BoxDecoration(color: Colors.white, borderRadius: BorderRadius.circular(16)),
                        child: Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: [
                            // GST field - if provided, validate and autofill address; compare company name
                            textControllerWidget(
                              context,
                              provider.gstNumberController,
                              "GST Number",
                              "Enter GST Number",
                                  (val) async {
                                // when user types, just update; validation on field submit
                                provider.gstNumberController.text = val;
                                provider.notifyListeners();
                              },
                              TextInputType.text,
                              false,
                              null,
                              focusNodes[9],
                              focusNodes[10],
                              TextInputAction.next,
                              null,
                              // onEditingComplete / onFieldSubmitted, we will validate
                            ),
                            // Validate GST when user leaves the field (on editing complete)
                            // To do that we use FocusNode
                            const SizedBox(height: 4),
                            errorWidget(context, provider.gstNumberError),
                            // Bank Account Number
                            textControllerWidget(
                              context,
                              provider.bankAcNumberController,
                              "Bank Account Number",
                              "Enter Bank Account Number",
                                  (p0) {
                                provider.updateNumber(p0);
                                // attempt validation only when IFSC present
                                if (provider.bankIfscCotroller.text.trim().isNotEmpty) {
                                  _validateBankIfNeeded(provider);
                                }
                              },
                              TextInputType.number,
                              false,
                              FilteringTextInputFormatter.digitsOnly,
                              focusNodes[10],
                              focusNodes[11],
                              TextInputAction.next,
                            ),
                            errorWidget(context, provider.bankAcNumberError),
                            // IFSC
                            textControllerWidget(
                              context,
                              provider.bankIfscCotroller,
                              "Bank IFSC",
                              "Enter Bank IFSC",
                                  (p0) {
                                provider.updateIFSC(p0);
                                // validate IFSC format locally; if good and account present, trigger server validation
                                if (_isIfscValidFormat(p0) && provider.bankAcNumberController.text.trim().isNotEmpty) {
                                  _validateBankIfNeeded(provider);
                                } else {
                                  if (p0.trim().isNotEmpty && !_isIfscValidFormat(p0)) {
                                    provider.bankIFSCError = "Invalid IFSC format";
                                    provider.notifyListeners();
                                  } else {
                                    provider.bankIFSCError = null;
                                    provider.notifyListeners();
                                  }
                                }
                              },
                              TextInputType.text,
                              false,
                              null,
                              focusNodes[8],
                              focusNodes[9],
                              TextInputAction.next,
                            ),
                            errorWidget(context, provider.bankIFSCError),
                            // Bank Name (autofill)
                            textControllerWidget(
                              context,
                              provider.bankNameController,
                              "Bank Name",
                              "Enter Bank Name",
                              provider.updateBankName,
                              TextInputType.text,
                              false,
                              null,
                              focusNodes[6],
                              focusNodes[7],
                              TextInputAction.next,
                            ),
                            errorWidget(context, provider.banknameError),
                            // Branch
                            textControllerWidget(
                              context,
                              provider.branchNameController,
                              "Bank Branch",
                              "Enter Bank Branch",
                              provider.updateBankBranch,
                              TextInputType.text,
                              false,
                              null,
                              focusNodes[7],
                              focusNodes[8],
                              TextInputAction.next,
                            ),
                            errorWidget(context, provider.bankBranchError),
                            // Holder
                            textControllerWidget(
                              context,
                              provider.bankHolderNameController,
                              "Bank Holder Name",
                              "Enter Bank Holder Name",
                              provider.updateHolder,
                              TextInputType.text,
                              false,
                              null,
                              focusNodes[9],
                              focusNodes[10],
                              TextInputAction.next,
                            ),
                            errorWidget(context, provider.bankHolderNameError),
                            // UPI
                            textControllerWidget(
                              context,
                              provider.bankUpiController,
                              "Bank UPI ID",
                              "Enter Bank UPI ID",
                              provider.updateUPI,
                              TextInputType.text,
                              false,
                              null,
                              focusNodes[11],
                              focusNodes[12],
                              TextInputAction.next,
                            ),
                            errorWidget(context, provider.upiError),
                          ],
                        ),
                      ),
                    ],
                  ),
                ),

                // Step 3 (Contact Details)
                Step(
                  label: Text("Step 4", style: TextStyle(fontSize: 12)),
                  title: const Text(''),
                  isActive: _currentStep >= 3,
                  content: Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      Container(
                        margin: EdgeInsets.only(bottom: 10),
                        child: Text("Contact Details", style: TextStyle(color: AppColors.app_blue, fontSize: 16, fontFamily: "JakartaMedium")),
                      ),
                      Container(
                        padding: EdgeInsets.symmetric(horizontal: 10, vertical: 10),
                        decoration: BoxDecoration(color: Colors.white, borderRadius: BorderRadius.circular(16)),
                        child: Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: [
                            textControllerWidget(
                              context,
                              provider.contectPersonDesignationController,
                              "Contact Person Designation",
                              "Enter Contact Person Designation",
                              provider.updateDesignation,
                              TextInputType.text,
                              false,
                              null,
                              focusNodes[13],
                              focusNodes[14],
                              TextInputAction.next,
                            ),
                            errorWidget(context, provider.desigantionError),
                            textControllerWidget(
                              context,
                              provider.contectPersonAltMobController,
                              "Alternative Mobile Number",
                              "Enter Alternative Mobile Number",
                                  (p0) {
                                provider.updateAltMobile(p0);
                                provider.checkInputsAPI(context, "mob2", provider.contectPersonAltMobController.text);
                              },
                              TextInputType.number,
                              false,
                              FilteringTextInputFormatter.digitsOnly,
                              focusNodes[14],
                              focusNodes[15],
                              TextInputAction.next,
                              10,
                            ),
                            errorWidget(context, provider.altMobError),
                            textControllerWidget(
                              context,
                              provider.contectPersonTeleController,
                              "Telephone Number",
                              "Enter Telephone Number",
                              provider.updateTeleMobile,
                              TextInputType.number,
                              false,
                              FilteringTextInputFormatter.digitsOnly,
                              focusNodes[15],
                              focusNodes[16],
                              TextInputAction.next,
                            ),
                            errorWidget(context, provider.teleError),
                            textControllerWidget(
                              context,
                              provider.contectPersonMailController,
                              "Customer Mail ID",
                              "Enter Customer Mail ID",
                              provider.updateMail,
                              TextInputType.text,
                              false,
                              null,
                              focusNodes[16],
                              focusNodes[17],
                              TextInputAction.next,
                            ),
                            errorWidget(context, provider.mailError),
                          ],
                        ),
                      ),
                    ],
                  ),
                ),
              ],
              controlsBuilder: (context, details) {
                return Column(
                  children: [
                    if (_currentStep == 3) ...[
                      InkResponse(
                        onTap: provider.submitClickced
                            ? null
                            : () async {
                          // Before submit final: validate all required rules:
                          //  - Step 0 required
                          //  - Step 3 required
                          //  - Step 2 & Step 1 optional (but if fields present then validate)
                          // Also ensure gst/bank validations triggered if filled
                          // Trigger validations
                          // If GST present -> validate
                          if (provider.gstNumberController.text.trim().isNotEmpty) {
                            await _validateGstIfNeeded(provider);
                          }
                          if (provider.bankAcNumberController.text.trim().isNotEmpty &&
                              provider.bankIfscCotroller.text.trim().isNotEmpty) {
                            await _validateBankIfNeeded(provider);
                          }

                          // Now run provider overall validation
                          final ok = provider.validatereceiptForm(context);

                          if (!ok) {
                            // move to first error step
                            final errStep = _firstErrorStep(provider);
                            if (errStep != null) {
                              setState(() {
                                _currentStep = errStep;
                              });
                            }
                            // ensure UI updated
                            provider.notifyListeners();
                            return;
                          }

                          // All good => submit
                          provider.submitClickced = true;
                          provider.notifyListeners();
                          await provider.submitCommonAccountsAPI(context, widget.from);
                        },
                        child: Container(
                          height: 45,
                          alignment: Alignment.center,
                          margin: EdgeInsets.symmetric(horizontal: 10, vertical: 10),
                          padding: EdgeInsets.symmetric(horizontal: 10, vertical: 5),
                          decoration: BoxDecoration(color: AppColors.app_blue, borderRadius: BorderRadius.circular(15)),
                          child: provider.submitClickced
                              ? CircularProgressIndicator.adaptive(valueColor: AlwaysStoppedAnimation(AppColors.white))
                              : Text("Submit", style: TextStyle(fontSize: 15, fontFamily: "JakartaMedium", color: Colors.white)),
                        ),
                      ),
                    ] else ...[
                      InkResponse(
                        onTap: () {
                          setState(() {
                            if (_currentStep == 0) {
                              if (provider.validateStep1()) {
                                _currentStep = 1;
                              } else {
                                provider.notifyListeners();
                                _currentStep = 0;
                              }
                            } else if (_currentStep == 1) {
                              if (provider.stateSearchController.text.trim().isNotEmpty ||
                                  provider.districtSearchController.text.trim().isNotEmpty ||
                                  provider.addressController.text.trim().isNotEmpty) {
                                // user has filled something - validate
                                if (provider.validateStep2()) {
                                  _currentStep = 2;
                                } else {
                                  provider.notifyListeners();
                                }
                              } else {
                                _currentStep = 2;
                              }
                            } else if (_currentStep == 2) {
                              // trigger GST/Bank validate if fields present
                              if (provider.gstNumberController.text.trim().isNotEmpty) {
                                _validateGstIfNeeded(provider);
                              }
                              if (provider.bankAcNumberController.text.trim().isNotEmpty &&
                                  provider.bankIfscCotroller.text.trim().isNotEmpty) {
                                _validateBankIfNeeded(provider);
                              }

                              // after async validations we just try to move forward;
                              // if errors exist they will be shown and user stays after next tap
                              _currentStep = 3;
                            } else {
                              _currentStep = 0;
                            }
                          });
                        },
                        child: Container(
                          height: 45,
                          alignment: Alignment.center,
                          margin: EdgeInsets.symmetric(horizontal: 10, vertical: 10),
                          padding: EdgeInsets.symmetric(horizontal: 10, vertical: 5),
                          decoration: BoxDecoration(color: AppColors.app_blue, borderRadius: BorderRadius.circular(15)),
                          child: Text("Proceed to Next Step", textAlign: TextAlign.start, style: TextStyle(fontSize: 15, fontFamily: "JakartaMedium", color: Colors.white)),
                        ),
                      ),
                    ],
                    if (_currentStep > 0) ...[
                      TextButton(
                        onPressed: () {
                          setState(() {
                            if (_currentStep == 3) {
                              _currentStep = 2;
                            } else if (_currentStep == 2) {
                              _currentStep = 1;
                            } else if (_currentStep == 1) {
                              _currentStep = 0;
                            } else {
                              _currentStep = 0;
                            }
                          });
                        },
                        child: Text('Back', style: TextStyle(color: AppColors.app_blue, fontSize: 14)),
                      ),
                    ],
                  ],
                );
              },
            ),
          ),
        );
      },
    );
  }

  // --- Not used UI variant kept for parity with your original file ---
  Widget _scaffold1(BuildContext context) {
    return Consumer<Accountslistprovider>(
      builder: (context, provider, child) {
        return Scaffold(
          resizeToAvoidBottomInset: true,
          appBar: appbar2(
            context,
            "Add Account",
            provider.resetValues,
            SizedBox(width: 0),
          ),
          backgroundColor: AppColors.white,
          body: SizedBox(
            child: SingleChildScrollView(
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  Container(
                    padding: EdgeInsets.symmetric(horizontal: 10, vertical: 10),
                    margin: EdgeInsets.symmetric(horizontal: 10, vertical: 10),
                    decoration: BoxDecoration(
                      color: Colors.white,
                      borderRadius: BorderRadius.circular(16),
                    ),
                    child: Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        Text(
                          "Account Details",
                          style: TextStyle(
                            color: AppColors.app_blue,
                            fontSize: 16,
                            fontFamily: "JakartaMedium",
                          ),
                        ),
                        SizedBox(height: 10),
                        Text("Account"),
                        DropdownButtonHideUnderline(
                          child: Row(
                            children: [
                              Expanded(
                                child: DropdownButton2<String>(
                                  isExpanded: true,
                                  hint: const Row(
                                    children: [
                                      Expanded(
                                        child: Text(
                                          'Select Account',
                                          style: TextStyle(fontSize: 14),
                                          overflow: TextOverflow.ellipsis,
                                        ),
                                      ),
                                    ],
                                  ),
                                  items:
                                  provider.accountTypes
                                      .map(
                                        (act) => DropdownMenuItem<String>(
                                      value: act,
                                      child: Text(
                                        act,
                                        style: const TextStyle(
                                          fontSize: 14,
                                        ),
                                        overflow: TextOverflow.ellipsis,
                                      ),
                                    ),
                                  )
                                      .toList(),
                                  // value: provider.selectedAccountType,
                                  value:
                                  provider.accountTypes.contains(
                                    provider.selectedAccountType,
                                  )
                                      ? provider.selectedAccountType
                                      : null,
                                  onChanged: (value) {
                                    if (value != null) {
                                      provider.selectedAccountType = value;
                                      print(
                                        "statusId:${provider.selectedAccountType}",
                                      );
                                    }
                                  },
                                  buttonStyleData: ddtheme.buttonStyleData,
                                  iconStyleData: ddtheme.iconStyleData,
                                  menuItemStyleData: ddtheme.menuItemStyleData,
                                  dropdownStyleData: ddtheme.dropdownStyleData,
                                ),
                              ),
                            ],
                          ),
                        ),
                        errorWidget(context, provider.accountError),
                        textControllerWidget(
                          context,
                          provider.nameController,
                          "Company Name",
                          "Enter Company Name",
                              (p0) {
                            provider.updateName(p0);
                            provider.checkInputsAPI(
                              context,
                              "name",
                              provider.nameController.text,
                            );
                          },
                          TextInputType.text,
                          false,
                          null,
                          focusNodes[0],
                          focusNodes[1],
                          TextInputAction.next,
                        ),
                        errorWidget(context, provider.nameError),
                        textControllerWidget(
                          context,
                          provider.mobileController,
                          "Mobile Number",
                          "Enter Mobile",
                              (p0) {
                            provider.updateMobile(p0);
                            provider.checkInputsAPI(
                              context,
                              "mob1",
                              provider.mobileController.text,
                            );
                          },
                          TextInputType.phone,
                          false,
                          FilteringTextInputFormatter.digitsOnly,
                          focusNodes[1],
                          focusNodes[2],
                          TextInputAction.next,
                          10,
                        ),
                        errorWidget(context, provider.mobileError),
                        textControllerWidget(
                          context,
                          provider.contactPersonController,
                          "Contact Person Name",
                          "Enter Contact Person Name",
                          provider.updateContactPerson,
                          TextInputType.text,
                          false,
                          null,
                          focusNodes[12],
                          focusNodes[13],
                          TextInputAction.next,
                        ),
                        errorWidget(context, provider.contactPersonError),
                      ],
                    ),
                  ),
                  SizedBox(height: 12),
                  Column(
                    children: [
                      InkResponse(
                        onTap: () => provider.isVisible = !provider.isVisible,
                        child: Center(
                          child: Text(
                            provider.isVisible
                                ? "- Hide More Details"
                                : "+ Add More Details",
                            style: TextStyle(
                              color: AppColors.app_blue,
                              fontSize: 16,
                              fontFamily: "JakartaMedium",
                            ),
                          ),
                        ),
                      ),
                      if (provider.addMoreDetailsError != null) ...[
                        Center(
                          child: ShakeWidget(
                            key: Key("value"),
                            duration: Duration(milliseconds: 700),
                            child: Text(
                              provider.addMoreDetailsError ?? "",
                              style: TextStyle(
                                color: Colors.red,
                                fontSize: 13,
                                fontFamily: "JakartaMedium",
                              ),
                            ),
                          ),
                        ),
                      ],
                      Visibility(
                        visible: provider.isVisible,
                        child: Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: [
                            Container(
                              margin: EdgeInsets.symmetric(
                                horizontal: 10,
                                vertical: 10,
                              ),
                              padding: EdgeInsets.symmetric(
                                horizontal: 10,
                                vertical: 10,
                              ),
                              decoration: BoxDecoration(
                                color: Colors.white,
                                borderRadius: BorderRadius.circular(16),
                              ),
                              child: Column(
                                crossAxisAlignment: CrossAxisAlignment.start,
                                children: [
                                  Text("State"),
                                  DropdownButtonHideUnderline(
                                    child: Row(
                                      children: [
                                        Expanded(
                                          child: DropdownButton2<States>(
                                            focusNode: focusNodes[2],
                                            autofocus:
                                            focusNodes[2].hasFocus
                                                ? true
                                                : false,
                                            isExpanded: true,
                                            hint: Text(
                                              'Select State',
                                              style: TextStyle(fontSize: 14),
                                              overflow: TextOverflow.ellipsis,
                                            ),
                                            items:
                                            provider.states
                                                .map(
                                                  (
                                                  states,
                                                  ) => DropdownMenuItem<
                                                  States
                                              >(
                                                value: states,
                                                child: Text(
                                                  states.name ?? '',
                                                  style:
                                                  const TextStyle(
                                                    fontSize: 14,
                                                  ),
                                                  overflow:
                                                  TextOverflow
                                                      .ellipsis,
                                                ),
                                              ),
                                            )
                                                .toList(),
                                            value:
                                            provider.states.contains(
                                              provider.selectedState,
                                            )
                                                ? provider.selectedState
                                                : null,
                                            // value: provider.selectedState,
                                            onChanged: (States? value) {
                                              if (value != null) {
                                                if (provider
                                                    .states
                                                    .isNotEmpty) {
                                                  provider.selectedState =
                                                      value;
                                                  print(
                                                    "Selected Complaint Type: ${value.name}, ID: ${value.id}",
                                                  );
                                                  provider.selectedStateID =
                                                  value.id!;
                                                  print(
                                                    "hfjkshfg${provider.selectedStateID}",
                                                  );
                                                  if (provider
                                                      .selectedDistricts !=
                                                      null) {
                                                    provider.states.clear();
                                                    // provider.selectedDistricts = null;
                                                    provider.selectedDistrictId =
                                                    null;
                                                    provider.selectedDistrictValue =
                                                    null;
                                                  }

                                                  provider.getDistrictAPI(
                                                    context,
                                                    provider.selectedStateID,
                                                  );
                                                }
                                              }
                                            },

                                            dropdownSearchData: DropdownSearchData(
                                              searchInnerWidgetHeight: 50,
                                              searchController:
                                              provider
                                                  .stateSearchController,
                                              searchInnerWidget: Padding(
                                                padding: const EdgeInsets.all(
                                                  8,
                                                ),
                                                child: TextFormField(
                                                  controller:
                                                  provider
                                                      .stateSearchController,
                                                  decoration: InputDecoration(
                                                    isDense: true,
                                                    contentPadding:
                                                    const EdgeInsets.symmetric(
                                                      horizontal: 10,
                                                      vertical: 8,
                                                    ),
                                                    hintText:
                                                    'Search States...',
                                                    border: OutlineInputBorder(
                                                      borderRadius:
                                                      BorderRadius.circular(
                                                        8,
                                                      ),
                                                    ),
                                                  ),
                                                ),
                                              ),
                                              searchMatchFn: (
                                                  item,
                                                  searchValue,
                                                  ) {
                                                return item.value?.name
                                                    ?.toLowerCase()
                                                    .contains(
                                                  searchValue
                                                      .toLowerCase(),
                                                ) ??
                                                    false;
                                              },
                                            ),
                                            onMenuStateChange: (isOpen) {
                                              if (!isOpen) {
                                                provider.stateSearchController
                                                    .clear();
                                              }
                                            },
                                            buttonStyleData:
                                            ddtheme.buttonStyleData,
                                            iconStyleData:
                                            ddtheme.iconStyleData,
                                            menuItemStyleData:
                                            ddtheme.menuItemStyleData,
                                            dropdownStyleData:
                                            ddtheme.dropdownStyleData,
                                          ),
                                        ),
                                      ],
                                    ),
                                  ),
                                  errorWidget(context, provider.stateError),
                                  Text("District"),
                                  DropdownButtonHideUnderline(
                                    child: Row(
                                      children: [
                                        Expanded(
                                          child: DropdownButton2<Districts>(
                                            focusNode: focusNodes[3],
                                            isExpanded: true,
                                            hint: Text(
                                              'Select District',
                                              style: TextStyle(fontSize: 14),
                                              overflow: TextOverflow.ellipsis,
                                            ),
                                            items:
                                            provider.districts
                                                .map(
                                                  (
                                                  dist,
                                                  ) => DropdownMenuItem<
                                                  Districts
                                              >(
                                                value: dist,
                                                child: Text(
                                                  dist.district ?? '',
                                                  style:
                                                  const TextStyle(
                                                    fontSize: 14,
                                                  ),
                                                  overflow:
                                                  TextOverflow
                                                      .ellipsis,
                                                ),
                                              ),
                                            )
                                                .toList(),
                                            value:
                                            provider.districts.contains(
                                              provider
                                                  .selectedDistricts,
                                            )
                                                ? provider.selectedDistricts
                                                : null,
                                            // value: provider.selectedDistricts,
                                            onChanged: (Districts? value) {
                                              if (value != null) {
                                                if (provider
                                                    .districts
                                                    .isNotEmpty) {
                                                  provider.selectedDistricts =
                                                      value;
                                                  print(
                                                    "Selected ID: ${value.id}",
                                                  );
                                                  provider.selectedDistrictId =
                                                  value.id!;
                                                  provider.selectedDistrictValue =
                                                  value.district!;
                                                  print(
                                                    "hfjkshfg${provider.selectedDistrictId}",
                                                  );
                                                  if (provider
                                                      .selectedSubLocations !=
                                                      null) {
                                                    // provider.selectedSubLocations =
                                                    // null;
                                                    provider.selectedSubLocID =
                                                    null;
                                                    provider.selectedSubLocValue =
                                                    null;
                                                  }
                                                  provider.getSubLocationAPI(
                                                    context,
                                                    provider.selectedDistrictId,
                                                  );
                                                }
                                              }
                                            },
                                            dropdownSearchData: DropdownSearchData(
                                              searchInnerWidgetHeight: 50,
                                              searchController:
                                              provider
                                                  .districtSearchController,
                                              searchInnerWidget: Padding(
                                                padding: const EdgeInsets.all(
                                                  8,
                                                ),
                                                child: TextFormField(
                                                  controller:
                                                  provider
                                                      .districtSearchController,
                                                  decoration: InputDecoration(
                                                    isDense: true,
                                                    contentPadding:
                                                    const EdgeInsets.symmetric(
                                                      horizontal: 10,
                                                      vertical: 8,
                                                    ),
                                                    hintText:
                                                    'Search Districts...',
                                                    border: OutlineInputBorder(
                                                      borderRadius:
                                                      BorderRadius.circular(
                                                        8,
                                                      ),
                                                    ),
                                                  ),
                                                ),
                                              ),
                                              searchMatchFn: (
                                                  item,
                                                  searchValue,
                                                  ) {
                                                return item.value?.district
                                                    ?.toLowerCase()
                                                    .contains(
                                                  searchValue
                                                      .toLowerCase(),
                                                ) ??
                                                    false;
                                              },
                                            ),
                                            onMenuStateChange: (isOpen) {
                                              if (!isOpen) {
                                                provider
                                                    .districtSearchController
                                                    .clear();
                                              }
                                            },
                                            buttonStyleData:
                                            ddtheme.buttonStyleData,
                                            iconStyleData:
                                            ddtheme.iconStyleData,
                                            menuItemStyleData:
                                            ddtheme.menuItemStyleData,
                                            dropdownStyleData:
                                            ddtheme.dropdownStyleData,
                                          ),
                                        ),
                                      ],
                                    ),
                                  ),
                                  errorWidget(context, provider.districtError),
                                  Text("Sub Locality"),
                                  DropdownButtonHideUnderline(
                                    child: Row(
                                      children: [
                                        Expanded(
                                          child: DropdownButton2<SubLocations>(
                                            focusNode: focusNodes[4],
                                            isExpanded: true,
                                            hint: Text(
                                              'Select Sub Locality',
                                              style: TextStyle(fontSize: 14),
                                              overflow: TextOverflow.ellipsis,
                                            ),
                                            items:
                                            provider.subLocations
                                                .map(
                                                  (
                                                  subloc,
                                                  ) => DropdownMenuItem<
                                                  SubLocations
                                              >(
                                                value: subloc,
                                                child: Text(
                                                  subloc.subLocality ??
                                                      '',
                                                  style:
                                                  const TextStyle(
                                                    fontSize: 14,
                                                  ),
                                                  overflow:
                                                  TextOverflow
                                                      .ellipsis,
                                                ),
                                              ),
                                            )
                                                .toList(),
                                            // value: provider.selectedSubLocations,
                                            value:
                                            provider.subLocations.contains(
                                              provider
                                                  .selectedSubLocations,
                                            )
                                                ? provider
                                                .selectedSubLocations
                                                : null,
                                            onChanged: (SubLocations? value) {
                                              if (value != null) {
                                                if (provider
                                                    .subLocations
                                                    .isNotEmpty) {
                                                  provider.selectedSubLocations =
                                                      value;
                                                  print(
                                                    "Selected ID: ${value.id}",
                                                  );
                                                  provider.selectedSubLocID =
                                                  value.id!;
                                                  provider.selectedSubLocValue =
                                                  value.subLocality!;
                                                  print(
                                                    "hfjkshfg${provider.selectedSubLocID}",
                                                  );
                                                }
                                              }
                                            },
                                            dropdownSearchData: DropdownSearchData(
                                              searchInnerWidgetHeight: 50,
                                              searchController:
                                              provider
                                                  .subLocSearchController,
                                              searchInnerWidget: Padding(
                                                padding: const EdgeInsets.all(
                                                  8,
                                                ),
                                                child: TextFormField(
                                                  controller:
                                                  provider
                                                      .subLocSearchController,
                                                  decoration: InputDecoration(
                                                    isDense: true,
                                                    contentPadding:
                                                    const EdgeInsets.symmetric(
                                                      horizontal: 10,
                                                      vertical: 8,
                                                    ),
                                                    hintText:
                                                    'Search Sub Locality...',
                                                    border: OutlineInputBorder(
                                                      borderRadius:
                                                      BorderRadius.circular(
                                                        8,
                                                      ),
                                                    ),
                                                  ),
                                                ),
                                              ),
                                              searchMatchFn: (
                                                  item,
                                                  searchValue,
                                                  ) {
                                                return item.value?.subLocality
                                                    ?.toLowerCase()
                                                    .contains(
                                                  searchValue
                                                      .toLowerCase(),
                                                ) ??
                                                    false;
                                              },
                                            ),
                                            onMenuStateChange: (isOpen) {
                                              if (!isOpen) {
                                                provider.subLocSearchController
                                                    .clear();
                                              }
                                            },
                                            buttonStyleData:
                                            ddtheme.buttonStyleData,
                                            iconStyleData:
                                            ddtheme.iconStyleData,
                                            menuItemStyleData:
                                            ddtheme.menuItemStyleData,
                                            dropdownStyleData:
                                            ddtheme.dropdownStyleData,
                                          ),
                                        ),
                                      ],
                                    ),
                                  ),
                                  errorWidget(context, provider.localityError),
                                  textControllerWidget(
                                    context,
                                    provider.addressController,
                                    "Address",
                                    "Enter Address",
                                    provider.updateAddress,
                                    TextInputType.text,
                                    false,
                                    null,
                                    focusNodes[5],
                                    null,
                                    TextInputAction.done,
                                  ),
                                  errorWidget(context, provider.addressError),
                                  Text(
                                    "Bank Details",
                                    style: TextStyle(
                                      color: AppColors.app_blue,
                                      fontSize: 16,
                                      fontFamily: "JakartaMedium",
                                    ),
                                  ),
                                  textControllerWidget(
                                    context,
                                    provider.bankNameController,
                                    "Bank Name",
                                    "Enter Bank Name",
                                    provider.updateBankName,
                                    TextInputType.text,
                                    false,
                                    null,
                                    focusNodes[6],
                                    focusNodes[7],
                                    TextInputAction.next,
                                  ),
                                  errorWidget(context, provider.banknameError),
                                  textControllerWidget(
                                    context,
                                    provider.branchNameController,
                                    "Bank Branch",
                                    "Enter Bank Branch",
                                    provider.updateBankBranch,
                                    TextInputType.text,
                                    false,
                                    null,
                                    focusNodes[7],
                                    focusNodes[8],
                                    TextInputAction.next,
                                  ),
                                  errorWidget(
                                    context,
                                    provider.bankBranchError,
                                  ),
                                  textControllerWidget(
                                    context,
                                    provider.bankIfscCotroller,
                                    "Bank IFSC",
                                    "Enter Bank IFSC",
                                    provider.updateIFSC,
                                    TextInputType.text,
                                    false,
                                    null,
                                    focusNodes[8],
                                    focusNodes[9],
                                    TextInputAction.next,
                                  ),
                                  errorWidget(context, provider.bankIFSCError),
                                  textControllerWidget(
                                    context,
                                    provider.bankHolderNameController,
                                    "Bank Holder Name",
                                    "Enter Bank Holder Name",
                                    provider.updateHolder,
                                    TextInputType.text,
                                    false,
                                    null,
                                    focusNodes[9],
                                    focusNodes[10],
                                    TextInputAction.next,
                                  ),
                                  errorWidget(
                                    context,
                                    provider.bankHolderNameError,
                                  ),
                                  textControllerWidget(
                                    context,
                                    provider.bankAcNumberController,
                                    "Bank Account Number",
                                    "Enter Bank Account Number",
                                    provider.updateNumber,
                                    TextInputType.number,
                                    false,
                                    FilteringTextInputFormatter.digitsOnly,
                                    focusNodes[10],
                                    focusNodes[11],
                                    TextInputAction.next,
                                  ),
                                  errorWidget(
                                    context,
                                    provider.bankAcNumberError,
                                  ),
                                  textControllerWidget(
                                    context,
                                    provider.bankUpiController,
                                    "Bank UPI ID",
                                    "Enter Bank UPI ID",
                                    provider.updateUPI,
                                    TextInputType.text,
                                    false,
                                    null,
                                    focusNodes[11],
                                    focusNodes[12],
                                    TextInputAction.next,
                                  ),
                                  errorWidget(context, provider.upiError),
                                ],
                              ),
                            ),
                            Container(
                              margin: EdgeInsets.symmetric(
                                horizontal: 10,
                                vertical: 10,
                              ),
                              padding: EdgeInsets.symmetric(
                                horizontal: 10,
                                vertical: 10,
                              ),
                              decoration: BoxDecoration(
                                color: Colors.white,
                                borderRadius: BorderRadius.circular(16),
                              ),
                              child: Column(
                                crossAxisAlignment: CrossAxisAlignment.start,
                                children: [
                                  Text(
                                    "Contact Details",
                                    style: TextStyle(
                                      color: AppColors.app_blue,
                                      fontSize: 16,
                                      fontFamily: "JakartaMedium",
                                    ),
                                  ),

                                  textControllerWidget(
                                    context,
                                    provider.contectPersonDesignationController,
                                    "Contact Person Designation",
                                    "Enter Contact Person Designation",
                                    provider.updateDesignation,
                                    TextInputType.text,
                                    false,
                                    null,
                                    focusNodes[13],
                                    focusNodes[14],
                                    TextInputAction.next,
                                  ),
                                  errorWidget(
                                    context,
                                    provider.desigantionError,
                                  ),
                                  textControllerWidget(
                                    context,
                                    provider.contectPersonAltMobController,
                                    "Alternative Mobile Number",
                                    "Enter Alternative Mobile Number",
                                        (p0) {
                                      provider.updateAltMobile(p0);
                                      provider.checkInputsAPI(
                                        context,
                                        "mob2",
                                        provider
                                            .contectPersonAltMobController
                                            .text,
                                      );
                                    },
                                    TextInputType.number,
                                    false,
                                    FilteringTextInputFormatter.digitsOnly,
                                    focusNodes[14],
                                    focusNodes[15],
                                    TextInputAction.next,
                                    10,
                                  ),
                                  errorWidget(context, provider.altMobError),
                                  textControllerWidget(
                                    context,
                                    provider.contectPersonTeleController,
                                    "Telephone Number",
                                    "Enter Telephone Number",
                                    provider.updateTeleMobile,
                                    TextInputType.number,
                                    false,
                                    FilteringTextInputFormatter.digitsOnly,
                                    focusNodes[15],
                                    focusNodes[16],
                                    TextInputAction.next,
                                  ),
                                  errorWidget(context, provider.teleError),
                                  textControllerWidget(
                                    context,
                                    provider.contectPersonMailController,
                                    "Customer Mail ID",
                                    "Enter Customer Mail ID",
                                    provider.updateMail,
                                    TextInputType.text,
                                    false,
                                    null,
                                    focusNodes[16],
                                    focusNodes[17],
                                    TextInputAction.next,
                                  ),
                                  errorWidget(context, provider.mailError),
                                ],
                              ),
                            ),
                          ],
                        ),
                      ),
                    ],
                  ),
                ],
              ),
            ),
          ),

          bottomNavigationBar: InkResponse(
            onTap:
            provider.submitClickced
                ? null
                : () {
              provider.submitClickced = true;
              provider.submitCommonAccountsAPI(context, widget.from);
            },
            child: Container(
              height: 45,
              alignment: Alignment.center,
              margin: EdgeInsets.symmetric(horizontal: 10, vertical: 15),
              padding: EdgeInsets.symmetric(horizontal: 10, vertical: 5),
              decoration: BoxDecoration(
                color: AppColors.app_blue,
                borderRadius: BorderRadius.circular(15),
              ),
              child:
              provider.submitClickced
                  ? CircularProgressIndicator.adaptive(
                valueColor: AlwaysStoppedAnimation(AppColors.white),
              )
                  : Text(
                "Submit",
                style: TextStyle(
                  fontSize: 15,
                  fontFamily: "JakartaMedium",
                  color: Colors.white,
                ),
              ),
            ),
          ),
        );
      },
    );
  }
}
