class ordersListByModeFilterResponse {
  List<Employees>? employees;
  List<String>? leadStatus;
  String? error;
  String? message;

  ordersListByModeFilterResponse({
    this.employees,
    this.leadStatus,
    this.error,
    this.message,
  });

  ordersListByModeFilterResponse.fromJson(Map<String, dynamic> json) {
    if (json['employees'] != null) {
      employees = <Employees>[];
      json['employees'].forEach((v) {
        employees!.add(Employees.fromJson(v));
      });
    }
    leadStatus = json['lead_status'].cast<String>();
    error = json['error'];
    message = json['message'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    if (employees != null) {
      data['employees'] = employees!.map((v) => v.toJson()).toList();
    }
    data['lead_status'] = leadStatus;
    data['error'] = error;
    data['message'] = message;
    return data;
  }
}

class Employees {
  String? id;
  String? name;

  Employees({this.id, this.name});

  Employees.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    name = json['name'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['name'] = name;
    return data;
  }
}
