class orderDashboardResponse {
  Ordergain? ordergain;
  Ordergain? dispatches;
  Ordergain? pendingTasks;
  Ordergain? quote;
  String? error;
  String? message;

  orderDashboardResponse({
    this.ordergain,
    this.dispatches,
    this.pendingTasks,
    this.quote,
    this.error,
    this.message,
  });

  orderDashboardResponse.fromJson(Map<String, dynamic> json) {
    ordergain =
        json['ordergain'] != null
            ? Ordergain.fromJson(json['ordergain'])
            : null;
    dispatches =
        json['dispatches'] != null
            ? Ordergain.fromJson(json['dispatches'])
            : null;
    pendingTasks =
        json['pending_tasks'] != null
            ? Ordergain.fromJson(json['pending_tasks'])
            : null;
    quote = json['quote'] != null ? Ordergain.fromJson(json['quote']) : null;
    error = json['error'];
    message = json['message'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    if (ordergain != null) {
      data['ordergain'] = ordergain!.toJson();
    }
    if (dispatches != null) {
      data['dispatches'] = dispatches!.toJson();
    }
    if (pendingTasks != null) {
      data['pending_tasks'] = pendingTasks!.toJson();
    }
    if (quote != null) {
      data['quote'] = quote!.toJson();
    }
    data['error'] = error;
    data['message'] = message;
    return data;
  }
}

class Ordergain {
  String? count;
  Filter? filter;

  Ordergain({this.count, this.filter});

  Ordergain.fromJson(Map<String, dynamic> json) {
    count = json['count'];
    filter = json['filter'] != null ? Filter.fromJson(json['filter']) : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['count'] = count;
    if (filter != null) {
      data['filter'] = filter!.toJson();
    }
    return data;
  }
}

class Filter {
  String? id;
  String? pageName;
  String? mode;
  String? openStatus;
  String? status;

  Filter({this.id, this.pageName, this.mode, this.openStatus, this.status});

  Filter.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    pageName = json['page_name'];
    mode = json['mode'];
    openStatus = json['open_status'];
    status = json['status'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['page_name'] = pageName;
    data['mode'] = mode;
    data['open_status'] = openStatus;
    data['status'] = status;
    return data;
  }
}
