class addReceiptPaymentResponse {
  List<Accounts>? accounts;
  List<ReceiptAccounts>? receiptAccounts;
  List<PaymentModes>? paymentModes;
  String? error;
  String? message;

  addReceiptPaymentResponse({
    this.accounts,
    this.receiptAccounts,
    this.paymentModes,
    this.error,
    this.message,
  });

  addReceiptPaymentResponse.fromJson(Map<String, dynamic> json) {
    if (json['accounts'] != null) {
      accounts = <Accounts>[];
      json['accounts'].forEach((v) {
        accounts!.add(Accounts.fromJson(v));
      });
    }
    if (json['receipt_accounts'] != null) {
      receiptAccounts = <ReceiptAccounts>[];
      json['receipt_accounts'].forEach((v) {
        receiptAccounts!.add(ReceiptAccounts.fromJson(v));
      });
    }
    if (json['payment_modes'] != null) {
      paymentModes = <PaymentModes>[];
      json['payment_modes'].forEach((v) {
        paymentModes!.add(PaymentModes.fromJson(v));
      });
    }
    error = json['error'];
    message = json['message'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    if (accounts != null) {
      data['accounts'] = accounts!.map((v) => v.toJson()).toList();
    }
    if (receiptAccounts != null) {
      data['receipt_accounts'] =
          receiptAccounts!.map((v) => v.toJson()).toList();
    }
    if (paymentModes != null) {
      data['payment_modes'] = paymentModes!.map((v) => v.toJson()).toList();
    }
    data['error'] = error;
    data['message'] = message;
    return data;
  }
}

class Accounts {
  String? id;
  String? name;

  Accounts({this.id, this.name});

  Accounts.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    name = json['name'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['name'] = name;
    return data;
  }
}

class ReceiptAccounts {
  String? id;
  String? name;

  ReceiptAccounts({this.id, this.name});

  ReceiptAccounts.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    name = json['name'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['name'] = name;
    return data;
  }
}

class PaymentModes {
  String? id;
  String? name;

  PaymentModes({this.id, this.name});

  PaymentModes.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    name = json['name'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['name'] = name;
    return data;
  }
}
