import 'dart:io';

import 'package:connectivity_plus/connectivity_plus.dart';
import 'package:flutter/material.dart';
import 'package:flutter_slidable/flutter_slidable.dart';
import 'package:flutter_svg/svg.dart';
import 'package:generp/Utils/commonWidgets.dart';
import 'package:provider/provider.dart';
import 'package:url_launcher/url_launcher.dart';
import 'package:generp/screens/screensExports.dart';
import '../../Notifiers/TodayMontlyVisitsProvider.dart';
import '../../Utils/app_colors.dart';
import '../../Utils/commonServices.dart';

class Todaymontlyvisists extends StatefulWidget {
  final String visitType;

  const Todaymontlyvisists({super.key, required this.visitType});

  @override
  State<Todaymontlyvisists> createState() => _TodaymontlyvisistsState();
}

class _TodaymontlyvisistsState extends State<Todaymontlyvisists> {
  Map _source = {ConnectivityResult.mobile: true};
  final MyConnectivity _connectivity = MyConnectivity.instance;

  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    _connectivity.initialise();
    _connectivity.myStream.listen((source) {
      setState(() => _source = source);
    });
    WidgetsBinding.instance.addPostFrameCallback((_) {
      var visitsProvider = Provider.of<Todaymontlyvisitsprovider>(
        context,
        listen: false,
      );

      switch (widget.visitType) {
        case "Month":
          visitsProvider.title = "Monthly Visits";
          visitsProvider.LoadMonthVisitsListAPI(context);
          break;
        case "Today":
          visitsProvider.title = "Today Visits";
          visitsProvider.LoadTodayVisitsListAPI(context);
          break;
      }
    });
  }

  @override
  void dispose() {
    // TODO: implement dispose
    _connectivity.disposeStream();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    switch (_source.keys.toList()[0]) {
      case ConnectivityResult.mobile:
        connection = 'Online';
        break;
      case ConnectivityResult.wifi:
        connection = 'Online';
        break;
      case ConnectivityResult.none:
      default:
        connection = 'Offline';
    }
    return (connection == "Online")
        ? Platform.isAndroid
            ? WillPopScope(
              onWillPop: () => onBackPressed(context),
              child: SafeArea(
                top: false,
                bottom: true,
                child: _scaffold1(context),
              ),
            )
            : _scaffold1(context)
        : NoNetwork(context);
  }

  @override
  Widget _scaffold1(BuildContext context) {
    return Consumer<Todaymontlyvisitsprovider>(
      builder: (context, provider, child) {
        return WillPopScope(
          onWillPop: () => onBackPressed(context),
          child: SafeArea(
            top: false,
            bottom: Platform.isIOS ? false : true,
            child: Scaffold(
              resizeToAvoidBottomInset: true,
              backgroundColor: AppColors.scaffold_bg_color,
              appBar: appbarNew(context, provider.title, 0xFFFFFFFF),
              body:
                  provider.visitsList.isNotEmpty
                      ? Container(
                        child: ListView.builder(
                          scrollDirection: Axis.vertical,
                          shrinkWrap: true,
                          itemCount: provider.visitsList.length,
                          padding: EdgeInsets.symmetric(
                            horizontal: 10,
                            vertical: 10,
                          ),

                          itemBuilder: (context, index) {
                            return InkResponse(
                              onTap: () {
                                Navigator.push(
                                  context,
                                  MaterialPageRoute(
                                    builder:
                                        (context) => Visitdetails(
                                          complaintID:
                                              provider
                                                  .visitsList[index]
                                                  .complaintId,
                                        ),
                                  ),
                                );
                              },
                              child: Container(
                                // padding: EdgeInsets.symmetric(
                                //   horizontal: 10,
                                //   vertical: 0,
                                // ),
                                margin: EdgeInsets.symmetric(vertical: 5),
                                decoration: BoxDecoration(
                                  color: Colors.white,
                                  borderRadius: BorderRadius.circular(20),
                                ),
                                child: ClipRRect(
                                  borderRadius: BorderRadius.circular(20),
                                  child: Slidable(
                                    endActionPane: ActionPane(
                                      motion: const ScrollMotion(),
                                      key: ValueKey(
                                        provider.visitsList[index].complaintId,
                                      ),
                                      dragDismissible: false,

                                      // dismissible: DismissiblePane(
                                      //
                                      //   onDismissed: () {},
                                      // closeOnCancel: true,
                                      // resizeDuration: Duration(milliseconds: 300),),
                                      children: [
                                        SlidableAction(
                                          onPressed: (context) {
                                            Navigator.push(
                                              context,
                                              MaterialPageRoute(
                                                builder:
                                                    (context) => Paymentdetails(
                                                      accountName: "Generator",
                                                      name:
                                                          provider
                                                              .visitsList[index]
                                                              .companyName,
                                                      genId:
                                                          provider
                                                              .visitsList[index]
                                                              .genId,
                                                      referenceID:
                                                          provider
                                                              .visitsList[index]
                                                              .complaintId,
                                                    ),
                                              ),
                                            );
                                          },
                                          backgroundColor: Color(0xFFE7FFE5),
                                          foregroundColor: Color(0xFF0D9C00),
                                          icon: Icons.add,
                                          label: 'Payment Details',
                                        ),
                                      ],
                                    ),

                                    child: Container(
                                      margin: EdgeInsets.symmetric(vertical: 5),
                                      padding: EdgeInsets.symmetric(
                                        horizontal: 10,
                                        vertical: 0,
                                      ),
                                      child: Column(
                                        crossAxisAlignment:
                                            CrossAxisAlignment.start,
                                        children: [
                                          Row(
                                            crossAxisAlignment:
                                                CrossAxisAlignment.center,
                                            mainAxisAlignment:
                                                MainAxisAlignment.center,
                                            children: [
                                              Expanded(
                                                flex: 1,
                                                child: Container(
                                                  padding: EdgeInsets.symmetric(
                                                    horizontal: 10,
                                                    vertical: 10,
                                                  ),
                                                  decoration: BoxDecoration(
                                                    color: Color(0xFFE6F6FF),
                                                    shape: BoxShape.circle,
                                                  ),
                                                  child: SvgPicture.asset(
                                                    width: 30,
                                                    height: 30,
                                                    "assets/svg/se_block_head.svg",
                                                  ),
                                                ),
                                              ),
                                              SizedBox(width: 5),

                                              Expanded(
                                                flex: 4,
                                                child: SizedBox(
                                                  child: Column(
                                                    crossAxisAlignment:
                                                        CrossAxisAlignment
                                                            .start,
                                                    children: [
                                                      Text(
                                                        provider
                                                                .visitsList[index]
                                                                .contactName ??
                                                            "-",
                                                        maxLines: 1,
                                                        overflow:
                                                            TextOverflow
                                                                .ellipsis,
                                                        style: TextStyle(
                                                          fontFamily:
                                                              "JakartaMedium",
                                                        ),
                                                      ),
                                                      Text(
                                                        "${provider.visitsList[index].companyName}",
                                                        maxLines: 1,
                                                        overflow:
                                                            TextOverflow
                                                                .ellipsis,
                                                        style: TextStyle(
                                                          color: Color(
                                                            0xFF818181,
                                                          ),
                                                        ),
                                                      ),
                                                    ],
                                                  ),
                                                ),
                                              ),
                                              Spacer(),
                                              Expanded(
                                                flex: 1,
                                                child: InkResponse(
                                                  onTap: () {
                                                    launch(
                                                      'tel://${provider.visitsList[index].mobileNo}',
                                                    );
                                                  },
                                                  child: SvgPicture.asset(
                                                    "assets/svg/se_call_customer.svg",
                                                    color: Color(0xFF0D9C00),
                                                    height: 20,
                                                    width: 20,
                                                  ),
                                                ),
                                              ),
                                            ],
                                          ),
                                        ],
                                      ),
                                    ),
                                  ),
                                ),
                              ),
                            );
                          },
                        ),
                      )
                      : Emptywidget(context),
            ),
          ),
        );
      },
    );
  }

  Widget _scaffold(BuildContext context) {
    return Consumer<Todaymontlyvisitsprovider>(
      builder: (context, provider, child) {
        return WillPopScope(
          onWillPop: () => onBackPressed(context),
          child: SafeArea(
            top: false,
            bottom: Platform.isIOS ? false : true,
            child: Scaffold(
              resizeToAvoidBottomInset: true,
              backgroundColor: AppColors.scaffold_bg_color,
              appBar: appbar(context, provider.title),
              body:
                  provider.visitsList.isNotEmpty
                      ? Container(
                        child: ListView.builder(
                          scrollDirection: Axis.vertical,
                          shrinkWrap: true,
                          itemCount: provider.visitsList.length,
                          padding: EdgeInsets.symmetric(
                            horizontal: 10,
                            vertical: 10,
                          ),

                          itemBuilder: (context, index) {
                            return Container(
                              padding: EdgeInsets.symmetric(
                                horizontal: 10,
                                vertical: 10,
                              ),
                              margin: EdgeInsets.symmetric(vertical: 5),
                              decoration: BoxDecoration(
                                color: Colors.white,
                                borderRadius: BorderRadius.circular(20),
                              ),
                              child: Column(
                                crossAxisAlignment: CrossAxisAlignment.start,
                                children: [
                                  Row(
                                    crossAxisAlignment:
                                        CrossAxisAlignment.center,
                                    mainAxisAlignment: MainAxisAlignment.center,
                                    children: [
                                      Expanded(
                                        flex: 1,
                                        child: Container(
                                          padding: EdgeInsets.symmetric(
                                            horizontal: 10,
                                            vertical: 10,
                                          ),
                                          decoration: BoxDecoration(
                                            color: Color(0xFFE6F6FF),
                                            borderRadius: BorderRadius.circular(
                                              8,
                                            ),
                                          ),
                                          child: SvgPicture.asset(
                                            width: 30,
                                            height: 30,
                                            "assets/svg/se_block_head.svg",
                                          ),
                                        ),
                                      ),
                                      SizedBox(width: 5),

                                      Expanded(
                                        flex: 4,
                                        child: SizedBox(
                                          child: Column(
                                            crossAxisAlignment:
                                                CrossAxisAlignment.start,
                                            children: [
                                              Text(
                                                provider
                                                        .visitsList[index]
                                                        .contactName ??
                                                    "-",
                                                maxLines: 1,
                                                overflow: TextOverflow.ellipsis,
                                                style: TextStyle(
                                                  fontFamily: "JakartaMedium",
                                                ),
                                              ),
                                              Text(
                                                "${provider.visitsList[index].companyName}",
                                                maxLines: 1,
                                                overflow: TextOverflow.ellipsis,
                                                style: TextStyle(
                                                  color: Color(0xFF818181),
                                                ),
                                              ),
                                            ],
                                          ),
                                        ),
                                      ),
                                      Spacer(),
                                      Expanded(
                                        flex: 1,
                                        child: InkResponse(
                                          onTap: () {
                                            launch(
                                              'tel://${provider.visitsList[index].mobileNo}',
                                            );
                                          },
                                          child: SvgPicture.asset(
                                            "assets/svg/se_call_customer.svg",
                                            color: Color(0xFF0D9C00),
                                            height: 20,
                                            width: 20,
                                          ),
                                        ),
                                      ),
                                      // Expanded(
                                      //   flex: 1,
                                      //   child: InkResponse(
                                      //     onTap: () {
                                      //       _showOptionsSheet(context);
                                      //     },
                                      //     child: Icon(Icons.more_vert),
                                      //   ),
                                      // ),
                                    ],
                                  ),
                                  Padding(
                                    padding: const EdgeInsets.all(8.0),
                                    child: Divider(
                                      thickness: 0.5,
                                      color: Color(0xFFD7D7D7),
                                    ),
                                  ),
                                  ...List.generate(3, (j) {
                                    final textheads = [
                                      "ID",
                                      "Generator Type",
                                      "Address",
                                    ];
                                    final textSubheads = [
                                      provider.visitsList[index].genId,
                                      provider.visitsList[index].productName,
                                      provider.visitsList[index].address,
                                    ];
                                    return Container(
                                      padding: EdgeInsets.symmetric(
                                        vertical: 3,
                                      ),
                                      child: Row(
                                        crossAxisAlignment:
                                            CrossAxisAlignment.start,
                                        children: [
                                          Expanded(
                                            flex: 1,
                                            child: Text(
                                              textheads[j].toString(),
                                              style: TextStyle(
                                                fontFamily: "JakartaMedium",
                                              ),
                                            ),
                                          ),
                                          Expanded(
                                            flex: 2,
                                            child: Text(
                                              textSubheads[j].toString(),
                                              style: TextStyle(
                                                color: Color(0xFF818181),
                                              ),
                                            ),
                                          ),
                                        ],
                                      ),
                                    );
                                  }),
                                  SizedBox(
                                    child: Row(
                                      mainAxisAlignment:
                                          MainAxisAlignment.spaceBetween,
                                      children: [
                                        InkResponse(
                                          onTap: () {
                                            Navigator.push(
                                              context,
                                              MaterialPageRoute(
                                                builder:
                                                    (context) => Paymentdetails(
                                                      accountName: "Generator",
                                                      name:
                                                          provider
                                                              .visitsList[index]
                                                              .companyName,
                                                      genId:
                                                          provider
                                                              .visitsList[index]
                                                              .genId,
                                                      referenceID:
                                                          provider
                                                              .visitsList[index]
                                                              .complaintId,
                                                    ),
                                              ),
                                            );
                                          },
                                          child: SvgPicture.asset(
                                            "assets/svg/se_payment_details.svg",
                                          ),
                                        ),
                                        Spacer(),
                                        InkResponse(
                                          onTap: () {
                                            Navigator.push(
                                              context,
                                              MaterialPageRoute(
                                                builder:
                                                    (context) => Visitdetails(
                                                      complaintID:
                                                          provider
                                                              .visitsList[index]
                                                              .complaintId,
                                                    ),
                                              ),
                                            );
                                          },
                                          child: Row(
                                            mainAxisAlignment:
                                                MainAxisAlignment.start,
                                            crossAxisAlignment:
                                                CrossAxisAlignment.center,
                                            children: [
                                              Text(
                                                "View Details",
                                                style: TextStyle(
                                                  fontFamily: "JakartaMedium",
                                                  color: AppColors.app_blue,
                                                ),
                                              ),
                                              SizedBox(width: 5),
                                              SvgPicture.asset(
                                                "assets/svg/next_button.svg",
                                              ),
                                            ],
                                          ),
                                        ),
                                      ],
                                    ),
                                  ),
                                ],
                              ),
                            );
                          },
                        ),
                      )
                      : Emptywidget(context),
            ),
          ),
        );
      },
    );
  }

  // Future<void> _showOptionsSheet(BuildContext context) {
  //   return showModalBottomSheet(
  //     useSafeArea: true,
  //     isDismissible: true,
  //     isScrollControlled: true,
  //     showDragHandle: true,
  //     backgroundColor: Colors.white,
  //     enableDrag: true,
  //     context: context,
  //     builder: (context) {
  //       return StatefulBuilder(
  //         builder: (context, setState) {
  //           return SafeArea(
  //             child: Consumer<Todaymontlyvisitsprovider>(
  //               builder: (context, provider, child) {
  //                 return Container(
  //                   margin: EdgeInsets.only(
  //                     bottom: 15,
  //                     left: 15,
  //                     right: 15,
  //                     top: 10,
  //                   ),
  //
  //                   child: SingleChildScrollView(
  //                     child: Column(
  //                       mainAxisSize: MainAxisSize.min,
  //                       children: [
  //                         SizedBox(height: 15),
  //
  //                         ListTile(
  //                           onTap: () async {
  //                             // _showUpdateComplaintSheet(context,provider.visitsList[index].complaintId);
  //                           },
  //                           leading: SvgPicture.asset(
  //                             "assets/svg/se_payment_details.svg",
  //                           ),
  //                           title: Text("Payment Details"),
  //                           trailing: Icon(
  //                             Icons.arrow_forward_ios_sharp,
  //                             size: 16,
  //                           ),
  //                         ),
  //                       ],
  //                     ),
  //                   ),
  //                 );
  //               },
  //             ),
  //           );
  //         },
  //       );
  //     },
  //   );
  // }
}
