import 'dart:io';

import 'package:flutter/material.dart';
import 'package:flutter_svg/svg.dart';
import 'package:generp/Notifiers/PaymentCollectionProvider.dart';
import 'package:generp/Utils/commonWidgets.dart';
import 'package:generp/screens/WebERPScreen.dart';
import 'package:provider/provider.dart';

import '../../Utils/app_colors.dart';
import 'AccountSuggestions.dart';

class Monthlycollection extends StatefulWidget {
  const Monthlycollection({super.key});

  @override
  State<Monthlycollection> createState() => _MonthlycollectionState();
}

class _MonthlycollectionState extends State<Monthlycollection> {
  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    WidgetsBinding.instance.addPostFrameCallback((_) {
      var provider = Provider.of<Paymentcollectionprovider>(
        context,
        listen: false,
      );
      provider.PaymentCollectionAPI(context);
    });
  }

  Color getDecorationColor(value) {
    var color = AppColors.approved_bg_color;
    switch (value) {
      case 'Pending Approval':
        return AppColors.requested_bg_color;
      case 'Approved':
        return AppColors.approved_bg_color;
      case 'Rejected':
        return AppColors.rejected_bg_color;
    }
    return color;
  }

  Color getTextColor(value) {
    var color = AppColors.approved_text_color;
    switch (value) {
      case 'Pending Approval':
        return AppColors.requested_text_color;
      case 'Approved':
        return AppColors.approved_text_color;
      case 'Rejected':
        return AppColors.rejected_text_color;
    }
    return color;
  }

  // Pending Approval', 'Approved', 'Rejected
  getText(value) {
    var text = "A";
    switch (value) {
      case 'Approved':
        return "A";
      case 'Pending Approval':
        return "PA";
      case 'Rejected':
        return "R";
    }
    return text;
  }

  @override
  Widget build(BuildContext context) {
    return Consumer<Paymentcollectionprovider>(
      builder: (context, provider, child) {
        var sendWidget = InkResponse(
          onTap: () async {
            var res = await Navigator.push(
              context,
              MaterialPageRoute(builder: (context) => Accountsuggestions()),
            );
            if (res == true) {
              provider.PaymentCollectionAPI(context);
            }
          },
          child: Container(
            height: 45,
            alignment: Alignment.center,
            margin: EdgeInsets.symmetric(horizontal: 10),
            padding: EdgeInsets.symmetric(horizontal: 10, vertical: 5),
            decoration: BoxDecoration(
              color: AppColors.app_blue,
              borderRadius: BorderRadius.circular(15),
            ),
            child: Text(
              "Add Payment",
              style: TextStyle(
                fontSize: 15,
                fontFamily: "JakartaMedium",
                color: Colors.white,
              ),
            ),
          ),
          // child: SvgPicture.asset(
          //   "assets/svg/add_account.svg",
          //   width: 20,
          //   color: Color(0xFF2D2D2D),
          //   height: 20,
          // ),
        );
        return WillPopScope(
          onWillPop: () => onBackPressed(context),
          child: SafeArea(
            top: false,
            bottom: Platform.isIOS ? false : true,
            child: Scaffold(
              resizeToAvoidBottomInset: true,
              backgroundColor: AppColors.scaffold_bg_color,
              appBar: appbar2New(
                context,
                "Payment Collection",
                provider.resetAll,
                SizedBox.shrink(),
                0xFFFFFFFF
              ),
              body:
                  provider.paymenCollectionList.isNotEmpty
                      ? Container(
                        child: ListView.builder(
                          scrollDirection: Axis.vertical,
                          shrinkWrap: true,
                          physics: AlwaysScrollableScrollPhysics(),
                          itemCount: provider.paymenCollectionList.length,
                          padding: EdgeInsets.symmetric(
                            horizontal: 10,
                            vertical: 10,
                          ),

                          itemBuilder: (context, index) {
                            return Container(
                              padding: EdgeInsets.symmetric(
                                horizontal: 10,
                                vertical: 10,
                              ),
                              margin: EdgeInsets.symmetric(vertical: 5),
                              decoration: BoxDecoration(
                                color: Colors.white,
                                borderRadius: BorderRadius.circular(20),
                              ),
                              child: Column(
                                crossAxisAlignment: CrossAxisAlignment.start,
                                children: [
                                  Row(
                                    crossAxisAlignment:
                                        CrossAxisAlignment.center,
                                    mainAxisAlignment: MainAxisAlignment.center,
                                    children: [
                                      // Expanded(
                                      //   flex: 1,
                                      //   child: Container(
                                      //     padding: EdgeInsets.symmetric(
                                      //       horizontal: 10,
                                      //       vertical: 10,
                                      //     ),
                                      //     decoration: BoxDecoration(
                                      //       color: Color(0xFFE6F6FF),
                                      //       shape: BoxShape.circle
                                      //     ),
                                      //     child: SvgPicture.asset(
                                      //       width: 30,
                                      //       height: 30,
                                      //       "assets/svg/se_block_head.svg",
                                      //     ),
                                      //   ),
                                      // ),
                                      Expanded(
                                        flex: 1,
                                        child: Container(
                                          height: 45,
                                          padding: EdgeInsets.symmetric(
                                            horizontal: 10,
                                          ),
                                          decoration: BoxDecoration(
                                            color: getDecorationColor(
                                              provider
                                                  .paymenCollectionList[index]
                                                  .approvalStatus,
                                            ),
                                            shape: BoxShape.circle,
                                          ),
                                          child: Center(
                                            child: Text(
                                              "${getText(provider.paymenCollectionList[index].approvalStatus)}",
                                              style: TextStyle(
                                                fontSize: 16,
                                                fontFamily: "JakartaMedium",
                                                color: getTextColor(
                                                  provider
                                                      .paymenCollectionList[index]
                                                      .approvalStatus,
                                                ),
                                              ),
                                            ),
                                          ),
                                        ),
                                      ),
                                      SizedBox(width: 10),

                                      Expanded(
                                        flex: 4,
                                        child: SizedBox(
                                          child: Column(
                                            crossAxisAlignment:
                                                CrossAxisAlignment.start,
                                            children: [
                                              Text(
                                                "${provider.paymenCollectionList[index].accountName}",
                                                maxLines: 2,
                                                overflow: TextOverflow.ellipsis,
                                                style: TextStyle(
                                                  fontFamily: "JakartaMedium",
                                                ),
                                              ),
                                              Text(
                                                "${provider.paymenCollectionList[index].paymentMode}",
                                                maxLines: 1,
                                                overflow: TextOverflow.ellipsis,
                                                style: TextStyle(
                                                  color: AppColors.grey_semi,
                                                  fontSize: 14,
                                                  fontFamily: "JakartaRegular",
                                                ),
                                              ),
                                              // Text("Gen Pvt. Ltd"),
                                            ],
                                          ),
                                        ),
                                      ),
                                      Container(
                                        height: 35,
                                        padding: EdgeInsets.symmetric(
                                          horizontal: 10,
                                        ),

                                        child: Center(
                                          child: Text(
                                            "₹${provider.paymenCollectionList[index].amount}",
                                            style: TextStyle(
                                              fontSize: 13,
                                              color: getTextColor(
                                                provider
                                                    .paymenCollectionList[index]
                                                    .approvalStatus,
                                              ),
                                            ),
                                          ),
                                        ),
                                      ),
                                      // Expanded(
                                      //   flex: 1,
                                      //   child: InkResponse(
                                      //     onTap: () {
                                      //       _showOptionsSheet(context);
                                      //     },
                                      //     child: Icon(Icons.more_vert),
                                      //   ),
                                      // ),
                                    ],
                                  ),
                                  // Padding(
                                  //   padding: const EdgeInsets.all(8.0),
                                  //   child: Divider(
                                  //     thickness: 0.5,
                                  //     color: Color(0xFFD7D7D7),
                                  //   ),
                                  // ),
                                  // SizedBox(height: 5),
                                  // ...List.generate(2, (j) {
                                  //   final textheads = ["ID", "Generator Type"];
                                  //   final textSubheads = [
                                  //     provider
                                  //         .paymenCollectionList[index]
                                  //         .paymentRefNo,
                                  //     provider
                                  //         .paymenCollectionList[index]
                                  //         .paymentMode,
                                  //   ];
                                  //   return Container(
                                  //     padding: EdgeInsets.symmetric(
                                  //       vertical: 3,
                                  //     ),
                                  //     child: Column(
                                  //       children: [
                                  //         Row(
                                  //           crossAxisAlignment:
                                  //               CrossAxisAlignment.start,
                                  //           children: [
                                  //             Expanded(
                                  //               flex: 1,
                                  //               child: Text(
                                  //                 textheads[j].toString(),
                                  //                 style: TextStyle(
                                  //                   fontFamily: "JakartaMedium",
                                  //                 ),
                                  //               ),
                                  //             ),
                                  //             SizedBox(width: 5),
                                  //             Expanded(
                                  //               flex: 2,
                                  //               child: Text(
                                  //                 textSubheads[j].toString(),
                                  //                 style: TextStyle(
                                  //                   color: Color(0xFF818181),
                                  //                 ),
                                  //               ),
                                  //             ),
                                  //           ],
                                  //         ),
                                  //       ],
                                  //     ),
                                  //   );
                                  // }),
                                  SizedBox(height: 10),
                                  InkResponse(
                                    onTap: () {
                                      Navigator.push(
                                        context,
                                        MaterialPageRoute(
                                          builder:
                                              (context) => WebErpScreen(
                                                erp_url:
                                                    provider
                                                        .paymenCollectionList[index]
                                                        .paymentProofFilePath ??
                                                    "",
                                              ),
                                        ),
                                      );
                                    },
                                    child: SizedBox(
                                      child: Row(
                                        mainAxisAlignment:
                                            MainAxisAlignment.start,
                                        crossAxisAlignment:
                                            CrossAxisAlignment.center,
                                        children: [
                                          Text(
                                            "View Attachment",
                                            style: TextStyle(
                                              color: AppColors.app_blue,
                                              fontFamily: "JakartaMedium",
                                            ),
                                          ),
                                          SizedBox(width: 5),
                                          SvgPicture.asset(
                                            "assets/svg/next_button.svg",
                                          ),
                                        ],
                                      ),
                                    ),
                                  ),
                                ],
                              ),
                            );
                          },
                        ),
                      )
                      : Emptywidget(context),

              floatingActionButtonLocation: FloatingActionButtonLocation.centerFloat,
              floatingActionButton: sendWidget,
            ),
          ),
        );
      },
    );
  }
}
