import 'dart:io';

import 'package:flutter/material.dart';
import 'package:generp/screens/finance/FileViewer.dart';
import 'package:provider/provider.dart';

import '../../Notifiers/VisitDetailsProvider.dart';
import '../../Utils/app_colors.dart';
import '../../Utils/commonWidgets.dart';

class Followupdetails extends StatefulWidget {
  final complaintID;

  const Followupdetails({super.key, required this.complaintID});

  @override
  State<Followupdetails> createState() => _FollowupdetailsState();
}

class _FollowupdetailsState extends State<Followupdetails> {
  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    WidgetsBinding.instance.addPostFrameCallback((_) {
      var visitdetails = Provider.of<Visitdetailsprovider>(
        context,
        listen: false,
      );
      visitdetails.LoadFollowupListAPI(context, widget.complaintID);
    });
  }

  @override
  Widget build(BuildContext context) {
    return Consumer<Visitdetailsprovider>(
      builder: (context, provider, child) {
        var followups = provider.followUpList;
        return WillPopScope(
          onWillPop: () => onBackPressed(context),
          child: SafeArea(
            top: false,
            bottom: Platform.isIOS?false:true,
            child: Scaffold(
              resizeToAvoidBottomInset: true,
              appBar: appbar(context, "Follow Up Details"),
              backgroundColor: AppColors.scaffold_bg_color,
              body: Container(
                child: ListView.builder(
                  itemCount: provider.followUpList.length,
                  itemBuilder: (context, index) {
                    return Container(
                      margin: EdgeInsets.symmetric(horizontal: 10, vertical: 5),
                      padding: EdgeInsets.symmetric(horizontal: 15, vertical: 10),
                      decoration: BoxDecoration(
                        color: Colors.white,
                        borderRadius: BorderRadius.circular(20),
                      ),
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: List.generate(9, (j) {
                          final textheads = [
                            "Employee Name",
                            "Date",
                            "Type",
                            "In Time",
                            "Out Time",
                            "Running Hours",
                            "FSR File",
                            "FSR Number",
                            "Feedback",
                          ];
                          final textSubheads = [
                            followups[index].ename??"-",
                            followups[index].date??"-",
                            followups[index].type??"-",
                            followups[index].time??"-",
                            followups[index].outTime??"-",
                            followups[index].runningHrs??"-",
                            followups[index].fsrExt??"-",
                            followups[index].fsrNo??"-",
                            followups[index].feedback??"-",
                          ];
                          return Container(
                            padding: EdgeInsets.symmetric(vertical: 3),
                            child: Container(
                              padding: EdgeInsets.symmetric(
                                vertical: 3,
                                horizontal: 0,
                              ),
                              child: Row(
                                children: [
                                  Expanded(child: Text(textheads[j].toString())),
                                  Expanded(
                                    child: InkResponse(
                                      onTap: () {
                                        if (textheads[j] == "FSR File") {
                                          Navigator.push(
                                            context,
                                            MaterialPageRoute(
                                              builder:
                                                  (context) => Fileviewer(
                                                    fileName: followups[index].fsrExt!,
                                                    fileUrl: "https://erp.gengroup.in/files_genservices/tech_fsr_report/${followups[index].fsrExt!}",
                                                    downloadEnable: false,
                                                  ),
                                            ),
                                          );
                                        }
                                      },
                                      child: Text(
                                        textSubheads[j]==""?"-":textSubheads[j],
                                        maxLines: 2,
                                        overflow: TextOverflow.ellipsis,
                                        style: TextStyle(
                                          color:
                                              textheads[j] == "FSR File"
                                                  ? AppColors.app_blue
                                                  : Color(0xFF818181),
                                        ),
                                      ),
                                    ),
                                  ),
                                ],
                              ),
                            ),
                          );
                        }),
                      ),
                    );
                  },
                ),
              ),
            ),
          ),
        );
      },
    );
  }
}
