// import 'package:dropdown_button2/dropdown_button2.dart';
// import 'package:flutter/material.dart';
// import 'package:flutter/services.dart';
// import 'package:generp/Models/crmModels/crmLeadDetailsEditProductsViewResponse.dart';
// import 'package:generp/Utils/dropdownTheme.dart';
// import 'package:provider/provider.dart';
//
// import '../../Notifiers/crmProvider/editProductListProvider.dart';
// import '../../Utils/app_colors.dart';
// import '../../Utils/commonWidgets.dart';
//
// class EditProductsList extends StatefulWidget {
//   final leadID;
//
//   const EditProductsList({super.key, required this.leadID});
//
//   @override
//   State<EditProductsList> createState() => _EditProductsListState();
// }
//
// class _EditProductsListState extends State<EditProductsList> {
//   Dropdowntheme ddtheme = Dropdowntheme();
//   double totalAmount = 0;
//   @override
//   void initState() {
//     // TODO: implement initState
//     super.initState();
//     WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
//       final provider = Provider.of<Editproductlistprovider>(
//         context,
//         listen: false,
//       );
//       provider.crmLeadDetailsEditProductsViewAPIFunction(
//         context,
//         widget.leadID,
//       );
//
//       for (int i = 0; i < provider.leadProductsList.length; i++) {
//         final widgetProductPrice = provider.leadProductsList[i].price!;
//         final widgetQty = provider.leadProductsList[i].qty!;
//
//         // totalAmount +=double.parse(provider.leadProductsList[i].price!.toString());
//         totalAmount = double.parse(widgetProductPrice.toString())*int.parse(widgetQty.toString());
//         print("totalAmount: $totalAmount");
//         final matchedOrder = provider.productsList.firstWhere(
//           (order) => order.id == provider.leadProductsList[i].id,
//           orElse: () {
//             return provider.productsList[0];
//           },
//         );
//
//         provider.editAddNewRow(); // Adds controller + dropdown slot
//         provider.editProductPriceControllers[i].text = widgetProductPrice;
//         provider.editQuantityControllers[i].text = widgetQty;
//         provider.editTotalAmountControllers[i].text = totalAmount.toString();
//
//         provider.updateSelectedProductIds(i, matchedOrder);
//       }
//     });
//   }
//
//   @override
//   Widget build(BuildContext context) {
//     return Consumer<Editproductlistprovider>(
//       builder: (context, editProvider, child) {
//         return WillPopScope(
//           child: Scaffold(
//             resizeToAvoidBottomInset: true,
//             backgroundColor: AppColors.scaffold_bg_color,
//             appBar: appbar2(
//               context,
//               "Edit Products",
//               editProvider.resetForm,
//               SizedBox(width: 0),
//             ),
//             body: Container(
//               padding: EdgeInsets.symmetric(horizontal: 10),
//               // decoration: BoxDecoration(
//               //   color: Colors.white,
//               //   borderRadius: BorderRadius.circular(20),
//               // ),
//               child: SingleChildScrollView(
//                 child: Column(
//                   crossAxisAlignment: CrossAxisAlignment.start,
//                   children: [
//                     if (editProvider.leadProductsList!.isNotEmpty) ...[
//                       InkResponse(
//                         onTap: () {
//                           // if (provider.selectedOrderIds.length < provider.orderList.length) {
//                           editProvider.editAddNewRow();
//                           print("clcicekd");
//                           // } else {
//                           //   ScaffoldMessenger.of(context).showSnackBar(
//                           //     SnackBar(
//                           //       content: Text('No more unique order IDs or statuses available'),
//                           //     ),
//                           //   );
//                           // }
//                         },
//                         child: Container(
//                           margin: EdgeInsets.symmetric(vertical: 10),
//                           height: 45,
//                           width: MediaQuery.of(context).size.width,
//                           decoration: BoxDecoration(
//                             color: Color(0xFFE6F6FF),
//                             borderRadius: BorderRadius.circular(12),
//                             border: Border.all(
//                               color: AppColors.app_blue,
//                               width: 0.5,
//                             ),
//                           ),
//                           child: Center(
//                             child: Text(
//                               "+ Add Product",
//                               style: TextStyle(
//                                 fontFamily: "JakartaMedium",
//                                 color: AppColors.app_blue,
//                               ),
//                             ),
//                           ),
//                         ),
//                       ),
//
//                       if (editProvider.leadProductsList.length > 0) ...[
//                         if (editProvider.editProductPriceControllers.length > 0)
//                           Row(
//                             children: [
//                               Expanded(
//                                 child: ListView.builder(
//                                   itemCount:
//                                       editProvider.leadProductsList.length,
//                                   physics: NeverScrollableScrollPhysics(),
//                                   shrinkWrap: true,
//                                   itemBuilder: (context, j) {
//                                     return Container(
//                                       padding: EdgeInsets.symmetric(
//                                         horizontal: 10,
//                                       ),
//                                       margin: EdgeInsets.symmetric(
//                                         vertical: 10,
//                                       ),
//                                       decoration: BoxDecoration(
//                                         color: Colors.white,
//                                         borderRadius: BorderRadius.circular(20),
//                                       ),
//                                       child: Column(
//                                         children: [
//                                           Row(
//                                             children: [
//                                               Expanded(
//                                                 flex: 3,
//                                                 child: SizedBox(
//                                                   child: Column(
//                                                     crossAxisAlignment:
//                                                         CrossAxisAlignment
//                                                             .start,
//                                                     children: [
//                                                       TextWidget(
//                                                         context,
//                                                         "Order",
//                                                       ),
//                                                       Row(
//                                                         children: [
//                                                           Expanded(
//                                                             child: DropdownButtonHideUnderline(
//                                                               child: DropdownButton2<
//                                                                 Products
//                                                               >(
//                                                                 isExpanded:
//                                                                     true,
//                                                                 hint: Text(
//                                                                   'Select Account Type',
//                                                                   style:
//                                                                       TextStyle(
//                                                                         fontSize:
//                                                                             14,
//                                                                       ),
//                                                                   overflow:
//                                                                       TextOverflow
//                                                                           .ellipsis,
//                                                                 ),
//                                                                 items:
//                                                                     editProvider
//                                                                         .productsList
//                                                                         .map(
//                                                                           (
//                                                                             ord,
//                                                                           ) => DropdownMenuItem<
//                                                                             Products
//                                                                           >(
//                                                                             value:
//                                                                                 ord,
//                                                                             child: Text(
//                                                                               "(Product Name: ${ord.name})" ??
//                                                                                   '',
//                                                                               style: const TextStyle(
//                                                                                 fontSize:
//                                                                                     14,
//                                                                               ),
//                                                                               overflow:
//                                                                                   TextOverflow.ellipsis,
//                                                                             ),
//                                                                           ),
//                                                                         )
//                                                                         .toList(),
//                                                                 value:
//                                                                     editProvider.selectedProductIds[j] !=
//                                                                                 null &&
//                                                                             editProvider.productsList.isNotEmpty
//                                                                         ? editProvider.productsList.firstWhere(
//                                                                           (
//                                                                             ord,
//                                                                           ) =>
//                                                                               ord.id ==
//                                                                               editProvider.selectedProductIds[j],
//                                                                           orElse:
//                                                                               () =>
//                                                                                   editProvider.productsList[0],
//                                                                         )
//                                                                         : null,
//                                                                 onChanged: (
//                                                                   Products?
//                                                                   value,
//                                                                 ) {
//                                                                   if (value !=
//                                                                       null) {
//                                                                     if (editProvider
//                                                                         .productsList
//                                                                         .isNotEmpty) {
//                                                                       editProvider
//                                                                               .selectedProducts =
//                                                                           value;
//
//                                                                       editProvider.updateSelectedProductIds(
//                                                                         j,
//                                                                         editProvider
//                                                                             .selectedProducts,
//                                                                       );
//                                                                       // provider.selectedOrderIds = value!.orderId!;
//                                                                       // provider.selectedOrderNumbers = value!.orderNumber!;
//                                                                       // print(
//                                                                       //   "hfjkshfg" +
//                                                                       //       provider.selectedOrderIds.toString(),
//                                                                     }
//                                                                   }
//                                                                 },
//                                                                 buttonStyleData:
//                                                                     ddtheme
//                                                                         .buttonStyleData,
//                                                                 iconStyleData:
//                                                                     ddtheme
//                                                                         .iconStyleData,
//                                                                 menuItemStyleData:
//                                                                     ddtheme
//                                                                         .menuItemStyleData,
//                                                                 dropdownStyleData:
//                                                                     ddtheme
//                                                                         .dropdownStyleData,
//                                                               ),
//                                                             ),
//                                                           ),
//                                                         ],
//                                                       ),
//                                                     ],
//                                                   ),
//                                                 ),
//                                               ),
//                                             ],
//                                           ),
//
//                                           SizedBox(width: 10),
//                                           Row(
//                                             children: [
//                                               Expanded(
//                                                 flex: 2,
//                                                 child: textControllerWidget(
//                                                   context,
//                                                   editProvider
//                                                       .editProductPriceControllers[j],
//                                                   "Enter Product Price",
//                                                   (p0) {},
//                                                   TextInputType.number,
//                                                   false,
//                                                   FilteringTextInputFormatter
//                                                       .digitsOnly,
//                                                 ),
//                                               ),
//                                             ],
//                                           ),
//                                           SizedBox(height: 10),
//                                           Row(
//                                             children: [
//                                               Expanded(
//                                                 flex: 2,
//                                                 child: textControllerWidget(
//                                                   context,
//                                                   editProvider
//                                                       .editQuantityControllers[j],
//                                                   "Enter Quantity",
//                                                   (p0) {},
//                                                   TextInputType.number,
//                                                   false,
//                                                   FilteringTextInputFormatter
//                                                       .digitsOnly,
//                                                 ),
//                                               ),
//                                             ],
//                                           ),
//                                           SizedBox(height: 10),
//                                           Row(
//                                             children: [
//                                               Expanded(
//                                                 flex: 2,
//                                                 child: textControllerWidget(
//                                                   context,
//                                                   editProvider
//                                                       .editQuantityControllers[j],
//                                                   "Enter Total Amount",
//                                                   (p0) {},
//                                                   TextInputType.number,
//                                                   true,
//                                                   FilteringTextInputFormatter
//                                                       .digitsOnly,
//                                                 ),
//                                               ),
//                                             ],
//                                           ),
//                                           SizedBox(height: 10),
//                                           // SizedBox(width: 10),
//                                           //
//                                           // IconButton(
//                                           //   icon: Icon(Icons.delete),
//                                           //   onPressed: provider.orderAmountControllers.length > 1
//                                           //       ? () => provider.removeRow(index)
//                                           //       : null, // Prevent removing the last row
//                                           // ),
//                                         ],
//                                       ),
//                                     );
//                                   },
//                                 ),
//                               ),
//                             ],
//                           ),
//                       ],
//                     ],
//                   ],
//                 ),
//               ),
//             ),
//             floatingActionButtonLocation:
//                 FloatingActionButtonLocation.centerFloat,
//             bottomNavigationBar: InkResponse(
//               onTap:
//                   editProvider.submitLoading
//                       ? null
//                       : () {
//                         // editProvider.submitLoading = true;
//                         final insertedData = editProvider.getFormData();
//                         print(insertedData);
//                       },
//               child: Container(
//                 height: 45,
//                 alignment: Alignment.center,
//                 margin: EdgeInsets.symmetric(horizontal: 10, vertical: 15),
//                 padding: EdgeInsets.symmetric(horizontal: 10, vertical: 5),
//                 decoration: BoxDecoration(
//                   color: AppColors.app_blue,
//                   borderRadius: BorderRadius.circular(15),
//                 ),
//                 child:
//                     editProvider.submitLoading
//                         ? CircularProgressIndicator.adaptive(
//                           valueColor: AlwaysStoppedAnimation(
//                             AppColors.app_blue,
//                           ),
//                         )
//                         : Text(
//                           "Submit",
//                           style: TextStyle(
//                             fontSize: 15,
//                             fontFamily: "JakartaMedium",
//                             color: Colors.white,
//                           ),
//                         ),
//               ),
//             ),
//           ),
//           onWillPop: () async {
//             editProvider.resetForm();
//             return onBackPressed(context);
//           },
//         );
//       },
//     );
//   }
// }
import 'dart:io';

import 'package:dropdown_button2/dropdown_button2.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:generp/Models/crmModels/crmLeadDetailsEditProductsViewResponse.dart';
import 'package:generp/Utils/dropdownTheme.dart';
import 'package:provider/provider.dart';
import '../../Notifiers/crmProvider/editProductListProvider.dart';
import '../../Utils/app_colors.dart';
import '../../Utils/commonWidgets.dart';

class EditProductsList extends StatefulWidget {
  final String leadID;

  const EditProductsList({super.key, required this.leadID});

  @override
  State<EditProductsList> createState() => _EditProductsListState();
}

class _EditProductsListState extends State<EditProductsList> {
  Dropdowntheme ddtheme = Dropdowntheme();

  @override
  void initState() {
    super.initState();
    WidgetsBinding.instance.addPostFrameCallback((_) async {
      final provider = Provider.of<Editproductlistprovider>(context, listen: false);
      await provider.crmLeadDetailsEditProductsViewAPIFunction(context, widget.leadID);

      // Initialize controllers and dropdowns after API call
      provider.initializeForm(context);
    });
  }

  @override
  Widget build(BuildContext context) {
    return Consumer<Editproductlistprovider>(
      builder: (context, editProvider, child) {
        return WillPopScope(
          onWillPop: () async {
            editProvider.resetForm();
            return true;
          },
          child: SafeArea(
            top: false,
            bottom: Platform.isIOS?false:true,
            child: Scaffold(
              resizeToAvoidBottomInset: true,
              backgroundColor: AppColors.scaffold_bg_color,
              appBar: appbar2(
                context,
                "Edit Products",
                editProvider.resetForm,
                const SizedBox(width: 0),
              ),
              body: Container(
                padding: const EdgeInsets.symmetric(horizontal: 10),
                child: SingleChildScrollView(
                  child: Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      InkResponse(
                        onTap: () {
                          editProvider.editAddNewRow();
                        },
                        child: Container(
                          margin: const EdgeInsets.symmetric(vertical: 10),
                          height: 45,
                          width: MediaQuery.of(context).size.width,
                          decoration: BoxDecoration(
                            color: const Color(0xFFE6F6FF),
                            borderRadius: BorderRadius.circular(12),
                            border: Border.all(
                              color: AppColors.app_blue,
                              width: 0.5,
                            ),
                          ),
                          child:  Center(
                            child: Text(
                              "+ Add Product",
                              style: TextStyle(
                                fontFamily: "JakartaMedium",
                                color: AppColors.app_blue,
                              ),
                            ),
                          ),
                        ),
                      ),
                      if (editProvider.leadProductsList.isNotEmpty ||
                          editProvider.editProductPriceControllers.isNotEmpty)
                        ListView.builder(
                          itemCount: editProvider.editProductPriceControllers.length,
                          physics: const NeverScrollableScrollPhysics(),
                          shrinkWrap: true,
                          itemBuilder: (context, j) {
                            return Container(
                              padding: const EdgeInsets.symmetric(horizontal: 10, vertical: 10),
                              margin: const EdgeInsets.symmetric(vertical: 10),
                              decoration: BoxDecoration(
                                color: Colors.white,
                                borderRadius: BorderRadius.circular(20),
                              ),
                              child: Column(
                                crossAxisAlignment: CrossAxisAlignment.start,
                                children: [
                                  TextWidget(context, "Product"),
                                  DropdownButtonHideUnderline(
                                    child: Row(
                                      children: [
                                        Expanded(
                                          child: DropdownButton2<Products>(
                                            isExpanded: true,
                                            hint: const Text(
                                              'Select Product',
                                              style: TextStyle(fontSize: 14),
                                              overflow: TextOverflow.ellipsis,
                                            ),
                                            items: editProvider.productsList
                                                .map((ord) => DropdownMenuItem<Products>(
                                              value: ord,
                                              child: Text(
                                                "${ord.name}",
                                                style: const TextStyle(fontSize: 14),
                                                overflow: TextOverflow.ellipsis,
                                              ),
                                            ))
                                                .toList(),
                                            value: editProvider.selectedProductIds[j] != null
                                                ? editProvider.productsList.firstWhere(
                                                  (ord) => ord.id == editProvider.selectedProductIds[j],
                                              orElse: () => editProvider.productsList[0],
                                            )
                                                : null,
                                            onChanged: (Products? value) {
                                              if (value != null) {
                                                editProvider.updateSelectedProductIds(j, value);
                                                editProvider.selectedProductIds[j] =
                                                    value.id?.toString() ?? '';
                                                editProvider.updateTotalAmount(j);
                                              }
                                            },
                                            buttonStyleData: ddtheme.buttonStyleData,
                                            iconStyleData: ddtheme.iconStyleData,
                                            menuItemStyleData: ddtheme.menuItemStyleData,
                                            dropdownStyleData: ddtheme.dropdownStyleData,
                                          ),
                                        ),
                                      ],
                                    ),
                                  ),
                                  const SizedBox(height: 10),
                                  Row(
                                    children: [
                                      Expanded(
                                        flex: 2,
                                        child: textControllerWidget(
                                          context,
                                          editProvider.editProductPriceControllers[j],
                                          "Product Price",
                                          "Enter Product Price",
                                              (value) => editProvider.updateTotalAmount(j),
                                          TextInputType.number,
                                          false,
                                          null
                                        ),
                                      ),
                                    ],
                                  ),
                                  const SizedBox(height: 10),
                                  Row(
                                    children: [
                                      Expanded(
                                        flex: 2,
                                        child: textControllerWidget(
                                          context,
                                          editProvider.editQuantityControllers[j],
                                          "Quantity",
                                          "Enter Quantity",
                                              (value) => editProvider.updateTotalAmount(j),
                                          TextInputType.number,
                                          false,
                                          FilteringTextInputFormatter.digitsOnly,
                                        ),
                                      ),
                                    ],
                                  ),
                                  errorWidget(context, "Note: Submit Quantity as Zero (0) to delete Product"),
                                  const SizedBox(height: 10),
                                  Row(
                                    children: [
                                      Expanded(
                                        flex: 2,
                                        child: textControllerWidget(
                                          context,
                                          editProvider.editTotalAmountControllers[j],
                                          "Amount",
                                          "Total Amount",
                                              (_) {},
                                          TextInputType.number,
                                          true,
                                          FilteringTextInputFormatter.digitsOnly,
                                        ),
                                      ),
                                    ],
                                  ),
                                  // IconButton(
                                  //   icon: const Icon(Icons.delete),
                                  //   onPressed: editProvider.editProductPriceControllers.length > 1
                                  //       ? () => editProvider.editRemoveRow(j)
                                  //       : null,
                                  // ),
                                ],
                              ),
                            );
                          },
                        ),
                    ],
                  ),
                ),
              ),
              floatingActionButtonLocation: FloatingActionButtonLocation.centerFloat,
              bottomNavigationBar: InkResponse(
                onTap: editProvider.submitLoading
                    ? null
                    : () {
                  editProvider.submitForm(context,widget.leadID);


                },
                child: Container(
                  height: 45,
                  alignment: Alignment.center,
                  margin: const EdgeInsets.symmetric(horizontal: 10, vertical: 15),
                  padding: const EdgeInsets.symmetric(horizontal: 10, vertical: 5),
                  decoration: BoxDecoration(
                    color: AppColors.app_blue,
                    borderRadius: BorderRadius.circular(15),
                  ),
                  child: editProvider.submitLoading
                      ?  CircularProgressIndicator.adaptive(
                    valueColor: AlwaysStoppedAnimation<Color>(AppColors.app_blue),
                  )
                      : const Text(
                    "Submit",
                    style: TextStyle(
                      fontSize: 15,
                      fontFamily: "JakartaMedium",
                      color: Colors.white,
                    ),
                  ),
                ),
              ),
            ),
          ),
        );
      },
    );
  }
}