import 'package:flutter/cupertino.dart';
import 'package:flutter/foundation.dart';
import 'package:generp/Models/commonModels/commonAccountLedgerFilterResponse.dart';
import 'package:generp/Models/commonModels/commonAccountLedgerResponse.dart';
import 'package:generp/Notifiers/HomeScreenNotifier.dart';
import 'package:generp/services/api_calling.dart';
import 'package:provider/provider.dart';

class Accountledgerprovider extends ChangeNotifier {
  TextEditingController searchAccountController = TextEditingController();

  List<Accounts> _accounts = [];
  List<LedgerList> _ledgerList = [];
  BalanceDetails _balanceDetails = BalanceDetails();
  AccountDetails _accountDetails = AccountDetails();
  Accounts? _selectedAccount;
  String _selectedAcID = "";
  String _selectedAcVal = "";
  bool _isLoading = true;
  bool _showMoreDetails = false;
  bool get isLoading => _isLoading;
  bool get showMoreDetails => _showMoreDetails;
  List<Accounts> get accounts => _accounts;
  List<LedgerList> get ledgerList => _ledgerList;
  AccountDetails get acDetails => _accountDetails;
  BalanceDetails get balanceDetails => _balanceDetails;
  Accounts? get selectedAccount => _selectedAccount;
  String get selectedAcId => _selectedAcID;
  String get selectedAcVal => _selectedAcVal;

  set showMoreDetails(bool value) {
    _showMoreDetails = value;
    notifyListeners();
  }

  set accounts(List<Accounts> value) {
    _accounts = value;
    notifyListeners();
  }

  set selectedAccount(Accounts? value) {
    _selectedAccount = value;
    _selectedAcID = value!.id!;
    _selectedAcVal = value.name!;
    notifyListeners();
  }

  set selectedAcId(String value) {
    _selectedAcID = value;
    notifyListeners();
  }

  set selectedAcVal(String value) {
    _selectedAcVal = value;
    notifyListeners();
  }

  // Reset all values
  void resetAll() {
    _selectedAccount = null;
    _selectedAcID = "";
    _selectedAcVal = "";
    _accounts = [];
    _ledgerList = [];
    checkDropdownReset();
    notifyListeners(); // Notify UI to update
  }

  void checkDropdownReset() {
    if (!_accounts.contains(_selectedAccount) && _selectedAccount != null) {
      _selectedAcID = "";
      _selectedAcVal = "";
    }
    notifyListeners();
  }

  Future<void> dropDownAPI(context) async {
    try {
      var prov = Provider.of<HomescreenNotifier>(context, listen: false);
      final data = await ApiCalling.commonAccountLedgerDropDownAPI(
        prov.empId,
        prov.session,
      );
      if (data != null) {
        if (data.error == "0") {
          checkDropdownReset();
          _accounts = data.accounts!;
          notifyListeners();
        }
      }
    } catch (e) {}
  }

  Future<void> ledgerlistAPI(context) async {
    try {
      var prov = Provider.of<HomescreenNotifier>(context, listen: false);
      _ledgerList.clear();
      _isLoading = true;
      notifyListeners();
      final data = await ApiCalling.commonAccountLedgerListAPI(
        prov.empId,
        prov.session,
        selectedAcId,
      );
      if (data != null) {
        if (data.error == "0") {
          _isLoading = false;
          _ledgerList = data.ledgerList!;
          _balanceDetails = data.balanceDetails!;
          _accountDetails = data.accountDetails!;
          if (_selectedAccount != null &&
              !_accounts.contains(_selectedAccount)) {
            _selectedAccount = null;
            _selectedAcID = "";
          }
          notifyListeners();
        } else if (data.error == "1") {
          _isLoading = false;
          notifyListeners();
        }
      }
    } catch (e) {}
  }

  Map<String, List<LedgerList>> groupByDate(List<LedgerList> list) {
    Map<String, List<LedgerList>> grouped = {};

    for (var item in list) {
      String date = item.createdDatetime!;
      if (!grouped.containsKey(date)) {
        grouped[date] = [];
      }
      grouped[date]!.add(item);
    }

    return grouped;
  }
}
