import 'package:flutter/material.dart';
import 'package:generp/Notifiers/HomeScreenNotifier.dart';
import 'package:generp/services/api_calling.dart';
import 'package:provider/provider.dart';

import '../Models/TodayVisitResponse.dart';

class Todaymontlyvisitsprovider extends ChangeNotifier {
  List<Visitlist> _visitsList = [];
  bool _isLoading = false;
  String _title = "";

  List<Visitlist> get visitsList => _visitsList;

  bool get isLoading => _isLoading;
  String get title => _title;

  set title(String value) {
    _title = value;
  }

  Future<void> LoadMonthVisitsListAPI(BuildContext context) async {
    try {
      var HomeProvider = Provider.of<HomescreenNotifier>(
        context,
        listen: false,
      );
      final data = await ApiCalling.getMonthVisitsListAPI(
        HomeProvider.empId,
        HomeProvider.session,
      );
      if (data != null) {
        if (data.sessionExists == 1) {
          if (data.error == 0) {
            _visitsList = data.list!;
            _isLoading = false;
          } else {
            _isLoading = false;
          }
          notifyListeners();
        } else {
          // SharedpreferencesService().clearPreferences();
          // Navigator.push(
          //   context,
          //   MaterialPageRoute(builder: (context) => LoginScreen()),
          // );
        }
        // toast(context, monthvisitlist.length.toString());
      } else {
        print("Something went wrong, Please try again.");
      }
    } on Exception catch (e) {
      print("$e");
    }
  }

  Future<void> LoadTodayVisitsListAPI(BuildContext context) async {
    try {
      var HomeProvider = Provider.of<HomescreenNotifier>(
        context,
        listen: false,
      );
      final data = await ApiCalling.getTodayVisitsListAPI(
        HomeProvider.empId,
        HomeProvider.session,
      );

      if (data != null) {
        if (data.sessionExists == 1) {
          if (data.error == 0) {
            _visitsList = data.list!;
            _isLoading = false;
          } else {
            _isLoading = false;
          }
          notifyListeners();
        } else {
          // SharedpreferencesService().clearPreferences();
          // Navigator.push(
          //   context,
          //   MaterialPageRoute(builder: (context) => LoginScreen()),
          // );
        }
      } else {
        print("Something went wrong, Please try again.");
      }
    } on Exception catch (e) {
      print("$e");
    }
  }
}
