class ordersDetailsByModeResponse {
  OrderDetails? orderDetails;
  List<Products>? products;
  List<FeedbackHistory>? feedbackHistory;
  List<PaymentHistory>? paymentHistory;
  String? error;
  String? message;

  ordersDetailsByModeResponse({
    this.orderDetails,
    this.products,
    this.feedbackHistory,
    this.paymentHistory,
    this.error,
    this.message,
  });

  ordersDetailsByModeResponse.fromJson(Map<String, dynamic> json) {
    orderDetails =
        json['order_details'] != null
            ? OrderDetails.fromJson(json['order_details'])
            : null;
    if (json['products'] != null) {
      products = <Products>[];
      json['products'].forEach((v) {
        products!.add(Products.fromJson(v));
      });
    }
    if (json['feedback_history'] != null) {
      feedbackHistory = <FeedbackHistory>[];
      json['feedback_history'].forEach((v) {
        feedbackHistory!.add(FeedbackHistory.fromJson(v));
      });
    }
    if (json['payment_history'] != null) {
      paymentHistory = <PaymentHistory>[];
      json['payment_history'].forEach((v) {
        paymentHistory!.add(PaymentHistory.fromJson(v));
      });
    }
    error = json['error'];
    message = json['message'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    if (orderDetails != null) {
      data['order_details'] = orderDetails!.toJson();
    }
    if (products != null) {
      data['products'] = products!.map((v) => v.toJson()).toList();
    }
    if (feedbackHistory != null) {
      data['feedback_history'] =
          feedbackHistory!.map((v) => v.toJson()).toList();
    }
    if (paymentHistory != null) {
      data['payment_history'] = paymentHistory!.map((v) => v.toJson()).toList();
    }
    data['error'] = error;
    data['message'] = message;
    return data;
  }
}

class OrderDetails {
  String? id;
  String? orderNumber;
  String? orderNumberHash;
  String? balanceAmount;
  String? accId;
  String? refType;
  String? refId;
  String? salesPersonEmpId;
  String? enteredEmpId;
  String? dispatchStateId;
  String? dispatchDistrictId;
  String? dispatchSubLocationId;
  String? dispatchPincode;
  String? dispatchAddress;
  String? basicAmount;
  String? cgstAmount;
  String? sgstAmount;
  String? igstAmount;
  String? paidAmount;
  String? totalAmount;
  String? status;
  String? orderReceivedDate;
  String? scheduledDispatchDate;
  String? otp;
  String? note;
  String? poViewFileName;
  String? poDirFilePath;
  String? unloadingScope;
  String? freightScope;
  String? erectionScope;
  String? saleOrderNumber;
  String? invoiceNumber;
  String? vehicleNumber;
  String? driverName;
  String? driverMobileNumber;
  String? tpcApplicable;
  String? requestedTpcAmount;
  String? level1TpcApprovedAmount;
  String? level2TpcApprovedAmount;
  String? tpcPaymentMode;
  String? tpcPaymentReferenceNo;
  String? tpcPaymentAttachmentDirFilePath;
  String? tpcPaymentAttachementViewFileName;
  String? tpcStatus;
  String? tpcAgentId;
  String? isExist;
  String? createdDatetime;
  String? updatedDatetime;
  String? accountName;
  String? gstNumber;
  String? billingAddress;
  String? billingDistrict;
  String? billingState;
  String? billingSubLocality;
  String? billingPincode;
  String? stateName;
  String? districtName;
  String? subLocationName;
  String? adjustedAmount;
  String? enteredEmpName;
  String? salesPersonEmpName;
  String? tpcaAgentName;

  OrderDetails({
    this.id,
    this.orderNumber,
    this.orderNumberHash,
    this.balanceAmount,
    this.accId,
    this.refType,
    this.refId,
    this.salesPersonEmpId,
    this.enteredEmpId,
    this.dispatchStateId,
    this.dispatchDistrictId,
    this.dispatchSubLocationId,
    this.dispatchPincode,
    this.dispatchAddress,
    this.basicAmount,
    this.cgstAmount,
    this.sgstAmount,
    this.igstAmount,
    this.paidAmount,
    this.totalAmount,
    this.status,
    this.orderReceivedDate,
    this.scheduledDispatchDate,
    this.otp,
    this.note,
    this.poViewFileName,
    this.poDirFilePath,
    this.unloadingScope,
    this.freightScope,
    this.erectionScope,
    this.saleOrderNumber,
    this.invoiceNumber,
    this.vehicleNumber,
    this.driverName,
    this.driverMobileNumber,
    this.tpcApplicable,
    this.requestedTpcAmount,
    this.level1TpcApprovedAmount,
    this.level2TpcApprovedAmount,
    this.tpcPaymentMode,
    this.tpcPaymentReferenceNo,
    this.tpcPaymentAttachmentDirFilePath,
    this.tpcPaymentAttachementViewFileName,
    this.tpcStatus,
    this.tpcAgentId,
    this.isExist,
    this.createdDatetime,
    this.updatedDatetime,
    this.accountName,
    this.gstNumber,
    this.billingAddress,
    this.billingDistrict,
    this.billingState,
    this.billingSubLocality,
    this.billingPincode,
    this.stateName,
    this.districtName,
    this.subLocationName,
    this.adjustedAmount,
    this.enteredEmpName,
    this.salesPersonEmpName,
    this.tpcaAgentName,
  });

  OrderDetails.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    orderNumber = json['order_number'];
    orderNumberHash = json['order_number_hash'];
    balanceAmount = json['balance_amount'];
    accId = json['acc_id'];
    refType = json['ref_type'];
    refId = json['ref_id'];
    salesPersonEmpId = json['sales_person_emp_id'];
    enteredEmpId = json['entered_emp_id'];
    dispatchStateId = json['dispatch_state_id'];
    dispatchDistrictId = json['dispatch_district_id'];
    dispatchSubLocationId = json['dispatch_sub_location_id'];
    dispatchPincode = json['dispatch_pincode'];
    dispatchAddress = json['dispatch_address'];
    basicAmount = json['basic_amount'];
    cgstAmount = json['cgst_amount'];
    sgstAmount = json['sgst_amount'];
    igstAmount = json['igst_amount'];
    paidAmount = json['paid_amount'];
    totalAmount = json['total_amount'];
    status = json['status'];
    orderReceivedDate = json['order_received_date'];
    scheduledDispatchDate = json['scheduled_dispatch_date'];
    otp = json['otp'];
    note = json['note'];
    poViewFileName = json['po_view_file_name'];
    poDirFilePath = json['po_dir_file_path'];
    unloadingScope = json['unloading_scope'];
    freightScope = json['freight_scope'];
    erectionScope = json['erection_scope'];
    saleOrderNumber = json['sale_order_number'];
    invoiceNumber = json['invoice_number'];
    vehicleNumber = json['vehicle_number'];
    driverName = json['driver_name'];
    driverMobileNumber = json['driver_mobile_number'];
    tpcApplicable = json['tpc_applicable'];
    requestedTpcAmount = json['requested_tpc_amount'];
    level1TpcApprovedAmount = json['level1_tpc_approved_amount'];
    level2TpcApprovedAmount = json['level2_tpc_approved_amount'];
    tpcPaymentMode = json['tpc_payment_mode'];
    tpcPaymentReferenceNo = json['tpc_payment_reference_no'];
    tpcPaymentAttachmentDirFilePath =
        json['tpc_payment_attachment_dir_file_path'];
    tpcPaymentAttachementViewFileName =
        json['tpc_payment_attachement_view_file_name'];
    tpcStatus = json['tpc_status'];
    tpcAgentId = json['tpc_agent_id'];
    isExist = json['is_exist'];
    createdDatetime = json['created_datetime'];
    updatedDatetime = json['updated_datetime'];
    accountName = json['account_name'];
    gstNumber = json['gst_number'];
    billingAddress = json['billing_address'];
    billingDistrict = json['billing_district'];
    billingState = json['billing_state'];
    billingSubLocality = json['billing_sub_locality'];
    billingPincode = json['billing_pincode'];
    stateName = json['state_name'];
    districtName = json['district_name'];
    subLocationName = json['sub_location_name'];
    adjustedAmount = json['adjusted_amount'];
    enteredEmpName = json['entered_emp_name'];
    salesPersonEmpName = json['sales_person_emp_name'];
    tpcaAgentName = json['tpca_agent_name'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['order_number'] = orderNumber;
    data['order_number_hash'] = orderNumberHash;
    data['balance_amount'] = balanceAmount;
    data['acc_id'] = accId;
    data['ref_type'] = refType;
    data['ref_id'] = refId;
    data['sales_person_emp_id'] = salesPersonEmpId;
    data['entered_emp_id'] = enteredEmpId;
    data['dispatch_state_id'] = dispatchStateId;
    data['dispatch_district_id'] = dispatchDistrictId;
    data['dispatch_sub_location_id'] = dispatchSubLocationId;
    data['dispatch_pincode'] = dispatchPincode;
    data['dispatch_address'] = dispatchAddress;
    data['basic_amount'] = basicAmount;
    data['cgst_amount'] = cgstAmount;
    data['sgst_amount'] = sgstAmount;
    data['igst_amount'] = igstAmount;
    data['paid_amount'] = paidAmount;
    data['total_amount'] = totalAmount;
    data['status'] = status;
    data['order_received_date'] = orderReceivedDate;
    data['scheduled_dispatch_date'] = scheduledDispatchDate;
    data['otp'] = otp;
    data['note'] = note;
    data['po_view_file_name'] = poViewFileName;
    data['po_dir_file_path'] = poDirFilePath;
    data['unloading_scope'] = unloadingScope;
    data['freight_scope'] = freightScope;
    data['erection_scope'] = erectionScope;
    data['sale_order_number'] = saleOrderNumber;
    data['invoice_number'] = invoiceNumber;
    data['vehicle_number'] = vehicleNumber;
    data['driver_name'] = driverName;
    data['driver_mobile_number'] = driverMobileNumber;
    data['tpc_applicable'] = tpcApplicable;
    data['requested_tpc_amount'] = requestedTpcAmount;
    data['level1_tpc_approved_amount'] = level1TpcApprovedAmount;
    data['level2_tpc_approved_amount'] = level2TpcApprovedAmount;
    data['tpc_payment_mode'] = tpcPaymentMode;
    data['tpc_payment_reference_no'] = tpcPaymentReferenceNo;
    data['tpc_payment_attachment_dir_file_path'] =
        tpcPaymentAttachmentDirFilePath;
    data['tpc_payment_attachement_view_file_name'] =
        tpcPaymentAttachementViewFileName;
    data['tpc_status'] = tpcStatus;
    data['tpc_agent_id'] = tpcAgentId;
    data['is_exist'] = isExist;
    data['created_datetime'] = createdDatetime;
    data['updated_datetime'] = updatedDatetime;
    data['account_name'] = accountName;
    data['gst_number'] = gstNumber;
    data['billing_address'] = billingAddress;
    data['billing_district'] = billingDistrict;
    data['billing_state'] = billingState;
    data['billing_sub_locality'] = billingSubLocality;
    data['billing_pincode'] = billingPincode;
    data['state_name'] = stateName;
    data['district_name'] = districtName;
    data['sub_location_name'] = subLocationName;
    data['adjusted_amount'] = adjustedAmount;
    data['entered_emp_name'] = enteredEmpName;
    data['sales_person_emp_name'] = salesPersonEmpName;
    data['tpca_agent_name'] = tpcaAgentName;
    return data;
  }
}

class Products {
  String? id;
  String? orderId;
  String? productId;
  String? pdiId;
  String? qty;
  String? unitPrice;
  String? cgstPercentage;
  String? sgstPercentage;
  String? igstPercentage;
  String? totalPrice;
  String? isExist;
  String? createdDatetime;
  String? updatedDatetime;
  String? productName;
  String? cgstAmount;
  String? sgstAmount;
  String? igstAmount;

  Products({
    this.id,
    this.orderId,
    this.productId,
    this.pdiId,
    this.qty,
    this.unitPrice,
    this.cgstPercentage,
    this.sgstPercentage,
    this.igstPercentage,
    this.totalPrice,
    this.isExist,
    this.createdDatetime,
    this.updatedDatetime,
    this.productName,
    this.cgstAmount,
    this.sgstAmount,
    this.igstAmount,
  });

  Products.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    orderId = json['order_id'];
    productId = json['product_id'];
    pdiId = json['pdi_id'];
    qty = json['qty'];
    unitPrice = json['unit_price'];
    cgstPercentage = json['cgst_percentage'];
    sgstPercentage = json['sgst_percentage'];
    igstPercentage = json['igst_percentage'];
    totalPrice = json['total_price'];
    isExist = json['is_exist'];
    createdDatetime = json['created_datetime'];
    updatedDatetime = json['updated_datetime'];
    productName = json['product_name'];
    cgstAmount = json['cgst_amount'];
    sgstAmount = json['sgst_amount'];
    igstAmount = json['igst_amount'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['order_id'] = orderId;
    data['product_id'] = productId;
    data['pdi_id'] = pdiId;
    data['qty'] = qty;
    data['unit_price'] = unitPrice;
    data['cgst_percentage'] = cgstPercentage;
    data['sgst_percentage'] = sgstPercentage;
    data['igst_percentage'] = igstPercentage;
    data['total_price'] = totalPrice;
    data['is_exist'] = isExist;
    data['created_datetime'] = createdDatetime;
    data['updated_datetime'] = updatedDatetime;
    data['product_name'] = productName;
    data['cgst_amount'] = cgstAmount;
    data['sgst_amount'] = sgstAmount;
    data['igst_amount'] = igstAmount;
    return data;
  }
}

class FeedbackHistory {
  String? employeNaem;
  String? feedback;
  String? createdDatetime;
  String? status;
  String? feedbackId;
  String? id;
  String? attachmentDirFilePath;
  String? attachmentViewFileName;
  String? isExists;
  String? updatedDatetime;
  String? attachImage;

  FeedbackHistory({
    this.employeNaem,
    this.feedback,
    this.createdDatetime,
    this.status,
    this.feedbackId,
    this.id,
    this.attachmentDirFilePath,
    this.attachmentViewFileName,
    this.isExists,
    this.updatedDatetime,
    this.attachImage,
  });

  FeedbackHistory.fromJson(Map<String, dynamic> json) {
    employeNaem = json['employe_naem'];
    feedback = json['feedback'];
    createdDatetime = json['created_datetime'];
    status = json['status'];
    feedbackId = json['feedback_id'];
    id = json['id'];
    attachmentDirFilePath = json['attachment_dir_file_path'];
    attachmentViewFileName = json['attachment_view_file_name'];
    isExists = json['is_exists'];
    updatedDatetime = json['updated_datetime'];
    attachImage = json['attach_image'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = Map<String, dynamic>();
    data['employe_naem'] = employeNaem;
    data['feedback'] = feedback;
    data['created_datetime'] = createdDatetime;
    data['status'] = status;
    data['feedback_id'] = feedbackId;
    data['id'] = id;
    data['attachment_dir_file_path'] = attachmentDirFilePath;
    data['attachment_view_file_name'] = attachmentViewFileName;
    data['is_exists'] = isExists;
    data['updated_datetime'] = updatedDatetime;
    data['attach_image'] = attachImage;
    return data;
  }
}

class PaymentHistory {
  String? paymentId;
  String? ename;
  String? accountName;
  String? adjustedAmount;
  String? enteredEmployee;
  String? paymentType;
  String? refId;
  String? refType;
  String? refNo;
  String? approvalStatus;
  String? paymentDate;
  String? approvalEmpId;
  String? description;
  String? amount;
  String? datetime;
  String? status;

  PaymentHistory({
    this.paymentId,
    this.ename,
    this.accountName,
    this.adjustedAmount,
    this.enteredEmployee,
    this.paymentType,
    this.refId,
    this.refType,
    this.refNo,
    this.approvalStatus,
    this.paymentDate,
    this.approvalEmpId,
    this.description,
    this.amount,
    this.datetime,
    this.status,
  });

  PaymentHistory.fromJson(Map<String, dynamic> json) {
    paymentId = json['payment_id'];
    ename = json['ename'];
    accountName = json['account_name'];
    adjustedAmount = json['adjusted_amount'];
    enteredEmployee = json['entered_employee'];
    paymentType = json['payment_type'];
    refId = json['ref_id'];
    refType = json['ref_type'];
    refNo = json['ref_no'];
    approvalStatus = json['approval_status'];
    paymentDate = json['payment_date'];
    approvalEmpId = json['approval_emp_id'];
    description = json['description'];
    amount = json['amount'];
    datetime = json['datetime'];
    status = json['status'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['payment_id'] = paymentId;
    data['ename'] = ename;
    data['account_name'] = accountName;
    data['adjusted_amount'] = adjustedAmount;
    data['entered_employee'] = enteredEmployee;
    data['payment_type'] = paymentType;
    data['ref_id'] = refId;
    data['ref_type'] = refType;
    data['ref_no'] = refNo;
    data['approval_status'] = approvalStatus;
    data['payment_date'] = paymentDate;
    data['approval_emp_id'] = approvalEmpId;
    data['description'] = description;
    data['amount'] = amount;
    data['datetime'] = datetime;
    data['status'] = status;
    return data;
  }
}
