class CommonResponse {
  String? error;
  String? message;
  String? qrCode;
  String? qrId;
  int? sessionExists;

  CommonResponse({this.error, this.message, this.sessionExists});

  CommonResponse.fromJson(Map<String, dynamic> json) {
    error = json['error'];
    qrCode = json['qr_code'];
    qrId = json['razorpay_order_id'];
    message = json['message'];
    sessionExists = json['session_exists'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['error'] = error;
    data['qr_code'] = qrCode;
    data['razorpay_order_id'] = qrId;
    data['message'] = message;
    data['session_exists'] = sessionExists;
    return data;
  }
}
