class AddOrderPaymentSelectAccountResponse {
  List<AccountList>? accountList;
  String? error;
  String? message;

  AddOrderPaymentSelectAccountResponse({
    this.accountList,
    this.error,
    this.message,
  });

  AddOrderPaymentSelectAccountResponse.fromJson(Map<String, dynamic> json) {
    if (json['account_list'] != null) {
      accountList = <AccountList>[];
      json['account_list'].forEach((v) {
        accountList!.add(AccountList.fromJson(v));
      });
    }
    error = json['error'];
    message = json['message'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    if (accountList != null) {
      data['account_list'] = accountList!.map((v) => v.toJson()).toList();
    }
    data['error'] = error;
    data['message'] = message;
    return data;
  }
}

class AccountList {
  String? id;
  String? text;

  AccountList({this.id, this.text});

  AccountList.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    text = json['text'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['text'] = text;
    return data;
  }
}
