class attendanceRequestDetailsResponse {
  RequestDetails? requestDetails;
  String? error;
  String? message;
  int? sessionExists;

  attendanceRequestDetailsResponse({
    this.requestDetails,
    this.error,
    this.message,
    this.sessionExists,
  });

  attendanceRequestDetailsResponse.fromJson(Map<String, dynamic> json) {
    requestDetails =
        json['request_details'] != null
            ? RequestDetails.fromJson(json['request_details'])
            : null;
    error = json['error'];
    message = json['message'];
    sessionExists = json['session_exists'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    if (requestDetails != null) {
      data['request_details'] = requestDetails!.toJson();
    }
    data['error'] = error;
    data['message'] = message;
    data['session_exists'] = sessionExists;
    return data;
  }
}

class RequestDetails {
  String? id;
  String? attendanceType;
  String? type;
  String? date;
  String? checkInType;
  String? checkInTime;
  String? chechOutType;
  String? checkOutTime;
  String? status;
  String? requestedDatetime;
  String? createdEmpName;
  String? employeeName;
  String? level1Remarks;
  String? level1EmpName;
  String? level2Remarks;
  String? checkInProofDirFilePath;
  String? checkOutProofDirFilePath;
  String? level2EmpName;
  String? note;
  String? checkInLocation;
  String? checkOutLocation;
  String? location;

  RequestDetails({
    this.id,
    this.attendanceType,
    this.type,
    this.date,
    this.checkInType,
    this.checkInTime,
    this.chechOutType,
    this.checkOutTime,
    this.status,
    this.requestedDatetime,
    this.createdEmpName,
    this.employeeName,
    this.level1Remarks,
    this.level1EmpName,
    this.level2Remarks,
    this.checkInProofDirFilePath,
    this.checkOutProofDirFilePath,
    this.level2EmpName,
    this.note,
    this.checkInLocation,
    this.checkOutLocation,
    this.location,
  });

  RequestDetails.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    attendanceType = json['attendance_type'];
    type = json['type'];
    date = json['date'];
    checkInType = json['check_in_type'];
    checkInTime = json['check_in_time'];
    chechOutType = json['chech_out_type'];
    checkOutTime = json['check_out_time'];
    status = json['status'];
    requestedDatetime = json['requested_datetime'];
    createdEmpName = json['created_emp_name'];
    employeeName = json['employee_name'];
    level1Remarks = json['level1_remarks'];
    level1EmpName = json['level1_emp_name'];
    level2Remarks = json['level2_remarks'];
    checkInProofDirFilePath = json['check_in_proof_dir_file_path'];
    checkOutProofDirFilePath = json['check_out_proof_dir_file_path'];
    level2EmpName = json['level2_emp_name'];
    note = json['note'];
    checkInLocation = json['check_in_location'];
    checkOutLocation = json['check_out_location'];
    location = json['location'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = Map<String, dynamic>();
    data['id'] = id;
    data['attendance_type'] = attendanceType;
    data['type'] = type;
    data['date'] = date;
    data['check_in_type'] = checkInType;
    data['check_in_time'] = checkInTime;
    data['chech_out_type'] = chechOutType;
    data['check_out_time'] = checkOutTime;
    data['status'] = status;
    data['requested_datetime'] = requestedDatetime;
    data['created_emp_name'] = createdEmpName;
    data['employee_name'] = employeeName;
    data['level1_remarks'] = level1Remarks;
    data['level1_emp_name'] = level1EmpName;
    data['level2_remarks'] = level2Remarks;
    data['check_in_proof_dir_file_path'] = checkInProofDirFilePath;
    data['check_out_proof_dir_file_path'] = checkOutProofDirFilePath;
    data['level2_emp_name'] = level2EmpName;
    data['note'] = note;
    data['check_in_location'] = checkInLocation;
    data['check_out_location'] = location;
    data['location'] = location;
    return data;
  }
}
