class NearbyOpenLeadsResponse {
  List<LeadList>? leadList;
  int? error;
  String? message;

  NearbyOpenLeadsResponse({this.leadList, this.error, this.message});

  NearbyOpenLeadsResponse.fromJson(Map<String, dynamic> json) {
    if (json['lead_list'] != null) {
      leadList = <LeadList>[];
      json['lead_list'].forEach((v) {
        leadList!.add(LeadList.fromJson(v));
      });
    }
    error = json['error'];
    message = json['message'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    if (leadList != null) {
      data['lead_list'] = leadList!.map((v) => v.toJson()).toList();
    }
    data['error'] = error;
    data['message'] = message;
    return data;
  }
}

class LeadList {
  String? id;
  String? ownerId;
  String? accId;
  String? accManagerId;
  String? status;
  String? openStatus;
  String? date;
  String? closeDate;
  String? closereason;
  String? competitor;
  String? orderGainId;
  String? loc;
  String? isExists;
  String? createdDatetime;
  String? updatedDatetime;
  String? followupFunction;
  String? name;
  String? contName;
  String? address;
  String? mob1;
  String? mob2;
  String? tel;
  String? email;
  String? distance;

  LeadList({
    this.id,
    this.ownerId,
    this.accId,
    this.accManagerId,
    this.status,
    this.openStatus,
    this.date,
    this.closeDate,
    this.closereason,
    this.competitor,
    this.orderGainId,
    this.loc,
    this.isExists,
    this.createdDatetime,
    this.updatedDatetime,
    this.followupFunction,
    this.name,
    this.contName,
    this.address,
    this.mob1,
    this.mob2,
    this.tel,
    this.email,
    this.distance,
  });

  LeadList.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    ownerId = json['owner_id'];
    accId = json['acc_id'];
    accManagerId = json['acc_manager_id'];
    status = json['status'];
    openStatus = json['open_status'];
    date = json['date'];
    closeDate = json['close_date'];
    closereason = json['closereason'];
    competitor = json['competitor'];
    orderGainId = json['order_gain_id'];
    loc = json['loc'];
    isExists = json['is_exists'];
    createdDatetime = json['created_datetime'];
    updatedDatetime = json['updated_datetime'];
    followupFunction = json['followup_function'];
    name = json['name'];
    contName = json['cont_name'];
    address = json['address'];
    mob1 = json['mob1'];
    mob2 = json['mob2'];
    tel = json['tel'];
    email = json['email'];
    distance = json['distance'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['owner_id'] = ownerId;
    data['acc_id'] = accId;
    data['acc_manager_id'] = accManagerId;
    data['status'] = status;
    data['open_status'] = openStatus;
    data['date'] = date;
    data['close_date'] = closeDate;
    data['closereason'] = closereason;
    data['competitor'] = competitor;
    data['order_gain_id'] = orderGainId;
    data['loc'] = loc;
    data['is_exists'] = isExists;
    data['created_datetime'] = createdDatetime;
    data['updated_datetime'] = updatedDatetime;
    data['followup_function'] = followupFunction;
    data['name'] = name;
    data['cont_name'] = contName;
    data['address'] = address;
    data['mob1'] = mob1;
    data['mob2'] = mob2;
    data['tel'] = tel;
    data['email'] = email;
    data['distance'] = distance;
    return data;
  }
}
