import 'dart:io';

import 'package:flutter/material.dart';
import 'package:flutter_svg/svg.dart';
import 'package:generp/Notifiers/ordersProvider/tpcAgentsProvider.dart';
import 'package:generp/screens/finance/FileViewer.dart';
import 'package:generp/screens/order/tpcAgentDetailsByMode.dart';
import 'package:provider/provider.dart';
import 'package:url_launcher/url_launcher.dart';

import '../../Utils/app_colors.dart';
import '../../Utils/commonWidgets.dart';

import 'package:connectivity_plus/connectivity_plus.dart';
import 'package:generp/Utils/commonServices.dart';

class Tpcagentlistbymode extends StatefulWidget {
  final pageTitleName;
  final mode;

  const Tpcagentlistbymode({
    super.key,
    required this.pageTitleName,
    required this.mode,
  });

  @override
  State<Tpcagentlistbymode> createState() => _TpcagentlistbymodeState();
}

class _TpcagentlistbymodeState extends State<Tpcagentlistbymode> {
  Map _source = {ConnectivityResult.mobile: true};
  final MyConnectivity _connectivity = MyConnectivity.instance;
  final ScrollController _scrollController = ScrollController();

  @override
  void initState() {
    super.initState();
    _connectivity.initialise();
    _connectivity.myStream.listen((source) {
      setState(() => _source = source);
    });

    WidgetsBinding.instance.addPostFrameCallback((_) {
      final provider = Provider.of<Tpcagentsprovider>(context, listen: false);
      provider.resetPagination();
      provider.TPCAgentsListAPIFunction(context, widget.mode);
    });

    _scrollController.addListener(() {
      if (_scrollController.position.pixels >=
          _scrollController.position.maxScrollExtent - 200) {
        final provider = Provider.of<Tpcagentsprovider>(context, listen: false);
        provider.loadMore(context, widget.mode);
      }
    });
  }

  @override
  void dispose() {
    _scrollController.dispose();
    _connectivity.disposeStream();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    switch (_source.keys.toList()[0]) {
      case ConnectivityResult.mobile:
        connection = 'Online';
        break;
      case ConnectivityResult.wifi:
        connection = 'Online';
        break;
      case ConnectivityResult.none:
      default:
        connection = 'Offline';
    }
    return (connection == "Online")
        ? Platform.isAndroid
            ? WillPopScope(
              onWillPop: () {
                Provider.of<Tpcagentsprovider>(
                  context,
                  listen: false,
                ).resetAll();
                return onBackPressed(context);
              },
              child: SafeArea(
                top: false,
                bottom: true,
                child: _scaffold(context),
              ),
            )
            : _scaffold(context)
        : NoNetwork(context);
  }

  Widget _scaffold(BuildContext context) {
    return Consumer<Tpcagentsprovider>(
      builder: (context, provider, child) {
        final tpcAgentsLists = provider.tpcAgentsList;
        return Scaffold(
          resizeToAvoidBottomInset: true,
          appBar: appbar2New(
            context,
            widget.pageTitleName,
            provider.resetAll,
            Row(
              children: [
                // InkResponse(
                //   onTap: () {
                //     // _showOptionsSheet(context);
                //   },
                //   child: SvgPicture.asset("assets/svg/ic_download.svg",),
                // ),
              ],
            ),
            0xFFFFFFFF,
          ),
          backgroundColor: AppColors.scaffold_bg_color,
          body:
              provider.isLoading && tpcAgentsLists.isEmpty
                  ? Center(
                    child: CircularProgressIndicator.adaptive(
                      valueColor: AlwaysStoppedAnimation<Color>(
                        AppColors.app_blue,
                      ),
                    ),
                  )
                  : tpcAgentsLists.isNotEmpty
                  ? RefreshIndicator(
                    onRefresh: () async {
                      provider.resetPagination();
                      await provider.TPCAgentsListAPIFunction(
                        context,
                        widget.mode,
                      );
                    },
                    child: ListView.builder(
                      controller: _scrollController,
                      itemCount:
                          tpcAgentsLists.length +
                          (provider.hasMoreData ? 1 : 0),
                      itemBuilder: (context, index) {
                        if (index == tpcAgentsLists.length) {
                          return provider.isLoadingMore
                              ? const Padding(
                                padding: EdgeInsets.all(16),
                                child: Center(
                                  child: CircularProgressIndicator(),
                                ),
                              )
                              : const SizedBox.shrink();
                        }

                        final agent = tpcAgentsLists[index];
                        return InkResponse(
                          onTap: () async {
                            Navigator.push(
                              context,
                              MaterialPageRoute(
                                builder:
                                    (context) => Tpcagentdetailsbymode(
                                      mode: widget.mode,
                                      pageTitleName: widget.pageTitleName,
                                      tpcAgentId:
                                          tpcAgentsLists[index].tpcAgentId,
                                    ),
                              ),
                            );
                          },
                          child: Container(
                            padding: EdgeInsets.symmetric(
                              horizontal: 7.5,
                              vertical: 5,
                            ),
                            margin: EdgeInsets.symmetric(
                              horizontal: 10,
                              vertical: 5,
                            ),
                            decoration: BoxDecoration(
                              color: Colors.white,
                              borderRadius: BorderRadius.circular(16),
                            ),
                            child: Column(
                              children: [
                                Row(
                                  children: [
                                    Expanded(
                                      flex: 1,
                                      child: SizedBox(
                                        height: 50,
                                        width: 35,

                                        // decoration: BoxDecoration(
                                        //   color: Color(0xFFEAF7FF),
                                        //   borderRadius:
                                        //   BorderRadius.circular(8),
                                        // ),
                                        child: SvgPicture.asset(
                                          "assets/svg/order/tpc_list_ic.svg",
                                        ),
                                      ),
                                    ),
                                    SizedBox(width: 10),
                                    Expanded(
                                      flex: 5,
                                      child: SizedBox(
                                        child: Column(
                                          crossAxisAlignment:
                                              CrossAxisAlignment.start,
                                          children: [
                                            Text(
                                              tpcAgentsLists[index].name!,
                                              maxLines: 1,
                                              overflow: TextOverflow.ellipsis,
                                              style: TextStyle(
                                                fontFamily: "JakartaRegular",
                                                fontSize: 14,
                                                color: AppColors.semi_black,
                                              ),
                                            ),
                                            Text(
                                              "${tpcAgentsLists[index].mobileNumber}",
                                              style: TextStyle(
                                                fontFamily: "JakartaRegular",
                                                fontSize: 14,
                                                color: AppColors.grey_semi,
                                              ),
                                            ),
                                          ],
                                        ),
                                      ),
                                    ),
                                    SizedBox(width: 10),
                                    Expanded(
                                      flex: 1,
                                      child: InkResponse(
                                        onTap: () {
                                          launch(
                                            'tel://${tpcAgentsLists[index].mobileNumber}',
                                          );
                                        },
                                        child: SizedBox(
                                          height: 35,
                                          width: 35,
                                          child: SvgPicture.asset(
                                            "assets/svg/crm/lead_list_call_ic.svg",
                                          ),
                                        ),
                                      ),
                                    ),
                                  ],
                                ),
                              ],
                            ),
                          ),
                        );
                      },
                    ),
                  )
                  : Emptywidget(context),
        );
      },
    );
  }

  Widget _scaffold1(BuildContext context) {
    return Consumer<Tpcagentsprovider>(
      builder: (context, provider, child) {
        final tpcAgentsLists = provider.tpcAgentsList;
        return WillPopScope(
          onWillPop: () {
            provider.resetAll();
            return onBackPressed(context);
          },
          child: SafeArea(
            top: false,
            bottom: Platform.isIOS ? false : true,
            child: Scaffold(
              resizeToAvoidBottomInset: true,
              appBar: appbar2(
                context,
                widget.pageTitleName,
                provider.resetAll,
                Row(
                  children: [
                    // InkResponse(
                    //   onTap: () {
                    //     // _showOptionsSheet(context);
                    //   },
                    //   child: SvgPicture.asset("assets/svg/ic_download.svg",),
                    // ),
                  ],
                ),
              ),
              backgroundColor: AppColors.scaffold_bg_color,
              body:
                  provider.isLoading
                      ? Center(
                        child: CircularProgressIndicator.adaptive(
                          valueColor: AlwaysStoppedAnimation<Color>(
                            AppColors.app_blue,
                          ),
                        ),
                      )
                      : tpcAgentsLists.isNotEmpty
                      ? SingleChildScrollView(
                        child: Column(
                          children: [
                            ListView.builder(
                              itemCount: tpcAgentsLists.length,
                              shrinkWrap: true,
                              physics: NeverScrollableScrollPhysics(),
                              itemBuilder: (context, index) {
                                if (tpcAgentsLists.isEmpty) {
                                  return SizedBox(
                                    child: Center(
                                      child: Text("No Data Available"),
                                    ),
                                  );
                                }
                                return Container(
                                  padding: EdgeInsets.symmetric(
                                    horizontal: 10,
                                    vertical: 10,
                                  ),
                                  margin: EdgeInsets.symmetric(
                                    horizontal: 10,
                                    vertical: 10,
                                  ),
                                  decoration: BoxDecoration(
                                    color: Colors.white,
                                    borderRadius: BorderRadius.circular(16),
                                  ),
                                  child: Column(
                                    children: [
                                      Row(
                                        children: [
                                          Expanded(
                                            flex: 1,
                                            child: Container(
                                              height: 50,
                                              width: 35,

                                              decoration: BoxDecoration(
                                                color: Color(0xFFEAF7FF),
                                                borderRadius:
                                                    BorderRadius.circular(8),
                                              ),
                                              child: SvgPicture.asset(
                                                "assets/svg/tpc_ic.svg",
                                              ),
                                            ),
                                          ),
                                          SizedBox(width: 10),
                                          Expanded(
                                            flex: 4,
                                            child: SizedBox(
                                              child: Column(
                                                crossAxisAlignment:
                                                    CrossAxisAlignment.start,
                                                children: [
                                                  Text(
                                                    tpcAgentsLists[index].name!,
                                                    style: TextStyle(
                                                      fontFamily:
                                                          "JakartaMedium",
                                                      fontSize: 14,
                                                      color:
                                                          AppColors.semi_black,
                                                    ),
                                                  ),
                                                  Text(
                                                    "${tpcAgentsLists[index].mobileNumber}",
                                                    style: TextStyle(
                                                      fontFamily:
                                                          "JakartaMedium",
                                                      fontSize: 14,
                                                      color: AppColors.app_blue,
                                                    ),
                                                  ),
                                                ],
                                              ),
                                            ),
                                          ),
                                        ],
                                      ),
                                      Divider(
                                        thickness: 0.5,
                                        color: Color(0xFFD7D7D7),
                                      ),
                                      ...List.generate(4, (j) {
                                        final headings = [
                                          "Entered Employee",
                                          "Issued Amount",
                                          "ID Proof",
                                          "Description",
                                        ];

                                        final subHeadings = [
                                          tpcAgentsLists[index].enteredEmpName,
                                          tpcAgentsLists[index].issuedAmount,
                                          "View",
                                          tpcAgentsLists[index].note,
                                        ];
                                        return Container(
                                          padding: EdgeInsets.symmetric(
                                            vertical: 5,
                                          ),
                                          child: Row(
                                            crossAxisAlignment:
                                                CrossAxisAlignment.start,
                                            children: [
                                              Expanded(
                                                child: Text(
                                                  headings[j],
                                                  style: TextStyle(
                                                    fontFamily: "JakartaMedium",
                                                    fontSize: 14,
                                                    color: AppColors.semi_black,
                                                  ),
                                                ),
                                              ),
                                              if (subHeadings[j] == "View") ...[
                                                Expanded(
                                                  child: InkResponse(
                                                    onTap: () {
                                                      Navigator.push(
                                                        context,
                                                        MaterialPageRoute(
                                                          builder:
                                                              (
                                                                context,
                                                              ) => Fileviewer(
                                                                fileName:
                                                                    tpcAgentsLists[index]
                                                                        .idProofViewFileName ??
                                                                    "-",
                                                                fileUrl:
                                                                    tpcAgentsLists[index]
                                                                        .idProofDirFilePath ??
                                                                    "-",
                                                              ),
                                                        ),
                                                      );
                                                    },
                                                    child: Text(
                                                      "${subHeadings[j]}",
                                                      style: TextStyle(
                                                        fontSize: 14,
                                                        color:
                                                            AppColors.app_blue,
                                                        decoration:
                                                            TextDecoration
                                                                .underline,
                                                        decorationColor:
                                                            AppColors.app_blue,
                                                      ),
                                                    ),
                                                  ),
                                                ),
                                              ] else ...[
                                                Expanded(
                                                  child: InkResponse(
                                                    child: Text(
                                                      "${subHeadings[j]}",
                                                      style: TextStyle(
                                                        fontSize: 14,
                                                        color: Color(
                                                          0xFF818181,
                                                        ),
                                                        decoration:
                                                            TextDecoration.none,
                                                        decorationColor:
                                                            AppColors.white,
                                                      ),
                                                    ),
                                                  ),
                                                ),
                                              ],
                                            ],
                                          ),
                                        );
                                      }),
                                      InkResponse(
                                        onTap: () async {
                                          Navigator.push(
                                            context,
                                            MaterialPageRoute(
                                              builder:
                                                  (
                                                    context,
                                                  ) => Tpcagentdetailsbymode(
                                                    mode: widget.mode,
                                                    pageTitleName:
                                                        widget.pageTitleName,
                                                    tpcAgentId:
                                                        tpcAgentsLists[index]
                                                            .tpcAgentId,
                                                  ),
                                            ),
                                          );
                                        },
                                        child: Container(
                                          padding: EdgeInsets.symmetric(
                                            vertical: 5,
                                          ),
                                          child: Row(
                                            crossAxisAlignment:
                                                CrossAxisAlignment.center,
                                            mainAxisAlignment:
                                                MainAxisAlignment.start,
                                            children: [
                                              Text(
                                                "View Details",
                                                style: TextStyle(
                                                  fontFamily: "JakartaMedium",
                                                  fontSize: 14,
                                                  color: AppColors.app_blue,
                                                ),
                                              ),
                                              SizedBox(width: 5),
                                              SvgPicture.asset(
                                                "assets/svg/next_button.svg",
                                              ),
                                            ],
                                          ),
                                        ),
                                      ),
                                    ],
                                  ),
                                );
                              },
                            ),
                          ],
                        ),
                      )
                      : Emptywidget(context),
            ),
          ),
        );
      },
    );
  }
}
