import 'dart:io';

import 'package:dotted_line/dotted_line.dart';
import 'package:dropdown_button2/dropdown_button2.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:flutter_svg/svg.dart';
import 'package:generp/Notifiers/ordersProvider/dispatchOrderProvider.dart';
import 'package:generp/Notifiers/ordersProvider/pagesDashboardProvider.dart';
import 'package:generp/Utils/GlobalConstants.dart';
import 'package:generp/Utils/dropdownTheme.dart';
import 'package:generp/screens/screensExports.dart';
import 'package:pin_code_fields/pin_code_fields.dart';
import 'package:pinput/pinput.dart';
import 'package:provider/provider.dart';

import '../../Utils/app_colors.dart';
import '../../Utils/commonWidgets.dart';
import '../finance/FileViewer.dart';
import 'editOrderAccountDetails.dart';
import 'package:generp/Models/ordersModels/ordersDetailsDispatchOrderViewResponse.dart';

import 'package:connectivity_plus/connectivity_plus.dart';
import 'package:generp/Utils/commonServices.dart';

class Ordersdetailsbymodes extends StatefulWidget {
  final pageTitleName;
  final orderId;
  final mode;

  const Ordersdetailsbymodes({
    super.key,
    required this.pageTitleName,
    required this.orderId,
    required this.mode,
  });

  @override
  State<Ordersdetailsbymodes> createState() => _OrdersdetailsbymodesState();
}

class _OrdersdetailsbymodesState extends State<Ordersdetailsbymodes> {
  Dropdowntheme ddtheme = Dropdowntheme();
  Map _source = {ConnectivityResult.mobile: true};
  final MyConnectivity _connectivity = MyConnectivity.instance;

  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    _connectivity.initialise();
    _connectivity.myStream.listen((source) {
      setState(() => _source = source);
    });
    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
      var provider = Provider.of<Pagesdashboardprovider>(
        context,
        listen: false,
      );
      provider.showMoreDetails = false;
      var disproved = Provider.of<Dispatchorderprovider>(
        context,
        listen: false,
      );
      provider.ordersDetailsByModeAPIFunction(
        context,
        widget.orderId,
        widget.mode,
      );
    });
  }

  Color getDecorationColor(value) {
    var color = AppColors.approved_bg_color;
    switch (value) {
      case 'Registered':
        return AppColors.requested_bg_color;
      case 'Level 1 Approved':
        return AppColors.approved_bg_color;
      case 'Level 1 Rejected':
        return AppColors.rejected_bg_color;
      case 'Level 2 Approved':
        return AppColors.approved_bg_color;
      case 'Level 2 Rejected':
        return AppColors.rejected_bg_color;
      case 'Sales Order Registered':
        return AppColors.processed_bg_color;
      case 'Dispatched':
        return AppColors.approved_bg_color;
    }
    return color;
  }

  Color getTextColor(value) {
    var color = AppColors.approved_text_color;
    switch (value) {
      case 'Registered':
        return AppColors.requested_text_color;
      case 'Level 1 Approved':
        return AppColors.approved_text_color;
      case 'Level 1 Rejected':
        return AppColors.rejected_text_color;
      case 'Level 2 Approved':
        return AppColors.approved_text_color;
      case 'Level 2 Rejected':
        return AppColors.rejected_text_color;
      case 'Sales Order Registered':
        return AppColors.processed_text_color;
      case 'Dispatched':
        return AppColors.approved_text_color;
    }
    return color;
  }

  getText(value) {
    var text = "R";
    switch (value) {
      case 'Registered':
        return "R";
      case 'Level 1 Approved':
        return "L1A";
      case 'Level 1 Rejected':
        return "L1R";
      case 'Level 2 Approved':
        return "L2A";
      case 'Level 2 Rejected':
        return "L2R";
      case 'Sales Order Registered':
        return "SOR";
      case 'Dispatched':
        return "D";
    }
    return text;
  }

  //All","Registered","Level 1 Approved","Level 2 Approved","Level 1 Rejected",
  // Level 2 Rejected","Level 2 Rejected Final","Sales Order Registered","Dispatched"

  double getSize(value) {
    var text = "A";
    switch (value) {
      case 'Registered':
        return 16.0;
      case 'Level 1 Approved':
        return 13.0;
      case 'Level 1 Rejected':
        return 13.0;
      case 'Level 2 Approved':
        return 13.0;
      case 'Level 2 Rejected':
        return 13.0;
      case 'Processed':
        return 16.0;
      case 'Sales Order Registered':
        return 13.0;
      case 'Dispatched':
        return 16.0;
    }
    return 18.0;
  }

  @override
  void dispose() {
    // TODO: implement dispose
    super.dispose();
    _connectivity.disposeStream();
  }

  @override
  Widget build(BuildContext context) {
    switch (_source.keys.toList()[0]) {
      case ConnectivityResult.mobile:
        connection = 'Online';
        break;
      case ConnectivityResult.wifi:
        connection = 'Online';
        break;
      case ConnectivityResult.none:
      default:
        connection = 'Offline';
    }
    return (connection == "Online")
        ? Platform.isAndroid
            ? WillPopScope(
              onWillPop: () async {
                Provider.of<Pagesdashboardprovider>(
                  context,
                  listen: false,
                ).resetForm();
                Provider.of<Dispatchorderprovider>(
                  context,
                  listen: false,
                ).resetForm();

                return onBackPressed(context);
              },
              child: SafeArea(
                top: false,
                bottom: true,
                child: _scaffold(context),
              ),
            )
            : _scaffold(context)
        : NoNetwork(context);
  }

  Widget _scaffold(BuildContext context) {
    switch (_source.keys.toList()[0]) {
      case ConnectivityResult.mobile:
        connection = 'Online';
        break;
      case ConnectivityResult.wifi:
        connection = 'Online';
        break;
      case ConnectivityResult.none:
      default:
        connection = 'Offline';
    }
    return Consumer2<Pagesdashboardprovider, Dispatchorderprovider>(
      builder: (context, provider, disProvider, child) {
        var orderDetails = provider.orderDetails;
        final productsHistory = provider.productsHistory;
        final feedbackHistory = provider.feedbackHistory;
        final paymentHistory = provider.paymentHistory;

        // var Headings1 = [
        //   "Order Number",
        //   "Account Name",
        //   "Sales Person Name",
        //   "Order Received Date",
        // ];
        // var subHeadings1 = [
        //   provider.orderDetails.orderNumber ?? "-",
        //   provider.orderDetails.accountName ?? "-",
        //   provider.orderDetails.salesPersonEmpName ?? "-",
        //   provider.orderDetails.orderReceivedDate ?? "-",
        // ];
        //
        // var Headings2 = [
        //   "Billing State",
        //   "Billing District",
        //   "Billing Sub Location",
        //   "Billing Pincode",
        //   "Billing Address",
        //
        //   "Entered By",
        //
        //   "Dispatch State",
        //   "Dispatch District",
        //   "District Sub Location",
        //   "Dispatch Pincode",
        //   "Dispatch Address",
        //
        //   "GST Number",
        //
        //   "Unloading Scope",
        //   "Freight Scope",
        //   "Erection Scope",
        //
        //   "CGST Amount",
        //   "SGST Amount",
        //   "IGST Amount",
        //
        //   "OTP",
        //
        //   "Basic Amount",
        //   "Paid Amount",
        //   "Balance Amount",
        //   "Total Amount",
        //
        //   "TPC Applicable",
        //   "TPC Agent",
        //   "TPC Requested Amount",
        //
        //   "TPC Level 1 Approved Amount",
        //   "TPC Level 2 Approved Amount",
        //
        //   "TPC Payment Mode",
        //   "TPC Payment Reference No",
        //   "TPC Payment Attachment",
        //   "TPC Status",
        //   "Purchase Order",
        //
        //   "Created Datetime",
        //   "Note",
        //   "Status",
        // ];
        // var subHeadings2 = [
        //   provider.orderDetails.billingState ?? "-",
        //   provider.orderDetails.billingDistrict ?? "-",
        //   provider.orderDetails.billingSubLocality ?? "-",
        //   provider.orderDetails.billingPincode ?? "-",
        //   provider.orderDetails.billingAddress ?? "-",
        //
        //   provider.orderDetails.enteredEmpName ?? "-",
        //
        //   provider.orderDetails.stateName ?? "-",
        //   provider.orderDetails.districtName ?? "-",
        //   provider.orderDetails.subLocationName ?? "-",
        //   provider.orderDetails.dispatchPincode ?? "-",
        //   provider.orderDetails.dispatchAddress ?? "-",
        //
        //   provider.orderDetails.gstNumber ?? "-",
        //
        //   provider.orderDetails.unloadingScope ?? "-",
        //   provider.orderDetails.freightScope ?? "-",
        //   provider.orderDetails.erectionScope ?? "-",
        //
        //   provider.orderDetails.cgstAmount ?? "-",
        //   provider.orderDetails.sgstAmount ?? "-",
        //   provider.orderDetails.igstAmount ?? "-",
        //
        //   provider.orderDetails.otp ?? "-",
        //
        //   provider.orderDetails.basicAmount ?? "-",
        //   provider.orderDetails.paidAmount ?? "-",
        //   provider.orderDetails.balanceAmount ?? "-",
        //   provider.orderDetails.totalAmount ?? "-",
        //
        //   provider.orderDetails.tpcApplicable ?? "-",
        //   provider.orderDetails.tpcaAgentName ?? "-",
        //   provider.orderDetails.requestedTpcAmount ?? "-",
        //
        //   provider.orderDetails.level1TpcApprovedAmount ?? "-",
        //   provider.orderDetails.level2TpcApprovedAmount ?? "-",
        //
        //   provider.orderDetails.tpcPaymentMode ?? "-",
        //   provider.orderDetails.tpcPaymentReferenceNo ?? "-",
        //   provider.orderDetails.tpcPaymentAttachementViewFileName ?? "-",
        //   provider.orderDetails.tpcStatus ?? "-",
        //   provider.orderDetails.tpcPaymentAttachmentDirFilePath ?? "-",
        //
        //   provider.orderDetails.createdDatetime ?? "-",
        //   provider.orderDetails.note ?? "-",
        //   provider.orderDetails.status ?? "-",
        // ];
        //
        // var Headings = [...Headings1];
        // var subHeadings = [...subHeadings1];
        //
        // if (provider.showMoreDetails) {
        //   Headings = [...Headings1, ...Headings2];
        //   subHeadings = [...subHeadings1, ...subHeadings2];
        // }
        final headings2 = [
          "Order Number",
          "Account Name",
          "Sales Person Name",
          "Order Received Date",
          // "OTP",
        ];
        final subHeadings2 = [
          provider.orderDetails.orderNumber ?? "-",
          provider.orderDetails.accountName ?? "-",
          provider.orderDetails.salesPersonEmpName ?? "-",
          provider.orderDetails.orderReceivedDate ?? "-",
          // provider.orderDetails.otp ?? "-",
        ];

        final headings3 = [
          "State",
          "District",
          "Sub Location",
          "Pincode",
          "Address",
          "Entered By",
        ];
        final subHeadings3 = [
          provider.orderDetails.billingState ?? "-",
          provider.orderDetails.billingDistrict ?? "-",
          provider.orderDetails.billingSubLocality ?? "-",
          provider.orderDetails.billingPincode ?? "-",
          provider.orderDetails.billingAddress ?? "-",
          provider.orderDetails.enteredEmpName ?? "-",
        ];
        final headings4 = [
          "State",
          "District",
          "Sub Location",
          "Pincode",
          "Address",
          "GST Number",
        ];
        final subHeadings4 = [
          provider.orderDetails.stateName ?? "-",
          provider.orderDetails.districtName ?? "-",
          provider.orderDetails.subLocationName ?? "-",
          provider.orderDetails.dispatchPincode ?? "-",
          provider.orderDetails.dispatchAddress ?? "-",

          provider.orderDetails.gstNumber ?? "-",
        ];
        final headings5 = ["Unloading", "Freight", "Erection"];
        final subHeadings5 = [
          provider.orderDetails.unloadingScope ?? "-",
          provider.orderDetails.freightScope ?? "-",
          provider.orderDetails.erectionScope ?? "-",
        ];
        final headings6 = ["CGST", "SGST", "IGST"];
        final subHeadings6 = [
          provider.orderDetails.cgstAmount ?? "-",
          provider.orderDetails.sgstAmount ?? "-",
          provider.orderDetails.igstAmount ?? "-",
        ];

        final headings7 = [
          "Basic Amount",
          "Paid Amount",
          "Balance Amount",
          "Total Amount",
        ];
        final subHeadings7 = [
          provider.orderDetails.basicAmount ?? "-",
          provider.orderDetails.paidAmount ?? "-",
          provider.orderDetails.balanceAmount ?? "-",
          provider.orderDetails.totalAmount ?? "-",
        ];

        final headings8 = [
          "TPC Applicable",
          "TPC Agent",
          "TPC Requested Amount",

          "TPC Level 1 Approved Amount",
          "TPC Level 2 Approved Amount",
        ];
        final subHeadings8 = [
          provider.orderDetails.tpcApplicable ?? "-",
          provider.orderDetails.tpcaAgentName ?? "-",
          provider.orderDetails.requestedTpcAmount ?? "-",

          provider.orderDetails.level1TpcApprovedAmount ?? "-",
          provider.orderDetails.level2TpcApprovedAmount ?? "-",
        ];

        final headings9 = [
          "TPC Payment Mode",
          "TPC Payment Reference No",
          "TPC Payment Attachment",
          "TPC Status",
          "Purchase Order",
        ];
        final subHeadings9 = [
          provider.orderDetails.tpcPaymentMode ?? "-",
          provider.orderDetails.tpcPaymentReferenceNo ?? "-",
          provider.orderDetails.tpcPaymentAttachementViewFileName ?? "-",
          provider.orderDetails.tpcStatus ?? "-",
          provider.orderDetails.tpcPaymentAttachmentDirFilePath ?? "-",
        ];

        final headings10 = ["Created Datetime", "Note", "Status"];
        final subHeadings10 = [
          provider.orderDetails.createdDatetime ?? "-",
          provider.orderDetails.note ?? "-",
          provider.orderDetails.status ?? "-",
        ];

        final sections = [
          {
            "title": "Order Details",
            "headings": headings2,
            "subHeadings": subHeadings2,
          },
          if (provider.showMoreDetails) ...[
            {
              "title": "Amount Details",
              "headings": headings7,
              "subHeadings": subHeadings7,
            },
            {
              "title": "GST Amount",
              "headings": headings6,
              "subHeadings": subHeadings6,
            },

            {
              "title": "Billing Details",
              "headings": headings3,
              "subHeadings": subHeadings3,
            },
            {
              "title": "Dispatch Details",
              "headings": headings4,
              "subHeadings": subHeadings4,
            },
            {
              "title": "Scope",
              "headings": headings5,
              "subHeadings": subHeadings5,
            },
            {
              "title": "TPC Details",
              "headings": headings8,
              "subHeadings": subHeadings8,
            },
            {
              "title": "TPC Payment Details",
              "headings": headings9,
              "subHeadings": subHeadings9,
            },
            {
              "title": "Others",
              "headings": headings10,
              "subHeadings": subHeadings10,
            },
          ],
        ];

        return Scaffold(
          resizeToAvoidBottomInset: true,
          appBar: appbar2New(
            context,
            "Order Details",
            provider.resetAll,
            SizedBox.shrink(),
            0xFFFFFFFF,
          ),
          backgroundColor: AppColors.scaffold_bg_color,
          body: SingleChildScrollView(
            child: Column(
              children: [
                Card(
                  shape: RoundedRectangleBorder(
                    borderRadius: BorderRadius.only(
                      bottomLeft: Radius.circular(30),
                      bottomRight: Radius.circular(30),
                    ),
                  ),
                  elevation: 2,
                  child: Container(
                    decoration: BoxDecoration(
                      color: Colors.white,
                      borderRadius: BorderRadius.only(
                        bottomLeft: Radius.circular(30),
                        bottomRight: Radius.circular(30),
                      ),
                    ),
                    // margin: EdgeInsets.symmetric(vertical: 10, horizontal: 10),
                    padding: EdgeInsets.symmetric(vertical: 10, horizontal: 10),
                    child: Column(
                      children: [
                        Row(
                          children: [
                            Expanded(
                              flex: 1,
                              child: Container(
                                height: 45,
                                width: 45,
                                padding: EdgeInsets.all(7.5),
                                decoration: BoxDecoration(
                                  color: Color(0xFFE6F6FF),
                                  shape: BoxShape.circle,
                                  // borderRadius: BorderRadius.circular(8),
                                ),
                                child: SvgPicture.asset(
                                  "assets/svg/fin_ic.svg",
                                ),
                              ),
                            ),
                            SizedBox(width: 10),
                            Expanded(
                              flex: 4,
                              child: SizedBox(
                                child: Column(
                                  crossAxisAlignment: CrossAxisAlignment.start,
                                  children: [
                                    InkResponse(
                                      onTap: () {},
                                      child: Padding(
                                        padding: const EdgeInsets.only(
                                          top: 8.0,
                                          bottom: 4,
                                        ),
                                        child: Text(
                                          orderDetails.accountName == ""
                                              ? "-"
                                              : orderDetails.accountName ?? "-",
                                          style: TextStyle(
                                            decoration:
                                                TextDecoration.underline,
                                            decorationStyle:
                                                TextDecorationStyle.dotted,
                                            decorationColor:
                                                AppColors.grey_thick,
                                            height: 1.2,
                                            fontFamily: "JakartaRegular",
                                            fontSize: 14,
                                            color: AppColors.semi_black,
                                          ),
                                        ),
                                      ),
                                    ),
                                    Text(
                                      orderDetails.balanceAmount == ""
                                          ? "-"
                                          : "${orderDetails.balanceAmount}",
                                      style: TextStyle(
                                        fontFamily: "JakartaRegular",
                                        fontSize: 14,
                                        color: AppColors.app_blue,
                                      ),
                                    ),
                                  ],
                                ),
                              ),
                            ),

                            Expanded(
                              flex: 2,
                              child: Container(
                                padding: EdgeInsets.symmetric(
                                  horizontal: 5,
                                  vertical: 10,
                                ),
                                decoration: BoxDecoration(
                                  borderRadius: BorderRadius.circular(8),
                                  color: getDecorationColor(
                                    orderDetails.status ?? "-",
                                  ),
                                ),
                                child: Center(
                                  child: Text(
                                    orderDetails.status ?? "-",
                                    textAlign: TextAlign.center,
                                    style: TextStyle(
                                      fontFamily: "JakartaMedium",
                                      fontSize: 14,
                                      color: getTextColor(orderDetails.status),
                                    ),
                                  ),
                                ),
                              ),
                            ),
                            Expanded(
                              flex: 1,
                              child: InkResponse(
                                onTap: () async {
                                  var res = await Navigator.push(
                                    context,
                                    MaterialPageRoute(
                                      builder:
                                          (context) => Editorderaccountdetails(
                                            mode: widget.mode,
                                            pageTitleName: "Edit Order",
                                            orderID: widget.orderId,
                                          ),
                                      settings: RouteSettings(
                                        name: 'Editorderaccountdetails',
                                      ),
                                    ),
                                  );
                                  if (routeSettingName ==
                                      'Editorderaccountdetails') {
                                    provider.ordersDetailsByModeAPIFunction(
                                      context,
                                      widget.orderId,
                                      widget.mode,
                                    );
                                  }
                                },
                                child: Container(
                                  height: 32,
                                  width: 30,
                                  padding: EdgeInsets.all(8.0),
                                  child: SvgPicture.asset(
                                    "assets/svg/crm/lead_details_edit_ic.svg",
                                  ),
                                ),
                              ),
                            ),
                          ],
                        ),
                        SizedBox(height: 10),
                        Column(
                          children: List.generate(sections.length, (
                            sectionIndex,
                          ) {
                            final section = sections[sectionIndex];
                            final title = section["title"] as String;
                            final headings =
                                section["headings"] as List<String>;
                            final subHeadings =
                                section["subHeadings"] as List<String>;

                            return Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: [
                                Container(
                                  padding: EdgeInsets.symmetric(vertical: 4),
                                  child: Row(
                                    children: [
                                      Expanded(
                                        flex: 3,
                                        child: Text(
                                          title,
                                          style: TextStyle(
                                            fontSize: 14,
                                            fontFamily: "JakartaSemiBold",
                                          ),
                                        ),
                                      ),
                                      Expanded(
                                        flex: 6,
                                        child: DottedLine(
                                          dashGapLength: 4,
                                          dashGapColor: Colors.white,
                                          dashColor: AppColors.grey_semi,
                                          dashLength: 2,
                                          lineThickness: 0.5,
                                        ),
                                      ),
                                    ],
                                  ),
                                ),

                                Column(
                                  children: List.generate(headings.length, (j) {
                                    return Container(
                                      padding: EdgeInsets.symmetric(
                                        vertical: 7,
                                      ),
                                      child: Row(
                                        crossAxisAlignment:
                                            CrossAxisAlignment.start,
                                        children: [
                                          Expanded(
                                            child: Text(
                                              headings[j],
                                              style: TextStyle(
                                                fontFamily: "JakartaRegular",
                                                fontSize: 14,
                                                color: AppColors.semi_black,
                                              ),
                                            ),
                                          ),
                                          Expanded(
                                            child: InkResponse(
                                              onTap:
                                                  subHeadings[j] == "View"
                                                      ? () {}
                                                      : null,
                                              child: Text(
                                                subHeadings[j].isEmpty
                                                    ? "-"
                                                    : subHeadings[j],
                                                textAlign: TextAlign.right,
                                                style: TextStyle(
                                                  fontSize: 14,

                                                  decoration:
                                                      subHeadings[j] == "View"
                                                          ? TextDecoration
                                                              .underline
                                                          : TextDecoration.none,
                                                  decorationColor:
                                                      AppColors.app_blue,
                                                  color:
                                                      subHeadings[j] == "View"
                                                          ? AppColors.app_blue
                                                          : Color(0xFF818181),
                                                ),
                                              ),
                                            ),
                                          ),
                                        ],
                                      ),
                                    );
                                  }),
                                ),
                              ],
                            );
                          }),
                        ),

                        InkResponse(
                          onTap: () async {
                            provider.showMoreDetails =
                                !provider.showMoreDetails;
                          },
                          child: Container(
                            padding: EdgeInsets.symmetric(vertical: 5),
                            child: Row(
                              crossAxisAlignment: CrossAxisAlignment.center,
                              mainAxisAlignment: MainAxisAlignment.center,
                              children: [
                                Text(
                                  provider.showMoreDetails
                                      ? "Hide Details"
                                      : "View Details",
                                  style: TextStyle(
                                    fontFamily: "JakartaMedium",
                                    fontSize: 14,
                                    color: AppColors.app_blue,
                                  ),
                                ),
                                Transform.flip(
                                  flipY:
                                      provider.showMoreDetails ? true : false,
                                  child: SvgPicture.asset(
                                    "assets/svg/arrow_dropdown.svg",
                                    height: 25,
                                    width: 20,
                                    color: AppColors.app_blue,
                                  ),
                                ),
                              ],
                            ),
                          ),
                        ),
                        SizedBox(height: 10),
                      ],
                    ),
                  ),
                ),

                Column(
                  children: [
                    ///product details
                    if (productsHistory.isNotEmpty) ...[
                      Container(
                        padding: EdgeInsets.only(left: 10, right: 10, top: 10),
                        child: Row(
                          children: [
                            Expanded(
                              child: Text(
                                textAlign: TextAlign.left,
                                "Product Details",
                                style: TextStyle(
                                  fontFamily: "JakartaMedium",
                                  fontSize: 14,
                                  color: AppColors.grey_thick,
                                ),
                              ),
                            ),
                          ],
                        ),
                      ),

                      SizedBox(
                        width: double.infinity,
                        height: 300,
                        child: ListView.builder(
                          physics: AlwaysScrollableScrollPhysics(),
                          shrinkWrap: true,
                          scrollDirection: Axis.horizontal,
                          padding: EdgeInsets.symmetric(
                            vertical: 5,
                            horizontal: 10,
                          ),
                          itemCount: productsHistory.length,
                          itemBuilder: (context, lp) {
                            return Container(
                              height: 300,
                              width: MediaQuery.of(context).size.width * 0.9,
                              decoration: BoxDecoration(
                                color: Colors.white,
                                borderRadius: BorderRadius.circular(14),
                              ),
                              padding: EdgeInsets.symmetric(
                                horizontal: 10,
                                vertical: 8,
                              ),

                              margin: EdgeInsets.symmetric(
                                horizontal: 5,
                                // vertical: 10,
                              ),

                              child: Column(
                                children: [
                                  Row(
                                    mainAxisAlignment: MainAxisAlignment.start,
                                    crossAxisAlignment:
                                        CrossAxisAlignment.start,
                                    children: [
                                      Expanded(
                                        flex: 1,
                                        child: SvgPicture.asset(
                                          "assets/svg/crm/product_details_ic.svg",
                                        ),
                                      ),
                                      SizedBox(width: 10),
                                      Expanded(
                                        flex: 6,
                                        child: SizedBox(
                                          child: Column(
                                            // mainAxisAlignment: MainAxisAlignment.start,
                                            crossAxisAlignment:
                                                CrossAxisAlignment.start,
                                            mainAxisAlignment:
                                                MainAxisAlignment.start,
                                            children: [
                                              Row(
                                                children: [
                                                  Expanded(
                                                    flex: 4,
                                                    child: Text(
                                                      productsHistory[lp]
                                                              .productName ??
                                                          "-",
                                                      maxLines: 2,
                                                      overflow:
                                                          TextOverflow.ellipsis,
                                                      style: TextStyle(
                                                        fontFamily:
                                                            "JakartaMedium",
                                                        fontSize: 14,
                                                        color:
                                                            AppColors
                                                                .semi_black,
                                                      ),
                                                    ),
                                                  ),
                                                  Expanded(
                                                    flex: 2,
                                                    child: Text(
                                                      textAlign:
                                                          TextAlign.right,
                                                      "₹${productsHistory[lp].unitPrice ?? "-"}",
                                                      style: TextStyle(
                                                        fontFamily:
                                                            "JakartaMedium",
                                                        fontSize: 14,
                                                        color:
                                                            AppColors.app_blue,
                                                      ),
                                                    ),
                                                  ),
                                                ],
                                              ),
                                              Text(
                                                "x  ${productsHistory[lp].qty ?? "-"}",
                                                style: TextStyle(
                                                  fontFamily: "JakartaMedium",
                                                  fontSize: 14,
                                                  color: AppColors.grey_semi,
                                                ),
                                              ),
                                              SizedBox(height: 5),
                                              // DottedLine(
                                              //   dashGapLength: 4,
                                              //   dashGapColor: Colors.white,
                                              //   dashColor: AppColors.grey_semi,
                                              //   dashLength: 2,
                                              //   lineThickness: 0.5,
                                              // ),
                                              // SizedBox(height: 5),
                                              // Text(
                                              //   "₹${productsHistory[lp].totalPrice ?? " - "}",
                                              //   style: TextStyle(
                                              //     fontFamily: "JakartaMedium",
                                              //     fontSize: 14,
                                              //     color: AppColors.semi_black,
                                              //   ),
                                              // ),
                                            ],
                                          ),
                                        ),
                                      ),
                                    ],
                                  ),
                                  Container(
                                    padding: EdgeInsets.symmetric(
                                      vertical: 7.5,
                                    ),
                                    child: Row(
                                      children: [
                                        Expanded(
                                          flex: 3,
                                          child: Text(
                                            "Tax Details",
                                            style: TextStyle(
                                              fontSize: 14,
                                              fontFamily: "JakartaSemiBold",
                                            ),
                                          ),
                                        ),
                                        Expanded(
                                          flex: 7,
                                          child: DottedLine(
                                            dashGapLength: 4,
                                            dashGapColor: Colors.white,
                                            dashColor: AppColors.grey_semi,
                                            dashLength: 2,
                                            lineThickness: 0.5,
                                          ),
                                        ),
                                      ],
                                    ),
                                  ),
                                  ...List.generate(3, (j) {
                                    final heads = [
                                      "CGST (%)",
                                      "SGST (%)",
                                      "IGST (%)",
                                    ];
                                    final subHeads = [
                                      productsHistory[lp].cgstPercentage ?? "-",
                                      productsHistory[lp].sgstPercentage ?? "-",
                                      productsHistory[lp].igstPercentage ?? "-",
                                    ];
                                    return Container(
                                      padding: EdgeInsets.symmetric(
                                        vertical: 3,
                                      ),
                                      child: Row(
                                        crossAxisAlignment:
                                            CrossAxisAlignment.start,
                                        children: [
                                          Expanded(
                                            child: Text(
                                              textAlign: TextAlign.left,
                                              heads[j],
                                              style: TextStyle(
                                                fontFamily: "JakartaRegular",
                                                fontSize: 14,
                                                color: AppColors.semi_black,
                                              ),
                                            ),
                                          ),
                                          if (subHeads[j] == "View") ...[
                                            Expanded(
                                              child: InkResponse(
                                                onTap: () {
                                                  Navigator.push(
                                                    context,
                                                    MaterialPageRoute(
                                                      builder:
                                                          (
                                                            context,
                                                          ) => Fileviewer(
                                                            fileName:
                                                                feedbackHistory[lp]
                                                                    .attachmentViewFileName!,
                                                            fileUrl:
                                                                feedbackHistory[lp]
                                                                    .attachmentDirFilePath!,
                                                          ),
                                                    ),
                                                  );
                                                },
                                                child: Text(
                                                  textAlign: TextAlign.right,
                                                  subHeads[j] == ""
                                                      ? "-"
                                                      : subHeads[j],
                                                  style: TextStyle(
                                                    fontSize: 14,
                                                    color: AppColors.app_blue,
                                                    decorationColor:
                                                        AppColors.app_blue,
                                                    decoration:
                                                        TextDecoration
                                                            .underline,
                                                  ),
                                                ),
                                              ),
                                            ),
                                          ] else ...[
                                            Expanded(
                                              child: Text(
                                                textAlign: TextAlign.right,
                                                subHeads[j] == ""
                                                    ? "-"
                                                    : subHeads[j],
                                                style: TextStyle(
                                                  fontSize: 14,
                                                  color: Color(0xFF818181),
                                                ),
                                              ),
                                            ),
                                          ],
                                        ],
                                      ),
                                    );
                                  }),

                                  Container(
                                    padding: EdgeInsets.symmetric(
                                      vertical: 7.5,
                                    ),
                                    child: Row(
                                      children: [
                                        Expanded(
                                          flex: 3,
                                          child: Text(
                                            "Price Details",
                                            style: TextStyle(
                                              fontSize: 14,
                                              fontFamily: "JakartaSemiBold",
                                            ),
                                          ),
                                        ),
                                        Expanded(
                                          flex: 7,
                                          child: DottedLine(
                                            dashGapLength: 4,
                                            dashGapColor: Colors.white,
                                            dashColor: AppColors.grey_semi,
                                            dashLength: 2,
                                            lineThickness: 0.5,
                                          ),
                                        ),
                                      ],
                                    ),
                                  ),
                                  ...List.generate(2, (j) {
                                    final heads = ["Unit Price", "Total Price"];
                                    final subHeads = [
                                      "₹ ${productsHistory[lp].unitPrice ?? "-"}",
                                      "₹ ${productsHistory[lp].totalPrice ?? "-"}",
                                    ];
                                    return Container(
                                      padding: EdgeInsets.symmetric(
                                        vertical: 3,
                                      ),
                                      child: Row(
                                        crossAxisAlignment:
                                            CrossAxisAlignment.start,
                                        children: [
                                          Expanded(
                                            child: Text(
                                              textAlign: TextAlign.left,
                                              heads[j],
                                              style: TextStyle(
                                                fontFamily: "JakartaRegular",
                                                fontSize: 14,
                                                color: AppColors.semi_black,
                                              ),
                                            ),
                                          ),
                                          if (subHeads[j] == "View") ...[
                                            Expanded(
                                              child: InkResponse(
                                                onTap: () {
                                                  Navigator.push(
                                                    context,
                                                    MaterialPageRoute(
                                                      builder:
                                                          (
                                                            context,
                                                          ) => Fileviewer(
                                                            fileName:
                                                                feedbackHistory[lp]
                                                                    .attachmentViewFileName!,
                                                            fileUrl:
                                                                feedbackHistory[lp]
                                                                    .attachmentDirFilePath!,
                                                          ),
                                                    ),
                                                  );
                                                },
                                                child: Text(
                                                  textAlign: TextAlign.right,
                                                  subHeads[j] == ""
                                                      ? "-"
                                                      : subHeads[j],
                                                  style: TextStyle(
                                                    fontSize: 14,
                                                    color: AppColors.app_blue,
                                                    decorationColor:
                                                        AppColors.app_blue,
                                                    decoration:
                                                        TextDecoration
                                                            .underline,
                                                  ),
                                                ),
                                              ),
                                            ),
                                          ] else ...[
                                            Expanded(
                                              child: Text(
                                                textAlign: TextAlign.right,
                                                subHeads[j] == ""
                                                    ? "-"
                                                    : subHeads[j],
                                                style: TextStyle(
                                                  fontSize: 14,
                                                  color: Color(0xFF818181),
                                                ),
                                              ),
                                            ),
                                          ],
                                        ],
                                      ),
                                    );
                                  }),
                                ],
                              ),
                            );
                          },
                        ),
                      ),
                    ],

                    ///Feedback details
                    Container(
                      padding: EdgeInsets.only(left: 10, right: 10, top: 10),
                      child: Row(
                        children: [
                          Expanded(
                            child: Text(
                              textAlign: TextAlign.left,
                              "Feedback Details",
                              style: TextStyle(
                                fontFamily: "JakartaMedium",
                                fontSize: 14,
                                color: AppColors.grey_thick,
                              ),
                            ),
                          ),
                          if (feedbackHistory.isNotEmpty) ...[
                            Expanded(
                              child: InkResponse(
                                onTap: () async {
                                  _showFeedbackSheet(context);
                                },
                                child: Padding(
                                  padding: const EdgeInsets.all(8.0),
                                  child: Text(
                                    textAlign: TextAlign.right,
                                    "+ Feedback Update",
                                    style: TextStyle(
                                      fontFamily: "JakartaMedium",
                                      fontSize: 14,
                                      color: AppColors.app_blue,
                                    ),
                                  ),
                                ),
                              ),
                            ),
                          ],
                        ],
                      ),
                    ),
                    if (feedbackHistory.isNotEmpty) ...[
                      SizedBox(
                        width: double.infinity,
                        height: 220,
                        child: ListView.builder(
                          physics: AlwaysScrollableScrollPhysics(),
                          shrinkWrap: true,
                          scrollDirection: Axis.horizontal,
                          padding: EdgeInsets.symmetric(
                            vertical: 10,
                            horizontal: 10,
                          ),
                          itemCount: feedbackHistory.length,
                          itemBuilder: (context, lp) {
                            return Container(
                              height: 220,
                              width: MediaQuery.of(context).size.width * 0.9,
                              decoration: BoxDecoration(
                                color: Colors.white,
                                borderRadius: BorderRadius.circular(14),
                              ),
                              padding: EdgeInsets.symmetric(
                                horizontal: 10,
                                vertical: 10,
                              ),
                              margin: EdgeInsets.symmetric(horizontal: 5),

                              child: Column(
                                children: [
                                  Row(
                                    mainAxisAlignment: MainAxisAlignment.start,
                                    crossAxisAlignment:
                                        CrossAxisAlignment.start,
                                    children: [
                                      Expanded(
                                        flex: 1,
                                        child: SvgPicture.asset(
                                          "assets/svg/crm/followup_details_ic.svg",
                                        ),
                                      ),
                                      SizedBox(width: 10),
                                      Expanded(
                                        flex: 6,
                                        child: SizedBox(
                                          child: Column(
                                            // mainAxisAlignment: MainAxisAlignment.start,
                                            crossAxisAlignment:
                                                CrossAxisAlignment.start,
                                            mainAxisAlignment:
                                                MainAxisAlignment.start,
                                            children: [
                                              Row(
                                                children: [
                                                  Expanded(
                                                    flex: 4,
                                                    child: Column(
                                                      crossAxisAlignment:
                                                          CrossAxisAlignment
                                                              .start,
                                                      children: [
                                                        Text(
                                                          feedbackHistory[lp]
                                                                  .employeNaem ??
                                                              "-",
                                                          style: TextStyle(
                                                            fontFamily:
                                                                "JakartaMedium",
                                                            fontSize: 14,
                                                            color:
                                                                AppColors
                                                                    .semi_black,
                                                          ),
                                                        ),
                                                        Text(
                                                          feedbackHistory[lp]
                                                                  .createdDatetime ??
                                                              "-",
                                                          style: TextStyle(
                                                            fontFamily:
                                                                "JakartaMedium",
                                                            fontSize: 14,
                                                            color:
                                                                AppColors
                                                                    .grey_semi,
                                                          ),
                                                        ),
                                                      ],
                                                    ),
                                                  ),
                                                  Expanded(
                                                    flex: 2,
                                                    child: Container(
                                                      decoration: BoxDecoration(
                                                        borderRadius:
                                                            BorderRadius.circular(
                                                              8,
                                                            ),
                                                        color: Color(
                                                          0xFFF3FFD5,
                                                        ),
                                                      ),
                                                      padding:
                                                          EdgeInsets.symmetric(
                                                            horizontal: 5,
                                                            vertical: 10,
                                                          ),
                                                      child: Center(
                                                        child: Text(
                                                          textAlign:
                                                              TextAlign.center,
                                                          feedbackHistory[lp]
                                                                  .status ??
                                                              "-",
                                                          style: TextStyle(
                                                            fontFamily:
                                                                "JakartaMedium",
                                                            fontSize: 14,
                                                            color: Color(
                                                              0xFF586000,
                                                            ),
                                                          ),
                                                        ),
                                                      ),
                                                    ),
                                                  ),
                                                ],
                                              ),
                                            ],
                                          ),
                                        ),
                                      ),
                                    ],
                                  ),
                                  Container(
                                    padding: EdgeInsets.symmetric(
                                      vertical: 7.5,
                                    ),
                                    child: Row(
                                      children: [
                                        Expanded(
                                          flex: 3,
                                          child: Text(
                                            "Feedback",
                                            style: TextStyle(
                                              fontSize: 14,
                                              fontFamily: "JakartaSemiBold",
                                            ),
                                          ),
                                        ),
                                        Expanded(
                                          flex: 7,
                                          child: DottedLine(
                                            dashGapLength: 4,
                                            dashGapColor: Colors.white,
                                            dashColor: AppColors.grey_semi,
                                            dashLength: 2,
                                            lineThickness: 0.5,
                                          ),
                                        ),
                                      ],
                                    ),
                                  ),
                                  ...List.generate(2, (j) {
                                    final heads = ["Feedback", "Attachment"];
                                    final subHeads = [
                                      feedbackHistory[lp].feedback ?? "-",
                                      "View",
                                    ];
                                    return Container(
                                      padding: EdgeInsets.symmetric(
                                        vertical: 3,
                                      ),
                                      child: Row(
                                        crossAxisAlignment:
                                            CrossAxisAlignment.start,
                                        children: [
                                          Expanded(
                                            flex: 1,
                                            child: Text(
                                              textAlign: TextAlign.left,
                                              heads[j],
                                              style: TextStyle(
                                                fontFamily: "JakartaRegular",
                                                fontSize: 14,
                                                color: AppColors.semi_black,
                                              ),
                                            ),
                                          ),
                                          if (subHeads[j] == "View") ...[
                                            Expanded(
                                              flex: 3,
                                              child: InkResponse(
                                                onTap: () {
                                                  Navigator.push(
                                                    context,
                                                    MaterialPageRoute(
                                                      builder:
                                                          (
                                                            context,
                                                          ) => Fileviewer(
                                                            fileName:
                                                                feedbackHistory[lp]
                                                                    .attachmentViewFileName!,
                                                            fileUrl:
                                                                feedbackHistory[lp]
                                                                    .attachmentDirFilePath!,
                                                          ),
                                                    ),
                                                  );
                                                },
                                                child: Text(
                                                  textAlign: TextAlign.right,
                                                  subHeads[j] == ""
                                                      ? "-"
                                                      : subHeads[j],
                                                  style: TextStyle(
                                                    fontSize: 14,
                                                    color: AppColors.app_blue,
                                                    decorationColor:
                                                        AppColors.app_blue,
                                                    decoration:
                                                        TextDecoration
                                                            .underline,
                                                  ),
                                                ),
                                              ),
                                            ),
                                          ] else ...[
                                            Expanded(
                                              flex: 4,
                                              child: Text(
                                                textAlign: TextAlign.right,
                                                subHeads[j] == ""
                                                    ? "-"
                                                    : subHeads[j],
                                                maxLines: 2,
                                                style: TextStyle(
                                                  fontSize: 14,
                                                  color: Color(0xFF818181),
                                                ),
                                              ),
                                            ),
                                          ],
                                        ],
                                      ),
                                    );
                                  }),
                                ],
                              ),
                            );
                          },
                        ),
                      ),
                    ] else ...[
                      InkResponse(
                        onTap: () async {
                          _showFeedbackSheet(context);
                        },
                        child: Container(
                          height: 50,
                          margin: EdgeInsets.symmetric(
                            horizontal: 10,
                            vertical: 10,
                          ),
                          decoration: BoxDecoration(
                            color: Colors.white,
                            borderRadius: BorderRadius.circular(16),
                          ),
                          child: Center(
                            child: Text(
                              textAlign: TextAlign.right,
                              "+ Feedback Update",
                              style: TextStyle(
                                fontFamily: "JakartaMedium",
                                fontSize: 14,
                                color: AppColors.app_blue,
                              ),
                            ),
                          ),
                        ),
                      ),
                    ],

                    ///PaymentHistory details
                    if (paymentHistory.isNotEmpty) ...[
                      Container(
                        padding: EdgeInsets.only(left: 10, right: 10, top: 10),
                        child: Row(
                          children: [
                            Expanded(
                              child: Text(
                                textAlign: TextAlign.left,
                                "Payment Details",
                                style: TextStyle(
                                  fontFamily: "JakartaMedium",
                                  fontSize: 14,
                                  color: AppColors.grey_thick,
                                ),
                              ),
                            ),
                          ],
                        ),
                      ),
                      SizedBox(
                        width: double.infinity,
                        height: 225,
                        child: ListView.builder(
                          physics: AlwaysScrollableScrollPhysics(),
                          shrinkWrap: true,
                          scrollDirection: Axis.horizontal,
                          padding: EdgeInsets.symmetric(
                            vertical: 10,
                            horizontal: 10,
                          ),
                          itemCount: paymentHistory.length,
                          itemBuilder: (context, lp) {
                            return Container(
                              height: 225,
                              width: MediaQuery.of(context).size.width * 0.9,
                              decoration: BoxDecoration(
                                color: Colors.white,
                                borderRadius: BorderRadius.circular(14),
                              ),
                              padding: EdgeInsets.symmetric(
                                horizontal: 10,
                                vertical: 10,
                              ),
                              margin: EdgeInsets.symmetric(horizontal: 5),

                              child: Column(
                                children: [
                                  Row(
                                    mainAxisAlignment: MainAxisAlignment.start,
                                    crossAxisAlignment:
                                        CrossAxisAlignment.start,
                                    children: [
                                      Expanded(
                                        flex: 1,
                                        child: SvgPicture.asset(
                                          "assets/svg/order/payment_history_ic.svg",
                                        ),
                                      ),
                                      SizedBox(width: 10),
                                      Expanded(
                                        flex: 6,
                                        child: SizedBox(
                                          child: Column(
                                            // mainAxisAlignment: MainAxisAlignment.start,
                                            crossAxisAlignment:
                                                CrossAxisAlignment.start,
                                            mainAxisAlignment:
                                                MainAxisAlignment.start,
                                            children: [
                                              Row(
                                                children: [
                                                  Expanded(
                                                    flex: 4,
                                                    child: Column(
                                                      crossAxisAlignment:
                                                          CrossAxisAlignment
                                                              .start,
                                                      children: [
                                                        Text(
                                                          paymentHistory[lp]
                                                                  .ename ??
                                                              "-",
                                                          style: TextStyle(
                                                            fontFamily:
                                                                "JakartaMedium",
                                                            fontSize: 14,
                                                            color:
                                                                AppColors
                                                                    .semi_black,
                                                          ),
                                                        ),
                                                        Text(
                                                          "₹ ${paymentHistory[lp].amount ?? "-"}",
                                                          style: TextStyle(
                                                            fontFamily:
                                                                "JakartaMedium",
                                                            fontSize: 14,
                                                            color:
                                                                AppColors
                                                                    .grey_semi,
                                                          ),
                                                        ),
                                                      ],
                                                    ),
                                                  ),
                                                ],
                                              ),
                                            ],
                                          ),
                                        ),
                                      ),
                                      Expanded(
                                        flex: 2,
                                        child: Container(
                                          height: 45,
                                          padding: EdgeInsets.symmetric(
                                            horizontal: 5,
                                          ),
                                          decoration: BoxDecoration(
                                            color: AppColors.processed_bg_color,
                                            borderRadius: BorderRadius.circular(
                                              8,
                                            ),
                                          ),
                                          child: Center(
                                            child: Text(
                                              paymentHistory[lp]
                                                      .approvalStatus ??
                                                  "-",
                                              textAlign: TextAlign.right,
                                              style: TextStyle(
                                                fontFamily: "JakartaMedium",
                                                fontSize: 14,
                                                color:
                                                    AppColors
                                                        .processed_text_color,
                                              ),
                                            ),
                                          ),
                                        ),
                                      ),
                                    ],
                                  ),
                                  Container(
                                    padding: EdgeInsets.symmetric(vertical: 10),
                                    child: Row(
                                      children: [
                                        Expanded(
                                          flex: 4,
                                          child: Text(
                                            "Payment Info",
                                            style: TextStyle(
                                              fontSize: 14,
                                              fontFamily: "JakartaSemiBold",
                                            ),
                                          ),
                                        ),
                                        Expanded(
                                          flex: 6,
                                          child: DottedLine(
                                            dashGapLength: 4,
                                            dashGapColor: Colors.white,
                                            dashColor: AppColors.grey_semi,
                                            dashLength: 2,
                                            lineThickness: 0.5,
                                          ),
                                        ),
                                      ],
                                    ),
                                  ),
                                  ...List.generate(3, (j) {
                                    final headsa = [
                                      "Mode of Payment",
                                      "Payment Reference",
                                      "Adjusted Amount",
                                      "Payment Date",
                                    ];
                                    final subHeadsa = [
                                      paymentHistory[lp].paymentType ?? "-",
                                      paymentHistory[lp].refNo ?? "-",
                                      "₹${paymentHistory[lp].adjustedAmount ?? "-"}",
                                      paymentHistory[lp].paymentDate ?? "-",
                                    ];
                                    return Container(
                                      padding: EdgeInsets.symmetric(
                                        vertical: 3,
                                      ),
                                      child: Row(
                                        crossAxisAlignment:
                                            CrossAxisAlignment.start,
                                        children: [
                                          Expanded(
                                            child: Text(
                                              textAlign: TextAlign.left,
                                              headsa[j],
                                              style: TextStyle(
                                                fontFamily: "JakartaRegular",
                                                fontSize: 14,
                                                color: AppColors.semi_black,
                                              ),
                                            ),
                                          ),
                                          Expanded(
                                            child: Text(
                                              textAlign: TextAlign.right,
                                              subHeadsa[j] == ""
                                                  ? "-"
                                                  : subHeadsa[j],
                                              style: TextStyle(
                                                fontSize: 14,
                                                color: Color(0xFF818181),
                                              ),
                                            ),
                                          ),
                                        ],
                                      ),
                                    );
                                  }),
                                ],
                              ),
                            );
                          },
                        ),
                      ),
                    ],
                  ],
                ),
              ],
            ),
          ),
          bottomNavigationBar:
              (widget.mode == "pending_approval")
                  ? SizedBox.shrink()
                  : widget.mode == "self" &&
                      orderDetails.status == "Customer verification Pending"
                  ? Container(
                    decoration: BoxDecoration(color: Colors.white),
                    padding: EdgeInsets.symmetric(horizontal: 10),
                    alignment: Alignment.bottomCenter,
                    height: 75,
                    child: Container(
                      margin: EdgeInsets.only(bottom: 10),
                      alignment: Alignment.center,
                      height: 45,
                      child: Row(
                        mainAxisAlignment: MainAxisAlignment.center,
                        children: [
                          SizedBox(width: 10),
                          Expanded(
                            child: InkResponse(
                              onTap: () {
                                _showVerifyOTPSheet(context);
                              },
                              child: Container(
                                // decoration: BoxDecoration(
                                //   borderRadius: BorderRadius.circular(8),
                                //   color: Color(0xFFFFEFEF),
                                //   border: Border.all(
                                //     color: Color(0xFFED3424),
                                //     width: 0.5,
                                //   ),
                                // ),
                                child: Row(
                                  mainAxisAlignment: MainAxisAlignment.center,
                                  children: [
                                    SvgPicture.asset(
                                      "assets/svg/finance/verify_otp_ic.svg",
                                    ),
                                    SizedBox(width: 5),
                                    Center(
                                      child: Text(
                                        "Verify OTP",
                                        style: TextStyle(
                                          color: AppColors.semi_black,
                                          fontSize: 14,
                                        ),
                                      ),
                                    ),
                                  ],
                                ),
                              ),
                            ),
                          ),
                          SizedBox(width: 10),
                        ],
                      ),
                    ),
                  )
                  : Container(
                    decoration: BoxDecoration(color: Colors.white),
                    padding: EdgeInsets.symmetric(horizontal: 10),
                    alignment: Alignment.bottomCenter,
                    height: 75,
                    child: Container(
                      margin: EdgeInsets.only(bottom: 10),
                      alignment: Alignment.center,
                      height: 45,
                      child: Row(
                        mainAxisAlignment: MainAxisAlignment.center,
                        children: [
                          if ([
                            "level_one_approval",
                            "level_two_approval",
                            "level_two_rejected",
                          ].contains(widget.mode)) ...[
                            Expanded(
                              child: InkResponse(
                                onTap: () {
                                  _showLevelApprovalRejectionSheet(
                                    context,
                                    "Reject",
                                  );
                                },
                                child: Container(
                                  // decoration: BoxDecoration(
                                  //   borderRadius: BorderRadius.circular(8),
                                  //   color: Color(0xFFFFEFEF),
                                  //   border: Border.all(
                                  //     color: Color(0xFFED3424),
                                  //     width: 0.5,
                                  //   ),
                                  // ),
                                  child: Row(
                                    mainAxisAlignment: MainAxisAlignment.center,
                                    children: [
                                      SvgPicture.asset(
                                        "assets/svg/finance/level_reject_ic.svg",
                                      ),
                                      SizedBox(width: 5),
                                      Center(
                                        child: Text(
                                          "Reject",
                                          style: TextStyle(
                                            color: AppColors.semi_black,
                                            fontSize: 14,
                                          ),
                                        ),
                                      ),
                                    ],
                                  ),
                                ),
                              ),
                            ),
                          ],
                          SizedBox(width: 10),
                          if ([
                            "level_one_approval",
                            "level_two_approval",
                            "level_two_rejected",
                            "sales_order_registered",
                          ].contains(widget.mode)) ...[
                            SvgPicture.asset(
                              "assets/svg/crm/vertical_line_ic.svg",
                            ),
                            SizedBox(width: 10),
                            Expanded(
                              child: InkResponse(
                                onTap: () {
                                  // provider
                                  //     .approveRejectPaymentRequestAPIFunction(
                                  //   context,
                                  //   provider.requestsDetails.id,
                                  // );
                                  _showLevelApprovalRejectionSheet(
                                    context,
                                    "Approve",
                                  );
                                },
                                child: Container(
                                  // decoration: BoxDecoration(
                                  //   borderRadius: BorderRadius.circular(8),
                                  //   color: Color(0xFFE7FFE5),
                                  //   border: Border.all(
                                  //     color: Color(0xFF0D9C00),
                                  //     width: 0.5,
                                  //   ),
                                  // ),
                                  child: Row(
                                    mainAxisAlignment: MainAxisAlignment.center,
                                    children: [
                                      SvgPicture.asset(
                                        "assets/svg/finance/level_approve_ic.svg",
                                      ),
                                      SizedBox(width: 5),
                                      Center(
                                        child: Text(
                                          "Approve",
                                          style: TextStyle(
                                            color: AppColors.semi_black,
                                            fontSize: 14,
                                          ),
                                        ),
                                      ),
                                    ],
                                  ),
                                ),
                              ),
                            ),
                            SizedBox(width: 10),
                          ],

                          if (widget.mode == "admin") ...[
                            SvgPicture.asset(
                              "assets/svg/crm/vertical_line_ic.svg",
                            ),
                            SizedBox(width: 10),
                            Expanded(
                              child: InkResponse(
                                onTap: () {
                                  _showLevelDeletionSheet(context);
                                },
                                child: Container(
                                  // decoration: BoxDecoration(
                                  //   borderRadius: BorderRadius.circular(8),
                                  //   color: Color(0xFFFFEFEF),
                                  //   border: Border.all(
                                  //     color: Color(0xFFED3424),
                                  //     width: 0.5,
                                  //   ),
                                  // ),
                                  child: Row(
                                    mainAxisAlignment: MainAxisAlignment.center,
                                    children: [
                                      SvgPicture.asset(
                                        "assets/svg/finance/level_delete_ic.svg",
                                      ),
                                      SizedBox(width: 5),
                                      Center(
                                        child: Text(
                                          "Delete",
                                          style: TextStyle(
                                            color: AppColors.semi_black,
                                            fontSize: 14,
                                          ),
                                        ),
                                      ),
                                    ],
                                  ),
                                ),
                              ),
                            ),
                            SizedBox(width: 10),
                          ],
                          if (widget.mode == "dispatched") ...[
                            SvgPicture.asset(
                              "assets/svg/crm/vertical_line_ic.svg",
                            ),
                            SizedBox(width: 10),
                            Expanded(
                              child: InkResponse(
                                onTap: () {
                                  disProvider.initializeForm(context);
                                  disProvider
                                      .ordersDetailsDispatchOrderViewFunction(
                                        context,
                                        widget.orderId,
                                      );
                                  _showDispatchSheet(context, "Dispatch");
                                },
                                child: Container(
                                  decoration: BoxDecoration(
                                    borderRadius: BorderRadius.circular(8),
                                    color: Color(0xFFFFEFEF),
                                    border: Border.all(
                                      color: Color(0xFFED3424),
                                      width: 0.5,
                                    ),
                                  ),
                                  child: Row(
                                    mainAxisAlignment: MainAxisAlignment.center,
                                    children: [
                                      Center(
                                        child: Text(
                                          "Dispatch",
                                          style: TextStyle(
                                            color: AppColors.semi_black,
                                            fontSize: 14,
                                          ),
                                        ),
                                      ),
                                    ],
                                  ),
                                ),
                              ),
                            ),
                          ],
                        ],
                      ),
                    ),
                  ),
        );
      },
    );
  }

  Widget _scaffold1(BuildContext context) {
    switch (_source.keys.toList()[0]) {
      case ConnectivityResult.mobile:
        connection = 'Online';
        break;
      case ConnectivityResult.wifi:
        connection = 'Online';
        break;
      case ConnectivityResult.none:
      default:
        connection = 'Offline';
    }
    return Consumer2<Pagesdashboardprovider, Dispatchorderprovider>(
      builder: (context, provider, disProvider, child) {
        var orderDetails = provider.orderDetails;

        var Headings1 = [
          "Order Number",
          "Account Name",
          "Sales Person Name",
          "Order Received Date",
        ];
        var subHeadings1 = [
          provider.orderDetails.orderNumber ?? "-",
          provider.orderDetails.accountName ?? "-",
          provider.orderDetails.salesPersonEmpName ?? "-",
          provider.orderDetails.orderReceivedDate ?? "-",
        ];

        var Headings2 = [
          "Billing State",
          "Billing District",
          "Billing Sub Location",
          "Billing Pincode",
          "Billing Address",

          "Entered By",

          "Dispatch State",
          "Dispatch District",
          "District Sub Location",
          "Dispatch Pincode",
          "Dispatch Address",

          "GST Number",

          "Unloading Scope",
          "Freight Scope",
          "Erection Scope",

          "CGST Amount",
          "SGST Amount",
          "IGST Amount",

          "OTP",

          "Basic Amount",
          "Paid Amount",
          "Balance Amount",
          "Total Amount",

          "TPC Applicable",
          "TPC Agent",
          "TPC Requested Amount",

          "TPC Level 1 Approved Amount",
          "TPC Level 2 Approved Amount",

          "TPC Payment Mode",
          "TPC Payment Reference No",
          "TPC Payment Attachment",
          "TPC Status",
          "Purchase Order",

          "Created Datetime",
          "Note",
          "Status",
        ];
        var subHeadings2 = [
          provider.orderDetails.billingState ?? "-",
          provider.orderDetails.billingDistrict ?? "-",
          provider.orderDetails.billingSubLocality ?? "-",
          provider.orderDetails.billingPincode ?? "-",
          provider.orderDetails.billingAddress ?? "-",

          provider.orderDetails.enteredEmpName ?? "-",

          provider.orderDetails.stateName ?? "-",
          provider.orderDetails.districtName ?? "-",
          provider.orderDetails.subLocationName ?? "-",
          provider.orderDetails.dispatchPincode ?? "-",
          provider.orderDetails.dispatchAddress ?? "-",

          provider.orderDetails.gstNumber ?? "-",

          provider.orderDetails.unloadingScope ?? "-",
          provider.orderDetails.freightScope ?? "-",
          provider.orderDetails.erectionScope ?? "-",

          provider.orderDetails.cgstAmount ?? "-",
          provider.orderDetails.sgstAmount ?? "-",
          provider.orderDetails.igstAmount ?? "-",

          provider.orderDetails.otp ?? "-",

          provider.orderDetails.basicAmount ?? "-",
          provider.orderDetails.paidAmount ?? "-",
          provider.orderDetails.balanceAmount ?? "-",
          provider.orderDetails.totalAmount ?? "-",

          provider.orderDetails.tpcApplicable ?? "-",
          provider.orderDetails.tpcaAgentName ?? "-",
          provider.orderDetails.requestedTpcAmount ?? "-",

          provider.orderDetails.level1TpcApprovedAmount ?? "-",
          provider.orderDetails.level2TpcApprovedAmount ?? "-",

          provider.orderDetails.tpcPaymentMode ?? "-",
          provider.orderDetails.tpcPaymentReferenceNo ?? "-",
          provider.orderDetails.tpcPaymentAttachementViewFileName ?? "-",
          provider.orderDetails.tpcStatus ?? "-",
          provider.orderDetails.tpcPaymentAttachmentDirFilePath ?? "-",

          provider.orderDetails.createdDatetime ?? "-",
          provider.orderDetails.note ?? "-",
          provider.orderDetails.status ?? "-",
        ];

        var Headings = [...Headings1];
        var subHeadings = [...subHeadings1];

        if (provider.showMoreDetails) {
          Headings = [...Headings1, ...Headings2];
          subHeadings = [...subHeadings1, ...subHeadings2];
        }
        return WillPopScope(
          child: SafeArea(
            top: false,
            bottom: Platform.isIOS ? false : true,
            child: Scaffold(
              resizeToAvoidBottomInset: true,
              appBar: appbar2(
                context,
                widget.mode != ""
                    ? "Order Details"
                    : "Order Details (${widget.mode})",
                provider.resetAll,
                InkResponse(
                  onTap: () {
                    _showOptionsSheet(context);
                  },
                  child: SvgPicture.asset("assets/svg/ic_more.svg", height: 30),
                ),
              ),
              backgroundColor: AppColors.scaffold_bg_color,
              body: Container(
                child: SingleChildScrollView(
                  child: Container(
                    decoration: BoxDecoration(
                      color: Colors.white,
                      borderRadius: BorderRadius.circular(16),
                    ),
                    margin: EdgeInsets.symmetric(vertical: 10, horizontal: 10),
                    padding: EdgeInsets.symmetric(vertical: 10, horizontal: 10),
                    child: Column(
                      children: [
                        Row(
                          children: [
                            Expanded(
                              flex: 1,
                              child: Container(
                                height: 50,
                                width: 35,
                                padding: EdgeInsets.all(8.0),
                                decoration: BoxDecoration(
                                  color: Color(0xFFFFF3CE),
                                  borderRadius: BorderRadius.circular(8),
                                ),
                                child: SvgPicture.asset(
                                  "assets/svg/fin_ic.svg",
                                ),
                              ),
                            ),
                            SizedBox(width: 10),
                            Expanded(
                              flex: 4,
                              child: SizedBox(
                                child: Column(
                                  crossAxisAlignment: CrossAxisAlignment.start,
                                  children: [
                                    Text(
                                      orderDetails.accountName ?? "-",
                                      style: TextStyle(
                                        fontFamily: "JakartaMedium",
                                        fontSize: 14,
                                        color: AppColors.semi_black,
                                      ),
                                    ),
                                    Text(
                                      "₹${orderDetails.balanceAmount}",
                                      style: TextStyle(
                                        fontFamily: "JakartaMedium",
                                        fontSize: 14,
                                        color: AppColors.app_blue,
                                      ),
                                    ),
                                  ],
                                ),
                              ),
                            ),
                            Expanded(
                              flex: 2,
                              child: Container(
                                padding: EdgeInsets.symmetric(
                                  horizontal: 5,
                                  vertical: 10,
                                ),
                                decoration: BoxDecoration(
                                  borderRadius: BorderRadius.circular(8),
                                  color: Color(0xFFE3FFE0),
                                ),
                                child: Center(
                                  child: Text(
                                    orderDetails.status ?? "-",
                                    textAlign: TextAlign.center,
                                    style: TextStyle(
                                      fontFamily: "JakartaMedium",
                                      fontSize: 14,
                                      color: Color(0xFF0D9C00),
                                    ),
                                  ),
                                ),
                              ),
                            ),
                          ],
                        ),
                        Divider(thickness: 0.5, color: Color(0xFFD7D7D7)),
                        ...List.generate(subHeadings.length, (j) {
                          return Container(
                            padding: EdgeInsets.symmetric(vertical: 7),
                            child: Row(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: [
                                Expanded(
                                  child: Text(
                                    Headings[j],
                                    style: TextStyle(
                                      fontFamily: "JakartaMedium",
                                      fontSize: 14,
                                      color: AppColors.semi_black,
                                    ),
                                  ),
                                ),
                                Expanded(
                                  child: InkResponse(
                                    onTap: () {
                                      if (Headings[j] == "Purchase Order") {
                                        Navigator.push(
                                          context,
                                          MaterialPageRoute(
                                            builder:
                                                (context) => Fileviewer(
                                                  fileName:
                                                      orderDetails
                                                          .tpcPaymentAttachementViewFileName!,
                                                  fileUrl:
                                                      orderDetails
                                                          .tpcPaymentAttachmentDirFilePath!,
                                                ),
                                          ),
                                        );
                                      }
                                    },
                                    child: Text(
                                      Headings[j] == "Purchase Order"
                                          ? "View"
                                          : subHeadings[j] == ""
                                          ? "-"
                                          : subHeadings[j],
                                      style: TextStyle(
                                        fontSize: 14,
                                        color:
                                            Headings[j] == "Purchase Order"
                                                ? AppColors.app_blue
                                                : Color(0xFF818181),
                                        decoration:
                                            Headings[j] == "Purchase Order"
                                                ? TextDecoration.underline
                                                : TextDecoration.none,
                                        decorationColor:
                                            Headings[j] == "Purchase Order"
                                                ? AppColors.app_blue
                                                : AppColors.white,
                                      ),
                                    ),
                                  ),
                                ),
                              ],
                            ),
                          );
                        }),
                        InkResponse(
                          onTap: () async {
                            provider.showMoreDetails =
                                !provider.showMoreDetails;
                          },
                          child: Container(
                            padding: EdgeInsets.symmetric(vertical: 5),
                            child: Row(
                              crossAxisAlignment: CrossAxisAlignment.center,
                              mainAxisAlignment: MainAxisAlignment.center,
                              children: [
                                Text(
                                  provider.showMoreDetails
                                      ? "- Show Less"
                                      : "+ More Details",
                                  style: TextStyle(
                                    fontFamily: "JakartaMedium",
                                    fontSize: 14,
                                    color: AppColors.app_blue,
                                  ),
                                ),
                              ],
                            ),
                          ),
                        ),
                      ],
                    ),
                  ),
                ),
              ),
              bottomNavigationBar:
                  ["self", "pending_approval"].contains(widget.mode)
                      ? Container(height: 0)
                      : Container(
                        margin: EdgeInsets.symmetric(horizontal: 10),
                        alignment: Alignment.bottomCenter,
                        height: 60,
                        child: Container(
                          margin: EdgeInsets.only(bottom: 10),
                          alignment: Alignment.center,
                          height: 45,
                          child: Row(
                            mainAxisAlignment: MainAxisAlignment.center,
                            children: [
                              if ([
                                "level_one_approval",
                                "level_two_approval",
                                "level_two_rejected",
                              ].contains(widget.mode)) ...[
                                Expanded(
                                  child: InkResponse(
                                    onTap: () {
                                      _showLevelApprovalRejectionSheet(
                                        context,
                                        "Reject",
                                      );
                                    },
                                    child: Container(
                                      decoration: BoxDecoration(
                                        borderRadius: BorderRadius.circular(8),
                                        color: Color(0xFFFFEFEF),
                                        border: Border.all(
                                          color: Color(0xFFED3424),
                                          width: 0.5,
                                        ),
                                      ),
                                      child: Center(
                                        child: Text(
                                          "Reject",
                                          style: TextStyle(
                                            color: Color(0xFFED3424),
                                          ),
                                        ),
                                      ),
                                    ),
                                  ),
                                ),
                              ],
                              SizedBox(width: 10),
                              if ([
                                "level_one_approval",
                                "level_two_approval",
                                "level_two_rejected",
                                "sales_order_registered",
                              ].contains(widget.mode)) ...[
                                Expanded(
                                  child: InkResponse(
                                    onTap: () {
                                      // provider
                                      //     .approveRejectPaymentRequestAPIFunction(
                                      //   context,
                                      //   provider.requestsDetails.id,
                                      // );
                                      _showLevelApprovalRejectionSheet(
                                        context,
                                        "Approve",
                                      );
                                    },
                                    child: Container(
                                      decoration: BoxDecoration(
                                        borderRadius: BorderRadius.circular(8),
                                        color: Color(0xFFE7FFE5),
                                        border: Border.all(
                                          color: Color(0xFF0D9C00),
                                          width: 0.5,
                                        ),
                                      ),
                                      child: Center(
                                        child: Text(
                                          "Approve",
                                          style: TextStyle(
                                            color: Color(0xFF0D9C00),
                                          ),
                                        ),
                                      ),
                                    ),
                                  ),
                                ),
                              ],

                              if (["admin"].contains(widget.mode)) ...[
                                Expanded(
                                  child: InkResponse(
                                    onTap: () {
                                      _showLevelDeletionSheet(context);
                                    },
                                    child: Container(
                                      decoration: BoxDecoration(
                                        borderRadius: BorderRadius.circular(8),
                                        color: Color(0xFFFFEFEF),
                                        border: Border.all(
                                          color: Color(0xFFED3424),
                                          width: 0.5,
                                        ),
                                      ),
                                      child: Center(
                                        child: Text(
                                          "Delete",
                                          style: TextStyle(
                                            color: Color(0xFFED3424),
                                          ),
                                        ),
                                      ),
                                    ),
                                  ),
                                ),
                              ],
                              if (widget.mode == "dispatched") ...[
                                Expanded(
                                  child: InkResponse(
                                    onTap: () {
                                      disProvider.initializeForm(context);
                                      disProvider
                                          .ordersDetailsDispatchOrderViewFunction(
                                            context,
                                            widget.orderId,
                                          );
                                      _showDispatchSheet(context, "Dispatch");
                                    },
                                    child: Container(
                                      decoration: BoxDecoration(
                                        borderRadius: BorderRadius.circular(8),
                                        color: Color(0xFFFFEFEF),
                                        border: Border.all(
                                          color: Color(0xFFED3424),
                                          width: 0.5,
                                        ),
                                      ),
                                      child: Center(
                                        child: Text(
                                          "Dispatch",
                                          style: TextStyle(
                                            color: Color(0xFFED3424),
                                          ),
                                        ),
                                      ),
                                    ),
                                  ),
                                ),
                              ],
                            ],
                          ),
                        ),
                      ),
            ),
          ),

          onWillPop: () {
            return onBackPressed(context);
          },
        );
      },
    );
  }

  Future<void> _showOptionsSheet(BuildContext context) {
    return showModalBottomSheet(
      useSafeArea: true,
      isDismissible: true,
      isScrollControlled: true,
      showDragHandle: true,
      backgroundColor: Colors.white,
      enableDrag: true,
      context: context,
      builder: (context) {
        return StatefulBuilder(
          builder: (context, setState) {
            return SafeArea(
              child: Consumer<Pagesdashboardprovider>(
                builder: (context, provider, child) {
                  return Container(
                    margin: EdgeInsets.only(
                      bottom: 15,
                      left: 15,
                      right: 15,
                      top: 10,
                    ),
                    padding: EdgeInsets.only(
                      bottom: MediaQuery.of(context).viewInsets.bottom,
                    ),
                    child: SingleChildScrollView(
                      child: Column(
                        mainAxisSize: MainAxisSize.min,
                        children: [
                          SizedBox(height: 15),

                          ...List.generate(4, (index) {
                            final assetnames = [
                              "crm_contact_edit",
                              "order_list_svg_2",
                              "order_list_svg_3",
                              "order_list_svg_3",
                            ];
                            final Headingnames = [
                              "Edit Order",
                              "Payment History",
                              "Products Details",
                              "Feedback History",
                            ];
                            return ListTile(
                              onTap: () async {
                                switch (index) {
                                  case 0:
                                    Navigator.pop(context);
                                    Navigator.push(
                                      context,
                                      MaterialPageRoute(
                                        builder:
                                            (
                                              context,
                                            ) => Editorderaccountdetails(
                                              mode: widget.mode,
                                              pageTitleName:
                                                  "Edit Order (${widget.mode})",
                                              orderID: provider.orderDetails.id,
                                            ),
                                      ),
                                    );
                                    break;
                                  case 1:
                                    Navigator.pop(context);
                                    Navigator.push(
                                      context,
                                      MaterialPageRoute(
                                        builder:
                                            (context) =>
                                                Orderdetailspaymenthistory(),
                                      ),
                                    );
                                    break;
                                  case 2:
                                    Navigator.pop(context);
                                    Navigator.push(
                                      context,
                                      MaterialPageRoute(
                                        builder:
                                            (context) =>
                                                Orderdetailsproductshistory(),
                                      ),
                                    );
                                    break;
                                  case 3:
                                    Navigator.pop(context);
                                    Navigator.push(
                                      context,
                                      MaterialPageRoute(
                                        builder:
                                            (context) =>
                                                Orderdetailsfeedbackhistory(),
                                      ),
                                    );
                                    break;
                                }
                              },
                              leading: SvgPicture.asset(
                                "assets/svg/${assetnames[index]}.svg",
                              ),
                              title: Text(
                                Headingnames[index],
                                style: TextStyle(fontFamily: "JakartaMedium"),
                              ),
                              trailing: SvgPicture.asset(
                                "assets/svg/arrow_right_new.svg",
                              ),
                            );
                          }),
                        ],
                      ),
                    ),
                  );
                },
              ),
            );
          },
        );
      },
    );
  }

  Future<void> _showLevelApprovalRejectionSheet(BuildContext context, type) {
    return showModalBottomSheet(
      useSafeArea: true,
      isDismissible: true,
      isScrollControlled: true,
      showDragHandle: true,
      backgroundColor: Colors.white,
      enableDrag: true,
      context: context,
      builder: (context) {
        return StatefulBuilder(
          builder: (context, setState) {
            return SafeArea(
              child: Consumer<Pagesdashboardprovider>(
                builder: (context, provider, child) {
                  final details = provider.orderDetails;
                  return Container(
                    margin: EdgeInsets.only(
                      bottom: 15,
                      left: 15,
                      right: 15,
                      top: 10,
                    ),
                    padding: EdgeInsets.only(
                      bottom: MediaQuery.of(context).viewInsets.bottom,
                    ),
                    child: SingleChildScrollView(
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        mainAxisSize: MainAxisSize.min,
                        children: [
                          Align(
                            alignment: Alignment.topLeft,
                            child: Text(
                              type == "Approve"
                                  ? provider.approvalSheetHeading
                                  : provider.rejecetionSheetHeading,
                              style: TextStyle(
                                color: AppColors.app_blue,
                                fontSize: 16,
                              ),
                            ),
                          ),
                          if (widget.mode == "sales_order_registered") ...[
                            Padding(
                              padding: const EdgeInsets.only(
                                bottom: 5.0,
                                top: 8.0,
                              ),
                              child: Text("Company Name"),
                            ),
                            Container(
                              height: 50,
                              alignment: Alignment.center,
                              decoration: BoxDecoration(
                                color: Color(0xFFE9E9E9),
                                borderRadius: BorderRadius.circular(14),
                              ),
                              child: Padding(
                                padding: const EdgeInsets.fromLTRB(
                                  10.0,
                                  0.0,
                                  10,
                                  0,
                                ),
                                child: TextFormField(
                                  controller: provider.editCompanyController,
                                  readOnly: true,
                                  keyboardType: TextInputType.text,
                                  maxLines: 1,
                                  onChanged: provider.onChangeEditCompanyName,
                                  style: TextStyle(
                                    color: Color(0xFF818181),
                                    fontSize: 14,
                                  ),
                                  decoration: InputDecoration(
                                    hintText: "Enter Company Name",
                                    hintStyle: TextStyle(
                                      fontWeight: FontWeight.w400,
                                      color: Color(0xFFB4BEC0),
                                      fontSize: 14,
                                    ),

                                    enabledBorder: InputBorder.none,
                                    focusedBorder: InputBorder.none,
                                  ),
                                ),
                              ),
                            ),
                            if (provider.companyNameError != null) ...[
                              Container(
                                alignment: Alignment.topLeft,
                                margin: EdgeInsets.only(top: 2.5, left: 25),
                                child: Text(
                                  "${provider.companyNameError}",
                                  style: TextStyle(
                                    color: Colors.red,
                                    fontSize: 10,
                                  ),
                                ),
                              ),
                            ],
                            Padding(
                              padding: const EdgeInsets.only(
                                bottom: 5.0,
                                top: 8.0,
                              ),
                              child: Text("Sale Order Number"),
                            ),
                            Container(
                              height: 50,
                              alignment: Alignment.center,
                              decoration: BoxDecoration(
                                color: Color(0xFFE9E9E9),
                                borderRadius: BorderRadius.circular(14),
                              ),
                              child: Padding(
                                padding: const EdgeInsets.fromLTRB(
                                  10.0,
                                  0.0,
                                  10,
                                  0,
                                ),
                                child: TextFormField(
                                  controller:
                                      provider.saleOrderNumberController,
                                  readOnly: true,
                                  keyboardType: TextInputType.text,
                                  maxLines: 1,
                                  onChanged: provider.onChangeSaleOrderNumber,
                                  style: TextStyle(
                                    color: Color(0xFF818181),
                                    fontSize: 14,
                                  ),
                                  decoration: InputDecoration(
                                    hintText: "Enter Order Number",
                                    hintStyle: TextStyle(
                                      fontWeight: FontWeight.w400,
                                      color: Color(0xFFB4BEC0),
                                      fontSize: 14,
                                    ),

                                    enabledBorder: InputBorder.none,
                                    focusedBorder: InputBorder.none,
                                  ),
                                ),
                              ),
                            ),
                            if (provider.saleOrderNumberError != null) ...[
                              Container(
                                alignment: Alignment.topLeft,
                                margin: EdgeInsets.only(top: 2.5, left: 25),
                                child: Text(
                                  "${provider.saleOrderNumberError}",
                                  style: TextStyle(
                                    color: Colors.red,
                                    fontSize: 10,
                                  ),
                                ),
                              ),
                            ],
                          ],

                          Padding(
                            padding: const EdgeInsets.only(
                              bottom: 5.0,
                              top: 8.0,
                            ),
                            child: Text("Remarks"),
                          ),
                          Container(
                            height: 150,
                            alignment: Alignment.center,
                            decoration: BoxDecoration(
                              color: Color(0xFFE9E9E9),
                              borderRadius: BorderRadius.circular(14),
                            ),
                            child: Padding(
                              padding: const EdgeInsets.fromLTRB(
                                10.0,
                                0.0,
                                10,
                                0,
                              ),
                              child: TextFormField(
                                controller:
                                    provider.approveRejectFeedbackController,
                                readOnly: true,
                                keyboardType: TextInputType.text,
                                maxLines: 60,
                                onChanged: provider.onChangeApproveRejection,
                                style: TextStyle(
                                  color: Color(0xFF818181),
                                  fontSize: 14,
                                ),
                                decoration: InputDecoration(
                                  hintText: "Write Remarks",
                                  hintStyle: TextStyle(
                                    fontWeight: FontWeight.w400,
                                    color: Color(0xFFB4BEC0),
                                    fontSize: 14,
                                  ),

                                  enabledBorder: InputBorder.none,
                                  focusedBorder: InputBorder.none,
                                ),
                              ),
                            ),
                          ),
                          if (provider.approveRejectFeedbackError != null) ...[
                            Container(
                              alignment: Alignment.topLeft,
                              margin: EdgeInsets.only(top: 2.5, left: 25),
                              child: Text(
                                "${provider.approveRejectFeedbackError}",
                                style: TextStyle(
                                  color: Colors.red,
                                  fontSize: 10,
                                ),
                              ),
                            ),
                          ],
                          InkWell(
                            onTap:
                                provider.submitClicked
                                    ? null
                                    : () {
                                      provider.submitClicked = true;
                                      provider.approvalRejectionAPIFunction(
                                        context,
                                        details.status,
                                        details.id,
                                        type == "Approve"
                                            ? "Approved"
                                            : "Rejected",
                                        details.tpcApplicable,
                                        details.tpcApplicable == "Yes"
                                            ? (widget.mode ==
                                                    "level_one_approval"
                                                ? details
                                                    .level1TpcApprovedAmount
                                                : details
                                                    .level2TpcApprovedAmount)
                                            : "",
                                        widget.mode == "dispatched"
                                            ? details.invoiceNumber
                                            : "",
                                        widget.mode == "dispatched"
                                            ? details.vehicleNumber
                                            : "",
                                        widget.mode == "dispatched"
                                            ? details.driverName
                                            : "",
                                        widget.mode == "dispatched"
                                            ? details.driverMobileNumber
                                            : "",
                                        widget.mode == "dispatched" ? [] : [],
                                        widget.mode,
                                      );
                                    },

                            child: Container(
                              alignment: Alignment.center,
                              height: 45,
                              margin: EdgeInsets.only(
                                left: 5.0,
                                right: 5.0,
                                top: 5.0,
                                bottom: 5.0,
                              ),
                              decoration: BoxDecoration(
                                color: AppColors.app_blue, //1487C9
                                borderRadius: BorderRadius.circular(14.0),
                              ),
                              child: Center(
                                child:
                                    provider.submitClicked
                                        ? CircularProgressIndicator.adaptive(
                                          valueColor: AlwaysStoppedAnimation(
                                            Colors.white,
                                          ),
                                        )
                                        : Text(
                                          "Submit",
                                          textAlign: TextAlign.center,
                                          style: TextStyle(color: Colors.white),
                                        ),
                              ),
                            ),
                          ),
                        ],
                      ),
                    ),
                  );
                },
              ),
            );
          },
        );
      },
    );
  }

  Future<void> _showDispatchSheet(BuildContext context, type) {
    return showModalBottomSheet(
      useSafeArea: true,
      isDismissible: true,
      isScrollControlled: true,
      showDragHandle: true,
      backgroundColor: Colors.white,
      enableDrag: true,
      context: context,
      builder: (context) {
        return StatefulBuilder(
          builder: (context, setState) {
            return SafeArea(
              child: Consumer2<Pagesdashboardprovider, Dispatchorderprovider>(
                builder: (context, provider, disProvider, child) {
                  final details = provider.orderDetails;
                  return Container(
                    margin: EdgeInsets.only(
                      bottom: 15,
                      left: 15,
                      right: 15,
                      top: 10,
                    ),
                    padding: EdgeInsets.only(
                      bottom: MediaQuery.of(context).viewInsets.bottom,
                    ),
                    child: SingleChildScrollView(
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        mainAxisSize: MainAxisSize.min,
                        children: [
                          Align(
                            alignment: Alignment.topLeft,
                            child: Text(
                              "Dispatch",
                              style: TextStyle(
                                color: AppColors.app_blue,
                                fontSize: 16,
                              ),
                            ),
                          ),
                          textControllerWidget(
                            context,
                            disProvider.invoiceNumberController,
                            "Invoice Number",
                            "Enter Invoice Number",
                            disProvider.onChangedinvoiceNumber,
                            TextInputType.text,
                            false,
                            null,
                          ),
                          errorWidget(context, disProvider.invoiceNumberError),
                          textControllerWidget(
                            context,
                            disProvider.vehicleNumberController,
                            "Vehicle Number",
                            "Enter Vehicle Number",
                            disProvider.onChangedvehicleNumber,
                            TextInputType.text,
                            false,
                            null,
                          ),
                          errorWidget(context, disProvider.vehicleNumberError),
                          textControllerWidget(
                            context,
                            disProvider.driverNameController,
                            "Driver Name",
                            "Enter Driver Name",
                            disProvider.onChangeddriverName,
                            TextInputType.text,
                            false,
                            null,
                          ),
                          errorWidget(context, disProvider.driverNameError),
                          textControllerWidget(
                            context,
                            disProvider.driverMobileNumberController,
                            "Driver Mobile Number",
                            "Enter Driver Mobile Number",
                            disProvider.onChangeddriverMobileNumber,
                            TextInputType.text,
                            false,
                            null,
                          ),
                          errorWidget(
                            context,
                            disProvider.driverMobileNumberError,
                          ),
                          InkResponse(
                            onTap: () {
                              disProvider.editAddNewRow();
                            },
                            child: Container(
                              margin: const EdgeInsets.symmetric(vertical: 10),
                              height: 45,
                              width: MediaQuery.of(context).size.width,
                              decoration: BoxDecoration(
                                color: const Color(0xFFE6F6FF),
                                borderRadius: BorderRadius.circular(12),
                                border: Border.all(
                                  color: AppColors.app_blue,
                                  width: 0.5,
                                ),
                              ),
                              child: Center(
                                child: Text(
                                  "+ Add Product",
                                  style: TextStyle(
                                    fontFamily: "JakartaMedium",
                                    color: AppColors.app_blue,
                                  ),
                                ),
                              ),
                            ),
                          ),
                          if (disProvider.leadProductsList.isNotEmpty ||
                              disProvider
                                  .engineNumberControllers
                                  .isNotEmpty) ...[
                            ListView.builder(
                              itemCount:
                                  disProvider.engineNumberControllers.length,
                              physics: const NeverScrollableScrollPhysics(),
                              shrinkWrap: true,
                              itemBuilder: (context, j) {
                                return Container(
                                  padding: const EdgeInsets.symmetric(
                                    horizontal: 10,
                                    vertical: 10,
                                  ),
                                  margin: const EdgeInsets.symmetric(
                                    vertical: 10,
                                  ),
                                  decoration: BoxDecoration(
                                    color: Colors.white,
                                    borderRadius: BorderRadius.circular(20),
                                  ),
                                  child: Column(
                                    crossAxisAlignment:
                                        CrossAxisAlignment.start,
                                    children: [
                                      TextWidget(context, "Product"),
                                      DropdownButtonHideUnderline(
                                        child: Row(
                                          children: [
                                            Expanded(
                                              child: DropdownButton2<Products>(
                                                isExpanded: true,
                                                hint: const Text(
                                                  'Select Product',
                                                  style: TextStyle(
                                                    fontSize: 14,
                                                  ),
                                                  overflow:
                                                      TextOverflow.ellipsis,
                                                ),
                                                items:
                                                    disProvider.productsList
                                                        .map(
                                                          (
                                                            ord,
                                                          ) => DropdownMenuItem<
                                                            Products
                                                          >(
                                                            value: ord,
                                                            child: Text(
                                                              "${ord.productName}",
                                                              style:
                                                                  const TextStyle(
                                                                    fontSize:
                                                                        14,
                                                                  ),
                                                              overflow:
                                                                  TextOverflow
                                                                      .ellipsis,
                                                            ),
                                                          ),
                                                        )
                                                        .toList(),
                                                value:
                                                    disProvider.selectedProductIds[j] !=
                                                            null
                                                        ? disProvider
                                                            .productsList
                                                            .firstWhere(
                                                              (ord) =>
                                                                  ord.id ==
                                                                  disProvider
                                                                      .selectedProductIds[j],
                                                              orElse:
                                                                  () =>
                                                                      disProvider
                                                                          .productsList[0],
                                                            )
                                                        : null,
                                                onChanged: (Products? value) {
                                                  if (value != null) {
                                                    disProvider
                                                        .updateSelectedProductIds(
                                                          j,
                                                          value,
                                                        );
                                                    disProvider
                                                            .selectedProductIds[j] =
                                                        value.id?.toString() ??
                                                        '';
                                                    disProvider
                                                        .updateTotalAmount(j);
                                                  }
                                                },
                                                buttonStyleData:
                                                    ddtheme.buttonStyleData,
                                                iconStyleData:
                                                    ddtheme.iconStyleData,
                                                menuItemStyleData:
                                                    ddtheme.menuItemStyleData,
                                                dropdownStyleData:
                                                    ddtheme.dropdownStyleData,
                                              ),
                                            ),
                                          ],
                                        ),
                                      ),
                                      const SizedBox(height: 10),
                                      Row(
                                        children: [
                                          Expanded(
                                            flex: 2,
                                            child: textControllerWidget(
                                              context,
                                              disProvider
                                                  .engineNumberControllers[j],
                                              "Engine Number",
                                              "Enter Engine Number",
                                              (p0) {
                                                if (disProvider
                                                    .engineNumberControllers[j]
                                                    .text
                                                    .trim()
                                                    .isEmpty) {
                                                  disProvider
                                                      .pdiIDControllers[j]
                                                      .clear();
                                                }
                                                disProvider.updateTotalAmount(
                                                  j,
                                                );
                                                disProvider
                                                    .ordersPDIIDByEngineNumberFunction(
                                                      context,
                                                      j,
                                                    );
                                              },
                                              TextInputType.text,
                                              false,
                                              null,
                                            ),
                                          ),
                                        ],
                                      ),
                                      const SizedBox(height: 10),
                                      Row(
                                        children: [
                                          Expanded(
                                            flex: 2,
                                            child: textControllerWidget(
                                              context,
                                              disProvider.pdiIDControllers[j],
                                              "PDI ID",
                                              "Enter PDI ID",
                                              (value) => disProvider
                                                  .updateTotalAmount(j),
                                              TextInputType.text,
                                              true,
                                              null,
                                            ),
                                          ),
                                        ],
                                      ),
                                      const SizedBox(height: 10),
                                      // IconButton(
                                      //   icon: const Icon(Icons.delete),
                                      //   onPressed: disProvider.editProductPriceControllers.length > 1
                                      //       ? () => disProvider.editRemoveRow(j)
                                      //       : null,
                                      // ),
                                    ],
                                  ),
                                );
                              },
                            ),
                          ],
                          InkWell(
                            onTap:
                                provider.submitClicked
                                    ? null
                                    : () {
                                      provider.submitClicked = false;
                                      final data = disProvider.getFormData();
                                      print(data);
                                      disProvider.approvalRejectionAPIFunction(
                                        context,
                                        details.status,
                                        details.id,
                                        type == "Dispatch",
                                        provider
                                            .approveRejectFeedbackController
                                            .text,
                                        details.tpcApplicable,
                                        details.tpcApplicable == "Yes"
                                            ? (widget.mode ==
                                                    "level_one_approval"
                                                ? details
                                                    .level1TpcApprovedAmount
                                                : details
                                                    .level2TpcApprovedAmount)
                                            : "",
                                        provider.saleOrderNumberController.text,
                                        provider.editCompanyController.text,
                                        data,
                                        widget.mode,
                                      );
                                    },

                            child: Container(
                              alignment: Alignment.center,
                              height: 45,
                              margin: EdgeInsets.only(
                                left: 5.0,
                                right: 5.0,
                                top: 5.0,
                                bottom: 5.0,
                              ),
                              decoration: BoxDecoration(
                                color: AppColors.app_blue, //1487C9
                                borderRadius: BorderRadius.circular(14.0),
                              ),
                              child: Center(
                                child:
                                    provider.submitClicked
                                        ? CircularProgressIndicator.adaptive(
                                          valueColor: AlwaysStoppedAnimation(
                                            Colors.white,
                                          ),
                                        )
                                        : Text(
                                          "Submit",
                                          textAlign: TextAlign.center,
                                          style: TextStyle(color: Colors.white),
                                        ),
                              ),
                            ),
                          ),
                        ],
                      ),
                    ),
                  );
                },
              ),
            );
          },
        );
      },
    );
  }

  Future<void> _showLevelDeletionSheet(BuildContext context) {
    return showModalBottomSheet(
      useSafeArea: true,
      isDismissible: true,
      isScrollControlled: true,
      showDragHandle: true,
      backgroundColor: Colors.white,
      enableDrag: true,
      context: context,
      builder: (context) {
        return StatefulBuilder(
          builder: (context, setState) {
            return SafeArea(
              child: Consumer<Pagesdashboardprovider>(
                builder: (context, provider, child) {
                  return Container(
                    margin: EdgeInsets.only(
                      bottom: 15,
                      left: 15,
                      right: 15,
                      top: 10,
                    ),
                    padding: EdgeInsets.only(
                      bottom: MediaQuery.of(context).viewInsets.bottom,
                    ),
                    child: SingleChildScrollView(
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        mainAxisSize: MainAxisSize.min,
                        children: [
                          Align(
                            alignment: Alignment.topLeft,
                            child: Text(
                              provider.deletionSheetHeading,
                              style: TextStyle(
                                color: AppColors.app_blue,
                                fontSize: 16,
                              ),
                            ),
                          ),

                          Padding(
                            padding: const EdgeInsets.only(
                              bottom: 5.0,
                              top: 8.0,
                            ),
                            child: Text("Remarks"),
                          ),
                          Container(
                            height: 150,
                            alignment: Alignment.center,
                            decoration: BoxDecoration(
                              color: Color(0xFFE9E9E9),
                              borderRadius: BorderRadius.circular(14),
                            ),
                            child: Padding(
                              padding: const EdgeInsets.fromLTRB(
                                10.0,
                                0.0,
                                10,
                                0,
                              ),
                              child: TextFormField(
                                controller: provider.deleteFeedbackController,
                                readOnly: true,
                                keyboardType: TextInputType.text,
                                maxLines: 60,
                                onChanged: provider.onChangeDeletion,
                                style: TextStyle(
                                  color: Color(0xFF818181),
                                  fontSize: 14,
                                ),
                                decoration: InputDecoration(
                                  hintText: "Write Remarks",
                                  hintStyle: TextStyle(
                                    fontWeight: FontWeight.w400,
                                    color: Color(0xFFB4BEC0),
                                    fontSize: 14,
                                  ),

                                  enabledBorder: InputBorder.none,
                                  focusedBorder: InputBorder.none,
                                ),
                              ),
                            ),
                          ),
                          if (provider.deleteFeedbackError != null) ...[
                            Container(
                              alignment: Alignment.topLeft,
                              margin: EdgeInsets.only(top: 2.5, left: 25),
                              child: Text(
                                "${provider.deleteFeedbackError}",
                                style: TextStyle(
                                  color: Colors.red,
                                  fontSize: 10,
                                ),
                              ),
                            ),
                          ],
                          InkWell(
                            onTap:
                                provider.submitClicked
                                    ? null
                                    : () {
                                      provider.submitClicked = true;
                                      provider.delectionAPIFunction(
                                        context,
                                        provider.orderDetails.id,
                                      );
                                    },
                            child: Container(
                              alignment: Alignment.center,
                              height: 45,
                              margin: EdgeInsets.only(
                                left: 5.0,
                                right: 5.0,
                                top: 5.0,
                                bottom: 5.0,
                              ),
                              decoration: BoxDecoration(
                                color: AppColors.app_blue, //1487C9
                                borderRadius: BorderRadius.circular(14.0),
                              ),
                              child: Center(
                                child:
                                    provider.submitClicked
                                        ? CircularProgressIndicator.adaptive(
                                          valueColor: AlwaysStoppedAnimation(
                                            Colors.white,
                                          ),
                                        )
                                        : Text(
                                          "Submit",
                                          textAlign: TextAlign.center,
                                          style: TextStyle(color: Colors.white),
                                        ),
                              ),
                            ),
                          ),
                        ],
                      ),
                    ),
                  );
                },
              ),
            );
          },
        );
      },
    );
  }

  Future<void> _showVerifyOTPSheet(BuildContext context) {
    return showModalBottomSheet(
      useSafeArea: true,
      isDismissible: true,
      isScrollControlled: true,
      showDragHandle: true,
      backgroundColor: Colors.white,
      enableDrag: true,
      context: context,
      builder: (context) {
        return StatefulBuilder(
          builder: (context, setState) {
            return SafeArea(
              child: Consumer<Pagesdashboardprovider>(
                builder: (context, provider, child) {
                  return Padding(
                    padding: EdgeInsets.only(
                      bottom:
                          MediaQuery.of(
                            context,
                          ).viewInsets.bottom, // This handles keyboard
                    ),
                    child: Container(
                      margin: EdgeInsets.only(
                        bottom: 15,
                        left: 15,
                        right: 15,
                        top: 10,
                      ),

                      child: SingleChildScrollView(
                        child: Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          mainAxisSize: MainAxisSize.min,
                          children: [
                            Align(
                              alignment: Alignment.center,
                              child: Text(
                                "Enter OTP",
                                style: TextStyle(
                                  color: AppColors.app_blue,
                                  fontSize: 16,
                                ),
                              ),
                            ),
                            SizedBox(height: 15),
                            Column(
                              children: [
                                // Container(
                                //   alignment: Alignment.center,
                                //
                                //   height: 50,
                                //   margin: EdgeInsets.only(
                                //     left: 5.0,
                                //     right: 5.0,
                                //   ),
                                //   child: Pinput(
                                //     controller: provider.otpController,
                                //     appContext: context,
                                //     pastedTextStyle: TextStyle(
                                //       fontWeight: FontWeight.bold,
                                //     ),
                                //     length: 4,
                                //     blinkWhenObscuring: true,
                                //
                                //     animationType: AnimationType.fade,
                                //     // validator: (v) {
                                //     //   if (v!.length < 3) {
                                //     //     return "I'm from validator";
                                //     //   } else {
                                //     //     return null;
                                //     //   }
                                //     // },
                                //     pinTheme: PinTheme(
                                //       shape: PinCodeFieldShape.underline,
                                //       borderRadius: BorderRadius.circular(16),
                                //       fieldHeight: 60,
                                //       fieldWidth: 60,
                                //       activeFillColor:
                                //       AppColors.text_field_color,
                                //       activeColor: AppColors.app_blue,
                                //       selectedColor: AppColors.text_field_color,
                                //       selectedFillColor:
                                //       AppColors.text_field_color,
                                //       inactiveFillColor:
                                //       AppColors.text_field_color,
                                //       inactiveColor: AppColors.text_field_color,
                                //       fieldOuterPadding: EdgeInsets.only(
                                //         left: 5,
                                //         right: 5,
                                //       ),
                                //       inactiveBorderWidth: 0,
                                //       activeBorderWidth: 0.5,
                                //     ),
                                //     enableActiveFill: true,
                                //     keyboardType: TextInputType.number,
                                //     boxShadows: const [
                                //       BoxShadow(
                                //         offset: Offset(0, 1),
                                //         color: Colors.black12,
                                //         blurRadius: 10,
                                //       ),
                                //     ],
                                //     onCompleted: (String enteredCode) {
                                //       provider.enteredOtp = enteredCode;
                                //       // clearText = true;
                                //       provider.verifyOrderAPIFunction(context,widget.orderId);
                                //
                                //       debugPrint("Completed");
                                //     },
                                //     // onTap: () {
                                //     //   print("Pressed");
                                //     // },
                                //     onChanged: (String enteredCode) {
                                //       debugPrint(enteredCode);
                                //
                                //       provider.enteredOtp = enteredCode;
                                //     },
                                //     onSubmitted: (String enteredCode) {
                                //       provider.enteredOtp = enteredCode;
                                //       // clearText = true;
                                //       // Verify_otp();
                                //     },
                                //     enablePinAutofill: true,
                                //     useExternalAutoFillGroup: true,
                                //     beforeTextPaste: (text) {
                                //       debugPrint("Allowing to paste $text");
                                //       //if you return true then it will show the paste confirmation dialog. Otherwise if false, then nothing will happen.
                                //       //but you can show anything you want here, like your pop up saying wrong paste format or etc
                                //       return true;
                                //     },
                                //   ),
                                // ),
                                Container(
                                  margin: EdgeInsets.zero,
                                  width:
                                      MediaQuery.of(context).size.width * 0.78,
                                  child: Pinput(
                                    useNativeKeyboard: true,
                                    // pastedTextStyle: TextStyle(
                                    //   color: ColorConstant.Fillcolor,
                                    //   fontWeight: FontWeight.bold,
                                    // ),
                                    length: 4,
                                    autofocus: true,
                                    showCursor: true,
                                    animationCurve: Curves.bounceInOut,

                                    // controller: provider.otpController,
                                    hapticFeedbackType:
                                        HapticFeedbackType.mediumImpact,

                                    // defaultPinTheme: PinTheme(
                                    //   height: 50,
                                    //   width: 60,
                                    //   decoration: BoxDecoration(
                                    //       borderRadius: BorderRadius.circular(15),
                                    //       color: Color(0xFFF5F5F5)),
                                    // ),
                                    // focusedPinTheme: PinTheme(
                                    //   height: 50,
                                    //   width: 60,
                                    //   decoration: BoxDecoration(
                                    //       border:
                                    //       Border.all(color: AppColors.cyan_blue),
                                    //       borderRadius: BorderRadius.circular(15),
                                    //       color: Color(0xFFF5F5F5)),
                                    // ),
                                    // submittedPinTheme: PinTheme(
                                    //   height: 50,
                                    //   width: 60,
                                    //   textStyle: TextStyle(color: Colors.white),
                                    //   decoration: BoxDecoration(
                                    //       border:
                                    //       Border.all(color: AppColors.cyan_blue),
                                    //       borderRadius: BorderRadius.circular(15),
                                    //       color: AppColors.cyan_blue),
                                    // ),
                                    keyboardType:
                                        TextInputType.numberWithOptions(),
                                    textInputAction:
                                        (Platform.isAndroid)
                                            ? TextInputAction.none
                                            : TextInputAction.done,

                                    inputFormatters: <TextInputFormatter>[
                                      FilteringTextInputFormatter.digitsOnly,
                                    ],
                                    onCompleted: (String enteredCode) {
                                      provider.enteredOtp = enteredCode;
                                      provider.verifyOrderAPIFunction(
                                        context,
                                        provider.orderDetails.id,
                                        provider.enteredOtp,
                                      );
                                    },

                                    onChanged: (String enteredCode) {
                                      provider.enteredOtp = enteredCode;
                                    },

                                    // onSubmitted: (String enteredCode) {
                                    //   setState(() {
                                    //     enteredOtp = enteredCode;
                                    //     clearText = true;
                                    //     //Verify_otp();
                                    //   });
                                    // },
                                  ),
                                ),
                                SizedBox(height: 15),
                                Container(
                                  alignment: Alignment.center,
                                  height: 45,
                                  margin: EdgeInsets.only(
                                    left: 5.0,
                                    right: 5.0,
                                    top: 5.0,
                                    bottom: 5.0,
                                  ),
                                  child: InkResponse(
                                    onTap: () {
                                      provider.ResendOtpAPI(
                                        context,
                                        provider.orderDetails.id,
                                      );
                                    },
                                    child: Center(
                                      child: Text(
                                        "Resend",
                                        style: TextStyle(
                                          fontWeight: FontWeight.w300,
                                        ),
                                      ),
                                    ),
                                  ),
                                ),

                                InkResponse(
                                  onTap: () async {
                                    await provider.verifyOrderAPIFunction(
                                      context,
                                      provider.orderDetails.id,
                                      provider.enteredOtp,
                                    );
                                  },
                                  child: Container(
                                    alignment: Alignment.center,
                                    height: 45,
                                    margin: EdgeInsets.only(
                                      left: 5.0,
                                      right: 5.0,
                                      top: 5.0,
                                      bottom: 5.0,
                                    ),
                                    decoration: BoxDecoration(
                                      color: AppColors.app_blue, //1487C9
                                      borderRadius: BorderRadius.circular(15.0),
                                    ),
                                    child: Center(
                                      child: Text(
                                        "Submit",
                                        textAlign: TextAlign.center,
                                        style: TextStyle(
                                          fontSize: 15,
                                          fontFamily: "JakartaMedium",
                                          color: Colors.white,
                                        ),
                                      ),
                                    ),
                                  ),
                                ),
                              ],
                            ),
                          ],
                        ),
                      ),
                    ),
                  );
                },
              ),
            );
          },
        );
      },
    );
  }

  Future<void> _showFeedbackSheet(BuildContext context) {
    return showModalBottomSheet(
      useSafeArea: true,
      isDismissible: true,
      isScrollControlled: true,
      showDragHandle: true,
      backgroundColor: Colors.white,
      enableDrag: true,
      context: context,
      builder: (context) {
        return StatefulBuilder(
          builder: (context, setState) {
            return SafeArea(
              child: Consumer<Pagesdashboardprovider>(
                builder: (context, provider, child) {
                  final orderDetails = provider.orderDetails;
                  return Container(
                    margin: EdgeInsets.only(
                      bottom: 15,
                      left: 15,
                      right: 15,
                      top: 10,
                    ),
                    padding: EdgeInsets.only(
                      bottom: MediaQuery.of(context).viewInsets.bottom,
                    ),
                    child: SingleChildScrollView(
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        mainAxisSize: MainAxisSize.min,
                        children: [
                          Align(
                            alignment: Alignment.topLeft,
                            child: Text(
                              "Feedback Update",
                              style: TextStyle(
                                color: AppColors.app_blue,
                                fontSize: 16,
                              ),
                            ),
                          ),

                          Padding(
                            padding: const EdgeInsets.only(
                              bottom: 5.0,
                              top: 8.0,
                            ),
                            child: Text("Remarks"),
                          ),
                          Container(
                            height: 150,
                            alignment: Alignment.center,
                            decoration: BoxDecoration(
                              color: Color(0xFFE9E9E9),
                              borderRadius: BorderRadius.circular(14),
                            ),
                            child: Padding(
                              padding: const EdgeInsets.fromLTRB(
                                10.0,
                                0.0,
                                10,
                                0,
                              ),
                              child: TextFormField(
                                controller: provider.feedbackController,
                                readOnly: true,
                                keyboardType: TextInputType.text,
                                maxLines: 60,
                                onChanged: provider.onChangeFeedback,
                                style: TextStyle(
                                  color: Color(0xFF818181),
                                  fontSize: 14,
                                ),
                                decoration: InputDecoration(
                                  hintText: "Write Remarks",
                                  hintStyle: TextStyle(
                                    fontWeight: FontWeight.w400,
                                    color: Color(0xFFB4BEC0),
                                    fontSize: 14,
                                  ),

                                  enabledBorder: InputBorder.none,
                                  focusedBorder: InputBorder.none,
                                ),
                              ),
                            ),
                          ),
                          if (provider.feedbackError != null) ...[
                            Container(
                              alignment: Alignment.topLeft,
                              margin: EdgeInsets.only(top: 2.5, left: 25),
                              child: Text(
                                "${provider.feedbackError}",
                                style: TextStyle(
                                  color: Colors.red,
                                  fontSize: 10,
                                ),
                              ),
                            ),
                          ],
                          InkResponse(
                            onTap: () {
                              _showAttachmentSheet(context);
                            },
                            child: Container(
                              margin: EdgeInsets.symmetric(vertical: 10),
                              height: 45,
                              width: MediaQuery.of(context).size.width,
                              decoration: BoxDecoration(
                                color: Color(0xFFE6F6FF),
                                borderRadius: BorderRadius.circular(12),
                                border: Border.all(
                                  color: AppColors.app_blue,
                                  width: 0.5,
                                ),
                              ),
                              child: Center(
                                child: Text(
                                  "Add Attachment",
                                  style: TextStyle(
                                    fontFamily: "JakartaMedium",
                                    color: AppColors.app_blue,
                                  ),
                                ),
                              ),
                            ),
                          ),
                          if (provider.imagePicked == 1 &&
                              provider.imagePath != null) ...[
                            Padding(
                              padding: const EdgeInsets.symmetric(
                                vertical: 4.0,
                              ),
                              child: Row(
                                mainAxisAlignment:
                                    MainAxisAlignment.spaceBetween,
                                children: [
                                  Text(
                                    "${provider.imagePath}",
                                    style: TextStyle(
                                      color: AppColors.semi_black,
                                      fontSize: 11,
                                      fontWeight: FontWeight.w600,
                                    ),
                                  ),
                                  InkResponse(
                                    onTap: () {
                                      provider.imagePicked = 0;
                                      provider.imagePath = null;
                                      provider.imageFilePath = null;
                                    },
                                    child: SvgPicture.asset(
                                      "assets/svg/ic_close.svg",
                                      width: 15,
                                      height: 15,
                                    ),
                                  ),
                                ],
                              ),
                            ),
                          ],
                          InkWell(
                            onTap: () {
                              provider
                                  .ordersDetailsFeedbackSubmissionAPIFunction(
                                    context,
                                    orderDetails.id,
                                    orderDetails.status,
                                  );
                            },
                            child: Container(
                              alignment: Alignment.center,
                              height: 45,

                              decoration: BoxDecoration(
                                color: AppColors.app_blue, //1487C9
                                borderRadius: BorderRadius.circular(14.0),
                              ),
                              child: Center(
                                child: Text(
                                  "Submit",
                                  textAlign: TextAlign.center,
                                  style: TextStyle(color: Colors.white),
                                ),
                              ),
                            ),
                          ),
                        ],
                      ),
                    ),
                  );
                },
              ),
            );
          },
        );
      },
    );
  }

  Future<void> _showAttachmentSheet(BuildContext context) {
    return showModalBottomSheet(
      useSafeArea: true,
      isDismissible: true,
      isScrollControlled: true,
      showDragHandle: true,
      backgroundColor: Colors.white,
      enableDrag: true,
      context: context,
      builder: (context) {
        return StatefulBuilder(
          builder: (context, setState) {
            return SafeArea(
              child: Consumer<Pagesdashboardprovider>(
                builder: (context, provider, child) {
                  return Padding(
                    padding: EdgeInsets.only(
                      bottom:
                          MediaQuery.of(
                            context,
                          ).viewInsets.bottom, // This handles keyboard
                    ),
                    child: Container(
                      margin: EdgeInsets.only(
                        bottom: 15,
                        left: 15,
                        right: 15,
                        top: 10,
                      ),

                      child: SingleChildScrollView(
                        child: Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          mainAxisSize: MainAxisSize.min,
                          children: [
                            Align(
                              alignment: Alignment.center,
                              child: Text(
                                "Select Source",
                                style: TextStyle(
                                  color: AppColors.app_blue,
                                  fontSize: 16,
                                ),
                              ),
                            ),
                            SizedBox(height: 15),
                            InkWell(
                              onTap: () {
                                Navigator.of(context).pop(false);
                                provider.imgFromGallery(context);
                              },
                              child: SizedBox(
                                height: 35,
                                child: Text("Select photo from gallery"),
                              ),
                            ),
                            SizedBox(height: 10),
                            InkWell(
                              onTap: () {
                                Navigator.of(context).pop(false);
                                provider.imgFromCamera(context);
                              },
                              child: SizedBox(
                                height: 35,
                                child: Text("Capture photo from camera"),
                              ),
                            ),
                          ],
                        ),
                      ),
                    ),
                  );
                },
              ),
            );
          },
        );
      },
    );
  }
}
