import 'dart:io';

import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:flutter_svg/svg.dart';
import 'package:provider/provider.dart';

import '../../Notifiers/ordersProvider/tpcAgentsProvider.dart';
import '../../Utils/app_colors.dart';
import '../../Utils/commonWidgets.dart';
import '../../Utils/dropdownTheme.dart';

import 'package:connectivity_plus/connectivity_plus.dart';
import 'package:generp/Utils/commonServices.dart';

class AddtpcagentScreen extends StatefulWidget {
  const AddtpcagentScreen({super.key});

  @override
  State<AddtpcagentScreen> createState() => _AddtpcagentScreenState();
}

class _AddtpcagentScreenState extends State<AddtpcagentScreen> {
  Dropdowntheme ddtheme = Dropdowntheme();
  List<FocusNode> focusNodes = List.generate(10, (index) => FocusNode());
  Map _source = {ConnectivityResult.mobile: true};
  final MyConnectivity _connectivity = MyConnectivity.instance;

  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    _connectivity.initialise();
    _connectivity.myStream.listen((source) {
      setState(() => _source = source);
    });
    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
      var provider = Provider.of<Tpcagentsprovider>(context, listen: false);
    });
  }

  @override
  void dispose() {
    // TODO: implement dispose
    super.dispose();
    _connectivity.disposeStream();
  }

  @override
  Widget build(BuildContext context) {
    switch (_source.keys.toList()[0]) {
      case ConnectivityResult.mobile:
        connection = 'Online';
        break;
      case ConnectivityResult.wifi:
        connection = 'Online';
        break;
      case ConnectivityResult.none:
      default:
        connection = 'Offline';
    }
    return connection == "Online"
        ? Consumer<Tpcagentsprovider>(
          builder: (context, provider, child) {
            return WillPopScope(
              child: SafeArea(
                top: false,
                bottom: Platform.isIOS ? false : true,
                child: Scaffold(
                  resizeToAvoidBottomInset: true,
                  appBar: appbar2New(
                    context,
                    "Add TPC Agent",
                    provider.resetAll,
                    SizedBox(width: 0),
                    0xFFFFFFFF,
                  ),
                  backgroundColor: AppColors.scaffold_bg_color,
                  body: Container(
                    child: SingleChildScrollView(
                      child: Column(
                        children: [
                          Container(
                            decoration: BoxDecoration(
                              color: Colors.white,
                              borderRadius: BorderRadius.circular(16),
                            ),
                            margin: EdgeInsets.symmetric(
                              vertical: 10,
                              horizontal: 10,
                            ),
                            padding: EdgeInsets.symmetric(
                              vertical: 10,
                              horizontal: 10,
                            ),
                            child: Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              mainAxisSize: MainAxisSize.min,
                              children: [
                                textControllerWidget(
                                  context,
                                  provider.tpcNameController,
                                  "Name",
                                  "Enter Name",
                                  provider.onChangetpcName,
                                  TextInputType.text,
                                  false,
                                  null,
                                  focusNodes[0],
                                  focusNodes[1],
                                  TextInputAction.next,
                                ),
                                if (provider.tpcNameError != null) ...[
                                  errorWidget(context, provider.tpcNameError),
                                ],

                                textControllerWidget(
                                  context,
                                  provider.tpcMobileNumberController,
                                  "Mobile Number",
                                  "Enter Mobile Number",
                                  provider.onChangetpcMobileNumber,
                                  TextInputType.number,
                                  false,
                                  FilteringTextInputFormatter.digitsOnly,
                                  focusNodes[1],
                                  focusNodes[2],
                                  TextInputAction.next,
                                  10,
                                ),
                                if (provider.tpcMobileNumberError != null) ...[
                                  errorWidget(
                                    context,
                                    provider.tpcMobileNumberError,
                                  ),
                                ],

                                InkResponse(
                                  onTap: () {
                                    _showAttachmentSheet(context);
                                  },
                                  child: Container(
                                    margin: EdgeInsets.symmetric(vertical: 10),
                                    height: 45,
                                    width: MediaQuery.of(context).size.width,
                                    decoration: BoxDecoration(
                                      color: Color(0xFFE6F6FF),
                                      borderRadius: BorderRadius.circular(12),
                                      border: Border.all(
                                        color: AppColors.app_blue,
                                        width: 0.5,
                                      ),
                                    ),
                                    child: Center(
                                      child: Text(
                                        "ID Proof",
                                        style: TextStyle(
                                          fontFamily: "JakartaMedium",
                                          color: AppColors.app_blue,
                                        ),
                                      ),
                                    ),
                                  ),
                                ),
                                if (provider.imagePicked == 1 &&
                                    provider.imagePath != null) ...[
                                  Padding(
                                    padding: const EdgeInsets.symmetric(
                                      vertical: 4.0,
                                    ),
                                    child: Row(
                                      mainAxisAlignment:
                                          MainAxisAlignment.spaceBetween,
                                      children: [
                                        Text(
                                          "${provider.imagePath}",
                                          style: TextStyle(
                                            color: AppColors.semi_black,
                                            fontSize: 11,
                                            fontWeight: FontWeight.w600,
                                          ),
                                        ),
                                        InkResponse(
                                          onTap: () {
                                            provider.imagePicked = 0;
                                            provider.imagePath = null;
                                            provider.imageFilePath = null;
                                          },
                                          child: SvgPicture.asset(
                                            "assets/svg/ic_close.svg",
                                            width: 15,
                                            height: 15,
                                          ),
                                        ),
                                      ],
                                    ),
                                  ),
                                ],
                                errorWidget(context, provider.imageError),

                                textControllerWidget(
                                  context,
                                  provider.tpcBankNameController,
                                  "Bank Name",
                                  "Enter Bank Name",
                                  provider.onChangetpcBankName,
                                  TextInputType.text,
                                  false,
                                  null,
                                  focusNodes[2],
                                  focusNodes[3],
                                  TextInputAction.next,
                                ),
                                if (provider.tpcBankNameError != null) ...[
                                  errorWidget(
                                    context,
                                    provider.tpcBankNameError,
                                  ),
                                ],

                                textControllerWidget(
                                  context,
                                  provider.tpcBankBeneficiaryNameController,
                                  "Bank Beneficiary Name",
                                  "Enter Bank Beneficiary Name",
                                  provider.onChangetpcBankBeneficiaryName,
                                  TextInputType.text,
                                  false,
                                  null,
                                  focusNodes[3],
                                  focusNodes[4],
                                  TextInputAction.next,
                                ),
                                if (provider.tpcBankBeneficiaryNameError !=
                                    null) ...[
                                  errorWidget(
                                    context,
                                    provider.tpcBankBeneficiaryNameError,
                                  ),
                                ],

                                textControllerWidget(
                                  context,
                                  provider.tpcBankAccountNumberController,
                                  "Bank Account Number",
                                  "Enter Bank Account Number",
                                  provider.onChangetpcBankAccountNumber,
                                  TextInputType.number,
                                  false,
                                  FilteringTextInputFormatter.digitsOnly,
                                  focusNodes[4],
                                  focusNodes[5],
                                  TextInputAction.next,
                                ),
                                if (provider.tpcBankAccountNumberError !=
                                    null) ...[
                                  errorWidget(
                                    context,
                                    provider.tpcBankAccountNumberError,
                                  ),
                                ],

                                textControllerWidget(
                                  context,
                                  provider.tpcBankIFSCController,
                                  "Bank IFSC",
                                  "Enter Bank IFSC",
                                  provider.onChangetpcBankIFSC,
                                  TextInputType.text,
                                  false,
                                  null,
                                  focusNodes[5],
                                  focusNodes[6],
                                  TextInputAction.next,
                                ),
                                if (provider.tpcBankIFSCError != null) ...[
                                  errorWidget(
                                    context,
                                    provider.tpcBankIFSCError,
                                  ),
                                ],

                                textControllerWidget(
                                  context,
                                  provider.tpcNoteController,
                                  "Description",
                                  "Enter Description",
                                  provider.onChangetpcNote,
                                  TextInputType.text,
                                  false,
                                  null,
                                  focusNodes[6],
                                  focusNodes[7],
                                  TextInputAction.next,
                                ),
                                if (provider.tpcNoteError != null) ...[
                                  errorWidget(context, provider.tpcNoteError),
                                ],
                                InkWell(
                                  onTap:
                                      provider.submitClicked
                                          ? null
                                          : () {
                                            provider.submitClicked = true;
                                            provider.addTPCAgentAPIFunction(
                                              context,
                                            );
                                          },

                                  child: Container(
                                    alignment: Alignment.center,
                                    height: 45,
                                    margin: EdgeInsets.only(
                                      left: 5.0,
                                      right: 5.0,
                                      top: 5.0,
                                      bottom: 5.0,
                                    ),
                                    decoration: BoxDecoration(
                                      color: AppColors.app_blue, //1487C9
                                      borderRadius: BorderRadius.circular(14.0),
                                    ),
                                    child: Center(
                                      child:
                                          provider.submitClicked
                                              ? CircularProgressIndicator.adaptive(
                                                valueColor:
                                                    AlwaysStoppedAnimation(
                                                      Colors.white,
                                                    ),
                                              )
                                              : Text(
                                                "Submit",
                                                textAlign: TextAlign.center,
                                                style: TextStyle(
                                                  color: Colors.white,
                                                ),
                                              ),
                                    ),
                                  ),
                                ),
                              ],
                            ),
                          ),
                        ],
                      ),
                    ),
                  ),
                ),
              ),

              onWillPop: () {
                return onBackPressed(context);
              },
            );
          },
        )
        : NoNetwork(context);
  }

  Future<void> _showAttachmentSheet(BuildContext context) {
    return showModalBottomSheet(
      useSafeArea: true,
      isDismissible: true,
      isScrollControlled: true,
      showDragHandle: true,
      backgroundColor: Colors.white,
      enableDrag: true,
      context: context,
      builder: (context) {
        return StatefulBuilder(
          builder: (context, setState) {
            return SafeArea(
              child: Consumer<Tpcagentsprovider>(
                builder: (context, tcpProvider, child) {
                  return Padding(
                    padding: EdgeInsets.only(
                      bottom:
                          MediaQuery.of(
                            context,
                          ).viewInsets.bottom, // This handles keyboard
                    ),
                    child: Container(
                      margin: EdgeInsets.only(
                        bottom: 15,
                        left: 15,
                        right: 15,
                        top: 10,
                      ),

                      child: SingleChildScrollView(
                        child: Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          mainAxisSize: MainAxisSize.min,
                          children: [
                            Align(
                              alignment: Alignment.center,
                              child: Text(
                                "Select Source",
                                style: TextStyle(
                                  color: AppColors.app_blue,
                                  fontSize: 16,
                                ),
                              ),
                            ),
                            SizedBox(height: 15),
                            InkWell(
                              onTap: () {
                                Navigator.of(context).pop(false);
                                tcpProvider.imgFromGallery(context);
                              },
                              child: SizedBox(
                                height: 35,
                                child: Text("Select photo from gallery"),
                              ),
                            ),
                            SizedBox(height: 10),
                            InkWell(
                              onTap: () {
                                Navigator.of(context).pop(false);
                                tcpProvider.imgFromCamera(context);
                              },
                              child: SizedBox(
                                height: 35,
                                child: Text("Capture photo from camera"),
                              ),
                            ),
                          ],
                        ),
                      ),
                    ),
                  );
                },
              ),
            );
          },
        );
      },
    );
  }
}
