import 'dart:io';

import 'package:connectivity_plus/connectivity_plus.dart';
import 'package:flutter/material.dart';
import 'package:generp/Notifiers/crmProvider/crmProspectDetailsProvider.dart';
import 'package:generp/Utils/commonServices.dart';
import 'package:generp/screens/crm/LeadDetailsByMode.dart';
import 'package:provider/provider.dart';

import '../../Utils/app_colors.dart';
import '../../Utils/commonWidgets.dart';
import 'addProspectLeads.dart';

class ProspectLeadDetails extends StatefulWidget {
  final leadID;
  final mode;

  const ProspectLeadDetails({
    super.key,
    required this.leadID,
    required this.mode,
  });

  @override
  State<ProspectLeadDetails> createState() => _ProspectLeadDetailsState();
}

class _ProspectLeadDetailsState extends State<ProspectLeadDetails> {
  Map _source = {ConnectivityResult.mobile: true};
  final MyConnectivity _connectivity = MyConnectivity.instance;

  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    _connectivity.initialise();
    _connectivity.myStream.listen((source) {
      setState(() => _source = source);
    });
    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
      final provider = Provider.of<crmProspectDetailsProvider>(
        context,
        listen: false,
      );
    });
  }

  @override
  void dispose() {
    // TODO: implement dispose
    super.dispose();
    _connectivity.disposeStream();
  }

  @override
  Widget build(BuildContext context) {
    switch (_source.keys.toList()[0]) {
      case ConnectivityResult.mobile:
        connection = 'Online';
        break;
      case ConnectivityResult.wifi:
        connection = 'Online';
        break;
      case ConnectivityResult.none:
      default:
        connection = 'Offline';
    }
    return (connection == "Online")
        ? Platform.isAndroid
            ? WillPopScope(
              onWillPop: () => onBackPressed(context),
              child: SafeArea(
                top: false,
                bottom: true,
                child: _scaffold(context),
              ),
            )
            : _scaffold(context)
        : NoNetwork(context);
  }

  Widget _scaffold(BuildContext context) {
    return Consumer<crmProspectDetailsProvider>(
      builder: (context, provider, child) {
        var customerDetails = provider.leadList;
        return Scaffold(
          resizeToAvoidBottomInset: true,
          appBar: appbar(context, "Lead Details"),
          backgroundColor: AppColors.scaffold_bg_color,
          body: SizedBox(
            child: SingleChildScrollView(
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  ListView.builder(
                    itemCount: customerDetails.length,
                    shrinkWrap: true,
                    itemBuilder: (context, index) {
                      return Container(
                        margin: EdgeInsets.symmetric(
                          horizontal: 10,
                          vertical: 5,
                        ),
                        padding: EdgeInsets.symmetric(
                          horizontal: 15,
                          vertical: 10,
                        ),
                        decoration: BoxDecoration(
                          color: Colors.white,
                          borderRadius: BorderRadius.circular(20),
                        ),
                        child: Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: List.generate(5, (j) {
                            final textheads = [
                              "Lead Id",
                              "Date Created",
                              "Lead Status",
                              "Lead Open / Close",
                              "View Details",
                            ];
                            final textSubheads = [
                              customerDetails[index].id ?? "-",
                              customerDetails[index].date ?? "-",
                              customerDetails[index].status ?? "-",
                              customerDetails[index].openStatus ?? "-",
                              "View",
                            ];
                            return Container(
                              padding: EdgeInsets.symmetric(
                                vertical: 6,
                                horizontal: 0,
                              ),
                              child: Row(
                                crossAxisAlignment: CrossAxisAlignment.start,
                                children: [
                                  Expanded(
                                    flex: 2,
                                    child: Text(
                                      textheads[j].toString(),
                                      maxLines: 2,
                                      overflow: TextOverflow.ellipsis,
                                    ),
                                  ),
                                  if (textSubheads[j] == "View") ...[
                                    Expanded(
                                      flex: 3,
                                      child: InkResponse(
                                        onTap: () async {
                                          var res = await Navigator.push(
                                            context,
                                            MaterialPageRoute(
                                              builder:
                                                  (context) =>
                                                      LeadDetailsByMode(
                                                        mode: "",
                                                        pageTitleName:
                                                            "Lead Details",
                                                        leadId: widget.leadID,
                                                      ),
                                            ),
                                          );
                                          if (res == true) {
                                            provider
                                                .crmProspectDetailsAPIFunction(
                                                  context,
                                                  widget.leadID,
                                                );
                                          }
                                        },
                                        child: Text(
                                          textSubheads[j] == ""
                                              ? "-"
                                              : textSubheads[j],
                                          maxLines: 2,
                                          overflow: TextOverflow.ellipsis,
                                          style: TextStyle(
                                            color: AppColors.app_blue,
                                            decorationColor: AppColors.app_blue,
                                            decoration:
                                                TextDecoration.underline,
                                          ),
                                        ),
                                      ),
                                    ),
                                  ] else ...[
                                    Expanded(
                                      flex: 3,
                                      child: Text(
                                        textSubheads[j] == ""
                                            ? "-"
                                            : textSubheads[j],
                                        maxLines: 2,
                                        overflow: TextOverflow.ellipsis,
                                        style: TextStyle(
                                          color: Color(0xFF818181),
                                        ),
                                      ),
                                    ),
                                  ],
                                ],
                              ),
                            );
                          }),
                        ),
                      );
                    },
                  ),

                  SizedBox(height: 75),
                ],
              ),
            ),
          ),
          floatingActionButton: Align(
            alignment: Alignment.bottomCenter,
            child: InkWell(
              onTap: () async {
                var res = await Navigator.push(
                  context,
                  MaterialPageRoute(
                    builder:
                        (context) => AddProspectLeads(
                          leadID: widget.leadID,
                          mode: widget.mode,
                        ),
                  ),
                );
                if (res == true) {
                  provider.crmProspectDetailsAPIFunction(
                    context,
                    widget.leadID,
                  );
                }
              },
              child: Container(
                alignment: Alignment.bottomCenter,
                height: 45,
                width: MediaQuery.of(context).size.width,
                margin: EdgeInsets.symmetric(horizontal: 10),
                decoration: BoxDecoration(
                  color: AppColors.app_blue,
                  borderRadius: BorderRadius.circular(14.0),
                ),
                child: Center(
                  child: Text(
                    "Add Lead",
                    textAlign: TextAlign.center,
                    style: TextStyle(
                      color: Colors.white,
                      fontFamily: "JakartaMedium",
                    ),
                  ),
                ),
              ),
            ),
          ),
          floatingActionButtonLocation:
              FloatingActionButtonLocation.centerFloat,
        );
      },
    );
  }
}
