import 'dart:io';

import 'package:connectivity_plus/connectivity_plus.dart';
import 'package:dotted_line/dotted_line.dart';
import 'package:dropdown_button2/dropdown_button2.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:flutter_svg/svg.dart';
import 'package:generp/Notifiers/crmProvider/crmLeadDetailsProvider.dart';
import 'package:generp/Notifiers/crmProvider/editProductListProvider.dart';
import 'package:generp/Utils/commonServices.dart';
import 'package:generp/Utils/dropdownTheme.dart';
import 'package:generp/screens/crm/AppointmentDetails.dart';
import 'package:generp/screens/crm/FollowUpDetails.dart';
import 'package:generp/screens/crm/QuotationDetails.dart';
import 'package:generp/screens/crm/contactDetails.dart';
import 'package:generp/screens/crm/editAccountDetails.dart';
import 'package:generp/screens/crm/followUpUpdateScreen.dart';
import 'package:generp/screens/crm/productDetails.dart';
import 'package:provider/provider.dart';
import 'package:url_launcher/url_launcher.dart';

import '../../Models/crmModels/crmLeadDetailsEditProductsViewResponse.dart';
import '../../Utils/app_colors.dart';
import '../../Utils/commonWidgets.dart';
import '../finance/FileViewer.dart';
import 'editProductsList.dart';
import 'generateQuotationScreen.dart';

class LeadDetailsByMode extends StatefulWidget {
  final mode;
  final pageTitleName;
  final leadId;

  const LeadDetailsByMode({
    super.key,
    required this.mode,
    required this.pageTitleName,
    required this.leadId,
  });

  @override
  State<LeadDetailsByMode> createState() => _LeadDetailsByModeState();
}

class _LeadDetailsByModeState extends State<LeadDetailsByMode> {
  Map _source = {ConnectivityResult.mobile: true};
  final MyConnectivity _connectivity = MyConnectivity.instance;
  Dropdowntheme ddtheme = Dropdowntheme();

  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    _connectivity.initialise();
    _connectivity.myStream.listen((source) {
      setState(() => _source = source);
    });
    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
      final provider = Provider.of<crmLeadDetailsProvider>(
        context,
        listen: false,
      );
      provider.showMoreDetails = false;
      provider.crmLeadDetailsAPIFunction(context, widget.leadId, widget.mode);
    });
  }

  @override
  void dispose() {
    // TODO: implement dispose
    super.dispose();
    _connectivity.disposeStream();
  }

  @override
  Widget build(BuildContext context) {
    switch (_source.keys.toList()[0]) {
      case ConnectivityResult.mobile:
        connection = 'Online';
        break;
      case ConnectivityResult.wifi:
        connection = 'Online';
        break;
      case ConnectivityResult.none:
      default:
        connection = 'Offline';
    }
    return (connection == "Online")
        ? Platform.isAndroid
            ? WillPopScope(
              onWillPop: () async {
                Provider.of<Editproductlistprovider>(
                  context,
                  listen: false,
                ).resetForm();
                Provider.of<crmLeadDetailsProvider>(
                  context,
                  listen: false,
                ).resetAll();

                return onBackPressed(context);
              },
              child: SafeArea(
                top: false,
                bottom: true,
                child: _scaffold(context),
              ),
            )
            : _scaffold(context)
        : NoNetwork(context);
  }

  Widget _scaffold(BuildContext context) {
    return Consumer2<crmLeadDetailsProvider, Editproductlistprovider>(
      builder: (context, provider, editProvider, child) {
        var leadDetails = provider.leadDetails;
        var accDetails = provider.accountDetails;

        var headings1 = ["Account Manager Name", "Account Created By"];
        var subHeadings1 = [
          accDetails.accManager ?? "-",
          accDetails.owner ?? "-",
        ];

        var headings2 = ["Address", "State", "District", "Sub Locality"];
        var subHeadings2 = [
          leadDetails.address ?? "-",
          accDetails.state ?? "-",
          accDetails.district ?? "-",
          accDetails.subLocality ?? "-",
        ];
        var headings3 = ["Source", "Reference", "Team", "Segment"];
        var subHeadings3 = [
          accDetails.source ?? "-",
          accDetails.reference ?? "-",
          accDetails.team ?? "-",
          accDetails.segment ?? "-",
        ];
        var headings4 = ["Lead Status", "Last Followup Date", "Lead Age"];
        var subHeadings4 = [
          leadDetails.status ?? "-",
          leadDetails.date ?? "-",
          "${leadDetails.lage ?? "-"} days",
        ];
        // var totalHeadings = [];
        // var totalSubHeadings = [];
        //
        // if (provider.showMoreDetails) {
        //   totalHeadings = [...headings2];
        //   totalSubHeadings = [...subHeadings2];
        // }

        var productsNotEmpty = provider.leadProducts.isNotEmpty;
        var contactsNotEmpty = provider.contactDetails.isNotEmpty;
        var followupNotEmpty = provider.followupDetails.isNotEmpty;
        var appointmentNotEmpty = provider.appointmentDetails.isNotEmpty;
        var quotationNotEmpty = provider.quotationsDetails.isNotEmpty;

        return Scaffold(
          resizeToAvoidBottomInset: true,

          appBar: AppBar(
            // toolbarHeight: provider.showMoreDetails ? 25 : 40,
            backgroundColor: Colors.white,
            automaticallyImplyLeading: false,
            centerTitle: false,

            // elevation: 2.0,
            title: SizedBox(
              child: Row(
                mainAxisAlignment: MainAxisAlignment.start,
                crossAxisAlignment: CrossAxisAlignment.center,
                children: [
                  InkResponse(
                    onTap: () {
                      HapticFeedback.selectionClick();
                      provider.resetAll();
                      editProvider.resetForm();
                      Navigator.pop(context, true);
                    },
                    child: SvgPicture.asset(
                      "assets/svg/appbar_back_button.svg",
                      height: 25,
                    ),
                  ),
                  SizedBox(width: 10),
                  Expanded(
                    flex: 4,
                    child: InkResponse(
                      onTap: () {
                        HapticFeedback.selectionClick();
                        provider.resetAll();
                        editProvider.resetForm();
                        Navigator.pop(context, true);
                      },
                      child: Text(
                        "Lead Details",
                        overflow: TextOverflow.ellipsis,
                        maxLines: 1,
                        style: TextStyle(
                          fontSize: 16,
                          height: 1.1,
                          fontFamily: "JakartaSemiBold",
                          color: AppColors.semi_black,
                        ),
                      ),
                    ),
                  ),
                ],
              ),
            ),
          ),
          backgroundColor: AppColors.scaffold_bg_color,
          body:
              provider.leadDetailsLoading
                  ? Center(
                    child: CircularProgressIndicator.adaptive(
                      valueColor: AlwaysStoppedAnimation<Color>(
                        AppColors.app_blue,
                      ),
                    ),
                  )
                  : SingleChildScrollView(
                    child: Column(
                      children: [
                        Card(
                          shape: RoundedRectangleBorder(
                            borderRadius: BorderRadius.only(
                              bottomLeft: Radius.circular(30),
                              bottomRight: Radius.circular(30),
                            ),
                          ),
                          elevation: 2,

                          child: Column(
                            children: [
                              Container(
                                decoration: BoxDecoration(
                                  color: Colors.white,
                                  borderRadius: BorderRadius.vertical(
                                    bottom: Radius.circular(30),
                                  ),
                                ),
                                // margin: EdgeInsets.symmetric(vertical: 10, horizontal: 10),
                                padding: EdgeInsets.symmetric(
                                  vertical: 10,
                                  horizontal: 10,
                                ),
                                child: Column(
                                  children: [
                                    Row(
                                      children: [
                                        Expanded(
                                          flex: 1,
                                          child: SizedBox(
                                            height: 50,
                                            width: 35,
                                            child: SvgPicture.asset(
                                              "assets/svg/crm/lead_details_ic.svg",
                                            ),
                                          ),
                                        ),
                                        SizedBox(width: 10),
                                        Expanded(
                                          flex: 5,
                                          child: SizedBox(
                                            child: Column(
                                              crossAxisAlignment:
                                                  CrossAxisAlignment.start,
                                              children: [
                                                Text(
                                                  leadDetails.name ?? "-",
                                                  style: TextStyle(
                                                    fontFamily: "JakartaMedium",
                                                    fontSize: 14,
                                                    color: AppColors.semi_black,
                                                  ),
                                                ),
                                              ],
                                            ),
                                          ),
                                        ),
                                        SizedBox(width: 10),
                                        if (provider.showEditButton == "1") ...[
                                          Expanded(
                                            flex: 1,
                                            child: InkResponse(
                                              onTap: () async {
                                                HapticFeedback.selectionClick();
                                                var res = await Navigator.push(
                                                  context,
                                                  MaterialPageRoute(
                                                    builder:
                                                        (
                                                          context,
                                                        ) => EditAccountDetails(
                                                          leadID:
                                                              leadDetails.id,
                                                          mode: widget.mode,
                                                          accountID:
                                                              leadDetails.accId,
                                                          companyName:
                                                              leadDetails.name,
                                                        ),
                                                  ),
                                                );
                                                if (res == true) {
                                                  provider
                                                      .crmLeadDetailsAPIFunction(
                                                        context,
                                                        widget.leadId,
                                                        widget.mode,
                                                      );
                                                }
                                              },
                                              child: Container(
                                                height: 32,
                                                width: 30,
                                                padding: EdgeInsets.all(8.0),
                                                child: SvgPicture.asset(
                                                  "assets/svg/crm/lead_details_edit_ic.svg",
                                                ),
                                              ),
                                            ),
                                          ),
                                        ],
                                        Expanded(
                                          flex: 1,
                                          child: InkResponse(
                                            onTap: () async {
                                              HapticFeedback.mediumImpact();
                                              provider.copyToClipboard(context);
                                            },
                                            child: Container(
                                              height: 32,
                                              width: 30,
                                              padding: EdgeInsets.all(8.0),
                                              child: SvgPicture.asset(
                                                "assets/svg/crm/lead_details_copy_ic.svg",
                                              ),
                                            ),
                                          ),
                                        ),
                                      ],
                                    ),
                                    Visibility(
                                      visible:
                                          provider.showMoreDetails
                                              ? true
                                              : false,
                                      child: Column(
                                        children: [
                                          Container(
                                            padding: EdgeInsets.symmetric(
                                              vertical: 4,
                                            ),
                                            child: Row(
                                              children: [
                                                Expanded(
                                                  flex: 3,
                                                  child: Text(
                                                    "Account Details",
                                                    style: TextStyle(
                                                      fontSize: 14,
                                                      fontFamily:
                                                          "JakartaSemiBold",
                                                    ),
                                                  ),
                                                ),
                                                Expanded(
                                                  flex: 6,
                                                  child: DottedLine(
                                                    dashGapLength: 4,
                                                    dashGapColor: Colors.white,
                                                    dashColor:
                                                        AppColors.grey_semi,
                                                    dashLength: 2,
                                                    lineThickness: 0.5,
                                                  ),
                                                ),
                                              ],
                                            ),
                                          ),
                                          ...List.generate(
                                            subHeadings1.length,
                                            (j) {
                                              return Container(
                                                padding: EdgeInsets.symmetric(
                                                  vertical: 7,
                                                ),
                                                child: Row(
                                                  crossAxisAlignment:
                                                      CrossAxisAlignment.start,
                                                  children: [
                                                    Expanded(
                                                      child: Text(
                                                        headings1[j],
                                                        style: TextStyle(
                                                          fontFamily:
                                                              "JakartaRegular",
                                                          fontSize: 14,
                                                          color:
                                                              AppColors
                                                                  .semi_black,
                                                        ),
                                                      ),
                                                    ),
                                                    Expanded(
                                                      child: Text(
                                                        subHeadings1[j] == ""
                                                            ? "-"
                                                            : subHeadings1[j],
                                                        style: TextStyle(
                                                          fontSize: 14,
                                                          color: Color(
                                                            0xFF818181,
                                                          ),
                                                        ),
                                                      ),
                                                    ),
                                                  ],
                                                ),
                                              );
                                            },
                                          ),
                                          Container(
                                            padding: EdgeInsets.symmetric(
                                              vertical: 4,
                                            ),
                                            child: Row(
                                              children: [
                                                Expanded(
                                                  flex: 3,
                                                  child: Text(
                                                    "Address Details",
                                                    style: TextStyle(
                                                      fontSize: 14,
                                                      fontFamily:
                                                          "JakartaSemiBold",
                                                    ),
                                                  ),
                                                ),
                                                Expanded(
                                                  flex: 6,
                                                  child: DottedLine(
                                                    dashGapLength: 4,
                                                    dashGapColor: Colors.white,
                                                    dashColor:
                                                        AppColors.grey_semi,
                                                    dashLength: 2,
                                                    lineThickness: 0.5,
                                                  ),
                                                ),
                                              ],
                                            ),
                                          ),
                                          ...List.generate(
                                            subHeadings2.length,
                                            (j) {
                                              return Container(
                                                padding: EdgeInsets.symmetric(
                                                  vertical: 7,
                                                ),
                                                child: Row(
                                                  crossAxisAlignment:
                                                      CrossAxisAlignment.start,
                                                  children: [
                                                    Expanded(
                                                      child: Text(
                                                        headings2[j],
                                                        style: TextStyle(
                                                          fontFamily:
                                                              "JakartaRegular",
                                                          fontSize: 14,
                                                          color:
                                                              AppColors
                                                                  .semi_black,
                                                        ),
                                                      ),
                                                    ),
                                                    Expanded(
                                                      child: Text(
                                                        subHeadings2[j] == ""
                                                            ? "-"
                                                            : subHeadings2[j],
                                                        style: TextStyle(
                                                          fontSize: 14,
                                                          color: Color(
                                                            0xFF818181,
                                                          ),
                                                        ),
                                                      ),
                                                    ),
                                                  ],
                                                ),
                                              );
                                            },
                                          ),
                                          Container(
                                            padding: EdgeInsets.symmetric(
                                              vertical: 4,
                                            ),
                                            child: Row(
                                              children: [
                                                Expanded(
                                                  flex: 3,
                                                  child: Text(
                                                    "Source Details",
                                                    style: TextStyle(
                                                      fontSize: 14,
                                                      fontFamily:
                                                          "JakartaSemiBold",
                                                    ),
                                                  ),
                                                ),
                                                Expanded(
                                                  flex: 6,
                                                  child: DottedLine(
                                                    dashGapLength: 4,
                                                    dashGapColor: Colors.white,
                                                    dashColor:
                                                        AppColors.grey_semi,
                                                    dashLength: 2,
                                                    lineThickness: 0.5,
                                                  ),
                                                ),
                                              ],
                                            ),
                                          ),
                                          ...List.generate(
                                            subHeadings3.length,
                                            (j) {
                                              return Container(
                                                padding: EdgeInsets.symmetric(
                                                  vertical: 7,
                                                ),
                                                child: Row(
                                                  crossAxisAlignment:
                                                      CrossAxisAlignment.start,
                                                  children: [
                                                    Expanded(
                                                      child: Text(
                                                        headings3[j],
                                                        style: TextStyle(
                                                          fontFamily:
                                                              "JakartaRegular",
                                                          fontSize: 14,
                                                          color:
                                                              AppColors
                                                                  .semi_black,
                                                        ),
                                                      ),
                                                    ),
                                                    Expanded(
                                                      child: Text(
                                                        subHeadings3[j] == ""
                                                            ? "-"
                                                            : subHeadings3[j],
                                                        style: TextStyle(
                                                          fontSize: 14,
                                                          color: Color(
                                                            0xFF818181,
                                                          ),
                                                        ),
                                                      ),
                                                    ),
                                                  ],
                                                ),
                                              );
                                            },
                                          ),
                                          Container(
                                            padding: EdgeInsets.symmetric(
                                              vertical: 4,
                                            ),
                                            child: Row(
                                              children: [
                                                Expanded(
                                                  flex: 3,
                                                  child: Text(
                                                    "Lead Details",
                                                    style: TextStyle(
                                                      fontSize: 14,
                                                      fontFamily:
                                                          "JakartaSemiBold",
                                                    ),
                                                  ),
                                                ),
                                                Expanded(
                                                  flex: 6,
                                                  child: DottedLine(
                                                    dashGapLength: 4,
                                                    dashGapColor: Colors.white,
                                                    dashColor:
                                                        AppColors.grey_semi,
                                                    dashLength: 2,
                                                    lineThickness: 0.5,
                                                  ),
                                                ),
                                              ],
                                            ),
                                          ),
                                          ...List.generate(subHeadings4.length, (
                                            j,
                                          ) {
                                            return Container(
                                              padding: EdgeInsets.symmetric(
                                                vertical: 7,
                                              ),
                                              child: Row(
                                                crossAxisAlignment:
                                                    CrossAxisAlignment.start,
                                                children: [
                                                  Expanded(
                                                    child: Text(
                                                      headings4[j],
                                                      style: TextStyle(
                                                        fontFamily:
                                                            "JakartaRegular",
                                                        fontSize: 14,
                                                        color:
                                                            AppColors
                                                                .semi_black,
                                                      ),
                                                    ),
                                                  ),
                                                  Expanded(
                                                    child: InkResponse(
                                                      child:
                                                          subHeadings4[j] ==
                                                                  "Lead Age"
                                                              ? Tooltip(
                                                                triggerMode:
                                                                    TooltipTriggerMode
                                                                        .tap,

                                                                message:
                                                                    "${provider.leadDetails.createdDatetime}",
                                                                child: Text(
                                                                  subHeadings4[j] ==
                                                                          ""
                                                                      ? "-"
                                                                      : subHeadings4[j],
                                                                  style: TextStyle(
                                                                    fontSize:
                                                                        14,
                                                                    color: Color(
                                                                      0xFF818181,
                                                                    ),
                                                                    decorationColor:
                                                                        AppColors
                                                                            .grey_semi,
                                                                    decoration:
                                                                        TextDecoration
                                                                            .underline,
                                                                  ),
                                                                ),
                                                              )
                                                              : Text(
                                                                subHeadings4[j] ==
                                                                        ""
                                                                    ? "-"
                                                                    : subHeadings4[j],
                                                                style: TextStyle(
                                                                  fontSize: 14,
                                                                  color: Color(
                                                                    0xFF818181,
                                                                  ),
                                                                ),
                                                              ),
                                                    ),
                                                  ),
                                                ],
                                              ),
                                            );
                                          }),
                                        ],
                                      ),
                                    ),

                                    InkResponse(
                                      onTap: () async {
                                        HapticFeedback.selectionClick();
                                        provider.showMoreDetails =
                                            !provider.showMoreDetails;
                                      },
                                      child: Container(
                                        padding: EdgeInsets.symmetric(
                                          vertical: 5,
                                        ),
                                        child: Row(
                                          crossAxisAlignment:
                                              CrossAxisAlignment.center,
                                          mainAxisAlignment:
                                              MainAxisAlignment.center,
                                          children: [
                                            Text(
                                              provider.showMoreDetails
                                                  ? "Hide Details"
                                                  : "View Details",
                                              style: TextStyle(
                                                fontFamily: "JakartaMedium",
                                                fontSize: 14,
                                                color: AppColors.app_blue,
                                              ),
                                            ),
                                            Transform.flip(
                                              flipY:
                                                  provider.showMoreDetails
                                                      ? true
                                                      : false,
                                              child: SvgPicture.asset(
                                                "assets/svg/arrow_dropdown.svg",
                                                height: 25,
                                                width: 20,
                                                color: AppColors.app_blue,
                                              ),
                                            ),
                                          ],
                                        ),
                                      ),
                                    ),
                                  ],
                                ),
                              ),
                            ],
                          ),
                        ),
                        Column(
                          children: [
                            ///product details
                            Container(
                              padding: EdgeInsets.only(
                                left: 10,
                                right: 10,
                                top: 10,
                              ),
                              child: Row(
                                children: [
                                  Expanded(
                                    child: Text(
                                      textAlign: TextAlign.left,
                                      "Product Details",
                                      style: TextStyle(
                                        fontFamily: "JakartaMedium",
                                        fontSize: 14,
                                        color: AppColors.grey_thick,
                                      ),
                                    ),
                                  ),
                                  if (productsNotEmpty) ...[
                                    Expanded(
                                      child: InkResponse(
                                        onTap:
                                            editProvider
                                                    .editProductDetailsClicked
                                                ? null
                                                : () async {
                                                  HapticFeedback.selectionClick();
                                                  editProvider
                                                          .editProductDetailsClicked =
                                                      true;
                                                  editProvider.resetForm();
                                                  await editProvider
                                                      .crmLeadDetailsEditProductsViewAPIFunction(
                                                        context,
                                                        provider
                                                            .leadDetails
                                                            .id!,
                                                      );
                                                  _showAddEditProductsSheet(
                                                    context,
                                                    widget.mode,
                                                    "add",
                                                    "",
                                                  );
                                                },
                                        child: Padding(
                                          padding: const EdgeInsets.all(8.0),
                                          child: Text(
                                            textAlign: TextAlign.right,
                                            "+ Add Product",
                                            style: TextStyle(
                                              fontFamily: "JakartaMedium",
                                              fontSize: 14,
                                              color: AppColors.app_blue,
                                            ),
                                          ),
                                        ),
                                      ),
                                    ),
                                  ],
                                ],
                              ),
                            ),
                            if (productsNotEmpty) ...[
                              SizedBox(
                                width: double.infinity,
                                height: 150,
                                child: ListView.builder(
                                  physics: AlwaysScrollableScrollPhysics(),
                                  shrinkWrap: true,
                                  scrollDirection: Axis.horizontal,
                                  padding: EdgeInsets.symmetric(
                                    vertical: 10,
                                    horizontal: 10,
                                  ),
                                  itemCount: provider.leadProducts.length,
                                  itemBuilder: (context, lp) {
                                    return InkResponse(
                                      onTap:
                                          editProvider.editProductDetailsClicked
                                              ? null
                                              : () async {
                                                // var res = await Navigator.push(
                                                //   context,
                                                //   MaterialPageRoute(
                                                //     builder:
                                                //         (context) => EditProductsList(
                                                //           leadID: provider.leadDetails.id ?? "",
                                                //         ),
                                                //   ),
                                                // );
                                                editProvider
                                                        .editProductDetailsClicked =
                                                    true;
                                                await editProvider
                                                    .crmLeadDetailsEditProductsViewAPIFunction(
                                                      context,
                                                      provider.leadDetails.id!,
                                                    );
                                                editProvider
                                                    .addEditProductPriceController
                                                    .text = provider
                                                        .leadProducts[lp]
                                                        .price!;
                                                editProvider
                                                    .addEditQuantityController
                                                    .text = provider
                                                        .leadProducts[lp]
                                                        .qty!;
                                                editProvider
                                                    .addEditTotalAmountController
                                                    .text = provider
                                                        .leadProducts[lp]
                                                        .prodTotalPrice!;
                                                editProvider.selectedProducts =
                                                    editProvider.productsList
                                                        .firstWhere(
                                                          (product) =>
                                                              product.id ==
                                                              provider
                                                                  .leadProducts[lp]
                                                                  .productId,
                                                        );
                                                editProvider
                                                        .selectedAddEditProductId =
                                                    provider
                                                        .leadProducts[lp]
                                                        .productId!;
                                                editProvider
                                                        .selectedAddEditProductName =
                                                    provider
                                                        .leadProducts[lp]
                                                        .productName!;
                                                _showAddEditProductsSheet(
                                                  context,
                                                  widget.mode,
                                                  "edit",
                                                  provider.leadProducts[lp].id,
                                                );
                                              },
                                      child: Container(
                                        height: 140,
                                        width:
                                            MediaQuery.of(context).size.width *
                                            0.9,
                                        decoration: BoxDecoration(
                                          color: Colors.white,
                                          borderRadius: BorderRadius.circular(
                                            14,
                                          ),
                                        ),
                                        padding: EdgeInsets.symmetric(
                                          horizontal: 10,
                                          vertical: 8,
                                        ),

                                        margin: EdgeInsets.symmetric(
                                          horizontal: 5,
                                          // vertical: 10,
                                        ),

                                        child: Row(
                                          mainAxisAlignment:
                                              MainAxisAlignment.start,
                                          crossAxisAlignment:
                                              CrossAxisAlignment.start,
                                          children: [
                                            Expanded(
                                              flex: 1,
                                              child: SvgPicture.asset(
                                                "assets/svg/crm/product_details_ic.svg",
                                              ),
                                            ),
                                            SizedBox(width: 10),
                                            Expanded(
                                              flex: 6,
                                              child: SizedBox(
                                                child: Column(
                                                  // mainAxisAlignment: MainAxisAlignment.start,
                                                  crossAxisAlignment:
                                                      CrossAxisAlignment.start,
                                                  mainAxisAlignment:
                                                      MainAxisAlignment.start,
                                                  children: [
                                                    Row(
                                                      children: [
                                                        Expanded(
                                                          flex: 4,
                                                          child: Text(
                                                            provider
                                                                    .leadProducts[lp]
                                                                    .productName ??
                                                                "-",
                                                            maxLines: 2,
                                                            overflow:
                                                                TextOverflow
                                                                    .ellipsis,
                                                            style: TextStyle(
                                                              fontFamily:
                                                                  "JakartaMedium",
                                                              fontSize: 14,
                                                              color:
                                                                  AppColors
                                                                      .semi_black,
                                                            ),
                                                          ),
                                                        ),
                                                        Expanded(
                                                          flex: 3,
                                                          child: Text(
                                                            maxLines: 1,
                                                            textAlign:
                                                                TextAlign.right,
                                                            "₹${provider.leadProducts[lp].price ?? "-"}",
                                                            style: TextStyle(
                                                              fontFamily:
                                                                  "JakartaMedium",
                                                              fontSize: 13,
                                                              color:
                                                                  AppColors
                                                                      .semi_black,
                                                            ),
                                                          ),
                                                        ),
                                                      ],
                                                    ),
                                                    Text(
                                                      "x  ${provider.leadProducts[lp].qty ?? "-"}",
                                                      style: TextStyle(
                                                        fontFamily:
                                                            "JakartaMedium",
                                                        fontSize: 14,
                                                        color:
                                                            AppColors.grey_semi,
                                                      ),
                                                    ),
                                                    SizedBox(height: 3),
                                                    DottedLine(
                                                      dashGapLength: 4,
                                                      dashGapColor:
                                                          Colors.white,
                                                      dashColor:
                                                          AppColors.grey_semi,
                                                      dashLength: 2,
                                                      lineThickness: 0.5,
                                                    ),
                                                    SizedBox(height: 5),
                                                    Text(
                                                      "₹${provider.leadProducts[lp].prodTotalPrice ?? " - "}",
                                                      style: TextStyle(
                                                        fontFamily:
                                                            "JakartaMedium",
                                                        fontSize: 14,
                                                        color:
                                                            AppColors
                                                                .semi_black,
                                                      ),
                                                    ),
                                                    SizedBox(height: 5),
                                                    Row(
                                                      mainAxisAlignment: MainAxisAlignment.spaceBetween,
                                                      children: [
                                                        Expanded(
                                                          child: Text(
                                                            provider.leadProducts[lp].remarks ?? "",
                                                            style: TextStyle(
                                                              fontFamily: "JakartaMedium",
                                                              fontSize: 14,
                                                              color: AppColors.semi_black,
                                                            ),
                                                            maxLines: 1,
                                                            overflow: TextOverflow.ellipsis,
                                                          ),
                                                        ),
                                                      ],
                                                    )
                                                  ],
                                                ),
                                              ),
                                            ),
                                          ],
                                        ),
                                      ),
                                    );
                                  },
                                ),
                              ),
                            ] else ...[
                              InkResponse(
                                onTap:
                                    editProvider.editProductDetailsClicked
                                        ? null
                                        : () async {
                                          HapticFeedback.selectionClick();
                                          editProvider
                                              .editProductDetailsClicked = true;
                                          editProvider.resetForm();
                                          await editProvider
                                              .crmLeadDetailsEditProductsViewAPIFunction(
                                                context,
                                                provider.leadDetails.id!,
                                              );
                                          _showAddEditProductsSheet(
                                            context,
                                            widget.mode,
                                            "add",
                                            "",
                                          );
                                        },
                                child: Container(
                                  height: 50,
                                  margin: EdgeInsets.symmetric(
                                    horizontal: 10,
                                    vertical: 10,
                                  ),
                                  decoration: BoxDecoration(
                                    color: Colors.white,
                                    borderRadius: BorderRadius.circular(16),
                                  ),
                                  child: Center(
                                    child: Text(
                                      textAlign: TextAlign.right,
                                      "+ Add Product",
                                      style: TextStyle(
                                        fontFamily: "JakartaMedium",
                                        fontSize: 14,
                                        color: AppColors.app_blue,
                                      ),
                                    ),
                                  ),
                                ),
                              ),
                            ],

                            ///contact details
                            Container(
                              padding: EdgeInsets.only(
                                left: 10,
                                right: 10,
                                top: 10,
                              ),
                              child: Row(
                                children: [
                                  Expanded(
                                    child: Text(
                                      textAlign: TextAlign.left,
                                      "Contact Details",
                                      style: TextStyle(
                                        fontFamily: "JakartaMedium",
                                        fontSize: 14,
                                        color: AppColors.grey_thick,
                                      ),
                                    ),
                                  ),
                                  if (contactsNotEmpty) ...[
                                    Expanded(
                                      child: InkResponse(
                                        onTap:
                                            editProvider
                                                    .editContactDetailsClicked
                                                ? null
                                                : () {
                                                  HapticFeedback.selectionClick();
                                                  editProvider
                                                          .editContactDetailsClicked =
                                                      true;
                                                  _showAddContactSheet(context);
                                                },
                                        child: Padding(
                                          padding: const EdgeInsets.all(8.0),
                                          child: Text(
                                            textAlign: TextAlign.right,
                                            "+ Add Contact",
                                            style: TextStyle(
                                              fontFamily: "JakartaMedium",
                                              fontSize: 14,
                                              color: AppColors.app_blue,
                                            ),
                                          ),
                                        ),
                                      ),
                                    ),
                                  ],
                                ],
                              ),
                            ),
                            if (contactsNotEmpty) ...[
                              ListView.builder(
                                physics: NeverScrollableScrollPhysics(),
                                shrinkWrap: true,
                                padding: EdgeInsets.symmetric(
                                  vertical: 10,
                                  horizontal: 10,
                                ),
                                itemCount: provider.contactDetails.length,
                                itemBuilder: (context, lp) {
                                  return InkResponse(
                                    onTap:
                                        editProvider.editContactDetailsClicked
                                            ? null
                                            : () async {
                                              HapticFeedback.selectionClick();
                                              editProvider
                                                      .editContactDetailsClicked =
                                                  true;
                                              provider.editNameController.text =
                                                  provider
                                                      .contactDetails[lp]
                                                      .name ??
                                                  "";
                                              provider
                                                  .editDesignationController
                                                  .text = provider
                                                      .contactDetails[lp]
                                                      .designation ??
                                                  "";
                                              provider
                                                  .editMobileNumberController
                                                  .text = provider
                                                      .contactDetails[lp]
                                                      .mob1 ??
                                                  "";
                                              provider
                                                  .editAlternativeMobileController
                                                  .text = provider
                                                      .contactDetails[lp]
                                                      .mob2 ??
                                                  "";
                                              provider
                                                  .editTelephoneController
                                                  .text = provider
                                                      .contactDetails[lp]
                                                      .tel ??
                                                  "";
                                              provider
                                                  .editEmailController
                                                  .text = provider
                                                      .contactDetails[lp]
                                                      .email ??
                                                  "";
                                              _showEditContactSheet(
                                                context,
                                                lp,
                                              );
                                            },
                                    child: Container(
                                      decoration: BoxDecoration(
                                        color: Colors.white,
                                        borderRadius: BorderRadius.circular(14),
                                      ),
                                      padding: EdgeInsets.symmetric(
                                        horizontal: 10,
                                        vertical: 10,
                                      ),
                                      margin: EdgeInsets.symmetric(vertical: 5),

                                      child: Row(
                                        mainAxisAlignment:
                                            MainAxisAlignment.start,
                                        crossAxisAlignment:
                                            CrossAxisAlignment.start,
                                        children: [
                                          Expanded(
                                            flex: 1,
                                            child: SvgPicture.asset(
                                              "assets/svg/crm/contact_details_ic.svg",
                                            ),
                                          ),
                                          SizedBox(width: 10),
                                          Expanded(
                                            flex: 6,
                                            child: SizedBox(
                                              child: Column(
                                                // mainAxisAlignment: MainAxisAlignment.start,
                                                crossAxisAlignment:
                                                    CrossAxisAlignment.start,
                                                mainAxisAlignment:
                                                    MainAxisAlignment.start,
                                                children: [
                                                  Row(
                                                    children: [
                                                      Expanded(
                                                        flex: 4,
                                                        child: Text(
                                                          provider
                                                                  .contactDetails[lp]
                                                                  .name ??
                                                              "-",
                                                          style: TextStyle(
                                                            fontFamily:
                                                                "JakartaMedium",
                                                            fontSize: 14,
                                                            color:
                                                                AppColors
                                                                    .semi_black,
                                                          ),
                                                        ),
                                                      ),
                                                      Expanded(
                                                        flex: 3,
                                                        child: InkResponse(
                                                          onTap: () {
                                                            HapticFeedback.selectionClick();
                                                            launch(
                                                              'tel://${provider.contactDetails[lp].mob1}',
                                                            );
                                                          },
                                                          child: Text(
                                                            textAlign:
                                                                TextAlign.right,
                                                            provider
                                                                    .contactDetails[lp]
                                                                    .mob1 ??
                                                                "-",
                                                            style: TextStyle(
                                                              height: 1,
                                                              decorationColor:
                                                                  AppColors
                                                                      .grey_thick,
                                                              decoration:
                                                                  TextDecoration
                                                                      .underline,
                                                              decorationStyle:
                                                                  TextDecorationStyle
                                                                      .dotted,
                                                              fontFamily:
                                                                  "JakartaMedium",
                                                              fontSize: 14,
                                                              color:
                                                                  AppColors
                                                                      .semi_black,
                                                            ),
                                                          ),
                                                        ),
                                                      ),
                                                    ],
                                                  ),
                                                  Text(
                                                    provider
                                                            .contactDetails[lp]
                                                            .email ??
                                                        "-",
                                                    style: TextStyle(
                                                      fontFamily:
                                                          "JakartaMedium",
                                                      fontSize: 14,
                                                      color:
                                                          AppColors.grey_semi,
                                                    ),
                                                  ),
                                                ],
                                              ),
                                            ),
                                          ),
                                        ],
                                      ),
                                    ),
                                  );
                                },
                              ),
                            ] else ...[
                              InkResponse(
                                onTap:
                                    editProvider.editContactDetailsClicked
                                        ? null
                                        : () async {
                                          HapticFeedback.selectionClick();
                                          editProvider
                                              .editContactDetailsClicked = true;
                                          _showAddContactSheet(context);
                                        },
                                child: Container(
                                  height: 50,
                                  margin: EdgeInsets.symmetric(
                                    horizontal: 10,
                                    vertical: 10,
                                  ),
                                  decoration: BoxDecoration(
                                    color: Colors.white,
                                    borderRadius: BorderRadius.circular(16),
                                  ),
                                  child: Center(
                                    child: Text(
                                      textAlign: TextAlign.right,
                                      "+ Add Contact",
                                      style: TextStyle(
                                        fontFamily: "JakartaMedium",
                                        fontSize: 14,
                                        color: AppColors.app_blue,
                                      ),
                                    ),
                                  ),
                                ),
                              ),
                            ],

                            ///Followup details
                            Container(
                              padding: EdgeInsets.only(
                                left: 10,
                                right: 10,
                                top: 10,
                              ),
                              child: Row(
                                children: [
                                  Expanded(
                                    child: Text(
                                      textAlign: TextAlign.left,
                                      "Followup Details",
                                      style: TextStyle(
                                        fontFamily: "JakartaMedium",
                                        fontSize: 14,
                                        color: AppColors.grey_thick,
                                      ),
                                    ),
                                  ),
                                  if (followupNotEmpty) ...[
                                    Expanded(
                                      child: InkResponse(
                                        onTap: () async {
                                          HapticFeedback.selectionClick();
                                          var res = await Navigator.push(
                                            context,
                                            MaterialPageRoute(
                                              builder:
                                                  (context) =>
                                                      Followupupdatescreen(
                                                        leadID:
                                                            provider
                                                                .leadDetails
                                                                .id,
                                                        mode: widget.mode,
                                                      ),
                                              settings: RouteSettings(
                                                name: 'Followupupdatescreen',
                                              ),
                                            ),
                                          );
                                        },
                                        child: Padding(
                                          padding: const EdgeInsets.all(8.0),
                                          child: Text(
                                            textAlign: TextAlign.right,
                                            "+ Follow up Update",
                                            style: TextStyle(
                                              fontFamily: "JakartaMedium",
                                              fontSize: 14,
                                              color: AppColors.app_blue,
                                            ),
                                          ),
                                        ),
                                      ),
                                    ),
                                  ],
                                ],
                              ),
                            ),
                            if (followupNotEmpty) ...[
                              SizedBox(
                                width: double.infinity,
                                height: 250,
                                child: ListView.builder(
                                  physics: AlwaysScrollableScrollPhysics(),
                                  shrinkWrap: true,
                                  scrollDirection: Axis.horizontal,
                                  padding: EdgeInsets.symmetric(
                                    vertical: 10,
                                    horizontal: 10,
                                  ),
                                  itemCount: provider.followupDetails.length,
                                  itemBuilder: (context, lp) {
                                    return Container(
                                      height: 250,
                                      width:
                                          MediaQuery.of(context).size.width *
                                          0.9,
                                      decoration: BoxDecoration(
                                        color: Colors.white,
                                        borderRadius: BorderRadius.circular(14),
                                      ),
                                      padding: EdgeInsets.symmetric(
                                        horizontal: 10,
                                        vertical: 10,
                                      ),
                                      margin: EdgeInsets.symmetric(
                                        horizontal: 5,
                                      ),

                                      child: Column(
                                        children: [
                                          Row(
                                            mainAxisAlignment:
                                                MainAxisAlignment.start,
                                            crossAxisAlignment:
                                                CrossAxisAlignment.start,
                                            children: [
                                              Expanded(
                                                flex: 1,
                                                child: SvgPicture.asset(
                                                  "assets/svg/crm/followup_details_ic.svg",
                                                ),
                                              ),
                                              SizedBox(width: 10),
                                              Expanded(
                                                flex: 6,
                                                child: SizedBox(
                                                  child: Column(
                                                    // mainAxisAlignment: MainAxisAlignment.start,
                                                    crossAxisAlignment:
                                                        CrossAxisAlignment
                                                            .start,
                                                    mainAxisAlignment:
                                                        MainAxisAlignment.start,
                                                    children: [
                                                      Row(
                                                        children: [
                                                          Expanded(
                                                            flex: 4,
                                                            child: Column(
                                                              crossAxisAlignment:
                                                                  CrossAxisAlignment
                                                                      .start,
                                                              children: [
                                                                Text(
                                                                  provider
                                                                          .followupDetails[lp]
                                                                          .ename ??
                                                                      "-",
                                                                  style: TextStyle(
                                                                    fontFamily:
                                                                        "JakartaMedium",
                                                                    fontSize:
                                                                        14,
                                                                    color:
                                                                        AppColors
                                                                            .semi_black,
                                                                  ),
                                                                ),
                                                                Text(
                                                                  provider
                                                                          .followupDetails[lp]
                                                                          .fdate ??
                                                                      "-",
                                                                  style: TextStyle(
                                                                    fontFamily:
                                                                        "JakartaMedium",
                                                                    fontSize:
                                                                        14,
                                                                    color:
                                                                        AppColors
                                                                            .grey_semi,
                                                                  ),
                                                                ),
                                                              ],
                                                            ),
                                                          ),
                                                          Expanded(
                                                            flex: 2,
                                                            child: Container(
                                                              decoration:
                                                                  BoxDecoration(
                                                                    borderRadius:
                                                                        BorderRadius.circular(
                                                                          8,
                                                                        ),
                                                                    color: Color(
                                                                      0xFFF3FFD5,
                                                                    ),
                                                                  ),
                                                              padding:
                                                                  EdgeInsets.symmetric(
                                                                    horizontal:
                                                                        5,
                                                                    vertical:
                                                                        10,
                                                                  ),
                                                              child: Center(
                                                                child: Text(
                                                                  textAlign:
                                                                      TextAlign
                                                                          .right,
                                                                  provider
                                                                          .followupDetails[lp]
                                                                          .fstatus ??
                                                                      "-",
                                                                  style: TextStyle(
                                                                    fontFamily:
                                                                        "JakartaMedium",
                                                                    fontSize:
                                                                        14,
                                                                    color: Color(
                                                                      0xFF586000,
                                                                    ),
                                                                  ),
                                                                ),
                                                              ),
                                                            ),
                                                          ),
                                                        ],
                                                      ),
                                                    ],
                                                  ),
                                                ),
                                              ),
                                            ],
                                          ),
                                          Container(
                                            padding: EdgeInsets.symmetric(
                                              vertical: 7.5,
                                            ),
                                            child: Row(
                                              children: [
                                                Expanded(
                                                  flex: 2,
                                                  child: Text(
                                                    "Time",
                                                    style: TextStyle(
                                                      fontSize: 14,
                                                      fontFamily:
                                                          "JakartaSemiBold",
                                                    ),
                                                  ),
                                                ),
                                                Expanded(
                                                  flex: 9,
                                                  child: DottedLine(
                                                    dashGapLength: 4,
                                                    dashGapColor: Colors.white,
                                                    dashColor:
                                                        AppColors.grey_semi,
                                                    dashLength: 2,
                                                    lineThickness: 0.5,
                                                  ),
                                                ),
                                              ],
                                            ),
                                          ),
                                          ...List.generate(2, (j) {
                                            final heads = [
                                              "In Time",
                                              "Out Time",
                                            ];
                                            final subHeads = [
                                              provider
                                                      .followupDetails[lp]
                                                      .finTime ??
                                                  "-",
                                              provider
                                                      .followupDetails[lp]
                                                      .foutTime ??
                                                  "-",
                                            ];
                                            return Container(
                                              padding: EdgeInsets.symmetric(
                                                vertical: 3,
                                              ),
                                              child: Row(
                                                crossAxisAlignment:
                                                    CrossAxisAlignment.start,
                                                children: [
                                                  Expanded(
                                                    child: Text(
                                                      textAlign: TextAlign.left,
                                                      heads[j],
                                                      style: TextStyle(
                                                        fontFamily:
                                                            "JakartaRegular",
                                                        fontSize: 14,
                                                        color:
                                                            AppColors
                                                                .semi_black,
                                                      ),
                                                    ),
                                                  ),
                                                  Expanded(
                                                    child: Text(
                                                      textAlign:
                                                          TextAlign.right,
                                                      subHeads[j] == ""
                                                          ? "-"
                                                          : subHeads[j],
                                                      style: TextStyle(
                                                        fontSize: 14,
                                                        color: Color(
                                                          0xFF818181,
                                                        ),
                                                      ),
                                                    ),
                                                  ),
                                                ],
                                              ),
                                            );
                                          }),
                                          Container(
                                            padding: EdgeInsets.symmetric(
                                              vertical: 7,
                                            ),
                                            child: Row(
                                              children: [
                                                Expanded(
                                                  flex: 2,
                                                  child: Text(
                                                    "Remarks",
                                                    style: TextStyle(
                                                      fontSize: 14,
                                                      fontFamily:
                                                          "JakartaSemiBold",
                                                    ),
                                                  ),
                                                ),
                                                Expanded(
                                                  flex: 7,
                                                  child: DottedLine(
                                                    dashGapLength: 4,
                                                    dashGapColor: Colors.white,
                                                    dashColor:
                                                        AppColors.grey_semi,
                                                    dashLength: 2,
                                                    lineThickness: 0.5,
                                                  ),
                                                ),
                                              ],
                                            ),
                                          ),
                                          Container(
                                            // padding: EdgeInsets.symmetric(
                                            //   vertical: 2,
                                            // ),
                                            child: Row(
                                              crossAxisAlignment:
                                                  CrossAxisAlignment.start,
                                              children: [
                                                Expanded(
                                                  flex: 3,
                                                  child: Text(
                                                    textAlign: TextAlign.left,
                                                    "Feedback",
                                                    style: TextStyle(
                                                      fontFamily:
                                                          "JakartaRegular",
                                                      fontSize: 14,
                                                      color:
                                                          AppColors.semi_black,
                                                    ),
                                                  ),
                                                ),
                                                Expanded(
                                                  flex: 7,
                                                  child: Text(
                                                    textAlign: TextAlign.right,
                                                    provider
                                                                .followupDetails[lp]
                                                                .ffeedback ==
                                                            ""
                                                        ? "-"
                                                        : provider
                                                                .followupDetails[lp]
                                                                .ffeedback ??
                                                            "-",
                                                    maxLines: 2,
                                                    style: TextStyle(
                                                      fontSize: 14,
                                                      color: Color(0xFF818181),
                                                    ),
                                                  ),
                                                ),
                                              ],
                                            ),
                                          ),
                                        ],
                                      ),
                                    );
                                  },
                                ),
                              ),
                            ] else ...[
                              InkResponse(
                                onTap: () async {
                                  HapticFeedback.selectionClick();
                                  var res = await Navigator.push(
                                    context,
                                    MaterialPageRoute(
                                      builder:
                                          (context) => Followupupdatescreen(
                                            leadID: provider.leadDetails.id,
                                            mode: widget.mode,
                                          ),
                                      settings: RouteSettings(
                                        name: 'Followupupdatescreen',
                                      ),
                                    ),
                                  );
                                },
                                child: Container(
                                  height: 50,
                                  margin: EdgeInsets.symmetric(
                                    horizontal: 10,
                                    vertical: 10,
                                  ),
                                  decoration: BoxDecoration(
                                    color: Colors.white,
                                    borderRadius: BorderRadius.circular(16),
                                  ),
                                  child: Center(
                                    child: Text(
                                      textAlign: TextAlign.right,
                                      "+ Follow up Update",
                                      style: TextStyle(
                                        fontFamily: "JakartaMedium",
                                        fontSize: 14,
                                        color: AppColors.app_blue,
                                      ),
                                    ),
                                  ),
                                ),
                              ),
                            ],

                            ///Appointment details
                            Container(
                              padding: EdgeInsets.only(
                                left: 10,
                                right: 10,
                                top: 10,
                              ),
                              child: Row(
                                children: [
                                  Expanded(
                                    child: Text(
                                      textAlign: TextAlign.left,
                                      "Appointment Details",
                                      style: TextStyle(
                                        fontFamily: "JakartaMedium",
                                        fontSize: 14,
                                        color: AppColors.grey_thick,
                                      ),
                                    ),
                                  ),
                                  if (appointmentNotEmpty) ...[
                                    Expanded(
                                      child: InkResponse(
                                        onTap:
                                            editProvider
                                                    .appointmentDetailsClicked
                                                ? null
                                                : () {
                                                  HapticFeedback.selectionClick();
                                                  editProvider
                                                          .appointmentDetailsClicked =
                                                      true;
                                                  _showAddAppointmentSheet(
                                                    context,
                                                  );
                                                },
                                        child: Padding(
                                          padding: const EdgeInsets.all(8.0),
                                          child: Text(
                                            textAlign: TextAlign.right,
                                            "+ Add Appointment",
                                            style: TextStyle(
                                              fontFamily: "JakartaMedium",
                                              fontSize: 14,
                                              color: AppColors.app_blue,
                                            ),
                                          ),
                                        ),
                                      ),
                                    ),
                                  ],
                                ],
                              ),
                            ),
                            if (appointmentNotEmpty) ...[
                              SizedBox(
                                width: double.infinity,
                                height: 225,
                                child: ListView.builder(
                                  physics: AlwaysScrollableScrollPhysics(),
                                  shrinkWrap: true,
                                  scrollDirection: Axis.horizontal,
                                  padding: EdgeInsets.symmetric(
                                    vertical: 10,
                                    horizontal: 10,
                                  ),
                                  itemCount: provider.appointmentDetails.length,
                                  itemBuilder: (context, lp) {
                                    return Container(
                                      height: 225,
                                      width:
                                          MediaQuery.of(context).size.width *
                                          0.9,
                                      decoration: BoxDecoration(
                                        color: Colors.white,
                                        borderRadius: BorderRadius.circular(14),
                                      ),
                                      padding: EdgeInsets.symmetric(
                                        horizontal: 10,
                                        vertical: 10,
                                      ),
                                      margin: EdgeInsets.symmetric(
                                        horizontal: 5,
                                      ),

                                      child: Column(
                                        children: [
                                          Row(
                                            mainAxisAlignment:
                                                MainAxisAlignment.start,
                                            crossAxisAlignment:
                                                CrossAxisAlignment.start,
                                            children: [
                                              Expanded(
                                                flex: 1,
                                                child: SvgPicture.asset(
                                                  "assets/svg/crm/appointment_details_ic.svg",
                                                ),
                                              ),
                                              SizedBox(width: 10),
                                              Expanded(
                                                flex: 6,
                                                child: SizedBox(
                                                  child: Column(
                                                    // mainAxisAlignment: MainAxisAlignment.start,
                                                    crossAxisAlignment:
                                                        CrossAxisAlignment
                                                            .start,
                                                    mainAxisAlignment:
                                                        MainAxisAlignment.start,
                                                    children: [
                                                      Row(
                                                        children: [
                                                          Expanded(
                                                            flex: 4,
                                                            child: Column(
                                                              crossAxisAlignment:
                                                                  CrossAxisAlignment
                                                                      .start,
                                                              children: [
                                                                Text(
                                                                  provider
                                                                          .appointmentDetails[lp]
                                                                          .ename ??
                                                                      "-",
                                                                  style: TextStyle(
                                                                    fontFamily:
                                                                        "JakartaMedium",
                                                                    fontSize:
                                                                        14,
                                                                    color:
                                                                        AppColors
                                                                            .semi_black,
                                                                  ),
                                                                ),
                                                                Text(
                                                                  provider
                                                                          .appointmentDetails[lp]
                                                                          .adate ??
                                                                      "-",
                                                                  style: TextStyle(
                                                                    fontFamily:
                                                                        "JakartaMedium",
                                                                    fontSize:
                                                                        14,
                                                                    color:
                                                                        AppColors
                                                                            .grey_semi,
                                                                  ),
                                                                ),
                                                              ],
                                                            ),
                                                          ),
                                                        ],
                                                      ),
                                                    ],
                                                  ),
                                                ),
                                              ),
                                              if (provider
                                                      .appointmentDetails[lp]
                                                      .astatus ==
                                                  "No") ...[
                                                Expanded(
                                                  flex: 3,
                                                  child: Container(
                                                    height: 45,
                                                    padding:
                                                        EdgeInsets.symmetric(
                                                          horizontal: 5,
                                                        ),
                                                    decoration: BoxDecoration(
                                                      color:
                                                          AppColors
                                                              .processed_bg_color,
                                                      borderRadius:
                                                          BorderRadius.circular(
                                                            8,
                                                          ),
                                                    ),
                                                    child: Center(
                                                      child: Text(
                                                        "Pending",
                                                        textAlign:
                                                            TextAlign.right,
                                                        style: TextStyle(
                                                          fontFamily:
                                                              "JakartaMedium",
                                                          fontSize: 14,
                                                          color:
                                                              AppColors
                                                                  .processed_text_color,
                                                        ),
                                                      ),
                                                    ),
                                                  ),
                                                ),
                                              ],
                                            ],
                                          ),
                                          Container(
                                            padding: EdgeInsets.symmetric(
                                              vertical: 10,
                                            ),
                                            child: Row(
                                              children: [
                                                Expanded(
                                                  flex: 4,
                                                  child: Text(
                                                    "Appointment",
                                                    maxLines: 1,
                                                    style: TextStyle(
                                                      fontSize: 14,
                                                      fontFamily:
                                                          "JakartaSemiBold",
                                                    ),
                                                  ),
                                                ),
                                                Expanded(
                                                  flex: 7,
                                                  child: DottedLine(
                                                    dashGapLength: 4,
                                                    dashGapColor: Colors.white,
                                                    dashColor:
                                                        AppColors.grey_semi,
                                                    dashLength: 2,
                                                    lineThickness: 0.5,
                                                  ),
                                                ),
                                              ],
                                            ),
                                          ),
                                          ...List.generate(1, (j) {
                                            final headsa = ["Type"];
                                            final subHeadsa = [
                                              provider
                                                      .appointmentDetails[lp]
                                                      .atype ??
                                                  "-",
                                            ];
                                            return Container(
                                              padding: EdgeInsets.symmetric(
                                                vertical: 3,
                                              ),
                                              child: Row(
                                                crossAxisAlignment:
                                                    CrossAxisAlignment.start,
                                                children: [
                                                  Expanded(
                                                    child: Text(
                                                      textAlign: TextAlign.left,
                                                      headsa[j],
                                                      style: TextStyle(
                                                        fontFamily:
                                                            "JakartaRegular",
                                                        fontSize: 14,
                                                        color:
                                                            AppColors
                                                                .semi_black,
                                                      ),
                                                    ),
                                                  ),
                                                  Expanded(
                                                    child: Text(
                                                      textAlign:
                                                          TextAlign.right,
                                                      subHeadsa[j] == ""
                                                          ? "-"
                                                          : subHeadsa[j],
                                                      style: TextStyle(
                                                        fontSize: 14,
                                                        color: Color(
                                                          0xFF818181,
                                                        ),
                                                      ),
                                                    ),
                                                  ),
                                                ],
                                              ),
                                            );
                                          }),
                                          Container(
                                            padding: EdgeInsets.symmetric(
                                              vertical: 10,
                                            ),
                                            child: Row(
                                              children: [
                                                Expanded(
                                                  flex: 2,
                                                  child: Text(
                                                    "Remarks",
                                                    style: TextStyle(
                                                      fontSize: 14,
                                                      fontFamily:
                                                          "JakartaSemiBold",
                                                    ),
                                                  ),
                                                ),
                                                Expanded(
                                                  flex: 7,
                                                  child: DottedLine(
                                                    dashGapLength: 4,
                                                    dashGapColor: Colors.white,
                                                    dashColor:
                                                        AppColors.grey_semi,
                                                    dashLength: 2,
                                                    lineThickness: 0.5,
                                                  ),
                                                ),
                                              ],
                                            ),
                                          ),
                                          Container(
                                            padding: EdgeInsets.symmetric(
                                              vertical: 3,
                                            ),
                                            child: Row(
                                              crossAxisAlignment:
                                                  CrossAxisAlignment.start,
                                              children: [
                                                Expanded(
                                                  flex: 1,
                                                  child: Text(
                                                    textAlign: TextAlign.left,
                                                    "Note",
                                                    style: TextStyle(
                                                      fontFamily:
                                                          "JakartaRegular",
                                                      fontSize: 14,
                                                      color:
                                                          AppColors.semi_black,
                                                    ),
                                                  ),
                                                ),
                                                Expanded(
                                                  flex: 5,
                                                  child: Text(
                                                    textAlign: TextAlign.right,
                                                    provider
                                                                .appointmentDetails[lp]
                                                                .anote ==
                                                            ""
                                                        ? "-"
                                                        : provider
                                                                .appointmentDetails[lp]
                                                                .anote ??
                                                            "-",
                                                    maxLines: 2,
                                                    style: TextStyle(
                                                      fontSize: 14,
                                                      height: 1,
                                                      color: Color(0xFF818181),
                                                    ),
                                                  ),
                                                ),
                                              ],
                                            ),
                                          ),
                                        ],
                                      ),
                                    );
                                  },
                                ),
                              ),
                            ] else ...[
                              InkResponse(
                                onTap:
                                    editProvider.appointmentDetailsClicked
                                        ? null
                                        : () {
                                          HapticFeedback.selectionClick();
                                          editProvider
                                              .appointmentDetailsClicked = true;
                                          _showAddAppointmentSheet(context);
                                        },
                                child: Container(
                                  height: 50,
                                  margin: EdgeInsets.symmetric(
                                    horizontal: 10,
                                    vertical: 10,
                                  ),
                                  decoration: BoxDecoration(
                                    color: Colors.white,
                                    borderRadius: BorderRadius.circular(16),
                                  ),
                                  child: Center(
                                    child: Text(
                                      textAlign: TextAlign.right,
                                      "+ Add Appointment",
                                      style: TextStyle(
                                        fontFamily: "JakartaMedium",
                                        fontSize: 14,
                                        color: AppColors.app_blue,
                                      ),
                                    ),
                                  ),
                                ),
                              ),
                            ],

                            ///Quotation details
                            Container(
                              padding: EdgeInsets.only(
                                left: 10,
                                right: 10,
                                top: 10,
                              ),
                              child: Row(
                                children: [
                                  Expanded(
                                    child: Text(
                                      textAlign: TextAlign.left,
                                      "Quotation Details",
                                      style: TextStyle(
                                        fontFamily: "JakartaMedium",
                                        fontSize: 14,
                                        color: AppColors.grey_thick,
                                      ),
                                    ),
                                  ),
                                  if (quotationNotEmpty) ...[
                                    Expanded(
                                      child: InkResponse(
                                        onTap: () async {
                                          var res = await Navigator.push(
                                            context,
                                            MaterialPageRoute(
                                              builder:
                                                  (context) =>
                                                      Generatequotationscreen(
                                                        leadId:
                                                            provider
                                                                .leadDetails
                                                                .id,
                                                      ),
                                            ),
                                          );
                                          if (res == true) {
                                            provider.crmLeadDetailsAPIFunction(
                                              context,
                                              provider.leadDetails.id,
                                              widget.mode,
                                            );
                                          }
                                        },
                                        child: Padding(
                                          padding: const EdgeInsets.all(8.0),
                                          child: Text(
                                            textAlign: TextAlign.right,
                                            "+ Generate Quotation",
                                            style: TextStyle(
                                              fontFamily: "JakartaMedium",
                                              fontSize: 14,
                                              color: AppColors.app_blue,
                                            ),
                                          ),
                                        ),
                                      ),
                                    ),
                                  ],
                                ],
                              ),
                            ),
                            if (quotationNotEmpty) ...[
                              SizedBox(
                                width: double.infinity,
                                height: 244,
                                child: ListView.builder(
                                  physics: AlwaysScrollableScrollPhysics(),
                                  shrinkWrap: true,
                                  scrollDirection: Axis.horizontal,
                                  padding: EdgeInsets.symmetric(
                                    vertical: 10,
                                    horizontal: 10,
                                  ),
                                  itemCount: provider.quotationsDetails.length,
                                  itemBuilder: (context, lp) {
                                    return Container(
                                      height: 242,
                                      width:
                                          MediaQuery.of(context).size.width *
                                          0.9,
                                      decoration: BoxDecoration(
                                        color: Colors.white,
                                        borderRadius: BorderRadius.circular(14),
                                      ),
                                      padding: EdgeInsets.symmetric(
                                        horizontal: 10,
                                        vertical: 10,
                                      ),
                                      margin: EdgeInsets.symmetric(
                                        horizontal: 5,
                                      ),

                                      child: Column(
                                        children: [
                                          Row(
                                            mainAxisAlignment:
                                                MainAxisAlignment.start,
                                            crossAxisAlignment:
                                                CrossAxisAlignment.start,
                                            children: [
                                              Expanded(
                                                flex: 1,
                                                child: SvgPicture.asset(
                                                  "assets/svg/crm/quotation_details_ic.svg",
                                                ),
                                              ),
                                              SizedBox(width: 10),
                                              Expanded(
                                                flex: 6,
                                                child: SizedBox(
                                                  child: Column(
                                                    // mainAxisAlignment: MainAxisAlignment.start,
                                                    crossAxisAlignment:
                                                        CrossAxisAlignment
                                                            .start,
                                                    mainAxisAlignment:
                                                        MainAxisAlignment.start,
                                                    children: [
                                                      Row(
                                                        children: [
                                                          Expanded(
                                                            flex: 4,
                                                            child: Column(
                                                              crossAxisAlignment:
                                                                  CrossAxisAlignment
                                                                      .start,
                                                              children: [
                                                                Text(
                                                                  provider
                                                                          .quotationsDetails[lp]
                                                                          .employee ??
                                                                      "-",
                                                                  style: TextStyle(
                                                                    fontFamily:
                                                                        "JakartaMedium",
                                                                    fontSize:
                                                                        14,
                                                                    color:
                                                                        AppColors
                                                                            .semi_black,
                                                                  ),
                                                                ),
                                                                Text(
                                                                  provider
                                                                          .quotationsDetails[lp]
                                                                          .id ??
                                                                      "-",
                                                                  style: TextStyle(
                                                                    fontFamily:
                                                                        "JakartaMedium",
                                                                    fontSize:
                                                                        14,
                                                                    color:
                                                                        AppColors
                                                                            .grey_semi,
                                                                  ),
                                                                ),
                                                              ],
                                                            ),
                                                          ),
                                                        ],
                                                      ),
                                                    ],
                                                  ),
                                                ),
                                              ),
                                            ],
                                          ),
                                          Container(
                                            padding: EdgeInsets.symmetric(
                                              vertical: 10,
                                            ),
                                            child: Row(
                                              children: [
                                                Expanded(
                                                  flex: 4,
                                                  child: Text(
                                                    "Quotation Details",
                                                    style: TextStyle(
                                                      fontSize: 14,
                                                      fontFamily:
                                                          "JakartaSemiBold",
                                                    ),
                                                  ),
                                                ),
                                                Expanded(
                                                  flex: 7,
                                                  child: DottedLine(
                                                    dashGapLength: 4,
                                                    dashGapColor: Colors.white,
                                                    dashColor:
                                                        AppColors.grey_semi,
                                                    dashLength: 2,
                                                    lineThickness: 0.5,
                                                  ),
                                                ),
                                              ],
                                            ),
                                          ),
                                          ...List.generate(2, (j) {
                                            final headsa = [
                                              "File Attached",
                                              "Info",
                                            ];
                                            final subHeadsa = [
                                              "View",
                                              provider
                                                      .quotationsDetails[lp]
                                                      .info ??
                                                  "-",
                                            ];
                                            return Container(
                                              padding: EdgeInsets.symmetric(
                                                vertical: 3,
                                              ),
                                              child: Row(
                                                crossAxisAlignment:
                                                    CrossAxisAlignment.start,
                                                children: [
                                                  Expanded(
                                                    child: Text(
                                                      textAlign: TextAlign.left,
                                                      headsa[j],
                                                      style: TextStyle(
                                                        fontFamily:
                                                            "JakartaRegular",
                                                        fontSize: 14,
                                                        color:
                                                            AppColors
                                                                .semi_black,
                                                      ),
                                                    ),
                                                  ),
                                                  if (subHeadsa[j] ==
                                                      "View") ...[
                                                    Expanded(
                                                      child: InkResponse(
                                                        onTap: () {
                                                          provider.crmDownloadQuotationFunction(
                                                            context,
                                                            widget.leadId,
                                                            provider
                                                                .quotationsDetails[lp]
                                                                .id,
                                                            provider
                                                                .quotationsDetails[lp]
                                                                .type,
                                                          );
                                                        },
                                                        child: Text(
                                                          textAlign:
                                                              TextAlign.right,
                                                          subHeadsa[j] == ""
                                                              ? "-"
                                                              : subHeadsa[j],
                                                          style: TextStyle(
                                                            fontSize: 14,
                                                            color:
                                                                AppColors
                                                                    .app_blue,
                                                            decorationColor:
                                                                AppColors
                                                                    .app_blue,
                                                            decoration:
                                                                TextDecoration
                                                                    .underline,
                                                          ),
                                                        ),
                                                      ),
                                                    ),
                                                  ] else ...[
                                                    Expanded(
                                                      child: Text(
                                                        textAlign:
                                                            TextAlign.right,
                                                        subHeadsa[j] == ""
                                                            ? "-"
                                                            : subHeadsa[j],
                                                        style: TextStyle(
                                                          fontSize: 14,
                                                          color: Color(
                                                            0xFF818181,
                                                          ),
                                                        ),
                                                      ),
                                                    ),
                                                  ],
                                                ],
                                              ),
                                            );
                                          }),
                                        ],
                                      ),
                                    );
                                  },
                                ),
                              ),
                            ] else ...[
                              InkResponse(
                                onTap: () async {
                                  HapticFeedback.selectionClick();
                                  var res = await Navigator.push(
                                    context,
                                    MaterialPageRoute(
                                      builder:
                                          (context) => Generatequotationscreen(
                                            leadId: provider.leadDetails.id,
                                          ),
                                    ),
                                  );
                                  if (res == true) {
                                    provider.crmLeadDetailsAPIFunction(
                                      context,
                                      provider.leadDetails.id,
                                      widget.mode,
                                    );
                                  }
                                },
                                child: Container(
                                  height: 50,
                                  margin: EdgeInsets.symmetric(
                                    horizontal: 10,
                                    vertical: 10,
                                  ),
                                  decoration: BoxDecoration(
                                    color: Colors.white,
                                    borderRadius: BorderRadius.circular(16),
                                  ),
                                  child: Center(
                                    child: Text(
                                      textAlign: TextAlign.right,
                                      "+ Generate Quotation",
                                      style: TextStyle(
                                        fontFamily: "JakartaMedium",
                                        fontSize: 14,
                                        color: AppColors.app_blue,
                                      ),
                                    ),
                                  ),
                                ),
                              ),
                            ],
                            SizedBox(height: 75),
                          ],
                        ),
                      ],
                    ),
                  ),
        );
      },
    );
  }

  Future<void> _showAddAppointmentSheet(BuildContext context) {
    return showModalBottomSheet(
      useSafeArea: true,
      isDismissible: true,
      isScrollControlled: true,
      showDragHandle: true,
      backgroundColor: Colors.white,
      enableDrag: true,
      context: context,
      builder: (context) {
        return StatefulBuilder(
          builder: (context, setState) {
            return SafeArea(
              child: Consumer2<crmLeadDetailsProvider, Editproductlistprovider>(
                builder: (context, provider, editProvider, child) {
                  editProvider.appointmentDetailsClicked = false;
                  return Container(
                    margin: EdgeInsets.only(
                      bottom: 15,
                      left: 15,
                      right: 15,
                      top: 10,
                    ),
                    padding: EdgeInsets.only(
                      bottom: MediaQuery.of(context).viewInsets.bottom,
                    ),

                    child: SingleChildScrollView(
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        mainAxisSize: MainAxisSize.min,
                        children: [
                          Align(
                            alignment: Alignment.topLeft,
                            child: Text(
                              "Add Appointment",
                              style: TextStyle(
                                color: AppColors.app_blue,
                                fontSize: 16,
                              ),
                            ),
                          ),
                          TextWidget(context, "Appointment Date"),
                          GestureDetector(
                            onTap: () {
                              HapticFeedback.selectionClick();
                              provider.showDatePickerDialog(context);
                            },
                            child: Row(
                              crossAxisAlignment: CrossAxisAlignment.center,
                              children: [
                                Expanded(
                                  child: Container(
                                    height: 50,
                                    alignment: Alignment.center,
                                    decoration: BoxDecoration(
                                      color: AppColors.text_field_color,
                                      borderRadius: BorderRadius.circular(14),
                                    ),
                                    child: Padding(
                                      padding: const EdgeInsets.fromLTRB(
                                        10.0,
                                        0.0,
                                        10,
                                        0,
                                      ),
                                      child: TextFormField(
                                        controller: provider.dateController,
                                        keyboardType: TextInputType.text,
                                        enabled: false,
                                        maxLines: 1,
                                        readOnly: true,
                                        onChanged: (value) {},
                                        decoration: InputDecoration(
                                          hintText: "Enter Date",
                                          hintStyle: TextStyle(
                                            fontWeight: FontWeight.w400,
                                            color: Color(0xFFB4BEC0),
                                            fontSize: 14,
                                          ),

                                          enabledBorder: InputBorder.none,
                                          disabledBorder: InputBorder.none,
                                          focusedBorder: InputBorder.none,
                                        ),
                                      ),
                                    ),
                                  ),
                                ),
                              ],
                            ),
                          ),
                          errorWidget(context, provider.dateError),
                          TextWidget(context, "Appointment Type"),
                          DropdownButtonHideUnderline(
                            child: Row(
                              children: [
                                Expanded(
                                  child: DropdownButton2<String>(
                                    isExpanded: true,
                                    hint: const Row(
                                      children: [
                                        Expanded(
                                          child: Text(
                                            'Select Type',
                                            style: TextStyle(fontSize: 14),
                                            overflow: TextOverflow.ellipsis,
                                          ),
                                        ),
                                      ],
                                    ),
                                    items:
                                        provider.visitTypes
                                            .map(
                                              (vt) => DropdownMenuItem<String>(
                                                value: vt,
                                                child: Text(
                                                  vt,
                                                  style: const TextStyle(
                                                    fontSize: 14,
                                                  ),
                                                  overflow:
                                                      TextOverflow.ellipsis,
                                                ),
                                              ),
                                            )
                                            .toList(),
                                    value: provider.selectedVisitType,
                                    onChanged: (value) {
                                      if (value != null) {
                                        provider.selectedVisitType = value;
                                        print(
                                          "statusId:${provider.selectedVisitType}",
                                        );
                                      }
                                    },
                                    buttonStyleData: ddtheme.buttonStyleData,
                                    iconStyleData: ddtheme.iconStyleData,
                                    menuItemStyleData:
                                        ddtheme.menuItemStyleData,
                                    dropdownStyleData:
                                        ddtheme.dropdownStyleData,
                                  ),
                                ),
                              ],
                            ),
                          ),
                          errorWidget(context, provider.visitTypeError),

                          textControllerWidget(
                            context,
                            provider.noteController,
                            "Note",
                            "Enter Note",
                            provider.onChangeNote,
                            TextInputType.text,
                            false,
                            null,
                          ),
                          errorWidget(context, provider.noteError),

                          InkWell(
                            onTap:
                                provider.isLoading
                                    ? null
                                    : () {
                                      HapticFeedback.selectionClick();
                                      provider.isLoading = true;
                                      provider
                                          .crmLeadDetailsAddAppointmentAPIFunction(
                                            context,
                                            provider.leadDetails.id,
                                            provider.formattedDateToSend,
                                            provider.selectedVisitType,
                                            provider.noteController.text,
                                          );
                                    },
                            child: Container(
                              alignment: Alignment.center,
                              height: 45,
                              decoration: BoxDecoration(
                                color: AppColors.app_blue, //1487C9
                                borderRadius: BorderRadius.circular(14.0),
                              ),
                              child: Center(
                                child:
                                    provider.isLoading
                                        ? CircularProgressIndicator.adaptive(
                                          valueColor: AlwaysStoppedAnimation(
                                            AppColors.white,
                                          ),
                                        )
                                        : Text(
                                          "Submit",
                                          textAlign: TextAlign.center,
                                          style: TextStyle(color: Colors.white),
                                        ),
                              ),
                            ),
                          ),
                        ],
                      ),
                    ),
                  );
                },
              ),
            );
          },
        );
      },
    ).whenComplete(() {
      WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
        final provider = Provider.of<crmLeadDetailsProvider>(
          context,
          listen: false,
        );
        final editProvider = Provider.of<Editproductlistprovider>(
          context,
          listen: false,
        );
        editProvider.appointmentDetailsClicked = false;
        provider.crmLeadDetailsAPIFunction(context, widget.leadId, widget.mode);
      });
    });
  }

  Future<void> _showAddContactSheet(BuildContext context) {
    return showModalBottomSheet(
      useSafeArea: true,
      isDismissible: true,
      isScrollControlled: true,
      showDragHandle: true,
      backgroundColor: Colors.white,
      enableDrag: true,
      context: context,
      builder: (context) {
        return StatefulBuilder(
          builder: (context, setState) {
            return SafeArea(
              child: Consumer2<crmLeadDetailsProvider, Editproductlistprovider>(
                builder: (context, provider, editProvider, child) {
                  editProvider.editContactDetailsClicked = false;
                  return Container(
                    margin: EdgeInsets.only(
                      bottom: 15,
                      left: 15,
                      right: 15,
                      top: 10,
                    ),
                    padding: EdgeInsets.only(
                      bottom: MediaQuery.of(context).viewInsets.bottom,
                    ),

                    child: SingleChildScrollView(
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        mainAxisSize: MainAxisSize.min,
                        children: [
                          Align(
                            alignment: Alignment.topLeft,
                            child: Text(
                              "Add Contact",
                              style: TextStyle(
                                color: AppColors.app_blue,
                                fontSize: 16,
                              ),
                            ),
                          ),
                          textControllerWidget(
                            context,
                            provider.nameController,
                            "Name",
                            "Enter Name",
                            (p0) {
                              provider.crmCheckFields(
                                context,
                                provider.nameController.text,
                                "name",
                              );
                              provider.onChangeName(p0);
                            },
                            TextInputType.text,
                            false,
                            null,
                          ),
                          errorWidget(context, provider.nameError),
                          textControllerWidget(
                            context,
                            provider.designationController,
                            "Designation",
                            "Enter Designation",
                            provider.onChangeDesignation,
                            TextInputType.text,
                            false,
                            null,
                          ),
                          errorWidget(context, provider.designationError),
                          textControllerWidget(
                            context,
                            provider.mobileNumberController,
                            "Mobile Number",
                            "Enter Mobile Number",
                            (p0) {
                              provider.crmCheckFields(
                                context,
                                provider.mobileNumberController.text,
                                "mob1",
                              );
                              provider.onChangeMobile(p0);
                            },

                            TextInputType.number,
                            false,
                            FilteringTextInputFormatter.digitsOnly,
                            null,
                            null,
                            TextInputAction.next,
                            10,
                          ),
                          errorWidget(context, provider.mobileNumError),
                          textControllerWidget(
                            context,
                            provider.alternativeMobileController,
                            "Alternative Mobile Number",
                            "Enter Alternative Mobile Number",
                            (p0) {
                              provider.crmCheckFields(
                                context,
                                provider.alternativeMobileController.text,
                                "mob2",
                              );
                              provider.onChangeAltMobile(p0);
                            },

                            TextInputType.number,
                            false,
                            FilteringTextInputFormatter.digitsOnly,
                            null,
                            null,
                            TextInputAction.next,
                            10,
                          ),
                          errorWidget(context, provider.altMobError),
                          textControllerWidget(
                            context,
                            provider.telephoneController,
                            "Telephone Number",
                            "Enter Telephone Number",
                            provider.onChangeTelephone,
                            TextInputType.number,
                            false,
                            FilteringTextInputFormatter.digitsOnly,
                          ),
                          errorWidget(context, provider.teleError),
                          textControllerWidget(
                            context,
                            provider.emailController,
                            "Email ID",
                            "Enter Email ID",
                            provider.onChangeEmailId,
                            TextInputType.emailAddress,
                            false,
                            null,
                          ),
                          errorWidget(context, provider.emailError),
                          InkWell(
                            onTap:
                                provider.isLoading
                                    ? null
                                    : () {
                                      HapticFeedback.selectionClick();
                                      provider.isLoading = true;
                                      provider
                                          .crmLeadDetailsAddContactAPIFunction(
                                            context,
                                            provider.leadDetails.accId,
                                          );
                                    },
                            child: Container(
                              alignment: Alignment.center,
                              height: 45,
                              margin: EdgeInsets.only(
                                left: 5.0,
                                right: 5.0,
                                top: 5.0,
                                bottom: 5.0,
                              ),
                              decoration: BoxDecoration(
                                color: AppColors.app_blue, //1487C9
                                borderRadius: BorderRadius.circular(14.0),
                              ),
                              child: Center(
                                child:
                                    provider.isLoading
                                        ? CircularProgressIndicator.adaptive(
                                          valueColor: AlwaysStoppedAnimation(
                                            AppColors.white,
                                          ),
                                        )
                                        : Text(
                                          "Submit",
                                          textAlign: TextAlign.center,
                                          style: TextStyle(color: Colors.white),
                                        ),
                              ),
                            ),
                          ),
                        ],
                      ),
                    ),
                  );
                },
              ),
            );
          },
        );
      },
    ).whenComplete(() {
      WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
        final provider = Provider.of<crmLeadDetailsProvider>(
          context,
          listen: false,
        );
        final editProvider = Provider.of<Editproductlistprovider>(
          context,
          listen: false,
        );
        editProvider.editContactDetailsClicked = false;
        provider.crmLeadDetailsAPIFunction(context, widget.leadId, widget.mode);
      });
    });
  }

  Future<void> _showEditContactSheet(BuildContext context, index) {
    return showModalBottomSheet(
      useSafeArea: true,
      isDismissible: true,
      isScrollControlled: true,
      showDragHandle: true,
      backgroundColor: Colors.white,
      enableDrag: true,
      context: context,
      builder: (context) {
        return StatefulBuilder(
          builder: (context, setState) {
            return SafeArea(
              child: Consumer2<crmLeadDetailsProvider, Editproductlistprovider>(
                builder: (context, provider, editProvider, child) {
                  editProvider.editContactDetailsClicked = false;
                  return Container(
                    margin: EdgeInsets.only(
                      bottom: 15,
                      left: 15,
                      right: 15,
                      top: 10,
                    ),
                    padding: EdgeInsets.only(
                      bottom: MediaQuery.of(context).viewInsets.bottom,
                    ),
                    child: SingleChildScrollView(
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        mainAxisSize: MainAxisSize.min,
                        children: [
                          Align(
                            alignment: Alignment.topLeft,
                            child: Text(
                              "Edit Contact",
                              style: TextStyle(
                                color: AppColors.app_blue,
                                fontSize: 16,
                              ),
                            ),
                          ),
                          textControllerWidget(
                            context,
                            provider.editNameController,
                            "Name",
                            "Enter Name",
                            (p0) {
                              provider.crmCheckFields(
                                context,
                                provider.editNameController.text,
                                "name",
                              );
                              provider.onChangeEditName(p0);
                            },
                            TextInputType.text,
                            false,
                            null,
                          ),
                          errorWidget(context, provider.editNameError),
                          textControllerWidget(
                            context,
                            provider.editDesignationController,
                            "Designation",
                            "Enter Designation",
                            provider.onChangeEditDesignation,
                            TextInputType.text,
                            false,
                            null,
                          ),
                          errorWidget(context, provider.editDesignationError),
                          textControllerWidget(
                            context,
                            provider.editMobileNumberController,
                            "Mobile Number",
                            "Enter Mobile Number",
                            (p0) {
                              provider.crmCheckFields(
                                context,
                                provider.editMobileNumberController.text,
                                "mob1",
                              );
                              provider.onChangeEditMobile(p0);
                            },

                            TextInputType.number,
                            false,
                            FilteringTextInputFormatter.digitsOnly,
                            null,
                            null,
                            TextInputAction.next,
                            10,
                          ),
                          errorWidget(context, provider.editMobileNumError),

                          textControllerWidget(
                            context,
                            provider.editAlternativeMobileController,
                            "Alternative Mobile Number",
                            "Enter Alternative Mobile Number",
                            (p0) {
                              provider.crmCheckFields(
                                context,
                                provider.editAlternativeMobileController.text,
                                "mob2",
                              );
                              provider.onChangeEditAltMobile(p0);
                            },

                            TextInputType.number,
                            false,
                            FilteringTextInputFormatter.digitsOnly,
                            null,
                            null,
                            TextInputAction.next,
                            10,
                          ),
                          errorWidget(context, provider.editAltMobError),
                          textControllerWidget(
                            context,
                            provider.editTelephoneController,
                            "Telephone Number",
                            "Enter Telephone Number",
                            provider.onChangeEditTelephone,
                            TextInputType.number,
                            false,
                            FilteringTextInputFormatter.digitsOnly,
                          ),
                          errorWidget(context, provider.editTeleError),

                          textControllerWidget(
                            context,
                            provider.editEmailController,
                            "Email ID",
                            "Enter Email ID",
                            provider.onChangeEditEmailId,
                            TextInputType.emailAddress,
                            false,
                            null,
                          ),
                          errorWidget(context, provider.editEmailError),

                          InkWell(
                            onTap:
                                provider.isLoading
                                    ? null
                                    : () {
                                      HapticFeedback.selectionClick();
                                      provider.isLoading = true;
                                      provider
                                          .crmLeadDetailsEditContactAPIFunction(
                                            context,
                                            provider.contactDetails[index].id,
                                          );
                                    },
                            child: Container(
                              alignment: Alignment.center,
                              height: 45,
                              margin: EdgeInsets.only(
                                left: 5.0,
                                right: 5.0,
                                top: 5.0,
                                bottom: 5.0,
                              ),
                              decoration: BoxDecoration(
                                color: AppColors.app_blue, //1487C9
                                borderRadius: BorderRadius.circular(14.0),
                              ),
                              child: Center(
                                child:
                                    provider.isLoading
                                        ? CircularProgressIndicator.adaptive(
                                          valueColor: AlwaysStoppedAnimation(
                                            AppColors.white,
                                          ),
                                        )
                                        : Text(
                                          "Submit",
                                          textAlign: TextAlign.center,
                                          style: TextStyle(color: Colors.white),
                                        ),
                              ),
                            ),
                          ),
                        ],
                      ),
                    ),
                  );
                },
              ),
            );
          },
        );
      },
    ).whenComplete(() {
      WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
        final provider = Provider.of<crmLeadDetailsProvider>(
          context,
          listen: false,
        );
        final editprovider = Provider.of<Editproductlistprovider>(
          context,
          listen: false,
        );
        editprovider.editContactDetailsClicked = false;
        provider.crmLeadDetailsAPIFunction(context, widget.leadId, widget.mode);
      });
    });
  }

  Future<void> _showOptionsSheet(BuildContext context) {
    return showModalBottomSheet(
      useSafeArea: true,
      isDismissible: true,
      isScrollControlled: true,
      showDragHandle: true,
      backgroundColor: Colors.white,
      enableDrag: true,
      context: context,
      builder: (context) {
        return StatefulBuilder(
          builder: (context, setState) {
            return SafeArea(
              child: Consumer<crmLeadDetailsProvider>(
                builder: (context, provider, child) {
                  final assetnames = [
                    "crm_appoint_details",
                    "crm_cont_details",
                    "crm_follow_up_details",
                    "crm_prod_details",
                    "crm_quotation_details",
                  ];

                  final Headingnames = [
                    "Product Details",
                    "Contact Details",
                    "Followup Details",
                    "Appointment Details",
                    "Quotation Details",
                  ];

                  return Container(
                    margin: EdgeInsets.only(
                      bottom: 15,
                      left: 15,
                      right: 15,
                      top: 10,
                    ),
                    padding: EdgeInsets.only(
                      bottom: MediaQuery.of(context).viewInsets.bottom,
                    ),

                    child: SingleChildScrollView(
                      child: Column(
                        mainAxisSize: MainAxisSize.min,
                        children: [
                          SizedBox(height: 15),

                          ...List.generate(assetnames.length, (index) {
                            return ListTile(
                              onTap: () {
                                HapticFeedback.selectionClick();
                                Navigator.pop(context, true);
                                switch (index) {
                                  case 0:
                                    Navigator.push(
                                      context,
                                      MaterialPageRoute(
                                        builder:
                                            (context) => Productdetails(
                                              leadID: provider.leadDetails.id,
                                              mode: widget.mode,
                                            ),
                                      ),
                                    );
                                    break;
                                  case 1:
                                    Navigator.push(
                                      context,
                                      MaterialPageRoute(
                                        builder:
                                            (context) => Contactdetails(
                                              accID: provider.leadDetails.accId,
                                            ),
                                      ),
                                    );
                                    break;
                                  case 2:
                                    Navigator.push(
                                      context,
                                      MaterialPageRoute(
                                        builder: (context) => FollowUpDetails(),
                                      ),
                                    );
                                    break;
                                  case 3:
                                    Navigator.push(
                                      context,
                                      MaterialPageRoute(
                                        builder:
                                            (context) => AppointmentDetails(
                                              leadID: provider.leadDetails.id,
                                            ),
                                      ),
                                    );
                                    break;
                                  case 4:
                                    Navigator.push(
                                      context,
                                      MaterialPageRoute(
                                        builder:
                                            (context) => QuotationDetails(
                                              leadID: provider.leadDetails.id,
                                              mode: widget.mode,
                                            ),
                                      ),
                                    );
                                  default:
                                    print("object");
                                }
                              },
                              leading: SvgPicture.asset(
                                "assets/svg/${assetnames[index]}.svg",
                              ),
                              title: Text(
                                Headingnames[index],
                                style: TextStyle(fontFamily: "JakartaMedium"),
                              ),
                              trailing: SvgPicture.asset(
                                "assets/svg/arrow_right_new.svg",
                              ),
                            );
                          }),
                        ],
                      ),
                    ),
                  );
                },
              ),
            );
          },
        );
      },
    );
  }

  Future<void> _showAddEditProductsSheet(
    BuildContext context,
    mode,
    type,
    leadProductId,
  ) {
    return showModalBottomSheet(
      useSafeArea: true,
      isDismissible: true,
      isScrollControlled: true,
      showDragHandle: true,
      backgroundColor: Colors.white,
      enableDrag: true,
      context: context,
      builder: (context) {
        return StatefulBuilder(
          builder: (context, setState) {
            return SafeArea(
              child: Consumer2<crmLeadDetailsProvider, Editproductlistprovider>(
                builder: (context, provider, editProvider, child) {
                  void updatedAmountfun(value) {
                    editProvider.editProductDetailsClicked = false;
                    final price =
                        double.tryParse(
                          editProvider.addEditProductPriceController.text,
                        ) ??
                        0;
                    final qty =
                        int.tryParse(
                          editProvider.addEditQuantityController.text,
                        ) ??
                        0;
                    editProvider.addEditTotalAmountController.text =
                        (price * qty).toString();
                  }

                  return Container(
                    margin: EdgeInsets.only(
                      bottom: 15,
                      left: 15,
                      right: 15,
                      top: 10,
                    ),
                    padding: EdgeInsets.only(
                      bottom: MediaQuery.of(context).viewInsets.bottom,
                    ),

                    child: SingleChildScrollView(
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: [
                          Text(
                            type == "add" ? "Add Product" : "Edit Product",
                            style: TextStyle(
                              fontSize: 14,
                              color: AppColors.app_blue,
                              fontFamily: "JakartaMedium",
                            ),
                          ),
                          SizedBox(height: 10),
                          TextWidget(context, "Product"),
                          DropdownButtonHideUnderline(
                            child: Row(
                              children: [
                                Expanded(
                                  child: DropdownButton2<Products>(
                                    isExpanded: true,
                                    hint: const Text(
                                      'Select Product',
                                      style: TextStyle(fontSize: 14),
                                      overflow: TextOverflow.ellipsis,
                                    ),
                                    items:
                                        editProvider.productsList
                                            .map(
                                              (ord) =>
                                                  DropdownMenuItem<Products>(
                                                    value: ord,
                                                    child: Text(
                                                      "${ord.name}",
                                                      style: const TextStyle(
                                                        fontSize: 14,
                                                      ),
                                                      overflow:
                                                          TextOverflow.ellipsis,
                                                    ),
                                                  ),
                                            )
                                            .toList(),
                                    // value: editProvider.selectedAddEditProductId != null
                                    //     ? editProvider.productsList.firstWhere(
                                    //       (ord) => ord.id == editProvider.selectedProductIds,
                                    //   orElse: () => editProvider.productsList[0],
                                    // )
                                    //     : null,
                                    value: editProvider.selectedProducts,
                                    onChanged: (Products? value) {
                                      if (value != null) {
                                        editProvider.selectedProducts = value;
                                        editProvider.selectedAddEditProductId =
                                            value.id;
                                        editProvider
                                                .selectedAddEditProductName =
                                            value.name;
                                        editProvider
                                            .crmSelectedProductDetailsApiFunction(
                                              context,
                                              value.id.toString(),
                                            );
                                        // editProvider.updateSelectedProductIds(j, value);
                                        // editProvider.selectedProductIds[j] =
                                        //     value.id?.toString() ?? '';
                                        // editProvider.updateTotalAmount(j);
                                      }
                                    },
                                    buttonStyleData: ddtheme.buttonStyleData,
                                    iconStyleData: ddtheme.iconStyleData,
                                    menuItemStyleData:
                                        ddtheme.menuItemStyleData,
                                    dropdownStyleData:
                                        ddtheme.dropdownStyleData,
                                  ),
                                ),
                              ],
                            ),
                          ),
                          if (editProvider.productError != null) ...[
                            errorWidget(context, editProvider.productError),
                          ],
                          Row(
                            children: [
                              Expanded(
                                flex: 2,
                                child: textControllerWidget(
                                  context,
                                  editProvider.addEditProductPriceController,
                                  "Product Price",
                                  "Enter Product Price",
                                  updatedAmountfun,
                                  TextInputType.number,
                                  false,
                                  null,
                                ),
                              ),
                            ],
                          ),
                          if (editProvider.priceError != null) ...[
                            errorWidget(context, editProvider.priceError),
                          ],
                          Row(
                            children: [
                              Expanded(
                                flex: 2,
                                child: textControllerWidget(
                                  context,
                                  editProvider.addEditQuantityController,
                                  "Quantity",
                                  "Enter Quantity",
                                  updatedAmountfun,
                                  TextInputType.number,
                                  false,
                                  FilteringTextInputFormatter.digitsOnly,
                                ),
                              ),
                            ],
                          ),
                          if (type != "add") ...[
                            Text(
                              "Note: Submit Quantity as Zero (0) to delete Product",
                              style: TextStyle(
                                color: AppColors.app_blue,
                                fontSize: 12,
                              ),
                            ),
                          ],
                          if (editProvider.qtyError != null) ...[
                            errorWidget(context, editProvider.qtyError),
                          ],
                          const SizedBox(height: 10),
                          Row(
                            children: [
                              Expanded(
                                flex: 2,
                                child: textControllerWidget(
                                  context,
                                  editProvider.addEditTotalAmountController,
                                  "Amount",
                                  "Total Amount",
                                  (_) {},
                                  TextInputType.number,
                                  true,
                                  FilteringTextInputFormatter.digitsOnly,
                                ),
                              ),
                            ],
                          ),
                          const SizedBox(height: 10),
                          TextWidget(context, "Remarks"),
                          Container(
                            margin: EdgeInsets.only(bottom: 6),
                            decoration: BoxDecoration(
                              color: AppColors.text_field_color,
                              borderRadius: BorderRadius.circular(14),
                            ),
                            child: TextFormField(
                              controller: editProvider.addEditRemarkController,
                              maxLines: 3,
                              enabled: true,
                              style: TextStyle(
                                color: Colors.black,
                                fontSize: 14,
                              ),
                              decoration: InputDecoration(
                                hintText: "Enter remark",
                                hintStyle: TextStyle(
                                  color: Colors.grey.shade500,
                                  fontSize: 14,
                                ),
                                border: InputBorder.none,
                                contentPadding: EdgeInsets.symmetric(
                                    horizontal: 12, vertical: 12),
                              ),
                            ),
                          ),
                          // IconButton(
                          //   icon: const Icon(Icons.delete),
                          //   onPressed: editProvider.editProductPriceControllers.length > 1
                          //       ? () => editProvider.editRemoveRow(j)
                          //       : null,
                          // ),
                          InkResponse(
                            onTap:
                                editProvider.submitLoading
                                    ? null
                                    : () {
                                      editProvider
                                          .crmLeadDetailsAddEditProductsSubmitAPIFunction(
                                            context,
                                            mode,
                                            provider.leadDetails.id!,
                                            type,
                                            leadProductId,
                                            editProvider.selectedAddEditProductId,
                                        editProvider.addEditRemarkController
                                          );
                                    },
                            child: Container(
                              height: 45,
                              alignment: Alignment.center,
                              margin: const EdgeInsets.symmetric(
                                horizontal: 0,
                                vertical: 15,
                              ),
                              padding: const EdgeInsets.symmetric(
                                horizontal: 10,
                                vertical: 5,
                              ),
                              decoration: BoxDecoration(
                                color: AppColors.app_blue,
                                borderRadius: BorderRadius.circular(15),
                              ),
                              child:
                                  editProvider.submitLoading
                                      ? CircularProgressIndicator.adaptive(
                                        valueColor:
                                            AlwaysStoppedAnimation<Color>(
                                              AppColors.white,
                                            ),
                                      )
                                      : const Text(
                                        "Submit",
                                        style: TextStyle(
                                          fontSize: 15,
                                          fontFamily: "JakartaMedium",
                                          color: Colors.white,
                                        ),
                                      ),
                            ),
                          ),
                        ],
                      ),
                    ),
                  );
                },
              ),
            );
          },
        );
      },
    ).whenComplete(() {
      WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
        final provider = Provider.of<crmLeadDetailsProvider>(
          context,
          listen: false,
        );
        final editProvider = Provider.of<Editproductlistprovider>(
          context,
          listen: false,
        );
        editProvider.editProductDetailsClicked = false;
        provider.crmLeadDetailsAPIFunction(context, widget.leadId, widget.mode);
      });
    });
  }
}
