import 'dart:io';

import 'package:connectivity_plus/connectivity_plus.dart';
import 'package:dropdown_button2/dropdown_button2.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:flutter_svg/svg.dart';
import 'package:generp/Notifiers/commonProvider/accountsListProvider.dart';
import 'package:generp/Utils/ShakeWidget.dart';
import 'package:generp/Utils/app_colors.dart';
import 'package:generp/Utils/commonServices.dart';
import 'package:generp/Utils/commonWidgets.dart';
import 'package:generp/Utils/dropdownTheme.dart';
import 'package:provider/provider.dart';
import 'package:generp/Models/commonModels/DistrictsResponse.dart';
import 'package:generp/Models/commonModels/SubLocationsResponse.dart';

import '../../Models/commonModels/commonAddAccountsViewResponse.dart';

class Addcommonpayment extends StatefulWidget {
  final from;
  const Addcommonpayment({super.key, required this.from});

  @override
  State<Addcommonpayment> createState() => _AddcommonpaymentState();
}

class _AddcommonpaymentState extends State<Addcommonpayment> {
  Dropdowntheme ddtheme = Dropdowntheme();
  int _currentStep = 0;
  final _formKey = GlobalKey<FormState>();
  List<FocusNode> focusNodes = List.generate(20, (index) => FocusNode());
  Map _source = {ConnectivityResult.mobile: true};
  final MyConnectivity _connectivity = MyConnectivity.instance;

  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    _connectivity.initialise();
    _connectivity.myStream.listen((source) {
      setState(() => _source = source);
    });
    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
      var prov = Provider.of<Accountslistprovider>(context, listen: false);
      prov.addCommonAccountViewAPI(context);
    });
  }

  void _nextStep() {
    if (_formKey.currentState!.validate()) {
      if (_currentStep < 3) {
        setState(() {
          _currentStep += 1;
        });
      } else {
        // Submit form data
        _submitForm();
      }
    }
  }

  void _previousStep() {
    if (_currentStep > 0) {
      setState(() {
        _currentStep -= 1;
      });
    }
  }

  void _submitForm() {
    print('Form Submitted:');
    ScaffoldMessenger.of(context).showSnackBar(
      const SnackBar(content: Text('Form submitted successfully!')),
    );
  }

  @override
  void dispose() {
    focusNodes.map((e) => e.dispose());
    super.dispose();
    _connectivity.disposeStream();
  }

  Future<bool> onBackPressed(BuildContext context) async {
    if (_currentStep > 0) {
      _previousStep();
      return false;
    } else {
      return true;
    }
  }

  @override
  Widget build(BuildContext context) {
    switch (_source.keys.toList()[0]) {
      case ConnectivityResult.mobile:
        connection = 'Online';
        break;
      case ConnectivityResult.wifi:
        connection = 'Online';
        break;
      case ConnectivityResult.none:
      default:
        connection = 'Offline';
    }
    return (connection == "Online")
        ? Platform.isAndroid
            ? WillPopScope(
              onWillPop: () => onBackPressed(context),
              child: SafeArea(
                top: false,
                bottom: true,
                child: _scaffold(context),
              ),
            )
            : _scaffold(context)
        : NoNetwork(context);
  }

  Widget _scaffold(BuildContext context) {
    return Consumer<Accountslistprovider>(
      builder: (context, provider, child) {
        return Scaffold(
          resizeToAvoidBottomInset: true,
          appBar: appbar2New(
            context,
            "Add Account",
            provider.resetValues,
            SizedBox.shrink(),
            0xFFFFFFFF,
          ),
          backgroundColor: AppColors.scaffold_bg_color,
          body: Form(
            canPop: _currentStep == 0,
            key: _formKey,
            child: Stepper(
              margin: EdgeInsets.symmetric(horizontal: 0, vertical: 0),
              type: StepperType.horizontal,
              currentStep: _currentStep,
              onStepContinue: _nextStep,
              onStepCancel: _previousStep,
              onStepTapped: (value) {
                print(value);

                setState(() {
                  if (value == 1 && !provider.validateStep1()) {
                    return;
                  }
                  if (value == 2 && !provider.validateStep2()) {
                    return;
                  }
                  if (value < _currentStep) {
                    _currentStep = value;
                  } else if (value > _currentStep) {
                    _currentStep = value;
                  }
                });
              },
              connectorColor: WidgetStatePropertyAll(AppColors.app_blue),
              stepIconBuilder: (stepIndex, stepState) {
                return CircleAvatar(
                  radius: 12,
                  backgroundColor:
                      stepIndex <= _currentStep
                          ? AppColors.app_blue
                          : Colors.grey[300],
                );
              },
              steps: [
                Step(
                  label: Text("Step 1", style: TextStyle(fontSize: 12)),
                  title: const Text(''),
                  isActive: _currentStep >= 0,
                  content: Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      Container(
                        margin: EdgeInsets.only(bottom: 5),
                        child: Text(
                          "Account Details",
                          style: TextStyle(
                            color: AppColors.app_blue,
                            fontSize: 16,
                            fontFamily: "JakartaMedium",
                          ),
                        ),
                      ),
                      Container(
                        padding: EdgeInsets.symmetric(
                          horizontal: 10,
                          vertical: 10,
                        ),

                        decoration: BoxDecoration(
                          color: Colors.white,
                          borderRadius: BorderRadius.circular(16),
                        ),
                        child: Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: [
                            SizedBox(height: 10),
                            Text("Account"),
                            DropdownButtonHideUnderline(
                              child: Row(
                                children: [
                                  Expanded(
                                    child: DropdownButton2<String>(
                                      isExpanded: true,
                                      hint: const Row(
                                        children: [
                                          Expanded(
                                            child: Text(
                                              'Select Account',
                                              style: TextStyle(fontSize: 14),
                                              overflow: TextOverflow.ellipsis,
                                            ),
                                          ),
                                        ],
                                      ),
                                      items:
                                          provider.accountTypes
                                              .map(
                                                (act) =>
                                                    DropdownMenuItem<String>(
                                                      value: act,
                                                      child: Text(
                                                        act,
                                                        style: const TextStyle(
                                                          fontSize: 14,
                                                        ),
                                                        overflow:
                                                            TextOverflow
                                                                .ellipsis,
                                                      ),
                                                    ),
                                              )
                                              .toList(),
                                      // value: provider.selectedAccountType,
                                      value:
                                          provider.accountTypes.contains(
                                                provider.selectedAccountType,
                                              )
                                              ? provider.selectedAccountType
                                              : null,
                                      onChanged: (value) {
                                        if (value != null) {
                                          provider.selectedAccountType = value;
                                          print(
                                            "statusId:${provider.selectedAccountType}",
                                          );
                                        }
                                      },
                                      buttonStyleData: ddtheme.buttonStyleData,
                                      iconStyleData: ddtheme.iconStyleData,
                                      menuItemStyleData:
                                          ddtheme.menuItemStyleData,
                                      dropdownStyleData:
                                          ddtheme.dropdownStyleData,
                                    ),
                                  ),
                                ],
                              ),
                            ),
                            errorWidget(context, provider.accountError),
                            textControllerWidget(
                              context,
                              provider.nameController,
                              "Company Name",
                              "Enter Company Name",
                              (p0) {
                                provider.updateName(p0);
                                provider.checkInputsAPI(
                                  context,
                                  "name",
                                  provider.nameController.text,
                                );
                              },
                              TextInputType.text,
                              false,
                              null,
                              focusNodes[0],
                              focusNodes[1],
                              TextInputAction.next,
                            ),
                            errorWidget(context, provider.nameError),
                            textControllerWidget(
                              context,
                              provider.mobileController,
                              "Mobile Number",
                              "Enter Mobile",
                              (p0) {
                                provider.updateMobile(p0);
                                provider.checkInputsAPI(
                                  context,
                                  "mob1",
                                  provider.mobileController.text,
                                );
                              },
                              TextInputType.phone,
                              false,
                              FilteringTextInputFormatter.digitsOnly,
                              focusNodes[1],
                              focusNodes[2],
                              TextInputAction.next,
                              10,
                            ),
                            errorWidget(context, provider.mobileError),
                            textControllerWidget(
                              context,
                              provider.contactPersonController,
                              "Contact Person Name",
                              "Enter Contact Person Name",
                              provider.updateContactPerson,
                              TextInputType.text,
                              false,
                              null,
                              focusNodes[12],
                              focusNodes[13],
                              TextInputAction.next,
                            ),
                            errorWidget(context, provider.contactPersonError),
                          ],
                        ),
                      ),
                    ],
                  ),
                ),
                Step(
                  label: Text("Step 2", style: TextStyle(fontSize: 12)),
                  title: const Text(''),
                  isActive: _currentStep >= 1,
                  content: Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      Container(
                        margin: EdgeInsets.only(bottom: 10),
                        child: Text(
                          "Address Details",
                          style: TextStyle(
                            color: AppColors.app_blue,
                            fontSize: 16,
                            fontFamily: "JakartaMedium",
                          ),
                        ),
                      ),
                      Container(
                        padding: EdgeInsets.symmetric(
                          horizontal: 10,
                          vertical: 10,
                        ),
                        decoration: BoxDecoration(
                          color: Colors.white,
                          borderRadius: BorderRadius.circular(16),
                        ),
                        child: Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: [
                            Text("State"),
                            DropdownButtonHideUnderline(
                              child: Row(
                                children: [
                                  Expanded(
                                    child: DropdownButton2<States>(
                                      focusNode: focusNodes[2],
                                      autofocus:
                                          focusNodes[2].hasFocus ? true : false,
                                      isExpanded: true,
                                      hint: Text(
                                        'Select State',
                                        style: TextStyle(fontSize: 14),
                                        overflow: TextOverflow.ellipsis,
                                      ),
                                      items:
                                          provider.states
                                              .map(
                                                (states) =>
                                                    DropdownMenuItem<States>(
                                                      value: states,
                                                      child: Text(
                                                        states.name ?? '',
                                                        style: const TextStyle(
                                                          fontSize: 14,
                                                        ),
                                                        overflow:
                                                            TextOverflow
                                                                .ellipsis,
                                                      ),
                                                    ),
                                              )
                                              .toList(),
                                      value:
                                          provider.states.contains(
                                                provider.selectedState,
                                              )
                                              ? provider.selectedState
                                              : null,
                                      // value: provider.selectedState,
                                      onChanged: (States? value) {
                                        if (value != null) {
                                          if (provider.states.isNotEmpty) {
                                            provider.selectedState = value;
                                            print(
                                              "Selected Complaint Type: ${value.name}, ID: ${value.id}",
                                            );
                                            provider.selectedStateID =
                                                value.id!;
                                            print(
                                              "hfjkshfg${provider.selectedStateID}",
                                            );
                                            if (provider.selectedDistricts !=
                                                null) {
                                              provider.districts.clear();
                                              // provider.selectedDistricts = null;
                                              provider.selectedDistrictId =
                                                  null;
                                              provider.selectedDistrictValue =
                                                  null;
                                            }

                                            provider.getDistrictAPI(
                                              context,
                                              provider.selectedStateID,
                                            );
                                          }
                                        }
                                      },

                                      dropdownSearchData: DropdownSearchData(
                                        searchInnerWidgetHeight: 50,
                                        searchController:
                                            provider.stateSearchController,
                                        searchInnerWidget: Padding(
                                          padding: const EdgeInsets.all(8),
                                          child: TextFormField(
                                            controller:
                                                provider.stateSearchController,
                                            decoration: InputDecoration(
                                              isDense: true,
                                              contentPadding:
                                                  const EdgeInsets.symmetric(
                                                    horizontal: 10,
                                                    vertical: 8,
                                                  ),
                                              hintText: 'Search States...',
                                              border: OutlineInputBorder(
                                                borderRadius:
                                                    BorderRadius.circular(8),
                                              ),
                                            ),
                                          ),
                                        ),
                                        searchMatchFn: (item, searchValue) {
                                          return item.value?.name
                                                  ?.toLowerCase()
                                                  .contains(
                                                    searchValue.toLowerCase(),
                                                  ) ??
                                              false;
                                        },
                                      ),
                                      onMenuStateChange: (isOpen) {
                                        if (!isOpen) {
                                          provider.stateSearchController
                                              .clear();
                                        }
                                      },
                                      buttonStyleData: ddtheme.buttonStyleData,
                                      iconStyleData: ddtheme.iconStyleData,
                                      menuItemStyleData:
                                          ddtheme.menuItemStyleData,
                                      dropdownStyleData:
                                          ddtheme.dropdownStyleData,
                                    ),
                                  ),
                                ],
                              ),
                            ),
                            errorWidget(context, provider.stateError),
                            Text("District"),
                            DropdownButtonHideUnderline(
                              child: Row(
                                children: [
                                  Expanded(
                                    child: DropdownButton2<Districts>(
                                      focusNode: focusNodes[3],
                                      isExpanded: true,
                                      hint: Text(
                                        'Select District',
                                        style: TextStyle(fontSize: 14),
                                        overflow: TextOverflow.ellipsis,
                                      ),
                                      items:
                                          provider.districts
                                              .map(
                                                (dist) =>
                                                    DropdownMenuItem<Districts>(
                                                      value: dist,
                                                      child: Text(
                                                        dist.district ?? '',
                                                        style: const TextStyle(
                                                          fontSize: 14,
                                                        ),
                                                        overflow:
                                                            TextOverflow
                                                                .ellipsis,
                                                      ),
                                                    ),
                                              )
                                              .toList(),
                                      value:
                                          provider.districts.contains(
                                                provider.selectedDistricts,
                                              )
                                              ? provider.selectedDistricts
                                              : null,
                                      // value: provider.selectedDistricts,
                                      onChanged: (Districts? value) {
                                        if (value != null) {
                                          if (provider.districts.isNotEmpty) {
                                            provider.selectedDistricts = value;
                                            print("Selected ID: ${value.id}");
                                            provider.selectedDistrictId =
                                                value.id!;
                                            provider.selectedDistrictValue =
                                                value.district!;
                                            print(
                                              "hfjkshfg${provider.selectedDistrictId}",
                                            );
                                            if (provider.selectedSubLocations !=
                                                null) {
                                              provider.subLocations.clear();
                                              // provider.selectedSubLocations =
                                              // null;
                                              provider.selectedSubLocID = null;
                                              provider.selectedSubLocValue =
                                                  null;
                                            }
                                            provider.getSubLocationAPI(
                                              context,
                                              provider.selectedDistrictId,
                                            );
                                          }
                                        }
                                      },
                                      dropdownSearchData: DropdownSearchData(
                                        searchInnerWidgetHeight: 50,
                                        searchController:
                                            provider.districtSearchController,
                                        searchInnerWidget: Padding(
                                          padding: const EdgeInsets.all(8),
                                          child: TextFormField(
                                            controller:
                                                provider
                                                    .districtSearchController,
                                            decoration: InputDecoration(
                                              isDense: true,
                                              contentPadding:
                                                  const EdgeInsets.symmetric(
                                                    horizontal: 10,
                                                    vertical: 8,
                                                  ),
                                              hintText: 'Search Districts...',
                                              border: OutlineInputBorder(
                                                borderRadius:
                                                    BorderRadius.circular(8),
                                              ),
                                            ),
                                          ),
                                        ),
                                        searchMatchFn: (item, searchValue) {
                                          return item.value?.district
                                                  ?.toLowerCase()
                                                  .contains(
                                                    searchValue.toLowerCase(),
                                                  ) ??
                                              false;
                                        },
                                      ),
                                      onMenuStateChange: (isOpen) {
                                        if (!isOpen) {
                                          provider.districtSearchController
                                              .clear();
                                        }
                                      },
                                      buttonStyleData: ddtheme.buttonStyleData,
                                      iconStyleData: ddtheme.iconStyleData,
                                      menuItemStyleData:
                                          ddtheme.menuItemStyleData,
                                      dropdownStyleData:
                                          ddtheme.dropdownStyleData,
                                    ),
                                  ),
                                ],
                              ),
                            ),
                            errorWidget(context, provider.districtError),
                            Text("Sub Locality"),
                            DropdownButtonHideUnderline(
                              child: Row(
                                children: [
                                  Expanded(
                                    child: DropdownButton2<SubLocations>(
                                      focusNode: focusNodes[4],
                                      isExpanded: true,
                                      hint: Text(
                                        'Select Sub Locality',
                                        style: TextStyle(fontSize: 14),
                                        overflow: TextOverflow.ellipsis,
                                      ),
                                      items:
                                          provider.subLocations
                                              .map(
                                                (subloc) => DropdownMenuItem<
                                                  SubLocations
                                                >(
                                                  value: subloc,
                                                  child: Text(
                                                    subloc.subLocality ?? '',
                                                    style: const TextStyle(
                                                      fontSize: 14,
                                                    ),
                                                    overflow:
                                                        TextOverflow.ellipsis,
                                                  ),
                                                ),
                                              )
                                              .toList(),
                                      // value: provider.selectedSubLocations,
                                      value:
                                          provider.subLocations.contains(
                                                provider.selectedSubLocations,
                                              )
                                              ? provider.selectedSubLocations
                                              : null,
                                      onChanged: (SubLocations? value) {
                                        if (value != null) {
                                          if (provider
                                              .subLocations
                                              .isNotEmpty) {
                                            provider.selectedSubLocations =
                                                value;
                                            print("Selected ID: ${value.id}");
                                            provider.selectedSubLocID =
                                                value.id!;
                                            provider.selectedSubLocValue =
                                                value.subLocality!;
                                            print(
                                              "hfjkshfg${provider.selectedSubLocID}",
                                            );
                                          }
                                        }
                                      },
                                      dropdownSearchData: DropdownSearchData(
                                        searchInnerWidgetHeight: 50,
                                        searchController:
                                            provider.subLocSearchController,
                                        searchInnerWidget: Padding(
                                          padding: const EdgeInsets.all(8),
                                          child: TextFormField(
                                            controller:
                                                provider.subLocSearchController,
                                            decoration: InputDecoration(
                                              isDense: true,
                                              contentPadding:
                                                  const EdgeInsets.symmetric(
                                                    horizontal: 10,
                                                    vertical: 8,
                                                  ),
                                              hintText:
                                                  'Search Sub Locality...',
                                              border: OutlineInputBorder(
                                                borderRadius:
                                                    BorderRadius.circular(8),
                                              ),
                                            ),
                                          ),
                                        ),
                                        searchMatchFn: (item, searchValue) {
                                          return item.value?.subLocality
                                                  ?.toLowerCase()
                                                  .contains(
                                                    searchValue.toLowerCase(),
                                                  ) ??
                                              false;
                                        },
                                      ),
                                      onMenuStateChange: (isOpen) {
                                        if (!isOpen) {
                                          provider.subLocSearchController
                                              .clear();
                                        }
                                      },
                                      buttonStyleData: ddtheme.buttonStyleData,
                                      iconStyleData: ddtheme.iconStyleData,
                                      menuItemStyleData:
                                          ddtheme.menuItemStyleData,
                                      dropdownStyleData:
                                          ddtheme.dropdownStyleData,
                                    ),
                                  ),
                                ],
                              ),
                            ),
                            errorWidget(context, provider.localityError),
                            textControllerWidget(
                              context,
                              provider.addressController,
                              "Address",
                              "Enter Address",
                              provider.updateAddress,
                              TextInputType.text,
                              false,
                              null,
                              focusNodes[5],
                              null,
                              TextInputAction.done,
                            ),
                            errorWidget(context, provider.addressError),
                          ],
                        ),
                      ),
                    ],
                  ),
                ),
                Step(
                  label: Text("Step 3", style: TextStyle(fontSize: 12)),
                  title: const Text(''),
                  isActive: _currentStep >= 1,
                  content: Column(
                    crossAxisAlignment: CrossAxisAlignment.start,

                    children: [
                      Container(
                        margin: EdgeInsets.only(bottom: 10),
                        child: Text(
                          "Bank Details",
                          style: TextStyle(
                            color: AppColors.app_blue,
                            fontSize: 16,
                            fontFamily: "JakartaMedium",
                          ),
                        ),
                      ),
                      Container(
                        padding: EdgeInsets.symmetric(
                          horizontal: 10,
                          vertical: 10,
                        ),
                        decoration: BoxDecoration(
                          color: Colors.white,
                          borderRadius: BorderRadius.circular(16),
                        ),
                        child: Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: [
                            textControllerWidget(
                              context,
                              provider.bankNameController,
                              "Bank Name",
                              "Enter Bank Name",
                              provider.updateBankName,
                              TextInputType.text,
                              false,
                              null,
                              focusNodes[6],
                              focusNodes[7],
                              TextInputAction.next,
                            ),
                            errorWidget(context, provider.banknameError),
                            textControllerWidget(
                              context,
                              provider.branchNameController,
                              "Bank Branch",
                              "Enter Bank Branch",
                              provider.updateBankBranch,
                              TextInputType.text,
                              false,
                              null,
                              focusNodes[7],
                              focusNodes[8],
                              TextInputAction.next,
                            ),
                            errorWidget(context, provider.bankBranchError),
                            textControllerWidget(
                              context,
                              provider.bankIfscCotroller,
                              "Bank IFSC",
                              "Enter Bank IFSC",
                              provider.updateIFSC,
                              TextInputType.text,
                              false,
                              null,
                              focusNodes[8],
                              focusNodes[9],
                              TextInputAction.next,
                            ),
                            errorWidget(context, provider.bankIFSCError),
                            textControllerWidget(
                              context,
                              provider.bankHolderNameController,
                              "Bank Holder Name",
                              "Enter Bank Holder Name",
                              provider.updateHolder,
                              TextInputType.text,
                              false,
                              null,
                              focusNodes[9],
                              focusNodes[10],
                              TextInputAction.next,
                            ),
                            errorWidget(context, provider.bankHolderNameError),
                            textControllerWidget(
                              context,
                              provider.bankAcNumberController,
                              "Bank Account Number",
                              "Enter Bank Account Number",
                              provider.updateNumber,
                              TextInputType.number,
                              false,
                              FilteringTextInputFormatter.digitsOnly,
                              focusNodes[10],
                              focusNodes[11],
                              TextInputAction.next,
                            ),
                            errorWidget(context, provider.bankAcNumberError),
                            textControllerWidget(
                              context,
                              provider.bankUpiController,
                              "Bank UPI ID",
                              "Enter Bank UPI ID",
                              provider.updateUPI,
                              TextInputType.text,
                              false,
                              null,
                              focusNodes[11],
                              focusNodes[12],
                              TextInputAction.next,
                            ),
                            errorWidget(context, provider.upiError),
                          ],
                        ),
                      ),
                    ],
                  ),
                ),
                Step(
                  label: Text("Step 4", style: TextStyle(fontSize: 12)),
                  title: const Text(''),
                  isActive: _currentStep >= 2,
                  content: Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      Container(
                        margin: EdgeInsets.only(bottom: 10),
                        child: Text(
                          "Contact Details",
                          style: TextStyle(
                            color: AppColors.app_blue,
                            fontSize: 16,
                            fontFamily: "JakartaMedium",
                          ),
                        ),
                      ),
                      Container(
                        padding: EdgeInsets.symmetric(
                          horizontal: 10,
                          vertical: 10,
                        ),
                        decoration: BoxDecoration(
                          color: Colors.white,
                          borderRadius: BorderRadius.circular(16),
                        ),
                        child: Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: [
                            textControllerWidget(
                              context,
                              provider.contectPersonDesignationController,
                              "Contact Person Designation",
                              "Enter Contact Person Designation",
                              provider.updateDesignation,
                              TextInputType.text,
                              false,
                              null,
                              focusNodes[13],
                              focusNodes[14],
                              TextInputAction.next,
                            ),
                            errorWidget(context, provider.desigantionError),
                            textControllerWidget(
                              context,
                              provider.contectPersonAltMobController,
                              "Alternative Mobile Number",
                              "Enter Alternative Mobile Number",
                              (p0) {
                                provider.updateAltMobile(p0);
                                provider.checkInputsAPI(
                                  context,
                                  "mob2",
                                  provider.contectPersonAltMobController.text,
                                );
                              },
                              TextInputType.number,
                              false,
                              FilteringTextInputFormatter.digitsOnly,
                              focusNodes[14],
                              focusNodes[15],
                              TextInputAction.next,
                              10,
                            ),
                            errorWidget(context, provider.altMobError),
                            textControllerWidget(
                              context,
                              provider.contectPersonTeleController,
                              "Telephone Number",
                              "Enter Telephone Number",
                              provider.updateTeleMobile,
                              TextInputType.number,
                              false,
                              FilteringTextInputFormatter.digitsOnly,
                              focusNodes[15],
                              focusNodes[16],
                              TextInputAction.next,
                            ),
                            errorWidget(context, provider.teleError),
                            textControllerWidget(
                              context,
                              provider.contectPersonMailController,
                              "Customer Mail ID",
                              "Enter Customer Mail ID",
                              provider.updateMail,
                              TextInputType.text,
                              false,
                              null,
                              focusNodes[16],
                              focusNodes[17],
                              TextInputAction.next,
                            ),
                            errorWidget(context, provider.mailError),
                          ],
                        ),
                      ),
                    ],
                  ),
                ),
              ],
              controlsBuilder: (context, details) {
                return Column(
                  children: [
                    if (_currentStep == 3) ...[
                      InkResponse(
                        onTap:
                            provider.submitClickced
                                ? null
                                : () {
                                  if (provider.validateStep4()) {
                                    provider.submitClickced = true;
                                    provider.submitCommonAccountsAPI(
                                      context,
                                      widget.from,
                                    );
                                  }

                                  details.onStepContinue;
                                },
                        child: Container(
                          height: 45,
                          alignment: Alignment.center,
                          margin: EdgeInsets.symmetric(
                            horizontal: 10,
                            vertical: 10,
                          ),
                          padding: EdgeInsets.symmetric(
                            horizontal: 10,
                            vertical: 5,
                          ),
                          decoration: BoxDecoration(
                            color: AppColors.app_blue,
                            borderRadius: BorderRadius.circular(15),
                          ),
                          child: Text(
                            "Submit",
                            style: TextStyle(
                              fontSize: 15,
                              fontFamily: "JakartaMedium",
                              color: Colors.white,
                            ),
                          ),
                        ),
                      ),
                    ] else ...[
                      InkResponse(
                        onTap: () {
                          setState(() {
                            if (_currentStep == 0) {
                              if (provider.validateStep1()) {
                                _currentStep = 1;
                              }
                            } else if (_currentStep == 1) {
                              if (provider.validateStep2()) {
                                _currentStep = 2;
                              }
                            } else if (_currentStep == 2) {
                              if (provider.validateStep3()) {
                                _currentStep = 3;
                              }
                            } else {
                              _currentStep = 0;
                            }
                          });
                          details.onStepContinue;
                        },
                        child: Container(
                          height: 45,
                          alignment: Alignment.center,
                          margin: EdgeInsets.symmetric(
                            horizontal: 10,
                            vertical: 10,
                          ),
                          padding: EdgeInsets.symmetric(
                            horizontal: 10,
                            vertical: 5,
                          ),
                          decoration: BoxDecoration(
                            color: AppColors.app_blue,
                            borderRadius: BorderRadius.circular(15),
                          ),
                          child: Text(
                            "Proceed to Next Step",
                            textAlign: TextAlign.start,
                            style: TextStyle(
                              fontSize: 15,
                              fontFamily: "JakartaMedium",
                              color: Colors.white,
                            ),
                          ),
                        ),
                      ),
                    ],
                    if (_currentStep > 0) ...[
                      TextButton(
                        onPressed: () {
                          setState(() {
                            if (_currentStep == 3) {
                              _currentStep = 2;
                            }
                            if (_currentStep == 2) {
                              _currentStep = 1;
                            } else if (_currentStep == 1) {
                              _currentStep = 0;
                            } else {
                              _currentStep = 3;
                            }
                          });
                          details.onStepCancel;
                        },
                        child: Text(
                          'Back',
                          style: TextStyle(
                            color: AppColors.app_blue,
                            fontSize: 14,
                          ),
                        ),
                      ),
                    ],
                  ],
                );
              },
            ),
          ),
        );
      },
    );
  }

  Widget _scaffold1(BuildContext context) {
    return Consumer<Accountslistprovider>(
      builder: (context, provider, child) {
        return Scaffold(
          resizeToAvoidBottomInset: true,
          appBar: appbar2(
            context,
            "Add Account",
            provider.resetValues,
            SizedBox(width: 0),
          ),
          backgroundColor: AppColors.white,
          body: SizedBox(
            child: SingleChildScrollView(
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  Container(
                    padding: EdgeInsets.symmetric(horizontal: 10, vertical: 10),
                    margin: EdgeInsets.symmetric(horizontal: 10, vertical: 10),
                    decoration: BoxDecoration(
                      color: Colors.white,
                      borderRadius: BorderRadius.circular(16),
                    ),
                    child: Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        Text(
                          "Account Details",
                          style: TextStyle(
                            color: AppColors.app_blue,
                            fontSize: 16,
                            fontFamily: "JakartaMedium",
                          ),
                        ),
                        SizedBox(height: 10),
                        Text("Account"),
                        DropdownButtonHideUnderline(
                          child: Row(
                            children: [
                              Expanded(
                                child: DropdownButton2<String>(
                                  isExpanded: true,
                                  hint: const Row(
                                    children: [
                                      Expanded(
                                        child: Text(
                                          'Select Account',
                                          style: TextStyle(fontSize: 14),
                                          overflow: TextOverflow.ellipsis,
                                        ),
                                      ),
                                    ],
                                  ),
                                  items:
                                      provider.accountTypes
                                          .map(
                                            (act) => DropdownMenuItem<String>(
                                              value: act,
                                              child: Text(
                                                act,
                                                style: const TextStyle(
                                                  fontSize: 14,
                                                ),
                                                overflow: TextOverflow.ellipsis,
                                              ),
                                            ),
                                          )
                                          .toList(),
                                  // value: provider.selectedAccountType,
                                  value:
                                      provider.accountTypes.contains(
                                            provider.selectedAccountType,
                                          )
                                          ? provider.selectedAccountType
                                          : null,
                                  onChanged: (value) {
                                    if (value != null) {
                                      provider.selectedAccountType = value;
                                      print(
                                        "statusId:${provider.selectedAccountType}",
                                      );
                                    }
                                  },
                                  buttonStyleData: ddtheme.buttonStyleData,
                                  iconStyleData: ddtheme.iconStyleData,
                                  menuItemStyleData: ddtheme.menuItemStyleData,
                                  dropdownStyleData: ddtheme.dropdownStyleData,
                                ),
                              ),
                            ],
                          ),
                        ),
                        errorWidget(context, provider.accountError),
                        textControllerWidget(
                          context,
                          provider.nameController,
                          "Company Name",
                          "Enter Company Name",
                          (p0) {
                            provider.updateName(p0);
                            provider.checkInputsAPI(
                              context,
                              "name",
                              provider.nameController.text,
                            );
                          },
                          TextInputType.text,
                          false,
                          null,
                          focusNodes[0],
                          focusNodes[1],
                          TextInputAction.next,
                        ),
                        errorWidget(context, provider.nameError),
                        textControllerWidget(
                          context,
                          provider.mobileController,
                          "Mobile Number",
                          "Enter Mobile",
                          (p0) {
                            provider.updateMobile(p0);
                            provider.checkInputsAPI(
                              context,
                              "mob1",
                              provider.mobileController.text,
                            );
                          },
                          TextInputType.phone,
                          false,
                          FilteringTextInputFormatter.digitsOnly,
                          focusNodes[1],
                          focusNodes[2],
                          TextInputAction.next,
                          10,
                        ),
                        errorWidget(context, provider.mobileError),
                        textControllerWidget(
                          context,
                          provider.contactPersonController,
                          "Contact Person Name",
                          "Enter Contact Person Name",
                          provider.updateContactPerson,
                          TextInputType.text,
                          false,
                          null,
                          focusNodes[12],
                          focusNodes[13],
                          TextInputAction.next,
                        ),
                        errorWidget(context, provider.contactPersonError),
                      ],
                    ),
                  ),
                  SizedBox(height: 12),
                  Column(
                    children: [
                      InkResponse(
                        onTap: () => provider.isVisible = !provider.isVisible,
                        child: Center(
                          child: Text(
                            provider.isVisible
                                ? "- Hide More Details"
                                : "+ Add More Details",
                            style: TextStyle(
                              color: AppColors.app_blue,
                              fontSize: 16,
                              fontFamily: "JakartaMedium",
                            ),
                          ),
                        ),
                      ),
                      if (provider.addMoreDetailsError != null) ...[
                        Center(
                          child: ShakeWidget(
                            key: Key("value"),
                            duration: Duration(milliseconds: 700),
                            child: Text(
                              provider.addMoreDetailsError ?? "",
                              style: TextStyle(
                                color: Colors.red,
                                fontSize: 13,
                                fontFamily: "JakartaMedium",
                              ),
                            ),
                          ),
                        ),
                      ],
                      Visibility(
                        visible: provider.isVisible,
                        child: Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: [
                            Container(
                              margin: EdgeInsets.symmetric(
                                horizontal: 10,
                                vertical: 10,
                              ),
                              padding: EdgeInsets.symmetric(
                                horizontal: 10,
                                vertical: 10,
                              ),
                              decoration: BoxDecoration(
                                color: Colors.white,
                                borderRadius: BorderRadius.circular(16),
                              ),
                              child: Column(
                                crossAxisAlignment: CrossAxisAlignment.start,
                                children: [
                                  Text("State"),
                                  DropdownButtonHideUnderline(
                                    child: Row(
                                      children: [
                                        Expanded(
                                          child: DropdownButton2<States>(
                                            focusNode: focusNodes[2],
                                            autofocus:
                                                focusNodes[2].hasFocus
                                                    ? true
                                                    : false,
                                            isExpanded: true,
                                            hint: Text(
                                              'Select State',
                                              style: TextStyle(fontSize: 14),
                                              overflow: TextOverflow.ellipsis,
                                            ),
                                            items:
                                                provider.states
                                                    .map(
                                                      (
                                                        states,
                                                      ) => DropdownMenuItem<
                                                        States
                                                      >(
                                                        value: states,
                                                        child: Text(
                                                          states.name ?? '',
                                                          style:
                                                              const TextStyle(
                                                                fontSize: 14,
                                                              ),
                                                          overflow:
                                                              TextOverflow
                                                                  .ellipsis,
                                                        ),
                                                      ),
                                                    )
                                                    .toList(),
                                            value:
                                                provider.states.contains(
                                                      provider.selectedState,
                                                    )
                                                    ? provider.selectedState
                                                    : null,
                                            // value: provider.selectedState,
                                            onChanged: (States? value) {
                                              if (value != null) {
                                                if (provider
                                                    .states
                                                    .isNotEmpty) {
                                                  provider.selectedState =
                                                      value;
                                                  print(
                                                    "Selected Complaint Type: ${value.name}, ID: ${value.id}",
                                                  );
                                                  provider.selectedStateID =
                                                      value.id!;
                                                  print(
                                                    "hfjkshfg${provider.selectedStateID}",
                                                  );
                                                  if (provider
                                                          .selectedDistricts !=
                                                      null) {
                                                    provider.states.clear();
                                                    // provider.selectedDistricts = null;
                                                    provider.selectedDistrictId =
                                                        null;
                                                    provider.selectedDistrictValue =
                                                        null;
                                                  }

                                                  provider.getDistrictAPI(
                                                    context,
                                                    provider.selectedStateID,
                                                  );
                                                }
                                              }
                                            },

                                            dropdownSearchData: DropdownSearchData(
                                              searchInnerWidgetHeight: 50,
                                              searchController:
                                                  provider
                                                      .stateSearchController,
                                              searchInnerWidget: Padding(
                                                padding: const EdgeInsets.all(
                                                  8,
                                                ),
                                                child: TextFormField(
                                                  controller:
                                                      provider
                                                          .stateSearchController,
                                                  decoration: InputDecoration(
                                                    isDense: true,
                                                    contentPadding:
                                                        const EdgeInsets.symmetric(
                                                          horizontal: 10,
                                                          vertical: 8,
                                                        ),
                                                    hintText:
                                                        'Search States...',
                                                    border: OutlineInputBorder(
                                                      borderRadius:
                                                          BorderRadius.circular(
                                                            8,
                                                          ),
                                                    ),
                                                  ),
                                                ),
                                              ),
                                              searchMatchFn: (
                                                item,
                                                searchValue,
                                              ) {
                                                return item.value?.name
                                                        ?.toLowerCase()
                                                        .contains(
                                                          searchValue
                                                              .toLowerCase(),
                                                        ) ??
                                                    false;
                                              },
                                            ),
                                            onMenuStateChange: (isOpen) {
                                              if (!isOpen) {
                                                provider.stateSearchController
                                                    .clear();
                                              }
                                            },
                                            buttonStyleData:
                                                ddtheme.buttonStyleData,
                                            iconStyleData:
                                                ddtheme.iconStyleData,
                                            menuItemStyleData:
                                                ddtheme.menuItemStyleData,
                                            dropdownStyleData:
                                                ddtheme.dropdownStyleData,
                                          ),
                                        ),
                                      ],
                                    ),
                                  ),
                                  errorWidget(context, provider.stateError),
                                  Text("District"),
                                  DropdownButtonHideUnderline(
                                    child: Row(
                                      children: [
                                        Expanded(
                                          child: DropdownButton2<Districts>(
                                            focusNode: focusNodes[3],
                                            isExpanded: true,
                                            hint: Text(
                                              'Select District',
                                              style: TextStyle(fontSize: 14),
                                              overflow: TextOverflow.ellipsis,
                                            ),
                                            items:
                                                provider.districts
                                                    .map(
                                                      (
                                                        dist,
                                                      ) => DropdownMenuItem<
                                                        Districts
                                                      >(
                                                        value: dist,
                                                        child: Text(
                                                          dist.district ?? '',
                                                          style:
                                                              const TextStyle(
                                                                fontSize: 14,
                                                              ),
                                                          overflow:
                                                              TextOverflow
                                                                  .ellipsis,
                                                        ),
                                                      ),
                                                    )
                                                    .toList(),
                                            value:
                                                provider.districts.contains(
                                                      provider
                                                          .selectedDistricts,
                                                    )
                                                    ? provider.selectedDistricts
                                                    : null,
                                            // value: provider.selectedDistricts,
                                            onChanged: (Districts? value) {
                                              if (value != null) {
                                                if (provider
                                                    .districts
                                                    .isNotEmpty) {
                                                  provider.selectedDistricts =
                                                      value;
                                                  print(
                                                    "Selected ID: ${value.id}",
                                                  );
                                                  provider.selectedDistrictId =
                                                      value.id!;
                                                  provider.selectedDistrictValue =
                                                      value.district!;
                                                  print(
                                                    "hfjkshfg${provider.selectedDistrictId}",
                                                  );
                                                  if (provider
                                                          .selectedSubLocations !=
                                                      null) {
                                                    // provider.selectedSubLocations =
                                                    // null;
                                                    provider.selectedSubLocID =
                                                        null;
                                                    provider.selectedSubLocValue =
                                                        null;
                                                  }
                                                  provider.getSubLocationAPI(
                                                    context,
                                                    provider.selectedDistrictId,
                                                  );
                                                }
                                              }
                                            },
                                            dropdownSearchData: DropdownSearchData(
                                              searchInnerWidgetHeight: 50,
                                              searchController:
                                                  provider
                                                      .districtSearchController,
                                              searchInnerWidget: Padding(
                                                padding: const EdgeInsets.all(
                                                  8,
                                                ),
                                                child: TextFormField(
                                                  controller:
                                                      provider
                                                          .districtSearchController,
                                                  decoration: InputDecoration(
                                                    isDense: true,
                                                    contentPadding:
                                                        const EdgeInsets.symmetric(
                                                          horizontal: 10,
                                                          vertical: 8,
                                                        ),
                                                    hintText:
                                                        'Search Districts...',
                                                    border: OutlineInputBorder(
                                                      borderRadius:
                                                          BorderRadius.circular(
                                                            8,
                                                          ),
                                                    ),
                                                  ),
                                                ),
                                              ),
                                              searchMatchFn: (
                                                item,
                                                searchValue,
                                              ) {
                                                return item.value?.district
                                                        ?.toLowerCase()
                                                        .contains(
                                                          searchValue
                                                              .toLowerCase(),
                                                        ) ??
                                                    false;
                                              },
                                            ),
                                            onMenuStateChange: (isOpen) {
                                              if (!isOpen) {
                                                provider
                                                    .districtSearchController
                                                    .clear();
                                              }
                                            },
                                            buttonStyleData:
                                                ddtheme.buttonStyleData,
                                            iconStyleData:
                                                ddtheme.iconStyleData,
                                            menuItemStyleData:
                                                ddtheme.menuItemStyleData,
                                            dropdownStyleData:
                                                ddtheme.dropdownStyleData,
                                          ),
                                        ),
                                      ],
                                    ),
                                  ),
                                  errorWidget(context, provider.districtError),
                                  Text("Sub Locality"),
                                  DropdownButtonHideUnderline(
                                    child: Row(
                                      children: [
                                        Expanded(
                                          child: DropdownButton2<SubLocations>(
                                            focusNode: focusNodes[4],
                                            isExpanded: true,
                                            hint: Text(
                                              'Select Sub Locality',
                                              style: TextStyle(fontSize: 14),
                                              overflow: TextOverflow.ellipsis,
                                            ),
                                            items:
                                                provider.subLocations
                                                    .map(
                                                      (
                                                        subloc,
                                                      ) => DropdownMenuItem<
                                                        SubLocations
                                                      >(
                                                        value: subloc,
                                                        child: Text(
                                                          subloc.subLocality ??
                                                              '',
                                                          style:
                                                              const TextStyle(
                                                                fontSize: 14,
                                                              ),
                                                          overflow:
                                                              TextOverflow
                                                                  .ellipsis,
                                                        ),
                                                      ),
                                                    )
                                                    .toList(),
                                            // value: provider.selectedSubLocations,
                                            value:
                                                provider.subLocations.contains(
                                                      provider
                                                          .selectedSubLocations,
                                                    )
                                                    ? provider
                                                        .selectedSubLocations
                                                    : null,
                                            onChanged: (SubLocations? value) {
                                              if (value != null) {
                                                if (provider
                                                    .subLocations
                                                    .isNotEmpty) {
                                                  provider.selectedSubLocations =
                                                      value;
                                                  print(
                                                    "Selected ID: ${value.id}",
                                                  );
                                                  provider.selectedSubLocID =
                                                      value.id!;
                                                  provider.selectedSubLocValue =
                                                      value.subLocality!;
                                                  print(
                                                    "hfjkshfg${provider.selectedSubLocID}",
                                                  );
                                                }
                                              }
                                            },
                                            dropdownSearchData: DropdownSearchData(
                                              searchInnerWidgetHeight: 50,
                                              searchController:
                                                  provider
                                                      .subLocSearchController,
                                              searchInnerWidget: Padding(
                                                padding: const EdgeInsets.all(
                                                  8,
                                                ),
                                                child: TextFormField(
                                                  controller:
                                                      provider
                                                          .subLocSearchController,
                                                  decoration: InputDecoration(
                                                    isDense: true,
                                                    contentPadding:
                                                        const EdgeInsets.symmetric(
                                                          horizontal: 10,
                                                          vertical: 8,
                                                        ),
                                                    hintText:
                                                        'Search Sub Locality...',
                                                    border: OutlineInputBorder(
                                                      borderRadius:
                                                          BorderRadius.circular(
                                                            8,
                                                          ),
                                                    ),
                                                  ),
                                                ),
                                              ),
                                              searchMatchFn: (
                                                item,
                                                searchValue,
                                              ) {
                                                return item.value?.subLocality
                                                        ?.toLowerCase()
                                                        .contains(
                                                          searchValue
                                                              .toLowerCase(),
                                                        ) ??
                                                    false;
                                              },
                                            ),
                                            onMenuStateChange: (isOpen) {
                                              if (!isOpen) {
                                                provider.subLocSearchController
                                                    .clear();
                                              }
                                            },
                                            buttonStyleData:
                                                ddtheme.buttonStyleData,
                                            iconStyleData:
                                                ddtheme.iconStyleData,
                                            menuItemStyleData:
                                                ddtheme.menuItemStyleData,
                                            dropdownStyleData:
                                                ddtheme.dropdownStyleData,
                                          ),
                                        ),
                                      ],
                                    ),
                                  ),
                                  errorWidget(context, provider.localityError),
                                  textControllerWidget(
                                    context,
                                    provider.addressController,
                                    "Address",
                                    "Enter Address",
                                    provider.updateAddress,
                                    TextInputType.text,
                                    false,
                                    null,
                                    focusNodes[5],
                                    null,
                                    TextInputAction.done,
                                  ),
                                  errorWidget(context, provider.addressError),
                                  Text(
                                    "Bank Details",
                                    style: TextStyle(
                                      color: AppColors.app_blue,
                                      fontSize: 16,
                                      fontFamily: "JakartaMedium",
                                    ),
                                  ),
                                  textControllerWidget(
                                    context,
                                    provider.bankNameController,
                                    "Bank Name",
                                    "Enter Bank Name",
                                    provider.updateBankName,
                                    TextInputType.text,
                                    false,
                                    null,
                                    focusNodes[6],
                                    focusNodes[7],
                                    TextInputAction.next,
                                  ),
                                  errorWidget(context, provider.banknameError),
                                  textControllerWidget(
                                    context,
                                    provider.branchNameController,
                                    "Bank Branch",
                                    "Enter Bank Branch",
                                    provider.updateBankBranch,
                                    TextInputType.text,
                                    false,
                                    null,
                                    focusNodes[7],
                                    focusNodes[8],
                                    TextInputAction.next,
                                  ),
                                  errorWidget(
                                    context,
                                    provider.bankBranchError,
                                  ),
                                  textControllerWidget(
                                    context,
                                    provider.bankIfscCotroller,
                                    "Bank IFSC",
                                    "Enter Bank IFSC",
                                    provider.updateIFSC,
                                    TextInputType.text,
                                    false,
                                    null,
                                    focusNodes[8],
                                    focusNodes[9],
                                    TextInputAction.next,
                                  ),
                                  errorWidget(context, provider.bankIFSCError),
                                  textControllerWidget(
                                    context,
                                    provider.bankHolderNameController,
                                    "Bank Holder Name",
                                    "Enter Bank Holder Name",
                                    provider.updateHolder,
                                    TextInputType.text,
                                    false,
                                    null,
                                    focusNodes[9],
                                    focusNodes[10],
                                    TextInputAction.next,
                                  ),
                                  errorWidget(
                                    context,
                                    provider.bankHolderNameError,
                                  ),
                                  textControllerWidget(
                                    context,
                                    provider.bankAcNumberController,
                                    "Bank Account Number",
                                    "Enter Bank Account Number",
                                    provider.updateNumber,
                                    TextInputType.number,
                                    false,
                                    FilteringTextInputFormatter.digitsOnly,
                                    focusNodes[10],
                                    focusNodes[11],
                                    TextInputAction.next,
                                  ),
                                  errorWidget(
                                    context,
                                    provider.bankAcNumberError,
                                  ),
                                  textControllerWidget(
                                    context,
                                    provider.bankUpiController,
                                    "Bank UPI ID",
                                    "Enter Bank UPI ID",
                                    provider.updateUPI,
                                    TextInputType.text,
                                    false,
                                    null,
                                    focusNodes[11],
                                    focusNodes[12],
                                    TextInputAction.next,
                                  ),
                                  errorWidget(context, provider.upiError),
                                ],
                              ),
                            ),
                            Container(
                              margin: EdgeInsets.symmetric(
                                horizontal: 10,
                                vertical: 10,
                              ),
                              padding: EdgeInsets.symmetric(
                                horizontal: 10,
                                vertical: 10,
                              ),
                              decoration: BoxDecoration(
                                color: Colors.white,
                                borderRadius: BorderRadius.circular(16),
                              ),
                              child: Column(
                                crossAxisAlignment: CrossAxisAlignment.start,
                                children: [
                                  Text(
                                    "Contact Details",
                                    style: TextStyle(
                                      color: AppColors.app_blue,
                                      fontSize: 16,
                                      fontFamily: "JakartaMedium",
                                    ),
                                  ),

                                  textControllerWidget(
                                    context,
                                    provider.contectPersonDesignationController,
                                    "Contact Person Designation",
                                    "Enter Contact Person Designation",
                                    provider.updateDesignation,
                                    TextInputType.text,
                                    false,
                                    null,
                                    focusNodes[13],
                                    focusNodes[14],
                                    TextInputAction.next,
                                  ),
                                  errorWidget(
                                    context,
                                    provider.desigantionError,
                                  ),
                                  textControllerWidget(
                                    context,
                                    provider.contectPersonAltMobController,
                                    "Alternative Mobile Number",
                                    "Enter Alternative Mobile Number",
                                    (p0) {
                                      provider.updateAltMobile(p0);
                                      provider.checkInputsAPI(
                                        context,
                                        "mob2",
                                        provider
                                            .contectPersonAltMobController
                                            .text,
                                      );
                                    },
                                    TextInputType.number,
                                    false,
                                    FilteringTextInputFormatter.digitsOnly,
                                    focusNodes[14],
                                    focusNodes[15],
                                    TextInputAction.next,
                                    10,
                                  ),
                                  errorWidget(context, provider.altMobError),
                                  textControllerWidget(
                                    context,
                                    provider.contectPersonTeleController,
                                    "Telephone Number",
                                    "Enter Telephone Number",
                                    provider.updateTeleMobile,
                                    TextInputType.number,
                                    false,
                                    FilteringTextInputFormatter.digitsOnly,
                                    focusNodes[15],
                                    focusNodes[16],
                                    TextInputAction.next,
                                  ),
                                  errorWidget(context, provider.teleError),
                                  textControllerWidget(
                                    context,
                                    provider.contectPersonMailController,
                                    "Customer Mail ID",
                                    "Enter Customer Mail ID",
                                    provider.updateMail,
                                    TextInputType.text,
                                    false,
                                    null,
                                    focusNodes[16],
                                    focusNodes[17],
                                    TextInputAction.next,
                                  ),
                                  errorWidget(context, provider.mailError),
                                ],
                              ),
                            ),
                          ],
                        ),
                      ),
                    ],
                  ),
                ],
              ),
            ),
          ),

          bottomNavigationBar: InkResponse(
            onTap:
                provider.submitClickced
                    ? null
                    : () {
                      provider.submitClickced = true;
                      provider.submitCommonAccountsAPI(context, widget.from);
                    },
            child: Container(
              height: 45,
              alignment: Alignment.center,
              margin: EdgeInsets.symmetric(horizontal: 10, vertical: 15),
              padding: EdgeInsets.symmetric(horizontal: 10, vertical: 5),
              decoration: BoxDecoration(
                color: AppColors.app_blue,
                borderRadius: BorderRadius.circular(15),
              ),
              child:
                  provider.submitClickced
                      ? CircularProgressIndicator.adaptive(
                        valueColor: AlwaysStoppedAnimation(AppColors.white),
                      )
                      : Text(
                        "Submit",
                        style: TextStyle(
                          fontSize: 15,
                          fontFamily: "JakartaMedium",
                          color: Colors.white,
                        ),
                      ),
            ),
          ),
        );
      },
    );
  }
}
