import 'dart:io';

import 'package:flutter/material.dart';
import 'package:flutter_svg/svg.dart';
import 'package:generp/Notifiers/UpdatePasswordProvider.dart';
import 'package:generp/Utils/app_colors.dart';
import 'package:generp/Utils/commonWidgets.dart';
import 'package:provider/provider.dart';

class UpdatePassword extends StatelessWidget {
  const UpdatePassword({super.key});

  @override
  Widget build(BuildContext context) {
    final provider = Provider.of<UpdatePasswordProvider>(context);

    return WillPopScope(
      onWillPop: () => onBackPressed(context),
      child: SafeArea(
        top: false,
        bottom: Platform.isIOS ? false : true,
        child: Scaffold(
          resizeToAvoidBottomInset: true,
          appBar: appbar(context, "Update Password"),
          backgroundColor: AppColors.scaffold_bg_color,
          body: Container(
            child: Column(
              children: [
                Expanded(
                  child: Container(
                    width: double.infinity,
                    decoration: BoxDecoration(
                      borderRadius: BorderRadius.vertical(
                        top: Radius.circular(30.0),
                      ),
                    ),
                    padding: EdgeInsets.all(10),
                    child: Column(
                      children: [
                        Container(
                          height: 280,
                          decoration: BoxDecoration(
                            color: Colors.white,
                            borderRadius: BorderRadius.circular(20.0),
                          ),
                          child: Column(
                            children: [
                              SizedBox(height: 10),
                              Container(
                                alignment: Alignment.topLeft,
                                padding: EdgeInsets.symmetric(horizontal: 10),
                                child: Text(
                                  "New Password",
                                  style: TextStyle(color: AppColors.semi_black),
                                ),
                              ),
                              SizedBox(height: 5),
                              _buildTextField(
                                controller: provider.password,
                                hintText: "New Password*",
                                errorText: provider.passwordError,
                                obscureText: !provider.pwdVisible,
                                suffixIcon: IconButton(
                                  icon:
                                      provider.pwdVisible
                                          ? SvgPicture.asset(
                                            width: 35,
                                            height: 35,
                                            "assets/svg/password_visible.svg",
                                          )
                                          : SvgPicture.asset(
                                            width: 35,
                                            height: 35,
                                            "assets/svg/password_invisible.svg",
                                          ),
                                  onPressed: () {
                                    provider.pwdVisibility();
                                  },
                                ),
                                onChanged: provider.onChangePassword,
                              ),
                              SizedBox(height: 10),
                              Container(
                                alignment: Alignment.topLeft,
                                padding: EdgeInsets.symmetric(horizontal: 10),
                                child: Text(
                                  "Confirm Password",
                                  style: TextStyle(color: AppColors.semi_black),
                                ),
                              ),
                              SizedBox(height: 5),
                              _buildTextField(
                                controller: provider.confPassword,
                                hintText: "Confirm New Password*",
                                errorText: provider.confirmPasswordError,
                                obscureText: !provider.confPwdVisible,
                                suffixIcon: IconButton(
                                  iconSize: 30,
                                  icon:
                                      provider.confPwdVisible
                                          ? SvgPicture.asset(
                                            width: 35,
                                            height: 35,
                                            "assets/svg/password_visible.svg",
                                          )
                                          : SvgPicture.asset(
                                            width: 35,
                                            height: 35,
                                            "assets/svg/password_invisible.svg",
                                          ),
                                  onPressed: () {
                                    provider.confPwdVisibility();
                                  },
                                ),
                                onChanged: provider.onChangeConfPassword,
                              ),
                              Spacer(),
                              InkWell(
                                onTap: () => provider.updatePassword(context),
                                child: Container(
                                  alignment: Alignment.center,
                                  height: 45,
                                  margin: EdgeInsets.symmetric(horizontal: 15),
                                  decoration: BoxDecoration(
                                    color: AppColors.app_blue,
                                    borderRadius: BorderRadius.circular(15.0),
                                  ),
                                  child:
                                      provider.isLoading
                                          ? CircularProgressIndicator(
                                            color: Colors.white,
                                            padding: EdgeInsets.all(7.5),
                                          )
                                          : Text(
                                            "Update",
                                            style: TextStyle(
                                              color: Colors.white,
                                            ),
                                          ),
                                ),
                              ),
                              SizedBox(height: 10),
                            ],
                          ),
                        ),
                      ],
                    ),
                  ),
                ),
              ],
            ),
          ),
        ),
      ),
    );
  }

  Widget _buildTextField({
    required TextEditingController controller,
    required String hintText,
    Function(String)? onChanged,
    required bool obscureText,
    required suffixIcon,
    String? errorText,
  }) {
    return Column(
      children: [
        Container(
          height: 55,
          margin: EdgeInsets.symmetric(horizontal: 15),
          decoration: BoxDecoration(
            color: AppColors.text_field_color,
            borderRadius: BorderRadius.circular(15),
          ),
          alignment: Alignment.center,
          child: Padding(
            padding: const EdgeInsets.symmetric(horizontal: 10),
            child: TextField(
              onChanged: onChanged,
              controller: controller,
              obscureText: obscureText,
              decoration: InputDecoration(
                hintText: hintText,
                hintStyle: TextStyle(color: Color(0xFF818181), fontSize: 14),
                border: InputBorder.none,
                suffixIcon: suffixIcon,
              ),
            ),
          ),
        ),
        if (errorText != null)
          Container(
            alignment: Alignment.topLeft,
            margin: EdgeInsets.only(top: 2.5, left: 25),
            child: Text(
              errorText,
              style: TextStyle(color: Colors.red, fontSize: 10),
            ),
          ),
      ],
    );
  }
}
