import 'package:dropdown_button2/dropdown_button2.dart';
import 'package:flutter/material.dart';
import 'package:flutter_svg/svg.dart';

import 'app_colors.dart';

class Dropdowntheme {
  final buttonStyleData = ButtonStyleData(
    height: 50,
    width: 160,
    padding: const EdgeInsets.only(left: 14, right: 14),
    decoration: BoxDecoration(
      borderRadius: BorderRadius.circular(14),
      color: AppColors.text_field_color,
    ),
  );
  final iconStyleData = IconStyleData(
    icon: SvgPicture.asset(
      "assets/svg/arrow_dropdown.svg",
      height: 25,
      width: 20,
    ),
    iconSize: 12,
    iconEnabledColor: Color(0xFF2D2D2D),
    iconDisabledColor: Colors.grey,
  );
  final dropdownStyleData = DropdownStyleData(
    maxHeight: 200,
    decoration: BoxDecoration(
      borderRadius: BorderRadius.circular(14),
      color: AppColors.text_field_color,
    ),
    scrollbarTheme: ScrollbarThemeData(
      radius: const Radius.circular(15),
      thickness: WidgetStateProperty.all<double>(6),
      thumbVisibility: WidgetStateProperty.all<bool>(true),
    ),
  );
  final menuItemStyleData = const MenuItemStyleData(
    height: 40,
    padding: EdgeInsets.only(left: 14, right: 14),
  );
}
