class crmLeadDetailsGenerateQuotationViewResponse {
  QuoteDetails? quoteDetails;
  List<LeadProducts>? leadProducts;
  List<Products>? products;
  String? error;
  String? message;
  int? sessionExists;

  crmLeadDetailsGenerateQuotationViewResponse({
    this.quoteDetails,
    this.leadProducts,
    this.products,
    this.error,
    this.message,
    this.sessionExists,
  });

  crmLeadDetailsGenerateQuotationViewResponse.fromJson(
    Map<String, dynamic> json,
  ) {
    quoteDetails =
        json['quote_details'] != null
            ? QuoteDetails.fromJson(json['quote_details'])
            : null;
    if (json['lead_products'] != null) {
      leadProducts = <LeadProducts>[];
      json['lead_products'].forEach((v) {
        leadProducts!.add(LeadProducts.fromJson(v));
      });
    }
    if (json['products'] != null) {
      products = <Products>[];
      json['products'].forEach((v) {
        products!.add(Products.fromJson(v));
      });
    }
    error = json['error'];
    message = json['message'];
    sessionExists = json['session_exists'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    if (quoteDetails != null) {
      data['quote_details'] = quoteDetails!.toJson();
    }
    if (leadProducts != null) {
      data['lead_products'] = leadProducts!.map((v) => v.toJson()).toList();
    }
    if (products != null) {
      data['products'] = products!.map((v) => v.toJson()).toList();
    }
    data['error'] = error;
    data['message'] = message;
    data['session_exists'] = sessionExists;
    return data;
  }
}

class QuoteDetails {
  String? accountId;
  String? name;
  String? email;
  String? mobile;
  String? subject;
  String? forText;
  String? paymentTerms;

  QuoteDetails({
    this.accountId,
    this.name,
    this.email,
    this.mobile,
    this.subject,
    this.forText,
    this.paymentTerms,
  });

  QuoteDetails.fromJson(Map<String, dynamic> json) {
    accountId = json['account_id'];
    name = json['name'];
    email = json['email'];
    mobile = json['mobile'];
    subject = json['subject'];
    forText = json['for_text'];
    paymentTerms = json['payment_terms'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['account_id'] = accountId;
    data['name'] = name;
    data['email'] = email;
    data['mobile'] = mobile;
    data['subject'] = subject;
    data['for_text'] = forText;
    data['payment_terms'] = paymentTerms;
    return data;
  }
}

class LeadProducts {
  String? id;
  String? leadId;
  String? productId;
  String? qty;
  String? price;
  String? date;
  String? isDel;
  String? isExists;
  String? createdDatetime;
  String? updatedDatetime;
  String? prodTotalPrice;
  String? productName;

  LeadProducts({
    this.id,
    this.leadId,
    this.productId,
    this.qty,
    this.price,
    this.date,
    this.isDel,
    this.isExists,
    this.createdDatetime,
    this.updatedDatetime,
    this.prodTotalPrice,
    this.productName,
  });

  LeadProducts.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    leadId = json['lead_id'];
    productId = json['product_id'];
    qty = json['qty'];
    price = json['price'];
    date = json['date'];
    isDel = json['is_del'];
    isExists = json['is_exists'];
    createdDatetime = json['created_datetime'];
    updatedDatetime = json['updated_datetime'];
    prodTotalPrice = json['prod_total_price'];
    productName = json['product_name'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['lead_id'] = leadId;
    data['product_id'] = productId;
    data['qty'] = qty;
    data['price'] = price;
    data['date'] = date;
    data['is_del'] = isDel;
    data['is_exists'] = isExists;
    data['created_datetime'] = createdDatetime;
    data['updated_datetime'] = updatedDatetime;
    data['prod_total_price'] = prodTotalPrice;
    data['product_name'] = productName;
    return data;
  }
}

class Products {
  String? id;
  String? name;

  Products({this.id, this.name});

  Products.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    name = json['name'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['name'] = name;
    return data;
  }
}
