class crmLeadDetailsEditProductsViewResponse {
  List<Products>? products;
  List<LeadProducts>? leadProducts;
  String? error;
  String? message;
  int? sessionExists;

  crmLeadDetailsEditProductsViewResponse({
    this.products,
    this.leadProducts,
    this.error,
    this.message,
    this.sessionExists,
  });

  crmLeadDetailsEditProductsViewResponse.fromJson(Map<String, dynamic> json) {
    if (json['products'] != null) {
      products = <Products>[];
      json['products'].forEach((v) {
        products!.add(Products.fromJson(v));
      });
    }
    if (json['lead_products'] != null) {
      leadProducts = <LeadProducts>[];
      json['lead_products'].forEach((v) {
        leadProducts!.add(LeadProducts.fromJson(v));
      });
    }
    error = json['error'];
    message = json['message'];
    sessionExists = json['session_exists'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    if (products != null) {
      data['products'] = products!.map((v) => v.toJson()).toList();
    }
    if (leadProducts != null) {
      data['lead_products'] = leadProducts!.map((v) => v.toJson()).toList();
    }
    data['error'] = error;
    data['message'] = message;
    data['session_exists'] = sessionExists;
    return data;
  }
}

class Products {
  String? id;
  String? name;

  Products({this.id, this.name});

  Products.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    name = json['name'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['name'] = name;
    return data;
  }
}

class LeadProducts {
  String? id;
  String? leadId;
  String? productId;
  String? qty;
  String? price;
  String? date;
  String? isDel;
  String? isExists;
  String? createdDatetime;
  String? updatedDatetime;
  String? productName;
  String? remarks;

  LeadProducts({
    this.id,
    this.leadId,
    this.productId,
    this.qty,
    this.price,
    this.date,
    this.isDel,
    this.isExists,
    this.createdDatetime,
    this.updatedDatetime,
    this.productName,
    this.remarks
  });

  LeadProducts.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    leadId = json['lead_id'];
    productId = json['product_id'];
    qty = json['qty'];
    price = json['price'];
    date = json['date'];
    isDel = json['is_del'];
    isExists = json['is_exists'];
    createdDatetime = json['created_datetime'];
    updatedDatetime = json['updated_datetime'];
    productName = json['product_name'];
    remarks = json["remarks"];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['lead_id'] = leadId;
    data['product_id'] = productId;
    data['qty'] = qty;
    data['price'] = price;
    data['date'] = date;
    data['is_del'] = isDel;
    data['is_exists'] = isExists;
    data['created_datetime'] = createdDatetime;
    data['updated_datetime'] = updatedDatetime;
    data['product_name'] = productName;
    data['remarks'] = remarks;
    return data;
  }
}
