import 'package:flutter/foundation.dart';
import 'package:generp/Notifiers/HomeScreenNotifier.dart';
import 'package:generp/services/api_calling.dart';
import 'package:provider/provider.dart';

import '../../Models/commonModels/commonAccessiblePagesResponse.dart';

class Commonpagesprovider extends ChangeNotifier {
  List<PagesAccessible> _accessPages = [];
  List<PagesAccessible> get accessPages => _accessPages;

  Future<void> commonAccessPagesAPIFunction(context) async {
    try {
      var HomeProv = Provider.of<HomescreenNotifier>(context, listen: false);
      final data = await ApiCalling.commonDashboardPagesAPI(
        HomeProv.empId,
        HomeProv.session,
      );
      if (data != null) {
        if (data.error == "0") {
          _accessPages = data.pagesAccessible!;
          notifyListeners();
        }
      }
    } catch (e) {}
  }
}
