class tourExpensesListResponse {
  List<TourList>? tourList;
  String? error;
  String? message;
  int? sessionExists;

  tourExpensesListResponse({
    this.tourList,
    this.error,
    this.message,
    this.sessionExists,
  });

  tourExpensesListResponse.fromJson(Map<String, dynamic> json) {
    if (json['tour_list'] != null) {
      tourList = <TourList>[];
      json['tour_list'].forEach((v) {
        tourList!.add(TourList.fromJson(v));
      });
    }
    error = json['error'];
    message = json['message'];
    sessionExists = json['session_exists'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    if (tourList != null) {
      data['tour_list'] = tourList!.map((v) => v.toJson()).toList();
    }
    data['error'] = error;
    data['message'] = message;
    data['session_exists'] = sessionExists;
    return data;
  }
}

class TourList {
  String? id;
  String? placeOfVisit;
  String? appliedDate;
  String? fromDate;
  String? toDate;
  String? type;
  String? appliedAmount;
  String? approvedAmount;
  String? approvalStatus;

  TourList({
    this.id,
    this.placeOfVisit,
    this.appliedDate,
    this.fromDate,
    this.toDate,
    this.type,
    this.appliedAmount,
    this.approvedAmount,
    this.approvalStatus,
  });

  TourList.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    placeOfVisit = json['place_of_visit'];
    appliedDate = json['applied_date'];
    fromDate = json['from_date'];
    toDate = json['to_date'];
    type = json['type'];
    appliedAmount = json['applied_amount'];
    approvedAmount = json['approved_amount'];
    approvalStatus = json['approval_status'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['place_of_visit'] = placeOfVisit;
    data['applied_date'] = appliedDate;
    data['from_date'] = fromDate;
    data['to_date'] = toDate;
    data['type'] = type;
    data['applied_amount'] = appliedAmount;
    data['approved_amount'] = approvedAmount;
    data['approval_status'] = approvalStatus;
    return data;
  }
}
