class NearbyGeneratorsResponse {
  List<Nearbygenerators>? list;
  int? error;
  int? sessionExists;

  NearbyGeneratorsResponse({this.list, this.error, this.sessionExists});

  NearbyGeneratorsResponse.fromJson(Map<String, dynamic> json) {
    if (json['list'] != null) {
      list = <Nearbygenerators>[];
      json['list'].forEach((v) {
        list!.add(Nearbygenerators.fromJson(v));
      });
    }
    error = json['error'];
    sessionExists = json['session_exists'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    if (list != null) {
      data['list'] = list!.map((v) => v.toJson()).toList();
    }
    data['error'] = error;
    data['session_exists'] = sessionExists;
    return data;
  }
}

class Nearbygenerators {
  String? generatorId;
  String? loc;
  String? productName;
  String? accName;
  String? distance;

  Nearbygenerators({
    this.generatorId,
    this.loc,
    this.productName,
    this.accName,
    this.distance,
  });

  Nearbygenerators.fromJson(Map<String, dynamic> json) {
    generatorId = json['generator_id'];
    loc = json['loc'];
    productName = json['product_name'];
    accName = json['acc_name'];
    distance = json['distance'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['generator_id'] = generatorId;
    data['loc'] = loc;
    data['product_name'] = productName;
    data['acc_name'] = accName;
    data['distance'] = distance;
    return data;
  }
}
