import 'dart:io';

import 'package:connectivity_plus/connectivity_plus.dart';
import 'package:dropdown_button2/dropdown_button2.dart';
import 'package:flutter/material.dart';
import 'package:flutter_svg/svg.dart';
import 'package:generp/Utils/dropdownTheme.dart';
import 'package:generp/screens/notifierExports.dart';
import 'package:generp/Utils/commonWidgets.dart';
import 'package:provider/provider.dart';

import '../../Models/loadGeneratorDetailsResponse.dart';
import '../../Utils/app_colors.dart';
import '../../Utils/commonServices.dart';

class Registercomplaint extends StatefulWidget {
  const Registercomplaint({super.key});

  @override
  State<Registercomplaint> createState() => _RegistercomplaintState();
}

class _RegistercomplaintState extends State<Registercomplaint> {
  Map _source = {ConnectivityResult.mobile: true};
  final MyConnectivity _connectivity = MyConnectivity.instance;

  TextEditingController running_hrs = TextEditingController();
  TextEditingController Complaint_Note = TextEditingController();
  Dropdowntheme ddtheme = Dropdowntheme();

  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    _connectivity.initialise();
    _connectivity.myStream.listen((source) {
      setState(() => _source = source);
    });
  }

  @override
  void dispose() {
    // TODO: implement dispose
    super.dispose();
    _connectivity.disposeStream();
  }

  @override
  Widget build(BuildContext context) {
    switch (_source.keys.toList()[0]) {
      case ConnectivityResult.mobile:
        connection = 'Online';
        break;
      case ConnectivityResult.wifi:
        connection = 'Online';
        break;
      case ConnectivityResult.none:
      default:
        connection = 'Offline';
    }
    return connection == "Online"
        ? Consumer2<Generatordetailsprovider, HomescreenNotifier>(
          builder: (context, provider, homeProvider, child) {
            return WillPopScope(
              onWillPop: () => onBackPressed(context),
              child: SafeArea(
                top: false,
                bottom: Platform.isIOS ? false : true,
                child: Scaffold(
                  resizeToAvoidBottomInset: true,
                  backgroundColor: AppColors.scaffold_bg_color,
                  appBar: appbar(context, "Register Complaint"),
                  body: Container(
                    child: SingleChildScrollView(
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: [
                          SizedBox(height: 5.0),
                          Container(
                            padding: EdgeInsets.fromLTRB(10, 0, 10, 0),

                            child: Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: [
                                SizedBox(height: 25),
                                Container(
                                  padding: EdgeInsets.symmetric(horizontal: 10),
                                  child: Text(
                                    "Customer Details",
                                    style: TextStyle(
                                      fontFamily: "JakartaMedium",
                                      color: Color(0xFF818181),
                                    ),
                                  ),
                                ),
                                Container(
                                  padding: EdgeInsets.fromLTRB(10, 10, 10, 10),
                                  margin: EdgeInsets.symmetric(
                                    horizontal: 10,
                                    vertical: 5,
                                  ),
                                  decoration: BoxDecoration(
                                    color: Colors.white,
                                    borderRadius: BorderRadius.circular(16),
                                  ),
                                  child: Column(
                                    children: [
                                      Row(
                                        crossAxisAlignment:
                                            CrossAxisAlignment.center,
                                        mainAxisAlignment:
                                            MainAxisAlignment.center,
                                        children: [
                                          Expanded(
                                            flex: 1,
                                            child: SvgPicture.asset(
                                              "assets/svg/se_block_head.svg",
                                            ),
                                          ),
                                          SizedBox(width: 10),

                                          Expanded(
                                            flex: 9,
                                            child: SizedBox(
                                              child: Column(
                                                crossAxisAlignment:
                                                    CrossAxisAlignment.start,
                                                children: [
                                                  Text(
                                                    "${provider.cname}",
                                                    style: TextStyle(
                                                      fontFamily:
                                                          "JakartaMedium",
                                                    ),
                                                  ),
                                                  Text(
                                                    "${provider.aname}",
                                                    maxLines: 2,
                                                    overflow:
                                                        TextOverflow.ellipsis,
                                                    style: TextStyle(
                                                      color: Color(0xFF818181),
                                                    ),
                                                  ),
                                                  // Text("Gen Pvt. Ltd"),
                                                ],
                                              ),
                                            ),
                                          ),
                                        ],
                                      ),
                                      Divider(
                                        thickness: 0.5,
                                        color: Color(0xFFD7D7D7),
                                      ),
                                      ...List.generate(2, (j) {
                                        final textheads = [
                                          "Product Name",
                                          "Engine ID",
                                        ];
                                        final textSubheads = [
                                          provider.spname,
                                          provider.engineNo,
                                        ];
                                        return Container(
                                          padding: EdgeInsets.symmetric(
                                            vertical: 3,
                                          ),
                                          child: Column(
                                            children: [
                                              Row(
                                                mainAxisAlignment:
                                                    MainAxisAlignment
                                                        .spaceBetween,
                                                children: [
                                                  Expanded(
                                                    child: SizedBox(
                                                      child: Column(
                                                        crossAxisAlignment:
                                                            CrossAxisAlignment
                                                                .start,
                                                        children: [
                                                          Text(
                                                            textheads[j]
                                                                .toString(),
                                                            style: TextStyle(
                                                              fontFamily:
                                                                  "JakartaMedium",
                                                            ),
                                                          ),
                                                        ],
                                                      ),
                                                    ),
                                                  ),
                                                  Expanded(
                                                    child: SizedBox(
                                                      child: Column(
                                                        crossAxisAlignment:
                                                            CrossAxisAlignment
                                                                .start,
                                                        children: [
                                                          Text(
                                                            textSubheads[j]
                                                                .toString(),
                                                            style: TextStyle(
                                                              color: Color(
                                                                0xFF818181,
                                                              ),
                                                            ),
                                                          ),
                                                        ],
                                                      ),
                                                    ),
                                                  ),
                                                ],
                                              ),
                                            ],
                                          ),
                                        );
                                      }),
                                      SizedBox(height: 10.0),
                                    ],
                                  ),
                                ),
                                Container(
                                  padding: EdgeInsets.symmetric(horizontal: 10),
                                  child: Text(
                                    "Complaint Details",
                                    style: TextStyle(
                                      fontFamily: "JakartaMedium",
                                      color: Color(0xFF818181),
                                    ),
                                  ),
                                ),
                                Container(
                                  padding: EdgeInsets.fromLTRB(10, 10, 10, 10),
                                  margin: EdgeInsets.symmetric(
                                    horizontal: 10,
                                    vertical: 5,
                                  ),
                                  decoration: BoxDecoration(
                                    color: Colors.white,
                                    borderRadius: BorderRadius.circular(16),
                                  ),
                                  child: Column(
                                    crossAxisAlignment:
                                        CrossAxisAlignment.start,
                                    children: [
                                      Padding(
                                        padding: const EdgeInsets.only(
                                          bottom: 5.0,
                                        ),
                                        child: Text(
                                          "Complaint Type",
                                          style: TextStyle(
                                            fontFamily: "JakartaMedium",
                                          ),
                                        ),
                                      ),
                                      DropdownButtonHideUnderline(
                                        child: Row(
                                          children: [
                                            Expanded(
                                              child: DropdownButton2<
                                                ComplaintTypeList
                                              >(
                                                isExpanded: true,
                                                hint: const Row(
                                                  children: [
                                                    Expanded(
                                                      child: Text(
                                                        'Select Complaint Type',
                                                        style: TextStyle(
                                                          fontSize: 14,
                                                        ),
                                                        overflow:
                                                            TextOverflow
                                                                .ellipsis,
                                                      ),
                                                    ),
                                                  ],
                                                ),
                                                items:
                                                    provider
                                                        .complaintTypeDropdown
                                                        .map(
                                                          (
                                                            complaintType,
                                                          ) => DropdownMenuItem<
                                                            ComplaintTypeList
                                                          >(
                                                            value:
                                                                complaintType,
                                                            child: Text(
                                                              complaintType
                                                                      .name ??
                                                                  '',
                                                              style:
                                                                  const TextStyle(
                                                                    fontSize:
                                                                        14,
                                                                  ),
                                                              overflow:
                                                                  TextOverflow
                                                                      .ellipsis,
                                                            ),
                                                          ),
                                                        )
                                                        .toList(),
                                                value:
                                                    provider
                                                        .selectedComplaintType,
                                                onChanged: (
                                                  ComplaintTypeList? value,
                                                ) {
                                                  if (value != null) {
                                                    if (provider
                                                        .complaintCategorydropdown
                                                        .isNotEmpty) {
                                                      provider.selectedComplaintType =
                                                          value;
                                                      print(
                                                        "Selected Complaint Type: ${value.name}, ID: ${value.id}",
                                                      );
                                                      provider.selectedType =
                                                          value.name;
                                                      provider.selectedTypeId =
                                                          value.id;
                                                      print(
                                                        "hfjkshfg${provider.selectedTypeId}",
                                                      );
                                                    }
                                                  }
                                                },
                                                buttonStyleData:
                                                    ddtheme.buttonStyleData,
                                                iconStyleData:
                                                    ddtheme.iconStyleData,
                                                menuItemStyleData:
                                                    ddtheme.menuItemStyleData,
                                                dropdownStyleData:
                                                    ddtheme.dropdownStyleData,
                                              ),
                                            ),
                                          ],
                                        ),
                                      ),
                                      SizedBox(height: 10.0),
                                      Padding(
                                        padding: const EdgeInsets.only(
                                          bottom: 5.0,
                                        ),
                                        child: Text(
                                          "Complaint Category",
                                          style: TextStyle(
                                            fontFamily: "JakartaMedium",
                                          ),
                                        ),
                                      ),
                                      DropdownButtonHideUnderline(
                                        child: Row(
                                          children: [
                                            Expanded(
                                              child: DropdownButton2<
                                                ComplaintCategoryList
                                              >(
                                                isExpanded: true,
                                                hint: const Row(
                                                  children: [
                                                    Expanded(
                                                      child: Text(
                                                        'Select Complaint Category',
                                                        style: TextStyle(
                                                          fontSize: 14,
                                                        ),
                                                        overflow:
                                                            TextOverflow
                                                                .ellipsis,
                                                      ),
                                                    ),
                                                  ],
                                                ),
                                                items:
                                                    provider
                                                        .complaintCategorydropdown
                                                        .map(
                                                          (
                                                            Category,
                                                          ) => DropdownMenuItem<
                                                            ComplaintCategoryList
                                                          >(
                                                            value: Category,
                                                            child: Text(
                                                              Category.name ??
                                                                  "",
                                                              style:
                                                                  const TextStyle(
                                                                    fontSize:
                                                                        14,
                                                                  ),
                                                              overflow:
                                                                  TextOverflow
                                                                      .ellipsis,
                                                            ),
                                                          ),
                                                        )
                                                        .toList(),
                                                value:
                                                    provider
                                                        .selectedCategoryType,
                                                onChanged: (
                                                  ComplaintCategoryList? value,
                                                ) {
                                                  if (provider
                                                      .complaintCategorydropdown
                                                      .isNotEmpty) {
                                                    provider.selectedCategoryType =
                                                        value;
                                                    provider.selectedCategory =
                                                        value?.name;
                                                    provider.selectedCategoryId =
                                                        value?.id;
                                                  }
                                                },
                                                buttonStyleData:
                                                    ddtheme.buttonStyleData,
                                                iconStyleData:
                                                    ddtheme.iconStyleData,
                                                menuItemStyleData:
                                                    ddtheme.menuItemStyleData,
                                                dropdownStyleData:
                                                    ddtheme.dropdownStyleData,
                                              ),
                                            ),
                                          ],
                                        ),
                                      ),

                                      SizedBox(height: 10.0),
                                      Padding(
                                        padding: const EdgeInsets.only(
                                          bottom: 5.0,
                                        ),
                                        child: Text(
                                          "Select Description",
                                          style: TextStyle(
                                            fontFamily: "JakartaMedium",
                                          ),
                                        ),
                                      ),
                                      DropdownButtonHideUnderline(
                                        child: Row(
                                          children: [
                                            Expanded(
                                              child: DropdownButton2<
                                                ComplaintDescriptionList
                                              >(
                                                isExpanded: true,
                                                hint: const Row(
                                                  children: [
                                                    Expanded(
                                                      child: Text(
                                                        'Select Description',
                                                        style: TextStyle(
                                                          fontSize: 14,
                                                        ),
                                                        overflow:
                                                            TextOverflow
                                                                .ellipsis,
                                                      ),
                                                    ),
                                                  ],
                                                ),
                                                items:
                                                    provider
                                                        .complaintDescriptionDropdown
                                                        .map(
                                                          (
                                                            Description,
                                                          ) => DropdownMenuItem<
                                                            ComplaintDescriptionList
                                                          >(
                                                            value: Description,
                                                            child: Text(
                                                              Description
                                                                      .name ??
                                                                  "",
                                                              style:
                                                                  const TextStyle(
                                                                    fontSize:
                                                                        14,
                                                                  ),
                                                              overflow:
                                                                  TextOverflow
                                                                      .ellipsis,
                                                            ),
                                                          ),
                                                        )
                                                        .toList(),
                                                value:
                                                    provider
                                                        .selectedDescriptionType,
                                                onChanged: (
                                                  ComplaintDescriptionList?
                                                  value,
                                                ) {
                                                  if (provider
                                                      .complaintDescriptionDropdown
                                                      .isNotEmpty) {
                                                    provider.selectedDescriptionType =
                                                        value;
                                                    provider.selectedDescription =
                                                        value?.name;
                                                    provider.selectedDescriptionId =
                                                        value?.id;
                                                  }
                                                },
                                                buttonStyleData:
                                                    ddtheme.buttonStyleData,
                                                iconStyleData:
                                                    ddtheme.iconStyleData,
                                                menuItemStyleData:
                                                    ddtheme.menuItemStyleData,
                                                dropdownStyleData:
                                                    ddtheme.dropdownStyleData,
                                              ),
                                            ),
                                          ],
                                        ),
                                      ),

                                      SizedBox(height: 10.0),
                                      Padding(
                                        padding: const EdgeInsets.only(
                                          bottom: 5.0,
                                        ),
                                        child: Text(
                                          "Duration",
                                          style: TextStyle(
                                            fontFamily: "JakartaMedium",
                                          ),
                                        ),
                                      ),
                                      Container(
                                        height: 50,

                                        alignment: Alignment.center,
                                        decoration: BoxDecoration(
                                          color: AppColors.text_field_color,
                                          borderRadius: BorderRadius.circular(
                                            14,
                                          ),
                                        ),
                                        child: Padding(
                                          padding: const EdgeInsets.fromLTRB(
                                            10.0,
                                            0.0,
                                            10,
                                            0,
                                          ),
                                          child: TextFormField(
                                            controller: running_hrs,
                                            keyboardType: TextInputType.text,
                                            decoration: InputDecoration(
                                              hintText: "Enter Running Number",
                                              hintStyle: TextStyle(
                                                fontWeight: FontWeight.w400,
                                                color: Color(0xFFB4BEC0),
                                                fontSize: 14,
                                              ),

                                              enabledBorder: InputBorder.none,
                                              focusedBorder: InputBorder.none,
                                            ),
                                          ),
                                        ),
                                      ),
                                      SizedBox(height: 10.0),
                                      Padding(
                                        padding: const EdgeInsets.only(
                                          bottom: 5.0,
                                        ),
                                        child: Text(
                                          "Message",
                                          style: TextStyle(
                                            fontFamily: "JakartaMedium",
                                          ),
                                        ),
                                      ),
                                      Container(
                                        height: 150,

                                        alignment: Alignment.center,
                                        decoration: BoxDecoration(
                                          color: AppColors.text_field_color,
                                          borderRadius: BorderRadius.circular(
                                            14,
                                          ),
                                        ),
                                        child: Padding(
                                          padding: const EdgeInsets.fromLTRB(
                                            10.0,
                                            0.0,
                                            10,
                                            0,
                                          ),
                                          child: TextFormField(
                                            maxLines: 6,
                                            controller: Complaint_Note,
                                            keyboardType: TextInputType.text,
                                            decoration: InputDecoration(
                                              hintText: "Enter Message",
                                              hintStyle: TextStyle(
                                                fontWeight: FontWeight.w400,
                                                color: Color(0xFFB4BEC0),
                                                fontSize: 14,
                                              ),

                                              enabledBorder: InputBorder.none,
                                              focusedBorder: InputBorder.none,
                                            ),
                                          ),
                                        ),
                                      ),
                                    ],
                                  ),
                                ),

                                SizedBox(height: 65.0),
                              ],
                            ),
                          ),
                        ],
                      ),
                    ),
                  ),
                  floatingActionButton: Container(
                    child: InkWell(
                      onTap: () {
                        provider.SubmitComplaintFunction(
                          context,
                          homeProvider,
                          provider.genID,
                          provider.selectedTypeId,
                          provider.selectedDescriptionId,
                          running_hrs.text,
                          Complaint_Note.text,
                        );
                      },
                      child: Container(
                        alignment: Alignment.center,
                        height: 45,
                        margin: EdgeInsets.only(left: 15.0, right: 15.0),
                        decoration: BoxDecoration(
                          color: AppColors.app_blue,
                          borderRadius: BorderRadius.circular(10.0),
                        ),
                        child: Text(
                          "Submit Complaint",
                          textAlign: TextAlign.center,
                          style: TextStyle(
                            fontFamily: "JakartaMedium",
                            fontSize: 15,
                            color: Colors.white,
                          ),
                        ),
                      ),
                    ),
                  ),
                  floatingActionButtonLocation:
                      FloatingActionButtonLocation.centerFloat,
                ),
              ),
            );
          },
        )
        : NoNetwork(context);
  }
}
