import 'dart:io';

import 'package:connectivity_plus/connectivity_plus.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:flutter_staggered_grid_view/flutter_staggered_grid_view.dart';
import 'package:flutter_svg/svg.dart';
import 'package:generp/Notifiers/commonProvider/accountsListProvider.dart';
import 'package:generp/Notifiers/financeProvider/DashboardProvider.dart';
import 'package:generp/Notifiers/financeProvider/RequestionListProvider.dart';
import 'package:generp/Notifiers/financeProvider/paymentReceiptsProvider.dart';
import 'package:generp/Utils/GlobalConstants.dart';
import 'package:generp/Utils/app_colors.dart';
import 'package:generp/Utils/commonWidgets.dart';
import 'package:generp/screens/screensExports.dart';
import 'package:provider/provider.dart';

import '../../Utils/commonServices.dart';

class Financedashboard extends StatefulWidget {
  const Financedashboard({super.key});

  @override
  State<Financedashboard> createState() => _FinancedashboardState();
}

class _FinancedashboardState extends State<Financedashboard> {
  Map _source = {ConnectivityResult.mobile: true};
  final MyConnectivity _connectivity = MyConnectivity.instance;

  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    _connectivity.initialise();
    _connectivity.myStream.listen((source) {
      setState(() => _source = source);
    });
    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
      var provider = Provider.of<Dashboardprovider>(context, listen: false);
      provider.DashboardPagesAPIFunction(context);
      provider.addFormfinanceFormAccessPagesAPIFunction(context);
    });
  }

  @override
  void dispose() {
    // TODO: implement dispose
    super.dispose();
    _connectivity.disposeStream();
  }

  @override
  Widget build(BuildContext context) {
    switch (_source.keys.toList()[0]) {
      case ConnectivityResult.mobile:
        connection = 'Online';
        break;
      case ConnectivityResult.wifi:
        connection = 'Online';
        break;
      case ConnectivityResult.none:
      default:
        connection = 'Offline';
    }
    return (connection == "Online")
        ? Platform.isAndroid
            ? WillPopScope(
              onWillPop: () => onBackPressed(context),
              child: SafeArea(
                top: false,
                bottom: true,
                child: _scaffold(context),
              ),
            )
            : _scaffold(context)
        : NoNetwork(context);
  }

  Widget _scaffold(BuildContext context) {
    return Consumer<Dashboardprovider>(
      builder: (context, provider, child) {
        final pages = provider.accessiblePagesList;
        final approvalLevelIcons = [
          "assets/svg/finance/fin_lvl1_ic.svg",
          "assets/svg/finance/fin_lvl2_ic.svg",
          "assets/svg/finance/fin_lvl2_self_ic.svg",
        ];
        final approvalLevelNames = ["Level 1", "Level 2", "Level 2 (Self)"];
        final approvalLevelRoles = [664, 684, 665];
        final approvalModes = ["apr_lvl1", "apr_lvl2", "self_apr_lvl2"];

        final paymentInitiationIcons = [
          "assets/svg/finance/fin_self_ic.svg", //self
          "assets/svg/finance/fin_accounts_ic.svg", //"
        ];
        final paymentInitiationNames = ["Self", "Account List"];
        final paymentInitiationSubtitles = [
          "Payment Requests",
          "Transactions Details",
        ];
        final paymentInitiationRoles = [668, 293];

        final paymentAdministrationIcons = [
          "assets/svg/finance/fin_process_ic.svg",
          "assets/svg/finance/fin_admin_ic.svg",
          "assets/svg/finance/fin_receipts_ic.svg",
          // "assets/svg/finance/fin_ac_ledger_ic.svg",
          "assets/svg/finance/fin_payments_ic.svg",
        ];
        final paymentAdministrationNames = [
          "Process", //process
          "Admin", //admin
          "Receipts List",
          // "Account Ledger",
          "Payment List",
        ];
        final paymentAdministrationSubtitles = [
          "Payment Requests",
          "Payment Requests",
          "Payment Requests",
          // "Ledgers, transactions, finance",
          "Payment Requests",
        ];
        final paymentAdministrationRoles = [
          666, 678, 673,
          // 675,
          667,
        ];

        // Extract role IDs from accessible pages
        final roles = provider.accessiblePagesList.map((e) => e.id).toList();

        // Filter items based on roles
        final filteredApprovalLevels = <Map<String, String>>[];
        for (int i = 0; i < approvalLevelRoles.length; i++) {
          if (roles.contains(approvalLevelRoles[i])) {
            filteredApprovalLevels.add({
              'name': approvalLevelNames[i],
              'icon': approvalLevelIcons[i],
            });
          }
        }

        final filteredPaymentInitiations = <Map<String, String>>[];
        for (int i = 0; i < paymentInitiationRoles.length; i++) {
          if (roles.contains(paymentInitiationRoles[i])) {
            filteredPaymentInitiations.add({
              'name': paymentInitiationNames[i],
              'icon': paymentInitiationIcons[i],
              'subtitle': paymentInitiationSubtitles[i],
            });
          }
        }

        final filteredPaymentAdministrations = <Map<String, String>>[];
        for (int i = 0; i < paymentAdministrationRoles.length; i++) {
          if (roles.contains(paymentAdministrationRoles[i])) {
            filteredPaymentAdministrations.add({
              'name': paymentAdministrationNames[i],
              'icon': paymentAdministrationIcons[i],
              'subtitle': paymentAdministrationSubtitles[i],
            });
          }
        }
        final rolesNames = provider.accessiblePagesList.map((e) => e.pageName);
        final rolesModes = provider.accessiblePagesList.map((e) => e.mode);

        return Scaffold(
          resizeToAvoidBottomInset: true,
          backgroundColor: AppColors.scaffold_bg_color,
          appBar: appbarNew(context, "Finance", 0xFFCEEDFF),
          body: SizedBox(
            child: SingleChildScrollView(
              child: Column(
                children: [
                  Container(
                    height: 200,
                    decoration: BoxDecoration(
                      image: DecorationImage(
                        image: AssetImage(
                          "assets/svg/finance/main_dashboard.png",
                        ),
                        fit: BoxFit.contain,
                      ),
                      gradient: LinearGradient(
                        colors: [
                          Color(0xFFCEEDFF),
                          AppColors.scaffold_bg_color,
                        ],
                        begin: Alignment.topCenter,
                        end: Alignment.bottomCenter,
                      ),
                    ),
                  ),
                  Container(
                    padding: EdgeInsets.symmetric(horizontal: 10),
                    child: Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        if (filteredApprovalLevels.isNotEmpty) ...[
                          Padding(
                            padding: const EdgeInsets.only(top: 10, bottom: 5),
                            child: Text(
                              "Approval Levels",
                              style: TextStyle(
                                color: AppColors.grey_thick,
                                fontSize: 14,
                                fontFamily: "JakartaMedium",
                              ),
                            ),
                          ),
                          Container(
                            padding: EdgeInsets.symmetric(
                              vertical: 10,
                              horizontal: 15,
                            ),
                            decoration: BoxDecoration(
                              color: Colors.white,
                              borderRadius: BorderRadius.circular(14),
                            ),
                            child: Row(
                              mainAxisAlignment: MainAxisAlignment.center,
                              children: List.generate(filteredApprovalLevels.length, (
                                co,
                              ) {
                                return Expanded(
                                  child: InkResponse(
                                    onTap: () async {
                                      HapticFeedback.selectionClick();
                                      Allpaymentrequesitionlistsbymodes
                                      navigate;
                                      navigate = Allpaymentrequesitionlistsbymodes(
                                        mode: approvalModes[co],
                                        pageTitleName:
                                            "Payment Requisition List ${approvalModes[co] == "apr_lvl1"
                                                ? "(Level 1)"
                                                : approvalModes[co] == "apr_lvl2"
                                                ? "(Level 2)"
                                                : "(Self Level 2)"}",
                                      );

                                      await Navigator.push(
                                        context,
                                        MaterialPageRoute(
                                          builder: (context) => navigate,
                                        ),
                                      );
                                    },
                                    child: SizedBox(
                                      child: Column(
                                        crossAxisAlignment:
                                            CrossAxisAlignment.center,
                                        mainAxisAlignment:
                                            MainAxisAlignment.center,
                                        children: [
                                          SvgPicture.asset(
                                            filteredApprovalLevels[co]['icon'] ??
                                                "",
                                          ),
                                          SizedBox(height: 10),
                                          Text(
                                            filteredApprovalLevels[co]['name'] ??
                                                "-",
                                            maxLines: 2,
                                            textAlign: TextAlign.center,
                                            style: TextStyle(
                                              fontSize: 12,
                                              fontFamily: "JakartaMedium",
                                            ),
                                          ),
                                        ],
                                      ),
                                    ),
                                  ),
                                );
                              }),
                            ),
                          ),
                        ],

                        if (filteredPaymentInitiations.isNotEmpty) ...[
                          Padding(
                            padding: const EdgeInsets.only(top: 10, bottom: 5),
                            child: Text(
                              "Payment Initiation",
                              style: TextStyle(
                                color: AppColors.grey_thick,
                                fontSize: 14,
                                fontFamily: "JakartaMedium",
                              ),
                            ),
                          ),
                          GridView.builder(
                            shrinkWrap: true,
                            padding: EdgeInsets.only(bottom: 0),

                            itemCount: filteredPaymentInitiations.length,
                            physics: NeverScrollableScrollPhysics(),
                            gridDelegate:
                                SliverGridDelegateWithMaxCrossAxisExtent(
                                  childAspectRatio: 1,
                                  mainAxisExtent: 100,
                                  maxCrossAxisExtent:
                                      MediaQuery.of(context).size.width * 0.5,
                                ),
                            itemBuilder: (context, ini) {
                              return InkResponse(
                                onTap: () async {
                                  HapticFeedback.selectionClick();
                                  var navigate;
                                  if (ini == 0) {
                                    navigate = await Navigator.push(
                                      context,
                                      MaterialPageRoute(
                                        builder:
                                            (
                                              context,
                                            ) => Allpaymentrequesitionlistsbymodes(
                                              mode: "self",
                                              pageTitleName:
                                                  "Payment Requisition List (Self)",
                                            ),
                                      ),
                                    );
                                  } else {
                                    navigate = await Navigator.push(
                                      context,
                                      MaterialPageRoute(
                                        builder: (context) => Accountslist(),
                                      ),
                                    );
                                  }
                                },
                                child: Container(
                                  padding: EdgeInsets.symmetric(
                                    vertical: 5,
                                    horizontal: 15,
                                  ),
                                  margin: EdgeInsets.symmetric(
                                    vertical: 7,
                                    horizontal: 5,
                                  ),
                                  decoration: BoxDecoration(
                                    color: Colors.white,
                                    borderRadius: BorderRadius.circular(14),
                                  ),
                                  child: Row(
                                    mainAxisAlignment: MainAxisAlignment.center,
                                    crossAxisAlignment:
                                        CrossAxisAlignment.center,
                                    children: [
                                      Expanded(
                                        flex: 2,
                                        child: SizedBox(
                                          child: Column(
                                            crossAxisAlignment:
                                                CrossAxisAlignment.start,
                                            mainAxisAlignment:
                                                MainAxisAlignment.center,
                                            children: [
                                              Text(
                                                filteredPaymentInitiations[ini]['name'] ??
                                                    "-",
                                                style: TextStyle(
                                                  fontSize: 14,
                                                  color: AppColors.app_blue,
                                                  fontFamily: "JakartaMedium",
                                                ),
                                              ),
                                              Text(
                                                filteredPaymentInitiations[ini]['subtitle'] ??
                                                    "-",
                                                style: TextStyle(
                                                  fontSize: 12,
                                                  color: AppColors.grey_semi,
                                                  fontFamily: "JakartaMedium",
                                                ),
                                              ),
                                            ],
                                          ),
                                        ),
                                      ),
                                      SizedBox(width: 10),
                                      Expanded(
                                        flex: 1,
                                        child: SvgPicture.asset(
                                          filteredPaymentInitiations[ini]['icon'] ??
                                              "",
                                        ),
                                      ),
                                    ],
                                  ),
                                ),
                              );
                            },
                          ),
                        ],

                        if (filteredPaymentAdministrations.isNotEmpty) ...[
                          Padding(
                            padding: const EdgeInsets.only(top: 10, bottom: 5),
                            child: Text(
                              "Payment Administration",
                              style: TextStyle(
                                color: AppColors.grey_thick,
                                fontSize: 14,
                                fontFamily: "JakartaMedium",
                              ),
                            ),
                          ),
                          GridView.builder(
                            itemCount: filteredPaymentAdministrations.length,
                            physics: NeverScrollableScrollPhysics(),
                            shrinkWrap: true,
                            gridDelegate:
                                SliverGridDelegateWithFixedCrossAxisCount(
                                  crossAxisCount: 2,
                                  childAspectRatio: 2 / 1.1,
                                ),
                            itemBuilder: (context, ad) {
                              return InkResponse(
                                onTap: () async {
                                  HapticFeedback.selectionClick();
                                  var navigate;
                                  if (ad == 0) {
                                    navigate = await Navigator.push(
                                      context,
                                      MaterialPageRoute(
                                        builder:
                                            (
                                              context,
                                            ) => Allpaymentrequesitionlistsbymodes(
                                              mode: "process",
                                              pageTitleName:
                                                  "Payment Requisition List (Process)",
                                            ),
                                      ),
                                    );
                                  } else if (ad == 1) {
                                    navigate = await Navigator.push(
                                      context,
                                      MaterialPageRoute(
                                        builder:
                                            (
                                              context,
                                            ) => Allpaymentrequesitionlistsbymodes(
                                              mode: "admin",
                                              pageTitleName:
                                                  "Payment Requisition List (Admin)",
                                            ),
                                      ),
                                    );
                                  } else if (ad == 2) {
                                    navigate = await Navigator.push(
                                      context,
                                      MaterialPageRoute(
                                        builder:
                                            (context) => Paymentreceiptlist(
                                              pageTitleName:
                                                  "Payment Receipt List",
                                            ),
                                      ),
                                    );
                                  }
                                  // else if (ad == 3) {
                                  //   navigate = await Navigator.push(
                                  //     context,
                                  //     MaterialPageRoute(
                                  //       builder: (context) => Accountledger(),
                                  //     ),
                                  //   );
                                  // }
                                  else {
                                    navigate = await Navigator.push(
                                      context,
                                      MaterialPageRoute(
                                        builder:
                                            (context) =>
                                                Paymentlistpaymentrequisition(
                                                  pageTitleName:
                                                      "Payments List",
                                                ),
                                      ),
                                    );
                                  }
                                },
                                child: Container(
                                  padding: EdgeInsets.symmetric(
                                    vertical: 5,
                                    horizontal: 15,
                                  ),
                                  margin: EdgeInsets.symmetric(
                                    vertical: 7,
                                    horizontal: 5,
                                  ),
                                  decoration: BoxDecoration(
                                    color: Colors.white,
                                    borderRadius: BorderRadius.circular(14),
                                  ),
                                  child: Row(
                                    mainAxisAlignment: MainAxisAlignment.center,
                                    crossAxisAlignment:
                                        CrossAxisAlignment.center,
                                    children: [
                                      Expanded(
                                        flex: 2,
                                        child: SizedBox(
                                          child: Column(
                                            crossAxisAlignment:
                                                CrossAxisAlignment.start,
                                            mainAxisAlignment:
                                                MainAxisAlignment.center,
                                            children: [
                                              Text(
                                                filteredPaymentAdministrations[ad]['name'] ??
                                                    "-",
                                                style: TextStyle(
                                                  fontSize: 14,
                                                  color: AppColors.app_blue,
                                                  fontFamily: "JakartaMedium",
                                                ),
                                              ),
                                              Text(
                                                filteredPaymentAdministrations[ad]['subtitle'] ??
                                                    "-",
                                                maxLines: 2,
                                                style: TextStyle(
                                                  fontSize: 12,
                                                  color: AppColors.grey_semi,
                                                  fontFamily: "JakartaMedium",
                                                ),
                                              ),
                                            ],
                                          ),
                                        ),
                                      ),
                                      SizedBox(width: 10),
                                      Expanded(
                                        flex: 1,
                                        child: SvgPicture.asset(
                                          filteredPaymentAdministrations[ad]['icon'] ??
                                              "",
                                        ),
                                      ),
                                    ],
                                  ),
                                ),
                              );
                            },
                          ),
                        ],
                        SizedBox(height: 100),

                        // ListView.builder(
                        //   itemCount: pages.length,
                        //   shrinkWrap: true,
                        //   physics: NeverScrollableScrollPhysics(),
                        //   itemBuilder: (context, index) {
                        //     Widget? SvgIcon;
                        //     switch (pages[index].mode) {
                        //       case "apr_lvl1":
                        //         SvgIcon = SvgPicture.asset("assets/svg/fin_lv1.svg");
                        //         break;
                        //       case "apr_lvl2":
                        //         SvgIcon = SvgPicture.asset("assets/svg/fin_lv2.svg");
                        //         break;
                        //       // final icons = ["comm_ic_1", "comm_ic_2"];
                        //       case "self_apr_lvl2":
                        //         SvgIcon = SvgPicture.asset("assets/svg/fin_lv2.svg");
                        //         break;
                        //       default:
                        //         SvgIcon = SvgPicture.asset("assets/svg/fin_ic.svg");
                        //         break;
                        //     }
                        //     return InkResponse(
                        //       onTap: () async {
                        //         var navigate;
                        //         if (pages[index].pageName == "Payments List") {
                        //           navigate = Paymentlistpaymentrequisition(
                        //             pageTitleName:
                        //                 provider.accessiblePagesList[index].pageName!,
                        //           );
                        //         } else if (provider
                        //                 .accessiblePagesList[index]
                        //                 .pageName ==
                        //             "Payment Receipts List") {
                        //           navigate = Paymentreceiptlist(
                        //             pageTitleName:
                        //                 provider.accessiblePagesList[index].pageName!,
                        //           );
                        //         } else if (provider
                        //                 .accessiblePagesList[index]
                        //                 .pageName ==
                        //             "Account List") {
                        //           navigate = Accountslist();
                        //
                        //           // break;
                        //         } else if (provider
                        //                 .accessiblePagesList[index]
                        //                 .pageName ==
                        //             "Account Ledger") {
                        //           navigate = Accountledger();
                        //         } else {
                        //           navigate = Allpaymentrequesitionlistsbymodes(
                        //             mode: pages[index].mode!,
                        //             pageTitleName:
                        //                 provider.accessiblePagesList[index].pageName!,
                        //           );
                        //         }
                        //         await Navigator.push(
                        //           context,
                        //           MaterialPageRoute(builder: (context) => navigate),
                        //         );
                        //       },
                        //       child: Container(
                        //         margin: EdgeInsets.symmetric(
                        //           horizontal: 5,
                        //           vertical: 5,
                        //         ),
                        //         padding: EdgeInsets.symmetric(
                        //           horizontal: 10,
                        //           vertical: 15,
                        //         ),
                        //         decoration: BoxDecoration(
                        //           color: Colors.white,
                        //           borderRadius: BorderRadius.circular(14),
                        //         ),
                        //         child: Row(
                        //           children: [
                        //             if (provider
                        //                     .accessiblePagesList[index]
                        //                     .pageName ==
                        //                 "Account List") ...[
                        //               Expanded(
                        //                 flex: 1,
                        //                 child: SvgPicture.asset(
                        //                   "assets/svg/comm_ic_1.svg",
                        //                   width: 25,
                        //                 ),
                        //               ),
                        //             ] else if (provider
                        //                     .accessiblePagesList[index]
                        //                     .pageName ==
                        //                 "Account Ledger") ...[
                        //               Expanded(
                        //                 flex: 1,
                        //                 child: SvgPicture.asset(
                        //                   "assets/svg/comm_ic_2.svg",
                        //                   width: 25,
                        //                 ),
                        //               ),
                        //             ] else ...[
                        //               Expanded(flex: 1, child: SvgIcon),
                        //             ],
                        //             Expanded(
                        //               flex: 5,
                        //               child: Text("${pages[index].pageName}"),
                        //             ),
                        //             Expanded(
                        //               flex: 1,
                        //               child: SvgPicture.asset(
                        //                 "assets/svg/arrow_right_new.svg",
                        //               ),
                        //             ),
                        //           ],
                        //         ),
                        //       ),
                        //     );
                        //   },
                        // ),
                      ],
                    ),
                  ),
                ],
              ),
            ),
          ),
          floatingActionButtonLocation:
              FloatingActionButtonLocation.centerFloat,
          floatingActionButton: InkResponse(
            onTap: () {
              HapticFeedback.selectionClick();
              _showPaymentOptionsSheet(context);
            },
            child: Container(
              height: 45,
              alignment: Alignment.center,
              margin: EdgeInsets.symmetric(horizontal: 10),
              padding: EdgeInsets.symmetric(horizontal: 10, vertical: 5),
              decoration: BoxDecoration(
                color: AppColors.app_blue,
                borderRadius: BorderRadius.circular(15),
              ),
              child: Text(
                "Add",
                style: TextStyle(
                  fontSize: 15,
                  fontFamily: "JakartaMedium",
                  color: Colors.white,
                ),
              ),
            ),
          ),
        );
      },
    );
  }

  Future<void> _showPaymentOptionsSheet(BuildContext context) {
    return showModalBottomSheet(
      useSafeArea: true,
      isDismissible: true,
      isScrollControlled: true,
      showDragHandle: true,
      backgroundColor: Colors.white,
      enableDrag: true,
      context: context,
      builder: (context) {
        return StatefulBuilder(
          builder: (context, setState) {
            return SafeArea(
              child: Consumer<Dashboardprovider>(
                builder: (context, provider, child) {
                  final pages2 = provider.accessiblePagesList2;
                  return Container(
                    margin: EdgeInsets.only(
                      bottom: 15,
                      left: 15,
                      right: 15,
                      top: 10,
                    ),
                    padding: EdgeInsets.only(
                      bottom: MediaQuery.of(context).viewInsets.bottom,
                    ),
                    child: SingleChildScrollView(
                      child: Column(
                        mainAxisSize: MainAxisSize.min,
                        children: [
                          SizedBox(height: 15),

                          ...List.generate(pages2.length, (index) {
                            print(pages2[index].mode);
                            // List<String> mode_lst = [
                            //   "self",
                            //   "other",
                            //   "process",
                            //   "admin",
                            //   "direct",
                            //   "admin"
                            // ];
                            // final Headingnames = [
                            //   "Add Self Payment Requisition",
                            //   "Add Other Payment Requisition",
                            //   "Add Processed Payment Requisition",
                            //   "Add Admin Payment Requisition",
                            //   "Add Direct Payment",
                            //   "Add Account"
                            // ];
                            final icons = [
                              "assets/svg/finance/fin_self_ic.svg",
                              "assets/svg/finance/fin_admin_ic.svg",
                              "assets/svg/finance/fin_process_ic.svg",
                              "assets/svg/finance/other_payment_ic.svg",
                              "assets/svg/finance/fin_receipts_ic.svg",
                              "assets/svg/finance/fin_payments_ic.svg",
                              "assets/svg/finance/fin_accounts_ic.svg",
                            ];
                            return ListTile(
                              onTap: () async {
                                HapticFeedback.selectionClick();
                                var res;
                                if (provider
                                        .accessiblePagesList2[index]
                                        .pageName ==
                                    "Add Direct Payment") {
                                  res = await Navigator.push(
                                    context,
                                    MaterialPageRoute(
                                      builder:
                                          (
                                            context,
                                          ) => Directpaymentrequesitionlist(
                                            pageTitleName:
                                                provider
                                                    .accessiblePagesList2[index]
                                                    .pageName!,
                                          ),
                                      settings: RouteSettings(
                                        name: "Directpaymentrequesitionlist",
                                      ),
                                    ),
                                  );
                                } else if (provider
                                        .accessiblePagesList2[index]
                                        .pageName ==
                                    "Add Payment Receipt") {
                                  res = await Navigator.push(
                                    context,
                                    MaterialPageRoute(
                                      builder:
                                          (context) => Addpaymentreceiptlist(
                                            pageTitleName:
                                                provider
                                                    .accessiblePagesList2[index]
                                                    .pageName!,
                                          ),
                                      settings: RouteSettings(
                                        name: "Addpaymentreceiptlist",
                                      ),
                                    ),
                                  );
                                } else if (provider
                                    .accessiblePagesList2[index]
                                    .pageName!
                                    .contains("Add Account")) {
                                  res = await Navigator.push(
                                    context,
                                    MaterialPageRoute(
                                      builder:
                                          (context) => Addcommonpayment(
                                            from: "Dashboard",
                                          ),
                                      settings: RouteSettings(
                                        name: "Addcommonpayment",
                                      ),
                                    ),
                                  );
                                } else {
                                  res = await Navigator.push(
                                    context,
                                    MaterialPageRoute(
                                      builder:
                                          (context) =>
                                              Submitpaymentrequestionlistsbymode(
                                                mode: "${pages2[index].mode}",
                                                pageTitleName:
                                                    "${pages2[index].pageName}",
                                              ),
                                      settings: RouteSettings(
                                        name:
                                            "Submitpaymentrequestionlistsbymode",
                                      ),
                                    ),
                                  );
                                }
                                switch (routeSettingName) {
                                  case "Submitpaymentrequestionlistsbymode":
                                    print("here");
                                    Provider.of<Requestionlistprovider>(
                                      context,
                                      listen: false,
                                    ).resetForm();
                                    break;
                                  case "Addcommonpayment":
                                    Provider.of<Accountslistprovider>(
                                      context,
                                      listen: false,
                                    ).resetValues();
                                    break;
                                  case "Addpaymentreceiptlist":
                                    Provider.of<Paymentreceiptsprovider>(
                                      context,
                                      listen: false,
                                    ).resetForm();
                                    break;
                                  case "Directpaymentrequesitionlist":
                                    Provider.of<Requestionlistprovider>(
                                      context,
                                      listen: false,
                                    ).resetForm();
                                    break;
                                }
                                Navigator.pop(context);
                              },
                              leading: SvgPicture.asset(icons[index]),
                              title: Text(
                                "${pages2[index].pageName}",
                                style: TextStyle(
                                  fontSize: 14,
                                  fontFamily: "JakartaMedium",
                                ),
                              ),
                              trailing: SvgPicture.asset(
                                "assets/svg/arrow_right_new.svg",
                              ),
                            );
                          }),
                        ],
                      ),
                    ),
                  );
                },
              ),
            );
          },
        );
      },
    );
  }
}
