import 'package:flutter/cupertino.dart';
import 'package:flutter/foundation.dart';
import 'package:provider/provider.dart';
import '../../Models/crmModels/ProspectListViewResponse.dart';
import '../../Models/crmModels/SubmitProspectListFilterResponse.dart';
import '../../services/api_calling.dart';
import '../HomeScreenNotifier.dart';

class ProspectListProvider extends ChangeNotifier {
  TextEditingController searchController = TextEditingController();
  TextEditingController mobileNumberController = TextEditingController();
  TextEditingController companyNameController = TextEditingController(
    text: "a",
  );

  bool _isLoading = true;

  List<Employees> _employeesList = [];
  List<AccountsList> _accountList = [];

  Employees? _selectedEmployees;

  String? _selectedEmployeeId;
  String? _selectedEmployeeValue;

  bool get isLoading => _isLoading;

  List<Employees> get employeesList => _employeesList;
  List<AccountsList> get accountList => _accountList;

  Employees? get selectedEmployees => _selectedEmployees;

  String? get selectedEmployeeId => _selectedEmployeeId;

  String? get selectedEmployeeValue => _selectedEmployeeValue;

  set isLoading(bool value) {
    _isLoading = value;
    notifyListeners();
  }

  set selectedEmployees(Employees? value) {
    _selectedEmployees = value;
    _selectedEmployeeId = value!.id!;
    _selectedEmployeeValue = value.name;
    notifyListeners();
  }

  set selectedEmployeeId(String? value) {
    _selectedEmployeeId = value;
    notifyListeners();
  }

  set selectedEmployeeValue(String? value) {
    _selectedEmployeeValue = value;
    notifyListeners();
  }

  Future<void> crmProspectListViewAPIFunction(context, mode) async {
    try {
      var HomeProv = Provider.of<HomescreenNotifier>(context, listen: false);
      final data = await ApiCalling.crmProspectListViewAPI(
        HomeProv.empId,
        HomeProv.session,
        mode,
      );
      if (data != null) {
        print(data.error);
        if (data.error == "0") {
          _employeesList = data.employees!;
          checkDropDownValues();
          // print(_leadStatusList);
          notifyListeners();
        }
      }
    } catch (e) {}
  }

  Future<void> crmProspectListAPIFunction(context, mode, employeeID) async {
    try {
      _accountList.clear();
      notifyListeners();
      var HomeProv = Provider.of<HomescreenNotifier>(context, listen: false);
      final data = await ApiCalling.crmProspectListFilterSubmitAPI(
        HomeProv.empId,
        HomeProv.session,
        mode,
        employeeID,
        mobileNumberController.text,
        companyNameController.text,
        "1",
      );
      if (data != null) {
        _isLoading = true;
        notifyListeners();
        if (data.error == "0") {
          _accountList = data.accountsList!;
          _isLoading = false;
          checkDropDownValues();
          notifyListeners();
        } else {
          _isLoading = false;
          notifyListeners();
        }
      } else {
        _isLoading = false;
        notifyListeners();
      }
    } catch (e) {
      _isLoading = false;
      notifyListeners();
    }
  }

  onChangedLeadId(value) {
    notifyListeners();
  }

  onChangedMobileNum(value) {
    notifyListeners();
  }

  onChangedCompanyName(value) {
    notifyListeners();
  }

  void resetForm() {
    _isLoading = false;
    mobileNumberController.clear();
    companyNameController.clear();
    searchController.clear();
    companyNameController.text = "a";
    _selectedEmployees = null;

    _selectedEmployeeId = null;

    _selectedEmployeeValue = null;

    checkDropDownValues();
    notifyListeners();
  }

  void checkDropDownValues() {
    if (!_employeesList.contains(_selectedEmployees) &&
        _selectedEmployees != null) {
      _selectedEmployeeId = null;
      _selectedEmployeeValue = null;
    }
    notifyListeners();
  }
}
