class ordersListByModeResponse {
  List<OrderList>? orderList;
  String? error;
  String? message;

  ordersListByModeResponse({this.orderList, this.error, this.message});

  ordersListByModeResponse.fromJson(Map<String, dynamic> json) {
    if (json['order_list'] != null) {
      orderList = <OrderList>[];
      json['order_list'].forEach((v) {
        orderList!.add(OrderList.fromJson(v));
      });
    }
    error = json['error'];
    message = json['message'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    if (orderList != null) {
      data['order_list'] = orderList!.map((v) => v.toJson()).toList();
    }
    data['error'] = error;
    data['message'] = message;
    return data;
  }
}

class OrderList {
  String? orderId;
  String? orderNumber;
  String? refType;
  String? totalAmount;
  String? paidAmount;
  String? balanceAmount;
  String? otp;
  String? orderReceivedDate;
  String? scheduledDispatchDate;
  String? status;
  String? createdDatetime;
  String? updatedDatetime;
  String? accountName;
  String? paymentAmount;
  String? enteredEmpName;
  String? salesPersonEmpName;
  String? tpcAgentName;
  String? requestedTpcAmount;
  String? tpcApplicable;
  String? level1TpcApprovedAmount;
  String? level2TpcApprovedAmount;
  String? tpcStatus;
  String? latestFeedback;
  String? feedbackDate;
  String? feedbackEmpName;

  OrderList({
    this.orderId,
    this.orderNumber,
    this.refType,
    this.totalAmount,
    this.paidAmount,
    this.balanceAmount,
    this.otp,
    this.orderReceivedDate,
    this.scheduledDispatchDate,
    this.status,
    this.createdDatetime,
    this.updatedDatetime,
    this.accountName,
    this.paymentAmount,
    this.enteredEmpName,
    this.salesPersonEmpName,
    this.tpcAgentName,
    this.requestedTpcAmount,
    this.tpcApplicable,
    this.level1TpcApprovedAmount,
    this.level2TpcApprovedAmount,
    this.tpcStatus,
    this.latestFeedback,
    this.feedbackDate,
    this.feedbackEmpName,
  });

  OrderList.fromJson(Map<String, dynamic> json) {
    orderId = json['order_id'];
    orderNumber = json['order_number'];
    refType = json['ref_type'];
    totalAmount = json['total_amount'];
    paidAmount = json['paid_amount'];
    balanceAmount = json['balance_amount'];
    otp = json['otp'];
    orderReceivedDate = json['order_received_date'];
    scheduledDispatchDate = json['scheduled_dispatch_date'];
    status = json['status'];
    createdDatetime = json['created_datetime'];
    updatedDatetime = json['updated_datetime'];
    accountName = json['account_name'];
    paymentAmount = json['payment_amount'];
    enteredEmpName = json['entered_emp_name'];
    salesPersonEmpName = json['sales_person_emp_name'];
    tpcAgentName = json['tpc_agent_name'];
    requestedTpcAmount = json['requested_tpc_amount'];
    tpcApplicable = json['tpc_applicable'];
    level1TpcApprovedAmount = json['level1_tpc_approved_amount'];
    level2TpcApprovedAmount = json['level2_tpc_approved_amount'];
    tpcStatus = json['tpc_status'];
    latestFeedback = json['latest_feedback'];
    feedbackDate = json['feedback_date'];
    feedbackEmpName = json['feedback_emp_name'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['order_id'] = orderId;
    data['order_number'] = orderNumber;
    data['ref_type'] = refType;
    data['total_amount'] = totalAmount;
    data['paid_amount'] = paidAmount;
    data['balance_amount'] = balanceAmount;
    data['otp'] = otp;
    data['order_received_date'] = orderReceivedDate;
    data['scheduled_dispatch_date'] = scheduledDispatchDate;
    data['status'] = status;
    data['created_datetime'] = createdDatetime;
    data['updated_datetime'] = updatedDatetime;
    data['account_name'] = accountName;
    data['payment_amount'] = paymentAmount;
    data['entered_emp_name'] = enteredEmpName;
    data['sales_person_emp_name'] = salesPersonEmpName;
    data['tpc_agent_name'] = tpcAgentName;
    data['requested_tpc_amount'] = requestedTpcAmount;
    data['tpc_applicable'] = tpcApplicable;
    data['level1_tpc_approved_amount'] = level1TpcApprovedAmount;
    data['level2_tpc_approved_amount'] = level2TpcApprovedAmount;
    data['tpc_status'] = tpcStatus;
    data['latest_feedback'] = latestFeedback;
    data['feedback_date'] = feedbackDate;
    data['feedback_emp_name'] = feedbackEmpName;
    return data;
  }
}
