class TPCAgentDetailsResponse {
  TpcAgentDetails? tpcAgentDetails;
  List<TpcRequestedAmounts>? tpcRequestedAmounts;
  String? error;
  String? message;

  TPCAgentDetailsResponse({
    this.tpcAgentDetails,
    this.tpcRequestedAmounts,
    this.error,
    this.message,
  });

  TPCAgentDetailsResponse.fromJson(Map<String, dynamic> json) {
    tpcAgentDetails =
        json['tpc_agent_details'] != null
            ? TpcAgentDetails.fromJson(json['tpc_agent_details'])
            : null;
    if (json['tpc_requested_amounts'] != null) {
      tpcRequestedAmounts = <TpcRequestedAmounts>[];
      json['tpc_requested_amounts'].forEach((v) {
        tpcRequestedAmounts!.add(TpcRequestedAmounts.fromJson(v));
      });
    }
    error = json['error'];
    message = json['message'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    if (tpcAgentDetails != null) {
      data['tpc_agent_details'] = tpcAgentDetails!.toJson();
    }
    if (tpcRequestedAmounts != null) {
      data['tpc_requested_amounts'] =
          tpcRequestedAmounts!.map((v) => v.toJson()).toList();
    }
    data['error'] = error;
    data['message'] = message;
    return data;
  }
}

class TpcAgentDetails {
  String? id;
  String? name;
  String? mobileNumber;
  String? idProofDirFilePath;
  String? idProofViewFileName;
  String? bankName;
  String? bankBeneficiaryName;
  String? bankAccountNo;
  String? bankIfscCode;
  String? note;
  String? enteredEmpId;
  String? isExists;
  String? createdDatetime;
  String? updatedDatetime;
  String? tpcAgentId;
  String? enteredEmployee;

  TpcAgentDetails({
    this.id,
    this.name,
    this.mobileNumber,
    this.idProofDirFilePath,
    this.idProofViewFileName,
    this.bankName,
    this.bankBeneficiaryName,
    this.bankAccountNo,
    this.bankIfscCode,
    this.note,
    this.enteredEmpId,
    this.isExists,
    this.createdDatetime,
    this.updatedDatetime,
    this.tpcAgentId,
    this.enteredEmployee,
  });

  TpcAgentDetails.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    name = json['name'];
    mobileNumber = json['mobile_number'];
    idProofDirFilePath = json['id_proof_dir_file_path'];
    idProofViewFileName = json['id_proof_view_file_name'];
    bankName = json['bank_name'];
    bankBeneficiaryName = json['bank_beneficiary_name'];
    bankAccountNo = json['bank_account_no'];
    bankIfscCode = json['bank_ifsc_code'];
    note = json['note'];
    enteredEmpId = json['entered_emp_id'];
    isExists = json['is_exists'];
    createdDatetime = json['created_datetime'];
    updatedDatetime = json['updated_datetime'];
    tpcAgentId = json['tpc_agent_id'];
    enteredEmployee = json['entered_employee'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['name'] = name;
    data['mobile_number'] = mobileNumber;
    data['id_proof_dir_file_path'] = idProofDirFilePath;
    data['id_proof_view_file_name'] = idProofViewFileName;
    data['bank_name'] = bankName;
    data['bank_beneficiary_name'] = bankBeneficiaryName;
    data['bank_account_no'] = bankAccountNo;
    data['bank_ifsc_code'] = bankIfscCode;
    data['note'] = note;
    data['entered_emp_id'] = enteredEmpId;
    data['is_exists'] = isExists;
    data['created_datetime'] = createdDatetime;
    data['updated_datetime'] = updatedDatetime;
    data['tpc_agent_id'] = tpcAgentId;
    data['entered_employee'] = enteredEmployee;
    return data;
  }
}

class TpcRequestedAmounts {
  String? id;
  String? name;
  String? mobileNumber;
  String? idProofDirFilePath;
  String? idProofViewFileName;
  String? bankName;
  String? bankBeneficiaryName;
  String? bankAccountNo;
  String? bankIfscCode;
  String? note;
  String? enteredEmpId;
  String? isExists;
  String? createdDatetime;
  String? updatedDatetime;
  String? tpcAgentId;
  String? customerName;
  String? ename;
  String? orderId;
  String? orderNumber;
  String? level1TpcApprovedAmount;
  String? level2TpcApprovedAmount;
  String? tpcStatus;
  String? requestedTpcAmount;
  String? totalAmount;

  TpcRequestedAmounts({
    this.id,
    this.name,
    this.mobileNumber,
    this.idProofDirFilePath,
    this.idProofViewFileName,
    this.bankName,
    this.bankBeneficiaryName,
    this.bankAccountNo,
    this.bankIfscCode,
    this.note,
    this.enteredEmpId,
    this.isExists,
    this.createdDatetime,
    this.updatedDatetime,
    this.tpcAgentId,
    this.customerName,
    this.ename,
    this.orderId,
    this.orderNumber,
    this.level1TpcApprovedAmount,
    this.level2TpcApprovedAmount,
    this.tpcStatus,
    this.requestedTpcAmount,
    this.totalAmount,
  });

  TpcRequestedAmounts.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    name = json['name'];
    mobileNumber = json['mobile_number'];
    idProofDirFilePath = json['id_proof_dir_file_path'];
    idProofViewFileName = json['id_proof_view_file_name'];
    bankName = json['bank_name'];
    bankBeneficiaryName = json['bank_beneficiary_name'];
    bankAccountNo = json['bank_account_no'];
    bankIfscCode = json['bank_ifsc_code'];
    note = json['note'];
    enteredEmpId = json['entered_emp_id'];
    isExists = json['is_exists'];
    createdDatetime = json['created_datetime'];
    updatedDatetime = json['updated_datetime'];
    tpcAgentId = json['tpc_agent_id'];
    customerName = json['customer_name'];
    ename = json['ename'];
    orderId = json['order_id'];
    orderNumber = json['order_number'];
    level1TpcApprovedAmount = json['level1_tpc_approved_amount'];
    level2TpcApprovedAmount = json['level2_tpc_approved_amount'];
    tpcStatus = json['tpc_status'];
    requestedTpcAmount = json['requested_tpc_amount'];
    totalAmount = json['total_amount'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['name'] = name;
    data['mobile_number'] = mobileNumber;
    data['id_proof_dir_file_path'] = idProofDirFilePath;
    data['id_proof_view_file_name'] = idProofViewFileName;
    data['bank_name'] = bankName;
    data['bank_beneficiary_name'] = bankBeneficiaryName;
    data['bank_account_no'] = bankAccountNo;
    data['bank_ifsc_code'] = bankIfscCode;
    data['note'] = note;
    data['entered_emp_id'] = enteredEmpId;
    data['is_exists'] = isExists;
    data['created_datetime'] = createdDatetime;
    data['updated_datetime'] = updatedDatetime;
    data['tpc_agent_id'] = tpcAgentId;
    data['customer_name'] = customerName;
    data['ename'] = ename;
    data['order_id'] = orderId;
    data['order_number'] = orderNumber;
    data['level1_tpc_approved_amount'] = level1TpcApprovedAmount;
    data['level2_tpc_approved_amount'] = level2TpcApprovedAmount;
    data['tpc_status'] = tpcStatus;
    data['requested_tpc_amount'] = requestedTpcAmount;
    data['total_amount'] = totalAmount;
    return data;
  }
}
