class SubmitLeadListFilterResponse {
  String? error;
  List<LeadList>? leadList;
  String? message;

  SubmitLeadListFilterResponse({this.error, this.leadList, this.message});

  SubmitLeadListFilterResponse.fromJson(Map<String, dynamic> json) {
    error = json['error'];
    if (json['lead_list'] != null) {
      leadList = <LeadList>[];
      json['lead_list'].forEach((v) {
        leadList!.add(LeadList.fromJson(v));
      });
    }
    message = json['message'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['error'] = error;
    if (leadList != null) {
      data['lead_list'] = leadList!.map((v) => v.toJson()).toList();
    }
    data['message'] = message;
    return data;
  }
}

class LeadList {
  String? ldate;
  String? stateName;
  String? district;
  String? subLocality;
  String? accman;
  String? accId;
  String? cname;
  String? mob1;
  String? leadid;
  String? status;
  String? openStatus;
  String? address;
  String? aid;
  String? company;
  String? lage;
  String? product;
  String? followupfun;
  Account? account;
  List<Contact>? contact;

  LeadList({
    this.ldate,
    this.stateName,
    this.district,
    this.subLocality,
    this.accman,
    this.accId,
    this.cname,
    this.mob1,
    this.leadid,
    this.status,
    this.openStatus,
    this.address,
    this.aid,
    this.company,
    this.lage,
    this.product,
    this.followupfun,
    this.account,
    this.contact,
  });

  LeadList.fromJson(Map<String, dynamic> json) {
    ldate = json['ldate'];
    stateName = json['state_name'];
    district = json['district'];
    subLocality = json['sub_locality'];
    accman = json['accman'];
    accId = json['acc_id'];
    cname = json['cname'];
    mob1 = json['mob1'];
    leadid = json['leadid'];
    status = json['status'];
    openStatus = json['open_status'];
    address = json['address'];
    aid = json['aid'];
    company = json['company'];
    lage = json['lage'];
    product = json['product'];
    followupfun = json['followupfun'];
    account =
        json['account'] != null ? Account.fromJson(json['account']) : null;
    if (json['contact'] != null) {
      contact = <Contact>[];
      json['contact'].forEach((v) {
        contact!.add(Contact.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['ldate'] = ldate;
    data['state_name'] = stateName;
    data['district'] = district;
    data['sub_locality'] = subLocality;
    data['accman'] = accman;
    data['acc_id'] = accId;
    data['cname'] = cname;
    data['mob1'] = mob1;
    data['leadid'] = leadid;
    data['status'] = status;
    data['open_status'] = openStatus;
    data['address'] = address;
    data['aid'] = aid;
    data['company'] = company;
    data['lage'] = lage;
    data['product'] = product;
    data['followupfun'] = followupfun;
    if (account != null) {
      data['account'] = account!.toJson();
    }
    if (contact != null) {
      data['contact'] = contact!.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class Account {
  String? id;
  String? tempId;
  String? ownerId;
  String? accManagerId;
  String? name;
  String? salutationName;
  String? subLocality;
  String? district;
  String? state;
  String? pincode;
  String? address;
  String? date;
  String? source;
  String? reference;
  String? segment;
  String? team;
  String? gstNumber;
  String? isExists;
  String? createdDatetime;
  String? updatedDatetime;

  Account({
    this.id,
    this.tempId,
    this.ownerId,
    this.accManagerId,
    this.name,
    this.salutationName,
    this.subLocality,
    this.district,
    this.state,
    this.pincode,
    this.address,
    this.date,
    this.source,
    this.reference,
    this.segment,
    this.team,
    this.gstNumber,
    this.isExists,
    this.createdDatetime,
    this.updatedDatetime,
  });

  Account.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    tempId = json['temp_id'];
    ownerId = json['owner_id'];
    accManagerId = json['acc_manager_id'];
    name = json['name'];
    salutationName = json['salutation_name'];
    subLocality = json['sub_locality'];
    district = json['district'];
    state = json['state'];
    pincode = json['pincode'];
    address = json['address'];
    date = json['date'];
    source = json['source'];
    reference = json['reference'];
    segment = json['segment'];
    team = json['team'];
    gstNumber = json['gst_number'];
    isExists = json['is_exists'];
    createdDatetime = json['created_datetime'];
    updatedDatetime = json['updated_datetime'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['temp_id'] = tempId;
    data['owner_id'] = ownerId;
    data['acc_manager_id'] = accManagerId;
    data['name'] = name;
    data['salutation_name'] = salutationName;
    data['sub_locality'] = subLocality;
    data['district'] = district;
    data['state'] = state;
    data['pincode'] = pincode;
    data['address'] = address;
    data['date'] = date;
    data['source'] = source;
    data['reference'] = reference;
    data['segment'] = segment;
    data['team'] = team;
    data['gst_number'] = gstNumber;
    data['is_exists'] = isExists;
    data['created_datetime'] = createdDatetime;
    data['updated_datetime'] = updatedDatetime;
    return data;
  }
}

class Contact {
  String? id;
  String? accId;
  String? name;
  String? salutationName;
  String? mob1;
  String? mob2;
  String? tel;
  String? email;
  String? type;
  String? designation;
  String? date;
  String? isExists;
  String? createdDatetime;
  String? updatedDatetime;

  Contact({
    this.id,
    this.accId,
    this.name,
    this.salutationName,
    this.mob1,
    this.mob2,
    this.tel,
    this.email,
    this.type,
    this.designation,
    this.date,
    this.isExists,
    this.createdDatetime,
    this.updatedDatetime,
  });

  Contact.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    accId = json['acc_id'];
    name = json['name'];
    salutationName = json['salutation_name'];
    mob1 = json['mob1'];
    mob2 = json['mob2'];
    tel = json['tel'];
    email = json['email'];
    type = json['type'];
    designation = json['designation'];
    date = json['date'];
    isExists = json['is_exists'];
    createdDatetime = json['created_datetime'];
    updatedDatetime = json['updated_datetime'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['acc_id'] = accId;
    data['name'] = name;
    data['salutation_name'] = salutationName;
    data['mob1'] = mob1;
    data['mob2'] = mob2;
    data['tel'] = tel;
    data['email'] = email;
    data['type'] = type;
    data['designation'] = designation;
    data['date'] = date;
    data['is_exists'] = isExists;
    data['created_datetime'] = createdDatetime;
    data['updated_datetime'] = updatedDatetime;
    return data;
  }
}
