class VersionsResponse {
  String? latestVersion;
  int? latestVersionCode;
  String? url;
  String? releaseNotes;
  String? iosLatestVersion;
  int? iosLatestVersionCode;
  String? iosUrl;
  String? iosReleaseNotes;

  VersionsResponse({
    this.latestVersion,
    this.latestVersionCode,
    this.url,
    this.releaseNotes,
    this.iosLatestVersion,
    this.iosLatestVersionCode,
    this.iosUrl,
    this.iosReleaseNotes,
  });

  VersionsResponse.fromJson(Map<String, dynamic> json) {
    latestVersion = json['latestVersion'];
    latestVersionCode = json['latestVersionCode'];
    url = json['url'];
    releaseNotes = json['releaseNotes'];
    iosLatestVersion = json['ios_latestVersion'];
    iosLatestVersionCode = json['ios_latestVersionCode'];
    iosUrl = json['ios_url'];
    iosReleaseNotes = json['ios_releaseNotes'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['latestVersion'] = latestVersion;
    data['latestVersionCode'] = latestVersionCode;
    data['url'] = url;
    data['releaseNotes'] = releaseNotes;
    data['ios_latestVersion'] = iosLatestVersion;
    data['ios_latestVersionCode'] = iosLatestVersionCode;
    data['ios_url'] = iosUrl;
    data['ios_releaseNotes'] = iosReleaseNotes;
    return data;
  }
}
