class FollowupListResponse {
  List<Followuplist>? list;
  int? error;
  int? sessionExists;

  FollowupListResponse({this.list, this.error, this.sessionExists});

  FollowupListResponse.fromJson(Map<String, dynamic> json) {
    if (json['list'] != null) {
      list = <Followuplist>[];
      json['list'].forEach((v) {
        list!.add(Followuplist.fromJson(v));
      });
    }
    error = json['error'];
    sessionExists = json['session_exists'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    if (list != null) {
      data['list'] = list!.map((v) => v.toJson()).toList();
    }
    data['error'] = error;
    data['session_exists'] = sessionExists;
    return data;
  }
}

class Followuplist {
  String? id;
  String? empId;
  String? compId;
  String? inTime;
  String? outTime;
  String? feedback;
  String? type;
  String? date;
  String? fsrNo;
  String? fsrExt;
  String? runningHrs;
  String? time;
  String? ename;

  Followuplist({
    this.id,
    this.empId,
    this.compId,
    this.inTime,
    this.outTime,
    this.feedback,
    this.type,
    this.date,
    this.fsrNo,
    this.fsrExt,
    this.runningHrs,
    this.time,
    this.ename,
  });

  Followuplist.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    empId = json['emp_id'];
    compId = json['comp_id'];
    inTime = json['in_time'];
    outTime = json['out_time'];
    feedback = json['feedback'];
    type = json['type'];
    date = json['date'];
    fsrNo = json['fsr_no'];
    fsrExt = json['fsr_ext'];
    runningHrs = json['running_hrs'];
    time = json['time'];
    ename = json['ename'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['emp_id'] = empId;
    data['comp_id'] = compId;
    data['in_time'] = inTime;
    data['out_time'] = outTime;
    data['feedback'] = feedback;
    data['type'] = type;
    data['date'] = date;
    data['fsr_no'] = fsrNo;
    data['fsr_ext'] = fsrExt;
    data['running_hrs'] = runningHrs;
    data['time'] = time;
    data['ename'] = ename;
    return data;
  }
}
