import 'dart:io';

import 'package:connectivity_plus/connectivity_plus.dart';
import 'package:flutter/material.dart';
import 'package:generp/Utils/commonServices.dart';
import 'package:provider/provider.dart';

import '../../Notifiers/GeneratorDetailsProvider.dart';
import '../../Notifiers/HomeScreenNotifier.dart';
import '../../Utils/app_colors.dart';
import '../../Utils/commonWidgets.dart';

class Complainthistory extends StatefulWidget {
  final genHashID;

  const Complainthistory({super.key, required this.genHashID});

  @override
  State<Complainthistory> createState() => _ComplainthistoryState();
}

class _ComplainthistoryState extends State<Complainthistory> {
  Map _source = {ConnectivityResult.mobile: true};
  final MyConnectivity _connectivity = MyConnectivity.instance;

  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    _connectivity.initialise();
    _connectivity.myStream.listen((source) {
      setState(() => _source = source);
    });
    WidgetsBinding.instance.addPostFrameCallback((_) {
      var details = Provider.of<Generatordetailsprovider>(
        context,
        listen: false,
      );
      var homeProvider = Provider.of<HomescreenNotifier>(
        context,
        listen: false,
      );
      details.LoadgeneratorComplaintHistoryApifunction(
        homeProvider,
        context,
        widget.genHashID,
      );
    });
  }

  @override
  void dispose() {
    // TODO: implement dispose
    super.dispose();
    _connectivity.disposeStream();
  }

  @override
  Widget build(BuildContext context) {
    switch (_source.keys.toList()[0]) {
      case ConnectivityResult.mobile:
        connection = 'Online';
        break;
      case ConnectivityResult.wifi:
        connection = 'Online';
        break;
      case ConnectivityResult.none:
      default:
        connection = 'Offline';
    }
    return connection == "Online"
        ? Consumer<Generatordetailsprovider>(
          builder: (context, provider, child) {
            return WillPopScope(
              onWillPop: () => onBackPressed(context),
              child: SafeArea(
                top: false,
                bottom: Platform.isIOS ? false : true,
                child: Scaffold(
                  resizeToAvoidBottomInset: true,
                  appBar: appbar(context, "Complaint History"),
                  backgroundColor: AppColors.scaffold_bg_color,
                  body: Container(
                    child: SingleChildScrollView(
                      child: Column(
                        children: [
                          if (provider.complaintListOther.isNotEmpty) ...[
                            ListView.builder(
                              shrinkWrap: true,
                              physics: NeverScrollableScrollPhysics(),
                              itemCount: provider.complaintListOther.length,
                              itemBuilder: (context, l) {
                                return Column(
                                  crossAxisAlignment: CrossAxisAlignment.start,
                                  children: [
                                    Padding(
                                      padding: const EdgeInsets.only(
                                        left: 8.0,
                                        top: 5.0,
                                      ),
                                      child: Text(
                                        "${provider.complaintListOther[l].compRegdate}",
                                        style: TextStyle(
                                          fontSize: 14,
                                          color: Color(0xFF818181),
                                        ),
                                      ),
                                    ),
                                    Container(
                                      margin: EdgeInsets.symmetric(
                                        horizontal: 10,
                                        vertical: 5,
                                      ),
                                      decoration: BoxDecoration(
                                        color: Colors.white,
                                        borderRadius: BorderRadius.circular(16),
                                      ),
                                      child: Column(
                                        children: [
                                          ...List.generate(4, (jndex) {
                                            final headings = [
                                              "Technician Name",
                                              "Complaint Type",
                                              "Complaint Status",
                                              "Complaint Created By",
                                            ];

                                            final values = [
                                              provider
                                                  .complaintListOther[l]
                                                  .techName,
                                              provider
                                                  .complaintListOther[l]
                                                  .compType,
                                              provider
                                                  .complaintListOther[l]
                                                  .compStatus,
                                              provider
                                                  .complaintListOther[l]
                                                  .createdBy,
                                            ];
                                            return Container(
                                              padding: EdgeInsets.symmetric(
                                                horizontal: 15,
                                                vertical: 6,
                                              ),
                                              child: Row(
                                                crossAxisAlignment:
                                                    CrossAxisAlignment.start,
                                                children: [
                                                  Expanded(
                                                    child: SizedBox(
                                                      child: Text(
                                                        headings[jndex],
                                                        style: TextStyle(
                                                          fontSize: 14,
                                                        ),
                                                      ),
                                                    ),
                                                  ),
                                                  Expanded(
                                                    child: SizedBox(
                                                      child: Text(
                                                        "${values[jndex]}",
                                                        style: TextStyle(
                                                          fontSize: 14,
                                                          color: Color(
                                                            0xFF818181,
                                                          ),
                                                        ),
                                                      ),
                                                    ),
                                                  ),
                                                ],
                                              ),
                                            );
                                          }),
                                        ],
                                      ),
                                    ),
                                  ],
                                );
                              },
                            ),
                          ] else ...[
                            Emptywidget(context),
                          ],
                        ],
                      ),
                    ),
                  ),
                ),
              ),
            );
          },
        )
        : NoNetwork(context);
  }
}
