import 'dart:io';

import 'package:connectivity_plus/connectivity_plus.dart';
import 'package:dotted_line/dotted_line.dart';
import 'package:dropdown_button2/dropdown_button2.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:flutter_svg/svg.dart';
import 'package:generp/Notifiers/crmProvider/crmEditProspectAccountProvider.dart';
import 'package:generp/Notifiers/crmProvider/crmLeadDetailsProvider.dart';
import 'package:generp/Utils/commonServices.dart';
import 'package:generp/Utils/dropdownTheme.dart';
import 'package:generp/screens/crm/prospectContactDetails.dart';
import 'package:generp/screens/crm/prospectLeadDetails.dart';
import 'package:generp/screens/crm/prospectOrderDetails.dart';
import 'package:generp/screens/crm/prospectPaymentDetails.dart';
import 'package:provider/provider.dart';
import 'package:url_launcher/url_launcher.dart';
import '../../Models/crmModels/GetDistrictOnStateResponse.dart';
import '../../Models/crmModels/GetSubLocOnDistrictResponse.dart';
import '../../Models/crmModels/LeadListViewResponse.dart' show Employees;
import '../../Models/crmModels/crmProspectDetailsAddLeadsResponse.dart'
    show LeadEmployees, Products;
import '../../Models/crmModels/crmProspectDetailsEditAccountViewResponse.dart';
import '../../Notifiers/crmProvider/addProspectLeadsProvider.dart';
import '../../Notifiers/crmProvider/crmProspectDetailsProvider.dart';
import '../../Utils/app_colors.dart';
import '../../Utils/commonWidgets.dart';
import '../order/ordersDetailsByModes.dart';
import '../order/paymentDetailsByMode.dart';
import 'LeadDetailsByMode.dart';

class ProspectDetailsByMode extends StatefulWidget {
  final mode;
  final pageTitleName;
  final leadId;

  const ProspectDetailsByMode({
    super.key,
    this.mode,
    this.pageTitleName,
    this.leadId,
  });

  @override
  State<ProspectDetailsByMode> createState() => ProspectDetailsByModeState();
}

class ProspectDetailsByModeState extends State<ProspectDetailsByMode> {
  Dropdowntheme ddtheme = Dropdowntheme();
  Map _source = {ConnectivityResult.mobile: true};
  final MyConnectivity _connectivity = MyConnectivity.instance;

  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    _connectivity.initialise();
    _connectivity.myStream.listen((source) {
      setState(() => _source = source);
    });
    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
      final provider = Provider.of<crmProspectDetailsProvider>(
        context,
        listen: false,
      );
      final editProvider = Provider.of<Crmeditprospectaccountprovider>(
        context,
        listen: false,
      );
      editProvider.crmLeadListViewAPIFunction(context, widget.mode);

      editProvider.crmProspectDetailsEditAccountViewAPIFunction(
        context,
        widget.leadId,
      );
      provider.showMoreDetails = false;
      provider.crmProspectDetailsAPIFunction(context, widget.leadId);
    });
  }

  @override
  void dispose() {
    // TODO: implement dispose
    super.dispose();
    _connectivity.disposeStream();
  }

  void prefill() async {
    final editProvider = Provider.of<Crmeditprospectaccountprovider>(
      context,
      listen: false,
    );

    await editProvider.crmProspectDetailsEditAccountViewAPIFunction(
      context,
      widget.leadId,
    );

    editProvider.editCompanyNameController.text =
        editProvider.accountDetails.name ?? "";
    editProvider.addressController.text =
        editProvider.accountDetails.address ?? "";
    editProvider.pincodeController.text =
        editProvider.accountDetails.pincode ?? "";

    if (editProvider.salutationList.isNotEmpty &&
        editProvider.accountDetails.salutationName != null) {
      editProvider.selectedSalutation =
          editProvider.salutationList.firstWhere(
            (element) => element == editProvider.accountDetails.salutationName,
          ) ??
          editProvider.salutationList.first;
    }

    // print("States:${editProvider.statesList.toList()}");
    if (editProvider.statesList.isNotEmpty &&
        editProvider.accountDetails.state != null) {
      print(editProvider.accountDetails.state);
      final selectedState = editProvider.statesList.firstWhere(
        (element) =>
            element.id!.trim() == editProvider.accountDetails.state!.trim(),
      );

      editProvider.selectedStates = selectedState;
      editProvider.selectedStateId = selectedState.id;
      editProvider.selectedStateValue = selectedState.name;

      await editProvider.crmLeadListDistrictsOnStateAPIFunction(
        context,
        widget.mode,
        editProvider.selectedStateId,
      );
    }

    // Prefill district
    if (editProvider.districtsList.isNotEmpty &&
        editProvider.accountDetails.district != null) {
      final selectedDistrict = editProvider.districtsList.firstWhere(
        (element) =>
            element.id!.trim() == editProvider.accountDetails.district!.trim(),
      );
      editProvider.selectedDistricts = selectedDistrict;
      editProvider.selectedDistrictId = selectedDistrict.id;
      editProvider.selectedDistrictValue = selectedDistrict.district;

      await editProvider.crmLeadListSubLocOnDistrictAPIFunction(
        context,
        widget.mode,
        editProvider.selectedDistrictId,
      );
    }

    if (editProvider.subLocationsList.isNotEmpty &&
        editProvider.accountDetails.subLocality != null) {
      final selectedSubLocation = editProvider.subLocationsList.firstWhere(
        (element) => element.id == editProvider.accountDetails.subLocality,
      );
      editProvider.selectedSubLocations = selectedSubLocation;
      editProvider.selectedSubLocationId = selectedSubLocation.id;
      editProvider.selectedSubLocationValue = selectedSubLocation.subLocality;
    }

    print("Company Name: ${editProvider.editCompanyNameController.text}");
    print("Pincode: ${editProvider.pincodeController.text}");
    print("Address: ${editProvider.addressController.text}");
    print("Selected Salutation: ${editProvider.selectedSalutation}");
    print("Selected State ID: ${editProvider.selectedStateId}");
    print("Selected State Value: ${editProvider.selectedStateValue}");
    print("Selected District ID: ${editProvider.selectedDistrictId}");
    print("Selected District Value: ${editProvider.selectedDistrictValue}");
    print("Selected Sub-Location ID: ${editProvider.selectedSubLocationId}");
    print(
      "Selected Sub-Location Value: ${editProvider.selectedSubLocationValue}",
    );
  }

  @override
  Widget build(BuildContext context) {
    switch (_source.keys.toList()[0]) {
      case ConnectivityResult.mobile:
        connection = 'Online';
        break;
      case ConnectivityResult.wifi:
        connection = 'Online';
        break;
      case ConnectivityResult.none:
      default:
        connection = 'Offline';
    }
    return (connection == "Online")
        ? Platform.isAndroid
            ? WillPopScope(
              onWillPop: () async {
                Provider.of<Addprospectleadsprovider>(
                  context,
                  listen: false,
                ).resetForm();
                return onBackPressed(context);
              },
              child: SafeArea(
                top: false,
                bottom: true,
                child: _scaffold(context),
              ),
            )
            : _scaffold(context)
        : NoNetwork(context);
  }

  Widget _scaffold(BuildContext context) {
    return Consumer3<
      crmProspectDetailsProvider,
      Crmeditprospectaccountprovider,
      Addprospectleadsprovider
    >(
      builder: (context, provider, editProvider, addleadProvider, child) {
        var leadDetails = provider.accountDetails;
        final leadsList = provider.leadList;
        final orderList = provider.ordersList;
        final paymentList = provider.paymentsList;

        var headings1 = ["Account Manager Name", "Account Created By"];
        var subHeadings1 = [
          leadDetails.accManager ?? "-",
          leadDetails.owner ?? "-",
        ];

        var headings2 = [
          "Address",
          "State",
          "District",
          "Sub Locality",
          "PinCode",
        ];
        var subHeadings2 = [
          leadDetails.address ?? "-",
          leadDetails.state ?? "-",
          leadDetails.district ?? "-",
          leadDetails.subLocality ?? "-",
          leadDetails.pincode ?? "-",
        ];
        var headings3 = ["Source", "Reference", "Team", "Segment"];
        var subHeadings3 = [
          leadDetails.source ?? "-",
          leadDetails.reference ?? "-",
          leadDetails.team ?? "-",
          leadDetails.segment ?? "-",
        ];
        var headings4 = ["Lead Age"];
        var subHeadings4 = ["${leadDetails.aage ?? "-"} days old"];

        var leadListNotEmpty = leadsList.isNotEmpty;
        var contactNotEmpty = provider.contactList.isNotEmpty;
        var orderNotEmpty = orderList.isNotEmpty;
        var paymentsNotEmpty = paymentList.isNotEmpty;
        return Scaffold(
          resizeToAvoidBottomInset: true,
          appBar: AppBar(
            backgroundColor: Colors.white,
            automaticallyImplyLeading: false,
            centerTitle: false,

            // elevation: 2.0,
            title: SizedBox(
              child: Row(
                mainAxisAlignment: MainAxisAlignment.start,
                crossAxisAlignment: CrossAxisAlignment.center,
                children: [
                  InkResponse(
                    onTap: () {
                      provider.resetAll();
                      addleadProvider.resetForm();
                      Navigator.pop(context, true);
                    },
                    child: SvgPicture.asset(
                      "assets/svg/appbar_back_button.svg",
                      height: 25,
                    ),
                  ),
                  SizedBox(width: 10),
                  Expanded(
                    flex: 4,
                    child: InkResponse(
                      onTap: () {
                        provider.resetAll();
                        addleadProvider.resetForm();
                        Navigator.pop(context, true);
                      },
                      child: Text(
                        "Account Details",
                        overflow: TextOverflow.ellipsis,
                        maxLines: 1,
                        style: TextStyle(
                          fontSize: 16,
                          height: 1.1,
                          fontFamily: "JakartaSemiBold",
                          color: AppColors.semi_black,
                        ),
                      ),
                    ),
                  ),
                  // Spacer(),
                  // InkResponse(
                  //   onTap: () {
                  //     _showOptionsSheet(context);
                  //   },
                  //   child: SvgPicture.asset(
                  //     "assets/svg/ic_more.svg",
                  //     height: 30,
                  //   ),
                  // ),
                ],
              ),
            ),
            // bottom: PreferredSize(
            //   preferredSize:
            //       provider.showMoreDetails
            //           ? Size.fromHeight(
            //             MediaQuery.of(context).size.height * 0.72,
            //           )
            //           : Size.fromHeight(120),
            //   child:
            // ),
            // shape: RoundedRectangleBorder(
            //   borderRadius: BorderRadius.vertical(
            //     bottom: Radius.circular(30), // Adjust the radius as needed
            //   ),
            // ),
          ),
          backgroundColor: AppColors.scaffold_bg_color,
          body: SingleChildScrollView(
            child: Column(
              children: [
                Card(
                  shape: RoundedRectangleBorder(
                    borderRadius: BorderRadius.only(
                      bottomLeft: Radius.circular(30),
                      bottomRight: Radius.circular(30),
                    ),
                  ),
                  elevation: 2,

                  child: Column(
                    children: [
                      Container(
                        decoration: BoxDecoration(
                          color: Colors.white,
                          borderRadius: BorderRadius.vertical(
                            bottom: Radius.circular(30),
                          ),
                        ),
                        // margin: EdgeInsets.symmetric(vertical: 10, horizontal: 10),
                        padding: EdgeInsets.symmetric(
                          vertical: 10,
                          horizontal: 10,
                        ),
                        child: Column(
                          children: [
                            Row(
                              children: [
                                Expanded(
                                  flex: 1,
                                  child: SizedBox(
                                    height: 50,
                                    width: 35,
                                    child: SvgPicture.asset(
                                      "assets/svg/crm/lead_details_ic.svg",
                                    ),
                                  ),
                                ),
                                SizedBox(width: 10),
                                Expanded(
                                  flex: 4,
                                  child: SizedBox(
                                    child: Column(
                                      crossAxisAlignment:
                                          CrossAxisAlignment.start,
                                      children: [
                                        Text(
                                          "${leadDetails.salutationName ?? "-"}  ${leadDetails.name ?? "-"}",
                                          style: TextStyle(
                                            fontFamily: "JakartaMedium",
                                            fontSize: 14,
                                            color: AppColors.semi_black,
                                          ),
                                        ),
                                      ],
                                    ),
                                  ),
                                ),

                                if (provider.showTransferAccount == "1") ...[
                                  SizedBox(width: 5),
                                  Expanded(
                                    flex: 1,
                                    child: InkResponse(
                                      onTap: () async {
                                        HapticFeedback.selectionClick();
                                        _showTransferAccountSheet(
                                          context,
                                          provider.accountDetails.id!,
                                        );
                                      },
                                      child: Container(
                                        height: 32,
                                        width: 30,
                                        padding: EdgeInsets.all(8.0),
                                        child: SvgPicture.asset(
                                          "assets/svg/transfer_ac.svg",
                                        ),
                                      ),
                                    ),
                                  ),
                                ],
                                SizedBox(width: 5),
                                Expanded(
                                  flex: 1,
                                  child: InkResponse(
                                    onTap: () async {
                                      HapticFeedback.selectionClick();
                                      editProvider.checkDropDownValues();
                                      prefill();
                                      await _showEditAccountSheet(
                                        context,
                                        provider.accountDetails.id!,
                                      );
                                    },
                                    child: Container(
                                      height: 32,
                                      width: 30,
                                      padding: EdgeInsets.all(8.0),
                                      child: SvgPicture.asset(
                                        "assets/svg/crm/lead_details_edit_ic.svg",
                                      ),
                                    ),
                                  ),
                                ),
                              ],
                            ),
                            Visibility(
                              visible: provider.showMoreDetails ? true : false,
                              child: Column(
                                children: [
                                  Container(
                                    padding: EdgeInsets.symmetric(vertical: 4),
                                    child: Row(
                                      children: [
                                        Expanded(
                                          flex: 3,
                                          child: Text(
                                            "Account Details",
                                            style: TextStyle(
                                              fontSize: 14,
                                              fontFamily: "JakartaSemiBold",
                                            ),
                                          ),
                                        ),
                                        Expanded(
                                          flex: 6,
                                          child: DottedLine(
                                            dashGapLength: 4,
                                            dashGapColor: Colors.white,
                                            dashColor: AppColors.grey_semi,
                                            dashLength: 2,
                                            lineThickness: 0.5,
                                          ),
                                        ),
                                      ],
                                    ),
                                  ),
                                  ...List.generate(subHeadings1.length, (j) {
                                    return Container(
                                      padding: EdgeInsets.symmetric(
                                        vertical: 7,
                                      ),
                                      child: Row(
                                        crossAxisAlignment:
                                            CrossAxisAlignment.start,
                                        children: [
                                          Expanded(
                                            child: Text(
                                              headings1[j],
                                              style: TextStyle(
                                                fontFamily: "JakartaRegular",
                                                fontSize: 14,
                                                color: AppColors.semi_black,
                                              ),
                                            ),
                                          ),
                                          Expanded(
                                            child: Text(
                                              subHeadings1[j] == ""
                                                  ? "-"
                                                  : subHeadings1[j],
                                              style: TextStyle(
                                                fontSize: 14,
                                                color: Color(0xFF818181),
                                              ),
                                            ),
                                          ),
                                        ],
                                      ),
                                    );
                                  }),
                                  Container(
                                    padding: EdgeInsets.symmetric(vertical: 4),
                                    child: Row(
                                      children: [
                                        Expanded(
                                          flex: 3,
                                          child: Text(
                                            "Address Details",
                                            style: TextStyle(
                                              fontSize: 14,
                                              fontFamily: "JakartaSemiBold",
                                            ),
                                          ),
                                        ),
                                        Expanded(
                                          flex: 6,
                                          child: DottedLine(
                                            dashGapLength: 4,
                                            dashGapColor: Colors.white,
                                            dashColor: AppColors.grey_semi,
                                            dashLength: 2,
                                            lineThickness: 0.5,
                                          ),
                                        ),
                                      ],
                                    ),
                                  ),
                                  ...List.generate(subHeadings2.length, (j) {
                                    return Container(
                                      padding: EdgeInsets.symmetric(
                                        vertical: 7,
                                      ),
                                      child: Row(
                                        crossAxisAlignment:
                                            CrossAxisAlignment.start,
                                        children: [
                                          Expanded(
                                            child: Text(
                                              headings2[j],
                                              style: TextStyle(
                                                fontFamily: "JakartaRegular",
                                                fontSize: 14,
                                                color: AppColors.semi_black,
                                              ),
                                            ),
                                          ),
                                          Expanded(
                                            child: Text(
                                              subHeadings2[j] == ""
                                                  ? "-"
                                                  : subHeadings2[j],
                                              style: TextStyle(
                                                fontSize: 14,
                                                color: Color(0xFF818181),
                                              ),
                                            ),
                                          ),
                                        ],
                                      ),
                                    );
                                  }),
                                  Container(
                                    padding: EdgeInsets.symmetric(vertical: 4),
                                    child: Row(
                                      children: [
                                        Expanded(
                                          flex: 3,
                                          child: Text(
                                            "Source Details",
                                            style: TextStyle(
                                              fontSize: 14,
                                              fontFamily: "JakartaSemiBold",
                                            ),
                                          ),
                                        ),
                                        Expanded(
                                          flex: 6,
                                          child: DottedLine(
                                            dashGapLength: 4,
                                            dashGapColor: Colors.white,
                                            dashColor: AppColors.grey_semi,
                                            dashLength: 2,
                                            lineThickness: 0.5,
                                          ),
                                        ),
                                      ],
                                    ),
                                  ),
                                  ...List.generate(subHeadings3.length, (j) {
                                    return Container(
                                      padding: EdgeInsets.symmetric(
                                        vertical: 7,
                                      ),
                                      child: Row(
                                        crossAxisAlignment:
                                            CrossAxisAlignment.start,
                                        children: [
                                          Expanded(
                                            child: Text(
                                              headings3[j],
                                              style: TextStyle(
                                                fontFamily: "JakartaRegular",
                                                fontSize: 14,
                                                color: AppColors.semi_black,
                                              ),
                                            ),
                                          ),
                                          Expanded(
                                            child: Text(
                                              subHeadings3[j] == ""
                                                  ? "-"
                                                  : subHeadings3[j],
                                              style: TextStyle(
                                                fontSize: 14,
                                                color: Color(0xFF818181),
                                              ),
                                            ),
                                          ),
                                        ],
                                      ),
                                    );
                                  }),
                                  Container(
                                    padding: EdgeInsets.symmetric(vertical: 4),
                                    child: Row(
                                      children: [
                                        Expanded(
                                          flex: 3,
                                          child: Text(
                                            "Lead Details",
                                            style: TextStyle(
                                              fontSize: 14,
                                              fontFamily: "JakartaSemiBold",
                                            ),
                                          ),
                                        ),
                                        Expanded(
                                          flex: 6,
                                          child: DottedLine(
                                            dashGapLength: 4,
                                            dashGapColor: Colors.white,
                                            dashColor: AppColors.grey_semi,
                                            dashLength: 2,
                                            lineThickness: 0.5,
                                          ),
                                        ),
                                      ],
                                    ),
                                  ),
                                  ...List.generate(subHeadings4.length, (j) {
                                    return Container(
                                      padding: EdgeInsets.symmetric(
                                        vertical: 7,
                                      ),
                                      child: Row(
                                        crossAxisAlignment:
                                            CrossAxisAlignment.start,
                                        children: [
                                          Expanded(
                                            child: Text(
                                              headings4[j],
                                              style: TextStyle(
                                                fontFamily: "JakartaRegular",
                                                fontSize: 14,
                                                color: AppColors.semi_black,
                                              ),
                                            ),
                                          ),
                                          Expanded(
                                            child:
                                                subHeadings4[j] == "Lead Age"
                                                    ? Tooltip(
                                                      triggerMode:
                                                          TooltipTriggerMode
                                                              .tap,

                                                      message:
                                                          "${leadDetails.createdDatetime}",
                                                      child: Text(
                                                        subHeadings4[j] == ""
                                                            ? "-"
                                                            : subHeadings4[j],
                                                        style: TextStyle(
                                                          fontSize: 14,
                                                          color: Color(
                                                            0xFF818181,
                                                          ),
                                                          decorationColor:
                                                              AppColors
                                                                  .grey_semi,
                                                          decoration:
                                                              TextDecoration
                                                                  .underline,
                                                        ),
                                                      ),
                                                    )
                                                    : Text(
                                                      subHeadings4[j] == ""
                                                          ? "-"
                                                          : subHeadings4[j],
                                                      style: TextStyle(
                                                        fontSize: 14,
                                                        color: Color(
                                                          0xFF818181,
                                                        ),
                                                      ),
                                                    ),
                                          ),
                                        ],
                                      ),
                                    );
                                  }),
                                ],
                              ),
                            ),

                            InkResponse(
                              onTap: () async {
                                HapticFeedback.selectionClick();
                                provider.showMoreDetails =
                                    !provider.showMoreDetails;
                              },
                              child: Container(
                                padding: EdgeInsets.symmetric(vertical: 5),
                                child: Row(
                                  crossAxisAlignment: CrossAxisAlignment.center,
                                  mainAxisAlignment: MainAxisAlignment.center,
                                  children: [
                                    Text(
                                      provider.showMoreDetails
                                          ? "Hide Details"
                                          : "View Details",
                                      style: TextStyle(
                                        fontFamily: "JakartaMedium",
                                        fontSize: 14,
                                        color: AppColors.app_blue,
                                      ),
                                    ),
                                    Transform.flip(
                                      flipY:
                                          provider.showMoreDetails
                                              ? true
                                              : false,
                                      child: SvgPicture.asset(
                                        "assets/svg/arrow_dropdown.svg",
                                        height: 25,
                                        width: 20,
                                        color: AppColors.app_blue,
                                      ),
                                    ),
                                  ],
                                ),
                              ),
                            ),
                          ],
                        ),
                      ),
                    ],
                  ),
                ),
                Column(
                  children: [
                    ///Lead Details
                    Container(
                      padding: EdgeInsets.only(
                        left: 10,
                        right: 10,
                        top: 25,
                        bottom: 5,
                      ),
                      child: Row(
                        children: [
                          Expanded(
                            child: Text(
                              textAlign: TextAlign.left,
                              "Lead Details",
                              style: TextStyle(
                                fontFamily: "JakartaMedium",
                                fontSize: 14,
                                color: AppColors.grey_thick,
                              ),
                            ),
                          ),
                          if (leadListNotEmpty) ...[
                            Expanded(
                              child: InkResponse(
                                onTap: () async {
                                  HapticFeedback.selectionClick();
                                  await addleadProvider
                                      .crmProspectDetailsAddLeadsViewAPIFunction(
                                        context,
                                        widget.mode,
                                      );
                                  _showAddLeadsSheet(context, widget.mode);
                                },
                                child: Padding(
                                  padding: const EdgeInsets.all(8.0),
                                  child: Text(
                                    textAlign: TextAlign.right,
                                    "+ Add Lead",
                                    style: TextStyle(
                                      fontFamily: "JakartaMedium",
                                      fontSize: 14,
                                      color: AppColors.app_blue,
                                    ),
                                  ),
                                ),
                              ),
                            ),
                          ],
                        ],
                      ),
                    ),
                    if (leadListNotEmpty) ...[
                      SizedBox(
                        width: double.infinity,
                        height: 210,
                        child: ListView.builder(
                          itemCount: leadsList.length,
                          shrinkWrap: true,
                          physics: AlwaysScrollableScrollPhysics(),
                          scrollDirection: Axis.horizontal,
                          itemBuilder: (context, index) {
                            return InkResponse(
                              onTap: () async {
                                HapticFeedback.selectionClick();
                                var res = await Navigator.push(
                                  context,
                                  MaterialPageRoute(
                                    builder:
                                        (context) => LeadDetailsByMode(
                                          mode: "",
                                          pageTitleName: "Lead Details",
                                          leadId: widget.leadId,
                                        ),
                                  ),
                                );
                                if (res == true) {
                                  provider.crmProspectDetailsAPIFunction(
                                    context,
                                    widget.leadId,
                                  );
                                }
                              },
                              child: Container(
                                height: 210,
                                width: MediaQuery.of(context).size.width * 0.9,

                                margin: EdgeInsets.symmetric(
                                  horizontal: 10,
                                  vertical: 5,
                                ),
                                padding: EdgeInsets.symmetric(
                                  horizontal: 15,
                                  vertical: 10,
                                ),
                                decoration: BoxDecoration(
                                  color: Colors.white,
                                  borderRadius: BorderRadius.circular(20),
                                ),
                                child: Column(
                                  crossAxisAlignment: CrossAxisAlignment.start,
                                  children: [
                                    Row(
                                      mainAxisAlignment:
                                          MainAxisAlignment.start,
                                      crossAxisAlignment:
                                          CrossAxisAlignment.start,
                                      children: [
                                        Expanded(
                                          flex: 1,
                                          child: SvgPicture.asset(
                                            "assets/svg/crm/followup_details_ic.svg",
                                          ),
                                        ),
                                        SizedBox(width: 10),
                                        Expanded(
                                          flex: 4,
                                          child: SizedBox(
                                            child: Column(
                                              // mainAxisAlignment: MainAxisAlignment.start,
                                              crossAxisAlignment:
                                                  CrossAxisAlignment.start,
                                              mainAxisAlignment:
                                                  MainAxisAlignment.start,
                                              children: [
                                                Text(
                                                  "Lead ID",
                                                  style: TextStyle(
                                                    fontFamily: "JakartaMedium",
                                                    fontSize: 14,
                                                    color: AppColors.semi_black,
                                                  ),
                                                ),

                                                Text(
                                                  "${leadsList[index].id}",
                                                  style: TextStyle(
                                                    fontFamily: "JakartaMedium",
                                                    fontSize: 14,
                                                    color: AppColors.grey_semi,
                                                  ),
                                                ),
                                              ],
                                            ),
                                          ),
                                        ),
                                        SizedBox(width: 10),
                                        Expanded(
                                          flex: 4,
                                          child: Container(
                                            decoration: BoxDecoration(
                                              borderRadius:
                                                  BorderRadius.circular(8),
                                              color: Color(0xFFF3FFD5),
                                            ),
                                            padding: EdgeInsets.symmetric(
                                              horizontal: 5,
                                              vertical: 10,
                                            ),
                                            child: Center(
                                              child: Text(
                                                textAlign: TextAlign.right,
                                                leadsList[index].status ?? "-",
                                                style: TextStyle(
                                                  fontFamily: "JakartaMedium",
                                                  fontSize: 14,
                                                  color: Color(0xFF586000),
                                                ),
                                              ),
                                            ),
                                          ),
                                        ),
                                      ],
                                    ),
                                    SizedBox(height: 5),
                                    Container(
                                      padding: EdgeInsets.symmetric(
                                        vertical: 4,
                                      ),
                                      child: Row(
                                        children: [
                                          Expanded(
                                            flex: 3,
                                            child: Text(
                                              "Lead Created",
                                              style: TextStyle(
                                                fontSize: 14,
                                                fontFamily: "JakartaSemiBold",
                                              ),
                                            ),
                                          ),
                                          Expanded(
                                            flex: 6,
                                            child: DottedLine(
                                              dashGapLength: 4,
                                              dashGapColor: Colors.white,
                                              dashColor: AppColors.grey_semi,
                                              dashLength: 2,
                                              lineThickness: 0.5,
                                            ),
                                          ),
                                        ],
                                      ),
                                    ),
                                    ...List.generate(1, (j) {
                                      final textheads = ["Time"];
                                      final textSubheads = [
                                        leadsList[index].date ?? "-",
                                      ];
                                      return Container(
                                        padding: EdgeInsets.symmetric(
                                          vertical: 7,
                                        ),
                                        child: Row(
                                          crossAxisAlignment:
                                              CrossAxisAlignment.start,
                                          children: [
                                            Expanded(
                                              child: Text(
                                                textAlign: TextAlign.left,
                                                textheads[j],
                                                style: TextStyle(
                                                  fontFamily: "JakartaRegular",
                                                  fontSize: 14,
                                                  color: AppColors.semi_black,
                                                ),
                                              ),
                                            ),

                                            Expanded(
                                              child: Text(
                                                textAlign: TextAlign.right,
                                                textSubheads[j] == ""
                                                    ? "-"
                                                    : textSubheads[j],
                                                style: TextStyle(
                                                  fontSize: 14,
                                                  color: Color(0xFF818181),
                                                ),
                                              ),
                                            ),
                                          ],
                                        ),
                                      );
                                    }),

                                    Container(
                                      padding: EdgeInsets.symmetric(
                                        vertical: 4,
                                      ),
                                      child: Row(
                                        children: [
                                          Expanded(
                                            flex: 3,
                                            child: Text(
                                              "Lead Details",
                                              style: TextStyle(
                                                fontSize: 14,
                                                fontFamily: "JakartaSemiBold",
                                              ),
                                            ),
                                          ),
                                          Expanded(
                                            flex: 6,
                                            child: DottedLine(
                                              dashGapLength: 4,
                                              dashGapColor: Colors.white,
                                              dashColor: AppColors.grey_semi,
                                              dashLength: 2,
                                              lineThickness: 0.5,
                                            ),
                                          ),
                                        ],
                                      ),
                                    ),
                                    ...List.generate(1, (j) {
                                      final textheads = ["Lead Open / Close"];
                                      final textSubheads = [
                                        leadsList[index].openStatus ?? "-",
                                      ];
                                      return Container(
                                        padding: EdgeInsets.symmetric(
                                          vertical: 7,
                                        ),
                                        child: Row(
                                          crossAxisAlignment:
                                              CrossAxisAlignment.start,
                                          children: [
                                            Expanded(
                                              child: Text(
                                                textAlign: TextAlign.left,
                                                textheads[j],
                                                style: TextStyle(
                                                  fontFamily: "JakartaRegular",
                                                  fontSize: 14,
                                                  color: AppColors.semi_black,
                                                ),
                                              ),
                                            ),

                                            Expanded(
                                              child: Text(
                                                textAlign: TextAlign.right,
                                                textSubheads[j] == ""
                                                    ? "-"
                                                    : textSubheads[j],
                                                style: TextStyle(
                                                  fontSize: 14,
                                                  color: Color(0xFF818181),
                                                ),
                                              ),
                                            ),
                                          ],
                                        ),
                                      );
                                    }),
                                  ],
                                ),
                              ),
                            );
                          },
                        ),
                      ),
                    ] else ...[
                      InkResponse(
                        onTap: () async {
                          HapticFeedback.selectionClick();
                          await addleadProvider
                              .crmProspectDetailsAddLeadsViewAPIFunction(
                                context,
                                widget.mode,
                              );
                          _showAddLeadsSheet(context, widget.mode);
                        },
                        child: Container(
                          height: 50,
                          margin: EdgeInsets.symmetric(
                            horizontal: 10,
                            vertical: 10,
                          ),
                          decoration: BoxDecoration(
                            color: Colors.white,
                            borderRadius: BorderRadius.circular(16),
                          ),
                          child: Center(
                            child: Text(
                              textAlign: TextAlign.right,
                              "+ Add Lead",
                              style: TextStyle(
                                fontFamily: "JakartaMedium",
                                fontSize: 14,
                                color: AppColors.app_blue,
                              ),
                            ),
                          ),
                        ),
                      ),
                    ],

                    ///Contact Details
                    Container(
                      padding: EdgeInsets.only(left: 10, right: 10, top: 10),
                      child: Row(
                        children: [
                          Expanded(
                            child: Text(
                              textAlign: TextAlign.left,
                              "Contact Details",
                              style: TextStyle(
                                fontFamily: "JakartaMedium",
                                fontSize: 14,
                                color: AppColors.grey_thick,
                              ),
                            ),
                          ),
                          if (contactNotEmpty) ...[
                            Expanded(
                              child: InkResponse(
                                onTap:
                                    provider.addContactSelected
                                        ? null
                                        : () {
                                          HapticFeedback.selectionClick();
                                          provider.addContactSelected = true;
                                          _showAddContactSheet(
                                            context,
                                            provider.accountDetails.id!,
                                          );
                                        },
                                child: Padding(
                                  padding: const EdgeInsets.all(8.0),
                                  child: Text(
                                    textAlign: TextAlign.right,
                                    "+ Add Contact",
                                    style: TextStyle(
                                      fontFamily: "JakartaMedium",
                                      fontSize: 14,
                                      color: AppColors.app_blue,
                                    ),
                                  ),
                                ),
                              ),
                            ),
                          ],
                        ],
                      ),
                    ),
                    if (contactNotEmpty) ...[
                      ListView.builder(
                        physics: NeverScrollableScrollPhysics(),
                        shrinkWrap: true,
                        padding: EdgeInsets.symmetric(
                          vertical: 10,
                          horizontal: 10,
                        ),
                        itemCount: provider.contactList.length,
                        itemBuilder: (context, lp) {
                          return InkResponse(
                            onTap:
                                provider.addContactSelected
                                    ? null
                                    : () async {
                                      provider.addContactSelected = true;
                                      HapticFeedback.selectionClick();
                                      provider.editNameController.text =
                                          provider.contactList[lp].name ?? "";
                                      provider.editDesignationController.text =
                                          provider
                                              .contactList[lp]
                                              .designation ??
                                          "";
                                      provider.editMobileNumberController.text =
                                          provider.contactList[lp].mob1 ?? "";
                                      provider
                                              .editAlternativeMobileController
                                              .text =
                                          provider.contactList[lp].mob2 ?? "";
                                      provider.editTelephoneController.text =
                                          provider.contactList[lp].tel ?? "";
                                      provider.editEmailController.text =
                                          provider.contactList[lp].email ?? "";
                                      _showEditContactSheet(
                                        context,
                                        lp,
                                        provider.accountDetails.id!,
                                      );
                                    },
                            child: Container(
                              decoration: BoxDecoration(
                                color: Colors.white,
                                borderRadius: BorderRadius.circular(14),
                              ),
                              padding: EdgeInsets.symmetric(
                                horizontal: 10,
                                vertical: 10,
                              ),
                              margin: EdgeInsets.symmetric(vertical: 5),

                              child: Row(
                                mainAxisAlignment: MainAxisAlignment.start,
                                crossAxisAlignment: CrossAxisAlignment.start,
                                children: [
                                  Expanded(
                                    flex: 1,
                                    child: SvgPicture.asset(
                                      "assets/svg/crm/contact_details_ic.svg",
                                    ),
                                  ),
                                  SizedBox(width: 10),
                                  Expanded(
                                    flex: 6,
                                    child: SizedBox(
                                      child: Column(
                                        // mainAxisAlignment: MainAxisAlignment.start,
                                        crossAxisAlignment:
                                            CrossAxisAlignment.start,
                                        mainAxisAlignment:
                                            MainAxisAlignment.start,
                                        children: [
                                          Row(
                                            children: [
                                              Expanded(
                                                flex: 4,
                                                child: Text(
                                                  provider
                                                          .contactList[lp]
                                                          .name ??
                                                      "-",
                                                  style: TextStyle(
                                                    fontFamily: "JakartaMedium",
                                                    fontSize: 14,
                                                    color: AppColors.semi_black,
                                                  ),
                                                ),
                                              ),
                                              Expanded(
                                                flex: 2,
                                                child: InkResponse(
                                                  onTap: () {
                                                    launch(
                                                      'tel://${provider.contactList[lp].mob1}',
                                                    );
                                                  },
                                                  child: Text(
                                                    textAlign: TextAlign.right,
                                                    provider
                                                            .contactList[lp]
                                                            .mob1 ??
                                                        "-",
                                                    style: TextStyle(
                                                      height: 1,
                                                      decorationColor:
                                                          AppColors.grey_thick,
                                                      decoration:
                                                          TextDecoration
                                                              .underline,
                                                      decorationStyle:
                                                          TextDecorationStyle
                                                              .dotted,
                                                      fontFamily:
                                                          "JakartaMedium",
                                                      fontSize: 14,
                                                      color:
                                                          AppColors.semi_black,
                                                    ),
                                                  ),
                                                ),
                                              ),
                                            ],
                                          ),
                                          Text(
                                            provider.contactList[lp].email == ""
                                                ? "-"
                                                : provider
                                                        .contactList[lp]
                                                        .email ??
                                                    "-",
                                            style: TextStyle(
                                              fontFamily: "JakartaMedium",
                                              fontSize: 14,
                                              color: AppColors.grey_semi,
                                            ),
                                          ),
                                        ],
                                      ),
                                    ),
                                  ),
                                ],
                              ),
                            ),
                          );
                        },
                      ),
                    ] else ...[
                      InkResponse(
                        onTap:
                            provider.addContactSelected
                                ? null
                                : () {
                                  HapticFeedback.selectionClick();
                                  provider.addContactSelected = true;
                                  _showAddContactSheet(
                                    context,
                                    provider.accountDetails.id!,
                                  );
                                },
                        child: Container(
                          height: 50,
                          margin: EdgeInsets.symmetric(
                            horizontal: 10,
                            vertical: 10,
                          ),
                          decoration: BoxDecoration(
                            color: Colors.white,
                            borderRadius: BorderRadius.circular(16),
                          ),
                          child: Center(
                            child: Text(
                              textAlign: TextAlign.right,
                              "+ Add Contact",
                              style: TextStyle(
                                fontFamily: "JakartaMedium",
                                fontSize: 14,
                                color: AppColors.app_blue,
                              ),
                            ),
                          ),
                        ),
                      ),
                    ],

                    ///Order Details
                    if (orderNotEmpty) ...[
                      Container(
                        padding: EdgeInsets.only(left: 10, right: 10, top: 10),
                        child: Row(
                          children: [
                            Expanded(
                              child: Text(
                                textAlign: TextAlign.left,
                                "Order Details",
                                style: TextStyle(
                                  fontFamily: "JakartaMedium",
                                  fontSize: 14,
                                  color: AppColors.grey_thick,
                                ),
                              ),
                            ),
                          ],
                        ),
                      ),
                      SizedBox(
                        width: double.infinity,
                        height: 250,
                        child: ListView.builder(
                          itemCount: orderList.length,
                          shrinkWrap: true,
                          padding: EdgeInsets.symmetric(
                            vertical: 10,
                            horizontal: 10,
                          ),
                          physics: AlwaysScrollableScrollPhysics(),
                          scrollDirection: Axis.horizontal,
                          itemBuilder: (context, index) {
                            return Container(
                              height: 250,
                              width: MediaQuery.of(context).size.width * 0.9,

                              margin: EdgeInsets.symmetric(vertical: 5),
                              padding: EdgeInsets.symmetric(
                                horizontal: 15,
                                vertical: 10,
                              ),
                              decoration: BoxDecoration(
                                color: Colors.white,
                                borderRadius: BorderRadius.circular(20),
                              ),
                              child: Column(
                                crossAxisAlignment: CrossAxisAlignment.start,
                                children: [
                                  Row(
                                    mainAxisAlignment: MainAxisAlignment.start,
                                    crossAxisAlignment:
                                        CrossAxisAlignment.start,
                                    children: [
                                      Expanded(
                                        flex: 1,
                                        child: SvgPicture.asset(
                                          "assets/svg/crm/product_details_ic.svg",
                                        ),
                                      ),
                                      SizedBox(width: 10),
                                      Expanded(
                                        flex: 4,
                                        child: SizedBox(
                                          child: Column(
                                            // mainAxisAlignment: MainAxisAlignment.start,
                                            crossAxisAlignment:
                                                CrossAxisAlignment.start,
                                            mainAxisAlignment:
                                                MainAxisAlignment.start,
                                            children: [
                                              Text(
                                                "Order ID",
                                                style: TextStyle(
                                                  fontFamily: "JakartaMedium",
                                                  fontSize: 14,
                                                  color: AppColors.semi_black,
                                                ),
                                              ),

                                              Text(
                                                "${orderList[index].id}",
                                                style: TextStyle(
                                                  fontFamily: "JakartaMedium",
                                                  fontSize: 14,
                                                  color: AppColors.grey_semi,
                                                ),
                                              ),
                                            ],
                                          ),
                                        ),
                                      ),
                                      SizedBox(width: 10),
                                      Expanded(
                                        flex: 2,
                                        child: Container(
                                          decoration: BoxDecoration(
                                            borderRadius: BorderRadius.circular(
                                              8,
                                            ),
                                            color: Color(0xFFF3FFD5),
                                          ),
                                          padding: EdgeInsets.symmetric(
                                            horizontal: 5,
                                            vertical: 10,
                                          ),
                                          child: Center(
                                            child: Text(
                                              textAlign: TextAlign.right,
                                              orderList[index].status ?? "-",
                                              style: TextStyle(
                                                fontFamily: "JakartaMedium",
                                                fontSize: 14,
                                                color: Color(0xFF586000),
                                              ),
                                            ),
                                          ),
                                        ),
                                      ),
                                    ],
                                  ),
                                  Container(
                                    padding: EdgeInsets.symmetric(vertical: 3),
                                    child: Row(
                                      children: [
                                        Expanded(
                                          flex: 3,
                                          child: Text(
                                            "Order Created",
                                            style: TextStyle(
                                              fontSize: 14,
                                              fontFamily: "JakartaSemiBold",
                                            ),
                                          ),
                                        ),
                                        Expanded(
                                          flex: 6,
                                          child: DottedLine(
                                            dashGapLength: 4,
                                            dashGapColor: Colors.white,
                                            dashColor: AppColors.grey_semi,
                                            dashLength: 2,
                                            lineThickness: 0.5,
                                          ),
                                        ),
                                      ],
                                    ),
                                  ),
                                  ...List.generate(1, (j) {
                                    final textheads = ["Time"];
                                    final textSubheads = [
                                      orderList[index].createdDatetime ?? "-",
                                    ];
                                    return Container(
                                      padding: EdgeInsets.symmetric(
                                        vertical: 3,
                                      ),
                                      child: Row(
                                        crossAxisAlignment:
                                            CrossAxisAlignment.start,
                                        children: [
                                          Expanded(
                                            child: Text(
                                              textAlign: TextAlign.left,
                                              textheads[j],
                                              style: TextStyle(
                                                fontFamily: "JakartaRegular",
                                                fontSize: 14,
                                                color: AppColors.semi_black,
                                              ),
                                            ),
                                          ),

                                          Expanded(
                                            child: Text(
                                              textAlign: TextAlign.right,
                                              textSubheads[j] == ""
                                                  ? "-"
                                                  : textSubheads[j],
                                              style: TextStyle(
                                                fontSize: 14,
                                                color: Color(0xFF818181),
                                              ),
                                            ),
                                          ),
                                        ],
                                      ),
                                    );
                                  }),

                                  Container(
                                    padding: EdgeInsets.symmetric(vertical: 4),
                                    child: Row(
                                      children: [
                                        Expanded(
                                          flex: 3,
                                          child: Text(
                                            "Order Details",
                                            style: TextStyle(
                                              fontSize: 14,
                                              fontFamily: "JakartaSemiBold",
                                            ),
                                          ),
                                        ),
                                        Expanded(
                                          flex: 6,
                                          child: DottedLine(
                                            dashGapLength: 4,
                                            dashGapColor: Colors.white,
                                            dashColor: AppColors.grey_semi,
                                            dashLength: 2,
                                            lineThickness: 0.5,
                                          ),
                                        ),
                                      ],
                                    ),
                                  ),
                                  ...List.generate(1, (j) {
                                    final textheads = ["View Details"];
                                    final textSubheads = ["View"];
                                    return Container(
                                      padding: EdgeInsets.symmetric(
                                        vertical: 7,
                                      ),
                                      child: Row(
                                        crossAxisAlignment:
                                            CrossAxisAlignment.start,
                                        children: [
                                          Expanded(
                                            child: Text(
                                              textAlign: TextAlign.left,
                                              textheads[j],
                                              style: TextStyle(
                                                fontFamily: "JakartaRegular",
                                                fontSize: 14,
                                                color: AppColors.semi_black,
                                              ),
                                            ),
                                          ),
                                          Expanded(
                                            child: InkResponse(
                                              onTap: () async {
                                                var res = await Navigator.push(
                                                  context,
                                                  MaterialPageRoute(
                                                    builder:
                                                        (
                                                          context,
                                                        ) => Ordersdetailsbymodes(
                                                          mode: "",
                                                          pageTitleName:
                                                              "Order Details",
                                                          orderId:
                                                              widget.leadId,
                                                        ),
                                                  ),
                                                );
                                                if (res == true) {
                                                  provider
                                                      .crmProspectDetailsAPIFunction(
                                                        context,
                                                        widget.leadId,
                                                      );
                                                }
                                              },
                                              child: Text(
                                                textAlign: TextAlign.right,
                                                textSubheads[j] == ""
                                                    ? "-"
                                                    : textSubheads[j],
                                                overflow: TextOverflow.ellipsis,
                                                style: TextStyle(
                                                  color: AppColors.app_blue,
                                                  decorationColor:
                                                      AppColors.app_blue,
                                                  decoration:
                                                      TextDecoration.underline,
                                                ),
                                              ),
                                            ),
                                          ),
                                        ],
                                      ),
                                    );
                                  }),
                                ],
                              ),
                            );
                          },
                        ),
                      ),
                    ],

                    ///Payment Details
                    if (paymentsNotEmpty) ...[
                      Container(
                        padding: EdgeInsets.only(left: 10, right: 10, top: 10),
                        child: Row(
                          children: [
                            Expanded(
                              child: Text(
                                textAlign: TextAlign.left,
                                "Payment Details",
                                style: TextStyle(
                                  fontFamily: "JakartaMedium",
                                  fontSize: 14,
                                  color: AppColors.grey_thick,
                                ),
                              ),
                            ),
                          ],
                        ),
                      ),

                      SizedBox(
                        width: double.infinity,
                        height: 200,
                        child: ListView.builder(
                          itemCount: paymentList.length,
                          shrinkWrap: true,
                          padding: EdgeInsets.symmetric(
                            vertical: 10,
                            horizontal: 5,
                          ),
                          physics: AlwaysScrollableScrollPhysics(),
                          scrollDirection: Axis.horizontal,
                          itemBuilder: (context, index) {
                            return InkResponse(
                              onTap: () async {
                                var res = await Navigator.push(
                                  context,
                                  MaterialPageRoute(
                                    builder:
                                        (context) => Paymentdetailsbymode(
                                          mode: "",
                                          pageTitleName: "Payment Details",
                                          paymentId: paymentList[index].id,
                                        ),
                                  ),
                                );
                                if (res == true) {
                                  provider.crmProspectDetailsAPIFunction(
                                    context,
                                    paymentList[index].id,
                                  );
                                }
                              },
                              child: Container(
                                height: 200,
                                width: MediaQuery.of(context).size.width * 0.9,

                                margin: EdgeInsets.symmetric(
                                  vertical: 5,
                                  horizontal: 7.5,
                                ),
                                padding: EdgeInsets.symmetric(
                                  horizontal: 15,
                                  vertical: 10,
                                ),
                                decoration: BoxDecoration(
                                  color: Colors.white,
                                  borderRadius: BorderRadius.circular(20),
                                ),
                                child: Column(
                                  crossAxisAlignment: CrossAxisAlignment.start,
                                  children: [
                                    Row(
                                      mainAxisAlignment:
                                          MainAxisAlignment.start,
                                      crossAxisAlignment:
                                          CrossAxisAlignment.start,
                                      children: [
                                        Expanded(
                                          flex: 1,
                                          child: SvgPicture.asset(
                                            "assets/svg/crm/payment_details_ic.svg",
                                          ),
                                        ),
                                        SizedBox(width: 10),
                                        Expanded(
                                          flex: 4,
                                          child: SizedBox(
                                            child: Column(
                                              // mainAxisAlignment: MainAxisAlignment.start,
                                              crossAxisAlignment:
                                                  CrossAxisAlignment.start,
                                              mainAxisAlignment:
                                                  MainAxisAlignment.start,
                                              children: [
                                                Text(
                                                  "${paymentList[index].employeeName}",
                                                  style: TextStyle(
                                                    fontFamily: "JakartaMedium",
                                                    fontSize: 14,
                                                    color: AppColors.semi_black,
                                                  ),
                                                ),

                                                Text(
                                                  "₹${paymentList[index].amount}",
                                                  style: TextStyle(
                                                    fontFamily: "JakartaMedium",
                                                    fontSize: 14,
                                                    color: AppColors.grey_semi,
                                                  ),
                                                ),
                                              ],
                                            ),
                                          ),
                                        ),
                                        SizedBox(width: 10),
                                        Expanded(
                                          flex: 2,
                                          child: Container(
                                            decoration: BoxDecoration(
                                              borderRadius:
                                                  BorderRadius.circular(8),
                                              color: Color(0xFFF3FFD5),
                                            ),
                                            padding: EdgeInsets.symmetric(
                                              horizontal: 5,
                                              vertical: 10,
                                            ),
                                            child: Center(
                                              child: Text(
                                                textAlign: TextAlign.right,
                                                paymentList[index]
                                                        .paymentType ??
                                                    "-",
                                                style: TextStyle(
                                                  fontFamily: "JakartaMedium",
                                                  fontSize: 14,
                                                  color: Color(0xFF586000),
                                                ),
                                              ),
                                            ),
                                          ),
                                        ),
                                      ],
                                    ),
                                    SizedBox(height: 5),
                                    Container(
                                      padding: EdgeInsets.symmetric(
                                        vertical: 4,
                                      ),
                                      child: Row(
                                        children: [
                                          Expanded(
                                            flex: 3,
                                            child: Text(
                                              "Payment Details",
                                              style: TextStyle(
                                                fontSize: 14,
                                                fontFamily: "JakartaSemiBold",
                                              ),
                                            ),
                                          ),
                                          Expanded(
                                            flex: 6,
                                            child: DottedLine(
                                              dashGapLength: 4,
                                              dashGapColor: Colors.white,
                                              dashColor: AppColors.grey_semi,
                                              dashLength: 2,
                                              lineThickness: 0.5,
                                            ),
                                          ),
                                        ],
                                      ),
                                    ),

                                    ...List.generate(2, (j) {
                                      final textheads = [
                                        "Payment Reference",
                                        "Payment Received Date",
                                      ];
                                      final textSubheads = [
                                        paymentList[index].refNo ?? "-",
                                        paymentList[index].paymentDate ?? "-",
                                      ];
                                      return Container(
                                        padding: EdgeInsets.symmetric(
                                          vertical: 7,
                                        ),
                                        child: Row(
                                          crossAxisAlignment:
                                              CrossAxisAlignment.start,
                                          children: [
                                            Expanded(
                                              child: Text(
                                                textAlign: TextAlign.left,
                                                textheads[j],
                                                style: TextStyle(
                                                  fontFamily: "JakartaRegular",
                                                  fontSize: 14,
                                                  color: AppColors.semi_black,
                                                ),
                                              ),
                                            ),

                                            Expanded(
                                              child: Text(
                                                textAlign: TextAlign.right,
                                                textSubheads[j] == ""
                                                    ? "-"
                                                    : textSubheads[j],
                                                style: TextStyle(
                                                  fontSize: 14,
                                                  color: Color(0xFF818181),
                                                ),
                                              ),
                                            ),
                                          ],
                                        ),
                                      );
                                    }),
                                  ],
                                ),
                              ),
                            );
                          },
                        ),
                      ),
                    ],
                    SizedBox(height: 75),
                  ],
                ),
              ],
            ),
          ),
        );
      },
    );
  }

  Future<void> _showAddContactSheet(BuildContext context, accID) {
    return showModalBottomSheet(
      useSafeArea: true,
      isDismissible: true,
      isScrollControlled: true,
      showDragHandle: true,
      backgroundColor: Colors.white,
      enableDrag: true,
      context: context,
      builder: (context) {
        return StatefulBuilder(
          builder: (context, setState) {
            return SafeArea(
              child: Consumer<crmProspectDetailsProvider>(
                builder: (context, provider, child) {
                  provider.addContactSelected = false;
                  return Container(
                    margin: EdgeInsets.only(
                      bottom: 15,
                      left: 15,
                      right: 15,
                      top: 10,
                    ),
                    padding: EdgeInsets.only(
                      bottom: MediaQuery.of(context).viewInsets.bottom,
                    ),

                    child: SingleChildScrollView(
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        mainAxisSize: MainAxisSize.min,
                        children: [
                          Align(
                            alignment: Alignment.topLeft,
                            child: Text(
                              "Add Contact",
                              style: TextStyle(
                                color: AppColors.app_blue,
                                fontSize: 16,
                              ),
                            ),
                          ),
                          textControllerWidget(
                            context,
                            provider.nameController,
                            "Name",
                            "Enter Name",
                            (p0) {
                              provider.crmCheckFields(
                                context,
                                provider.nameController.text,
                                "name",
                              );
                              provider.onChangeName(p0);
                            },
                            TextInputType.text,
                            false,
                            null,
                          ),
                          errorWidget(context, provider.nameError),
                          textControllerWidget(
                            context,
                            provider.designationController,
                            "Designation",
                            "Enter Designation",
                            provider.onChangeDesignation,
                            TextInputType.text,
                            false,
                            null,
                          ),
                          errorWidget(context, provider.designationError),
                          textControllerWidget(
                            context,
                            provider.mobileNumberController,
                            "Mobile Number",
                            "Enter Mobile Number",
                            (p0) {
                              provider.crmCheckFields(
                                context,
                                provider.mobileNumberController.text,
                                "mob1",
                              );
                              provider.onChangeMobile(p0);
                            },
                            TextInputType.number,
                            false,
                            FilteringTextInputFormatter.digitsOnly,
                            null,
                            null,
                            TextInputAction.next,
                            10,
                          ),
                          errorWidget(context, provider.mobileNumError),
                          textControllerWidget(
                            context,
                            provider.alternativeMobileController,
                            "Alternative Mobile Number",
                            "Enter Alternative Mobile Number",
                            (p0) {
                              provider.crmCheckFields(
                                context,
                                provider.alternativeMobileController.text,
                                "mob2",
                              );
                              provider.onChangeAltMobile(p0);
                            },
                            TextInputType.number,
                            false,
                            FilteringTextInputFormatter.digitsOnly,
                            null,
                            null,
                            TextInputAction.next,
                            10,
                          ),
                          errorWidget(context, provider.altMobError),
                          textControllerWidget(
                            context,
                            provider.telephoneController,
                            "Telephone Number",
                            "Enter Telephone Number",
                            provider.onChangeTelephone,
                            TextInputType.number,
                            false,
                            FilteringTextInputFormatter.digitsOnly,
                          ),
                          errorWidget(context, provider.teleError),
                          textControllerWidget(
                            context,
                            provider.emailController,
                            "Email ID",
                            "Enter Email ID",
                            provider.onChangeEmailId,
                            TextInputType.emailAddress,
                            false,
                            null,
                          ),
                          errorWidget(context, provider.emailError),
                          InkWell(
                            onTap:
                                provider.isLoading
                                    ? null
                                    : () {
                                      provider.isLoading = true;
                                      provider
                                          .crmProspectDetailsAddContactAPIFunction(
                                            context,
                                            accID,
                                          );
                                    },
                            child: Container(
                              alignment: Alignment.center,
                              height: 45,
                              margin: EdgeInsets.only(
                                left: 5.0,
                                right: 5.0,
                                top: 5.0,
                                bottom: 5.0,
                              ),
                              decoration: BoxDecoration(
                                color: AppColors.app_blue, //1487C9
                                borderRadius: BorderRadius.circular(14.0),
                              ),
                              child: Center(
                                child:
                                    provider.isLoading
                                        ? CircularProgressIndicator.adaptive(
                                          valueColor: AlwaysStoppedAnimation(
                                            AppColors.white,
                                          ),
                                        )
                                        : Text(
                                          "Submit",
                                          textAlign: TextAlign.center,
                                          style: TextStyle(color: Colors.white),
                                        ),
                              ),
                            ),
                          ),
                        ],
                      ),
                    ),
                  );
                },
              ),
            );
          },
        );
      },
    ).whenComplete(() {
      WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
        final provider = Provider.of<crmProspectDetailsProvider>(
          context,
          listen: false,
        );
        final editProvider = Provider.of<Crmeditprospectaccountprovider>(
          context,
          listen: false,
        );
        editProvider.crmLeadListViewAPIFunction(context, widget.mode);
        provider.addContactSelected = false;
        editProvider.crmProspectDetailsEditAccountViewAPIFunction(
          context,
          widget.leadId,
        );
        provider.crmProspectDetailsAPIFunction(context, widget.leadId);
      });
    });
  }

  Future<void> _showEditContactSheet(BuildContext context, index, accid) {
    return showModalBottomSheet(
      useSafeArea: true,
      isDismissible: true,
      isScrollControlled: true,
      showDragHandle: true,
      backgroundColor: Colors.white,
      enableDrag: true,
      context: context,
      builder: (context) {
        return StatefulBuilder(
          builder: (context, setState) {
            return SafeArea(
              child: Consumer<crmProspectDetailsProvider>(
                builder: (context, provider, child) {
                  provider.addContactSelected = false;
                  return Container(
                    margin: EdgeInsets.only(
                      bottom: 15,
                      left: 15,
                      right: 15,
                      top: 10,
                    ),
                    padding: EdgeInsets.only(
                      bottom: MediaQuery.of(context).viewInsets.bottom,
                    ),
                    child: SingleChildScrollView(
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        mainAxisSize: MainAxisSize.min,
                        children: [
                          Align(
                            alignment: Alignment.topLeft,
                            child: Text(
                              "Edit Contact",
                              style: TextStyle(
                                color: AppColors.app_blue,
                                fontSize: 16,
                              ),
                            ),
                          ),
                          textControllerWidget(
                            context,
                            provider.editNameController,
                            "Name",
                            "Enter Name",
                            (p0) {
                              provider.crmCheckFields(
                                context,
                                provider.editNameController.text,
                                "name",
                              );
                              provider.onChangeEditName(p0);
                            },
                            TextInputType.text,
                            false,
                            null,
                          ),
                          errorWidget(context, provider.editNameError),
                          textControllerWidget(
                            context,
                            provider.editDesignationController,
                            "Designation",
                            "Enter Designation",
                            provider.onChangeEditDesignation,
                            TextInputType.text,
                            false,
                            null,
                          ),
                          errorWidget(context, provider.editDesignationError),
                          textControllerWidget(
                            context,
                            provider.editMobileNumberController,
                            "Mobile Number",
                            "Enter Mobile Number",
                            (p0) {
                              provider.crmCheckFields(
                                context,
                                provider.editMobileNumberController.text,
                                "mob1",
                              );
                              provider.onChangeEditMobile(p0);
                            },
                            TextInputType.number,
                            false,
                            FilteringTextInputFormatter.digitsOnly,
                            null,
                            null,
                            TextInputAction.next,
                            10,
                          ),
                          errorWidget(context, provider.editMobileNumError),

                          textControllerWidget(
                            context,
                            provider.editAlternativeMobileController,
                            "Alternative Mobile Number",
                            "Enter Alternative Mobile Number",
                            (p0) {
                              provider.crmCheckFields(
                                context,
                                provider.editAlternativeMobileController.text,
                                "mob2",
                              );
                              provider.onChangeEditAltMobile(p0);
                            },
                            TextInputType.number,
                            false,
                            FilteringTextInputFormatter.digitsOnly,
                            null,
                            null,
                            TextInputAction.next,
                            10,
                          ),
                          errorWidget(context, provider.editAltMobError),
                          textControllerWidget(
                            context,
                            provider.editTelephoneController,
                            "Telephone Number",
                            "Enter Telephone Number",
                            provider.onChangeEditTelephone,
                            TextInputType.number,
                            false,
                            FilteringTextInputFormatter.digitsOnly,
                          ),
                          errorWidget(context, provider.editTeleError),

                          textControllerWidget(
                            context,
                            provider.editEmailController,
                            "Email ID",
                            "Enter Email ID",
                            provider.onChangeEditEmailId,
                            TextInputType.emailAddress,
                            false,
                            null,
                          ),
                          errorWidget(context, provider.editEmailError),

                          InkWell(
                            onTap:
                                provider.isLoading
                                    ? null
                                    : () {
                                      provider.isLoading = true;
                                      provider
                                          .crmProspectDetailsEditContactAPIFunction(
                                            context,
                                            provider.contactList[index].id,
                                            accid,
                                          );
                                    },
                            child: Container(
                              alignment: Alignment.center,
                              height: 45,
                              margin: EdgeInsets.only(
                                left: 5.0,
                                right: 5.0,
                                top: 5.0,
                                bottom: 5.0,
                              ),
                              decoration: BoxDecoration(
                                color: AppColors.app_blue, //1487C9
                                borderRadius: BorderRadius.circular(14.0),
                              ),
                              child: Center(
                                child:
                                    provider.isLoading
                                        ? CircularProgressIndicator.adaptive(
                                          valueColor: AlwaysStoppedAnimation(
                                            AppColors.white,
                                          ),
                                        )
                                        : Text(
                                          "Submit",
                                          textAlign: TextAlign.center,
                                          style: TextStyle(color: Colors.white),
                                        ),
                              ),
                            ),
                          ),
                        ],
                      ),
                    ),
                  );
                },
              ),
            );
          },
        );
      },
    ).whenComplete(() {
      WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
        final provider = Provider.of<crmProspectDetailsProvider>(
          context,
          listen: false,
        );
        final editProvider = Provider.of<Crmeditprospectaccountprovider>(
          context,
          listen: false,
        );
        editProvider.crmLeadListViewAPIFunction(context, widget.mode);
        provider.addContactSelected = false;
        editProvider.crmProspectDetailsEditAccountViewAPIFunction(
          context,
          widget.leadId,
        );
        provider.crmProspectDetailsAPIFunction(context, widget.leadId);
      });
    });
  }

  Future<void> _showTransferAccountSheet(BuildContext context, accID) {
    return showModalBottomSheet(
      useSafeArea: true,
      isDismissible: true,
      isScrollControlled: true,
      showDragHandle: true,
      backgroundColor: Colors.white,
      enableDrag: true,
      context: context,
      builder: (context) {
        return StatefulBuilder(
          builder: (context, setState) {
            return SafeArea(
              child: Consumer<Crmeditprospectaccountprovider>(
                builder: (context, editProsProvider, child) {
                  return Container(
                    margin: EdgeInsets.only(
                      bottom: 15,
                      left: 15,
                      right: 15,
                      top: 10,
                    ),
                    padding: EdgeInsets.only(
                      bottom: MediaQuery.of(context).viewInsets.bottom,
                    ),

                    child: SingleChildScrollView(
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        mainAxisSize: MainAxisSize.min,
                        children: [
                          Align(
                            alignment: Alignment.topLeft,
                            child: Text(
                              "Transfer Account",
                              style: TextStyle(
                                color: AppColors.app_blue,
                                fontSize: 16,
                              ),
                            ),
                          ),
                          TextWidget(context, "Employee"),
                          DropdownButtonHideUnderline(
                            child: Row(
                              children: [
                                Expanded(
                                  child: DropdownButton2<Employees>(
                                    hint: Text(
                                      "Select Source",
                                      style: TextStyle(fontSize: 14),
                                    ),
                                    items:
                                        editProsProvider.employeesList
                                            .map(
                                              (slist) =>
                                                  DropdownMenuItem<Employees>(
                                                    value: slist,
                                                    child: Text(
                                                      slist.name!,
                                                      style: TextStyle(
                                                        fontSize: 14,
                                                      ),
                                                    ),
                                                  ),
                                            )
                                            .toList(),
                                    value:
                                        editProsProvider.employeesList.contains(
                                              editProsProvider
                                                  .selectedEmployees,
                                            )
                                            ? editProsProvider.selectedEmployees
                                            : null,

                                    // value: provider.selectedEmployees,
                                    onChanged: (Employees? value) {
                                      if (value != null) {
                                        if (editProsProvider
                                            .employeesList
                                            .isNotEmpty) {
                                          editProsProvider.selectedEmployees =
                                              value;
                                          editProsProvider.selectedEmployeeId =
                                              value.id!;
                                          editProsProvider
                                                  .selectedEmployeeValue =
                                              value.name!;
                                        }
                                      }
                                    },
                                    isExpanded: true,
                                    dropdownSearchData: DropdownSearchData(
                                      searchInnerWidgetHeight: 50,
                                      searchController:
                                          editProsProvider.searchController,
                                      searchInnerWidget: Padding(
                                        padding: const EdgeInsets.all(8),
                                        child: TextFormField(
                                          controller:
                                              editProsProvider.searchController,
                                          decoration: InputDecoration(
                                            isDense: true,
                                            contentPadding:
                                                const EdgeInsets.symmetric(
                                                  horizontal: 10,
                                                  vertical: 8,
                                                ),
                                            hintText: 'Search account...',
                                            border: OutlineInputBorder(
                                              borderRadius:
                                                  BorderRadius.circular(8),
                                            ),
                                          ),
                                        ),
                                      ),
                                      searchMatchFn: (item, searchValue) {
                                        return item.value?.name
                                                ?.toLowerCase()
                                                .contains(
                                                  searchValue.toLowerCase(),
                                                ) ??
                                            false;
                                      },
                                    ),
                                    onMenuStateChange: (isOpen) {
                                      if (!isOpen) {
                                        editProsProvider.searchController
                                            .clear();
                                      }
                                    },
                                    buttonStyleData: ddtheme.buttonStyleData,
                                    iconStyleData: ddtheme.iconStyleData,
                                    menuItemStyleData:
                                        ddtheme.menuItemStyleData,
                                    dropdownStyleData:
                                        ddtheme.dropdownStyleData,
                                  ),
                                ),
                              ],
                            ),
                          ),

                          InkWell(
                            onTap:
                                editProsProvider.isLoading
                                    ? null
                                    : () {
                                      editProsProvider.isLoading = true;
                                      editProsProvider
                                          .crmProspectDetailsTransferAccountAPIFunction(
                                            context,
                                            accID,
                                            editProsProvider.selectedEmployeeId,
                                          );
                                    },
                            child: Container(
                              alignment: Alignment.center,
                              height: 45,
                              margin: EdgeInsets.only(
                                left: 5.0,
                                right: 5.0,
                                top: 5.0,
                                bottom: 5.0,
                              ),
                              decoration: BoxDecoration(
                                color: AppColors.app_blue, //1487C9
                                borderRadius: BorderRadius.circular(14.0),
                              ),
                              child: Center(
                                child:
                                    editProsProvider.isLoading
                                        ? CircularProgressIndicator.adaptive(
                                          valueColor: AlwaysStoppedAnimation(
                                            AppColors.white,
                                          ),
                                        )
                                        : Text(
                                          "Submit",
                                          textAlign: TextAlign.center,
                                          style: TextStyle(color: Colors.white),
                                        ),
                              ),
                            ),
                          ),
                        ],
                      ),
                    ),
                  );
                },
              ),
            );
          },
        );
      },
    ).whenComplete(() {
      WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
        final provider = Provider.of<crmProspectDetailsProvider>(
          context,
          listen: false,
        );
        final editProvider = Provider.of<Crmeditprospectaccountprovider>(
          context,
          listen: false,
        );
        editProvider.crmLeadListViewAPIFunction(context, widget.mode);

        editProvider.crmProspectDetailsEditAccountViewAPIFunction(
          context,
          widget.leadId,
        );
        provider.crmProspectDetailsAPIFunction(context, widget.leadId);
      });
    });
  }

  Future<void> _showEditAccountSheet(BuildContext context, accID) {
    return showModalBottomSheet(
      useSafeArea: true,
      isDismissible: true,
      isScrollControlled: true,
      showDragHandle: true,
      backgroundColor: Colors.white,
      enableDrag: true,
      context: context,
      builder: (context) {
        return StatefulBuilder(
          builder: (context, setState) {
            return SafeArea(
              child: Consumer2<
                Crmeditprospectaccountprovider,
                crmProspectDetailsProvider
              >(
                builder: (context, provider, prosDetProvider, child) {
                  return Container(
                    margin: EdgeInsets.only(
                      bottom: 15,
                      left: 15,
                      right: 15,
                      top: 10,
                    ),
                    padding: EdgeInsets.only(
                      bottom: MediaQuery.of(context).viewInsets.bottom,
                    ),
                    child: SingleChildScrollView(
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        mainAxisSize: MainAxisSize.min,
                        children: [
                          SizedBox(height: 15),
                          Row(
                            children: [
                              Expanded(
                                child: Text(
                                  "Edit Account Details",
                                  style: TextStyle(
                                    color: AppColors.app_blue,
                                    fontSize: 14,
                                  ),
                                ),
                              ),
                            ],
                          ),

                          TextWidget(context, "Salutation"),
                          DropdownButtonHideUnderline(
                            child: Row(
                              children: [
                                Expanded(
                                  child: DropdownButton2<String>(
                                    hint: Text(
                                      "Select Salutation",
                                      style: TextStyle(fontSize: 14),
                                    ),
                                    items:
                                        provider.salutationList
                                            .map(
                                              (slist) =>
                                                  DropdownMenuItem<String>(
                                                    value: slist,
                                                    child: Text(
                                                      slist,
                                                      style: TextStyle(
                                                        fontSize: 14,
                                                      ),
                                                    ),
                                                  ),
                                            )
                                            .toList(),
                                    value: provider.selectedSalutation,
                                    onChanged: (String? value) {
                                      if (value != null) {
                                        if (provider
                                            .salutationList
                                            .isNotEmpty) {
                                          provider.selectedSalutation = value;
                                        }
                                      }
                                    },
                                    isExpanded: true,
                                    buttonStyleData: ddtheme.buttonStyleData,
                                    iconStyleData: ddtheme.iconStyleData,
                                    menuItemStyleData:
                                        ddtheme.menuItemStyleData,
                                    dropdownStyleData:
                                        ddtheme.dropdownStyleData,
                                  ),
                                ),
                              ],
                            ),
                          ),
                          errorWidget(context, provider.salutationError),
                          textControllerWidget(
                            context,
                            provider.editCompanyNameController,
                            "Company Name",
                            "Enter Company Name",
                            provider.onChangeCompanyName,
                            TextInputType.text,
                            false,
                            null,
                          ),
                          errorWidget(context, provider.companyNameError),

                          TextWidget(context, "State"),
                          DropdownButtonHideUnderline(
                            child: Row(
                              children: [
                                Expanded(
                                  child: DropdownButton2<States>(
                                    hint: Text(
                                      "Select State",
                                      style: TextStyle(fontSize: 14),
                                    ),
                                    items:
                                        provider.statesList
                                            .map(
                                              (slist) =>
                                                  DropdownMenuItem<States>(
                                                    value: slist,
                                                    child: Text(
                                                      slist.name!,
                                                      style: TextStyle(
                                                        fontSize: 14,
                                                      ),
                                                    ),
                                                  ),
                                            )
                                            .toList(),
                                    value:
                                        provider.statesList.contains(
                                              provider.selectedStates,
                                            )
                                            ? provider.selectedStates
                                            : null,
                                    onChanged: (States? value) {
                                      if (value != null) {
                                        if (provider.statesList.isNotEmpty) {
                                          provider.selectedStates = value;
                                          provider.selectedStateId = value.id!;
                                          provider.selectedStateValue =
                                              value.name!;
                                          if (provider
                                              .districtsList
                                              .isNotEmpty) {
                                            provider.districtsList.clear();
                                            provider.selectedDistricts = null;
                                            provider.selectedDistrictId = null;
                                            provider.selectedDistrictValue = "";
                                          }
                                          provider
                                              .crmLeadListDistrictsOnStateAPIFunction(
                                                context,
                                                widget.mode,
                                                provider.selectedStateId,
                                              );
                                        }
                                      }
                                    },
                                    isExpanded: true,
                                    buttonStyleData: ddtheme.buttonStyleData,
                                    iconStyleData: ddtheme.iconStyleData,
                                    menuItemStyleData:
                                        ddtheme.menuItemStyleData,
                                    dropdownStyleData:
                                        ddtheme.dropdownStyleData,
                                  ),
                                ),
                              ],
                            ),
                          ),

                          TextWidget(context, "District"),
                          DropdownButtonHideUnderline(
                            child: Row(
                              children: [
                                Expanded(
                                  child: DropdownButton2<Districts>(
                                    hint: Text(
                                      "Select District",
                                      style: TextStyle(fontSize: 14),
                                    ),
                                    items:
                                        provider.districtsList
                                            .map(
                                              (slist) =>
                                                  DropdownMenuItem<Districts>(
                                                    value: slist,
                                                    child: Text(
                                                      slist.district!,
                                                      style: TextStyle(
                                                        fontSize: 14,
                                                      ),
                                                    ),
                                                  ),
                                            )
                                            .toList(),
                                    value:
                                        provider.districtsList.contains(
                                              provider.selectedDistricts,
                                            )
                                            ? provider.selectedDistricts
                                            : null,
                                    // value: provider.selectedDistricts,
                                    onChanged: (Districts? value) {
                                      if (value != null) {
                                        if (provider.districtsList.isNotEmpty) {
                                          provider.selectedDistricts = value;
                                          provider.selectedDistrictId =
                                              value.id!;
                                          provider.selectedDistrictValue =
                                              value.district!;
                                          if (provider
                                              .subLocationsList
                                              .isNotEmpty) {
                                            provider.subLocationsList.clear();
                                            provider.selectedSubLocations =
                                                null;
                                            provider.selectedSubLocationId =
                                                null;
                                            provider.selectedSubLocationValue =
                                                "";
                                          }
                                          provider
                                              .crmLeadListSubLocOnDistrictAPIFunction(
                                                context,
                                                widget.mode,
                                                provider.selectedDistrictId,
                                              );
                                          prosDetProvider
                                              .crmProspectDetailsAPIFunction(
                                                context,
                                                widget.leadId,
                                              );
                                        }
                                      }
                                    },
                                    isExpanded: true,
                                    buttonStyleData: ddtheme.buttonStyleData,
                                    iconStyleData: ddtheme.iconStyleData,
                                    menuItemStyleData:
                                        ddtheme.menuItemStyleData,
                                    dropdownStyleData:
                                        ddtheme.dropdownStyleData,
                                  ),
                                ),
                              ],
                            ),
                          ),

                          TextWidget(context, "Sub Location"),
                          DropdownButtonHideUnderline(
                            child: Row(
                              children: [
                                Expanded(
                                  child: DropdownButton2<SubLocations>(
                                    hint: Text(
                                      "Select Sub Location",
                                      style: TextStyle(fontSize: 14),
                                    ),
                                    items:
                                        provider.subLocationsList
                                            .map(
                                              (slist) => DropdownMenuItem<
                                                SubLocations
                                              >(
                                                value: slist,
                                                child: Text(
                                                  slist.subLocality!,
                                                  style: TextStyle(
                                                    fontSize: 14,
                                                  ),
                                                ),
                                              ),
                                            )
                                            .toList(),
                                    value:
                                        provider.subLocationsList.contains(
                                              provider.selectedSubLocations,
                                            )
                                            ? provider.selectedSubLocations
                                            : null,
                                    // value: provider.selectedSubLocations,
                                    onChanged: (SubLocations? value) {
                                      if (value != null) {
                                        if (provider
                                            .subLocationsList
                                            .isNotEmpty) {
                                          provider.selectedSubLocations = value;
                                          provider.selectedSubLocationId =
                                              value.id!;
                                          provider.selectedSubLocationValue =
                                              value.subLocality!;
                                        }
                                      }
                                    },
                                    isExpanded: true,
                                    buttonStyleData: ddtheme.buttonStyleData,
                                    iconStyleData: ddtheme.iconStyleData,
                                    menuItemStyleData:
                                        ddtheme.menuItemStyleData,
                                    dropdownStyleData:
                                        ddtheme.dropdownStyleData,
                                  ),
                                ),
                              ],
                            ),
                          ),

                          textControllerWidget(
                            context,
                            provider.pincodeController,
                            "Pincode",
                            "Enter Pincode",
                            provider.onChangePincode,
                            TextInputType.number,
                            false,
                            FilteringTextInputFormatter.digitsOnly,
                          ),
                          errorWidget(context, provider.pincodeError),
                          textControllerWidget(
                            context,
                            provider.addressController,
                            "Address",
                            "Enter Address",
                            provider.onChangeAddress,
                            TextInputType.text,
                            false,
                            null,
                          ),
                          errorWidget(context, provider.addressError),

                          InkResponse(
                            onTap:
                                provider.isLoading
                                    ? null
                                    : () {
                                      provider.isLoading = true;
                                      provider
                                          .crmProspectDetailsEditAccountSubmitAPIFunction(
                                            context,
                                            accID,
                                            provider.selectedSalutation,
                                            provider.selectedStateId,
                                            provider.selectedDistrictId,
                                            provider.selectedSubLocationId,
                                          );
                                      Navigator.pop(context);
                                    },
                            child: Container(
                              height: 45,
                              alignment: Alignment.center,
                              margin: EdgeInsets.symmetric(horizontal: 10),
                              padding: EdgeInsets.symmetric(
                                horizontal: 10,
                                vertical: 5,
                              ),
                              decoration: BoxDecoration(
                                color: AppColors.app_blue,
                                borderRadius: BorderRadius.circular(15),
                              ),
                              child:
                                  provider.isLoading
                                      ? CircularProgressIndicator.adaptive(
                                        valueColor: AlwaysStoppedAnimation(
                                          AppColors.white,
                                        ),
                                      )
                                      : Text(
                                        "Submit",
                                        style: TextStyle(
                                          fontSize: 15,
                                          fontFamily: "JakartaMedium",
                                          color: Colors.white,
                                        ),
                                      ),
                            ),
                          ),
                        ],
                      ),
                    ),
                  );
                },
              ),
            );
          },
        );
      },
    ).whenComplete(() {
      WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
        final provider = Provider.of<crmProspectDetailsProvider>(
          context,
          listen: false,
        );
        final editProvider = Provider.of<Crmeditprospectaccountprovider>(
          context,
          listen: false,
        );
        editProvider.crmLeadListViewAPIFunction(context, widget.mode);

        editProvider.crmProspectDetailsEditAccountViewAPIFunction(
          context,
          widget.leadId,
        );
        provider.crmProspectDetailsAPIFunction(context, widget.leadId);
      });
    });
  }

  Future<void> _showOptionsSheet(BuildContext context) {
    return showModalBottomSheet(
      useSafeArea: true,
      isDismissible: true,
      isScrollControlled: true,
      showDragHandle: true,
      backgroundColor: Colors.white,
      enableDrag: true,
      context: context,
      builder: (context) {
        return StatefulBuilder(
          builder: (context, setState) {
            return SafeArea(
              child: Consumer<crmLeadDetailsProvider>(
                builder: (context, provider, child) {
                  return Container(
                    margin: EdgeInsets.only(
                      bottom: 15,
                      left: 15,
                      right: 15,
                      top: 10,
                    ),
                    padding: EdgeInsets.only(
                      bottom: MediaQuery.of(context).viewInsets.bottom,
                    ),
                    child: SingleChildScrollView(
                      child: Column(
                        mainAxisSize: MainAxisSize.min,
                        children: [
                          SizedBox(height: 15),

                          ...List.generate(4, (index) {
                            final assetnames = [
                              "crm_appoint_details",
                              "crm_cont_details",
                              "crm_follow_up_details",
                              "crm_prod_details",
                            ];
                            final Headingnames = [
                              "Lead Details",
                              "Contact Details",
                              "Order Details",
                              "Payment Details",
                            ];
                            return ListTile(
                              onTap: () {
                                switch (index) {
                                  case 0:
                                    Navigator.push(
                                      context,
                                      MaterialPageRoute(
                                        builder:
                                            (context) => ProspectLeadDetails(
                                              leadID: widget.leadId,
                                              mode: widget.mode,
                                            ),
                                      ),
                                    );
                                    break;
                                  case 1:
                                    Navigator.push(
                                      context,
                                      MaterialPageRoute(
                                        builder:
                                            (context) => ProspectContactDetails(
                                              accountId:
                                                  provider.accountDetails.id,
                                            ),
                                      ),
                                    );
                                    break;
                                  case 2:
                                    Navigator.push(
                                      context,
                                      MaterialPageRoute(
                                        builder:
                                            (context) => ProspectOrderDetails(
                                              leadID: widget.leadId,
                                            ),
                                      ),
                                    );
                                    break;
                                  case 3:
                                    Navigator.push(
                                      context,
                                      MaterialPageRoute(
                                        builder:
                                            (context) => ProspectPaymentDetails(
                                              leadID: widget.leadId,
                                            ),
                                      ),
                                    );
                                    break;

                                  default:
                                    print("object");
                                }
                              },
                              leading: SvgPicture.asset(
                                "assets/svg/${assetnames[index]}.svg",
                              ),
                              title: Text(
                                Headingnames[index],
                                style: TextStyle(fontFamily: "JakartaMedium"),
                              ),
                              trailing: SvgPicture.asset(
                                "assets/svg/arrow_right_new.svg",
                              ),
                            );
                          }),
                        ],
                      ),
                    ),
                  );
                },
              ),
            );
          },
        );
      },
    );
  }

  Future<void> _showAddLeadsSheet(BuildContext context, mode) {
    return showModalBottomSheet(
      useSafeArea: true,
      isDismissible: true,
      isScrollControlled: true,
      showDragHandle: true,
      backgroundColor: Colors.white,
      enableDrag: true,
      context: context,
      builder: (context) {
        return StatefulBuilder(
          builder: (context, setState) {
            return SafeArea(
              child: Consumer2<
                crmProspectDetailsProvider,
                Addprospectleadsprovider
              >(
                builder: (context, provider, addleadProvider, child) {
                  final price =
                      double.tryParse(
                        addleadProvider.addLeadProductPriceController.text,
                      ) ??
                      0;
                  final qty =
                      int.tryParse(
                        addleadProvider.addLeadProductQtyController.text,
                      ) ??
                      0;
                  addleadProvider.addLeadProductTotalPriceController.text =
                      (price * qty).toString();
                  void updatedAmountfun(value) {
                    final price =
                        double.tryParse(
                          addleadProvider.addLeadProductPriceController.text,
                        ) ??
                        0;
                    final qty =
                        int.tryParse(
                          addleadProvider.addLeadProductQtyController.text,
                        ) ??
                        0;
                    addleadProvider.addLeadProductTotalPriceController.text =
                        (price * qty).toString();
                  }

                  return Container(
                    margin: EdgeInsets.only(
                      bottom: 15,
                      left: 15,
                      right: 15,
                      top: 10,
                    ),
                    padding: EdgeInsets.only(
                      bottom: MediaQuery.of(context).viewInsets.bottom,
                    ),

                    child: SingleChildScrollView(
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: [
                          Text(
                            "Add Lead",
                            style: TextStyle(
                              fontSize: 14,
                              color: AppColors.app_blue,
                              fontFamily: "JakartaMedium",
                            ),
                          ),
                          SizedBox(height: 10),

                          // TextWidget(context, "Employee"),
                          // DropdownButtonHideUnderline(
                          //   child: Row(
                          //     children: [
                          //       Expanded(
                          //         child: DropdownButton2<LeadEmployees>(
                          //           hint: Text(
                          //             "Select Source",
                          //             style: TextStyle(fontSize: 14),
                          //           ),
                          //           items:
                          //               addleadProvider.employeeList
                          //                   .map(
                          //                     (slist) => DropdownMenuItem<
                          //                       LeadEmployees
                          //                     >(
                          //                       value: slist,
                          //                       child: Text(
                          //                         slist.name!,
                          //                         style: TextStyle(
                          //                           fontSize: 14,
                          //                         ),
                          //                       ),
                          //                     ),
                          //                   )
                          //                   .toList(),
                          //           value:
                          //               addleadProvider.employeeList.contains(
                          //                     addleadProvider.selectedEmployee,
                          //                   )
                          //                   ? addleadProvider.selectedEmployee
                          //                   : null,
                          //
                          //           // value: provider.selectedEmployees,
                          //           onChanged: (LeadEmployees? value) {
                          //             if (value != null) {
                          //               if (addleadProvider
                          //                   .employeeList
                          //                   .isNotEmpty) {
                          //                 addleadProvider.selectedEmployee =
                          //                     value;
                          //                 addleadProvider.selectedEmployeeId =
                          //                     value!.id!;
                          //                 addleadProvider
                          //                         .selectedEmployeeValue =
                          //                     value!.name!;
                          //               }
                          //             }
                          //           },
                          //           isExpanded: true,
                          //           dropdownSearchData: DropdownSearchData(
                          //             searchInnerWidgetHeight: 50,
                          //             searchController:
                          //                 addleadProvider.searchController,
                          //             searchInnerWidget: Padding(
                          //               padding: const EdgeInsets.all(8),
                          //               child: TextFormField(
                          //                 controller:
                          //                     addleadProvider.searchController,
                          //                 decoration: InputDecoration(
                          //                   isDense: true,
                          //                   contentPadding:
                          //                       const EdgeInsets.symmetric(
                          //                         horizontal: 10,
                          //                         vertical: 8,
                          //                       ),
                          //                   hintText: 'Search account...',
                          //                   border: OutlineInputBorder(
                          //                     borderRadius:
                          //                         BorderRadius.circular(8),
                          //                   ),
                          //                 ),
                          //               ),
                          //             ),
                          //             searchMatchFn: (item, searchValue) {
                          //               return item.value?.name
                          //                       ?.toLowerCase()
                          //                       .contains(
                          //                         searchValue.toLowerCase(),
                          //                       ) ??
                          //                   false;
                          //             },
                          //           ),
                          //           onMenuStateChange: (isOpen) {
                          //             if (!isOpen) {
                          //               addleadProvider.searchController
                          //                   .clear();
                          //             }
                          //           },
                          //           buttonStyleData: ddtheme.buttonStyleData,
                          //           iconStyleData: ddtheme.iconStyleData,
                          //           menuItemStyleData:
                          //               ddtheme.menuItemStyleData,
                          //           dropdownStyleData:
                          //               ddtheme.dropdownStyleData,
                          //         ),
                          //       ),
                          //     ],
                          //   ),
                          // ),
                          TextWidget(context, "Product"),
                          DropdownButtonHideUnderline(
                            child: Row(
                              children: [
                                Expanded(
                                  child: DropdownButton2<Products>(
                                    isExpanded: true,
                                    hint: const Text(
                                      'Select Product',
                                      style: TextStyle(fontSize: 14),
                                      overflow: TextOverflow.ellipsis,
                                    ),
                                    items:
                                        addleadProvider.leadProductsList
                                            .map(
                                              (ord) =>
                                                  DropdownMenuItem<Products>(
                                                    value: ord,
                                                    child: Text(
                                                      "${ord.name}",
                                                      style: const TextStyle(
                                                        fontSize: 14,
                                                      ),
                                                      overflow:
                                                          TextOverflow.ellipsis,
                                                    ),
                                                  ),
                                            )
                                            .toList(),
                                    value:
                                        addleadProvider.selectedProducts != null
                                            ? addleadProvider.leadProductsList
                                                .firstWhere(
                                                  (ord) =>
                                                      ord.id ==
                                                      addleadProvider
                                                          .selectedProductsID,
                                                  orElse:
                                                      () =>
                                                          addleadProvider
                                                              .leadProductsList[0],
                                                )
                                            : null,
                                    onChanged: (Products? value) {
                                      if (value != null) {
                                        // addleadProvider
                                        //     .updateSelectedProductIds(
                                        //   j,
                                        //   value,
                                        // // );
                                        // addleadProvider.selectedProductIds[j] =
                                        //     value.id?.toString() ?? '';
                                        // addleadProvider.updateTotalAmount(j);
                                        addleadProvider.selectedProducts =
                                            value;
                                        addleadProvider.selectedProductsName =
                                            value.id;
                                        addleadProvider.selectedProductsID =
                                            value.name;
                                        addleadProvider
                                            .crmSelectedProductDetailsApiFunction(
                                              context,
                                              value.id.toString(),
                                            );
                                      }
                                    },
                                    buttonStyleData: ddtheme.buttonStyleData,
                                    iconStyleData: ddtheme.iconStyleData,
                                    menuItemStyleData:
                                        ddtheme.menuItemStyleData,
                                    dropdownStyleData:
                                        ddtheme.dropdownStyleData,
                                  ),
                                ),
                              ],
                            ),
                          ),
                          const SizedBox(height: 10),
                          textControllerWidget(
                            context,
                            addleadProvider.addLeadProductPriceController,
                            "Product Price",
                            "Enter Product Price",
                            (p0) {
                              updatedAmountfun(p0);
                              addleadProvider.onChnageProductPrice(p0);
                            },
                            TextInputType.number,
                            false,
                            null,
                          ),
                          if (addleadProvider.priceError != null) ...[
                            errorWidget(context, addleadProvider.priceError),
                          ],
                          textControllerWidget(
                            context,
                            addleadProvider.addLeadProductQtyController,
                            "Quantity",
                            "Enter Quantity",
                            (p0) {
                              updatedAmountfun(p0);
                              addleadProvider.onChnageProductQty(p0);
                            },
                            TextInputType.number,
                            false,
                            FilteringTextInputFormatter.digitsOnly,
                          ),
                          if (addleadProvider.qtyError != null) ...[
                            errorWidget(context, addleadProvider.qtyError),
                          ],

                          // Text(
                          //   "Note: Submit Quantity as Zero (0) to delete Product",
                          //   style: TextStyle(
                          //     color: AppColors.app_blue,
                          //     fontSize: 12,
                          //   ),
                          // ),
                          const SizedBox(height: 10),
                          Row(
                            children: [
                              Expanded(
                                flex: 2,
                                child: textControllerWidget(
                                  context,
                                  addleadProvider
                                      .addLeadProductTotalPriceController,
                                  "Amount",
                                  "Total Amount",
                                  (p0) {},
                                  TextInputType.number,
                                  true,
                                  FilteringTextInputFormatter.digitsOnly,
                                ),
                              ),
                            ],
                          ),
                          TextWidget(context, "Status"),
                          DropdownButtonHideUnderline(
                            child: Row(
                              children: [
                                Expanded(
                                  child: DropdownButton2<String>(
                                    isExpanded: true,
                                    hint: const Row(
                                      children: [
                                        Expanded(
                                          child: Text(
                                            'Select Lead Status',
                                            style: TextStyle(fontSize: 14),
                                            overflow: TextOverflow.ellipsis,
                                          ),
                                        ),
                                      ],
                                    ),
                                    items:
                                    <String>['All', 'Cold', 'Hot', 'Warm']
                                        .map(
                                          (value) => DropdownMenuItem<String>(
                                        value: value,
                                        child: Text(
                                          value ?? '',
                                          style: const TextStyle(
                                            fontSize: 14,
                                          ),
                                          overflow: TextOverflow.ellipsis,
                                        ),
                                      ),
                                    )
                                        .toList(),
                                    value: addleadProvider.selectedStatus,
                                    onChanged: (String? newValue) {
                                      setState(() {
                                        addleadProvider.selectedStatus = newValue!;
                                      });
                                    },
                                    buttonStyleData: ddtheme.buttonStyleData,
                                    iconStyleData: ddtheme.iconStyleData,
                                    menuItemStyleData: ddtheme.menuItemStyleData,
                                    dropdownStyleData: ddtheme.dropdownStyleData,
                                  ),
                                ),
                              ],
                            ),
                          ),
                          if (addleadProvider.statusError != null) ...[
                            errorWidget(context, addleadProvider.statusError),
                          ],

                          TextWidget(context, "Remarks"),
                          Container(
                            margin: EdgeInsets.only(bottom: 6),
                            decoration: BoxDecoration(
                              color: AppColors.text_field_color,
                              borderRadius: BorderRadius.circular(14),
                            ),
                            child: TextFormField(
                              controller: addleadProvider.addLeadProductRemarksController,
                              maxLines: 3,
                              enabled: true,
                              style: TextStyle(
                                color: Colors.black,
                                fontSize: 14,
                              ),
                              decoration: InputDecoration(
                                hintText: "Enter remark",
                                hintStyle: TextStyle(
                                  color: Colors.grey.shade500,
                                  fontSize: 14,
                                ),
                                border: InputBorder.none,
                                contentPadding: EdgeInsets.symmetric(
                                    horizontal: 12, vertical: 12),
                              ),
                            ),
                          ),

                          InkResponse(
                            onTap:
                                addleadProvider.submitLoading
                                    ? null
                                    : () {
                                      // addleadProvider
                                      //     .crmProspectDetailsAddLeadsSubmitAPIFunction(
                                      //   context,
                                      //   widget.mode,
                                      //   provider.accountDetails.id,
                                      //   addleadProvider.selectedEmployeeId,
                                      //   {},
                                      //   addleadProvider.selectedStatus,
                                      // );
                                      addleadProvider
                                          .crmProspectDetailsAddLeadsSubmitAPIFunctionNew(
                                            context,
                                            mode,
                                            widget.leadId,
                                            provider.accountDetails.id,
                                            addleadProvider.selectedProductsID,
                                            addleadProvider.selectedStatus,
                                          );
                                    },
                            child: Container(
                              height: 45,
                              alignment: Alignment.center,
                              margin: const EdgeInsets.symmetric(
                                horizontal: 0,
                                vertical: 15,
                              ),
                              padding: const EdgeInsets.symmetric(
                                horizontal: 10,
                                vertical: 5,
                              ),
                              decoration: BoxDecoration(
                                color: AppColors.app_blue,
                                borderRadius: BorderRadius.circular(15),
                              ),
                              child:
                                  addleadProvider.submitLoading
                                      ? CircularProgressIndicator.adaptive(
                                        valueColor:
                                            AlwaysStoppedAnimation<Color>(
                                              AppColors.white,
                                            ),
                                      )
                                      : const Text(
                                        "Submit",
                                        style: TextStyle(
                                          fontSize: 15,
                                          fontFamily: "JakartaMedium",
                                          color: Colors.white,
                                        ),
                                      ),
                            ),
                          ),
                        ],
                      ),
                    ),
                  );
                },
              ),
            );
          },
        );
      },
    ).whenComplete(() {
      Provider.of<crmProspectDetailsProvider>(
        context,
      ).crmProspectDetailsAPIFunction(context, widget.leadId);
      Provider.of<Addprospectleadsprovider>(context).resetForm();
    });
  }
}
