class TechnicianPendingComplaintsResponse {
  List<TP_List>? list;
  int? error;
  int? sessionExists;

  TechnicianPendingComplaintsResponse({
    this.list,
    this.error,
    this.sessionExists,
  });

  TechnicianPendingComplaintsResponse.fromJson(Map<String, dynamic> json) {
    if (json['list'] != null) {
      list = <TP_List>[];
      json['list'].forEach((v) {
        list!.add(TP_List.fromJson(v));
      });
    }
    error = json['error'];
    sessionExists = json['session_exists'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    if (list != null) {
      data['list'] = list!.map((v) => v.toJson()).toList();
    }
    data['error'] = error;
    data['session_exists'] = sessionExists;
    return data;
  }
}

class TP_List {
  String? genId;
  String? address;
  String? loc;
  String? complaintId;
  String? companyName;
  String? productName;
  String? complaintCategory;
  String? compRegDatetime;
  String? mobileNo;
  String? contactName;
  String? engineNo;

  TP_List({
    this.genId,
    this.address,
    this.loc,
    this.complaintId,
    this.companyName,
    this.productName,
    this.complaintCategory,
    this.compRegDatetime,
    this.mobileNo,
    this.contactName,
    this.engineNo,
  });

  TP_List.fromJson(Map<String, dynamic> json) {
    genId = json['gen_id'];
    address = json['address'];
    loc = json['loc'];
    complaintId = json['complaint_id'];
    companyName = json['company_name'];
    productName = json['product_name'];
    complaintCategory = json['complaint_category'];
    compRegDatetime = json['comp_reg_datetime'];
    mobileNo = json['mobile_no'];
    contactName = json['contact_name'];
    engineNo = json['engine_number'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['gen_id'] = genId;
    data['address'] = address;
    data['loc'] = loc;
    data['complaint_id'] = complaintId;
    data['company_name'] = companyName;
    data['product_name'] = productName;
    data['complaint_category'] = complaintCategory;
    data['comp_reg_datetime'] = compRegDatetime;
    data['mobile_no'] = mobileNo;
    data['contact_name'] = contactName;
    data['engine_number'] = engineNo;
    return data;
  }
}
