import 'dart:io';

import 'package:connectivity_plus/connectivity_plus.dart';
import 'package:dotted_line/dotted_line.dart';
import 'package:flutter/material.dart';
import 'package:flutter_svg/svg.dart';
import 'package:generp/screens/screensExports.dart';
import 'package:generp/screens/notifierExports.dart';
import 'package:provider/provider.dart';
import '../../Utils/app_colors.dart';
import '../../Utils/commonServices.dart';
import '../../Utils/commonWidgets.dart';
import '../finance/FileViewer.dart';

class Tpcagentissuelistdetails extends StatefulWidget {
  final pageTitleName;
  final orderId;
  final mode;

  const Tpcagentissuelistdetails({
    super.key,
    required this.pageTitleName,
    required this.orderId,
    required this.mode,
  });

  @override
  State<Tpcagentissuelistdetails> createState() =>
      _TpcagentissuelistdetailsState();
}

class _TpcagentissuelistdetailsState extends State<Tpcagentissuelistdetails> {
  Map _source = {ConnectivityResult.mobile: true};
  final MyConnectivity _connectivity = MyConnectivity.instance;

  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    _connectivity.initialise();
    _connectivity.myStream.listen((source) {
      setState(() => _source = source);
    });
    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
      var provider = Provider.of<Pagesdashboardprovider>(
        context,
        listen: false,
      );
      provider.showMoreDetails = false;

      provider.ordersDetailsByModeAPIFunction(
        context,
        widget.orderId,
        widget.mode,
      );
    });
  }

  @override
  void dispose() {
    // TODO: implement dispose
    super.dispose();
    _connectivity.disposeStream();
  }

  Color getDecorationColor(value) {
    var color = AppColors.approved_bg_color;
    switch (value) {
      case 'Registered':
        return AppColors.requested_bg_color;
      case 'Level 1 Approved':
        return AppColors.approved_bg_color;
      case 'Level 1 Rejected':
        return AppColors.rejected_bg_color;
      case 'Level 2 Approved':
        return AppColors.approved_bg_color;
      case 'Level 2 Rejected':
        return AppColors.rejected_bg_color;
      case 'Sales Order Registered':
        return AppColors.processed_bg_color;
      case 'Dispatched':
        return AppColors.approved_bg_color;
    }
    return color;
  }

  Color getTextColor(value) {
    var color = AppColors.approved_text_color;
    switch (value) {
      case 'Registered':
        return AppColors.requested_text_color;
      case 'Level 1 Approved':
        return AppColors.approved_text_color;
      case 'Level 1 Rejected':
        return AppColors.rejected_text_color;
      case 'Level 2 Approved':
        return AppColors.approved_text_color;
      case 'Level 2 Rejected':
        return AppColors.rejected_text_color;
      case 'Sales Order Registered':
        return AppColors.processed_text_color;
      case 'Dispatched':
        return AppColors.approved_text_color;
    }
    return color;
  }

  getText(value) {
    var text = "R";
    switch (value) {
      case 'Registered':
        return "R";
      case 'Level 1 Approved':
        return "L1A";
      case 'Level 1 Rejected':
        return "L1R";
      case 'Level 2 Approved':
        return "L2A";
      case 'Level 2 Rejected':
        return "L2R";
      case 'Sales Order Registered':
        return "SOR";
      case 'Dispatched':
        return "D";
    }
    return text;
  }

  //All","Registered","Level 1 Approved","Level 2 Approved","Level 1 Rejected",
  // Level 2 Rejected","Level 2 Rejected Final","Sales Order Registered","Dispatched"

  double getSize(value) {
    var text = "A";
    switch (value) {
      case 'Registered':
        return 16.0;
      case 'Level 1 Approved':
        return 13.0;
      case 'Level 1 Rejected':
        return 13.0;
      case 'Level 2 Approved':
        return 13.0;
      case 'Level 2 Rejected':
        return 13.0;
      case 'Processed':
        return 16.0;
      case 'Sales Order Registered':
        return 13.0;
      case 'Dispatched':
        return 16.0;
    }
    return 18.0;
  }

  @override
  Widget build(BuildContext context) {
    switch (_source.keys.toList()[0]) {
      case ConnectivityResult.mobile:
        connection = 'Online';
        break;
      case ConnectivityResult.wifi:
        connection = 'Online';
        break;
      case ConnectivityResult.none:
      default:
        connection = 'Offline';
    }
    return (connection == "Online")
        ? Platform.isAndroid
            ? WillPopScope(
              onWillPop: () async {
                Provider.of<Tpcagentsprovider>(
                  context,
                  listen: false,
                ).resetAll();

                return onBackPressed(context);
              },
              child: SafeArea(
                top: false,
                bottom: true,
                child: _scaffold(context),
              ),
            )
            : _scaffold(context)
        : NoNetwork(context);
  }

  Widget _scaffold(BuildContext context) {
    return Consumer2<Pagesdashboardprovider, Tpcagentsprovider>(
      builder: (context, provider, tpcProvider, child) {
        var orderDetails = provider.orderDetails;
        final productsHistory = provider.productsHistory;
        final feedbackHistory = provider.feedbackHistory;
        final paymentHistory = provider.paymentHistory;

        final headings2 = [
          "Order Number",
          "Account Name",
          "Sales Person Name",
          "Order Received Date",
          "OTP",
        ];
        final subHeadings2 = [
          provider.orderDetails.orderNumber ?? "-",
          provider.orderDetails.accountName ?? "-",
          provider.orderDetails.salesPersonEmpName ?? "-",
          provider.orderDetails.orderReceivedDate ?? "-",
          provider.orderDetails.otp ?? "-",
        ];

        final headings3 = [
          "State",
          "District",
          "Sub Location",
          "Pincode",
          "Address",
          "Entered By",
        ];
        final subHeadings3 = [
          provider.orderDetails.billingState ?? "-",
          provider.orderDetails.billingDistrict ?? "-",
          provider.orderDetails.billingSubLocality ?? "-",
          provider.orderDetails.billingPincode ?? "-",
          provider.orderDetails.billingAddress ?? "-",
          provider.orderDetails.enteredEmpName ?? "-",
        ];
        final headings4 = [
          "State",
          "District",
          "Sub Location",
          "Pincode",
          "Address",
          "GST Number",
        ];
        final subHeadings4 = [
          provider.orderDetails.stateName ?? "-",
          provider.orderDetails.districtName ?? "-",
          provider.orderDetails.subLocationName ?? "-",
          provider.orderDetails.dispatchPincode ?? "-",
          provider.orderDetails.dispatchAddress ?? "-",

          provider.orderDetails.gstNumber ?? "-",
        ];
        final headings5 = ["Unloading", "Freight", "Erection"];
        final subHeadings5 = [
          provider.orderDetails.unloadingScope ?? "-",
          provider.orderDetails.freightScope ?? "-",
          provider.orderDetails.erectionScope ?? "-",
        ];
        final headings6 = ["CGST", "SGST", "IGST"];
        final subHeadings6 = [
          provider.orderDetails.cgstAmount ?? "-",
          provider.orderDetails.sgstAmount ?? "-",
          provider.orderDetails.igstAmount ?? "-",
        ];

        final headings7 = [
          "Basic Amount",
          "Paid Amount",
          "Balance Amount",
          "Total Amount",
        ];
        final subHeadings7 = [
          provider.orderDetails.basicAmount ?? "-",
          provider.orderDetails.paidAmount ?? "-",
          provider.orderDetails.balanceAmount ?? "-",
          provider.orderDetails.totalAmount ?? "-",
        ];

        final headings8 = [
          "TPC Applicable",
          "TPC Agent",
          "TPC Requested Amount",

          "TPC Level 1 Approved Amount",
          "TPC Level 2 Approved Amount",
        ];
        final subHeadings8 = [
          provider.orderDetails.tpcApplicable ?? "-",
          provider.orderDetails.tpcaAgentName ?? "-",
          provider.orderDetails.requestedTpcAmount ?? "-",

          provider.orderDetails.level1TpcApprovedAmount ?? "-",
          provider.orderDetails.level2TpcApprovedAmount ?? "-",
        ];

        final headings9 = [
          "TPC Payment Mode",
          "TPC Payment Reference No",
          "TPC Payment Attachment",
          "TPC Status",
          "Purchase Order",
        ];
        final subHeadings9 = [
          provider.orderDetails.tpcPaymentMode ?? "-",
          provider.orderDetails.tpcPaymentReferenceNo ?? "-",
          provider.orderDetails.tpcPaymentAttachementViewFileName ?? "-",
          provider.orderDetails.tpcStatus ?? "-",
          provider.orderDetails.tpcPaymentAttachmentDirFilePath ?? "-",
        ];

        final headings10 = ["Created Datetime", "Note", "Status"];
        final subHeadings10 = [
          provider.orderDetails.createdDatetime ?? "-",
          provider.orderDetails.note ?? "-",
          provider.orderDetails.status ?? "-",
        ];

        final sections = [
          {
            "title": "Order Details",
            "headings": headings2,
            "subHeadings": subHeadings2,
          },
          if (provider.showMoreDetails) ...[
            {
              "title": "Amount Details",
              "headings": headings7,
              "subHeadings": subHeadings7,
            },
            {
              "title": "GST Amount",
              "headings": headings6,
              "subHeadings": subHeadings6,
            },

            {
              "title": "Billing Details",
              "headings": headings3,
              "subHeadings": subHeadings3,
            },
            {
              "title": "Dispatch Details",
              "headings": headings4,
              "subHeadings": subHeadings4,
            },
            {
              "title": "Scope",
              "headings": headings5,
              "subHeadings": subHeadings5,
            },
            {
              "title": "TPC Details",
              "headings": headings8,
              "subHeadings": subHeadings8,
            },
            {
              "title": "TPC Payment Details",
              "headings": headings9,
              "subHeadings": subHeadings9,
            },
            {
              "title": "Others",
              "headings": headings10,
              "subHeadings": subHeadings10,
            },
          ],
        ];

        return Scaffold(
          resizeToAvoidBottomInset: true,
          appBar: appbar2New(
            context,
            widget.pageTitleName,
            provider.resetAll,
            SizedBox.shrink(),
            0xFFFFFFFF,
          ),
          backgroundColor: AppColors.scaffold_bg_color,
          body: SingleChildScrollView(
            child: Column(
              children: [
                Card(
                  margin: EdgeInsets.symmetric(horizontal: 0, vertical: 2),
                  shape: RoundedRectangleBorder(
                    borderRadius: BorderRadius.only(
                      bottomLeft: Radius.circular(30),
                      bottomRight: Radius.circular(30),
                    ),
                  ),
                  elevation: 2,
                  child: Container(
                    decoration: BoxDecoration(
                      color: Colors.white,
                      borderRadius: BorderRadius.only(
                        bottomLeft: Radius.circular(30),
                        bottomRight: Radius.circular(30),
                      ),
                    ),
                    // margin: EdgeInsets.symmetric(vertical: 10, horizontal: 10),
                    padding: EdgeInsets.symmetric(vertical: 10, horizontal: 10),
                    child: Column(
                      children: [
                        Row(
                          children: [
                            Expanded(
                              flex: 1,
                              child: Container(
                                height: 45,
                                width: 45,
                                padding: EdgeInsets.all(7.5),
                                decoration: BoxDecoration(
                                  color: Color(0xFFE6F6FF),
                                  shape: BoxShape.circle,
                                  // borderRadius: BorderRadius.circular(8),
                                ),
                                child: SvgPicture.asset(
                                  "assets/svg/fin_ic.svg",
                                ),
                              ),
                            ),
                            SizedBox(width: 10),
                            Expanded(
                              flex: 4,
                              child: SizedBox(
                                child: Column(
                                  crossAxisAlignment: CrossAxisAlignment.start,
                                  children: [
                                    InkResponse(
                                      onTap: () {},
                                      child: Padding(
                                        padding: const EdgeInsets.only(
                                          top: 8.0,
                                          bottom: 4,
                                        ),
                                        child: Text(
                                          orderDetails.accountName == ""
                                              ? "-"
                                              : orderDetails.accountName ?? "-",
                                          style: TextStyle(
                                            decoration:
                                                TextDecoration.underline,
                                            decorationStyle:
                                                TextDecorationStyle.dotted,
                                            decorationColor:
                                                AppColors.grey_thick,
                                            height: 1.2,
                                            fontFamily: "JakartaRegular",
                                            fontSize: 14,
                                            color: AppColors.semi_black,
                                          ),
                                        ),
                                      ),
                                    ),
                                    Text(
                                      orderDetails.balanceAmount == ""
                                          ? "-"
                                          : "₹${orderDetails.balanceAmount}",
                                      style: TextStyle(
                                        fontFamily: "JakartaRegular",
                                        fontSize: 14,
                                        color: AppColors.app_blue,
                                      ),
                                    ),
                                  ],
                                ),
                              ),
                            ),

                            Expanded(
                              flex: 2,
                              child: Container(
                                padding: EdgeInsets.symmetric(
                                  horizontal: 5,
                                  vertical: 10,
                                ),
                                decoration: BoxDecoration(
                                  borderRadius: BorderRadius.circular(8),
                                  color: getDecorationColor(
                                    orderDetails.status ?? "-",
                                  ),
                                ),
                                child: Center(
                                  child: Text(
                                    orderDetails.status ?? "-",
                                    textAlign: TextAlign.center,
                                    style: TextStyle(
                                      fontFamily: "JakartaMedium",
                                      fontSize: 14,
                                      color: getTextColor(orderDetails.status),
                                    ),
                                  ),
                                ),
                              ),
                            ),
                          ],
                        ),
                        SizedBox(height: 10),
                        Column(
                          children: List.generate(sections.length, (
                            sectionIndex,
                          ) {
                            final section = sections[sectionIndex];
                            final title = section["title"] as String;
                            final headings =
                                section["headings"] as List<String>;
                            final subHeadings =
                                section["subHeadings"] as List<String>;

                            return Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: [
                                Container(
                                  padding: EdgeInsets.symmetric(vertical: 4),
                                  child: Row(
                                    children: [
                                      Expanded(
                                        flex: 3,
                                        child: Text(
                                          title,
                                          style: TextStyle(
                                            fontSize: 14,
                                            fontFamily: "JakartaSemiBold",
                                          ),
                                        ),
                                      ),
                                      Expanded(
                                        flex: 6,
                                        child: DottedLine(
                                          dashGapLength: 4,
                                          dashGapColor: Colors.white,
                                          dashColor: AppColors.grey_semi,
                                          dashLength: 2,
                                          lineThickness: 0.5,
                                        ),
                                      ),
                                    ],
                                  ),
                                ),

                                Column(
                                  children: List.generate(headings.length, (j) {
                                    return Container(
                                      padding: EdgeInsets.symmetric(
                                        vertical: 7,
                                      ),
                                      child: Row(
                                        crossAxisAlignment:
                                            CrossAxisAlignment.start,
                                        children: [
                                          Expanded(
                                            child: Text(
                                              headings[j],
                                              style: TextStyle(
                                                fontFamily: "JakartaRegular",
                                                fontSize: 14,
                                                color: AppColors.semi_black,
                                              ),
                                            ),
                                          ),
                                          Expanded(
                                            child: InkResponse(
                                              onTap:
                                                  subHeadings[j] == "View"
                                                      ? () {}
                                                      : null,
                                              child: Text(
                                                subHeadings[j].isEmpty
                                                    ? "-"
                                                    : subHeadings[j],
                                                textAlign: TextAlign.right,
                                                style: TextStyle(
                                                  fontSize: 14,

                                                  decoration:
                                                      subHeadings[j] == "View"
                                                          ? TextDecoration
                                                              .underline
                                                          : TextDecoration.none,
                                                  decorationColor:
                                                      AppColors.app_blue,
                                                  color:
                                                      subHeadings[j] == "View"
                                                          ? AppColors.app_blue
                                                          : Color(0xFF818181),
                                                ),
                                              ),
                                            ),
                                          ),
                                        ],
                                      ),
                                    );
                                  }),
                                ),
                              ],
                            );
                          }),
                        ),

                        InkResponse(
                          onTap: () async {
                            provider.showMoreDetails =
                                !provider.showMoreDetails;
                          },
                          child: Container(
                            padding: EdgeInsets.symmetric(vertical: 5),
                            child: Row(
                              crossAxisAlignment: CrossAxisAlignment.center,
                              mainAxisAlignment: MainAxisAlignment.center,
                              children: [
                                Text(
                                  provider.showMoreDetails
                                      ? "Hide Details"
                                      : "View Details",
                                  style: TextStyle(
                                    fontFamily: "JakartaMedium",
                                    fontSize: 14,
                                    color: AppColors.app_blue,
                                  ),
                                ),
                                Transform.flip(
                                  flipY:
                                      provider.showMoreDetails ? true : false,
                                  child: SvgPicture.asset(
                                    "assets/svg/arrow_dropdown.svg",
                                    height: 25,
                                    width: 20,
                                    color: AppColors.app_blue,
                                  ),
                                ),
                              ],
                            ),
                          ),
                        ),
                        SizedBox(height: 10),
                      ],
                    ),
                  ),
                ),

                Column(
                  children: [
                    ///product details
                    if (productsHistory.isNotEmpty) ...[
                      Container(
                        padding: EdgeInsets.only(left: 10, right: 10, top: 10),
                        child: Row(
                          children: [
                            Expanded(
                              child: Text(
                                textAlign: TextAlign.left,
                                "Product Details",
                                style: TextStyle(
                                  fontFamily: "JakartaMedium",
                                  fontSize: 14,
                                  color: AppColors.grey_thick,
                                ),
                              ),
                            ),
                          ],
                        ),
                      ),

                      SizedBox(
                        width: double.infinity,
                        height: 260,
                        child: ListView.builder(
                          physics: AlwaysScrollableScrollPhysics(),
                          shrinkWrap: true,
                          scrollDirection: Axis.horizontal,
                          padding: EdgeInsets.symmetric(
                            vertical: 5,
                            horizontal: 10,
                          ),
                          itemCount: productsHistory.length,
                          itemBuilder: (context, lp) {
                            return Container(
                              height: 260,
                              width: MediaQuery.of(context).size.width * 0.9,
                              decoration: BoxDecoration(
                                color: Colors.white,
                                borderRadius: BorderRadius.circular(14),
                              ),
                              padding: EdgeInsets.symmetric(
                                horizontal: 10,
                                vertical: 8,
                              ),

                              margin: EdgeInsets.symmetric(
                                horizontal: 5,
                                // vertical: 10,
                              ),

                              child: Column(
                                children: [
                                  Row(
                                    mainAxisAlignment: MainAxisAlignment.start,
                                    crossAxisAlignment:
                                        CrossAxisAlignment.start,
                                    children: [
                                      Expanded(
                                        flex: 1,
                                        child: SvgPicture.asset(
                                          "assets/svg/crm/product_details_ic.svg",
                                        ),
                                      ),
                                      SizedBox(width: 10),
                                      Expanded(
                                        flex: 6,
                                        child: SizedBox(
                                          child: Column(
                                            // mainAxisAlignment: MainAxisAlignment.start,
                                            crossAxisAlignment:
                                                CrossAxisAlignment.start,
                                            mainAxisAlignment:
                                                MainAxisAlignment.start,
                                            children: [
                                              Row(
                                                children: [
                                                  Expanded(
                                                    flex: 4,
                                                    child: Text(
                                                      productsHistory[lp]
                                                              .productName ??
                                                          "-",
                                                      maxLines: 2,
                                                      overflow:
                                                          TextOverflow.ellipsis,
                                                      style: TextStyle(
                                                        fontFamily:
                                                            "JakartaMedium",
                                                        fontSize: 14,
                                                        color:
                                                            AppColors
                                                                .semi_black,
                                                      ),
                                                    ),
                                                  ),
                                                  Expanded(
                                                    flex: 3,
                                                    child: Text(
                                                      textAlign:
                                                          TextAlign.right,
                                                      "₹${productsHistory[lp].totalPrice ?? "-"}",
                                                      style: TextStyle(
                                                        fontFamily:
                                                            "JakartaMedium",
                                                        fontSize: 14,
                                                        color:
                                                            AppColors.app_blue,
                                                      ),
                                                    ),
                                                  ),
                                                ],
                                              ),
                                              Text(
                                                "x  ${productsHistory[lp].qty ?? "-"}",
                                                style: TextStyle(
                                                  fontFamily: "JakartaMedium",
                                                  fontSize: 14,
                                                  color: AppColors.grey_semi,
                                                ),
                                              ),

                                              // DottedLine(
                                              //   dashGapLength: 4,
                                              //   dashGapColor: Colors.white,
                                              //   dashColor: AppColors.grey_semi,
                                              //   dashLength: 2,
                                              //   lineThickness: 0.5,
                                              // ),
                                              // SizedBox(height: 5),
                                              // Text(
                                              //   "₹${productsHistory[lp].totalPrice ?? " - "}",
                                              //   style: TextStyle(
                                              //     fontFamily: "JakartaMedium",
                                              //     fontSize: 14,
                                              //     color: AppColors.semi_black,
                                              //   ),
                                              // ),
                                            ],
                                          ),
                                        ),
                                      ),
                                    ],
                                  ),
                                  Container(
                                    padding: EdgeInsets.symmetric(
                                      vertical: 7.5,
                                    ),
                                    child: Row(
                                      children: [
                                        Expanded(
                                          flex: 3,
                                          child: Text(
                                            "Tax Details",
                                            style: TextStyle(
                                              fontSize: 14,
                                              fontFamily: "JakartaSemiBold",
                                            ),
                                          ),
                                        ),
                                        Expanded(
                                          flex: 7,
                                          child: DottedLine(
                                            dashGapLength: 4,
                                            dashGapColor: Colors.white,
                                            dashColor: AppColors.grey_semi,
                                            dashLength: 2,
                                            lineThickness: 0.5,
                                          ),
                                        ),
                                      ],
                                    ),
                                  ),
                                  ...List.generate(3, (j) {
                                    final heads = [
                                      "CGST (%)",
                                      "SGST (%)",
                                      "IGST (%)",
                                    ];
                                    final subHeads = [
                                      productsHistory[lp].cgstPercentage ?? "-",
                                      productsHistory[lp].sgstPercentage ?? "-",
                                      productsHistory[lp].igstPercentage ?? "-",
                                    ];
                                    return Container(
                                      padding: EdgeInsets.symmetric(
                                        vertical: 3,
                                      ),
                                      child: Row(
                                        crossAxisAlignment:
                                            CrossAxisAlignment.start,
                                        children: [
                                          Expanded(
                                            child: Text(
                                              textAlign: TextAlign.left,
                                              heads[j],
                                              style: TextStyle(
                                                fontFamily: "JakartaRegular",
                                                fontSize: 14,
                                                color: AppColors.semi_black,
                                              ),
                                            ),
                                          ),
                                          if (subHeads[j] == "View") ...[
                                            Expanded(
                                              child: InkResponse(
                                                onTap: () {
                                                  Navigator.push(
                                                    context,
                                                    MaterialPageRoute(
                                                      builder:
                                                          (
                                                            context,
                                                          ) => Fileviewer(
                                                            fileName:
                                                                feedbackHistory[lp]
                                                                    .attachmentViewFileName!,
                                                            fileUrl:
                                                                feedbackHistory[lp]
                                                                    .attachmentDirFilePath!,
                                                          ),
                                                    ),
                                                  );
                                                },
                                                child: Text(
                                                  textAlign: TextAlign.right,
                                                  subHeads[j] == ""
                                                      ? "-"
                                                      : subHeads[j],
                                                  style: TextStyle(
                                                    fontSize: 14,
                                                    color: AppColors.app_blue,
                                                    decorationColor:
                                                        AppColors.app_blue,
                                                    decoration:
                                                        TextDecoration
                                                            .underline,
                                                  ),
                                                ),
                                              ),
                                            ),
                                          ] else ...[
                                            Expanded(
                                              child: Text(
                                                textAlign: TextAlign.right,
                                                subHeads[j] == ""
                                                    ? "-"
                                                    : subHeads[j],
                                                style: TextStyle(
                                                  fontSize: 14,
                                                  color: Color(0xFF818181),
                                                ),
                                              ),
                                            ),
                                          ],
                                        ],
                                      ),
                                    );
                                  }),

                                  Container(
                                    padding: EdgeInsets.symmetric(
                                      vertical: 7.5,
                                    ),
                                    child: Row(
                                      children: [
                                        Expanded(
                                          flex: 3,
                                          child: Text(
                                            "Price Details",
                                            style: TextStyle(
                                              fontSize: 14,
                                              fontFamily: "JakartaSemiBold",
                                            ),
                                          ),
                                        ),
                                        Expanded(
                                          flex: 7,
                                          child: DottedLine(
                                            dashGapLength: 4,
                                            dashGapColor: Colors.white,
                                            dashColor: AppColors.grey_semi,
                                            dashLength: 2,
                                            lineThickness: 0.5,
                                          ),
                                        ),
                                      ],
                                    ),
                                  ),
                                  ...List.generate(1, (j) {
                                    final heads = [
                                      // "Unit Price",
                                      "Total Price",
                                    ];
                                    final subHeads = [
                                      // "₹ ${productsHistory[lp].unitPrice ?? "-"}",
                                      "₹ ${productsHistory[lp].totalPrice ?? "-"}",
                                    ];
                                    return Container(
                                      padding: EdgeInsets.symmetric(
                                        vertical: 3,
                                      ),
                                      child: Row(
                                        crossAxisAlignment:
                                            CrossAxisAlignment.start,
                                        children: [
                                          Expanded(
                                            child: Text(
                                              textAlign: TextAlign.left,
                                              heads[j],
                                              style: TextStyle(
                                                fontFamily: "JakartaRegular",
                                                fontSize: 14,
                                                color: AppColors.semi_black,
                                              ),
                                            ),
                                          ),
                                          if (subHeads[j] == "View") ...[
                                            Expanded(
                                              child: InkResponse(
                                                onTap: () {
                                                  Navigator.push(
                                                    context,
                                                    MaterialPageRoute(
                                                      builder:
                                                          (
                                                            context,
                                                          ) => Fileviewer(
                                                            fileName:
                                                                feedbackHistory[lp]
                                                                    .attachmentViewFileName!,
                                                            fileUrl:
                                                                feedbackHistory[lp]
                                                                    .attachmentDirFilePath!,
                                                          ),
                                                    ),
                                                  );
                                                },
                                                child: Text(
                                                  textAlign: TextAlign.right,
                                                  subHeads[j] == ""
                                                      ? "-"
                                                      : subHeads[j],
                                                  style: TextStyle(
                                                    fontSize: 14,
                                                    color: AppColors.app_blue,
                                                    decorationColor:
                                                        AppColors.app_blue,
                                                    decoration:
                                                        TextDecoration
                                                            .underline,
                                                  ),
                                                ),
                                              ),
                                            ),
                                          ] else ...[
                                            Expanded(
                                              child: Text(
                                                textAlign: TextAlign.right,
                                                subHeads[j] == ""
                                                    ? "-"
                                                    : subHeads[j],
                                                style: TextStyle(
                                                  fontSize: 14,
                                                  color: Color(0xFF818181),
                                                ),
                                              ),
                                            ),
                                          ],
                                        ],
                                      ),
                                    );
                                  }),
                                ],
                              ),
                            );
                          },
                        ),
                      ),
                    ],

                    ///Feedback details
                    Container(
                      padding: EdgeInsets.only(left: 10, right: 10, top: 10),
                      child: Row(
                        children: [
                          Expanded(
                            child: Text(
                              textAlign: TextAlign.left,
                              "Feedback Details",
                              style: TextStyle(
                                fontFamily: "JakartaMedium",
                                fontSize: 14,
                                color: AppColors.grey_thick,
                              ),
                            ),
                          ),
                          if (feedbackHistory.isNotEmpty) ...[
                            Expanded(
                              child: InkResponse(
                                onTap: () async {
                                  _showFeedbackSheet(context);
                                },
                                child: Padding(
                                  padding: const EdgeInsets.all(8.0),
                                  child: Text(
                                    textAlign: TextAlign.right,
                                    "+ Feedback Update",
                                    style: TextStyle(
                                      fontFamily: "JakartaMedium",
                                      fontSize: 14,
                                      color: AppColors.app_blue,
                                    ),
                                  ),
                                ),
                              ),
                            ),
                          ],
                        ],
                      ),
                    ),
                    if (feedbackHistory.isNotEmpty) ...[
                      SizedBox(
                        width: double.infinity,
                        height: 220,
                        child: ListView.builder(
                          physics: AlwaysScrollableScrollPhysics(),
                          shrinkWrap: true,
                          scrollDirection: Axis.horizontal,
                          padding: EdgeInsets.symmetric(
                            vertical: 10,
                            horizontal: 10,
                          ),
                          itemCount: feedbackHistory.length,
                          itemBuilder: (context, lp) {
                            return Container(
                              height: 220,
                              width: MediaQuery.of(context).size.width * 0.9,
                              decoration: BoxDecoration(
                                color: Colors.white,
                                borderRadius: BorderRadius.circular(14),
                              ),
                              padding: EdgeInsets.symmetric(
                                horizontal: 10,
                                vertical: 10,
                              ),
                              margin: EdgeInsets.symmetric(horizontal: 5),

                              child: Column(
                                crossAxisAlignment: CrossAxisAlignment.start,
                                children: [
                                  Row(
                                    mainAxisAlignment: MainAxisAlignment.start,
                                    crossAxisAlignment:
                                        CrossAxisAlignment.start,
                                    children: [
                                      Expanded(
                                        flex: 1,
                                        child: SvgPicture.asset(
                                          "assets/svg/crm/followup_details_ic.svg",
                                        ),
                                      ),
                                      SizedBox(width: 10),
                                      Expanded(
                                        flex: 6,
                                        child: SizedBox(
                                          child: Column(
                                            // mainAxisAlignment: MainAxisAlignment.start,
                                            crossAxisAlignment:
                                                CrossAxisAlignment.start,
                                            mainAxisAlignment:
                                                MainAxisAlignment.start,
                                            children: [
                                              Row(
                                                children: [
                                                  Expanded(
                                                    flex: 4,
                                                    child: Column(
                                                      crossAxisAlignment:
                                                          CrossAxisAlignment
                                                              .start,
                                                      children: [
                                                        Text(
                                                          feedbackHistory[lp]
                                                                  .employeNaem ??
                                                              "-",
                                                          maxLines: 2,
                                                          overflow:
                                                              TextOverflow
                                                                  .ellipsis,
                                                          style: TextStyle(
                                                            fontFamily:
                                                                "JakartaMedium",
                                                            fontSize: 14,
                                                            color:
                                                                AppColors
                                                                    .semi_black,
                                                          ),
                                                        ),
                                                        Text(
                                                          feedbackHistory[lp]
                                                                  .createdDatetime ??
                                                              "-",
                                                          style: TextStyle(
                                                            fontFamily:
                                                                "JakartaMedium",
                                                            fontSize: 14,
                                                            color:
                                                                AppColors
                                                                    .grey_semi,
                                                          ),
                                                        ),
                                                      ],
                                                    ),
                                                  ),
                                                  Expanded(
                                                    flex: 4,
                                                    child: Container(
                                                      decoration: BoxDecoration(
                                                        borderRadius:
                                                            BorderRadius.circular(
                                                              8,
                                                            ),
                                                        color: Color(
                                                          0xFFF3FFD5,
                                                        ),
                                                      ),
                                                      padding:
                                                          EdgeInsets.symmetric(
                                                            horizontal: 5,
                                                            vertical: 10,
                                                          ),
                                                      child: Center(
                                                        child: Text(
                                                          textAlign:
                                                              TextAlign.center,
                                                          feedbackHistory[lp]
                                                                  .status ??
                                                              "-",
                                                          style: TextStyle(
                                                            fontFamily:
                                                                "JakartaMedium",
                                                            fontSize: 14,
                                                            color: Color(
                                                              0xFF586000,
                                                            ),
                                                          ),
                                                        ),
                                                      ),
                                                    ),
                                                  ),
                                                ],
                                              ),
                                            ],
                                          ),
                                        ),
                                      ),
                                    ],
                                  ),
                                  Container(
                                    padding: EdgeInsets.symmetric(
                                      vertical: 7.5,
                                    ),
                                    child: Row(
                                      children: [
                                        Expanded(
                                          flex: 3,
                                          child: Text(
                                            "Feedback",
                                            style: TextStyle(
                                              fontSize: 14,
                                              fontFamily: "JakartaSemiBold",
                                            ),
                                          ),
                                        ),
                                        Expanded(
                                          flex: 7,
                                          child: DottedLine(
                                            dashGapLength: 4,
                                            dashGapColor: Colors.white,
                                            dashColor: AppColors.grey_semi,
                                            dashLength: 2,
                                            lineThickness: 0.5,
                                          ),
                                        ),
                                      ],
                                    ),
                                  ),
                                  ...List.generate(2, (j) {
                                    final heads = ["Feedback", "Attachment"];
                                    final subHeads = [
                                      feedbackHistory[lp].feedback ?? "-",
                                      "View",
                                    ];
                                    return Container(
                                      padding: EdgeInsets.symmetric(
                                        vertical: 3,
                                      ),
                                      child: Row(
                                        crossAxisAlignment:
                                            CrossAxisAlignment.start,
                                        children: [
                                          Expanded(
                                            flex: 1,
                                            child: Text(
                                              textAlign: TextAlign.left,
                                              heads[j],
                                              style: TextStyle(
                                                fontFamily: "JakartaRegular",
                                                fontSize: 14,
                                                color: AppColors.semi_black,
                                              ),
                                            ),
                                          ),
                                          if (subHeads[j] == "View") ...[
                                            Expanded(
                                              flex: 3,
                                              child: InkResponse(
                                                onTap: () {
                                                  Navigator.push(
                                                    context,
                                                    MaterialPageRoute(
                                                      builder:
                                                          (
                                                            context,
                                                          ) => Fileviewer(
                                                            fileName:
                                                                feedbackHistory[lp]
                                                                    .attachmentViewFileName!,
                                                            fileUrl:
                                                                feedbackHistory[lp]
                                                                    .attachmentDirFilePath!,
                                                          ),
                                                    ),
                                                  );
                                                },
                                                child: Text(
                                                  textAlign: TextAlign.right,
                                                  subHeads[j] == ""
                                                      ? "-"
                                                      : subHeads[j],
                                                  style: TextStyle(
                                                    fontSize: 14,
                                                    color: AppColors.app_blue,
                                                    decorationColor:
                                                        AppColors.app_blue,
                                                    decoration:
                                                        TextDecoration
                                                            .underline,
                                                  ),
                                                ),
                                              ),
                                            ),
                                          ] else ...[
                                            Expanded(
                                              flex: 4,
                                              child: Text(
                                                textAlign: TextAlign.right,
                                                subHeads[j] == ""
                                                    ? "-"
                                                    : subHeads[j],
                                                maxLines: 2,
                                                style: TextStyle(
                                                  fontSize: 14,
                                                  color: Color(0xFF818181),
                                                ),
                                              ),
                                            ),
                                          ],
                                        ],
                                      ),
                                    );
                                  }),
                                ],
                              ),
                            );
                          },
                        ),
                      ),
                    ] else ...[
                      InkResponse(
                        onTap: () async {
                          _showFeedbackSheet(context);
                        },
                        child: Container(
                          height: 50,
                          margin: EdgeInsets.symmetric(
                            horizontal: 10,
                            vertical: 10,
                          ),
                          decoration: BoxDecoration(
                            color: Colors.white,
                            borderRadius: BorderRadius.circular(16),
                          ),
                          child: Center(
                            child: Text(
                              textAlign: TextAlign.right,
                              "+ Feedback Update",
                              style: TextStyle(
                                fontFamily: "JakartaMedium",
                                fontSize: 14,
                                color: AppColors.app_blue,
                              ),
                            ),
                          ),
                        ),
                      ),
                    ],

                    ///PaymentHistory details
                    if (paymentHistory.isNotEmpty) ...[
                      Container(
                        padding: EdgeInsets.only(left: 10, right: 10, top: 10),
                        child: Row(
                          children: [
                            Expanded(
                              child: Text(
                                textAlign: TextAlign.left,
                                "Payment Details",
                                style: TextStyle(
                                  fontFamily: "JakartaMedium",
                                  fontSize: 14,
                                  color: AppColors.grey_thick,
                                ),
                              ),
                            ),
                          ],
                        ),
                      ),
                      SizedBox(
                        width: double.infinity,
                        height: 225,
                        child: ListView.builder(
                          physics: AlwaysScrollableScrollPhysics(),
                          shrinkWrap: true,
                          scrollDirection: Axis.horizontal,
                          padding: EdgeInsets.symmetric(
                            vertical: 10,
                            horizontal: 10,
                          ),
                          itemCount: paymentHistory.length,
                          itemBuilder: (context, lp) {
                            return Container(
                              height: 225,
                              width: MediaQuery.of(context).size.width * 0.9,
                              decoration: BoxDecoration(
                                color: Colors.white,
                                borderRadius: BorderRadius.circular(14),
                              ),
                              padding: EdgeInsets.symmetric(
                                horizontal: 10,
                                vertical: 10,
                              ),
                              margin: EdgeInsets.symmetric(horizontal: 5),

                              child: Column(
                                children: [
                                  Row(
                                    mainAxisAlignment: MainAxisAlignment.start,
                                    crossAxisAlignment:
                                        CrossAxisAlignment.start,
                                    children: [
                                      Expanded(
                                        flex: 1,
                                        child: SvgPicture.asset(
                                          "assets/svg/order/payment_history_ic.svg",
                                        ),
                                      ),
                                      SizedBox(width: 10),
                                      Expanded(
                                        flex: 6,
                                        child: SizedBox(
                                          child: Column(
                                            // mainAxisAlignment: MainAxisAlignment.start,
                                            crossAxisAlignment:
                                                CrossAxisAlignment.start,
                                            mainAxisAlignment:
                                                MainAxisAlignment.start,
                                            children: [
                                              Row(
                                                children: [
                                                  Expanded(
                                                    flex: 4,
                                                    child: Column(
                                                      crossAxisAlignment:
                                                          CrossAxisAlignment
                                                              .start,
                                                      children: [
                                                        Text(
                                                          paymentHistory[lp]
                                                                  .ename ??
                                                              "-",
                                                          style: TextStyle(
                                                            fontFamily:
                                                                "JakartaMedium",
                                                            fontSize: 14,
                                                            color:
                                                                AppColors
                                                                    .semi_black,
                                                          ),
                                                        ),
                                                        Text(
                                                          "₹ ${paymentHistory[lp].amount ?? "-"}",
                                                          style: TextStyle(
                                                            fontFamily:
                                                                "JakartaMedium",
                                                            fontSize: 14,
                                                            color:
                                                                AppColors
                                                                    .grey_semi,
                                                          ),
                                                        ),
                                                      ],
                                                    ),
                                                  ),
                                                ],
                                              ),
                                            ],
                                          ),
                                        ),
                                      ),
                                      Expanded(
                                        flex: 2,
                                        child: Container(
                                          height: 45,
                                          padding: EdgeInsets.symmetric(
                                            horizontal: 5,
                                          ),
                                          decoration: BoxDecoration(
                                            color: AppColors.processed_bg_color,
                                            borderRadius: BorderRadius.circular(
                                              8,
                                            ),
                                          ),
                                          child: Center(
                                            child: Text(
                                              paymentHistory[lp]
                                                      .approvalStatus ??
                                                  "-",
                                              textAlign: TextAlign.right,
                                              style: TextStyle(
                                                fontFamily: "JakartaMedium",
                                                fontSize: 14,
                                                color:
                                                    AppColors
                                                        .processed_text_color,
                                              ),
                                            ),
                                          ),
                                        ),
                                      ),
                                    ],
                                  ),
                                  Container(
                                    padding: EdgeInsets.symmetric(vertical: 10),
                                    child: Row(
                                      children: [
                                        Expanded(
                                          flex: 4,
                                          child: Text(
                                            "Payment Info",
                                            style: TextStyle(
                                              fontSize: 14,
                                              fontFamily: "JakartaSemiBold",
                                            ),
                                          ),
                                        ),
                                        Expanded(
                                          flex: 6,
                                          child: DottedLine(
                                            dashGapLength: 4,
                                            dashGapColor: Colors.white,
                                            dashColor: AppColors.grey_semi,
                                            dashLength: 2,
                                            lineThickness: 0.5,
                                          ),
                                        ),
                                      ],
                                    ),
                                  ),
                                  ...List.generate(3, (j) {
                                    final headsa = [
                                      "Mode of Payment",
                                      "Payment Reference",
                                      "Adjusted Amount",
                                      "Payment Date",
                                    ];
                                    final subHeadsa = [
                                      paymentHistory[lp].paymentType ?? "-",
                                      paymentHistory[lp].refNo ?? "-",
                                      "₹${paymentHistory[lp].adjustedAmount ?? "-"}",
                                      paymentHistory[lp].paymentDate ?? "-",
                                    ];
                                    return Container(
                                      padding: EdgeInsets.symmetric(
                                        vertical: 3,
                                      ),
                                      child: Row(
                                        crossAxisAlignment:
                                            CrossAxisAlignment.start,
                                        children: [
                                          Expanded(
                                            child: Text(
                                              textAlign: TextAlign.left,
                                              headsa[j],
                                              style: TextStyle(
                                                fontFamily: "JakartaRegular",
                                                fontSize: 14,
                                                color: AppColors.semi_black,
                                              ),
                                            ),
                                          ),
                                          Expanded(
                                            child: Text(
                                              textAlign: TextAlign.right,
                                              subHeadsa[j] == ""
                                                  ? "-"
                                                  : subHeadsa[j],
                                              style: TextStyle(
                                                fontSize: 14,
                                                color: Color(0xFF818181),
                                              ),
                                            ),
                                          ),
                                        ],
                                      ),
                                    );
                                  }),
                                ],
                              ),
                            );
                          },
                        ),
                      ),
                    ],
                  ],
                ),
              ],
            ),
          ),
          bottomNavigationBar: Container(
            decoration: BoxDecoration(color: Colors.white),
            alignment: Alignment.center,
            height: 65,
            child: Row(
              mainAxisAlignment: MainAxisAlignment.center,
              children: [
                Expanded(
                  child: InkResponse(
                    onTap: () {
                      // provider
                      //     .approveRejectPaymentRequestAPIFunction(
                      //   context,
                      //   provider.requestsDetails.id,
                      // );
                      _showLevelApprovalSheet(context);
                    },
                    child: Container(
                      // decoration: BoxDecoration(
                      //   borderRadius: BorderRadius.circular(8),
                      //   color: Color(0xFFE7FFE5),
                      //   border: Border.all(
                      //     color: Color(0xFF0D9C00),
                      //     width: 0.5,
                      //   ),
                      // ),
                      child: Row(
                        mainAxisAlignment: MainAxisAlignment.center,
                        children: [
                          SvgPicture.asset(
                            "assets/svg/finance/level_approve_ic.svg",
                          ),
                          SizedBox(width: 10),
                          Center(
                            child: Text(
                              "Approve",
                              style: TextStyle(color: AppColors.semi_black),
                            ),
                          ),
                        ],
                      ),
                    ),
                  ),
                ),
              ],
            ),
          ),
        );
      },
    );
  }

  Widget _scaffold1(BuildContext context) {
    return Consumer2<Pagesdashboardprovider, Tpcagentsprovider>(
      builder: (context, provider, tpcProvider, child) {
        var orderDetails = provider.orderDetails;

        var Headings1 = [
          "Order Number",
          "Account Name",
          "Sales Person Name",
          "Order Received Date",
        ];
        var subHeadings1 = [
          provider.orderDetails.orderNumber ?? "-",
          provider.orderDetails.accountName ?? "-",
          provider.orderDetails.salesPersonEmpName ?? "-",
          provider.orderDetails.orderReceivedDate ?? "-",
        ];

        var Headings2 = [
          "Billing State",
          "Billing District",
          "Billing Sub Location",
          "Billing Pincode",
          "Billing Address",

          "Entered By",

          "Dispatch State",
          "Dispatch District",
          "District Sub Location",
          "Dispatch Pincode",
          "Dispatch Address",

          "GST Number",

          "Unloading Scope",
          "Freight Scope",
          "Erection Scope",

          "CGST Amount",
          "SGST Amount",
          "IGST Amount",

          "OTP",

          "Basic Amount",
          "Paid Amount",
          "Balance Amount",
          "Total Amount",

          "TPC Applicable",
          "TPC Agent",
          "TPC Requested Amount",

          "TPC Level 1 Approved Amount",
          "TPC Level 2 Approved Amount",

          "TPC Payment Mode",
          "TPC Payment Reference No",
          "TPC Payment Attachment",
          "TPC Status",
          "Purchase Order",

          "Created Datetime",
          "Note",
          "Status",
        ];
        var subHeadings2 = [
          provider.orderDetails.billingState ?? "-",
          provider.orderDetails.billingDistrict ?? "-",
          provider.orderDetails.billingSubLocality ?? "-",
          provider.orderDetails.billingPincode ?? "-",
          provider.orderDetails.billingAddress ?? "-",

          provider.orderDetails.enteredEmpName ?? "-",

          provider.orderDetails.stateName ?? "-",
          provider.orderDetails.districtName ?? "-",
          provider.orderDetails.subLocationName ?? "-",
          provider.orderDetails.dispatchPincode ?? "-",
          provider.orderDetails.dispatchAddress ?? "-",

          provider.orderDetails.gstNumber ?? "-",

          provider.orderDetails.unloadingScope ?? "-",
          provider.orderDetails.freightScope ?? "-",
          provider.orderDetails.erectionScope ?? "-",

          provider.orderDetails.cgstAmount ?? "-",
          provider.orderDetails.sgstAmount ?? "-",
          provider.orderDetails.igstAmount ?? "-",

          provider.orderDetails.otp ?? "-",

          provider.orderDetails.basicAmount ?? "-",
          provider.orderDetails.paidAmount ?? "-",
          provider.orderDetails.balanceAmount ?? "-",
          provider.orderDetails.totalAmount ?? "-",

          provider.orderDetails.tpcApplicable ?? "-",
          provider.orderDetails.tpcaAgentName ?? "-",
          provider.orderDetails.requestedTpcAmount ?? "-",

          provider.orderDetails.level1TpcApprovedAmount ?? "-",
          provider.orderDetails.level2TpcApprovedAmount ?? "-",

          provider.orderDetails.tpcPaymentMode ?? "-",
          provider.orderDetails.tpcPaymentReferenceNo ?? "-",
          provider.orderDetails.tpcPaymentAttachementViewFileName ?? "-",
          provider.orderDetails.tpcStatus ?? "-",
          provider.orderDetails.tpcPaymentAttachmentDirFilePath ?? "-",

          provider.orderDetails.createdDatetime ?? "-",
          provider.orderDetails.note ?? "-",
          provider.orderDetails.status ?? "-",
        ];

        var Headings = [...Headings1];
        var subHeadings = [...subHeadings1];

        if (provider.showMoreDetails) {
          Headings = [...Headings1, ...Headings2];
          subHeadings = [...subHeadings1, ...subHeadings2];
        }
        return WillPopScope(
          child: SafeArea(
            top: false,
            bottom: Platform.isIOS ? false : true,
            child: Scaffold(
              resizeToAvoidBottomInset: true,
              appBar: appbar2(
                context,
                widget.pageTitleName,
                provider.resetAll,
                InkResponse(
                  onTap: () {
                    _showOptionsSheet(context);
                  },
                  child: SvgPicture.asset("assets/svg/ic_more.svg", height: 30),
                ),
              ),
              backgroundColor: AppColors.scaffold_bg_color,
              body: Container(
                child: SingleChildScrollView(
                  child: Container(
                    decoration: BoxDecoration(
                      color: Colors.white,
                      borderRadius: BorderRadius.circular(16),
                    ),
                    margin: EdgeInsets.symmetric(vertical: 10, horizontal: 10),
                    padding: EdgeInsets.symmetric(vertical: 10, horizontal: 10),
                    child: Column(
                      children: [
                        Row(
                          children: [
                            Expanded(
                              flex: 1,
                              child: Container(
                                height: 50,
                                width: 35,
                                padding: EdgeInsets.all(8.0),
                                decoration: BoxDecoration(
                                  color: Color(0xFFFFF3CE),
                                  borderRadius: BorderRadius.circular(8),
                                ),
                                child: SvgPicture.asset(
                                  "assets/svg/fin_ic.svg",
                                ),
                              ),
                            ),
                            SizedBox(width: 10),
                            Expanded(
                              flex: 4,
                              child: SizedBox(
                                child: Column(
                                  crossAxisAlignment: CrossAxisAlignment.start,
                                  children: [
                                    Text(
                                      orderDetails.accountName ?? "-",
                                      style: TextStyle(
                                        fontFamily: "JakartaMedium",
                                        fontSize: 14,
                                        color: AppColors.semi_black,
                                      ),
                                    ),
                                    Text(
                                      "₹${orderDetails.balanceAmount}",
                                      style: TextStyle(
                                        fontFamily: "JakartaMedium",
                                        fontSize: 14,
                                        color: AppColors.app_blue,
                                      ),
                                    ),
                                  ],
                                ),
                              ),
                            ),
                            Expanded(
                              flex: 2,
                              child: Container(
                                padding: EdgeInsets.symmetric(
                                  horizontal: 5,
                                  vertical: 10,
                                ),
                                decoration: BoxDecoration(
                                  borderRadius: BorderRadius.circular(8),
                                  color: Color(0xFFE3FFE0),
                                ),
                                child: Center(
                                  child: Text(
                                    orderDetails.status ?? "-",
                                    textAlign: TextAlign.center,
                                    style: TextStyle(
                                      fontFamily: "JakartaMedium",
                                      fontSize: 14,
                                      color: Color(0xFF0D9C00),
                                    ),
                                  ),
                                ),
                              ),
                            ),
                          ],
                        ),
                        Divider(thickness: 0.5, color: Color(0xFFD7D7D7)),
                        ...List.generate(subHeadings.length, (j) {
                          return Container(
                            padding: EdgeInsets.symmetric(vertical: 7),
                            child: Row(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: [
                                Expanded(
                                  child: Text(
                                    Headings[j],
                                    style: TextStyle(
                                      fontFamily: "JakartaMedium",
                                      fontSize: 14,
                                      color: AppColors.semi_black,
                                    ),
                                  ),
                                ),
                                Expanded(
                                  child: InkResponse(
                                    onTap: () {
                                      if (Headings[j] == "Purchase Order") {
                                        Navigator.push(
                                          context,
                                          MaterialPageRoute(
                                            builder:
                                                (context) => Fileviewer(
                                                  fileName:
                                                      orderDetails
                                                          .tpcPaymentAttachementViewFileName!,
                                                  fileUrl:
                                                      orderDetails
                                                          .tpcPaymentAttachmentDirFilePath!,
                                                ),
                                          ),
                                        );
                                      }
                                    },
                                    child: Text(
                                      Headings[j] == "Purchase Order"
                                          ? "View"
                                          : subHeadings[j],
                                      style: TextStyle(
                                        fontSize: 14,
                                        color:
                                            Headings[j] == "Purchase Order"
                                                ? AppColors.app_blue
                                                : Color(0xFF818181),
                                        decoration:
                                            Headings[j] == "Purchase Order"
                                                ? TextDecoration.underline
                                                : TextDecoration.none,
                                        decorationColor:
                                            Headings[j] == "Purchase Order"
                                                ? AppColors.app_blue
                                                : AppColors.white,
                                      ),
                                    ),
                                  ),
                                ),
                              ],
                            ),
                          );
                        }),
                        InkResponse(
                          onTap: () async {
                            provider.showMoreDetails =
                                !provider.showMoreDetails;
                          },
                          child: Container(
                            padding: EdgeInsets.symmetric(vertical: 5),
                            child: Row(
                              crossAxisAlignment: CrossAxisAlignment.center,
                              mainAxisAlignment: MainAxisAlignment.center,
                              children: [
                                Text(
                                  provider.showMoreDetails
                                      ? "- Show Less"
                                      : "+ More Details",
                                  style: TextStyle(
                                    fontFamily: "JakartaMedium",
                                    fontSize: 14,
                                    color: AppColors.app_blue,
                                  ),
                                ),
                              ],
                            ),
                          ),
                        ),
                      ],
                    ),
                  ),
                ),
              ),
              bottomNavigationBar: Container(
                margin: EdgeInsets.symmetric(horizontal: 10),
                alignment: Alignment.bottomCenter,
                height: 60,
                child: Container(
                  margin: EdgeInsets.only(bottom: 10),
                  alignment: Alignment.center,
                  height: 45,
                  child: Row(
                    mainAxisAlignment: MainAxisAlignment.center,
                    children: [
                      Expanded(
                        child: InkResponse(
                          onTap: () {
                            // provider
                            //     .approveRejectPaymentRequestAPIFunction(
                            //   context,
                            //   provider.requestsDetails.id,
                            // );
                            _showLevelApprovalSheet(context);
                          },
                          child: Container(
                            decoration: BoxDecoration(
                              borderRadius: BorderRadius.circular(8),
                              color: Color(0xFFE7FFE5),
                              border: Border.all(
                                color: Color(0xFF0D9C00),
                                width: 0.5,
                              ),
                            ),
                            child: Center(
                              child: Text(
                                "Approve",
                                style: TextStyle(color: Color(0xFF0D9C00)),
                              ),
                            ),
                          ),
                        ),
                      ),
                    ],
                  ),
                ),
              ),
            ),
          ),

          onWillPop: () {
            return onBackPressed(context);
          },
        );
      },
    );
  }

  Future<void> _showOptionsSheet(BuildContext context) {
    return showModalBottomSheet(
      useSafeArea: true,
      isDismissible: true,
      isScrollControlled: true,
      showDragHandle: true,
      backgroundColor: Colors.white,
      enableDrag: true,
      context: context,
      builder: (context) {
        return StatefulBuilder(
          builder: (context, setState) {
            return SafeArea(
              child: Consumer2<Pagesdashboardprovider, Tpcagentsprovider>(
                builder: (context, provider, tpcProvider, child) {
                  return Container(
                    margin: EdgeInsets.only(
                      bottom: 15,
                      left: 15,
                      right: 15,
                      top: 10,
                    ),
                    padding: EdgeInsets.only(
                      bottom: MediaQuery.of(context).viewInsets.bottom,
                    ),
                    child: SingleChildScrollView(
                      child: Column(
                        mainAxisSize: MainAxisSize.min,
                        children: [
                          SizedBox(height: 15),

                          ...List.generate(3, (index) {
                            final assetnames = [
                              "order_list_svg_1",
                              "order_list_svg_2",
                              "order_list_svg_3",
                            ];
                            final Headingnames = [
                              "Payment History",
                              "Products Details",
                              "Feedback History",
                            ];
                            return ListTile(
                              onTap: () async {
                                switch (index) {
                                  case 0:
                                    Navigator.pop(context);
                                    Navigator.push(
                                      context,
                                      MaterialPageRoute(
                                        builder:
                                            (context) =>
                                                Orderdetailspaymenthistory(),
                                      ),
                                    );
                                    break;
                                  case 1:
                                    Navigator.pop(context);
                                    Navigator.push(
                                      context,
                                      MaterialPageRoute(
                                        builder:
                                            (context) =>
                                                Orderdetailsproductshistory(),
                                      ),
                                    );
                                    break;
                                  case 2:
                                    Navigator.pop(context);
                                    Navigator.push(
                                      context,
                                      MaterialPageRoute(
                                        builder:
                                            (context) =>
                                                Orderdetailsfeedbackhistory(),
                                      ),
                                    );
                                    break;
                                }
                              },
                              leading: SvgPicture.asset(
                                "assets/svg/${assetnames[index]}.svg",
                              ),
                              title: Text(
                                Headingnames[index],
                                style: TextStyle(fontFamily: "JakartaMedium"),
                              ),
                              trailing: SvgPicture.asset(
                                "assets/svg/arrow_right_new.svg",
                              ),
                            );
                          }),
                        ],
                      ),
                    ),
                  );
                },
              ),
            );
          },
        );
      },
    );
  }

  Future<void> _showFeedbackSheet(BuildContext context) {
    return showModalBottomSheet(
      useSafeArea: true,
      isDismissible: true,
      isScrollControlled: true,
      showDragHandle: true,
      backgroundColor: Colors.white,
      enableDrag: true,
      context: context,
      builder: (context) {
        return StatefulBuilder(
          builder: (context, setState) {
            return SafeArea(
              child: Consumer<Pagesdashboardprovider>(
                builder: (context, provider, child) {
                  final orderDetails = provider.orderDetails;
                  return Container(
                    margin: EdgeInsets.only(
                      bottom: 15,
                      left: 15,
                      right: 15,
                      top: 10,
                    ),
                    padding: EdgeInsets.only(
                      bottom: MediaQuery.of(context).viewInsets.bottom,
                    ),
                    child: SingleChildScrollView(
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        mainAxisSize: MainAxisSize.min,
                        children: [
                          Align(
                            alignment: Alignment.topLeft,
                            child: Text(
                              "Feedback Update",
                              style: TextStyle(
                                color: AppColors.app_blue,
                                fontSize: 16,
                              ),
                            ),
                          ),

                          Padding(
                            padding: const EdgeInsets.only(
                              bottom: 5.0,
                              top: 8.0,
                            ),
                            child: Text("Remarks"),
                          ),
                          Container(
                            height: 150,
                            alignment: Alignment.center,
                            decoration: BoxDecoration(
                              color: Color(0xFFE9E9E9),
                              borderRadius: BorderRadius.circular(14),
                            ),
                            child: Padding(
                              padding: const EdgeInsets.fromLTRB(
                                10.0,
                                0.0,
                                10,
                                0,
                              ),
                              child: TextFormField(
                                controller: provider.feedbackController,
                                readOnly: true,
                                keyboardType: TextInputType.text,
                                maxLines: 60,
                                onChanged: provider.onChangeFeedback,
                                style: TextStyle(
                                  color: Color(0xFF818181),
                                  fontSize: 14,
                                ),
                                decoration: InputDecoration(
                                  hintText: "Write Remarks",
                                  hintStyle: TextStyle(
                                    fontWeight: FontWeight.w400,
                                    color: Color(0xFFB4BEC0),
                                    fontSize: 14,
                                  ),

                                  enabledBorder: InputBorder.none,
                                  focusedBorder: InputBorder.none,
                                ),
                              ),
                            ),
                          ),
                          if (provider.feedbackError != null) ...[
                            Container(
                              alignment: Alignment.topLeft,
                              margin: EdgeInsets.only(top: 2.5, left: 25),
                              child: Text(
                                "${provider.feedbackError}",
                                style: TextStyle(
                                  color: Colors.red,
                                  fontSize: 10,
                                ),
                              ),
                            ),
                          ],
                          InkResponse(
                            onTap: () {
                              _showAttachmentSheet(context);
                            },
                            child: Container(
                              margin: EdgeInsets.symmetric(vertical: 10),
                              height: 45,
                              width: MediaQuery.of(context).size.width,
                              decoration: BoxDecoration(
                                color: Color(0xFFE6F6FF),
                                borderRadius: BorderRadius.circular(12),
                                border: Border.all(
                                  color: AppColors.app_blue,
                                  width: 0.5,
                                ),
                              ),
                              child: Center(
                                child: Text(
                                  "Add Attachment",
                                  style: TextStyle(
                                    fontFamily: "JakartaMedium",
                                    color: AppColors.app_blue,
                                  ),
                                ),
                              ),
                            ),
                          ),
                          if (provider.imagePicked == 1 &&
                              provider.imagePath != null) ...[
                            Padding(
                              padding: const EdgeInsets.symmetric(
                                vertical: 4.0,
                              ),
                              child: Row(
                                mainAxisAlignment:
                                    MainAxisAlignment.spaceBetween,
                                children: [
                                  Text(
                                    "${provider.imagePath}",
                                    style: TextStyle(
                                      color: AppColors.semi_black,
                                      fontSize: 11,
                                      fontWeight: FontWeight.w600,
                                    ),
                                  ),
                                  InkResponse(
                                    onTap: () {
                                      provider.imagePicked = 0;
                                      provider.imagePath = null;
                                      provider.imageFilePath = null;
                                    },
                                    child: SvgPicture.asset(
                                      "assets/svg/ic_close.svg",
                                      width: 15,
                                      height: 15,
                                    ),
                                  ),
                                ],
                              ),
                            ),
                          ],
                          InkWell(
                            onTap: () {
                              provider
                                  .ordersDetailsFeedbackSubmissionAPIFunction(
                                    context,
                                    orderDetails.id,
                                    orderDetails.status,
                                  );
                            },
                            child: Container(
                              alignment: Alignment.center,
                              height: 45,

                              decoration: BoxDecoration(
                                color: AppColors.app_blue, //1487C9
                                borderRadius: BorderRadius.circular(14.0),
                              ),
                              child: Center(
                                child: Text(
                                  "Submit",
                                  textAlign: TextAlign.center,
                                  style: TextStyle(color: Colors.white),
                                ),
                              ),
                            ),
                          ),
                        ],
                      ),
                    ),
                  );
                },
              ),
            );
          },
        );
      },
    );
  }

  Future<void> _showLevelApprovalSheet(BuildContext context) {
    return showModalBottomSheet(
      useSafeArea: true,
      isDismissible: true,
      isScrollControlled: true,
      showDragHandle: true,
      backgroundColor: Colors.white,
      enableDrag: true,
      context: context,
      builder: (context) {
        return StatefulBuilder(
          builder: (context, setState) {
            return SafeArea(
              child: Consumer<Tpcagentsprovider>(
                builder: (context, tcpProvider, child) {
                  return Container(
                    margin: EdgeInsets.only(
                      bottom: 15,
                      left: 15,
                      right: 15,
                      top: 10,
                    ),
                    padding: EdgeInsets.only(
                      bottom: MediaQuery.of(context).viewInsets.bottom,
                    ),
                    child: SingleChildScrollView(
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        mainAxisSize: MainAxisSize.min,
                        children: [
                          Align(
                            alignment: Alignment.topLeft,
                            child: Text(
                              "Update Issue",
                              style: TextStyle(
                                color: AppColors.app_blue,
                                fontSize: 16,
                              ),
                            ),
                          ),

                          Padding(
                            padding: const EdgeInsets.only(
                              bottom: 5.0,
                              top: 8.0,
                            ),
                            child: Text("TPC Payment Mode"),
                          ),
                          Container(
                            height: 50,
                            alignment: Alignment.center,
                            decoration: BoxDecoration(
                              color: Color(0xFFE9E9E9),
                              borderRadius: BorderRadius.circular(14),
                            ),
                            child: Padding(
                              padding: const EdgeInsets.fromLTRB(
                                10.0,
                                0.0,
                                10,
                                0,
                              ),
                              child: TextFormField(
                                controller:
                                    tcpProvider.tpcPaymentModeController,
                                readOnly: true,
                                keyboardType: TextInputType.text,
                                maxLines: 1,
                                onChanged: tcpProvider.onChangeTPCPayment,
                                style: TextStyle(
                                  color: Color(0xFF818181),
                                  fontSize: 14,
                                ),
                                decoration: InputDecoration(
                                  hintText: "Enter Company Name",
                                  hintStyle: TextStyle(
                                    fontWeight: FontWeight.w400,
                                    color: Color(0xFFB4BEC0),
                                    fontSize: 14,
                                  ),

                                  enabledBorder: InputBorder.none,
                                  focusedBorder: InputBorder.none,
                                ),
                              ),
                            ),
                          ),
                          if (tcpProvider.tpcPaymentModeError != null) ...[
                            Container(
                              alignment: Alignment.topLeft,
                              margin: EdgeInsets.only(top: 2.5, left: 25),
                              child: Text(
                                "${tcpProvider.tpcPaymentModeError}",
                                style: TextStyle(
                                  color: Colors.red,
                                  fontSize: 10,
                                ),
                              ),
                            ),
                          ],
                          Padding(
                            padding: const EdgeInsets.only(
                              bottom: 5.0,
                              top: 8.0,
                            ),
                            child: Text(
                              "TPC Payment Reference No. /Cheque No. / UTR No.",
                            ),
                          ),
                          Container(
                            height: 50,
                            alignment: Alignment.center,
                            decoration: BoxDecoration(
                              color: Color(0xFFE9E9E9),
                              borderRadius: BorderRadius.circular(14),
                            ),
                            child: Padding(
                              padding: const EdgeInsets.fromLTRB(
                                10.0,
                                0.0,
                                10,
                                0,
                              ),
                              child: TextFormField(
                                controller:
                                    tcpProvider.tpcPaymentModeController,
                                readOnly: true,
                                keyboardType: TextInputType.text,
                                maxLines: 1,
                                onChanged:
                                    tcpProvider.onChangeTPCPaymentReference,
                                style: TextStyle(
                                  color: Color(0xFF818181),
                                  fontSize: 14,
                                ),
                                decoration: InputDecoration(
                                  hintText: "Enter Order Number",
                                  hintStyle: TextStyle(
                                    fontWeight: FontWeight.w400,
                                    color: Color(0xFFB4BEC0),
                                    fontSize: 14,
                                  ),

                                  enabledBorder: InputBorder.none,
                                  focusedBorder: InputBorder.none,
                                ),
                              ),
                            ),
                          ),
                          if (tcpProvider.tpcPaymentReferenceNoError !=
                              null) ...[
                            Container(
                              alignment: Alignment.topLeft,
                              margin: EdgeInsets.only(top: 2.5, left: 25),
                              child: Text(
                                "${tcpProvider.tpcPaymentReferenceNoError}",
                                style: TextStyle(
                                  color: Colors.red,
                                  fontSize: 10,
                                ),
                              ),
                            ),
                          ],

                          Padding(
                            padding: const EdgeInsets.only(
                              bottom: 5.0,
                              top: 8.0,
                            ),
                            child: Text("Remarks"),
                          ),
                          Container(
                            height: 150,
                            alignment: Alignment.center,
                            decoration: BoxDecoration(
                              color: Color(0xFFE9E9E9),
                              borderRadius: BorderRadius.circular(14),
                            ),
                            child: Padding(
                              padding: const EdgeInsets.fromLTRB(
                                10.0,
                                0.0,
                                10,
                                0,
                              ),
                              child: TextFormField(
                                controller:
                                    tcpProvider.orderTpcFeedbackController,
                                readOnly: true,
                                keyboardType: TextInputType.text,
                                maxLines: 60,
                                onChanged: tcpProvider.onChangeTpcFeedback,
                                style: TextStyle(
                                  color: Color(0xFF818181),
                                  fontSize: 14,
                                ),
                                decoration: InputDecoration(
                                  hintText: "Write Remarks",
                                  hintStyle: TextStyle(
                                    fontWeight: FontWeight.w400,
                                    color: Color(0xFFB4BEC0),
                                    fontSize: 14,
                                  ),

                                  enabledBorder: InputBorder.none,
                                  focusedBorder: InputBorder.none,
                                ),
                              ),
                            ),
                          ),
                          if (tcpProvider.orderTpcFeedbackError != null) ...[
                            Container(
                              alignment: Alignment.topLeft,
                              margin: EdgeInsets.only(top: 2.5, left: 25),
                              child: Text(
                                "${tcpProvider.orderTpcFeedbackError}",
                                style: TextStyle(
                                  color: Colors.red,
                                  fontSize: 10,
                                ),
                              ),
                            ),
                          ],
                          InkResponse(
                            onTap: () {
                              _showAttachmentSheet(context);
                            },
                            child: Container(
                              margin: EdgeInsets.symmetric(vertical: 10),
                              height: 45,
                              width: MediaQuery.of(context).size.width,
                              decoration: BoxDecoration(
                                color: Color(0xFFE6F6FF),
                                borderRadius: BorderRadius.circular(12),
                                border: Border.all(
                                  color: AppColors.app_blue,
                                  width: 0.5,
                                ),
                              ),
                              child: Center(
                                child: Text(
                                  "Add Attachment",
                                  style: TextStyle(
                                    fontFamily: "JakartaMedium",
                                    color: AppColors.app_blue,
                                  ),
                                ),
                              ),
                            ),
                          ),
                          if (tcpProvider.imagePicked == 1 &&
                              tcpProvider.imagePath != null) ...[
                            Padding(
                              padding: const EdgeInsets.symmetric(
                                vertical: 4.0,
                              ),
                              child: Row(
                                mainAxisAlignment:
                                    MainAxisAlignment.spaceBetween,
                                children: [
                                  Text(
                                    "${tcpProvider.imagePath}",
                                    style: TextStyle(
                                      color: AppColors.semi_black,
                                      fontSize: 11,
                                      fontWeight: FontWeight.w600,
                                    ),
                                  ),
                                  InkResponse(
                                    onTap: () {
                                      tcpProvider.imagePicked = 0;
                                      tcpProvider.imagePath = null;
                                      tcpProvider.imageFilePath = null;
                                    },
                                    child: SvgPicture.asset(
                                      "assets/svg/ic_close.svg",
                                      width: 15,
                                      height: 15,
                                    ),
                                  ),
                                ],
                              ),
                            ),
                          ],

                          InkWell(
                            onTap: () {
                              tcpProvider.TPCAgentsIssueApprovalAPIFunction(
                                context,
                                widget.orderId,
                              );
                            },

                            child: Container(
                              alignment: Alignment.center,
                              height: 45,
                              margin: EdgeInsets.only(
                                left: 5.0,
                                right: 5.0,
                                top: 5.0,
                                bottom: 5.0,
                              ),
                              decoration: BoxDecoration(
                                color: AppColors.app_blue, //1487C9
                                borderRadius: BorderRadius.circular(14.0),
                              ),
                              child: Center(
                                child: Text(
                                  "Submit",
                                  textAlign: TextAlign.center,
                                  style: TextStyle(color: Colors.white),
                                ),
                              ),
                            ),
                          ),
                        ],
                      ),
                    ),
                  );
                },
              ),
            );
          },
        );
      },
    );
  }

  Future<void> _showAttachmentSheet(BuildContext context) {
    return showModalBottomSheet(
      useSafeArea: true,
      isDismissible: true,
      isScrollControlled: true,
      showDragHandle: true,
      backgroundColor: Colors.white,
      enableDrag: true,
      context: context,
      builder: (context) {
        return StatefulBuilder(
          builder: (context, setState) {
            return SafeArea(
              child: Consumer<Tpcagentsprovider>(
                builder: (context, tcpProvider, child) {
                  return Padding(
                    padding: EdgeInsets.only(
                      bottom:
                          MediaQuery.of(
                            context,
                          ).viewInsets.bottom, // This handles keyboard
                    ),
                    child: Container(
                      margin: EdgeInsets.only(
                        bottom: 15,
                        left: 15,
                        right: 15,
                        top: 10,
                      ),

                      child: SingleChildScrollView(
                        child: Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          mainAxisSize: MainAxisSize.min,
                          children: [
                            Align(
                              alignment: Alignment.center,
                              child: Text(
                                "Select Source",
                                style: TextStyle(
                                  color: AppColors.app_blue,
                                  fontSize: 16,
                                ),
                              ),
                            ),
                            SizedBox(height: 15),
                            InkWell(
                              onTap: () {
                                Navigator.of(context).pop(false);
                                tcpProvider.imgFromGallery(context);
                              },
                              child: SizedBox(
                                height: 35,
                                child: Text("Select photo from gallery"),
                              ),
                            ),
                            SizedBox(height: 10),
                            InkWell(
                              onTap: () {
                                Navigator.of(context).pop(false);
                                tcpProvider.imgFromCamera(context);
                              },
                              child: SizedBox(
                                height: 35,
                                child: Text("Capture photo from camera"),
                              ),
                            ),
                          ],
                        ),
                      ),
                    ),
                  );
                },
              ),
            );
          },
        );
      },
    );
  }
}
