import 'dart:io';

import 'package:connectivity_plus/connectivity_plus.dart';
import 'package:dropdown_button2/dropdown_button2.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:flutter_svg/svg.dart';
import 'package:generp/Notifiers/crmProvider/crmEditProspectAccountProvider.dart';
import 'package:generp/Notifiers/crmProvider/crmLeadDetailsProvider.dart';
import 'package:generp/Utils/commonServices.dart';
import 'package:generp/Utils/dropdownTheme.dart';
import 'package:generp/screens/crm/prospectContactDetails.dart';
import 'package:generp/screens/crm/prospectLeadDetails.dart';
import 'package:generp/screens/crm/prospectOrderDetails.dart';
import 'package:generp/screens/crm/prospectPaymentDetails.dart';
import 'package:get/get.dart';
import 'package:provider/provider.dart';
import '../../Models/crmModels/GetDistrictOnStateResponse.dart';
import '../../Models/crmModels/GetSubLocOnDistrictResponse.dart';
import '../../Models/crmModels/LeadListViewResponse.dart' show Employees;
import '../../Models/crmModels/crmProspectDetailsEditAccountViewResponse.dart';
import '../../Notifiers/crmProvider/crmProspectDetailsProvider.dart';
import '../../Utils/app_colors.dart';
import '../../Utils/commonWidgets.dart';

class ProspectDetailsByModeOld extends StatefulWidget {
  final mode;
  final pageTitleName;
  final leadId;

  const ProspectDetailsByModeOld({
    super.key,
    this.mode,
    this.pageTitleName,
    this.leadId,
  });

  @override
  State<ProspectDetailsByModeOld> createState() =>
      ProspectDetailsByModeOldState();
}

class ProspectDetailsByModeOldState extends State<ProspectDetailsByModeOld> {
  Dropdowntheme ddtheme = Dropdowntheme();
  Map _source = {ConnectivityResult.mobile: true};
  final MyConnectivity _connectivity = MyConnectivity.instance;

  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    _connectivity.initialise();
    _connectivity.myStream.listen((source) {
      setState(() => _source = source);
    });
    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
      final provider = Provider.of<crmProspectDetailsProvider>(
        context,
        listen: false,
      );
      final editProvider = Provider.of<Crmeditprospectaccountprovider>(
        context,
        listen: false,
      );
      editProvider.crmLeadListViewAPIFunction(context, widget.mode);

      editProvider.crmProspectDetailsEditAccountViewAPIFunction(
        context,
        widget.leadId,
      );
      provider.crmProspectDetailsAPIFunction(context, widget.leadId);
    });
  }

  @override
  void dispose() {
    // TODO: implement dispose
    super.dispose();
    _connectivity.disposeStream();
  }

  void prefill() async {
    final editProvider = Provider.of<Crmeditprospectaccountprovider>(
      context,
      listen: false,
    );

    await editProvider.crmProspectDetailsEditAccountViewAPIFunction(
      context,
      widget.leadId,
    );

    editProvider.editCompanyNameController.text =
        editProvider.accountDetails.name ?? "";
    editProvider.addressController.text =
        editProvider.accountDetails.address ?? "";
    editProvider.pincodeController.text =
        editProvider.accountDetails.pincode ?? "";

    if (editProvider.salutationList.isNotEmpty &&
        editProvider.accountDetails.salutationName != null) {
      editProvider.selectedSalutation =
          editProvider.salutationList.firstWhere(
            (element) => element == editProvider.accountDetails.salutationName,
          ) ??
          editProvider.salutationList.first;
    }

    // print("States:${editProvider.statesList.toList()}");
    if (editProvider.statesList.isNotEmpty &&
        editProvider.accountDetails.state != null) {
      print(editProvider.accountDetails.state);
      final selectedState = editProvider.statesList.firstWhere(
        (element) =>
            element.id!.trim() == editProvider.accountDetails.state!.trim(),
      );

      editProvider.selectedStates = selectedState;
      editProvider.selectedStateId = selectedState.id;
      editProvider.selectedStateValue = selectedState.name;

      await editProvider.crmLeadListDistrictsOnStateAPIFunction(
        context,
        widget.mode,
        editProvider.selectedStateId,
      );
    }

    // Prefill district
    if (editProvider.districtsList.isNotEmpty &&
        editProvider.accountDetails.district != null) {
      final selectedDistrict = editProvider.districtsList.firstWhere(
        (element) =>
            element.id!.trim() == editProvider.accountDetails.district!.trim(),
      );
      editProvider.selectedDistricts = selectedDistrict;
      editProvider.selectedDistrictId = selectedDistrict.id;
      editProvider.selectedDistrictValue = selectedDistrict.district;

      await editProvider.crmLeadListSubLocOnDistrictAPIFunction(
        context,
        widget.mode,
        editProvider.selectedDistrictId,
      );
    }

    if (editProvider.subLocationsList.isNotEmpty &&
        editProvider.accountDetails.subLocality != null) {
      final selectedSubLocation = editProvider.subLocationsList.firstWhere(
        (element) => element.id == editProvider.accountDetails.subLocality,
      );
      editProvider.selectedSubLocations = selectedSubLocation;
      editProvider.selectedSubLocationId = selectedSubLocation.id;
      editProvider.selectedSubLocationValue = selectedSubLocation.subLocality;
    }

    print("Company Name: ${editProvider.editCompanyNameController.text}");
    print("Pincode: ${editProvider.pincodeController.text}");
    print("Address: ${editProvider.addressController.text}");
    print("Selected Salutation: ${editProvider.selectedSalutation}");
    print("Selected State ID: ${editProvider.selectedStateId}");
    print("Selected State Value: ${editProvider.selectedStateValue}");
    print("Selected District ID: ${editProvider.selectedDistrictId}");
    print("Selected District Value: ${editProvider.selectedDistrictValue}");
    print("Selected Sub-Location ID: ${editProvider.selectedSubLocationId}");
    print(
      "Selected Sub-Location Value: ${editProvider.selectedSubLocationValue}",
    );
  }

  @override
  Widget build(BuildContext context) {
    switch (_source.keys.toList()[0]) {
      case ConnectivityResult.mobile:
        connection = 'Online';
        break;
      case ConnectivityResult.wifi:
        connection = 'Online';
        break;
      case ConnectivityResult.none:
      default:
        connection = 'Offline';
    }
    return (connection == "Online")
        ? Platform.isAndroid
            ? WillPopScope(
              onWillPop: () => onBackPressed(context),
              child: SafeArea(
                top: false,
                bottom: true,
                child: _scaffold(context),
              ),
            )
            : _scaffold(context)
        : NoNetwork(context);
  }

  Widget _scaffold(BuildContext context) {
    return Consumer2<
      crmProspectDetailsProvider,
      Crmeditprospectaccountprovider
    >(
      builder: (context, provider, editProvider, child) {
        var leadDetails = provider.accountDetails;

        return Scaffold(
          resizeToAvoidBottomInset: true,
          appBar: appbar2(
            context,
            widget.pageTitleName,
            provider.resetAll,
            InkResponse(
              onTap: () {
                _showOptionsSheet(context);
              },
              child: SvgPicture.asset("assets/svg/ic_more.svg", height: 30),
            ),
          ),
          backgroundColor: AppColors.scaffold_bg_color,
          body: Container(
            child: SingleChildScrollView(
              child: Container(
                decoration: BoxDecoration(
                  color: Colors.white,
                  borderRadius: BorderRadius.circular(16),
                ),
                margin: EdgeInsets.symmetric(vertical: 10, horizontal: 10),
                padding: EdgeInsets.symmetric(vertical: 10, horizontal: 10),
                child: Column(
                  children: [
                    Row(
                      children: [
                        Expanded(
                          flex: 1,
                          child: Container(
                            height: 50,
                            width: 35,
                            padding: EdgeInsets.all(8.0),
                            decoration: BoxDecoration(
                              color: Color(0xFFE6F6FF),
                              borderRadius: BorderRadius.circular(8),
                            ),
                            child: SvgPicture.asset(
                              "assets/svg/se_block_head.svg",
                            ),
                          ),
                        ),
                        SizedBox(width: 10),
                        Expanded(
                          flex: 4,
                          child: SizedBox(
                            child: Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: [
                                Text(
                                  "${leadDetails.salutationName ?? "-"}  ${leadDetails.name ?? "-"}",
                                  style: TextStyle(
                                    fontFamily: "JakartaMedium",
                                    fontSize: 14,
                                    color: AppColors.semi_black,
                                  ),
                                ),
                              ],
                            ),
                          ),
                        ),

                        if (provider.showTransferAccount == "1") ...[
                          SizedBox(width: 5),
                          Expanded(
                            flex: 1,
                            child: InkResponse(
                              onTap: () async {
                                _showTransferAccountSheet(
                                  context,
                                  provider.accountDetails.id!,
                                );
                              },
                              child: Container(
                                height: 32,
                                width: 30,
                                padding: EdgeInsets.all(8.0),
                                child: SvgPicture.asset(
                                  "assets/svg/transfer_ac.svg",
                                ),
                              ),
                            ),
                          ),
                        ],
                        SizedBox(width: 5),
                        Expanded(
                          flex: 1,
                          child: InkResponse(
                            onTap: () async {
                              editProvider.checkDropDownValues();
                              prefill();
                              await _showEditAccountSheet(
                                context,
                                provider.accountDetails.id!,
                              );
                            },
                            child: Container(
                              height: 32,
                              width: 30,
                              padding: EdgeInsets.all(8.0),
                              child: SvgPicture.asset(
                                "assets/svg/crm_contact_edit.svg",
                              ),
                            ),
                          ),
                        ),
                      ],
                    ),
                    Divider(thickness: 0.5, color: Color(0xFFD7D7D7)),
                    ...List.generate(provider.subHeadings.length, (j) {
                      return Container(
                        padding: EdgeInsets.symmetric(vertical: 7),
                        child: Row(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: [
                            Expanded(
                              child: Text(
                                provider.Headings[j],
                                style: TextStyle(
                                  fontFamily: "JakartaMedium",
                                  fontSize: 14,
                                  color: AppColors.semi_black,
                                ),
                              ),
                            ),
                            Expanded(
                              child: InkResponse(
                                child:
                                    provider.Headings[j] == "Lead Age"
                                        ? Tooltip(
                                          triggerMode: TooltipTriggerMode.tap,

                                          message:
                                              "${provider.accountDetails.createdDatetime}",
                                          child: Text(
                                            provider.subHeadings[j] == ""
                                                ? "-"
                                                : provider.subHeadings[j],
                                            style: TextStyle(
                                              fontSize: 14,
                                              color: Color(0xFF818181),
                                              decorationColor:
                                                  AppColors.grey_semi,
                                              decoration:
                                                  TextDecoration.underline,
                                            ),
                                          ),
                                        )
                                        : Text(
                                          provider.subHeadings[j] == ""
                                              ? "-"
                                              : provider.subHeadings[j],
                                          style: TextStyle(
                                            fontSize: 14,
                                            color: Color(0xFF818181),
                                          ),
                                        ),
                              ),
                            ),
                          ],
                        ),
                      );
                    }),
                  ],
                ),
              ),
            ),
          ),
        );
      },
    );
  }

  Future<void> _showTransferAccountSheet(BuildContext context, accID) {
    return showModalBottomSheet(
      useSafeArea: true,
      isDismissible: true,
      isScrollControlled: true,
      showDragHandle: true,
      backgroundColor: Colors.white,
      enableDrag: true,
      context: context,
      builder: (context) {
        return StatefulBuilder(
          builder: (context, setState) {
            return SafeArea(
              child: Consumer<Crmeditprospectaccountprovider>(
                builder: (context, editProsProvider, child) {
                  return Container(
                    margin: EdgeInsets.only(
                      bottom: 15,
                      left: 15,
                      right: 15,
                      top: 10,
                    ),
                    padding: EdgeInsets.only(
                      bottom: MediaQuery.of(context).viewInsets.bottom,
                    ),

                    child: SingleChildScrollView(
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        mainAxisSize: MainAxisSize.min,
                        children: [
                          Align(
                            alignment: Alignment.topLeft,
                            child: Text(
                              "Transfer Account",
                              style: TextStyle(
                                color: AppColors.app_blue,
                                fontSize: 16,
                              ),
                            ),
                          ),
                          TextWidget(context, "Employee"),
                          DropdownButtonHideUnderline(
                            child: Row(
                              children: [
                                Expanded(
                                  child: DropdownButton2<Employees>(
                                    hint: Text(
                                      "Select Source",
                                      style: TextStyle(fontSize: 14),
                                    ),
                                    items:
                                        editProsProvider.employeesList
                                            .map(
                                              (slist) =>
                                                  DropdownMenuItem<Employees>(
                                                    value: slist,
                                                    child: Text(
                                                      slist.name!,
                                                      style: TextStyle(
                                                        fontSize: 14,
                                                      ),
                                                    ),
                                                  ),
                                            )
                                            .toList(),
                                    value:
                                        editProsProvider.employeesList.contains(
                                              editProsProvider
                                                  .selectedEmployees,
                                            )
                                            ? editProsProvider.selectedEmployees
                                            : null,

                                    // value: provider.selectedEmployees,
                                    onChanged: (Employees? value) {
                                      if (value != null) {
                                        if (editProsProvider
                                            .employeesList
                                            .isNotEmpty) {
                                          editProsProvider.selectedEmployees =
                                              value;
                                          editProsProvider.selectedEmployeeId =
                                              value.id!;
                                          editProsProvider
                                                  .selectedEmployeeValue =
                                              value.name!;
                                        }
                                      }
                                    },
                                    isExpanded: true,
                                    dropdownSearchData: DropdownSearchData(
                                      searchInnerWidgetHeight: 50,
                                      searchController:
                                          editProsProvider.searchController,
                                      searchInnerWidget: Padding(
                                        padding: const EdgeInsets.all(8),
                                        child: TextFormField(
                                          controller:
                                              editProsProvider.searchController,
                                          decoration: InputDecoration(
                                            isDense: true,
                                            contentPadding:
                                                const EdgeInsets.symmetric(
                                                  horizontal: 10,
                                                  vertical: 8,
                                                ),
                                            hintText: 'Search account...',
                                            border: OutlineInputBorder(
                                              borderRadius:
                                                  BorderRadius.circular(8),
                                            ),
                                          ),
                                        ),
                                      ),
                                      searchMatchFn: (item, searchValue) {
                                        return item.value?.name
                                                ?.toLowerCase()
                                                .contains(
                                                  searchValue.toLowerCase(),
                                                ) ??
                                            false;
                                      },
                                    ),
                                    onMenuStateChange: (isOpen) {
                                      if (!isOpen) {
                                        editProsProvider.searchController
                                            .clear();
                                      }
                                    },
                                    buttonStyleData: ddtheme.buttonStyleData,
                                    iconStyleData: ddtheme.iconStyleData,
                                    menuItemStyleData:
                                        ddtheme.menuItemStyleData,
                                    dropdownStyleData:
                                        ddtheme.dropdownStyleData,
                                  ),
                                ),
                              ],
                            ),
                          ),

                          InkWell(
                            onTap:
                                editProsProvider.isLoading
                                    ? null
                                    : () {
                                      editProsProvider.isLoading = true;
                                      editProsProvider
                                          .crmProspectDetailsTransferAccountAPIFunction(
                                            context,
                                            accID,
                                            editProsProvider.selectedEmployeeId,
                                          );
                                    },
                            child: Container(
                              alignment: Alignment.center,
                              height: 45,
                              margin: EdgeInsets.only(
                                left: 5.0,
                                right: 5.0,
                                top: 5.0,
                                bottom: 5.0,
                              ),
                              decoration: BoxDecoration(
                                color: AppColors.app_blue, //1487C9
                                borderRadius: BorderRadius.circular(14.0),
                              ),
                              child: Center(
                                child:
                                    editProsProvider.isLoading
                                        ? CircularProgressIndicator.adaptive(
                                          valueColor: AlwaysStoppedAnimation(
                                            AppColors.white,
                                          ),
                                        )
                                        : Text(
                                          "Submit",
                                          textAlign: TextAlign.center,
                                          style: TextStyle(color: Colors.white),
                                        ),
                              ),
                            ),
                          ),
                        ],
                      ),
                    ),
                  );
                },
              ),
            );
          },
        );
      },
    ).whenComplete(() {});
  }

  Future<void> _showEditAccountSheet(BuildContext context, accID) {
    return showModalBottomSheet(
      useSafeArea: true,
      isDismissible: true,
      isScrollControlled: true,
      showDragHandle: true,
      backgroundColor: Colors.white,
      enableDrag: true,
      context: context,
      builder: (context) {
        return StatefulBuilder(
          builder: (context, setState) {
            return SafeArea(
              child: Consumer2<
                Crmeditprospectaccountprovider,
                crmProspectDetailsProvider
              >(
                builder: (context, provider, prosDetProvider, child) {
                  return Container(
                    margin: EdgeInsets.only(
                      bottom: 15,
                      left: 15,
                      right: 15,
                      top: 10,
                    ),
                    padding: EdgeInsets.only(
                      bottom: MediaQuery.of(context).viewInsets.bottom,
                    ),
                    child: SingleChildScrollView(
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        mainAxisSize: MainAxisSize.min,
                        children: [
                          SizedBox(height: 15),
                          Row(
                            children: [
                              Expanded(
                                child: Text(
                                  "Edit Account Details",
                                  style: TextStyle(
                                    color: AppColors.app_blue,
                                    fontSize: 14,
                                  ),
                                ),
                              ),
                            ],
                          ),

                          TextWidget(context, "Salutation"),
                          DropdownButtonHideUnderline(
                            child: Row(
                              children: [
                                Expanded(
                                  child: DropdownButton2<String>(
                                    hint: Text(
                                      "Select Salutation",
                                      style: TextStyle(fontSize: 14),
                                    ),
                                    items:
                                        provider.salutationList
                                            .map(
                                              (slist) =>
                                                  DropdownMenuItem<String>(
                                                    value: slist,
                                                    child: Text(
                                                      slist,
                                                      style: TextStyle(
                                                        fontSize: 14,
                                                      ),
                                                    ),
                                                  ),
                                            )
                                            .toList(),
                                    value: provider.selectedSalutation,
                                    onChanged: (String? value) {
                                      if (value != null) {
                                        if (provider
                                            .salutationList
                                            .isNotEmpty) {
                                          provider.selectedSalutation = value;
                                        }
                                      }
                                    },
                                    isExpanded: true,
                                    buttonStyleData: ddtheme.buttonStyleData,
                                    iconStyleData: ddtheme.iconStyleData,
                                    menuItemStyleData:
                                        ddtheme.menuItemStyleData,
                                    dropdownStyleData:
                                        ddtheme.dropdownStyleData,
                                  ),
                                ),
                              ],
                            ),
                          ),
                          errorWidget(context, provider.salutationError),
                          textControllerWidget(
                            context,
                            provider.editCompanyNameController,
                            "Company Name",
                            "Enter Company Name",
                            provider.onChangeCompanyName,
                            TextInputType.text,
                            false,
                            null,
                          ),
                          errorWidget(context, provider.companyNameError),

                          TextWidget(context, "State"),
                          DropdownButtonHideUnderline(
                            child: Row(
                              children: [
                                Expanded(
                                  child: DropdownButton2<States>(
                                    hint: Text(
                                      "Select State",
                                      style: TextStyle(fontSize: 14),
                                    ),
                                    items:
                                        provider.statesList
                                            .map(
                                              (slist) =>
                                                  DropdownMenuItem<States>(
                                                    value: slist,
                                                    child: Text(
                                                      slist.name!,
                                                      style: TextStyle(
                                                        fontSize: 14,
                                                      ),
                                                    ),
                                                  ),
                                            )
                                            .toList(),
                                    value:
                                        provider.statesList.contains(
                                              provider.selectedStates,
                                            )
                                            ? provider.selectedStates
                                            : null,
                                    onChanged: (States? value) {
                                      if (value != null) {
                                        if (provider.statesList.isNotEmpty) {
                                          provider.selectedStates = value;
                                          provider.selectedStateId = value.id!;
                                          provider.selectedStateValue =
                                              value.name!;
                                          if (provider
                                              .districtsList
                                              .isNotEmpty) {
                                            provider.districtsList.clear();
                                            provider.selectedDistricts = null;
                                            provider.selectedDistrictId = null;
                                            provider.selectedDistrictValue = "";
                                          }
                                          provider
                                              .crmLeadListDistrictsOnStateAPIFunction(
                                                context,
                                                widget.mode,
                                                provider.selectedStateId,
                                              );
                                        }
                                      }
                                    },
                                    isExpanded: true,
                                    buttonStyleData: ddtheme.buttonStyleData,
                                    iconStyleData: ddtheme.iconStyleData,
                                    menuItemStyleData:
                                        ddtheme.menuItemStyleData,
                                    dropdownStyleData:
                                        ddtheme.dropdownStyleData,
                                  ),
                                ),
                              ],
                            ),
                          ),

                          TextWidget(context, "District"),
                          DropdownButtonHideUnderline(
                            child: Row(
                              children: [
                                Expanded(
                                  child: DropdownButton2<Districts>(
                                    hint: Text(
                                      "Select District",
                                      style: TextStyle(fontSize: 14),
                                    ),
                                    items:
                                        provider.districtsList
                                            .map(
                                              (slist) =>
                                                  DropdownMenuItem<Districts>(
                                                    value: slist,
                                                    child: Text(
                                                      slist.district!,
                                                      style: TextStyle(
                                                        fontSize: 14,
                                                      ),
                                                    ),
                                                  ),
                                            )
                                            .toList(),
                                    value:
                                        provider.districtsList.contains(
                                              provider.selectedDistricts,
                                            )
                                            ? provider.selectedDistricts
                                            : null,
                                    // value: provider.selectedDistricts,
                                    onChanged: (Districts? value) {
                                      if (value != null) {
                                        if (provider.districtsList.isNotEmpty) {
                                          provider.selectedDistricts = value;
                                          provider.selectedDistrictId =
                                              value.id!;
                                          provider.selectedDistrictValue =
                                              value.district!;
                                          if (provider
                                              .subLocationsList
                                              .isNotEmpty) {
                                            provider.subLocationsList.clear();
                                            provider.selectedSubLocations =
                                                null;
                                            provider.selectedSubLocationId =
                                                null;
                                            provider.selectedSubLocationValue =
                                                "";
                                          }
                                          provider
                                              .crmLeadListSubLocOnDistrictAPIFunction(
                                                context,
                                                widget.mode,
                                                provider.selectedDistrictId,
                                              );
                                          prosDetProvider
                                              .crmProspectDetailsAPIFunction(
                                                context,
                                                widget.leadId,
                                              );
                                        }
                                      }
                                    },
                                    isExpanded: true,
                                    buttonStyleData: ddtheme.buttonStyleData,
                                    iconStyleData: ddtheme.iconStyleData,
                                    menuItemStyleData:
                                        ddtheme.menuItemStyleData,
                                    dropdownStyleData:
                                        ddtheme.dropdownStyleData,
                                  ),
                                ),
                              ],
                            ),
                          ),

                          TextWidget(context, "Sub Location"),
                          DropdownButtonHideUnderline(
                            child: Row(
                              children: [
                                Expanded(
                                  child: DropdownButton2<SubLocations>(
                                    hint: Text(
                                      "Select Sub Location",
                                      style: TextStyle(fontSize: 14),
                                    ),
                                    items:
                                        provider.subLocationsList
                                            .map(
                                              (slist) => DropdownMenuItem<
                                                SubLocations
                                              >(
                                                value: slist,
                                                child: Text(
                                                  slist.subLocality!,
                                                  style: TextStyle(
                                                    fontSize: 14,
                                                  ),
                                                ),
                                              ),
                                            )
                                            .toList(),
                                    value:
                                        provider.subLocationsList.contains(
                                              provider.selectedSubLocations,
                                            )
                                            ? provider.selectedSubLocations
                                            : null,
                                    // value: provider.selectedSubLocations,
                                    onChanged: (SubLocations? value) {
                                      if (value != null) {
                                        if (provider
                                            .subLocationsList
                                            .isNotEmpty) {
                                          provider.selectedSubLocations = value;
                                          provider.selectedSubLocationId =
                                              value.id!;
                                          provider.selectedSubLocationValue =
                                              value.subLocality!;
                                        }
                                      }
                                    },
                                    isExpanded: true,
                                    buttonStyleData: ddtheme.buttonStyleData,
                                    iconStyleData: ddtheme.iconStyleData,
                                    menuItemStyleData:
                                        ddtheme.menuItemStyleData,
                                    dropdownStyleData:
                                        ddtheme.dropdownStyleData,
                                  ),
                                ),
                              ],
                            ),
                          ),

                          textControllerWidget(
                            context,
                            provider.pincodeController,
                            "Pincode",
                            "Enter Pincode",
                            provider.onChangePincode,
                            TextInputType.number,
                            false,
                            FilteringTextInputFormatter.digitsOnly,
                          ),
                          errorWidget(context, provider.pincodeError),
                          textControllerWidget(
                            context,
                            provider.addressController,
                            "Address",
                            "Enter Address",
                            provider.onChangeAddress,
                            TextInputType.text,
                            false,
                            null,
                          ),
                          errorWidget(context, provider.addressError),

                          InkResponse(
                            onTap:
                                provider.isLoading
                                    ? null
                                    : () {
                                      provider.isLoading = true;
                                      provider
                                          .crmProspectDetailsEditAccountSubmitAPIFunction(
                                            context,
                                            accID,
                                            provider.selectedSalutation,
                                            provider.selectedStateId,
                                            provider.selectedDistrictId,
                                            provider.selectedSubLocationId,
                                          );
                                      Navigator.pop(context);
                                    },
                            child: Container(
                              height: 45,
                              alignment: Alignment.center,
                              margin: EdgeInsets.symmetric(horizontal: 10),
                              padding: EdgeInsets.symmetric(
                                horizontal: 10,
                                vertical: 5,
                              ),
                              decoration: BoxDecoration(
                                color: AppColors.app_blue,
                                borderRadius: BorderRadius.circular(15),
                              ),
                              child:
                                  provider.isLoading
                                      ? CircularProgressIndicator.adaptive(
                                        valueColor: AlwaysStoppedAnimation(
                                          AppColors.white,
                                        ),
                                      )
                                      : Text(
                                        "Submit",
                                        style: TextStyle(
                                          fontSize: 15,
                                          fontFamily: "JakartaMedium",
                                          color: Colors.white,
                                        ),
                                      ),
                            ),
                          ),
                        ],
                      ),
                    ),
                  );
                },
              ),
            );
          },
        );
      },
    );
  }

  Future<void> _showOptionsSheet(BuildContext context) {
    return showModalBottomSheet(
      useSafeArea: true,
      isDismissible: true,
      isScrollControlled: true,
      showDragHandle: true,
      backgroundColor: Colors.white,
      enableDrag: true,
      context: context,
      builder: (context) {
        return StatefulBuilder(
          builder: (context, setState) {
            return SafeArea(
              child: Consumer<crmLeadDetailsProvider>(
                builder: (context, provider, child) {
                  return Container(
                    margin: EdgeInsets.only(
                      bottom: 15,
                      left: 15,
                      right: 15,
                      top: 10,
                    ),
                    padding: EdgeInsets.only(
                      bottom: MediaQuery.of(context).viewInsets.bottom,
                    ),
                    child: SingleChildScrollView(
                      child: Column(
                        mainAxisSize: MainAxisSize.min,
                        children: [
                          SizedBox(height: 15),

                          ...List.generate(4, (index) {
                            final assetnames = [
                              "crm_appoint_details",
                              "crm_cont_details",
                              "crm_follow_up_details",
                              "crm_prod_details",
                            ];
                            final Headingnames = [
                              "Lead Details",
                              "Contact Details",
                              "Order Details",
                              "Payment Details",
                            ];
                            return ListTile(
                              onTap: () {
                                switch (index) {
                                  case 0:
                                    Navigator.push(
                                      context,
                                      MaterialPageRoute(
                                        builder:
                                            (context) => ProspectLeadDetails(
                                              leadID: widget.leadId,
                                              mode: widget.mode,
                                            ),
                                      ),
                                    );
                                    break;
                                  case 1:
                                    Navigator.push(
                                      context,
                                      MaterialPageRoute(
                                        builder:
                                            (context) => ProspectContactDetails(
                                              accountId:
                                                  provider.accountDetails.id,
                                            ),
                                      ),
                                    );
                                    break;
                                  case 2:
                                    Navigator.push(
                                      context,
                                      MaterialPageRoute(
                                        builder:
                                            (context) => ProspectOrderDetails(
                                              leadID: widget.leadId,
                                            ),
                                      ),
                                    );
                                    break;
                                  case 3:
                                    Navigator.push(
                                      context,
                                      MaterialPageRoute(
                                        builder:
                                            (context) => ProspectPaymentDetails(
                                              leadID: widget.leadId,
                                            ),
                                      ),
                                    );
                                    break;

                                  default:
                                    print("object");
                                }
                              },
                              leading: SvgPicture.asset(
                                "assets/svg/${assetnames[index]}.svg",
                              ),
                              title: Text(
                                Headingnames[index],
                                style: TextStyle(fontFamily: "JakartaMedium"),
                              ),
                              trailing: SvgPicture.asset(
                                "assets/svg/arrow_right_new.svg",
                              ),
                            );
                          }),
                        ],
                      ),
                    ),
                  );
                },
              ),
            );
          },
        );
      },
    );
  }
}
