import 'package:flutter/material.dart';
import 'package:flutter_svg/svg.dart';

class RewardSearchScreen extends StatefulWidget {
  const RewardSearchScreen({super.key});

  @override
  State<RewardSearchScreen> createState() => _RewardSearchScreenState();
}

class _RewardSearchScreenState extends State<RewardSearchScreen> {
  final TextEditingController _searchController = TextEditingController();

  // Dummy data
  final List<String> accounts = [
    "Siddha Bank",
    "Siddharth Shivam",
    "Sidheshwar Temple",
    "Axis Bank",
    "SBI",
  ];

  final List<String> inquiries = [
    "Inquiry Siddha Bank",
    "Inquiry Sidharth",
    "Inquiry Sidheshwar",
    "Customer SBI",
  ];

  final List<String> leads = [
    "Lead Siddha Bank",
    "Lead Shivam",
    "Lead Sidheshwar",
    "Lead HDFC",
  ];

  // Filtered data
  String query = "";

  @override
  Widget build(BuildContext context) {
    final filteredAccounts =
        accounts
            .where((e) => e.toLowerCase().contains(query.toLowerCase()))
            .toList();
    final filteredInquiries =
        inquiries
            .where((e) => e.toLowerCase().contains(query.toLowerCase()))
            .toList();
    final filteredLeads =
        leads
            .where((e) => e.toLowerCase().contains(query.toLowerCase()))
            .toList();

    return Scaffold(
      appBar: AppBar(
        automaticallyImplyLeading: false,
        backgroundColor: const Color(0xFFFFFFFF),
        title: Row(
          children: [
            InkResponse(
              onTap: () => Navigator.pop(context, true),
              child: SvgPicture.asset(
                "assets/svg/appbar_back_button.svg",
                height: 25,
              ),
            ),
            const SizedBox(width: 10),
            const Text(
              "Search",
              style: TextStyle(
                fontSize: 18,
                fontFamily: "Plus Jakarta Sans",
                fontWeight: FontWeight.w600,
                color: Colors.black87,
              ),
            ),
          ],
        ),
      ),

      backgroundColor: Color(0xFFF6F6F8),
      body: SingleChildScrollView(
        padding: const EdgeInsets.all(16),
        child: Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            ///  Search Field
            TextField(
              controller: _searchController,
              onChanged: (value) {
                setState(() {
                  query = value;
                });
              },
              decoration: InputDecoration(
                hintText: "Search",
                prefixIcon: const Icon(Icons.search, color: Colors.black54),
                filled: true,
                fillColor: const Color(0xffFFFFFF),
                contentPadding: const EdgeInsets.symmetric(
                  horizontal: 16,
                  vertical: 12,
                ),
                border: OutlineInputBorder(
                  borderRadius: BorderRadius.circular(12),
                  borderSide: BorderSide.none,
                ),
              ),
            ),

            const SizedBox(height: 20),

            if (query.isNotEmpty)
              Text(
                'Result for “$query”',
                style: const TextStyle(
                  fontSize: 18,
                  color: Color(0xff1487C9),
                  fontFamily: "Plus Jakarta Sans",
                  fontWeight: FontWeight.w600,
                ),
              ),

            const SizedBox(height: 20),

            if (query.isNotEmpty && filteredAccounts.isNotEmpty)
              _buildSection("Accounts", filteredAccounts),

            if (query.isNotEmpty && filteredInquiries.isNotEmpty)
              _buildSection("Inquiries", filteredInquiries),

            if (query.isNotEmpty && filteredLeads.isNotEmpty)
              _buildSection("Leads", filteredLeads),

            if (query.isNotEmpty &&
                filteredAccounts.isEmpty &&
                filteredInquiries.isEmpty &&
                filteredLeads.isEmpty)
              const Center(
                child: Text(
                  "No results found",
                  style: TextStyle(fontSize: 14, color: Colors.grey),
                ),
              ),
          ],
        ),
      ),
    );
  }

  /// Reusable Section Widget
  Widget _buildSection(String title, List<String> items) {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        Text(
          title,
          style: const TextStyle(
            fontSize: 14,
            fontWeight: FontWeight.w500,
            fontFamily: "Plus Jakarta Sans",
            color: Color(0xff2D2D2D),
          ),
        ),
        const SizedBox(height: 10),
        Column(
          children:
              items
                  .map(
                    (e) => Container(
                      margin: const EdgeInsets.only(bottom: 12),
                      padding: const EdgeInsets.symmetric(
                        horizontal: 12,
                        vertical: 12,
                      ),
                      decoration: BoxDecoration(
                        color: Colors.white,
                        borderRadius: BorderRadius.circular(12),
                        boxShadow: [
                          BoxShadow(
                            color: Colors.grey.withOpacity(0.1),
                            blurRadius: 5,
                            offset: const Offset(0, 3),
                          ),
                        ],
                      ),
                      child: Row(
                        children: [
                          Container(
                            height: 32,
                            width: 32,
                            decoration: BoxDecoration(
                              color: const Color(0xffE8F3FF),
                              borderRadius: BorderRadius.circular(8),
                            ),
                            child: const Icon(
                              Icons.search,
                              color: Color(0xff0066FF),
                              size: 20,
                            ),
                          ),
                          const SizedBox(width: 10),
                          Expanded(
                            child: Text(
                              e,
                              style: const TextStyle(
                                fontSize: 14,
                                fontFamily: "Plus Jakarta Sans",
                                fontWeight: FontWeight.w400,
                                color: Color(0xff2D2D2D),
                              ),
                              overflow: TextOverflow.ellipsis,
                            ),
                          ),
                        ],
                      ),
                    ),
                  )
                  .toList(),
        ),
      ],
    );
  }
}
