import 'package:dotted_line/dotted_line.dart';
import 'package:flutter/material.dart';
import 'package:flutter_svg/svg.dart';
import 'package:generp/screens/hrm/RewardSearchScreen.dart';
import 'package:provider/provider.dart';

import '../../Notifiers/hrmProvider/rewardListProvider.dart';
import '../../Utils/app_colors.dart';

class RewardListScreen extends StatefulWidget {
  const RewardListScreen({super.key});

  @override
  State<RewardListScreen> createState() => _RewardListScreenState();
}

class _RewardListScreenState extends State<RewardListScreen> {
  @override
  Widget build(BuildContext context) {
    return SafeArea(
      top: false,
      child: ChangeNotifierProvider(
        create: (_) => RewardListProvider()..fetchRewardList(context),
        child: Consumer<RewardListProvider>(
          builder: (context, provider, child) {
            return Scaffold(
              appBar: AppBar(
                automaticallyImplyLeading: false,
                backgroundColor: Colors.white,
                title: Row(
                  children: [
                    InkResponse(
                      onTap: () => Navigator.pop(context, true),
                      child: SvgPicture.asset(
                        "assets/svg/appbar_back_button.svg",
                        height: 25,
                      ),
                    ),
                    const SizedBox(width: 10),
                    Text(
                      "Reward List",
                      style: TextStyle(
                        fontSize: 18,
                        fontFamily: "Plus Jakarta Sans",
                        fontWeight: FontWeight.w600,
                        color: AppColors.semi_black,
                      ),
                    ),
                  ],
                ),
                // actions: [
                //   InkResponse(
                //     onTap: () {
                //       Navigator.push(
                //         context,
                //         MaterialPageRoute(
                //           builder: (context) => RewardSearchScreen(),
                //           settings: const RouteSettings(
                //             name: 'AddLiveAttendanceScreen',
                //           ),
                //         ),
                //       ).then((_) {
                //       });
                //     },
                //     child: SvgPicture.asset(
                //       "assets/svg/search_ic.svg",
                //       height: 25,
                //     ),
                //   ),
                //   const SizedBox(width: 20),
                // ],
              ),

              backgroundColor: Color(0xFFF6F6F8),
              body: Builder(
                builder: (context) {
                  if (provider.isLoading) {
                    return const Center(
                      child: CircularProgressIndicator(color: Colors.blue),
                    );
                  }
                  if (provider.errorMessage != null) {
                    return Center(child: Text(provider.errorMessage!));
                  }
                  if (provider.response == null) {
                    return const Center(child: Text("No details found"));
                  }
                  final rewardDetail = provider.response!;
                  final rewardResponse = provider.response!;
                  final rewards =
                      rewardResponse.rewardsList; //  main list object
                  final achieved = rewardResponse.achievedAmount ?? "0";
                  final disbursed = rewardResponse.disbursedAmount ?? "0";
                  final balance = rewardResponse.balanceAmount ?? "0";
                  return SingleChildScrollView(
                    padding: const EdgeInsets.all(16),
                    child: Column(
                      children: [
                        /// --- Top Summary Cards ---
                        Stack(
                          children: [
                            Container(
                              height: 110,
                              width: double.infinity,
                              padding: const EdgeInsets.all(18),
                              decoration: BoxDecoration(
                                color: const Color(0xffd9ffd6),
                                borderRadius: BorderRadius.circular(18),
                              ),
                              child: Column(
                                crossAxisAlignment: CrossAxisAlignment.start,
                                mainAxisAlignment: MainAxisAlignment.center,
                                children: [
                                  Text(
                                    "₹$achieved", // Achieved Amount from response
                                    style: const TextStyle(
                                      fontSize: 20,
                                      color: Color(0xff0D9C00),
                                      fontStyle: FontStyle.normal,
                                      fontWeight: FontWeight.w500,
                                    ),
                                  ),
                                  const SizedBox(height: 10),
                                  const Text(
                                    "Achievement Amount",
                                    style: TextStyle(
                                      fontSize: 14,
                                      color: Color(0xff2D2D2D),
                                      fontStyle: FontStyle.normal,
                                      fontWeight: FontWeight.w400,
                                    ),
                                  ),
                                ],
                              ),
                            ),

                            // Positioned SVG Icon
                            Positioned(
                              bottom: 8,
                              right: 12,
                              child: Container(
                                height: 42,
                                width: 42,
                                decoration: BoxDecoration(
                                  shape: BoxShape.circle,
                                  color: const Color(0xA0FFFFFF), // icon bg
                                ),
                                child: Center(
                                  child: SvgPicture.asset(
                                    height: 25,
                                    width: 25,
                                    "assets/svg/hrm/achievement_ic.svg",
                                    fit: BoxFit.contain,
                                  ),
                                ),
                              ),
                            ),
                          ],
                        ),
                        const SizedBox(height: 12),

                        Row(
                          children: [
                            Expanded(
                              child: Container(
                                height: 110,
                                padding: const EdgeInsets.all(16),
                                decoration: BoxDecoration(
                                  color: const Color(0xffe8ddff),
                                  borderRadius: BorderRadius.circular(16),
                                ),
                                child: Stack(
                                  children: [
                                    Column(
                                      crossAxisAlignment:
                                          CrossAxisAlignment.start,
                                      children: [
                                        Text(
                                          "₹$disbursed", // Disbursed Amount
                                          style: const TextStyle(
                                            fontSize: 20,
                                            color: Color(0xff493272),
                                            fontWeight: FontWeight.w500,
                                          ),
                                        ),
                                        const SizedBox(height: 8),
                                        const Text(
                                          "Disbursed \nAmount",
                                          style: TextStyle(
                                            fontSize: 14,
                                            color: Color(0xff2D2D2D),
                                            fontWeight: FontWeight.w400,
                                          ),
                                        ),
                                      ],
                                    ),
                                    Positioned(
                                      bottom: 2,
                                      right: 2,
                                      child: Container(
                                        height: 42,
                                        width: 42,
                                        decoration: BoxDecoration(
                                          shape: BoxShape.circle,
                                          color: const Color(
                                            0xA0FFFFFF,
                                          ), // icon bg
                                        ),
                                        child: Center(
                                          child: SvgPicture.asset(
                                            height: 25,
                                            width: 25,
                                            "assets/svg/hrm/location_ic.svg",
                                            fit: BoxFit.contain,
                                          ),
                                        ),
                                      ),
                                    ),
                                  ],
                                ),
                              ),
                            ),
                            const SizedBox(width: 12),
                            Expanded(
                              child: Container(
                                height: 110,
                                padding: const EdgeInsets.all(16),
                                decoration: BoxDecoration(
                                  color: const Color(0xfffffbc3),
                                  borderRadius: BorderRadius.circular(16),
                                ),
                                child: Stack(
                                  children: [
                                    Column(
                                      crossAxisAlignment:
                                          CrossAxisAlignment.start,
                                      children: [
                                        Text(
                                          "₹$balance", // Balance Amount
                                          style: const TextStyle(
                                            fontSize: 18,
                                            color: Color(0xff605C00),
                                          ),
                                        ),
                                        const SizedBox(height: 8),
                                        const Text(
                                          "Balance \nAmount",
                                          style: TextStyle(
                                            fontSize: 14,
                                            color: Color(0xff2D2D2D),
                                            fontWeight: FontWeight.w400,
                                          ),
                                        ),
                                      ],
                                    ),
                                    Positioned(
                                      bottom: 2,
                                      right: 2,
                                      child: Container(
                                        height: 42,
                                        width: 42,
                                        decoration: BoxDecoration(
                                          shape: BoxShape.circle,
                                          color: const Color(
                                            0xA0FFFFFF,
                                          ), // icon bg
                                        ),
                                        child: Center(
                                          child: SvgPicture.asset(
                                            height: 25,
                                            width: 25,
                                            "assets/svg/hrm/ballance_ic.svg",
                                            fit: BoxFit.contain,
                                          ),
                                        ),
                                      ),
                                    ),
                                  ],
                                ),
                              ),
                            ),
                          ],
                        ),

                        const SizedBox(height: 20),

                        /// --- Reward List Card ---
                        if (rewards != null)
                          _rewardListCard(
                            title:
                                rewards.description ??
                                "-", //  rewardsList fields
                            dateTime: rewards.dateTime ?? "-",
                            achieved: achieved,
                            disbursed: disbursed,
                            balance: balance,
                            enteredBy: rewards.enteredBy ?? "-",
                          )
                        else
                          const Text("No rewards available"),
                      ],
                    ),
                  );
                },
              ),
            );
          },
        ),
      ),
    );
  }

  ///  Reusable Reward Card Function
  Widget _rewardListCard({
    required String title,
    required String dateTime,
    required String achieved,
    required String disbursed,
    required String balance,
    required String enteredBy,
  }) {
    return Container(
      margin: const EdgeInsets.only(bottom: 16),
      padding: const EdgeInsets.all(16),
      decoration: BoxDecoration(
        color: Colors.white,
        borderRadius: BorderRadius.circular(16),
        // boxShadow: [
        //   BoxShadow(
        //     color: Colors.grey.withOpacity(0.1),
        //     blurRadius: 6,
        //     offset: const Offset(0, 3),
        //   )
        // ],
      ),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          /// Header Row
          Row(
            children: [
              CircleAvatar(
                radius: 22.5,
                backgroundColor: Color(0xffEDF8FF),
                child: SvgPicture.asset(
                  height: 28,
                  width: 28,
                  "assets/svg/hrm/rewardList.svg",
                  fit: BoxFit.contain,
                ),
              ),
              const SizedBox(width: 8),
              Expanded(
                child: Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    Text(
                      title,
                      style: const TextStyle(
                        fontSize: 14.5,
                        color: Color(0xff2D2D2D),
                        fontFamily: "Plus Jakarta Sans",
                        fontStyle: FontStyle.normal,
                        fontWeight: FontWeight.w400,
                      ),
                    ),
                    Text(
                      dateTime,
                      style: const TextStyle(
                        fontSize: 12.5,
                        color: Color(0xff818181),
                        fontFamily: "Plus Jakarta Sans",
                        fontStyle: FontStyle.normal,
                        fontWeight: FontWeight.w400,
                      ),
                    ),
                  ],
                ),
              ),
            ],
          ),

          const SizedBox(height: 12),

          /// Amount Details
          Padding(
            padding: const EdgeInsets.all(2.0),
            child: Row(
              children: [
                const Text(
                  "Amount Details",
                  style: TextStyle(fontSize: 14, fontFamily: "JakartaSemiBold"),
                ),
                const SizedBox(width: 10),
                Expanded(
                  child: DottedLine(
                    dashGapLength: 4,
                    dashGapColor: Colors.white,
                    dashColor: AppColors.grey_semi,
                    dashLength: 2,
                    lineThickness: 0.5,
                  ),
                ),
              ],
            ),
          ),
          const SizedBox(height: 6),

          _buildKeyValue("Achieved Amount", achieved),
          _buildKeyValue("Disbursed Amount", disbursed),
          _buildKeyValue("Balance Amount", balance),

          const SizedBox(height: 10),

          /// Employee Details
          Padding(
            padding: const EdgeInsets.all(2.0),
            child: Row(
              children: [
                const Text(
                  "Employee Details",
                  style: TextStyle(fontSize: 14, fontFamily: "JakartaSemiBold"),
                ),
                const SizedBox(width: 10),
                Expanded(
                  child: DottedLine(
                    dashGapLength: 4,
                    dashGapColor: Colors.white,
                    dashColor: AppColors.grey_semi,
                    dashLength: 2,
                    lineThickness: 0.5,
                  ),
                ),
              ],
            ),
          ),

          _buildKeyValue("Entered By", enteredBy),
        ],
      ),
    );
  }

  ///  Key-Value Row
  Widget _buildKeyValue(String key, String value) {
    return Padding(
      padding: const EdgeInsets.symmetric(vertical: 3.5, horizontal: 2),
      child: Row(
        mainAxisAlignment: MainAxisAlignment.spaceBetween,
        children: [
          Text(
            key,
            style: TextStyle(
              fontFamily: "JakartaRegular",
              fontSize: 14,
              color: AppColors.semi_black,
            ),
          ),

          Text(
            value,
            style: const TextStyle(fontSize: 14, color: Color(0xFF818181)),
          ),
        ],
      ),
    );
  }
}
