import 'package:flutter/material.dart';
import 'package:provider/provider.dart';

import '../../Models/hrmModels/leaveApplicationDetailsResponse.dart';
import '../../Models/ordersModels/commonResponse.dart';
import '../../services/api_calling.dart';
import '../HomeScreenNotifier.dart';

class LeaveApplicationDetailsProvider extends ChangeNotifier {
  leaveApplicationDetailsResponse? _response;
  bool _isLoading = false;
  String? _errorMessage;
  bool _isSubmitting = false;
  bool get isSubmitting => _isSubmitting;

  CommonResponse? _StatusResponse;
  CommonResponse? get Response => _StatusResponse;

  leaveApplicationDetailsResponse? get response => _response;
  bool get isLoading => _isLoading;
  String? get errorMessage => _errorMessage;

  /// Fetch leave application details
  Future<void> fetchLeaveApplicationDetails(
    BuildContext context,
    String leaveRequestId,
  ) async {
    _isLoading = true;
    _errorMessage = null;
    _response = null;
    notifyListeners();

    try {
      final provider = Provider.of<HomescreenNotifier>(context, listen: false);
      final result = await ApiCalling.leaveApplicationDetailAPI(
        provider.session,
        provider.empId,
        leaveRequestId,
      );

      if (result != null) {
        _response = result;
      } else {
        _errorMessage = "No data found!";
      }
    } catch (e) {
      _errorMessage = "Something went wrong: $e";
      debugPrint('Error fetching leave application details: $e');
    }

    _isLoading = false;
    notifyListeners();
  }

  Future<void> leaveRequestRejectApprove(
    BuildContext context, {
    required String mode,
    required String type,
    required String remarks,
    required String id,
  }) async {
    _isSubmitting = true;
    _errorMessage = null;
    _StatusResponse = null;
    notifyListeners();

    try {
      final homeProvider = Provider.of<HomescreenNotifier>(
        context,
        listen: false,
      );

      final result = await ApiCalling.leaveRequestRejectApproveAPI(
        homeProvider.session,
        homeProvider.empId,
        mode,
        type,
        remarks,
        id,
      );

      if (result != null) {
        _StatusResponse = result;

        if (result.error != null && result.error!.isNotEmpty) {
          _errorMessage = result.error;
        } else {
          // Show success snack bar
          ScaffoldMessenger.of(context).showSnackBar(
            SnackBar(
              content: Text(
                "Leave request ${type.toLowerCase()} successfully.",
              ),
              backgroundColor: Colors.green,
              behavior: SnackBarBehavior.floating,
            ),
          );
        }
      } else {
        _errorMessage = "Failed to $type leave request!";
      }
    } catch (e) {
      _errorMessage = "Error while processing leave request: $e";
    }

    _isSubmitting = false;
    notifyListeners();
  }

  /// Clear the current response data
  void clearData() {
    _response = null;
    _errorMessage = null;
    notifyListeners();
  }
}
