// import 'package:flutter/cupertino.dart';
// import 'package:flutter/foundation.dart';
// import 'package:generp/Models/crmModels/GetSegmentOnTeamResponse.dart';
// import 'package:generp/Models/crmModels/GetSourceOnReferenceResponse.dart';
// import 'package:generp/Models/crmModels/LeadListViewResponse.dart';
// import 'package:generp/Models/crmModels/SubmitLeadListFilterResponse.dart';
// import 'package:provider/provider.dart';
//
// import '../../Models/crmModels/GetDistrictOnStateResponse.dart';
// import '../../Models/crmModels/GetSubLocOnDistrictResponse.dart';
// import '../../Models/crmModels/LeadListContactPopUpResponse.dart' show Contacts;
// import '../../services/api_calling.dart';
// import '../HomeScreenNotifier.dart';
//
// class Leadlistprovider extends ChangeNotifier {
//   TextEditingController sLeadIDController = TextEditingController();
//   TextEditingController mobileNumberController = TextEditingController();
//   TextEditingController companyNameController = TextEditingController(
//     text: "a",
//   );
//
//   bool _isLoading = true;
//
//   List<Sources> _sourcesList = [];
//   List<Teams> _teamsList = [];
//   List<States> _statesList = [];
//   List<Employees> _employeesList = [];
//   List<References> _referencesList = [];
//   List<Segments> _segmentsList = [];
//   List<Districts> _districtsList = [];
//   List<SubLocations> _subLocationsList = [];
//   List<Contacts> _contactsList = [];
//   List<LeadList> _crmLeadList = [];
//   List<String?> _leadStatusList = [];
//   List<String?> _openStatusList = [];
//   List<String?> _alphabetList = [];
//
//
//   Sources? _selectedSources;
//   Teams? _selectedTeams;
//   States? _selectedStates;
//   Employees? _selectedEmployees;
//   References? _selectedReferences;
//   Segments? _selectedSegments;
//   Districts? _selectedDistricts;
//   SubLocations? _selectedSubLocations;
//   Contacts? _selectedContacts;
//   String? _selectedLeadStatus;
//   String? _selectedOpenStatus;
//   String? _selectedAlphabet;
//
//   String? _selectedSourceId;
//   String? _selectedSourceValue;
//
//   String? _selectedTeamId;
//   String? _selectedTeamValue;
//
//   String? _selectedStateId;
//   String? _selectedStateValue;
//
//   String? _selectedEmployeeId;
//   String? _selectedEmployeeValue;
//
//   String? _selectedReferenceId;
//   String? _selectedReferenceValue;
//
//   String? _selectedSegmentId;
//   String? _selectedSegmentValue;
//
//   String? _selectedDistrictId;
//   String? _selectedDistrictValue;
//
//   String? _selectedSubLocationId;
//   String? _selectedSubLocationValue;
//
//   String? _selectedContactId;
//   String? _selectedContactValue;
//
//   bool get isLoading => _isLoading;
//
//   List<Sources> get sourcesList => _sourcesList;
//
//   List<Teams> get teamsList => _teamsList;
//
//   List<States> get statesList => _statesList;
//
//   List<Employees> get employeesList => _employeesList;
//
//   List<References> get referencesList => _referencesList;
//
//   List<Segments> get segmentsList => _segmentsList;
//
//   List<Districts> get districtsList => _districtsList;
//
//   List<SubLocations> get subLocationsList => _subLocationsList;
//
//   List<Contacts> get contactsList => _contactsList;
//
//   List<LeadList> get crmLeadList => _crmLeadList;
//
//   List<String?> get leadStatusList => _leadStatusList;
//
//   List<String?> get alphabetList => _alphabetList;
//
//   List<String?> get openStatusList => _openStatusList;
//
//   Sources? get selectedSource => _selectedSources;
//
//   Teams? get selectedTeam => _selectedTeams;
//
//   States? get selectedStates => _selectedStates;
//
//   Employees? get selectedEmployee => _selectedEmployees;
//
//   References? get selectedReference => _selectedReferences;
//
//   Segments? get selectedSegment => _selectedSegments;
//
//   Districts? get selectedDistricts => _selectedDistricts;
//
//   SubLocations? get selectedSubLocations => _selectedSubLocations;
//
//   Contacts? get selectedContacts => _selectedContacts;
//
//   String? get selectedLeadStatus => _selectedLeadStatus;
//
//   String? get selectedOpenStatus => _selectedOpenStatus;
//
//   String? get selectedSourceId => _selectedSourceId;
//
//   String? get selectedSourceValue => _selectedSourceValue;
//
//   String? get selectedTeamId => _selectedTeamId;
//
//   String? get selectedTeamValue => _selectedTeamValue;
//
//   String? get selectedStateId => _selectedStateId;
//
//   String? get selectedStateValue => _selectedStateValue;
//
//   String? get selectedEmployeeId => _selectedEmployeeId;
//
//   String? get selectedEmployeeValue => _selectedEmployeeValue;
//
//   String? get selectedReferenceId => _selectedReferenceId;
//
//   String? get selectedReferenceValue => _selectedReferenceValue;
//
//   String? get selectedSegmentId => _selectedSegmentId;
//
//   String? get selectedSegmentValue => _selectedSegmentValue;
//
//   String? get selectedDistrictId => _selectedDistrictId;
//
//   String? get selectedDistrictValue => _selectedDistrictValue;
//
//   String? get selectedSubLocationId => _selectedSubLocationId;
//
//   String? get selectedSubLocationValue => _selectedSubLocationValue;
//
//   String? get selectedContactId => _selectedContactId;
//
//   String? get selectedContactValue => _selectedContactValue;
//
//   String? get selectedAlphabet => _selectedAlphabet;
//
//   set isLoading(bool value) {
//     _isLoading = value;
//     notifyListeners();
//   }
//
//   set selectedAlphabet(String? value){
//     _selectedAlphabet = value;
//     notifyListeners();
//   }
//
//   set selectedSource(Sources? value) {
//     _selectedSources = value;
//     _selectedSourceId = value!.id!;
//     _selectedSourceValue = value!.name!;
//     notifyListeners();
//   }
//
//   set selectedTeam(Teams? value) {
//     _selectedTeams = value;
//     _selectedTeamId = value!.id!;
//     _selectedTeamValue = value.name;
//     notifyListeners();
//   }
//
//   set selectedStates(States? value) {
//     _selectedStates = value;
//     _selectedStateId = value!.id!;
//     _selectedStateValue = value.name;
//     notifyListeners();
//   }
//
//   set selectedEmployee(Employees? value) {
//     _selectedEmployees = value;
//     _selectedEmployeeId = value!.id!;
//     _selectedEmployeeValue = value.name;
//     notifyListeners();
//   }
//
//   set selectedReference(References? value) {
//     _selectedReferences = value;
//     _selectedReferenceId = value!.id!;
//     _selectedReferenceValue = value.name;
//     notifyListeners();
//   }
//
//   set selectedSegment(Segments? value) {
//     _selectedSegments = value;
//     _selectedSegmentId = value!.id!;
//     _selectedSegmentValue = value.name;
//     notifyListeners();
//   }
//
//   set selectedDistricts(Districts? value) {
//     _selectedDistricts = value;
//     _selectedDistrictId = value!.id!;
//     _selectedDistrictValue = value.district;
//     notifyListeners();
//   }
//
//   set selectedSubLocations(SubLocations? value) {
//     _selectedSubLocations = value;
//     _selectedSubLocationId = value!.id!;
//     _selectedSubLocationValue = value.subLocality;
//     notifyListeners();
//   }
//
//   set selectedContacts(Contacts? value) {
//     _selectedContacts = value;
//     _selectedContactId = value!.id!;
//     _selectedContactValue = value.name;
//     notifyListeners();
//   }
//
//   set selectedLeadStatus(String? value) {
//     _selectedLeadStatus = value;
//     notifyListeners();
//   }
//
//   set selectedOpenStatus(String? value) {
//     _selectedOpenStatus = value;
//     notifyListeners();
//   }
//
//   set selectedSourceId(String? value) {
//     _selectedSourceId = value;
//     notifyListeners();
//   }
//
//   set selectedSourceValue(String? value) {
//     _selectedSourceValue = value;
//     notifyListeners();
//   }
//
//   set selectedTeamId(String? value) {
//     _selectedTeamId = value;
//     notifyListeners();
//   }
//
//   set selectedTeamValue(String? value) {
//     _selectedTeamValue = value;
//     notifyListeners();
//   }
//
//   set selectedStateId(String? value) {
//     _selectedStateId = value;
//     notifyListeners();
//   }
//
//   set selectedStateValue(String? value) {
//     _selectedStateValue = value;
//     notifyListeners();
//   }
//
//   set selectedEmployeeId(String? value) {
//     _selectedEmployeeId = value;
//     notifyListeners();
//   }
//
//   set selectedEmployeeValue(String? value) {
//     _selectedEmployeeValue = value;
//     notifyListeners();
//   }
//
//   set selectedReferenceId(String? value) {
//     _selectedReferenceId = value;
//     notifyListeners();
//   }
//
//   set selectedReferenceValue(String? value) {
//     _selectedReferenceValue = value;
//     notifyListeners();
//   }
//
//   set selectedSegmentId(String? value) {
//     _selectedSegmentId = value;
//     notifyListeners();
//   }
//
//   set selectedSegmentValue(String? value) {
//     _selectedSegmentValue = value;
//     notifyListeners();
//   }
//
//   set selectedDistrictId(String? value) {
//     _selectedDistrictId = value;
//     notifyListeners();
//   }
//
//   set selectedDistrictValue(String? value) {
//     _selectedDistrictValue = value;
//     notifyListeners();
//   }
//
//   set selectedSubLocationId(String? value) {
//     _selectedSubLocationId = value;
//     notifyListeners();
//   }
//
//   set selectedSubLocationValue(String? value) {
//     _selectedSubLocationValue = value;
//     notifyListeners();
//   }
//
//   set selectedContactId(String? value) {
//     _selectedContactId = value;
//     notifyListeners();
//   }
//
//   set selectedContactValue(String? value) {
//     _selectedContactValue = value;
//     notifyListeners();
//   }
//
//   Future<void> crmLeadListViewAPIFunction(context, mode) async {
//     try {
//       var HomeProv = Provider.of<HomescreenNotifier>(context, listen: false);
//       final data = await ApiCalling.crmLeadListViewAPI(
//         HomeProv.empId,
//         HomeProv.session,
//         mode,
//       );
//       if (data != null) {
//         print(data.error);
//         if (data.error == "0") {
//           // print("as");
//           _leadStatusList = [
//             "all",
//             "Hot",
//             "Warm",
//             "Cold",
//             "Order Gain",
//             "Order Lost",
//           ];
//           _alphabetList = List.generate(26, (index) => String.fromCharCode(index + 65));
//
//           _openStatusList = ["open", "Closed", "All"];
//           _sourcesList = data.sources!;
//           _teamsList = data.teams!;
//           _statesList = data.states!;
//           _employeesList = data.employees!;
//           checkDropDownValues();
//           // print(_leadStatusList);
//           notifyListeners();
//         }
//       }
//     } catch (e, s) {}
//   }
//
//   Future<void> crmLeadListSourceOnReferenceAPIFunction(
//     context,
//     mode,
//     sourceID,
//   ) async {
//     try {
//       var prov = Provider.of<HomescreenNotifier>(context, listen: false);
//       final data = await ApiCalling.crmLeadListSourceOnReferenceAPI(
//         prov.empId,
//         prov.session,
//         sourceID,
//       );
//       if (data != null) {
//         if (data.error == "0") {
//           _referencesList = data.references!;
//           notifyListeners();
//         }
//       }
//     } catch (e, s) {}
//   }
//
//   Future<void> crmLeadListSegmentOnTeamAPIFunction(
//     context,
//     mode,
//     teamID,
//   ) async {
//     try {
//       var prov = Provider.of<HomescreenNotifier>(context, listen: false);
//       final data = await ApiCalling.crmLeadListSegmentOnTeamAPI(
//         prov.empId,
//         prov.session,
//         teamID,
//       );
//       if (data != null) {
//         if (data.error == "0") {
//           _segmentsList = data.segments!;
//           notifyListeners();
//         }
//       }
//     } catch (e, s) {}
//   }
//
//   Future<void> crmLeadListDistrictsOnStateAPIFunction(
//     context,
//     mode,
//     stateID,
//   ) async {
//     try {
//       var prov = Provider.of<HomescreenNotifier>(context, listen: false);
//       final data = await ApiCalling.crmDistrictsOnStateAPI(
//         prov.empId,
//         prov.session,
//         stateID,
//       );
//       if (data != null) {
//         if (data.error == "0") {
//           _districtsList = data.districts!;
//           notifyListeners();
//         }
//       }
//     } catch (e, s) {}
//   }
//
//   Future<void> crmLeadListSubLocOnDistrictAPIFunction(
//     context,
//     mode,
//     districtID,
//   ) async {
//     try {
//       var prov = Provider.of<HomescreenNotifier>(context, listen: false);
//       final data = await ApiCalling.crmSubLocOnDistrictAPI(
//         prov.empId,
//         prov.session,
//         districtID,
//       );
//       if (data != null) {
//         if (data.error == "0") {
//           _subLocationsList = data.subLocations!;
//           notifyListeners();
//         }
//       }
//     } catch (e, s) {}
//   }
//
//   Future<void> crmLeadListContactPopUpAPIFunction(
//     context,
//     mode,
//     accountID,
//   ) async {
//     try {
//       var prov = Provider.of<HomescreenNotifier>(context, listen: false);
//       final data = await ApiCalling.crmLeadListContactPopUpAPI(
//         prov.empId,
//         prov.session,
//         accountID,
//       );
//       if (data != null) {
//         if (data.error == "0") {
//           _contactsList = data.contacts!;
//           notifyListeners();
//         }
//       }
//     } catch (e, s) {}
//   }
//
//   Future<void> crmLeadListAPIFunction(
//     context,
//     mode,
//     leadStatus,
//     openStatus,
//     sourceID,
//     referenceID,
//     teamID,
//     segmentID,
//       alphabet
//   ) async {
//     try {
//       _isLoading = true;
//       _crmLeadList.clear();
//       notifyListeners();
//       var HomeProv = Provider.of<HomescreenNotifier>(context, listen: false);
//       final data = await ApiCalling.crmLeadListFilterSubmitAPI(
//         HomeProv.empId,
//         HomeProv.session,
//         mode,
//         leadStatus,
//         openStatus,
//         mobileNumberController.text,
//         companyNameController.text,
//         sourceID,
//         referenceID,
//         teamID,
//         segmentID,
//           alphabet
//       );
//       if (data != null) {
//         _isLoading = true;
//         notifyListeners();
//         if (data.error == "0") {
//           _crmLeadList = data.leadList!;
//           _isLoading = false;
//           checkDropDownValues();
//           notifyListeners();
//         } else {
//           _isLoading = false;
//           notifyListeners();
//         }
//       } else {
//         _isLoading = false;
//         notifyListeners();
//       }
//     } catch (e, s) {
//       _isLoading = false;
//       notifyListeners();
//     }
//   }
//
//   onChangedLeadId(value) {
//     notifyListeners();
//   }
//
//   onChangedMobileNum(value) {
//     notifyListeners();
//   }
//
//   onChangedCompanyName(value) {
//     notifyListeners();
//   }
//
//   void resetForm() {
//     _isLoading = false;
//     sLeadIDController.clear();
//     mobileNumberController.clear();
//     companyNameController.clear();
//     companyNameController.text = "a";
//     _selectedEmployees = null;
//     _selectedSources = null;
//     _selectedReferences = null;
//     _selectedSegments = null;
//     _selectedTeams = null;
//     _selectedDistricts = null;
//     _selectedStates = null;
//     _selectedSubLocations = null;
//     _selectedLeadStatus = null;
//     _selectedOpenStatus = null;
//     _selectedEmployeeId = null;
//     _selectedSourceId = null;
//     _selectedReferenceId = null;
//     _selectedTeamId = null;
//     _selectedSegmentId = null;
//     _selectedStateId = null;
//     _selectedDistrictId = null;
//     _selectedSubLocationId = null;
//
//     _selectedEmployeeValue = null;
//     _selectedSourceValue = null;
//     _selectedReferenceValue = null;
//     _selectedTeamValue = null;
//     _selectedSegmentValue = null;
//     _selectedDistrictValue = null;
//     _selectedStateValue = null;
//     _selectedSubLocationValue = null;
//     checkDropDownValues();
//     notifyListeners();
//   }
//
//   void checkDropDownValues() {
//     if (!_employeesList.contains(_selectedEmployees) &&
//         _selectedEmployees != null) {
//       _selectedEmployeeId = null;
//       _selectedEmployeeValue = null;
//     }
//     if (!_sourcesList.contains(_selectedSources) && _selectedSources != null) {
//       _selectedSourceId = null;
//       _selectedSourceValue = null;
//     }
//     if (!_referencesList.contains(_selectedReferences) &&
//         _selectedReferences != null) {
//       _selectedReferenceId = null;
//       _selectedReferenceValue = null;
//     }
//     if (!_segmentsList.contains(_selectedSegments) &&
//         _selectedSegments != null) {
//       _selectedTeamId = null;
//       _selectedTeamValue = null;
//     }
//     if (!_teamsList.contains(_selectedTeams) && _selectedTeams != null) {
//       _selectedSegmentId = null;
//       _selectedSegmentValue = null;
//     }
//     if (!_districtsList.contains(_selectedDistricts) &&
//         _selectedDistricts != null) {
//       _selectedDistrictId = null;
//       _selectedDistrictValue = null;
//     }
//     if (!_statesList.contains(_selectedStates) && _selectedStates != null) {
//       _selectedStateId = null;
//       _selectedStateValue = null;
//     }
//     if (!_subLocationsList.contains(_selectedSubLocations) &&
//         _selectedSubLocations != null) {
//       _selectedSubLocationId = null;
//       _selectedSubLocationValue = null;
//     }
//     notifyListeners();
//   }
// }
import 'package:flutter/cupertino.dart';
import 'package:flutter/foundation.dart';
import 'package:generp/Models/crmModels/GetSegmentOnTeamResponse.dart';
import 'package:generp/Models/crmModels/GetSourceOnReferenceResponse.dart';
import 'package:generp/Models/crmModels/LeadListViewResponse.dart';
import 'package:generp/Models/crmModels/SubmitLeadListFilterResponse.dart';
import 'package:provider/provider.dart';

import '../../Models/crmModels/GetDistrictOnStateResponse.dart';
import '../../Models/crmModels/GetSubLocOnDistrictResponse.dart';
import '../../Models/crmModels/LeadListContactPopUpResponse.dart' show Contacts;
import '../../services/api_calling.dart';
import '../HomeScreenNotifier.dart';

class Leadlistprovider extends ChangeNotifier {
  TextEditingController sLeadIDController = TextEditingController();
  TextEditingController mobileNumberController = TextEditingController();
  TextEditingController companyNameController = TextEditingController();

  bool _isLoading = true;

  List<Sources> _sourcesList = [];
  List<Teams> _teamsList = [];
  List<States> _statesList = [];
  List<Employees> _employeesList = [];
  List<References> _referencesList = [];
  List<Segments> _segmentsList = [];
  List<Districts> _districtsList = [];
  List<SubLocations> _subLocationsList = [];
  List<Contacts> _contactsList = [];
  List<LeadList> _crmLeadList = [];
  List<String?> _leadStatusList = [];
  List<String?> _openStatusList = [];
  List<String?> _alphabetList = [];

  Sources? _selectedSources;
  Teams? _selectedTeams;
  States? _selectedStates;
  Employees? _selectedEmployees;
  References? _selectedReferences;
  Segments? _selectedSegments;
  Districts? _selectedDistricts;
  SubLocations? _selectedSubLocations;
  Contacts? _selectedContacts;
  String? _selectedLeadStatus;
  String? _selectedOpenStatus;
  String? _selectedAlphabet;

  String? _selectedSourceId;
  String? _selectedSourceValue;

  String? _selectedTeamId;
  String? _selectedTeamValue;

  String? _selectedStateId;
  String? _selectedStateValue;

  String? _selectedEmployeeId;
  String? _selectedEmployeeValue;

  String? _selectedReferenceId;
  String? _selectedReferenceValue;

  String? _selectedSegmentId;
  String? _selectedSegmentValue;

  String? _selectedDistrictId;
  String? _selectedDistrictValue;

  String? _selectedSubLocationId;
  String? _selectedSubLocationValue;

  String? _selectedContactId;
  String? _selectedContactValue;

  bool get isLoading => _isLoading;

  List<Sources> get sourcesList => _sourcesList;

  List<Teams> get teamsList => _teamsList;

  List<States> get statesList => _statesList;

  List<Employees> get employeesList => _employeesList;

  List<References> get referencesList => _referencesList;

  List<Segments> get segmentsList => _segmentsList;

  List<Districts> get districtsList => _districtsList;

  List<SubLocations> get subLocationsList => _subLocationsList;

  List<Contacts> get contactsList => _contactsList;

  List<LeadList> get crmLeadList => _crmLeadList;

  List<String?> get leadStatusList => _leadStatusList;

  List<String?> get alphabetList => _alphabetList;

  List<String?> get openStatusList => _openStatusList;

  Sources? get selectedSource => _selectedSources;

  Teams? get selectedTeam => _selectedTeams;

  States? get selectedStates => _selectedStates;

  Employees? get selectedEmployee => _selectedEmployees;

  References? get selectedReference => _selectedReferences;

  Segments? get selectedSegment => _selectedSegments;

  Districts? get selectedDistricts => _selectedDistricts;

  SubLocations? get selectedSubLocations => _selectedSubLocations;

  Contacts? get selectedContacts => _selectedContacts;

  String? get selectedLeadStatus => _selectedLeadStatus;

  String? get selectedOpenStatus => _selectedOpenStatus;

  String? get selectedSourceId => _selectedSourceId;

  String? get selectedSourceValue => _selectedSourceValue;

  String? get selectedTeamId => _selectedTeamId;

  String? get selectedTeamValue => _selectedTeamValue;

  String? get selectedStateId => _selectedStateId;

  String? get selectedStateValue => _selectedStateValue;

  String? get selectedEmployeeId => _selectedEmployeeId;

  String? get selectedEmployeeValue => _selectedEmployeeValue;

  String? get selectedReferenceId => _selectedReferenceId;

  String? get selectedReferenceValue => _selectedReferenceValue;

  String? get selectedSegmentId => _selectedSegmentId;

  String? get selectedSegmentValue => _selectedSegmentValue;

  String? get selectedDistrictId => _selectedDistrictId;

  String? get selectedDistrictValue => _selectedDistrictValue;

  String? get selectedSubLocationId => _selectedSubLocationId;

  String? get selectedSubLocationValue => _selectedSubLocationValue;

  String? get selectedContactId => _selectedContactId;

  String? get selectedContactValue => _selectedContactValue;

  String? get selectedAlphabet => _selectedAlphabet;

  set isLoading(bool value) {
    _isLoading = value;
    notifyListeners();
  }

  set selectedAlphabet(String? value) {
    _selectedAlphabet = value;
    notifyListeners();
  }

  set selectedSource(Sources? value) {
    _selectedSources = value;
    _selectedSourceId = value?.id;
    _selectedSourceValue = value?.name;
    print(
      'Setting selectedSource: $value, id: $_selectedSourceId, name: $_selectedSourceValue',
    );
    notifyListeners();
  }

  set selectedTeam(Teams? value) {
    _selectedTeams = value;
    _selectedTeamId = value?.id;
    _selectedTeamValue = value?.name;
    notifyListeners();
  }

  set selectedStates(States? value) {
    _selectedStates = value;
    _selectedStateId = value?.id;
    _selectedStateValue = value?.name;
    notifyListeners();
  }

  set selectedEmployee(Employees? value) {
    _selectedEmployees = value;
    _selectedEmployeeId = value?.id;
    _selectedEmployeeValue = value?.name;
    notifyListeners();
  }

  set selectedReference(References? value) {
    _selectedReferences = value;
    _selectedReferenceId = value?.id;
    _selectedReferenceValue = value?.name;
    notifyListeners();
  }

  set selectedSegment(Segments? value) {
    _selectedSegments = value;
    _selectedSegmentId = value?.id;
    _selectedSegmentValue = value?.name;
    notifyListeners();
  }

  set selectedDistricts(Districts? value) {
    _selectedDistricts = value;
    _selectedDistrictId = value?.id;
    _selectedDistrictValue = value?.district;
    notifyListeners();
  }

  set selectedSubLocations(SubLocations? value) {
    _selectedSubLocations = value;
    _selectedSubLocationId = value?.id;
    _selectedSubLocationValue = value?.subLocality;
    notifyListeners();
  }

  set selectedContacts(Contacts? value) {
    _selectedContacts = value;
    _selectedContactId = value?.id;
    _selectedContactValue = value?.name;
    notifyListeners();
  }

  set selectedLeadStatus(String? value) {
    _selectedLeadStatus = value;
    notifyListeners();
  }

  set selectedOpenStatus(String? value) {
    _selectedOpenStatus = value;
    notifyListeners();
  }

  set selectedSourceId(String? value) {
    _selectedSourceId = value;
    notifyListeners();
  }

  set selectedSourceValue(String? value) {
    _selectedSourceValue = value;
    notifyListeners();
  }

  set selectedTeamId(String? value) {
    _selectedTeamId = value;
    notifyListeners();
  }

  set selectedTeamValue(String? value) {
    _selectedTeamValue = value;
    notifyListeners();
  }

  set selectedStateId(String? value) {
    _selectedStateId = value;
    notifyListeners();
  }

  set selectedStateValue(String? value) {
    _selectedStateValue = value;
    notifyListeners();
  }

  set selectedEmployeeId(String? value) {
    _selectedEmployeeId = value;
    notifyListeners();
  }

  set selectedEmployeeValue(String? value) {
    _selectedEmployeeValue = value;
    notifyListeners();
  }

  set selectedReferenceId(String? value) {
    _selectedReferenceId = value;
    notifyListeners();
  }

  set selectedReferenceValue(String? value) {
    _selectedReferenceValue = value;
    notifyListeners();
  }

  set selectedSegmentId(String? value) {
    _selectedSegmentId = value;
    notifyListeners();
  }

  set selectedSegmentValue(String? value) {
    _selectedSegmentValue = value;
    notifyListeners();
  }

  set selectedDistrictId(String? value) {
    _selectedDistrictId = value;
    notifyListeners();
  }

  set selectedDistrictValue(String? value) {
    _selectedDistrictValue = value;
    notifyListeners();
  }

  set selectedSubLocationId(String? value) {
    _selectedSubLocationId = value;
    notifyListeners();
  }

  set selectedSubLocationValue(String? value) {
    _selectedSubLocationValue = value;
    notifyListeners();
  }

  set selectedContactId(String? value) {
    _selectedContactId = value;
    notifyListeners();
  }

  set selectedContactValue(String? value) {
    _selectedContactValue = value;
    notifyListeners();
  }

  Future<void> crmLeadListViewAPIFunction(context, mode) async {
    try {
      var HomeProv = Provider.of<HomescreenNotifier>(context, listen: false);
      final data = await ApiCalling.crmLeadListViewAPI(
        HomeProv.empId,
        HomeProv.session,
        mode,
      );
      if (data != null) {
        print(
          'crmLeadListViewAPI error: ${data.error}, sources: ${data.sources}',
        );
        if (data.error == "0") {
          _leadStatusList = [
            "all",
            "Hot",
            "Warm",
            "Cold",
            "Order Gain",
            "Order Lost",
          ];
          _alphabetList = List.generate(
            26,
            (index) => String.fromCharCode(index + 65),
          );
          _openStatusList = ["open", "Closed", "All"];
          _sourcesList =
              data.sources
                  ?.where((source) => source.id != null && source.name != null)
                  .toList() ??
              [];
          _teamsList =
              data.teams
                  ?.where((team) => team.id != null && team.name != null)
                  .toList() ??
              [];
          _statesList =
              data.states
                  ?.where((state) => state.id != null && state.name != null)
                  .toList() ??
              [];
          _employeesList =
              data.employees
                  ?.where(
                    (employee) => employee.id != null && employee.name != null,
                  )
                  .toList() ??
              [];
          checkDropDownValues();
          notifyListeners();
        }
      }
    } catch (e, s) {
      print('crmLeadListViewAPI error: $e, stack: $s');
    }
  }

  Future<void> crmLeadListSourceOnReferenceAPIFunction(
    context,
    mode,
    String? sourceID,
  ) async {
    try {
      var prov = Provider.of<HomescreenNotifier>(context, listen: false);
      final data = await ApiCalling.crmLeadListSourceOnReferenceAPI(
        prov.empId,
        prov.session,
        sourceID,
      );
      if (data != null) {
        if (data.error == "0") {
          _referencesList =
              data.references
                  ?.where((ref) => ref.id != null && ref.name != null)
                  .toList() ??
              [];
          notifyListeners();
        } else {
          _referencesList.clear();
          notifyListeners();
        }
      }
    } catch (e, s) {
      print('crmLeadListSourceOnReferenceAPI error: $e, stack: $s');
    }
  }

  Future<void> crmLeadListSegmentOnTeamAPIFunction(
    context,
    mode,
    String? teamID,
  ) async {
    try {
      var prov = Provider.of<HomescreenNotifier>(context, listen: false);
      final data = await ApiCalling.crmLeadListSegmentOnTeamAPI(
        prov.empId,
        prov.session,
        teamID,
      );
      if (data != null) {
        if (data.error == "0") {
          _segmentsList =
              data.segments
                  ?.where(
                    (segment) => segment.id != null && segment.name != null,
                  )
                  .toList() ??
              [];
          notifyListeners();
        } else {
          _segmentsList.clear();
          notifyListeners();
        }
      }
    } catch (e, s) {
      print('crmLeadListSegmentOnTeamAPI error: $e, stack: $s');
    }
  }

  Future<void> crmLeadListDistrictsOnStateAPIFunction(
    context,
    mode,
    String? stateID,
  ) async {
    try {
      var prov = Provider.of<HomescreenNotifier>(context, listen: false);
      final data = await ApiCalling.crmDistrictsOnStateAPI(
        prov.empId,
        prov.session,
        stateID,
      );
      if (data != null) {
        if (data.error == "0") {
          _districtsList =
              data.districts
                  ?.where(
                    (district) =>
                        district.id != null && district.district != null,
                  )
                  .toList() ??
              [];
          notifyListeners();
        } else {
          _districtsList.clear();
          notifyListeners();
        }
      }
    } catch (e, s) {
      print('crmLeadListDistrictsOnStateAPI error: $e, stack: $s');
    }
  }

  Future<void> crmLeadListSubLocOnDistrictAPIFunction(
    context,
    mode,
    String? districtID,
  ) async {
    try {
      var prov = Provider.of<HomescreenNotifier>(context, listen: false);
      final data = await ApiCalling.crmSubLocOnDistrictAPI(
        prov.empId,
        prov.session,
        districtID,
      );
      if (data != null) {
        if (data.error == "0") {
          _subLocationsList =
              data.subLocations
                  ?.where(
                    (subLoc) => subLoc.id != null && subLoc.subLocality != null,
                  )
                  .toList() ??
              [];
          notifyListeners();
        } else {
          _subLocationsList.clear();
          notifyListeners();
        }
      }
    } catch (e, s) {
      print('crmLeadListSubLocOnDistrictAPI error: $e, stack: $s');
    }
  }

  Future<void> crmLeadListContactPopUpAPIFunction(
    context,
    mode,
    String? accountID,
  ) async {
    try {
      var prov = Provider.of<HomescreenNotifier>(context, listen: false);
      final data = await ApiCalling.crmLeadListContactPopUpAPI(
        prov.empId,
        prov.session,
        accountID,
      );
      if (data != null) {
        if (data.error == "0") {
          _contactsList =
              data.contacts
                  ?.where(
                    (contact) => contact.id != null && contact.name != null,
                  )
                  .toList() ??
              [];
          notifyListeners();
        } else {
          _contactsList.clear();
          notifyListeners();
        }
      }
    } catch (e, s) {
      print('crmLeadListContactPopUpAPI error: $e, stack: $s');
    }
  }

  bool _isLoadingMore = false;
  bool get isLoadingMore => _isLoadingMore;

  bool _hasMoreData = true;
  bool get hasMoreData => _hasMoreData;

  int _currentPage = 1;
  String? _errorMessage;
  String? get errorMessage => _errorMessage;

  /// Reset pagination
  void resetPagination() {
    _currentPage = 1;
    _hasMoreData = true;
    _crmLeadList.clear();
    notifyListeners();
  }

  Future<void> crmLeadListAPIFunction(
    BuildContext context,
    String? mode,
    String? leadStatus,
    String? openStatus,
    String? sourceID,
    String? referenceID,
    String? teamID,
    String? segmentID,
    String? alphabet, {
    bool append = false,
  }) async {
    try {
      var HomeProv = Provider.of<HomescreenNotifier>(context, listen: false);

      if (!append) {
        _isLoading = true;
        _errorMessage = null;
        notifyListeners();
      } else {
        _isLoadingMore = true;
        notifyListeners();
      }

      final data = await ApiCalling.crmLeadListFilterSubmitAPI(
        HomeProv.empId,
        HomeProv.session,
        mode,
        leadStatus,
        openStatus,
        mobileNumberController.text,
        companyNameController.text,
        sourceID,
        referenceID,
        teamID,
        segmentID,
        alphabet,
        _currentPage.toString(), //
      );
      debugPrint(
        'empId: ${HomeProv.empId}, session: ${HomeProv.session}, pageNumber: $_currentPage',
      );

      if(data != null){
        if ( data.error == "0") {

          print("Lead List Length ${data.leadList!.length}");
          if (append) {
            _crmLeadList.addAll(data.leadList ?? []);
          } else {
            _crmLeadList = data.leadList ?? [];
          }

          if (data.leadList!.length < 15) {
            _hasMoreData = false; // no more pages
          }
        } else if(data.error=="1") {
          if (!append) _errorMessage = "No leads found!";
          _hasMoreData = false;
        }
      }else{
        _hasMoreData = false;
      }

    } catch (e) {
      _errorMessage = "Error: $e";
    }

    _isLoading = false;
    _isLoadingMore = false;
    notifyListeners();
  }

  /// Load next page
  Future<void> loadMore(
    BuildContext context,
    String? mode,
    String? leadStatus,
    String? openStatus,
    String? sourceID,
    String? referenceID,
    String? teamID,
    String? segmentID,
    String? alphabet,
  ) async {
    if (_isLoadingMore || !_hasMoreData) return;
    _currentPage++;
    await crmLeadListAPIFunction(
      context,
      mode,
      leadStatus,
      openStatus,
      sourceID,
      referenceID,
      teamID,
      segmentID,
      alphabet,
      append: true,
    );
  }

  onChangedLeadId(String? value) {
    notifyListeners();
  }

  onChangedMobileNum(String? value) {
    notifyListeners();
  }

  onChangedCompanyName(String? value) {
    notifyListeners();
  }

  void resetForm() {
    _isLoading = false;
    sLeadIDController.clear();
    mobileNumberController.clear();
    companyNameController.clear();
    companyNameController.clear();
    _selectedEmployees = null;
    _selectedSources = null;
    _selectedReferences = null;
    _selectedSegments = null;
    _selectedTeams = null;
    _selectedDistricts = null;
    _selectedStates = null;
    _selectedSubLocations = null;
    _selectedLeadStatus = null;
    _selectedOpenStatus = null;
    _selectedAlphabet = null;
    _selectedEmployeeId = null;
    _selectedSourceId = null;
    _selectedReferenceId = null;
    _selectedTeamId = null;
    _selectedSegmentId = null;
    _selectedStateId = null;
    _selectedDistrictId = null;
    _selectedSubLocationId = null;
    _selectedEmployeeValue = null;
    _selectedSourceValue = null;
    _selectedReferenceValue = null;
    _selectedTeamValue = null;
    _selectedSegmentValue = null;
    _selectedDistrictValue = null;
    _selectedStateValue = null;
    _selectedSubLocationValue = null;
    checkDropDownValues();
    notifyListeners();
  }

  void checkDropDownValues() {
    if (_selectedEmployees != null &&
        !_employeesList.contains(_selectedEmployees)) {
      _selectedEmployees = null;
      _selectedEmployeeId = null;
      _selectedEmployeeValue = null;
    }
    if (_selectedSources != null && !_sourcesList.contains(_selectedSources)) {
      _selectedSources = null;
      _selectedSourceId = null;
      _selectedSourceValue = null;
    }
    if (_selectedReferences != null &&
        !_referencesList.contains(_selectedReferences)) {
      _selectedReferences = null;
      _selectedReferenceId = null;
      _selectedReferenceValue = null;
    }
    if (_selectedSegments != null &&
        !_segmentsList.contains(_selectedSegments)) {
      _selectedSegments = null;
      _selectedSegmentId = null;
      _selectedSegmentValue = null;
    }
    if (_selectedTeams != null && !_teamsList.contains(_selectedTeams)) {
      _selectedTeams = null;
      _selectedTeamId = null;
      _selectedTeamValue = null;
    }
    if (_selectedDistricts != null &&
        !_districtsList.contains(_selectedDistricts)) {
      _selectedDistricts = null;
      _selectedDistrictId = null;
      _selectedDistrictValue = null;
    }
    if (_selectedStates != null && !_statesList.contains(_selectedStates)) {
      _selectedStates = null;
      _selectedStateId = null;
      _selectedStateValue = null;
    }
    if (_selectedSubLocations != null &&
        !_subLocationsList.contains(_selectedSubLocations)) {
      _selectedSubLocations = null;
      _selectedSubLocationId = null;
      _selectedSubLocationValue = null;
    }
    notifyListeners();
  }
}
