class crmSelectedProductDetailsResponse {
  ProductsData? productsData;
  String? error;
  String? message;

  crmSelectedProductDetailsResponse({
    this.productsData,
    this.error,
    this.message,
  });

  crmSelectedProductDetailsResponse.fromJson(Map<String, dynamic> json) {
    productsData =
        json['data'] != null ? ProductsData.fromJson(json['data']) : null;
    error = json['error'];
    message = json['message'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    if (productsData != null) {
      data['data'] = productsData!.toJson();
    }
    data['error'] = error;
    data['message'] = message;
    return data;
  }
}

class ProductsData {
  String? id;
  String? name;
  String? application;
  String? rating;
  String? ratingKw;
  String? ordStatus;
  String? description;
  String? price;
  String? createdOn;
  String? empId;
  String? materialMasterId;
  String? isGenerator;
  String? isExists;
  String? createdDatetime;
  String? updatedDatetime;
  String? remarks;

  ProductsData({
    this.id,
    this.name,
    this.application,
    this.rating,
    this.ratingKw,
    this.ordStatus,
    this.description,
    this.price,
    this.createdOn,
    this.empId,
    this.materialMasterId,
    this.isGenerator,
    this.isExists,
    this.createdDatetime,
    this.updatedDatetime,
    this.remarks,
  });

  ProductsData.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    name = json['name'];
    application = json['application'];
    rating = json['rating'];
    ratingKw = json['rating_kw'];
    ordStatus = json['ord_status'];
    description = json['description'];
    price = json['price'];
    createdOn = json['created_on'];
    empId = json['emp_id'];
    materialMasterId = json['material_master_id'];
    isGenerator = json['is_generator'];
    isExists = json['is_exists'];
    createdDatetime = json['created_datetime'];
    updatedDatetime = json['updated_datetime'];
    remarks = json['remarks'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['name'] = name;
    data['application'] = application;
    data['rating'] = rating;
    data['rating_kw'] = ratingKw;
    data['ord_status'] = ordStatus;
    data['description'] = description;
    data['price'] = price;
    data['created_on'] = createdOn;
    data['emp_id'] = empId;
    data['material_master_id'] = materialMasterId;
    data['is_generator'] = isGenerator;
    data['is_exists'] = isExists;
    data['created_datetime'] = createdDatetime;
    data['updated_datetime'] = updatedDatetime;
    data['remarks'] = remarks;
    return data;
  }
}
