import 'dart:io';

import 'package:flutter/material.dart';
import 'package:generp/Notifiers/ordersProvider/pagesDashboardProvider.dart';
import 'package:provider/provider.dart';

import '../../Utils/app_colors.dart';
import '../../Utils/commonWidgets.dart';

class Orderdetailspaymenthistory extends StatefulWidget {
  const Orderdetailspaymenthistory({super.key});

  @override
  State<Orderdetailspaymenthistory> createState() =>
      _OrderdetailspaymenthistoryState();
}

class _OrderdetailspaymenthistoryState
    extends State<Orderdetailspaymenthistory> {
  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    WidgetsBinding.instance.addPostFrameCallback((_) {
      var details = Provider.of<Pagesdashboardprovider>(context, listen: false);
    });
  }

  @override
  Widget build(BuildContext context) {
    return Consumer<Pagesdashboardprovider>(
      builder: (context, provider, child) {
        final paymentHistory = provider.paymentHistory;
        return WillPopScope(
          onWillPop: () => onBackPressed(context),
          child: SafeArea(
            top: false,
            bottom: Platform.isIOS ? false : true,
            child: Scaffold(
              resizeToAvoidBottomInset: true,
              appBar: appbar(context, "Payment History"),
              backgroundColor: AppColors.scaffold_bg_color,
              body:
                  paymentHistory.isNotEmpty
                      ? Container(
                        child: ListView.builder(
                          scrollDirection: Axis.vertical,
                          shrinkWrap: true,
                          physics: AlwaysScrollableScrollPhysics(),
                          itemCount: paymentHistory.length,
                          padding: EdgeInsets.symmetric(
                            horizontal: 10,
                            vertical: 10,
                          ),

                          itemBuilder: (context, index) {
                            return Container(
                              margin: EdgeInsets.symmetric(
                                horizontal: 10,
                                vertical: 5,
                              ),
                              padding: EdgeInsets.symmetric(
                                horizontal: 15,
                                vertical: 10,
                              ),
                              decoration: BoxDecoration(
                                color: Colors.white,
                                borderRadius: BorderRadius.circular(20),
                              ),
                              child: Column(
                                crossAxisAlignment: CrossAxisAlignment.start,
                                children: List.generate(7, (j) {
                                  final textheads = [
                                    "Mode of Payment",
                                    "Payment Reference",
                                    "Payment Amount",
                                    "Adjusted Amount",
                                    "Entered By Employee",
                                    "Payment Received Date",
                                    "Action",
                                  ];
                                  final textSubheads = [
                                    "${paymentHistory[index].paymentType}",
                                    "${paymentHistory[index].refNo}",
                                    "${paymentHistory[index].amount}",
                                    "${paymentHistory[index].adjustedAmount}",
                                    "${paymentHistory[index].enteredEmployee}",
                                    "${paymentHistory[index].paymentDate}",
                                    "${paymentHistory[index].approvalStatus}",
                                  ];
                                  return Container(
                                    padding: EdgeInsets.symmetric(
                                      vertical: 6,
                                      horizontal: 0,
                                    ),
                                    child: Row(
                                      mainAxisAlignment:
                                          MainAxisAlignment.spaceBetween,
                                      crossAxisAlignment:
                                          CrossAxisAlignment.start,
                                      children: [
                                        Expanded(
                                          child: Text(
                                            textheads[j].toString(),
                                            maxLines: 2,
                                            overflow: TextOverflow.ellipsis,
                                          ),
                                        ),
                                        Expanded(
                                          child: SizedBox(
                                            // height:45,
                                            width:
                                                MediaQuery.of(
                                                  context,
                                                ).size.width *
                                                0.75,
                                            child: Text(
                                              textSubheads[j],
                                              maxLines: 2,
                                              overflow: TextOverflow.ellipsis,
                                              style: TextStyle(
                                                color: Color(0xFF818181),
                                              ),
                                            ),
                                          ),
                                        ),
                                      ],
                                    ),
                                  );
                                }),
                              ),
                            );
                          },
                        ),
                      )
                      : Emptywidget(context),
            ),
          ),
        );
      },
    );
  }
}
