import 'dart:async';
import 'dart:io';

import 'package:connectivity_plus/connectivity_plus.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:flutter_svg/flutter_svg.dart';
import 'package:generp/Utils/app_colors.dart' show AppColors;
import 'package:generp/Utils/commonServices.dart';
import 'package:generp/Utils/commonWidgets.dart';
import 'package:generp/screens/screensExports.dart';
import 'package:generp/screens/notifierExports.dart';
import 'package:geolocator/geolocator.dart';
import 'package:provider/provider.dart';
import 'package:cached_network_image/cached_network_image.dart';
import 'package:location/location.dart' as loc;
import 'package:auto_size_text/auto_size_text.dart';

class MyHomePageOld extends StatefulWidget {
  const MyHomePageOld({super.key});

  @override
  State<MyHomePageOld> createState() => _MyHomePageOldState();
}

class _MyHomePageOldState extends State<MyHomePageOld> {
  Timer? timer;
  Map _source = {ConnectivityResult.mobile: true};
  final MyConnectivity _connectivity = MyConnectivity.instance;

  @override
  void initState() {
    // TODO: implement initState
    _connectivity.initialise();
    _connectivity.myStream.listen((source) {
      setState(() => _source = source);
    });
    var prov = Provider.of<HomescreenNotifier>(context, listen: false);
    var profProv = Provider.of<ProfileNotifer>(context, listen: false);
    Future.microtask(() {
      prov.DashboardApiFunction(context);
    });
    Future.delayed(Duration(milliseconds: 600), () {
      profProv.ProfileApiFunction(prov, context);
      profProv.VersionApiFunction();
    });
    super.initState();
  }

  Future<bool> onBackPressed() async {
    return await showDialog<bool>(
          context: context,
          builder:
              (context) => AlertDialog(
                title: const Text('Are you sure?'),
                content: const Text('Do you want to exit the App'),
                actions: [
                  TextButton(
                    style: ButtonStyle(
                      backgroundColor: WidgetStateProperty.all(Colors.white),
                      overlayColor: WidgetStateProperty.all(Colors.white),
                    ),
                    onPressed: () => Navigator.of(context).pop(false),
                    child: Text(
                      "NO",
                      style: TextStyle(fontWeight: FontWeight.w500),
                    ),
                  ),
                  const SizedBox(height: 16),
                  TextButton(
                    style: ButtonStyle(
                      backgroundColor: WidgetStateProperty.all(Colors.white),
                      overlayColor: WidgetStateProperty.all(Colors.white70),
                    ),
                    onPressed:
                        () => SystemChannels.platform.invokeMethod(
                          'SystemNavigator.pop',
                        ),
                    child: Text(
                      "YES",
                      style: TextStyle(fontWeight: FontWeight.w500),
                    ),
                  ),
                ],
                elevation: 30.0,
              ),
          barrierDismissible: false,
        ) ??
        false;
  }

  Future<void> requestGpsPermission() async {
    bool isLocationEnabled = false;
    bool hasLocationPermission = false;
    isLocationEnabled = await Geolocator.isLocationServiceEnabled();

    // Check if the app has been granted location permission
    LocationPermission permission = await Geolocator.checkPermission();
    hasLocationPermission =
        permission == LocationPermission.always ||
        permission == LocationPermission.whileInUse;

    final loc.Location location = loc.Location();
    bool serviceEnabled;
    serviceEnabled = await location.serviceEnabled();
    if (!serviceEnabled) {
      serviceEnabled = await location.requestService();
      if (!serviceEnabled) {
        return;
      }
    }
  }

  @override
  void dispose() {
    // TODO: implement dispose
    super.dispose();
    _connectivity.disposeStream();
  }

  @override
  Widget build(BuildContext context) {
    switch (_source.keys.toList()[0]) {
      case ConnectivityResult.mobile:
        connection = 'Online';
        break;
      case ConnectivityResult.wifi:
        connection = 'Online';
        break;
      case ConnectivityResult.none:
      default:
        connection = 'Offline';
    }
    return (connection == 'Online')
        ? Consumer2<HomescreenNotifier, ProfileNotifer>(
          builder: (context, homescreen, profile, child) {
            // Define the original data
            final names = [
              "Attendance",
              "Finance",
              "CRM",
              "Orders",
              "ERP",
              "Service Engineer",
              "Gen Tracker",
              // "Nearby",
              "Inventory",
              "Whizzdom",
              // "Common",
            ];
            final icons = [
              "assets/svg/home_icons_1.svg",
              "assets/svg/home_icons_10.svg",
              "assets/svg/home_icons_12.svg",
              "assets/svg/home_icons_11.svg",
              "assets/svg/home_icons_2.svg",
              "assets/svg/home_icons_4.svg",
              "assets/svg/home_icons_31.svg",
              // "assets/svg/home_icons_5.svg",
              "assets/svg/home_icons_6.svg",
              "assets/svg/home_icons_81.svg",
              // "assets/svg/home_icons_9.svg",
            ];
            final requiredRoles = [
              "430",
              "430",
              "430",
              "430",
              "431",
              "433",
              "434",
              // "433",
              "432",
              "431",
              // "430",
            ];

            final filteredItems = <Map<String, String>>[];
            for (int i = 0; i < names.length; i++) {
              if (homescreen.roleStatus.contains(requiredRoles[i])) {
                filteredItems.add({'name': names[i], 'icon': icons[i]});
              }
            }
            return WillPopScope(
              onWillPop: onBackPressed,
              child: RefreshIndicator.adaptive(
                color: AppColors.app_blue,

                onRefresh: () async {
                  await Future.delayed(const Duration(milliseconds: 600));
                  homescreen.DashboardApiFunction(context);
                },
                child: SafeArea(
                  top: false,
                  bottom: Platform.isIOS ? false : true,
                  child: Scaffold(
                    resizeToAvoidBottomInset: true,
                    backgroundColor: AppColors.scaffold_bg_color,

                    body: Container(
                      child: Column(
                        children: [
                          Expanded(
                            flex: 4,
                            child: Container(
                              padding: EdgeInsets.symmetric(vertical: 10),
                              decoration: BoxDecoration(
                                color: Colors.white,
                                borderRadius: BorderRadius.vertical(
                                  bottom: Radius.circular(30),
                                ),
                              ),
                              child: Container(
                                margin: EdgeInsets.only(
                                  bottom: 15,
                                  left: 15,
                                  right: 15,
                                  top: 30,
                                ),
                                padding: EdgeInsets.only(bottom: 15, right: 10),
                                decoration: BoxDecoration(
                                  borderRadius: BorderRadius.circular(30),
                                  gradient: LinearGradient(
                                    colors: [
                                      AppColors.profile_card_gradient1,
                                      AppColors.profile_card_gradient2,
                                    ],
                                  ),
                                ),
                                child: Row(
                                  crossAxisAlignment: CrossAxisAlignment.center,
                                  children: [
                                    Expanded(
                                      flex: 2,
                                      child: SizedBox(
                                        child: Column(
                                          mainAxisAlignment:
                                              MainAxisAlignment.center,

                                          children: [
                                            SizedBox(
                                              width: 66,
                                              height: 66,
                                              child: ClipRRect(
                                                borderRadius:
                                                    BorderRadius.circular(50),
                                                child: CachedNetworkImage(
                                                  cacheKey:
                                                      profile.profileImage,
                                                  fit: BoxFit.cover,
                                                  imageUrl:
                                                      "${profile.profileImage}",
                                                  useOldImageOnUrlChange: false,
                                                  placeholder:
                                                      (context, url) =>
                                                          CircularProgressIndicator.adaptive(),
                                                  errorWidget:
                                                      (context, url, error) =>
                                                          Icon(Icons.error),
                                                ),
                                              ),
                                            ),

                                            Row(
                                              mainAxisAlignment:
                                                  MainAxisAlignment.center,
                                              children: [
                                                Container(
                                                  width: 13,
                                                  height: 13,
                                                  decoration: BoxDecoration(
                                                    shape: BoxShape.circle,
                                                    color:
                                                        homescreen.onlineStatus ==
                                                                "Online"
                                                            ? Colors.green
                                                            : Colors.yellow,
                                                  ),
                                                ),
                                                SizedBox(width: 6),
                                                Text(
                                                  "${homescreen.onlineStatus}",
                                                  style: TextStyle(
                                                    fontSize: 16,
                                                    fontFamily: "JakartaMedium",
                                                    color: Color(0xFF2D2D2D),
                                                  ),
                                                ),
                                              ],
                                            ),
                                          ],
                                        ),
                                      ),
                                    ),
                                    Expanded(
                                      flex: 3,
                                      child: Container(
                                        padding: EdgeInsets.only(right: 10),
                                        child: Column(
                                          crossAxisAlignment:
                                              CrossAxisAlignment.start,
                                          mainAxisAlignment:
                                              MainAxisAlignment.center,
                                          children: [
                                            // Text(
                                            //   "${profile.employeeName}",
                                            //   maxLines: 1,
                                            //   style: TextStyle(
                                            //     color: AppColors.app_blue,
                                            //     fontFamily: "JakartaSemiBold",
                                            //     fontSize: 18,
                                            //   ),
                                            // ),
                                            AutoSizeText(
                                              '${profile.employeeName}',
                                              maxFontSize: 18,
                                              minFontSize: 12,
                                              style: TextStyle(
                                                fontSize: 18,
                                                color: AppColors.app_blue,
                                                fontFamily: "JakartaRegular",
                                              ),
                                              maxLines: 2,
                                            ),
                                            AutoSizeText(
                                              '(${profile.designation})',
                                              maxFontSize: 14,
                                              minFontSize: 10,
                                              style: TextStyle(
                                                fontSize: 14,
                                                color: AppColors.semi_black,
                                                fontFamily: "JakartaRegular",
                                              ),
                                              maxLines: 1,
                                            ),
                                            // Text(
                                            //   "${profile.designation}",
                                            //   maxLines: 1,
                                            //   style: TextStyle(
                                            //     color: AppColors.semi_black,
                                            //     fontFamily: "JakartaRegular",
                                            //     fontSize: 14,
                                            //   ),
                                            // ),
                                            Text(
                                              "${profile.employeeeID}",
                                              style: TextStyle(
                                                color: AppColors.semi_black,
                                                fontFamily: "JakartaRegular",
                                                fontSize: 14,
                                              ),
                                            ),
                                            InkResponse(
                                              onTap: () {
                                                _showProfileBottomSheet(
                                                  context,
                                                );
                                              },
                                              child: Row(
                                                mainAxisAlignment:
                                                    MainAxisAlignment.start,
                                                crossAxisAlignment:
                                                    CrossAxisAlignment.center,
                                                children: [
                                                  Text(
                                                    "View Profile",
                                                    style: TextStyle(
                                                      color: AppColors.app_blue,
                                                      fontFamily:
                                                          "JakartaRegular",
                                                      fontSize: 14,
                                                    ),
                                                  ),
                                                  SizedBox(width: 5),
                                                  SizedBox(
                                                    width: 15,
                                                    height: 15,
                                                    child: Center(
                                                      child: SvgPicture.asset(
                                                        "assets/svg/next_button.svg",
                                                      ),
                                                    ),
                                                  ),
                                                ],
                                              ),
                                            ),
                                          ],
                                        ),
                                      ),
                                    ),
                                  ],
                                ),
                              ),
                            ),
                          ),
                          Expanded(
                            flex: 10,
                            child: Container(
                              padding: EdgeInsets.only(
                                left: 20,
                                right: 20,
                                top: 0,
                                bottom: 10,
                              ),
                              margin: EdgeInsets.only(top: 10),
                              child: GridView.builder(
                                itemCount: filteredItems.length,
                                gridDelegate:
                                    SliverGridDelegateWithFixedCrossAxisCount(
                                      crossAxisCount: 2,
                                      crossAxisSpacing: 10,
                                      mainAxisSpacing: 10,
                                    ),
                                itemBuilder: (context, index) {
                                  final item = filteredItems[index];
                                  return InkResponse(
                                    onTap: () async {
                                      var res;
                                      switch (item['name']) {
                                        case "Attendance":
                                          res = await Navigator.push(
                                            context,
                                            MaterialPageRoute(
                                              builder:
                                                  (context) =>
                                                      AttendanceScreen(),
                                              settings: RouteSettings(
                                                arguments: 'AttendanceScreen',
                                              ),
                                            ),
                                          );
                                          break;
                                        case "ERP":
                                          bool isGpsEnabled =
                                              await Geolocator.isLocationServiceEnabled();
                                          if (isGpsEnabled) {
                                            if (Platform.isAndroid) {
                                              res = await Navigator.push(
                                                context,
                                                MaterialPageRoute(
                                                  builder:
                                                      (context) => WebErpScreen(
                                                        erp_url:
                                                            homescreen
                                                                .webPageUrl,
                                                      ),
                                                ),
                                              );
                                            } else {
                                              res = await Navigator.push(
                                                context,
                                                MaterialPageRoute(
                                                  builder:
                                                      (context) => WebERPIOS(
                                                        url:
                                                            homescreen
                                                                .webPageUrl,
                                                      ),
                                                ),
                                              );
                                            }
                                          } else {
                                            requestGpsPermission();
                                          }

                                          break;
                                        case "Gen Tracker":
                                          res = await Navigator.push(
                                            context,
                                            MaterialPageRoute(
                                              builder:
                                                  (context) =>
                                                      Gentrackerdashboard(),
                                              settings: RouteSettings(
                                                arguments:
                                                    'Gentrackerdashboard',
                                              ),
                                            ),
                                          );
                                          break;
                                        case "Service Engineer":
                                          res = await Navigator.push(
                                            context,
                                            MaterialPageRoute(
                                              builder:
                                                  (context) =>
                                                      Serviceengineerdashboard(),
                                            ),
                                          );
                                          break;
                                        case "Nearby":
                                          res = await Navigator.push(
                                            context,
                                            MaterialPageRoute(
                                              builder:
                                                  (context) =>
                                                      Nearbygenerators(),
                                            ),
                                          );

                                          break;
                                        case "Inventory":
                                          res = await Navigator.push(
                                            context,
                                            MaterialPageRoute(
                                              builder:
                                                  (context) =>
                                                      InventoryScreen(),
                                            ),
                                          );
                                          break;
                                        case "Whizzdom":
                                          bool isGpsEnabled =
                                              await Geolocator.isLocationServiceEnabled();
                                          if (isGpsEnabled) {
                                            res = await Navigator.push(
                                              context,
                                              MaterialPageRoute(
                                                builder:
                                                    (
                                                      context,
                                                    ) => WebWhizzdomScreen(
                                                      whizzdom_url:
                                                          homescreen
                                                              .whizzdomPageUrl,
                                                    ),
                                              ),
                                            );
                                          } else {
                                            requestGpsPermission();
                                          }
                                          break;
                                        case "Common":
                                          res = await Navigator.push(
                                            context,
                                            MaterialPageRoute(
                                              builder:
                                                  (context) =>
                                                      Commondashboard(),
                                            ),
                                          );
                                          break;
                                        case "Finance":
                                          res = await Navigator.push(
                                            context,
                                            MaterialPageRoute(
                                              builder:
                                                  (context) =>
                                                      Financedashboard(),
                                              settings: RouteSettings(
                                                arguments: 'Financedashboard',
                                              ),
                                            ),
                                          );
                                          break;
                                        case "Orders":
                                          res = await Navigator.push(
                                            context,
                                            MaterialPageRoute(
                                              builder:
                                                  (context) =>
                                                      Ordermoduledashboard(),
                                            ),
                                          );
                                        case "CRM":
                                          res = await Navigator.push(
                                            context,
                                            MaterialPageRoute(
                                              builder:
                                                  (context) =>
                                                      CrmdashboardScreen(),
                                              settings: RouteSettings(
                                                name: 'CrmdashboardScreen',
                                              ),
                                            ),
                                          );
                                        default:
                                          print("111");
                                          break;
                                      }
                                      if (res == true) {
                                        homescreen.DashboardApiFunction(
                                          context,
                                        );
                                      }
                                    },
                                    child: Container(
                                      decoration: BoxDecoration(
                                        color: Colors.white,
                                        borderRadius: BorderRadius.circular(30),
                                      ),
                                      child: Column(
                                        crossAxisAlignment:
                                            CrossAxisAlignment.center,
                                        mainAxisAlignment:
                                            MainAxisAlignment.center,
                                        children: [
                                          SvgPicture.asset(
                                            item['icon']!,
                                            height: 45,
                                          ),
                                          SizedBox(height: 10),
                                          Text(item['name']!),
                                        ],
                                      ),
                                    ),
                                  );
                                },
                              ),
                            ),
                          ),
                        ],
                      ),
                    ),
                  ),
                ),
              ),
            );
          },
        )
        : NoNetwork(context);
  }

  Future<void> _showProfileBottomSheet(BuildContext context) {
    return showModalBottomSheet(
      useSafeArea: true,
      isDismissible: true,
      isScrollControlled: true,
      showDragHandle: true,

      enableDrag: true,
      context: context,
      builder: (context) {
        return StatefulBuilder(
          builder: (context, setState) {
            return SafeArea(
              child: Container(
                margin: EdgeInsets.only(
                  bottom: 15,
                  left: 15,
                  right: 15,
                  top: 30,
                ),
                padding: EdgeInsets.only(
                  bottom: MediaQuery.of(context).viewInsets.bottom,
                ),
                child: Consumer3<
                  HomescreenNotifier,
                  ProfileNotifer,
                  LogoutNotifier
                >(
                  builder: (context, home, profile, logout, child) {
                    return SingleChildScrollView(
                      child: Column(
                        mainAxisSize: MainAxisSize.min,
                        children: [
                          Padding(
                            padding: const EdgeInsets.symmetric(
                              horizontal: 5.0,
                            ),
                            child: Row(
                              children: [
                                SizedBox(
                                  height: 35,
                                  child: Image.asset(
                                    "assets/images/gen_horiz_logo.png",
                                  ),
                                ),
                                Spacer(),
                                InkResponse(
                                  onTap: () {
                                    Navigator.push(
                                      context,
                                      MaterialPageRoute(
                                        builder: (context) => Scannerlogin(),
                                      ),
                                    );
                                  },
                                  child: SizedBox(
                                    height: 25,
                                    width: 25,
                                    child: SvgPicture.asset(
                                      "assets/svg/scanner.svg",
                                    ),
                                  ),
                                ),
                              ],
                            ),
                          ),
                          SizedBox(height: 15),
                          Container(
                            padding: EdgeInsets.symmetric(
                              horizontal: 5,
                              vertical: 10,
                            ),
                            decoration: BoxDecoration(
                              borderRadius: BorderRadius.circular(30),
                              gradient: LinearGradient(
                                colors: [
                                  AppColors.profile_card_gradient1,
                                  AppColors.profile_card_gradient2,
                                ],
                              ),
                            ),
                            child: Column(
                              crossAxisAlignment: CrossAxisAlignment.center,
                              children: [
                                Padding(
                                  padding: EdgeInsets.all(10),
                                  child: SizedBox(
                                    width: 70,
                                    height: 70,
                                    child: ClipRRect(
                                      borderRadius: BorderRadius.circular(50),
                                      child: CachedNetworkImage(
                                        cacheKey: profile.profileImage,
                                        fit: BoxFit.cover,
                                        imageUrl: "${profile.profileImage}",
                                        useOldImageOnUrlChange: false,
                                        placeholder:
                                            (context, url) =>
                                                CircularProgressIndicator.adaptive(),
                                        errorWidget:
                                            (context, url, error) =>
                                                Icon(Icons.error),
                                      ),
                                    ),
                                  ),
                                ),
                                Text(
                                  "${profile.employeeName}",
                                  textAlign: TextAlign.center,
                                  style: TextStyle(
                                    color: AppColors.app_blue,
                                    fontFamily: "JakartaSemiBold",
                                    fontSize: 18,
                                  ),
                                ),
                                Text(
                                  "${profile.employeeEmail}",
                                  textAlign: TextAlign.center,
                                  style: TextStyle(
                                    color: AppColors.semi_black,
                                    fontSize: 14,
                                  ),
                                ),
                                Container(
                                  padding: EdgeInsets.symmetric(horizontal: 20),
                                  alignment: Alignment.center,
                                  child: Row(
                                    mainAxisAlignment: MainAxisAlignment.center,
                                    crossAxisAlignment:
                                        CrossAxisAlignment.center,
                                    children: [
                                      Expanded(
                                        flex: 1,
                                        child: ListView.builder(
                                          shrinkWrap: true,
                                          itemCount: 5,
                                          physics:
                                              NeverScrollableScrollPhysics(),
                                          itemBuilder: (context, index) {
                                            final textHeadings = [
                                              "Company",
                                              "Branch",
                                              "Designation",
                                              "Employee ID",
                                              "Mobile Number",
                                            ];
                                            return SizedBox(
                                              height: 40,
                                              child: Align(
                                                alignment: Alignment.centerLeft,
                                                child: Text(
                                                  textHeadings[index],

                                                  textAlign: TextAlign.left,
                                                  style: TextStyle(
                                                    fontSize: 14,
                                                    fontFamily: "JakartaMedium",
                                                    color: AppColors.app_blue,
                                                  ),
                                                ),
                                              ),
                                            );
                                          },
                                        ),
                                      ),
                                      Expanded(
                                        flex: 1,
                                        child: ListView.builder(
                                          shrinkWrap: true,
                                          itemCount: 5,
                                          physics:
                                              NeverScrollableScrollPhysics(),
                                          itemBuilder: (context, index) {
                                            final textHeadings = [
                                              profile.company,
                                              profile.branch,
                                              profile.designation,
                                              profile.employeeeID,
                                              profile.mobileNUmber,
                                            ];
                                            return SizedBox(
                                              height: 40,
                                              child: Align(
                                                alignment: Alignment.centerLeft,
                                                child: Text(
                                                  textHeadings[index]
                                                      .toString(),
                                                  textAlign: TextAlign.left,
                                                  style: TextStyle(
                                                    fontSize: 14,
                                                    color: AppColors.semi_black,
                                                  ),
                                                ),
                                              ),
                                            );
                                          },
                                        ),
                                      ),
                                    ],
                                  ),
                                ),
                              ],
                            ),
                          ),
                          SizedBox(height: 10),
                          InkWell(
                            onTap: () {
                              // LoginApiFunction();

                              var f = FocusScope.of(context);

                              if (!f.hasPrimaryFocus) {
                                f.unfocus();
                              }
                              _showLogoutBottomSheet(context);
                              //  Navigator.push(context,MaterialPageRoute(builder: (context)=>Profile()));
                            },
                            child: Container(
                              alignment: Alignment.center,
                              height: 45,
                              margin: EdgeInsets.only(
                                left: 5.0,
                                right: 5.0,
                                top: 5.0,
                                bottom: 5.0,
                              ),
                              decoration: BoxDecoration(
                                color: AppColors.app_blue, //1487C9
                                borderRadius: BorderRadius.circular(15.0),
                              ),
                              child: Center(
                                child: Text(
                                  "Logout",
                                  textAlign: TextAlign.center,
                                  style: TextStyle(color: Colors.white),
                                ),
                              ),
                            ),
                          ),

                          Text(
                            profile.releaseNotes,
                            style: TextStyle(
                              fontSize: 14,
                              color: AppColors.grey_thick,
                            ),
                          ),
                        ],
                      ),
                    );
                  },
                ),
              ),
            );
          },
        );
      },
    );
  }

  Future<void> _showLogoutBottomSheet(BuildContext context) {
    return showModalBottomSheet(
      useSafeArea: true,
      isDismissible: true,
      isScrollControlled: true,
      showDragHandle: true,

      enableDrag: true,
      context: context,
      builder: (context) {
        return StatefulBuilder(
          builder: (context, setState) {
            return SafeArea(
              child: Container(
                margin: EdgeInsets.only(
                  bottom: 15,
                  left: 15,
                  right: 15,
                  top: 30,
                ),
                padding: EdgeInsets.only(
                  bottom: MediaQuery.of(context).viewInsets.bottom,
                ),
                child: Consumer3<
                  HomescreenNotifier,
                  ProfileNotifer,
                  LogoutNotifier
                >(
                  builder: (context, home, profile, logout, child) {
                    return SingleChildScrollView(
                      child: Column(
                        mainAxisSize: MainAxisSize.min,
                        children: [
                          Column(
                            crossAxisAlignment: CrossAxisAlignment.center,
                            children: [
                              Text(
                                "Are you sure you want \nto logout ?",
                                textAlign: TextAlign.center,
                                style: TextStyle(
                                  fontFamily: "JakartaMedium",
                                  color: AppColors.semi_black,
                                  fontSize: 18,
                                ),
                              ),
                            ],
                          ),
                          SizedBox(height: 20),
                          InkWell(
                            onTap: () {
                              // LoginApiFunction();

                              var f = FocusScope.of(context);

                              if (!f.hasPrimaryFocus) {
                                f.unfocus();
                              }
                              logout.LogoutApiFunction(home, context);
                              //  Navigator.push(context,MaterialPageRoute(builder: (context)=>Profile()));
                            },
                            child: Container(
                              alignment: Alignment.center,
                              height: 45,
                              margin: EdgeInsets.only(
                                left: 5.0,
                                right: 5.0,
                                top: 5.0,
                                bottom: 5.0,
                              ),
                              decoration: BoxDecoration(
                                color: AppColors.app_blue, //1487C9
                                borderRadius: BorderRadius.circular(15.0),
                              ),
                              child: Center(
                                child: Text(
                                  "Yes, Logout",
                                  textAlign: TextAlign.center,
                                  style: TextStyle(
                                    color: Colors.white,
                                    fontFamily: "JakartaMedium",
                                  ),
                                ),
                              ),
                            ),
                          ),

                          InkWell(
                            onTap: () {
                              // LoginApiFunction();

                              var f = FocusScope.of(context);

                              if (!f.hasPrimaryFocus) {
                                f.unfocus();
                              }
                              Navigator.pop(context);
                            },
                            child: Container(
                              alignment: Alignment.center,
                              height: 45,
                              margin: EdgeInsets.only(
                                left: 5.0,
                                right: 5.0,
                                top: 5.0,
                                bottom: 5.0,
                              ),

                              child: Center(
                                child: Text(
                                  "Cancel",
                                  textAlign: TextAlign.center,
                                  style: TextStyle(
                                    color: AppColors.app_blue,
                                    fontFamily: "JakartaMedium",
                                  ),
                                ),
                              ),
                            ),
                          ),
                        ],
                      ),
                    );
                  },
                ),
              ),
            );
          },
        );
      },
    );
  }
}
